unit WaverForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, MPlayer, Buttons, ComCtrls, Menus;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Label16: TLabel;
    Panel1: TPanel;
    Memo2: TMemo;
    Button3: TButton;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    Button4: TButton;
    Label38: TLabel;
    BitBtn1: TBitBtn;
    MediaPlayer1: TMediaPlayer;
    CheckBox2: TCheckBox;
    Bevel2: TBevel;
    Button5: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Label37: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    CheckBox3: TCheckBox;
    Label41: TLabel;
    Label42: TLabel;
    Button2: TButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Label33: TLabel;
    Label32: TLabel;
    Label13: TLabel;
    Label12: TLabel;
    Label31: TLabel;
    Label30: TLabel;
    Label29: TLabel;
    Label28: TLabel;
    Label27: TLabel;
    Label26: TLabel;
    Label25: TLabel;
    Label24: TLabel;
    Label23: TLabel;
    Label22: TLabel;
    Label21: TLabel;
    Label11: TLabel;
    Label10: TLabel;
    Label9: TLabel;
    Label8: TLabel;
    Label7: TLabel;
    Label6: TLabel;
    Label5: TLabel;
    Label4: TLabel;
    Label3: TLabel;
    Label2: TLabel;
    Label1: TLabel;
    Label15: TLabel;
    Label14: TLabel;
    Label43: TLabel;
    Label44: TLabel;
    Label45: TLabel;
    Label46: TLabel;
    Label47: TLabel;
    Label48: TLabel;
    Label49: TLabel;
    Label50: TLabel;
    Label51: TLabel;
    Label52: TLabel;
    Label53: TLabel;
    CheckBox4: TCheckBox;
    Label54: TLabel;
    Button6: TButton;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Close1: TMenuItem;
    CheckBox5: TCheckBox;
    Label55: TLabel;
    Label56: TLabel;
    CheckBox6: TCheckBox;
    CheckBox60: TCheckBox;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    procedure Button9Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Edit2KeyPress(Sender: TObject; var Key: Char);
    procedure CheckBox3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
 uses waverUnit1;
var check6 : boolean;
procedure TForm1.FormCreate(Sender: TObject);
begin
 with screen do if (Width<>1680) or (height<>1050) then
  showMessage('The interface of the program was prepared for the 1680x1050 screen resolution!'#13#10+
  'Your screen parameters are: '+intToStr(width)+'x'+intToStr(height)+'.'#13#10'Try to change your graphic card parameters to these values');
 phonShowLabelsVisible(false);
 button3.Caption:='Phonemic transcr. of all'#13#10' sentences of a chosen person';
 bitBtn1.Hint:='Po wybraniu najpierw polecenie "Poka wypowied" a potem ewentualnie jeszcze raz posuchaj'#13#10+
  'Odwrotna sekwencja polece wywoa bd I/O 32'#13#10'Mona jednak zmieni wybrane pozycje i kontynuowa prac';
 button1.Hint:='Dziaa tylko w trakcie wykonywania polecenia '#13#10'"Pocz pliki"';
 button2.Hint:='Czyta pliki z CSL (Computer Speech Lab, Kay) i zapisuje je w formacie WAV';
 button3.enabled:=false;
 button3.Hint:=button4.Hint+#13#10'Program dodaje numeracj wypowiedzi dla uatwienia czytania';
 button4.enabled:=false;
 button4.Hint:='Uwaga! Program musi by kompilowany z dyrektyw {$A1},'#13#10'aby rekord czytajcy opis fonematyczny'#13#10'nie rozszerza si sztucznie do wielokrotnoci 2 bajtw!';
 button5.Hint:='Natychmiastowe zatrzymanie programu bez zamykania otwartych plikw';
 button7.enabled:=false;
 button7.Hint:='Poprzed operacj czenia sprawdzeniem,'#13#10+
  'czy istniej wszystkie pliki *.wav z danej listy (CorporaIndex.txt)'#13#10+
  'oraz pliki *.fon ich opisw transkrypcji fonematycznej';
 button8.Enabled:=false;
 button9.Enabled:=false;
 checkBox2.Hint:='W poleceniu "Pocz pliki" naley wyczy komunikaty, aby nie wstrzymywa pracy w oczekiwaniu'+
  ' na reakcj uytkownika.'#13#10'Tre komunikatw zawsze jest przekazywana do pliku "Report.txt",'#13#10+
  'skd mona je odczyta po zakoczeniu pracy.';
 checkBox3.Hint:='Pokazuje jedn wypowied'#13#10' wybran za pomoc numerw';
 checkbox3.Enabled:=false;
 checkBox4.Hint:='Wczony - po kadym oscylogramie odtworzy dwik';
 checkBox6.Hint:='Wywietlanie listy wartoci'#13#10'bardzo spowalnia proces graficzny';
 edit1.Enabled :=checkBox3.Checked;
 edit1.Hint:='Wartoci z zakresu 1 do 45';
 edit2.Enabled :=checkBox3.Checked;
 edit2.Hint:='Wartoci z zakresu 1 do 365';
 label16.Caption:='';
 label38.Left:=panel1.Left+panel1.Width-8*length(form1.label38.caption)-16;
 label55.Caption:='';
 dirStr:=extractFileDir(waveFileDir0);
 if not DirectoryExists(dirStr) then
   with openDialog1 do
     begin
      Title:='Point to any Corpora''s file (Wska jakikolwiek plik w katalogu Corpory)';
      initialDir:=dirStr;  fileName:='';
      if execute then dirStr:=copy(extractFileDir(fileName),1,lastDelimiter('\',extractFileDir(fileName)));
     end;
end;{TForm1.FormCreate}

procedure safeClosing;
 Begin
  if application.MessageBox('Break the program? - all obtained results will be writen down.'#13#10'Press the "Halt" button to finish if joined was done.'#13#10,'',MB_YESNO)=idNo then
  exit;
  BreakProgramm:=true;
 End;{safeClosing}

procedure TForm1.Button1Click(Sender: TObject);   //break copying of files and close all files
begin
 safeClosing;
end;

procedure TForm1.Button2Click(Sender: TObject);   //Poka wypowied

var RIFF:string; var fileLength:longWord;var Wave,fmt:string;
  var lengthOfFmtData:word;var PCM,MonoSter:byte;var SampleRate,blockAlign:word;var BACBS,bits_sample:byte;
  var data:string; var dataBlockLength:longWord;
 type Ts4arr=array[1..4] of char;
      Tb4Arr=array[1..4] of byte;
    TlevelAB=record a,b:smallInt end;
 var i:smallint;  waveCounter:longWord;
 j:word;
 l:longWord;
 li:longInt;
 s4:string[4];
 s4arr:Ts4arr;
 b4Arr:Tb4Arr;
 s20:string[20];
 samplingRate:longWord;
 signalLength:longWord;
 levelAB:TlevelAB;
 b2Arr:array[1..2] of byte;
 var s:shortString;
begin  //-------------------------------------------Button2Click------------------------------
 checkBox6.enabled:=false;
 form1.PageControl1.TabIndex:=0;  bitBtn1.Enabled:=false;
 s:='C:\apl\CSLdata\morze.nsp';
 checkBox3.Checked:=false;
 openDialog(opendialog1,s,'Point to data from the CSL spectrograph (*.nsp)');
 assignFile(waveFile,s);   label38.Caption:=s;
 reset(waveFile);
 for i:=1 to 4 do read(waveFile,b4Arr[i]);      //1. FORM
 s4Arr:=Ts4Arr(b4Arr); if s4Arr<>'FORM' then showMessage('brak tytuu FORM');                 form1.label43.Caption:='FORM                 '+s4Arr;
 for i:=1 to 4 do read(waveFile,b4Arr[i]);      //2. DS16
 s4Arr:=Ts4Arr(b4Arr); if s4Arr<>'DS16' then showMessage('To nie jest sygna(format<>DS16)'); form1.label44.Caption:='DS16                 '+s4Arr;
 for i:=1 to 4 do read(waveFile,b4Arr[i]);      //3. dugo bloku
 l:=longWord(b4Arr);                                                                          form1.label45.Caption:='Block length         '+intToStr(l);
 for i:=1 to 4 do read(waveFile,b4Arr[i]);      //4. tytu bloku HEDR
 s4Arr:=Ts4Arr(b4Arr);                                                                        form1.label46.Caption:='HEDR                 '+s4Arr;
  for i:=1 to 4 do read(waveFile,b4Arr[i]);     //5. dugo bloku =32
 l:=longWord(b4Arr);                                                                          form1.label47.Caption:='Block length (32)    '+intToStr(l);
 for i:=1 to 20 do read(waveFile,byte(s20[i])); //6. creation data (20 bajtw)
  s20[0]:=#20;                                                                                form1.label48.Caption:='Creation data        '+s20;
 for i:=1 to 4 do read(waveFile,b4Arr[i]);      //7. sampling rate
 samplingRate:=longWord(b4Arr);                                                               form1.label49.Caption:='Sampling rate        '+intToStr(samplingRate);
 for i:=1 to 4 do read(waveFile,b4Arr[i]);       //8. signalLength
 signalLength:=longWord(b4Arr);                                                               form1.label50.Caption:='Signal length        '+intToStr(signalLength);
 for i:=1 to 4 do read(waveFile,b4Arr[i]);      //9. levelAB maksymalna liczba 2 bajtowych punktw zapamitana w kanale A i B; 27126, -1, jeli kana nie by rejestrowany
 levelAB:=TlevelAB(b4Arr);                                                                    form1.label51.Caption:='LevelAB              '+intTostr(levelAB.a)+', '+intTostr(levelAB.b);
 for i:=1 to 4 do read(waveFile,b4Arr[i]);      //10.tytu bloku SDA_
 s4Arr:=Ts4Arr(b4Arr);                                                                        form1.label52.Caption:='Block title (SDA)    '+s4Arr;
 for i:=1 to 4 do read(waveFile,b4Arr[i]);      //11.dugo bloku (w bajtach!)
 l:=longWord(b4Arr);                                                                          form1.label53.Caption:='Block length (byte)  '+intToStr(l);
 li:=0;
 outWaveFileDir := copy(s,1,pos('.',s))+'wav';
 saveDialog(saveDialog1,outWaveFileDir,'Zapisa jako:');
 speakerDir:=outWaveFileDir;      //wskazanie pliku dla gonika
 assignFile(outWaveFile,outWaveFileDir);
 rewrite(outWaveFile);
 ErrReportFileDir:=extractFileDir(outWaveFileDir)+'\Report.txt';
 assignFile(ErrReportFile,ErrReportFileDir);
 rewrite(ErrReportFile);
 waveHeadWrite('RIFF',l+36,'WAVE','fmt ',16,1,1,samplingRate,32000,2,16,'data',l-1);
 while not eof(waveFile) do
  begin
   inc(li);
   for i:=1 to 2 do
    begin
     read(waveFile,b2Arr[i]);
     Write(outWaveFile,b2Arr[i])
    end;
   i:=smallint(b2Arr);
   writeln(ErrReportFile,intToStr(li),'. ',intToStr(i));
  end;
  if li<>l div 2 then showmessage('deklarowana dugo bloku='+intToStr(l div 2)+' rni si od istniejcej liczby danych='+intToStr(li));
 closeFile(waveFile);
 closeFile(outWaveFile);
 closeFile(ErrReportFile);
 showWaveHead(canvas,outWaveFile,outWaveFileDir,RIFF,fileLength,Wave,fmt,lengthOfFmtData,PCM,MonoSter,SampleRate,blockAlign,BACBS,
  bits_sample,data,dataBlockLength,false);
 waveShow(canvas,dataBlockLength,outWaveFile,false,0,0,waveCounter);
 if checkBox4.Checked then speak(outWaveFileDir);//speakerDir:=outWaveFileDir;
 checkBox6.Checked:=check6;
 checkBox6.enabled:=true;
 bitBtn1.Enabled:=true;
end;{Button2Click}


procedure TForm1.Button3Click(Sender: TObject);  //Poka opis fonematyczny wszystkich wypowiedzi
begin
 form1.Memo2.Visible:=true;
 form1.Memo2.Clear;
 phonShow;
end;

procedure TForm1.Button4Click(Sender: TObject);  //Join files (pocz pliki)
begin
 check6:=checkBox6.Checked;
 form1.PageControl1.TabIndex:=1;
 button3.Enabled:=false;
 button7.enabled:=false;
 checkbox3.Enabled:=false;
 JoinFiles(canvas);
 button2.Enabled:=true;                        //csl/wav converter
 button3.Enabled:=true;
 button7.enabled:=true;
 checkbox3.Enabled:=true;
 checkBox6.Checked:=check6;
 checkBox6.enabled:=true;
end; {Button4Click}


procedure TForm1.FormResize(Sender: TObject);
begin
with form1 do
 begin
  panel1.Visible:=true;
  panel1.Visible:=false;
  Panel1.Width:=left+width-panel1.Left -118;
  application.ProcessMessages;
 end
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
var
i,j:longWord;
begin
   if CheckBox3.Checked then  //chosen sentence
     begin
      i:=strToInt(edit1.Text);        if i>45 then showMessage('person range 1-45');
      j:=strToInt(edit2.Text)+46;     if strToInt(edit2.Text)>365 then showMessage('sentence range 1-365');
      s5:=sentencesDirList[i];                             //fonFileDirFix
      s3:=sentencesDirList[j];                            //waveFileDirFix
      speakerDir:=dirStr+'\'+s5+'\'+s5+s3+'.wav';
     end;
 speak(speakerDir);
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
 if application.MessageBox('Przerwa program? - dotychczasowe wyniki przetwarzania NIE bd w peni zapisane.'+
   #13#10'Stosuj jeli czenie zostao wykonane, to aby zakoczy program nacinij Halt.','',MB_YESNO)=idNo then
  exit;
halt
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
 edit1.Enabled :=checkBox3.Checked;
 edit2.Enabled :=checkBox3.Checked;
 checkbox60.Checked:=not checkbox3.Checked; //turn off suspend or hibernate
 button3.Enabled :=checkBox3.Checked;
 if checkBox3.Checked then
  begin
  button4.Caption:='Show sentence osc.'; //pokaz wypowied
  edit1.Text:='1';
  edit2.Text:='1';
  end
 else button4.Caption:='Join files';
 button8.Enabled:=checkBox3.Checked;
 button9.Enabled:=checkBox3.Checked;
 if checkBox3.Checked then joinFiles(canvas);  //poka oscylogram dla 1, 1
end;

procedure TForm1.Edit2KeyPress(Sender: TObject; var Key: Char);
begin
 if key=#13 then button4.SetFocus;
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
ShowMessage('Opcja nie uwzgldnia wszystkich aspektw tego formatu.'#13#10+
'Przeznaczona tylko do obsugi "surowych" danych zebranych za pomoc tego urzdzenia...'#13#10+
'Plik nie moe te zawiera komentarzy (bloku "NOTE", por. instrukcja obsugi s. 488)');
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
 DirListRead;
 with openDialog1 do
   begin
    button2.Enabled:=false;
    Title:='Point to any Corpora file';
    initialDir:=dirStr;  fileName:='*.wav';
    if execute then dirStr:=copy(extractFileDir(fileName),1,lastDelimiter('\',extractFileDir(fileName)));
    button4.Enabled:=true;
    button7.Enabled:=true;
    checkbox3.Enabled:=true;
   end;
end;

procedure TForm1.Close1Click(Sender: TObject);
begin
SafeClosing
end;

procedure TForm1.CheckBox6Click(Sender: TObject);
begin
if checkbox6.Checked then
 begin
  showMessage('Showing values is time consuming process!!');
  checkBox6.Caption:='Clear values';
 end
else
 begin
  memo1.text:='';
  checkBox6.Caption:='Show values';
 end
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
 checkForFiles;          //Sprawd, czy istniej wszystkie pliki
end;

procedure TForm1.Button8Click(Sender: TObject);
 var i,j:word;
begin
 button8.Enabled:=false;  //aby nie naciska w trakcie odtwarzania oscylogramu, bo wtedy IO error
 button9.Enabled:=false;  //aby nie naciska w trakcie odtwarzania oscylogramu, bo wtedy IO error
 i:=strToint(edit1.Text); j:=strToint(edit2.Text);
 if j=1 then
  begin
  if i>1 then dec(i);
  j:=365;
  end
  else if j>1 then dec(j);
  edit1.Text := intToStr(i);
  edit2.Text := intToStr(j);
  JoinFiles(canvas);
  button8.Enabled:=true;  //aby nie naciska w trakcie odtwarzania oscylogramu, bo wtedy IO error
  button9.Enabled:=true; //aby nie naciska w trakcie odtwarzania oscylogramu, bo wtedy IO error
end;

procedure TForm1.Button9Click(Sender: TObject);
var i,j:word;
begin
  button8.Enabled:=false;  //aby nie naciska w trakcie odtwarzania oscylogramu, bo wtedy IO error
  button9.Enabled:=false;  //aby nie naciska w trakcie odtwarzania oscylogramu, bo wtedy IO error
  i:=strToint(edit1.Text); j:=strToint(edit2.Text);
  if j=365 then  inc(i);
  inc(j);
  edit1.Text := intToStr((i-1) mod 45+1);
  edit2.Text := intToStr((j-1) mod 365+1);
  JoinFiles(canvas);
  button8.Enabled:=true;  //aby nie naciska w trakcie odtwarzania oscylogramu, bo wtedy IO error
  button9.Enabled:=true; //aby nie naciska w trakcie odtwarzania oscylogramu, bo wtedy IO error
end;


end.
