unit ControlStatesEncoder;

interface
var                              OutCheckStates : word;
allNormChecksStatesCode, allOutChecksStatesCode : word;
                                            C,D : array[byte] of word;
  procedure OutCheckStatesRestore;
  procedure NormCheckStatesRestore;
  function checkBoxEnCode:word;

implementation
 uses sysutils,NewSpectrum,unit1,visualization;

 type ToutSettings = procedure(out c:array of word);
 var binLength_glob : byte;

  procedure checkBoxDeCode(n:word;out checkStateArr:array of boolean; out binLength:byte);
   //checkBoxes states decode - convert decimal of a number to its binary form
    var i,k:longInt;
    Begin
     for i:=0 to high(checkStateArr) do checkStateArr[i]:=false;
     i:=0;
     repeat
      k:=n div 2;
      if 2*k <  n then checkStateArr[i]:=true;
      n:=k;
      inc(i);
      if k=0 then binLength:=i-1;  //throw out end zeros
     until (i> high(checkStateArr)) or (k=0);
    End;{checkBoxDeCode}

 procedure OutCheckStatesRestore;
   var i:byte;   OutStatArr: array[0..15] of boolean;  k:word;
   Begin
    i:=0;   //checkBoxDeCode(allNormChecksStatesCode,NormStatArr);
    checkBoxDeCode(allOutChecksStatesCode,OutStatArr,binLength_glob);   //allOutChecksStatesCode, allOutChecksStatesCode
    with form1 do
     begin //"Output"check box                   //Streams Names                         dec. contrib.   indeks in  checkStateArr
              Form1.checkBox5.Checked :=OutStatArr[i];  //Original signal                           1    0
      inc(i);                                           //weighed wave
      inc(i); Form1.checkBox40.Checked:=OutStatArr[i];  //Power spectrum (PS)                       4    2
      inc(i); Form1.checkBox41.Checked:=OutStatArr[i];  //Smoothed PS (sPS)                         8    3
      inc(i); Form1.checkBox44.Checked:=OutStatArr[i];  //Mels from smoothed PS (msPS)             16    4
      inc(i); Form1.checkBox43.Checked:=OutStatArr[i];   //Time centralized PS (vPS)               32    5
      inc(i); Form1.checkBox42.Checked:=OutStatArr[i];  //Spectrum of time constant response (cPS) 64    6
      inc(i); Form1.checkBox4.Checked :=OutStatArr[i];  //Signal spectrum phase (aPS)             128    7
      inc(i); Form1.checkBox45.Checked:=OutStatArr[i];  //Power Cepstrum (PC)                     256    8
      inc(i); Form1.checkBox48.Checked:=OutStatArr[i];  //Mel PC (mPC)                            512    9
      inc(i); Form1.checkBox47.Checked:=OutStatArr[i];  //Time centralized PC (vPC)              1024   10
      inc(i); Form1.checkBox46.Checked:=OutStatArr[i];  //PC of a time constant response (cPC)   2048   11
      inc(i); Form1.checkBox49.Checked:=OutStatArr[i];  //Multi Mean                             4096   12
      k:= allOutChecksStatesCode;
      k:=k shr i;
              form2.radiogroup4.ItemIndex:=k;//Multimean bundle                  8192 | 16384 | 24576
    end{with}
   End;{OutCheckStatesRestore}

 procedure NormCheckStatesRestore;
   var i:byte;    NormStatArr : array[0..15] of boolean;
   Begin
    i:=0;
    checkBoxDeCode(allNormChecksStatesCode,NormStatArr,binLength_glob);  //allNormChecksStatesCode, allOutChecksStatesCode
    with form2 do
     begin //"Standardize" check box              //Streams Names                  dec. contrib.   indeks in  checkStateArr
              checkBox82.Checked:=NormStatArr[i]; //Original signal                           1    0
      inc(i); checkBox83.Checked:=NormStatArr[i]; //Weighted signal                           2    1
      inc(i); checkBox84.Checked:=NormStatArr[i]; //Power spectrum (PS)                       4    2
      inc(i); checkBox85.Checked:=NormStatArr[i]; //Smoothed PS (sPS)                         8    3
      inc(i); checkBox86.Checked:=NormStatArr[i]; //Mels from smoothed PS (msPS)             16    4
      inc(i); checkBox87.Checked:=NormStatArr[i]; //Time centralized PS (vPS)                32    5
      inc(i); checkBox88.Checked:=NormStatArr[i]; //Spectrum of time constant response (cPS) 64    6
      inc(i);                                     //Signal spectrum phase (aPS)             128    7
      inc(i); checkBox89.Checked:=NormStatArr[i]; //Power Cepstrum (PC)                     256    8
      inc(i); checkBox90.Checked:=NormStatArr[i]; //Mel PC (mPC)                            512    9
      inc(i); checkBox91.Checked:=NormStatArr[i]; //Time centralized PC (vPC)              1024   10
      inc(i); checkBox92.Checked:=NormStatArr[i]; //PC of a time constant response (cPC)   2048   11
      inc(i); checkBox93.Checked:=NormStatArr[i]; //Multi Mean                             4096   12
      inc(i); checkbox30.checked:=NormStatArr[i]; //cPS[0]=0 && vPS[0]=0 && sPS[0]=0       8192   13
    end;{with}
   End;{NormCheckStatesRestore}

 procedure rigidOutSettings(out c:array of word);
    Begin
  //Checkbox states&names

    with form2 do
     begin  //codes of states of standardisation check boxes
     {M, N] = {checkboxM, power N of 2}                                                                    // critical
      //      Critical settings                                                output                         norm checkBoxes                 numerical codes of their settings
     {82,  0} c[0]:=1; //82                                                    // 31. Wave origin                   82                      =    1
     {83,  1} c[1]:=1+1 shl 1;                                                 // -  Wave weighed                   82,83                   =    3
     //--------------------------------
     {84,  2} c[2]:=1+1 shl 1+1 shl 2;                                         // 32. Power spectrum           (PS) 82,83,84                =    7
     {85,  3} c[3]:=1+1 shl 1+1 shl 2+1 shl 3+1 shl 8+1 shl 13;                // 33. Smoothed power spectrum (sPS) 82,83,84,85,89,30       = 4239
     {86,  4} c[4]:=1+1 shl 1+1 shl 2+1 shl 3+1 shl 4+1 shl 8+1 shl 13;        // 34. Mel smooth. PS         (msPS) 82,83,84,85,86,89,30    = 4255
     {87,  5} c[5]:=1+1 shl 1+1 shl 2+1 shl 5+1 shl 8+1 shl 13;                // 35. Time centralised PS     (vPS) 82,83,84,87,89,30       = 4263
     {88,  6} c[6]:=1+1 shl 1+1 shl 2+1 shl 6+1 shl 8+1 shl 13;                // 36. Time constant PS        (cPS) 82,83,84,88,89,30       = 4295
     //-------------------------------
     {89,  8} c[7]:=1+1 shl 1+1 shl 2+1 shl 8;                                 // 41. Power cepstrum           (PC) 82,83,84,89             =  135
     {90,  9} c[8]:=1+1 shl 1+1 shl 2+1 shl 3+1 shl 4+1shl 8+1 shl 9+1 shl 13; // 42. Mel PC                  (mPC) 82,83,84,85,86,89,90,30 = 4511
     {91, 10} c[9]:=1+1 shl 1+1 shl 2+1 shl 8+1 shl 10;                        // 43. Time centr. PC          (vPC) 82,83,84,89,91          =  647
     {92, 11}c[10]:=1+1 shl 1+1 shl 2+1 shl 8+1 shl 11;                        // 44. Time const. PC          (cPC) 82,83,84,89,92          = 1159
     //--------------------------------
     {93, 12}c[11]:=c[8]+(form2.RadioGroup4.ItemIndex) shl 13;                 // CCR bundle
    end{with}
   End;{rigidOutSettings}

 procedure weakOutSettings(out d:array of word);
    Begin
  //Checkbox states&names

    with form2 do
     begin  //codes of states of standardisation check boxes
     {M, N] = {checkboxM, power N of 2}                                                                         // critical
      //      Critical settings                                                output                              norm checkBoxes           numerical codes of their settings
     {82,  0} d[0]:=1; //82                                                    // 31. Wave origin                   82                      =    1
     {83,  1} d[1]:=1+1 shl 1;                                                 // -  Wave weighed                  82,83                    =    3
     //--------------------------------
     {84,  2} d[2]:=1+1 shl 1+1 shl 2;                                         // 32. Power spectrum           (PS) 82,83,84                =    7
     {85,  3} d[3]:=1+1 shl 1+1 shl 2+1 shl 3+1 shl 8+1 shl 13;                // 33. Smoothed power spectrum (sPS) 82,83,84,85,89,30       = 4239                                 check82, when not check89
     {86,  4} d[4]:=1+1 shl 1+1 shl 2+1 shl 3+1 shl 4+1 shl 13;                // 34. Mel smooth. PS         (msPS) 82,83,84,86,30          = 4127   -85!rem.
     {87,  5} d[5]:=1+1 shl 1+1 shl 2+1 shl 5+1 shl 8+1 shl 13;                // 35. Time centralised PS     (vPS) 82,83,84,87,89,30       = 4263                                 check 82, 84 when not check30
     {88,  6} d[6]:=1+1 shl 1+1 shl 2+1 shl 6+1 shl 8+1 shl 13;                // 36. Time constant PS        (cPS) 82,83,84,88,89,30       = 4295
     //-------------------------------
     {89,  8} d[7]:=1+1 shl 1+1 shl 2+1 shl 8;                                 // 41. Power cepstrum           (PC) 82,83,84,89             =  135
     {90,  9} d[8]:=  1 shl 2+1 shl 3+1 shl 4+1 shl 9;                         // 42. Mel PC                  (mPC) 84, 85,86,90            = 284   -84!remove, 85!remove
     {91, 10} d[9]:=1+1 shl 1+1 shl 2+1 shl 8+1 shl 10;                        // 43. Time centr. PC          (vPC) 84,89,91                =  647   84, 89, 91, czyli -82!rem., 83!rem.     check 82, 83 when not check89 or not check30
     {92, 11}d[10]:=1+1 shl 1+1 shl 2+1 shl 8+1 shl 11;                        // 44. Time const. PC          (cPC) 84,89,92                = 1159    j.w., ale 92   -82!rem., 83!rem.              check 82, 83 when not check89 or not check30
     //--------------------------------
     {93, 11}d[11]:=d[8]+(form2.RadioGroup4.ItemIndex) shl 13;                 // CCR bundle
    end{with}
   End;{weakOutSettings}

function checkBoxEnCode:word;  {out cBc:array of boolean}
   //encode states of streams normalization czheckBoxes (82..92)

  type checksStatesRec = record
                           vizName : shortString;
                          outCheck : boolean;
                         analCheck : boolean;
                          stdCheck : boolean;
                         end;
             TCrossArr = Array[0..16] of byte;
   var
                                 l : integer;
                       statesDescr : array[0..16] of checksStatesRec;
                          crossArr : TcrossArr;
                             s1,s2 : shortString;

  checkBoxEncodeNbr:word;
  checkStateArr:array[0..15] of boolean;
  cBc:array[0..16] of boolean;

  function OutCheckEncoder:word;
   //decimal code of the out checkboxes states. Note shift from PS
   Begin
    with form2 do
     begin
      result:=0;                                      //name                                      decimal code
       result:=result+byte(checkBox31.checked) shl 0; //Original signal                            1
        result:=result+byte(checkBox32.checked) shl 2;  //Power spectrum (PS)                        4
         result:=result+byte(checkBox33.checked) shl 3;  //Smoothed PS (sPS)                          8
          result:=result+byte(checkBox34.checked) shl 4;  //Mels from smoothed PS (msPS)               16
           result:=result+byte(checkBox35.checked) shl 5;  //Time centralized PS (vPS)                 32
            result:=result+byte(checkBox36.checked) shl 6;  //Signal spectrum phase (cPS)               64
             result:=result+byte(checkBox37.checked) shl 7;  //Spectrum of time constant response (aPS) 128
              result:=result+byte(checkBox41.checked) shl 8;  //Power Cepstrum (PC)                      256
               result:=result+byte(checkBox42.checked) shl 9;  //Mel PC (mPC)                             512
                result:=result+byte(checkBox43.checked) shl 10;  //Time centralized PC (vPC)              1024
                 result:=result+byte(checkBox44.checked) shl 11; //PC of a time constant response (cPC)    2048
                  result:=result+byte(checkBox45.checked) shl 12; //Multi Mean                              4096
                   result:=   result+radiogroup4.ItemIndex shl 13; //Multimean bundle  0|8192 |16384 |24576
     end{with}
   End; {OutCheckEncoder}

 function NormCheckEncoder:word;
   //decimal code of the standarization checkboxes states. Note shift from PC
   Begin
     with form2 do
     begin
      result:=0;                                       //accepted version                    decimal code
       result:=result+byte(checkBox82.checked) shl 0;  //Original signal                           1
        result:=result+byte(checkBox83.checked) shl 1;  //Weighted signal                           2
         result:=result+byte(checkBox84.checked) shl 2;  //Power spectrum (PS)                       4
          result:=result+byte(checkBox85.checked) shl 3;  //Smoothed PS (sPS)                         8
           result:=result+byte(checkBox86.checked) shl 4;  //Mels from smoothed PS (msPS)             16
            result:=result+byte(checkBox87.checked) shl 5;  //Time centralized PS (vPS)                32
             result:=result+byte(checkBox88.checked) shl 6;  //Spectrum of time constant response (cPS) 64
              result:=result+byte(checkBox89.checked) shl 8;   //Power Cepstrum (PC)                     256
               result:=result+byte(checkBox90.checked) shl 9;   //Mel PC (mPC)                            512
                result:=result+byte(checkBox91.checked) shl 10;  //Time centralized PC (vPC)              1024
                 result:=result+byte(checkBox92.checked) shl 11;  //PC of a time constant response (cPC)   2048
                  result:=result+byte(checkBox93.checked) shl 12;  //Multi Mean                             4096
                   result:=result+byte(checkBox30.checked) shl 13;  //cPS[0]=0 && vPS[0]=0 && sPS[0]=0       8192
     end{with}
   End; {NormCheckEncoder}


 function checkStatesDescr(out l:integer):TCrossArr;
  {
  Create description of out and standardize checkboxes on the basis of a given a'priori their captions
  and a given a'priori their numbers as an array called "crossArr"
  Their states and  captions names for outputed analyses streams will be
  read from data passed by the Spectrum Analyser and adapted later
  }
  function OutShl(k:byte):boolean;
   begin
    result:=((1 shl k) and allOutChecksStatesCode)>0
   end;

  function stdShl(k:byte):boolean;
   begin
    result:=((1 shl k) and allNormChecksStatesCode)>0
   end;

   var i,k:byte;
   Begin
    l:=0;
    for i:=0 to high(result) do begin result[i]:=high(result[0]); with statesDescr[i] do begin vizName:='';outCheck:=false; stdCheck:=false;analCheck:=false end {with} end;{for}
    with form2 do
     begin //                               "Graphs"  check box "Output"check box     "Standardize" check box "Analyses" check box                 //Streams Names                        indeks in  checkStateArr
      with statesDescr[0]  do begin vizName:=checkBox7.Caption;  outCheck:=outShl(0);  stdCheck:=stdShl(0);   analCheck:=outCheck or stdCheck  end;//Original signal                           1    0
      with statesDescr[1]  do begin vizName:=checkBox8.Caption;  outCheck:=false;      stdCheck:=stdShl(1);   analCheck:=outCheck or stdCheck  end;//Weighted signal                           2    1
      with statesDescr[2]  do begin vizName:=checkBox9.Caption;  outCheck:=outShl(2);  stdCheck:=stdShl(2);   analCheck:=outCheck or stdCheck  end;//Power spectrum (PS)                       4    2
      with statesDescr[3]  do begin vizName:=checkBox10.Caption; outCheck:=outShl(3);  stdCheck:=stdShl(3);   analCheck:=outCheck or stdCheck  end;//Smoothed PS (sPS)                         8    3
      with statesDescr[4]  do begin vizName:=checkBox11.Caption; outCheck:=outShl(4);  stdCheck:=stdShl(4);   analCheck:=outCheck or stdCheck  end;//Mels from smoothed PS (msPS)             16    4
      with statesDescr[5]  do begin vizName:=checkBox12.Caption; outCheck:=outShl(5);  stdCheck:=stdShl(5);   analCheck:=outCheck or stdCheck  end;//Time centralized PS (vPS)                32    5
      with statesDescr[6]  do begin vizName:=checkBox13.Caption; outCheck:=outShl(6);  stdCheck:=stdShl(6);   analCheck:=outCheck or stdCheck  end;//Spectrum of time constant response (cPS) 64    6

      with statesDescr[7]  do begin vizName:=checkBox26.Caption; outCheck:=outShl(7);  stdCheck:=false;       analCheck:=outCheck or stdCheck  end;//aPS     a=angle. phase
      with statesDescr[8]  do begin vizName:=checkBox27.Caption; outCheck:=False;      stdCheck:=false;       analCheck:=outCheck or stdCheck  end;//svPS
      with statesDescr[9]  do begin vizName:=checkBox28.Caption; outCheck:=false;      stdCheck:=false;       analCheck:=outCheck or stdCheck  end;//acPS
      with statesDescr[10] do begin vizName:=checkBox29.Caption; outCheck:=false;      stdCheck:=false;       analCheck:=outCheck or stdCheck  end;//aPC

      with statesDescr[11] do begin vizName:=checkBox14.Caption; outCheck:=outShl(8);  stdCheck:=stdShl(8);   analCheck:=outCheck or stdCheck  end;//Power Cepstrum (PC)                     128     7
      with statesDescr[12] do begin vizName:=checkBox15.Caption; outCheck:=outShl(9);  stdCheck:=stdShl(9);   analCheck:=outCheck or stdCheck  end;//Mel PC (mPC)                            256     8
      with statesDescr[13] do begin vizName:=checkBox16.Caption; outCheck:=outShl(10); stdCheck:=stdShl(10);  analCheck:=outCheck or stdCheck  end;//Time centralized PC (vPC)               512     9
      with statesDescr[14] do begin vizName:=checkBox17.Caption; outCheck:=outShl(11); stdCheck:=stdShl(11);  analCheck:=outCheck or stdCheck  end;//PC of a time constant response (cPC)   1024    10
      with statesDescr[15] do begin vizName:='Multi Mean';       outCheck:=outShl(12); stdCheck:=stdShl(12);  analCheck:=outCheck or stdCheck  end;//Multi Mean                             2048    11

      with statesDescr[16] do begin vizName:=checkBox30.Caption; outCheck:=false;      stdCheck:=stdShl(13);  analCheck:=checkBox30.checked;   end;//cPS[0]=0 && vPS[0]=0 && sPS[0]=0       4096    12

      for i:=0 to  high(result) do if length(statesDescr[i].vizName)>l then l:=length(statesDescr[i].vizName);  //the longest checkBox caption
    end;{with}
    for i:=0 to 7 do result[i]:=i;
    for i:=8 to 13 do result[i]:=i+3;

   End;{checkStatesDescr}

 procedure stdCheckStatesArr;
  var i:byte;
  Begin
   with form2 do
    begin
     for i:=0 to high(checkStateArr) do cBc[i]:=false; //debug prp.; restore the checkboxes states from the numerical code;

     //"Standardize" checkBox state  name in viz. checkBox   "Out" checkBox
     cBc[0]:=checkBox82.checked;       // 7                    31
     cBc[1]:=checkBox83.checked;       // 8                     -

     cBc[2]:=checkBox84.checked;       // 9                    32
     cBc[3]:=checkBox85.checked;       //10                    33
     cBc[4]:=checkBox86.checked;       //11                    34
     cBc[5]:=checkBox87.checked;       //12                    35
     cBc[6]:=checkBox88.checked;       //13                    36

     cBc[7]:=checkBox89.checked;       //14                    41
     cBc[8]:=checkBox90.checked;       //15                    42
     cBc[9]:=checkBox91.checked;       //16                    43
     cBc[10]:=checkBox92.checked;      //17                    44

  // cBc[11]:=checkBox93.checked;      //45                    45
     cBc[11]:=checkBox30.checked;      //30                     -
    end;{with form2}
   End;{stdCheckStatesArr}

   function onOff(check:boolean):shortString;
   Begin
    if check then result:='  On        '  else result:=' Off        ' //length=12
   End;{onOff}

   procedure ToReport(outSettings:ToutSettings;out E:array of word; rigidWeek,cd:shortString);
   // l - the longest checkBox caption
   var i:integer; j,k,binLength:byte; s:string;

  procedure binToreport(i:longInt);
   var j:byte;
   Begin
    checkBoxDeCode(i,checkStateArr,binLength);                                              //convert decimal of a number to its binary form
    for j:=0 to binLength do write(reportFile,byte(checkStateArr[j]):2);   //print binary form of a E[i]
    for j:= binLength+1 to high(checkStateArr) do write(reportFile,' ':2);
   End;

    Begin
     with form2 do
      Writeln(reportFile,'List of states of all checkboxes and checkboxes influencing the output streams'#13#10,
      'NOTE. Data valid for spectrum analyses results obtained with the "Spectrum" program v. 8.1. or higher');
     OutSettings(E);
     with form2 do begin s1:='Analyses'; s2:='Standardize'; delete(s1,pos(' ',s1),1);  delete(s2,pos(' ',s2),1); end;
     Writeln(reportFile,#13#10'CheckBox states',rigidWeek,':');
     k:=length('  i '+'Output   '+s1+'  '+s2+'    |')+l-1;
     Writeln(reportFile,'---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------');
     with form2 do
     Writeln(reportFile,'  i ','Stream name ':l+1,'Output   ',s1,'  ',s2,'      | Codes of checkboxes (',cd,') influencing output| names of "',s2,'" and the "',form2.checkBox30.caption,'" check boxes turned on ');
     Writeln(reportFile,'  ':k+3,'|______________________________________________|');
     Writeln(reportFile,'  ':k+3,'|  decimal  |  binary form                     | i.e. ',intTostr(allNormChecksStatesCode),' and ',cd,' ');
     for i:=0 to k+2 do Write(reportFile,'=');
     Writeln(reportFile,'|====================================================================================================================================================================');
     for i:=0 to 16 do
      begin
       if crossArr[i]<=high(statesDescr) then
        with statesDescr[crossArr[i]] do
        begin
         if i=13 then                                                                         //vizName:='cPS[0]=0 & vPS[0]=0 & sPS[0]=0'  checkBox30
          write(reportFile,i:3,')',vizName:l,' ',onOff(form2.CheckBox30.Checked), '-':3,'  ':11,'-','|':10,E[i]:9,'  |  ')
         else write(reportFile,i:3,')',vizName:l,' ',onOff(outCheck), onOff(outCheck or stdCheck), onOff(stdCheck),'|',E[i]:9,'  |  ');         //decimal dependencies code
         binToReport(E[i]);
          s:='';
         if E[i] and allNormChecksStatesCode>0 then
          begin
           write(reportFile,'|');
           checkBoxDeCode(E[i] and allNormChecksStatesCode, checkStateArr,binLength); //convert decimal of a number to its binary form
           for j:=0 to binLength do    //write names of turned on checkBoxes
            begin
             if byte(checkStateArr[j])=1
             then s:=s+' "'+statesDescr[crossArr[j]]. vizName+'", ';
            end{for j}
          end {if E[i]}
         else write(reportFile,'| *');
         delete(s,length(s)-1,2);
         writeln(reportFile,s,'.'); //end of the tables row
        end;{with}
       flush(reportFile)
      end;{for i}
      i:=allOutChecksStatesCode shr 12;
     write(reportFile,14:3,')',form2.RadioGroup4.caption:l,' ',form2.RadioGroup4.itemIndex:3,form2.RadioGroup4.items[form2.RadioGroup4.itemIndex]:13,'-':11,'|':10,i:9,'  |  ':5);
     binToReport(i);
     writeln(reportFile,'| -.':4,' Note, the  "decimal  |  binary form" in this row mean the "',form2.RadioGroup4.caption,'" radiogroups state index' );
//standardize check boxes
     cd:='Settings code of all "standardize" and the "'+form2.checkBox30.caption+'" check boxes: ';
     j:=length(cd);    //debug prp
     for i:=0 to k+2 do Write(reportFile,'-');
     Writeln(reportFile,'|-----------|----------------------------------|----------------------------------------------------------------------------------------------------------------------');
     Write(reportFile,cd:k+3);for i:=0 to 80-j-8 do write(reportFile,' ');write(reportFile,'|', allNormChecksStatesCode:9,'  |  ');
     binToReport(allNormChecksStatesCode);
     Writeln(reportFile,'|');
     for i:=0 to k+2 do Write(reportFile,'-');
     Writeln(reportFile,'|-----------|----------------------------------|----------------------------------------------------------------------------------------------------------------------');
//---------------------------------------------------------------------------------
  //Out checkBoxes
     cd:='Settings code of all "Output" check boxes, and the "'+form2.radiogroup4.Caption+'" radiogr state:';
     j:=length(cd);
     Write(reportFile,cd:k+2);for i:=0 to 80-j-2 do write(reportFile,' '); write(reportFile,'|',allOutChecksStatesCode:9,'  |  ');
     binToReport(allOutChecksStatesCode);
     Writeln(reportFile,'|');
     Writeln(reportFile,'---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------',#13#10);

     Writeln(reportFile,'* means "This Out stream was not affected by standarize command nor by the "',form2.checkbox30.Caption,'" checkBox"');
     Writeln(reportFile,'A and B means logical product');
    End;{ToReport}

   Begin //------------------------------------checkBoxEnCode-----------------------
    allOutChecksStatesCode:=outCheckEncoder;    //decimal code of all out checkboxes states
    allNormChecksStatesCode:=NormCheckEncoder;    //decimal code of standardization checkboxes states
    l:=0;
    crossArr:=checkStatesDescr(l); //l - the longest checkBox caption
    if l<50 then l:=50;
    Writeln(reportFile,#13#10'Table 1.');
    ToReport(rigidOutSettings,C,', v. rigid','c[i]');
    Writeln(reportFile,#13#10'Table 2.');
    ToReport(weakOutSettings,D,', v. week','d[i]');
   End;{checkBoxEnCode}

end.


      (* if radiogroup4.ItemIndex=0 then  result:=result+(1 shl 12); //Multimean bundle                        4096 |
        if radiogroup4.ItemIndex=1 then  result:=result+(1 shl 13); //Multimean bundle                        8192 |
         if radiogroup4.ItemIndex=2 then  result:=result+(1 shl 14); //Multimean bundle                       16384 |
          if radiogroup4.ItemIndex=3 then  result:=result+(1 shl 15); //Multimean bundle                       22768 |  *)


 (* procedure checkBoxDeCode(n:word;out checkStateArr:array of boolean);
   //checkBoxes states decode - convert decimal of a number to its binary form
    var i,k:longInt;
    Begin
     for i:=0 to high(checkStateArr) do checkStateArr[i]:=false;
     i:=0;
     repeat
      k:=n div 2;
      if 2*k <  n then checkStateArr[i]:=true;
      n:=k;
      inc(i)
     until i> high(checkStateArr);
    End;{checkBoxDeCode}  *)

 (*  function checkStatesDescr(out l:integer):TCrossArr;
   var i:byte;
   Begin
    l:=0;
    for i:=0 to high(result) do result[i]:=high(result[0]);
    with form2 do
     begin //                               "Graphs"  check box "Output"check box             "Analyses" check box           "Standardize" check box            //Streams Names                                 indeks in  checkStateArr
      with statesDescr[0]  do begin vizName:=checkBox7.Caption;  outCheck:=checkBox31.Checked; analCheck:=checkBox60.Checked; stdCheck:=checkBox82.Checked  end;//Original signal                           1    0
      with statesDescr[1]  do begin vizName:=checkBox8.Caption;  outCheck:=false;              analCheck:=false;              stdCheck:=checkBox83.Checked  end;//Weighted signal                           2    1
      with statesDescr[2]  do begin vizName:=checkBox9.Caption;  outCheck:=checkBox32.Checked; analCheck:=checkBox46.Checked; stdCheck:=checkBox84.Checked  end;//Power spectrum (PS)                       4    2
      with statesDescr[3]  do begin vizName:=checkBox10.Caption; outCheck:=checkBox33.Checked; analCheck:=checkBox47.Checked; stdCheck:=checkBox85.Checked  end;//Smoothed PS (sPS)                         8    3
      with statesDescr[4]  do begin vizName:=checkBox11.Caption; outCheck:=checkBox34.Checked; analCheck:=checkBox48.Checked; stdCheck:=checkBox86.Checked  end;//Mels from smoothed PS (msPS)             16    4
      with statesDescr[5]  do begin vizName:=checkBox12.Caption; outCheck:=checkBox35.Checked; analCheck:=checkBox49.Checked; stdCheck:=checkBox87.Checked  end;//Time centralized PS (vPS)                32    5
      with statesDescr[6]  do begin vizName:=checkBox13.Caption; outCheck:=checkBox36.Checked; analCheck:=checkBox50.Checked; stdCheck:=checkBox88.Checked  end;//Spectrum of time constant response (cPS) 64    6
      with statesDescr[7]  do begin vizName:=checkBox26.Caption; outCheck:=checkBox37.Checked; analCheck:=checkBox51.Checked; stdCheck:=false               end;//
      with statesDescr[8]  do begin vizName:=checkBox27.Caption; outCheck:=checkBox38.Checked; analCheck:=checkBox52.Checked; stdCheck:=false               end;//
      with statesDescr[9]  do begin vizName:=checkBox28.Caption; outCheck:=checkBox39.Checked; analCheck:=checkBox53.Checked; stdCheck:=false               end;//
      with statesDescr[10] do begin vizName:=checkBox29.Caption; outCheck:=checkBox40.Checked; analCheck:=checkBox54.Checked; stdCheck:=false               end;//
      with statesDescr[11] do begin vizName:=checkBox14.Caption; outCheck:=checkBox41.Checked; analCheck:=checkBox55.Checked; stdCheck:=checkBox89.Checked  end;//Power Cepstrum (PC)                     128     7
      with statesDescr[12] do begin vizName:=checkBox15.Caption; outCheck:=checkBox42.Checked; analCheck:=checkBox56.Checked; stdCheck:=checkBox90.Checked  end;//Mel PC (mPC)                            256     8
      with statesDescr[13] do begin vizName:=checkBox16.Caption; outCheck:=checkBox43.Checked; analCheck:=checkBox57.Checked; stdCheck:=checkBox91.Checked  end;//Time centralized PC (vPC)               512     9
      with statesDescr[14] do begin vizName:=checkBox17.Caption; outCheck:=checkBox44.Checked; analCheck:=checkBox58.Checked; stdCheck:=checkBox92.Checked  end;//PC of a time constant response (cPC)   1024    10
      with statesDescr[15] do begin vizName:='Multi Mean';       outCheck:=checkBox45.Checked; analCheck:=checkBox59.Checked; stdCheck:=checkBox93.Checked  end;//Multi Mean                             2048    11
      with statesDescr[16] do begin vizName:=checkBox30.Caption; outCheck:=false;              analCheck:=checkBox30.checked; stdCheck:=false               end;//cPS[0]=0 && vPS[0]=0 && sPS[0]=0       4096    12
      for i:=0 to  high(result) do if length(statesDescr[i].vizName)>l then l:=length(statesDescr[i].vizName);  //the longest checkBox caption
      for i:=0 to 6 do result[i]:=i;
      for i:=7 to 12 do result[i]:=i+4;
    end{with}
   End;{checkStatesDescr}    *)


   


  (* procedure ToReport(outSettings:ToutSettings;out E:array of word; rigidWeek,cd:shortString);
   // l - the longest checkBox caption
   var i,j:byte; s:string;
    Begin
     with form2 do
      Writeln(reportFile,#13#10'Table 1. List of states of checkboxes: "', label2.Caption,'", "', label3.Caption,'", and "', label6.Caption,' and checkboxes influencing the output streams');
     OutSettings(E);
     with form2 do begin s1:=Label3.Caption; s2:=label6.Caption; delete(s1,pos(' ',s1),1);  delete(s2,pos(' ',s2),1); end;
     Writeln(reportFile,#13#10'CheckBox states',rigidWeek,':');
     Writeln(reportFile,'--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------');
     with form2 do
     Writeln(reportFile,'  i ','Stream name ':l,' ',label2.Caption,'     ',s1,'     ',s2,' | Codes of checkboxes (',cd,') influencing output| names of "',s2,'" and the "',form2.checkBox30.caption,'" check boxes turned on ');
     Writeln(reportFile,'                                                                                 |  decimal  |  binary form                     | i.e. ',intTostr(allNormChecksStatesCode),' and ',cd,' ');
     Writeln(reportFile,'=================================================================================|=============================================================================================================================');
     for i:=0 to 12 do
      begin
       if crossArr[i]<=high(statesDescr) then
        with statesDescr[crossArr[i]] do
        begin
         if i=12 then //vizName:='cPS[0]=0 & vPS[0]=0 & sPS[0]=0'
              write(reportFile,i:3,')',vizName:l,' ','  -',' ':9, onOff(analCheck),' ',' -','|':10,E[i]:9,'  |  ')
         else write(reportFile,i:3,')',vizName:l,' ',onOff(outCheck), onOff(analCheck), onOff(stdCheck),'|',E[i]:9,'  |  '); //decimal dependencies code
         checkBoxDeCode(E[i], checkStateArr);                                                                        //binary form of above code
         for j:=0 to high(checkStateArr) do write(reportFile,byte(checkStateArr[j]):2);   //print binary form of a E[i]
          s:='';
         if E[i] and allNormChecksStatesCode>0 then
          begin
           checkBoxDeCode(E[i] and allNormChecksStatesCode, checkStateArr);
           write(reportFile,'|');
           for j:=0 to high(checkStateArr) do    //write names of turned on checkBoxes
            begin
            if byte(checkStateArr[j])=1
            then s:=s+' "'+statesDescr[crossArr[j]]. vizName+'", ';
            end{for j}
          end {if E[i]}
         else write(reportFile,'| *');
         delete(s,length(s)-1,2);
         writeln(reportFile,s,'.'); //end of the tables row
        end; {with}
       flush(reportFile)
      end;{for i}
//standardize check boxes
     cd:='Settings code of all "standardize" and the "'+form2.checkBox30.caption+'" check boxes: ';
     j:=length(cd);    //debug prp
     Writeln(reportFile,'---------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------');
     Write(reportFile,cd:l+23, allNormChecksStatesCode:15,'  |  ');
     checkBoxDeCode(allNormChecksStatesCode, checkStateArr);                                                                        //binary form of normChecksStateCode code
     for j:=0 to high(checkStateArr) do write(reportFile,byte(checkStateArr[j]):2);
     Writeln(reportFile,'|');
     Writeln(reportFile,'---------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------');
  //Out checkBoxes
     cd:='Settings code of all "Output" check boxes and the "'+form2.radioGroup4.caption+'" radiogroup   ';
     j:=length(cd);
     Write(reportFile,cd:139-j, allOutChecksStatesCode:15,'  |  ');
     checkBoxDeCode(allOutChecksStatesCode, checkStateArr);                                                                        //binary form of normChecksStateCode code
     for j:=0 to high(checkStateArr) do write(reportFile,byte(checkStateArr[j]):2);
     Writeln(reportFile,'|');
     Writeln(reportFile,'---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------',#13#10);

     Writeln(reportFile,'* means "This Out stream was not affected by standarize command nor by the "',form2.checkbox30.Caption,'" checkBox"');
     Writeln(reportFile,'A and B means logical product');
    End;{ToReport}    *)

 Begin //------------------------------------checkBoxEnCode-----------------------
  //  OutCheckStatesRetriever;
    allOutChecksStatesCode:=outCheckEncoder;    //decimal code of all out checkboxes states
  //  l:=outCheckStatesCodeCheck;//control prp, l should be =  allOutChecksStatesCod
  //  NormCheckStatesRetriever;
    allNormChecksStatesCode:=NormCheckEncoder;    //decimal code of standardization checkboxes states
    l:=0;
    crossArr:=checkStatesDescr(l); //l - the longest checkBox caption
    if l<50 then l:=50;
    Writeln(reportFile,#13#10'Table 1.');
    ToReport(rigidOutSettings,C,', v. rigid','c[i]');
    Writeln(reportFile,#13#10'Table 2.');
    ToReport(weakOutSettings,D,', v. week','d[i]');
    // exit;
   (* allOutChecksStatesCode:=outCheckEncoder;    //decimal code of out checkboxes states
    allNormChecksStatesCode:=NormCheckEncoder;    //decimal code of standardization checkboxes states
    crossArr:=checkStatesDescr(l); //l - the longest checkBox caption
    ToReport(rigidOutSettings,C,', v. rigid','c[i]');
    ToReport(weakOutSettings,D,', v. week','d[i]');  *)
   End;{checkBoxEnCode}
