unit WaveSound;
interface
implementation
end.

unit WaveSound;     //https://stackoverflow.com/questions/7971748/real-time-microphone-in-delphi/15723767#15723767

interface

uses
  SysUtils, MMSystem;

const
  NUMSAMPLES = 1024;    // Number of Samples

type
  TIndata      = array[0 .. NUMSAMPLES - 1] of Integer;
  PIndata      = ^TIndata;

  TFrec= record
    Fx, dx  :Integer;
  end;

  function SNDInitWaveIn: Cardinal;
  procedure SNDProcWaveIn(var Indata : TIndata);
  procedure SNDStopWave;

implementation

var
  DevHandle   : Integer;
  WAVEFORMAT1 : TWAVEFORMATEX;
  Wave        : WAVEHDR;

function SNDInitWaveIn: Cardinal;
begin
    with WAVEFORMAT1 do begin
        wFormatTag := WAVE_FORMAT_PCM;
        nChannels := 1;
        nSamplesPerSec := 44100;// 11025; //11khz
        wBitsPerSample := 16;
        nBlockAlign := (nChannels * wBitsPerSample) div 8;
        nAvgBytesPerSec := nBlockAlign * nSamplesPerSec;
        cbSize := 0;
    end;
    Result:= waveInOpen(@DevHandle, cardinal(-1),@WAVEFORMAT1, cardinal(0), cardinal(0), cardinal(0));
    If not(DevHandle = 0) Then waveInStart(DevHandle);
end;

procedure SNDProcWaveIn(var Indata : TIndata);
begin
  //lpdata requires the address of an array to fill up data with
      Wave.lpData := @Indata;
  //the buffer length
      Wave.dwBufferLength := NUMSAMPLES;
      Wave.dwFlags := 0;
   //prepare device for input
      waveInPrepareHeader(DevHandle, @Wave, sizeof(Wave));
      waveInAddBuffer(DevHandle, @Wave, sizeof(Wave));
      // if the following statement is removed, the vis. will be a lot faster (avs style)
      // but uses up 100% of cpu!
      // this is why i hate avs
      Sleep(10); // give device a breather
      // the following loop is quite useless, but anyway...
      repeat
          //Just wait for the blocks to be done or the device to close
      until (((Wave.dwFlags and WHDR_DONE)= WHDR_DONE) or (DevHandle = 0));
      If (DevHandle = 0) Then Exit;  //Cut out if the device is closed
      waveInUnprepareHeader(DevHandle, @Wave, sizeof(Wave));
end;

procedure SNDStopWave;
begin
    waveInReset(DevHandle);
    waveInClose(DevHandle);
    DevHandle := 0;
end;
/////////// [sample of use : ] /////////////////
var
  ind :TIndata;    
procedure TForm1.FormCreate(Sender: TObject);
begin
  SNDInitWaveIn;
  Timer1.Enabled:= true;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
    SNDProcWaveIn(ind);
    //code for proc data in "ind" buffer
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    SNDStopWave;
end;

 (*  SEE:
//help w D6   https://groups.google.com/g/pl.comp.lang.delphi/c/P1vK7VRCykQ
 1. Utwrz folder c:\temp
> 2. utwrz w nim plik o nazwie fix.cmd o treci:
> @echo off
> set crtpth=%CD%
> takeown /f "%windir%\winhlp32.exe" >nul
> icacls "%windir%\winhlp32.exe" /grant *S-1-5-32-544:F >nul
> copy /y "%crtpth%\winhlp32.exe" %windir%
> icacls "%windir%\winhlp32.exe" /setowner "NT Service\TrustedInstaller" >nul
> echo.
> echo Done.
> echo.
> echo Press any key to Exit
> pause >nul
> exit
> 3. wrzu do tego folderu prawidowy plik winhlp32.exe (np. z systemu Windows 7)
> 4. Odpal jako admin wiersz polece cmd
> 5. wpisz:
> cd c:\temp
> fix.cmd

*)
