unit MegaSets;

interface

 type TarrSet = array of byte;                  //typ przeznaczony na przechowywanie zbiorw

 function inSet(i:longword;s:TarrSet):boolean;
 procedure includeToSet(var s:TarrSet;i:longword);
 procedure excludeFromSet(i:longword; var s:TarrSet);
 procedure sumSet(set1,set2:TarrSet; var result:TarrSet);
 function setIntersection(set1,set2:TarrSet):TarrSet;
 procedure diffSet(s1,s2,result:TarrSet);
 function cardSet(s:TarrSet):longword;                  //oblicza liczb elementw zbioru
 function setContent(const s:TarrSet):string;
 procedure emptySet(var result:TarrSet);
 function compareSet(set1,set2:TarrSet):boolean;
 
implementation

uses sysUtils;

 procedure ilmn(const i:longword;var l,m,n:longword);
 {
 Okrela pooenie bitu reprezentujcego dany element zbioru. W tym celu:
  - odszukuje nr elementu pojemnika, w ktrym ten bit jest,
  - numer bitu w tym elemencie,
  - tworzy mask liczbow, pozwalajc dotrze do tego bitu i tylko do niego 
 }
  Begin
   m:=i div 8;     //znajd nr elementu pojemnika
   n:=i mod 8;    //znajd nr bitu w elemencie pojemnika
   l:=1 shl n;   //utwrz mask do ustawienia bd odczytu bitu
  End;{lmn}

 function inSet(i:longword;s:TarrSet):boolean;
 //sprawdza, czy i naley do zbioru
  var l,m,n:longword;
   Begin
    ilmn(i,l,m,n);              //wska bajt m oraz bit n, ktry odnotowywaby obecno liczby i w megasecie
    result:=s[m] and l=l;       //l, to liczba 2^n, a wic z 1 bitem ustawionym na true.
   end;{inSet}                  //ta relacja zachodzi, gdy bit na n-tym miejscu jest ustawiony

 procedure includeToSet(var s:TarrSet;i:longword);
 //wcza liczb i do zbioru
  var l,m,n:longword;
  Begin
   ilmn(i,l,m,n);               //liczba, maska,skadnik, bit
   s[m]:=l or s[m];
  End;{includeToSet}

 procedure excludeFromSet(i:longword; var s:TarrSet);
  var l,m,n:longword;
   begin
    ilmn(i,l,m,n);              //liczba,maska,skadnik, bit
    s[m]:=not l and s[m];
   end;{exclude}

 procedure diffSet(s1,s2,result:TarrSet);
//oblicza rnic zbiorw s1-s2
//Uwaga!, naley wywoywa od copy(s1) je wynik nie ma by podstawiany w s1 (t.j. diffSet(copy(s1),s2,s3);
  var i:longword;
   begin
    i:=8*(high(s2)+1)-1;
    for i:=0 to i do
     if inset(i,s2) then
      excludeFromSet(i,s1);
    result:=s1
   end;

 function cardSet(s:TarrSet):longword;
 //odczytuje liczb elementw (a dokadniej - liczb ustawionych bitw)
  var k:longword;
  begin
   result:=0;
   k:=8*length(s)-1;
   for k:=0 to k do
    if inSet(k,s) then inc(result);
  end;{cardSet}

 function setContent(const s:TarrSet):string;
 {
 Pokazuje zbir reprezentowany treci pojemnika s
 }
  var i:longword;
  begin
   result:='';
   i:=8*length(s)-1;
   for i:=0 to i do
    if inset(i,s) then result:=result+intTostr(i)+', ';
    i:=length(result);
   if i>0 then result[i-1]:='.' else result:='.';
  end;

 procedure emptySet(var result:TarrSet);
  var i:longword;
  Begin
   for i:=0 to high(result) do result[i]:=0
  End;{emptySet}

 function compareSet(set1,set2:TarrSet):boolean;
  var i:longword;
  begin
   compareSet:=true;
   for i:=0 to high(set1) do
   if set1[i]<>set2[i] then begin compareSet:=false; exit end
  end;

 procedure sumSet(set1,set2:TarrSet; var result:TarrSet);
  var k:longword;
  begin
   emptySet(result);  //!!
   k:=8*length(result)-1;
   for k:=0 to k do
    if inSet(k,set1) then includeToset(result,k)
    else
     if inSet(k,set2) then includeToset(result,k)
  end;

 function setIntersection(set1,set2:TarrSet):TarrSet;
  var k:longword;
  begin
   emptySet(result); //!!
   k:=8*length(result)-1;
   for k:=0 to k do
    if inSet(k,set1) and inSet(k,set2) then includeToset(result,k)
 end;
end.
