unit Unit2;

interface
uses unit1,types,ExtCtrls, Graphics, forms,VQUnit,sysutils;

 var
  wspx1,wspy1,topHeight1, wspx2,wspy2,topHeight2, wspx3,wspy3,topHeight3, wspx4,wspy4,topHeight4, wspx5,
                                         wspy5,topHeight5, wspx6,wspy6topHeight6,wspx7,wspy7,topHeight7 : double;   //wspczynniki proporcjonalnoci dla poszczeglnych paneli
            cath1IRmax,cath2IRmax,cath3IRmax,IRstretch,cath1ErrMax,cath2ErrMax,cath3ErrMax,errStretch : double;
             txtStretch : smallInt;
IRdrawings : procedure (Panel:TPanel;canvas:tcanvas;const classNbr:Word; const  prevX,currX:double;
                      var prevY:double; currY:double; const wspy,topHeight:double; const lineColor:longInt);

 function GetColor(i:longWord):Tcolor;
 procedure curvesColors;
 procedure IRframe(Panel:TPanel;canvas:tcanvas;const classNbr:Word; const stretch:double; ceil1,ceil2,ceil3:double; out wspx,wspy,topHeight:double);
 procedure IRdrawings_clipped(Panel:TPanel;canvas:tcanvas;const classNbr:Word; const  prevX,currX:double;
                      var prevY:double; currY:double; const wspy,topHeight:double; const lineColor:longInt);
 procedure IRdrawings_noClipping(Panel:TPanel;canvas:tcanvas;const classNbr:Word; const  prevX,currX:double;
                      var prevY:double; currY:double; const wspy,topHeight:double; const lineColor:longInt);
 procedure VertLine(const panel:Tpanel; const cl:longint;const currX:double);
 procedure showSpkInputRecord(const cath2,cath1,cath3:char; const count:word);
 procedure showTxtInputRecord(const cath2,cath1,cath3:char;const txtStretch:smallInt);
 procedure showModifiedSpkInput;
 procedure showModifiedTxtInput;
implementation
 var
     centr2,centr3,centr4,centr5: integer;                              //centra pionowe dla poszczeglnych paneli

 function GetColor(i:longWord):Tcolor;
 begin
   case i of
    0: result:=clBlack;
    1: result:=clWhite;
    2: result:=clBlue;
    3: result:=clFuchsia;
    4: result:=clYellow;
    5: result:=clTeal;
    6: result:=clRed;
    7: result:=clAqua;
    8: result:=clLime
    else result:=0;
   end
 end;{GetColor}

procedure curvesColors;
 begin
   with form1 do     //kolory linii wykresw
   begin
   if byte(checkBox2.Checked)+byte(checkBox3.Checked)+byte(checkBox4.Checked)=1 then
    begin
     cl1:=GetColor(perfCounter mod 9);
     cl2:=cl1; cl3:=cl1; cl4:=cl1; cl5:=cl1;
     if ovrGraphs then checkBox10.Checked:=true;
     label56.Caption:='Distortion; curve nbr:';
     Application.ProcessMessages;//bo nie pojawia si pierwszy numer wykresu - 0.
     canvas.font.color:=getColor(perfCounter mod 9);
     canvas.Font.Style:=[fsBold];
     canvas.TextOut(round((perfCounter mod 9)*20+label56.left+length(label56.Caption)*label56.Font.Size/1.35),label56.Top, intToStr(perfCounter))
    end
   else
    begin
     cl1:=clblue; cl2:=clRed; cl3:=clgreen; cl4:=clBlack; cl5:=clBlack;
     label56.Caption:='Distortion (average distance over the tree leaves)';
    end;
   label57.Visible:=checkBox2.Checked;
   label58.Visible:=checkBox3.Checked;
   label59.Visible:=checkBox4.Checked;
  end;{with}
  ovrGraphs:=false;
 end;

 procedure IRframe(Panel:TPanel;canvas:tcanvas;const classNbr:Word; const stretch:double; ceil1,ceil2,ceil3:double; out wspx,wspy,topHeight:double);
  //Wykrela ramki pokazujce pole wykresu
  //strech - zakres zmiennoci y
  //wspx,wspy - wspczynniki proporcjonalnoci dla okna
  //ceil - grne ograniczenie wykresu
  var leftWidth :double;  str:string; maxCeil:double;

  procedure ceilDraw(const ceil:double);
   begin
    canvas.moveTo(panel.left,round(ceil));                   //--------------------ten kolor nie jest aktywowany!
    canvas.lineTo(round(leftwidth),round(ceil));
   end;

  begin
   with Panel,canvas do
    begin
     leftWidth:=left+Width;   topHeight:=top+Height;
     try
      wspy:=(height)/stretch;
     except
      wspy:=1.7e308
     end;
     if panel=form1.panel3 then    //okreli pooenie etykiety najwyszego progu na wykresie IR
      begin
       if ceil1>ceil2 then maxCeil:=ceil1 else maxCeil:=ceil2;
      if maxCeil<ceil3 then maxCeil:=ceil3;
      end;
     ceil1:=topHeight-ceil1*wspy; ceil2:=topHeight-ceil2*wspy; ceil3:=topHeight-ceil3*wspy;
     if classNbr=0 then wspx:=0 else wspx:=width/classNbr;
     Pen.Color:=clblack;                                           //------------------------------------a ten jest!
     Rectangle(left-10,top-10,round(leftWidth+10), round(topHeight+10));                     Application.ProcessMessages;
     Pen.Color:=clwhite;
     Rectangle(left-8,top-8,round(leftWidth+9), round(topHeight+9));                          Application.ProcessMessages;
     Pen.Color:=clgray;
     Rectangle(left-2,top-2,round(leftWidth+2), round(topHeight+2));                          Application.ProcessMessages;
     Pen.Color:=clwhite;
     Rectangle(left,top,round(leftWidth), round(topHeight));                                  Application.ProcessMessages;
     Pen.Color:=clblue;  if form1.checkBox2.checked then ceilDraw(ceil1);       Application.ProcessMessages;//linie wyznaczajce grne ograniczenia wykresw: cath1
     Pen.Color:=clred;   if form1.checkBox3.checked then ceilDraw(ceil2);       Application.ProcessMessages;//                                                cath2
     Pen.Color:=clgreen; if form1.checkBox4.checked then ceilDraw(ceil3);       Application.ProcessMessages;//                                                cath3
     if panel=form1.panel3 then str:=floatToStrF(stretch,ffNumber,6,4)
     else str:=intToStr(round(stretch));
     if panel=form1.panel3 then TextOut(round(leftWidth)+15,round(topHeight-maxCeil*wspY)+font.Height,'          ')
     else TextOut(round(leftWidth)+15,top+font.Height,'          ');    //wyczy pole tekstowe (ma znaczenie dla error i card przy przerwaniach i insertach)
     if panel = form1.panel4 then str:=str+'%';                   //bd poda w %
     if panel=form1.panel3 then TextOut(round(leftWidth)+15,round(topHeight-maxCeil*wspY)+font.Height,str)
     else TextOut(round(leftWidth)+15,top+font.Height,str);
     TextOut(round(leftWidth)+15,round(topHeight)+font.Height,'0');
    end;
   application.processmessages;
  end;{IRframe}

  function interX(x1,x2,y,y1,y2:double):double;
   begin
    result:=((y-y1)*(x2-x1)+(y2-y1)*x1)/(y2-y1);
   end;


 procedure IRdrawings_clipped(Panel:TPanel;canvas:tcanvas;const classNbr:Word; const  prevX,currX:double;
                      var prevY:double; currY:double; const wspy,topHeight:double; const lineColor:longInt);
 //wykresy biecych wartoci IR lub error lub distortion
 //strech - zakres Y,
 //prevX,prevY - wsporzdne poprzeniego punktu (poprzednia warto step i IR) nieskalowane Y!
 //currX,currY - wsporzdne biecego punktu (warto step i IR)              nieskalowane Y!
  var prevYwspY,currYwspy,tY:double;
      newX,newY:word;
  Begin
   with panel,canvas do
   begin
    Pen.Color:=lineColor;
    currYwspy:=currY*wspy;  prevYwspY:=prevY*wspY;
    prevY:=topHeight-prevYwspy;               //skalowa prevY; prevX:=(step-1)*wspx+left;    10.04.09
    tY:=currY;                                //zapaminieskalowan currY
    currY:=topHeight-currYwspy;               //skalowa currY
    with canvas do                            //currX:=step*wspx;             10.04.09
    if (prevY>=top) and (prevY<=topHeight) then moveTo(round(prevX),round(prevY)) //punkt docelowy jest w zakresie
    else
    Begin //------------------------------------------------------move clipping-----------
     if (currY>=top) then                                                     //punkt docelowy poniej grnej ramki
     if (prevY<top) then                                                          //start powyej grnej ramki
      begin
       newX:=round(interX(prevX,currX,top,prevY,currY));                      (*dla debug*)
       newY:=top;
       moveTo(newX,newY);
     end;
     if (currY<=topHeight) then                                               //punkt docelowy powyej  dolnej ramki
     if (prevY>topHeight) then                                                    //start poniej dolnej ramki
     begin
      newX:=round(interX(prevX,currX,Height,prevY,currY));                 (*dla debug*)
      newY:= ROUND(topHeight);
      moveTo(newX,newY);
     end;
    End;  //-------------------------------------------------------------------------------

    if (currX<=width+left) then
     Begin
      if (currY>=top) and (currY<=topHeight)  then canvas.lineTo(round(currX),round(currY))         //punkt docelowy jest w zakresie
      else
       begin   //=====================================line clipping==================================
         prevY:=topHeight-prevYwspy;
        if (prevY>top) and (currY<top) then                //punkt docelowy powyej  ramki
         begin
          newX:=round((interX(prevX,currX,top,prevY,currY)));
          canvas.lineTo(newX,top);
         end;
        if (prevY>top) and (currY>topHeight) then                //punkt docelowy poniej ramki
         begin
          newX:=round((interX(prevX,currX,topHeight,prevY,currY)));
          canvas.lineTo(newX,round(topHeight)); //punkt docelowy poniej ramki
         end;
       end;{else}
     End;
   end;{with}
    prevY:=tY;
  End; {IRdrawings_clipped}

 procedure IRdrawings_noClipping(Panel:TPanel;canvas:tcanvas;const classNbr:Word; const  prevX,currX:double;
                      var prevY:double; currY:double; const wspy,topHeight:double; const lineColor:longInt);
 //wykresy biecych wartoci IR lub error lub distortion
 //strech - zakres Y,  prevX,prevY - wsporzdne poprzeniego punktu (poprzednia warto step i IR)

  Begin
   with panel,canvas do
   begin
    Pen.Color:=lineColor;
    prevY:=topHeight-prevY*wspy;
    with canvas do
    moveTo(round(prevX),round(prevY));
    prevY:=currY;
    currY:=currY*wspy;
    currY:=topHeight-currY;  //currX:=currX+left;             10.04.09
    canvas.lineTo(round(currX),round(currY));
   end;
  End;{IRdrawings_noClipping}

  procedure frame(Pane:TPanel;canvas:tcanvas;const dataBlockLength:longWord; const stretch:double;  out wspx,wspy:double; out centr:integer);
  //Wykrela ramki pokazujce pole wykresu
  //wspx,wspy - wspczynniki proporcjonalnoci dla okna
  //centr - rodek w pionie pola rysunku
  var leftWidth,topHeight:integer;
  begin
   with Pane,canvas do
    begin
     leftWidth:=left+Width;   topHeight:=top+Height;
     centr:=round(top+height/2);
     wspy:=(height)/stretch;
     wspx:=width/dataBlockLength;
     Pen.Color:=clblack;                                           //------------------------------------a ten jest!
     Rectangle(left-10,top-10,leftWidth+10, topHeight+10); Application.ProcessMessages;
     Pen.Color:=clwhite;
     Rectangle(left-8,top-8,leftWidth+9, topHeight+9);     Application.ProcessMessages;
     Pen.Color:=clgray;
     Rectangle(left-2,top-2,leftWidth+2, topHeight+2);     Application.ProcessMessages;
     Pen.Color:=clwhite;
     Rectangle(left,top,leftWidth, topHeight);             Application.ProcessMessages;
     Pen.Color:=clwhite;
     moveTo(left,centr);                                           //--------------------ten kolor nie jest aktywowany!
     lineTo(left+width,centr);                             Application.ProcessMessages;
     moveTo(left,centr);                                   Application.ProcessMessages;
    end;
   application.processMessages;
  end;{frame}

  procedure OscDraw(panel:tpanel;canvas:tcanvas; const y:array of smallInt; wspx,wspy : double; centr:integer;
  const count:longWord; const clear:boolean;const chartColor:longInt; const cath2,cath1,cath3:char);
//---------------------oscylogram danych wave    var Yzero,wagi,xr,yi : rAryType;
var
      i : longWord;
      j : integer;
    label e1;
  begin if not form1.CheckBox13.Checked then exit;//poka grafik
   panel.Visible:=clear;
   panel.Visible:=false;
   with panel do
    begin
     j:=centr;
     if j<top then goto e1;
     if j>top+Height then goto e1;
     form1.Canvas.Pen.Color:=clwhite;
     form1.Canvas.moveTo(round(nc*wspx+left),top);
     form1.canvas.LineTo(round(nc*wspx+left),top+height);
     form1.Canvas.TextOut(left+width-35,top-25,'           ');
     form1.Canvas.TextOut(left+width-35,top-25,cath1+', '+cath2+', '+cath3);
     form1.Canvas.moveTo(left,centr);                                           //--------------------ten kolor nie jest aktywowany!
     form1.Canvas.lineTo(left+width,centr);
e1:  form1.Canvas.moveTo(left,centr);
     form1.Canvas.Pen.Color:=chartColor;
    end;
   application.processMessages;
   for i:=0 to count-1 do with Panel do
    begin
     j:=round(-y[i]*wspy+centr);
     if j<top then j:=top;
     if j>top+Height then j:=top+Height;
     canvas.LineTo(round(i*wspx+left),j);
     application.processMessages;                  //Uwaga! skasuje narysowany oscylogram, jeli wczeniej nie wywoano jeszcze processmessages
    end;{for}
  end;{OscDraw}

 procedure SpkDraw(panel:tpanel;canvas:tcanvas; const y:array of smallInt; wspx,wspy:double; centr:integer;
  const count:longWord; const clear:boolean;const chartColor:longInt);
//---------------------oscylogram danych wave    var Yzero,wagi,xr,yi : rAryType;
var
    i : longWord;
    j : integer;
label e1;
  begin if not form1.CheckBox13.Checked then exit;//poka grafik
   panel.Visible:=clear;
   panel.Visible:=false;

   with panel do
    begin
     j:=centr;
     if j<top then goto e1;
     if j>top+Height then goto e1;
     form1.Canvas.Pen.Color:=clwhite;
     form1.Canvas.moveTo(left,centr);                                           //--------------------ten kolor nie jest aktywowany!
     form1.Canvas.lineTo(left+width,centr);
e1:  form1.Canvas.moveTo(left,centr);
     form1.Canvas.Pen.Color:=chartColor;
    end;
   application.processMessages;
   for i:=0 to count-1 do with Panel do
    begin
     j:=round(-y[i]*wspy+centr);
     if j<top then j:=top;
     if j>top+Height then j:=top+Height;
     canvas.LineTo(round(i*wspx+left),j);
     application.processMessages;                  //Uwaga! skasuje narysowany oscylogram, jeli wczeniej nie wywoano jeszcze processmessages
    end;
  end;{SpkDraw}

 procedure VertLine(const panel:Tpanel; const cl:longint;const currX:double);
 {
 draws vertical line pointing step, when all cathegorical values have their own representative set
 }
  begin
   with form1,panel do
    begin
     Canvas.Pen.Color:=cl;
     Canvas.moveTo(round(currX),top+height);
     Canvas.lineTo(round(currX),top);
    end;
  end;

 procedure showSpkInputRecord(const cath2,cath1,cath3:char;const count:word);
  var count_cp:word;
  Begin
    with form1,inputRecord do
   begin
    count_cp:=count div 2;
    Frame(Panel2,canvas,count-1,high(word),wspx2,wspy2,centr2);
    Frame(Panel3,canvas,count_cp-1,13,wspx3,wspy3,centr3);
    OscDraw(panel2,canvas,signal,wspx2,wspy2*1.5,centr2,count,false,clblue,cath2,cath1,cath3);                                     //waony oscylogram okienka
    SpkDraw(panel3,canvas,powerSpectr,wspx3,wspy3/950,centr3+round(panel3.Height/4.4),count_cp,true,clblue);      //wykres spektrum; centr+round(panel3.Height/1.75) - eksperymentalne obnienie wykresu dla neperw
    SpkDraw(panel3,canvas,smoothedSpectr,wspx3,wspy3/1600,centr3+round(panel3.Height/4.5),count_cp,false,clblack);//- odwrcone cepstrum - spektrum wygadzone
    SpkDraw(panel3,canvas,melSmoothSpectr,wspx3,wspy3/1000,centr3+round(panel3.Height/5.5),count_cp,false,clred); //spektrum wygadzone po transformacji do meli
    if form1.CheckBox32.Checked then      //wide cpstr
    begin                                                                           //krel poszerzone cepstrum
    Frame(Panel4,canvas,nc-1,high(word) div 2,wspx4,wspy4,centr4);  //krel poszerzone cepstrum
    SpkDraw(panel4,canvas,powerCepstr,wspx4,wspy4,centr4+round(panel4.Height/5.5),nc,true,clblue);                               //cepstrum mocy
    SpkDraw(panel4,canvas,melCepstr,wspx4,wspy4,centr4+round(panel4.Height/5.5),nc,false,clred);                                //cepstrum mocy na melach
    end
    else
    begin
    Frame(Panel4,canvas,count_cp-1,high(word) div 2,wspx4,wspy4,centr4);
    SpkDraw(panel4,canvas,powerCepstr,wspx4,wspy4,centr4+round(panel4.Height/5.5),count_cp,true,clblue);                               //cepstrum mocy
    SpkDraw(panel4,canvas,melCepstr,wspx4,wspy4,centr4+round(panel4.Height/5.5),count_cp,false,clred);                                //cepstrum mocy na melach
    end;
   end;
  End;{showSpkInputRecord}

 procedure showTxtInputRecord(const cath2,cath1,cath3:char;const txtStretch:smallInt);  
  var  i:byte;
  Begin
    with form1,dataRecord do
   begin
    Frame(Panel2,canvas,nc-1,2*txtStretch,wspx2,wspy2,centr2);
    OscDraw(panel2,canvas,vect,wspx2,wspy2,centr2,nc,false,clblue,cath2,cath1,cath3);                                     //waony oscylogram okienka
   end;
  End;{showTxtInputRecord}

 procedure meanInputDraw(panel:tpanel;canvas:tcanvas; const y:TmeanVector; wspx,wspy:double; centr:integer;
  const count:longWord; const clear:boolean;const chartColor:longInt);
//---------------------wykres strumienia urednionego
//Rni si od spkDraw typem y - jest double, co zapobiega koniecznoci zaokrglonego przeadowywania tablic
var
    i : longWord;
    j : integer;
label e1;
  begin if not form1.CheckBox13.Checked then exit;//poka grafik
   panel.Visible:=clear;
   panel.Visible:=false;

   with panel do
    begin
     j:=centr;
     if j<top then goto e1;
     if j>top+Height then goto e1;
     form1.Canvas.Pen.Color:=clwhite;
     form1.Canvas.moveTo(left,centr);                                           //--------------------ten kolor nie jest aktywowany!
     form1.Canvas.lineTo(left+width,centr);
e1:  form1.Canvas.moveTo(left,centr);
     form1.Canvas.Pen.Color:=chartColor;
    end;
   application.processMessages;
   for i:=0 to count-1 do with Panel do
    begin
     j:=round(-y[i]*wspy+centr);
     if j<top then j:=top;
     if j>top+Height then j:=top+Height;
     canvas.LineTo(round(i*wspx+left),j);
     application.processMessages;                  //Uwaga! skasuje narysowany oscylogram, jeli wczeniej nie wywoano jeszcze processmessages
    end;
  end;{meanInputDraw}

 procedure showModifiedSpkInput;
 //wywietla dane po ojciu redniej czasowej i redni czasow
  var i,count:word;
  Begin
   with form1 do
    begin
     if checkBox32.Checked  then count:=nc else count:=128;
     Frame(Panel7,canvas,count-1,high(word) div 2,wspx5,wspy5,centr5);                                                                          //krel poszerzone cepstrum
     meanInputDraw(panel7,canvas,meanVector,wspx5,wspy5,centr5+round(panel7.Height/5.5),count,true,clblack);                         //redni czasowa
     SpkDraw(panel7,canvas,dataRecord.vect,wspx5,wspy5,centr5+round(panel7.Height/5.5),count,false,form1.Label101.Color);   //cepstrum|spektrum po odjciu redniej czasowej
    end;
  End;{showModifiedSpkInput}

 procedure showModifiedTxtInput;
 //wywietla dane po ojciu redniej czasowej i redni czasow
  var i,count:word;
  Begin
   with form1 do
    begin      //frame(Pane:TPanel;canvas:tcanvas;const dataBlockLength:longWord; const stretch:double;  out wspx,wspy:double; out centr:integer);
     if checkBox32.Checked  then count:=nc else count:=128;
     Frame(Panel7,canvas,count-1,txtStretch,wspx5,wspy5,centr5);                                                                          //krel poszerzone cepstrum
     meanInputDraw(panel7,canvas,meanVector,wspx5,wspy5,centr5+round(panel7.Height/5.5),count,true,clblack);                         //redni czasowa
     SpkDraw(panel7,canvas,dataRecord.vect,wspx5,wspy5,centr5+round(panel7.Height/5.5),count,false,form1.Label101.Color);   //cepstrum|spektrum po odjciu redniej czasowej
    end;
  End;{showModifiedSpkInput}

Initialization
 IRdrawings :=IRdrawings_clipped;
end.




 procedure sentencesDirListDirFix;
 {
 okreli pooenie pliku sentencesDirList, z ktrego, w procedurze phonListRead, odczytywana jest lista fonemw
 }
   Begin
    //openDialog(form1.OpenDialog1,sentencesDirListDir,5,'Wska plik z list plikw Corpory (*.TXT)',form1.edit12);
    if fileexists(sentencesDirListDir) then
      begin
       assignFile(dirListFile,sentencesDirListDir);
       reset(dirListFile);
      end
     else
      begin
       repeat
        showMessage ('Plik o nazwie '+sentencesDirListDir+' nie istnieje,'#13#10+'(plik ma zawiera list 3'+
         ' ostatnich liter w nazwie pliku wypowiedzi, tre wypowiedzi  oraz list znakw fonematycznych'+
         ' poprzedzon wierszem o treci'#13#10'"Lista fonemw (37+3)"');
        //openDialog(form1.OpenDialog1,sentencesDirListDir,5,'Wska plik z list plikw Corpory (*.TXT)',form1.edit12);
       until fileexists(sentencesDirListDir);
       assignFile(dirListFile,sentencesDirListDir);
       reset(dirListFile);
      end;
     writeln(reportFile,'Sentences list directory: ',sentencesDirListDir);
    End;{sentencesDirListDirFix}

procedure phonListRead(out phonNbr:byte);
{Procedura czytania danych dla bazy Corpora
     eventPhon : array of char;             //lista przypisujca fonemy zdarzeniom; fonemy s zakodowane umownymi znakami
   eventPerson : array of byte;             //lista przypisujca osoby zdarzeniom; osoby s zakodowane numerami
    personList : of string[9];              //lista osb odczytana z pliku GrochScan.txt
     zdarzenia : wektory cepstralne
# - znak oznaczajcy wszystkie znaki spoza danego zbioru znakw kodujcych fonemy
}

 var   s:shortString;
       z:char;
       i:byte;

procedure error1;
var s : string;
Begin
 s:='Error 1:'#13#10'W pliku '+sentencesDirListDir+'nie napotkano obowizkowego wiersza o treci'#13#10'"Phoneme list (37+3)",'+
  #13#10'po ktrym, na kocu tekstu, powinna wystpi lista uytych w opisie bazy "Corpora" fonemw'+
  #13#10'Program zostanie przerwany'+#13#10'End of the error 1 description.';
 showMessage(s);
 writeln(reportFile,s);
 flush(reportFile);
 halt;
End;

 procedure error2;
 var s : string;
  Begin
   s:='Error 2:'#13#10'W wykazie fonemw, w wierszu nr '+intToStr(i)+'o treci "'+s+'", odczytano tekst zawierajcy '+
     intToStr(length(s))+' znakw, czyli wicej, ni 1 znak.'+#13#10'Tu powinien by 1 znak w wierszu.'#13#10+
     '(Z kadego wiersza tej listy zawsze pobierany jest pierwszy znak i doczany do zbioru fonemw. W tym'+
     ' wypadku bdzie to "'+z+'", a pozostae znaki tego wiersza zostan pominite.)'+
     #13#10'End of the error 2 description.';
   showMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
  End;

  procedure error3;
  var s : string;
   Begin
    s:='Error 3:'#13#10'Na pozycji '+intToStr(i)+' listy '+sentencesDirListDir+' napotkano znak "'+z+'",'#13#10+
    'ktry ju wczeniej zosta na niej znaleziony.'#13#10'Sprawd, czy lista ta jest poprawnie napisana.'+
    #13#10'End of the error 3 description.';
   ShowMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
   End;

  procedure error4;
  var s : string;
   Begin
    s:='Error 4: '#13#10'There is something wrong with "'+sentencesDirListDir+
     '".'#13#10'It does not match Corpora''s data;'+
     #13#10' personNbr<>i; personNbr='+intToStr(personNbr)+', and i='+intToStr(i)+
     '.'#13#10'These values should be equal; ask the author or check "'+sentencesDirListDir+
     #13#10'End of the error 4 description.';
    showMessage(s);
    writeln(reportFile,s);
    flush(reportFile);
   End;

  procedure error24(const i:byte; const z:char);
  var s : string;
   Begin
    s:='Jest rnica pomidzy zbiorem kodw osb utworzonym na etapie czytania danych,'#13#10+
     'a zbiorem utworzonym w wyniku czytania katalogu "'+sentencesDirListDir+'" na pozycji '+intToStr(i)+
     '. Znaku ['+z+'] tam nie byo!'+#13#10'End of the error 24 description.';
    showMessage(s);
    writeln(reportFile,s);
    flush(reportFile);
   End;

 Begin   //--------------------------------------phonListRead----------- ! CORPORA ! ----------------
  sentencesDirListDirFix;                                  //okreli pooenie pliku sentencesDirList
  for i:=1 to 9 do readln(dirListFile,s);                  //doj do listy osb
  i:=0;    s:='';
  while not seekeof(dirListFile) do     //czyta i kodowa nazwy osb
   begin
    readln(dirListFile,s);
    if (s='') or (s='sentence list')  then break;
    personNameList[i]:=s;
    z:=s[1];
    personCodeList[i]:=char(i);
    if not (z in personSet) then begin include(personSet,z); error24(i,z) end;
    inc(i);
   end;{while}
  if i<>personNbr then error4;
  personNbr:=i;
  repeat                                                   //doj do listy fonemw
   readln(dirListFile,s);
  until (s='Phoneme list (37+3)') or eof(dirListFile);
  if s<>'Phoneme list (37+3)' then error1;
  i:=0;  phonSet:=[];
  phonList[0]:=#0; phonHash[#0]:=0;                        //# znak oznaczajcy wszystkie znaki spoza danego zbioru znakw kodujcych fonemy
  repeat
   readln(dirListFile,s);
   z:=s[1];
   if length(s)<>1 then error2;
   if not (z in phonSet) then
    begin
     inc(i);
     phonList[i]:=z;                                       //dekoder znakw fonematycznych
     phonHash[z]:=i;                                       //koder znakw fonematycznych
     include(phonSet,z);
    end
   else error3;
  until eof(dirListFile);
  phonNbr:=i;
  form1.edit9.Text:=intToStr(phonNbr);
  form1.edit10.Text:=intToStr(personNbr);
  form1.edit11.Text:=intToStr(voicingCathNbr);
 End;{phonListRead}

