﻿unit VQUnit;

interface
uses windows,math,dialogs,StdCtrls,messages,Forms,sysUtils,controls, ExtCtrls,megasets,classes,Graphics;

 const
       rareEventNbr1 : integer=2;
       rareEventNbr2 : integer=2;
         WaveFileDir : shortstring ='C:\APL\Waver\results\*.wav';
        eventFileDir : string     ='C:\APL\Spectrum\results\*.spk';           //położenie pliku z przekrojami spektralnymi (plik zdarzeń)
   cath2EventFileDir : string     ='C:\APL\Spectrum\results\Joined.pers';          //położenie pliku osobników (2-gi klasyfikator)
 sentencesDirListDir : string     ='C:\apl\WAVER\data\GrochScan.txt';              //plik z listą plików Corpora, listą osób i fonemów
         treeFileDir : string     ='C:\apl\LVQ\Results\tree.vq';                   //plik wynikowy - drzewo kwantujące
       reportFileDir : string     ='C:\apl\LVQ\Results\report.txt';
          programDir : string     ='C:\apl\LVQ\LVQInit.txt';
     LVQinitFileLogo : shortString='LVQ Init File';
                  nc : integer=16;                                                 //liczba uwzględnianych składowych wektorów cech zdarzeń
            cath2Nbr : byte=45;
            cath1Nbr : byte=40;
            cath3Nbr : byte=2;
    reportFileOpened : boolean=false;
            dataread : boolean=false;
           interrupt : boolean=false;
         stopReading : boolean=false;
   BreakReadingPoint : integer=0;
      parametersSize = 128;
 Type
  realtype = double;
  T128SmallIntArr = array[0..parametersSize] of smallInt;
  T255SmallIntArr = array[0..255] of smallint;
      TmeanVector = array[0..parametersSize] of double;           //wektor do przechowywania śreadniej
         THistory = array[0..400] of TmeanVector;      //historia-wektory o składowych podzielonych przez stałą uśreadniania
            THist = array of longWord;
           TdbArr = array of double;
           TlwArr = array of longWord;
  T256InputRecord = record                                   // second and following records ---------------first record contains data:
                   sliceNbr : longWord;                         // portion number                                 number of portions
                     signal : T255SmallIntArr;                  // signal portion                                 portions length (FFT windows width)
                powerSpectr : T128SmallIntArr;                  // power spectrum                                  0. -  FFT weighting window nbr, 1. - cepstrum filter cut-off, 2..realTypeSize+1. -  frameStep, 3+realTypeSize+1..3+2realTypeSize+1. - rate
             smoothedSpectr : T128SmallIntArr;                  // spectrum ditto cepstral smoothed               Wave File Directory
            melSmoothSpectr : T128SmallIntArr;                  // spectr ditto after mel transform
                powerCepstr : T128SmallIntArr;                  // power cepstrum
                  melCepstr : T128SmallIntArr;                  // invers fft transf. melSmoothSpectr
        cath1,cath2,cath3 : char;                               // classifications according to                   powers sets of values of these cathegories
                    end;{record}                                //cath1, cat2 and cath3 values

            TVect = T128SmallIntArr; //było array[0..vLength] of double; 27.09.05
      TdataRecord = record
               vect : Tvect;
cath1,cath2,cath3 : char;
                    end;
          nameStr = String[7];
   // T128DoubleArr = array[0..parametersSize] of double;
 var
 CentroidsNb_glob0,CentroidsNb_glob : integer;
  heapTop,nodeHeapTop,wholeEventNbr,
                       trueEventNbr : longWord;
                             ramSum : int64;
                           initFile : text;
                         reportFile : text;
                         temp,temp1 : variant;
                                ln2 : extended;
                        InputRecord : T256InputRecord;
                          startTime : tDateTime;
                          treeSaved : boolean=false;
                            spk_txt : boolean=true;
                   breakingLeafSave : integer=0;
                     rate,FrameStep : realType;
             AveragingTime,frameNbr : integer;
                                rap : word=0;       //RAM allocation process
                             MinMax : array[0..parametersSize] of record min, max:smallInt end;
                    ResponseChecker : function(const startNode:longWord):double;
        SetChoiceDivisionEvaluation,
   FeaturesChoiceDivisionEvaluation : procedure(n:longWord; const TempHist1,TempHist2,NodeHist:Thist;
                                                 const FeatureLevelNbr:byte;const Pb:TdbArr; out delta2:double;
                                                 const k1,k2:longWord; const lb0,hb0,hb1,lb2:longWord;
                                                 const nodeAddr:word; const RadioGroup:TradioGroup; const bl:TlwArr);
                         meanVector : TmeanVector;                         //wektor do przechowywania śreadniej
                            History : THistory;                            //historia-wektory o składowych podzielonych przez stałą uśreadniania (bufor pierścieniowy)
                         dataRecord : TdataRecord;
                             Y1Name : nameStr='cath1';                     //nazwy opisowe zmiennych klasyfikującyh (do wydruków)
                             Y2Name : nameStr='cath2 ';
                             Y3Name : nameStr='cath3';
                          classKind : char;
                       clasRegister : boolean=false;
                         multStdDev : single;
                cl1,cl2,cl3,cl4,cl5 : Tcolor;
                        perfCounter : byte=0;
                             tempus : variant;
                         onceShowed : boolean=false;
                        inputFormat : byte;
                                TIC : function (out v1,v2:TmeanVector; const lb,hb:longWord; const centroid:TmeanVector; const nodeAddr:word):boolean;
                  showModifiedInput : procedure;
procedure DataPrepare;
procedure DataReading;
procedure Perform;
procedure openDialog(dialog:TOpenDialog;var s:String;const fltIdx:byte; const tit:string;edit:Tedit);
function checkDistortion(const startNode:longWord):double;
function checkcath1IR(const startNode:longWord):double;
function checkcath2IR(const startNode:longWord):double;
function checkcath3IR(const startNode:longWord):double;
function checkcath1Error(const startNode:longWord):double;
function checkcath2Error(const startNode:longWord):double;
function checkcath3Error(const startNode:longWord):double;
procedure DivisionEvaluation_distortion(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte;
           const Pb:TdbArr; out delta2:double;const k1,k2:longWord; const lb0,hb0,hb1,lb2:longWord;const nodeAddr:word; const RadioGroup:TradioGroup;const bl:TlwArr);
procedure DivisionEvaluation_Err(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte;
           const Pb:TdbArr; out delta2:double;const k1,k2:longWord; const lb0,hb0,hb1,lb2:longWord;const nodeAddr:word; const RadioGroup:TradioGroup;const bl:TlwArr);
procedure DivisionEvaluation_IR(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte;
           const Pb:TdbArr; out delta2:double;const k1,k2:longWord; const lb0,hb0,hb1,lb2:longWord;const nodeAddr:word; const RadioGroup:TradioGroup;const bl:TlwArr);
procedure inspectTreeSettings(radio:TradioGroup);
procedure error42(var i:integer; edit:Tedit;labelx:Tlabel;s:string);
procedure error51;
procedure error59(programDir:string);
procedure error60(programDir,proc:string);
procedure error61(s:string);
procedure OpenreportFile;
procedure showLeavesSetsCounts(graphRepeat:boolean);
function DelSpace(s:string):string;

implementation

uses unit1,unit2,setEdit;

type
 TDist = function (const v1,v2:TmeanVector):extended;
  Tset = set of byte;
 Tnode = record
          son,brother:smallInt;
         end;

 type

 TnodeProps = record
               centroid,nodeStDev:TmeanVector;
               iterNbr:word;
               cardinal,lb,hb:longWord;          //liczebność zbioru, adresy graniczne
               leafIdx,nodeStep:word;
               cath1Ir,cath2Ir,cath3Ir:double;
               cath1,cath2,cath3:byte;
               cath1RecErr,cath2RecErr,cath3RecErr:longWord;
               meanDistance,fissionDistance:double;
               OptComponentNbr:byte;       //CART optymalna składowa (jej numer) podziału
              end;{TnodeProps}

TcharList = array of char;
TcharByte = array[char] of byte;
 TcharSet = set of char;
 TWordArr = array of word;
T2WordArr = array of array of Word;
      TSAC = array[0..3] of int64;
TcharArray = packed array[0..2*(parametersSize+1)-1] of char;
  Tstring9 = string[9];
  var                               reportDate : shortString;
                                      wbl, sbl : TlwArr;         //lista robocza adresów (working border list), lista adresów posortowana wg przynależności zdarzeń do zbiorów (sorted border list)
                                featureUseHist : T2WordArr;      //histogram użycia cech w CART
                             featureUseCounter : TWordArr;       //licznik użyć cech w CART
                                      vectList : array of TVect;
               cath1IrGlob,distMax,deltaIRGlob,
      setChoiceCritGlob,distortion,cath2IrGlob,
                 prevDist,cath3IrGlob,tryDelta : double;
                distMaxNodeAddr,excludeSetCard : LongWord;
                                      nodeHeap : array of Tnode;
                                     nodeProps : array of TnodeProps;
                                   leafCardArr : array of longWord;
       emptyHash,cath1Hash,cath2Hash,cath3Hash : TcharByte;
                                    eventcath1 : TcharList;             //lista przypisująca fonemy zdarzeniom; fonemy są zakodowane umownymi znakami
                                    eventcath2 : TcharList;             //lista przypisująca osoby zdarzeniom; osoby są zakodowane umownymi znakami
                                    eventcath3 : TcharList;             //lista przypisująca fonemy zdarzeniom; fonemy są zakodowane umownymi znakami
                                 emptyResponse : TcharList;             //pusta lista (bez przydziału RAM!) stosowana, gdy jest wybierana dystorsja, aby podnieść pewność kodu programu
                                   dirListFile : text;
     cath1CodeList,cath2CodeList,cath3CodeList : TcharList;
                                 cath2NameList : array of Tstring9;
      nodeNbr,leafNodeNbr,iterNbr,totalIterNbr : word;                      //całkowita liczba węzłów i liści w drzewie
                         k1,k2,hb1glob,lb2glob : longWord;
     cath1NodeHist,cath2NodeHist,cath3NodeHist,
                       NodeHist_glob,emptyHist : Thist;
                       cath1H0,cath2H0,cath3H0,                             //histogramy liczebności w węźle zerowym
                           tempHist1,tempHist2 : THist;                     //chwilowe histogramy liczebności dla pure CART
            emptyIndex,cath1Pb,cath2Pb,cath3Pb : TdbArr;                    //prawdopodobieństwa empiryczne w węźle zerowym;  TdbArr = array of double;
                                     leafNodes : TlwArr;                    //skorowidz węzłów liści
                   cath1Set, cath2Set,cath3Set,
    Checkcath1Set, Checkcath2Set,Checkcath3Set : TcharSet;
                        excludeSet,leafNodeSet : TArrSet;                   //excludeSet zbiór zdarzeń rzadkich
                                      treeFile : textFile;                      //drzewo kwantujące na dysk
                                     eventFile : file of T256InputRecord;   //dane obiektów; było TdataRecord;                                         //report z przebiegu obliczeń
                                  txtEventFile : textFile;
      nodeFound,featureFound,allcath1,allcath2,
                                      allcath3 : boolean;
                                      percNorm : extended; //variancja odległości i śreadnia odległóść w zbiorze S0
           fissionCounter,step,FFTwindowsWidth,
        cath1AllStep,cath2AllStep,cath3AllStep : word;
                     hashCounter1,hashCounter2,
       hashCounter3,bestFeature,featureSetCard,
  componentNbr,globComponentNbr,lifterTreshold : byte;     //dla klasyfikacji eksperymentalnej 16.11.05; bestFeature - Pure CART, FeaturesInspectTree, bieg po liściach; zapamiętać najlepszą cechę w danym liściu
                                          dist : TDist;
                                         v1,v2 : TmeanVector;
                                    secondPass : boolean;
                                   InspectTree : procedure(startNodeIndex:longWord);
                   meanDistance1,meanDistance2 : extended;
                 cath1RecErrSum,cath2RecErrSum,
                                cath3RecErrSum : longWord;
                     cath1IRarray,cath2IRarray,
                                  cath3IRarray : TdbArr;
           cath1ClusterCount,cath2ClusterCount,
                             cath3ClusterCount,
         cath1ClusterCount1,cath2ClusterCount1,
                            cath3ClusterCount1 : TWordArr;
                        phErr,persErr,cath3Err,
              cath1CountArray, cath2CountArray,
                               cath3CountArray : TlwArr;
                                   leafCounter : word;
            prevIRcath1,prevIRpers, prevIRvoic,
            NodePrevIRcath1,NodePrevDistortion,
NodePrevIRpers,NodePrevIRvoic,NodePrevErrcath1,
  NodePrevErrPers,NodePrevErrVoic,prevErrcath1,
             prevErrPers,prevErrVoic,nodeCurrX,
          prevDistortion,prevX,NodePrevX,currX : double;
                                   singleCurve : boolean;
                                         alloc : char;
                                   sz,sk,stdev : array of double;
                                     charArray : TcharArray;
                                     centroArr : array of TdbArr;
           RowsToReportTableCaption,H0ToReport : procedure;
                                       inputer : procedure(out dataRecord:TdataRecord);
                                DataParameters : procedure(var EventNbr:longWord);
                         setClassifiersNumbers : procedure (i,j,k:byte);

  procedure error8;
  var s : string;
  Begin
   s:='Error 8, program error.'#13#10'Heap for the tree nodes is too small.'#13#10'Now heapTop='+intToStr(heapTop)+'. Its size is determinined as '+
      '2*('+form1.Label5.Caption+')+1='+intToStr(2*CentroidsNb_glob+1)+'. The error can occure in the CART or CART-like mode or in the "second pass" eliminating rare events.'+
      'In the last case try to run the program in the "second pass" alone.'#13#10'The programm should be changed, contact the author.'+
       #13#10'End of the error 8 description.';
   s:=delAmpers(S);
   ShowMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
  End;{error8}

  procedure error9(startNodeAddr:longWord);
  var s : string;
  Begin
   s:='Error 9. Błąd programu.'#13#10'Węzeł (nr '+intToStr(startNodeAddr)+
   ', od którego ma być kontynuowana rozbudowa grafu, ma już następnika!'#13#10+'To węzeł nr '+
   intToStr(nodeHeap[startNodeAddr].son)+#13#10'Program zostanie przerwany'+#13#10'End of the error 9 description.';
   ShowMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
   halt;
  End;{error9}

  function error11:byte;
   var s : string;
   begin
    s:='Error 11, step='+intToStr(step)+#13#10'Computation error (procedure DivideSet\means), one of the descendant set contains no members (k=0).'+
    #13#10'The error could arrise as an effect of dividing a set, which contained identical members,'+
    #13#10'or when switch "alloc" in the procedure DivideSet does not work properly in case when different events are equally spaced from centroids'+
    #13#10'Turn to the author in these cases'+
    #13#10'If the error appearead at the same beginning of the program execution (step=1),';
    s:=s+#13#10'then check, whether the reading of the centroids obtained in some previous execution'+
    ' was justified'#13#10'(erase file "'+treeFileDir+'"), or whether the generated set of rare events'+
    ' does not contain all events (because of too high treshold "'+ form1.mainMenu1.Items[2].Caption+'\'+
    form1.PageControl1.Pages[6].Caption+'\'+form1.Label37.Caption+'" all events were included to the rare events set).'+
    #13#10'or whether the set is not erronous  (may be it was obtained for different options!)'+
    #13#10'OK="We take the k=1 and we continue computations for (diagnostic purposes only)'+
    #13#10'End of the error 11 description.';
    s:=delAmpers(s);
    writeln(reportFile,s);
    result:=1;
    if application.MessageBox(pchar(s),pchar('Error! Continue?'),mb_yesNo)=idNo then halt;
    flush(reportFile);
   end; {error11}

    procedure error0(s:string);
     begin
      with form1 do
      s:='Error 0'#13#10'Error in the file name, ('+s+') correct  or chose from the list '+
       '(these data will be read only, don''t be afraid, you can point any existing file, the file will not be modified)'+
       #13#10'If the things are goin wrong, close the program, reopen, go to the'#13#10'"'+ mainMenu1.Items[2].Caption+'\'+
       PageControl1.Pages[1].Caption+label7.Caption +'"'#13#10'and manually write down correct path and filename'+
       ' accordingly to the DOS rules or the *.* wild sings and continue chosing the proper file from the opened list'+
       #13#10'or remove the init.txt file  or manually correct its contents. You will find the file in the same directory, where the program is located';
      messageDlg(s,mtConfirmation,[mbOK],0);
     end;

 procedure ToReportRAMinfoCaption;
  var i:byte;
  begin
   if not form1.CheckBox37.Checked then exit;
   Writeln(reportFile,#13#10'RAM allocation process-------------------------------------------'#13#10,
    'ramSum - RAM usage, n1 - number of elements before new allocation, n2 - number of elements after new allocation, size - one element size'#13#10);
   for i:=1 to 162 do Write(reportFile,'='); Writeln(reportFile);flush(reportFile);
    Writeln(reportFile,'  Nbr','variable name':23,'n1':16,'n2':17,'size':17,'RAM summ':17,'size before':16,'size after':17,'RAM increase':17,'RAM after':17);
   for i:=1 to 162 do Write(reportFile,'='); Writeln(reportFile);flush(reportFile);
  end;{IF}

 function ToReportRAMinfo(s:shortString;n1,size,n2:int64):boolean;
 {
 rap - RAM allocation process (use of setLength number)
 ramSum - RAM usage
 n1 - number of elements before new allocation
 n2 - number of elements after new allocation
 size - one element size
 }
 var n :longWord;
  Begin
   inc(n1);
   result:=n1<>n2;
   if not result then exit;
   inc(rap);  inc(ramSum,(-n1+n2)*size);
   form1.label4.Caption:=intTostr(ramSum);
   if not form1.CheckBox37.Checked then exit;
   Write(reportFile,intToStr(rap):5,'.  ',s:20,' ',intToStr(n1):15,'  ',intToStr(n2):15,'  ',intToStr(size):15,'  ',intTostr(ramSum):15);
   Writeln(reportFile,' ',intToStr(n1*size):15,'  ',intToStr(n2*size):15,'  ',intToStr((-n1+n2)*size):15,'  ',intTostr(ramSum):15);
   flush(reportFile);
  End;

 procedure openDialog(dialog:TOpenDialog;var s:String;const fltIdx:byte; const tit:string;edit:Tedit);

   Begin {---------otwiera okno openDialog--------------}
    repeat
     application.ProcessMessages;
     with Dialog do
     begin
      Title:=tit;   FilterIndex:=fltIdx;
      initialDir:=s;  fileName:=s;
      if execute then s:=fileName
     end;
     if not fileExists(s) then  error0(s);
    until fileExists(s);
    Edit.Text:=s;
    Edit.Enabled:=false;
   End;{openDialog}

 function saveDialog(dialog:TSaveDialog;var s:String; fltIdx:byte;const tit:string):boolean;

 var decision:byte;

   Begin   {---------otwiera okno saveDialog--------------}
    decision:=mrYes;
    repeat
     application.ProcessMessages;
     with Dialog do
     begin
      Title:=tit;     FilterIndex:=fltIdx;
      initialDir:=s;  fileName:=s;
      if execute then s:=fileName
     end;
     if fileExists(s) then
      begin
       decision:=messageDlg('File:'#13#10'"'+s+'"'#13#10'exists. Overwrite it?',mtConfirmation,[mbYes,mbNo,MbCancel],0);
       result:=decision=mrYes;
      end
     else result:=true;
    until result or (decision=mrCancel);
   End;{saveDialog}

 procedure HistReset;
  var j:word;
  Begin
   with form1 do
    begin
     if checkbox2.Checked then for j:=0 to cath1Nbr do cath1NodeHist[j]:=0;
     if checkbox3.Checked then for j:=0 to cath2Nbr do cath2NodeHist[j]:=0;
     if checkbox4.Checked then for j:=0 to cath3Nbr do cath3NodeHist[j]:=0;
    end;
  End;

function card(setVar:Tset):word;
//zlicza elementy zbioru
 var i:byte;
 begin
  result:=0;
  for i:=0 to 255 do if i in setVar then inc(result);
 end;

 procedure error29(result:double;i:byte);
  var s : string;
  begin
   s:='error29'#13#10'function "EuclidDist", sum of squares<0!; ='+floatToStrF(result,fffixed,10,2)+
   '; occuread at component nbr='+inttoStr(i)+#13#10'End of the error 29 description';
   showMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
 End; {error29}

function EuclidDist(const v1,v2:TmeanVector):extended;
{
oblicz odległość pomiędzy dwoma punktami
}
 var i:byte;
 begin
  result:=0;
  for i:=0 to nc-1 do
   begin  if not (i in featureSet) then continue;           //uwzględniaj cechy ze wskazanego zbioru
    temp1:=v1[i]-v2[i];
    result:=result+sqr(temp1);  //bezpośreadnie obliczanie kwadratu różnicy dawało wynik <0!!
    if result <0 then error29(result,i);
   end;
  if result>=0 then result:=sqrt(result)
  else result:=0;
 end;{EuclidDist}

 procedure error27(n,k1,k2:longWord; s:string);
  Begin
    begin
     s:='Error 27.'#13#10'Program error. Sets counts does not balance or one set is empty: given set has '+intTostr(n)+' members. The first descendant set has '+intToStr(k1)+' memebers, the second has '+intTostr(k2)+' members'+
     #13#10'The sum of the division result is equal to '+intToStr(k1+k2)+#13#10'called from '+s+#13#10'End of the error 27 description.';
     showMessage(s);
     writeln(reportFile,s); flush(reportFile);
    end;
  End;

 procedure error31(n,k,k1,k2:longWord;s:shortString);
  Begin
   s:='Error31.'#13#10'Program error, the balance does not square,'#13#10'set count='+intToStr(n)+
        ' members, found '+intToStr(k)+'.'#13#10'First descendand set contains '+intToStr(k1)+
        #13#10'Second descendand set contains '+intToStr(k2)+#13#10'Sum='+intToStr(k1+k2)+
        #13#10'Called from "'+s+'"'+#13#10'End of the error 31 description.';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
  End;

 procedure error32(const startNodeAddr:longWord;vim:double;s:shortString);

  Begin
   with nodeProps[startNodeAddr] do
    s:='Error 32.'#13#10'Program error, procedure "'+s+'",'#13#10'centroid[componentNbr]<>round(vim), i.e.'+
       ' centroid[componentNbr]='+floatToStr(centroid[componentNbr])+',  round(vim)='+floatToStr(round(vim))+
       #13#10'componentNbr='+intToStr(componentNbr)+#13#10'startNodeAddr='+intToStr(startNodeAddr)+
       #13#10'End of the error 31 description.';
   showMessage(s);
   writeln(reportFile,s); flush(reportFile);
  End;

  procedure error33(const eventNbr,k:longWord);
  var s:shortString;
   Begin
    s:='Error 33.'#13#10'Program error!'#13#10'Should be '+intToStr(eventNbr)+' events in the set free of '+
    'excluded rare events, but it was found '+intToStr(k)+' events!'#13#10'Turn to the author';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

  procedure error34(const startNodeAddr:longWord;step:word);
  var s:shortString;
   Begin
    s:='Error 34.'#13#10'Program error!'#13#10'Leaf node  was already processed!'#13#10'nbr='+
    intToStr(startNodeAddr)+#13#10'son='+intToStr(nodeHeap[startNodeAddr].son)+
     #13#10'step='+intToStr(step)+#13#10'Turn to the author...'+#13#10'End of the error 34 description.';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

  procedure error35(s:string);
   Begin
    s:='Error 35.'#13#10+s+#13#10'End of the error35  description.';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

   procedure error36;
   var s:string;
   Begin
    s:=delAmpers('Error36.'#13#10'I/O error, can not rewrite file.'#13#10'Check if directory "'+reportFileDir+'" is correct!'+
    #13#10'At least the path must exist!'#13#10+
    #13#10'Look at "'+programDir+'" file.'#13#10'May be the file is opened with'+
    ' other program. If yes, then close it and run the LVQ again, '#13#10'otherwise remove the"'+reportFileDir+
    '" file, the new will be created automatically or check if '#13#10'"'+form1.label1.caption+
    '"'#13#10'was not too large) actually it must be <= than 128'#13#10'Program will be halted now...'#13#10+
    #13#10'End of the error 36 description.');
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
    halt;
   End;

 procedure error37(s:string);
   Begin
    s:='Error 37'#13#10+s+#13#10'End of the error 37 description.';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

  procedure error40(i:integer);
   var s:string;
   Begin
    s:=delAmpers('You wanted current analysis should be for "'+form1.RadioGroup2.Caption+'\'+ form1.RadioGroup2.Items[form1.RadioGroup2.ItemIndex]+
   '" feature (see "'+form1.MainMenu1.Items[2].Caption+'\'+form1.TabSheet6.Caption+'),'#13#10'but the previous analysis was performed for the '+
   intToStr(i)+' one, and it was changed to those feature');
    s:='Error 40, procedure "readExcludeSet".'#13#10+s+#13#10'End of the error 40 description.';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

procedure error42(var i:integer; edit:Tedit;labelx:Tlabel;s:string);
   //CentroidsNb_glob=0, więc zamienia to na 1 i ostrzega
   Begin
    s:=s+#13#10+labelx.Caption+' is<=0!, (see the "'+form1.MainMenu1.Items[2].Caption+'\'+
         form1.PageControl1.Pages[0].Caption+'"). It will be changed to 1.'#13#10'Check the "'+ form1.mainMenu1.Items[2].Caption+'\'+
         form1.PageControl1.Pages[0].Caption+'" and write down a proper value!';
    s:=delAmpers('Error 42, procedure "readExcludeSet".'#13#10+s+#13#10'End of the error 42 description.');
    showMessage(s);
   // writeln(reportFile,s); flush(reportFile);     blokada, bo może być wołany podczas czytania INIT, a wtedy plik report nie jest jeszcze otwarty!
    i:=1; edit.Text:='1';
   End;

procedure error44;
   var s:string;
   Begin
    s:='You have chosen the "'+form1.RadioGroup3.Caption+'\'+form1.RadioGroup3.Items[1]+'" option, but the exclude set is empty, so '+
        'the program will be performed as if the "'+form1.RadioGroup3.Items[0]+'" was chosen. Nevertheless the reading from the pointed tree parameters will be applied.'+
        'Cause that the set is empty: probably the "'+form1.Label37.Caption+'" treshold value='+intToStr(rareEventNbr2)+' was too low.'#13#10+
        'Check the Table 3 - the "leaf set count" column - in report, to be able to choose a proper value';
    s:=delAmpers('Error 44, procedure "readExcludeSet".'#13#10+s+#13#10'End of the error 44 description.');
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

 procedure error45(const card1,n,eventNbr:longWord);  //error44(excludeSetCard,(n+1) div 8,n,eventNbr);
   var s:string;
   Begin
    s:='Error during reading exclude set was encounteread. Check the "'+treeFileDir+'" file. May be corrupted.'+
    #13#10'If  the "exclude set" is not empty (excludeSetCard>0), then in following rows should appear huge'+
    #13#10'structure containing members of this set, otherwise the next row should be empty';
    s:=s+#13#10'Remember, the "second pas" should be performed with exactly the same options as the "first" one unless you have special purposes.';
     s:=s+#13#10'Size of the exclude set ='+intToStr(card1);
    if n<>eventNbr then s:=s+#13#10'Number of the read event is ='+intToStr(eventNbr)+'. It should be rather set to '+intToStr(n);
    s:=s+#13#10'Reading of the exclude set not completed. It can contain errenously assigned events as "rare event".'+
     ' We recommend to break the program or at lesat to change options, especially change the "'+form1.RadioGroup3.Caption+'\'+
     form1.RadioGroup3.Items[1]+'" option to the "'+form1.RadioGroup3.Items[0]+'".';
    s:=delAmpers('Error 45, procedure "readExcludeSet".'#13#10+s+#13#10'End of the error 45 description.');
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

 procedure error46(s:string;radio:Tradiogroup);

  Begin
  s:=delAmpers('Error 46. '#13#10'Probably the procedure variable "'+s+'" has been not evaluated. You must click proper value in radiogroup "'+
      radio.Caption+'".'#13#10'If it was the case, then next time launching (in order the evaluation takes place)'+
      ' click other value and then the proprer one.'#13#10'The program will be halted now.'+
      #13#10'End of the error 46 description.');
  showMessage(s);
  writeln(reportFile,s); flush(reportFile);
  Halt;
 end;{error46}

 procedure error47(s:string);
 begin
  with form1 do
  s:=delAmpers('Error 47'#13#10'The RAM resources assigning for '+s+' failed.'#13#10'You must lower class number, i.e. "'+ mainMenu1.Items[2].Caption+'\'+
  PageControl1.Pages[1].Caption+'\'+Label5.Caption+'" or readuce data size, use "'+ mainMenu1.Items[2].Caption+'\'+PageControl1.Pages[1].Caption+
  '\'+CheckBox36.Caption+'".'#13#10'The program will be halted now'#13#10'End of the error 47 description');
  showMessage(s);
  writeln(reportFile,s); flush(reportFile);
  Halt;
 end;{error47}

 procedure error48;
 var s:string;
 begin
  with form1 do
  s:=delAmpers('Error 48'#13#10'The RAM resources assigning for vector list or for one of the answer list failed (procedure "vectorAndCathListRead").'#13#10+
  'You must readuce data size, use "'+ mainMenu1.Items[2].Caption+'\'+PageControl1.Pages[1].Caption+
  '\'+CheckBox36.Caption+'".'#13#10'The program will be halted now'#13#10'End of the error 48 description');
  showMessage(s);
  writeln(reportFile,s); flush(reportFile);
  Halt;
 end;{error48}

 procedure error49;
 var s:string;
 begin
  with form1 do
  s:=delAmpers('Error 49'#13#10'The RAM resources assigning for leaves sets cardinals list failed (procedure "FinalIRToreport").'#13#10+
  'You must reduce data size, use "'+ mainMenu1.Items[2].Caption+'\'+PageControl1.Pages[1].Caption+
  '\'+CheckBox36.Caption+'". May be the feature set is empty, so check also "'+label109.Caption+'" or the "'+
   label110.Caption+'".'#13#10'You must also take into account the "'+label1.Caption+'" parameter.'#13#10'End of the error 49 description');
  showMessage(s);
  writeln(reportFile,s); flush(reportFile);
 end;{error49}

 procedure error50(n,cardinal:longWord;s:shortString);  
  Begin
   s:='Error50,'+s+'.'#13#10'Program error, the balance does not square,'#13#10'found '+intToStr(n)+' members,'+
        #13#10'set should contain '+intToStr(cardinal)+'.'#13#10'End of the error 50 description.';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
  End;{error50}

procedure error51;
var s:string;
 Begin
  s:='Error51, some error with "'+form1.RadioGroup24.Caption +'" occuread'#13#10'End of the error 51 description.';
  showMessage(s);
  writeln(reportFile,s); flush(reportFile);
 End;{error51}

procedure error52(s:shortString; hb,lb:longWord);

   Begin
    s:='Error 52'#13#10'Indeks borders ('+s+') are wrong - the first one should be >= then the second one, meanwhile they are: ('+intTostr(hb)+',  '+intToStr(lb)+').'+
   #13#10'Program error, turn to the author'#13#10'End of the error 52 description.';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

 procedure error53(n,excludesetCard:longWord);
  var s:shortString;
   Begin
    s:='Error 53: Error in reading or saving exclude set. It contains '+intToStr(n)+
    ' members, but should contain (as read from the tree file) '+intToStr(excludesetCard)+' members'#13#10+
    'Probably program error or the tree file ('+treeFileDir+') is corrupted'#13#10'End of the error 53 description';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

procedure error54(const n,Card:longWord; const leaf:word; s:shortString);
   Begin
    s:='Error 54: Error in making leaf sets. Leaf set nbr '+intToStr(leaf) +' contains '+intToStr(n)+
       ' members, but should contain '+intToStr(Card)+' members'#13#10'Program error, turn to the author'#13#10+
       'Occuread in the procedure '+s+#13#10'End of the error 54 description';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

procedure error55(s:shortString);
   Begin
    s:='Error 55: Unknown error occuread in the procedure "CARTbestDivision".'#13#10+
    'The parameter "trial_or_fixed" equal to "'+s+'" and is different both from "trial" and from "fixed"'#13#10+
    'The program should be checked, turn to the author...'#13#10'End of the error 55 description';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

procedure error56(const j,lbhb:int64; s:shortString);
   Begin
    s:='Error 56: Error detected in the procedure "'+s+'".'#13#10+
    'Count of created set members does not balance with borders indexes. Should be '+ intToStr(lbHb)+' but is '+intToStr(j)+
    #13#10'The program should be checked, turn to the author...'#13#10'End of the error 56 description';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

procedure error57(const lb2hb1:int64; s:shortString);
   Begin
    s:='Error 57: Error detected in the procedure "'+s+'".'#13#10+
    'High and low indexes of descendant sets  differ too much. The difference should be 1, but is '+ intToStr(lb2Hb1)+
    #13#10'The program should be checked, turn to the author...'#13#10'End of the error 57 description';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

procedure error58(s:shortString);

   Begin
    s:='Error 58: Error detected in the procedure "'+s+ #13#10'Standard deviation <0'+
    #13#10'The program should be checked, turn to the author...'#13#10'End of the error 58 description';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;


procedure error59(programDir:string);
 var s:string;
   Begin
    s:='Error 59: File of last used options, i.e.'#13#10'"'+programDir+'"'#13#10'is corrupted'#13#10'Check it or remove - in this case the new one will be generated automatically';
    showMessage(s);
    if fileExists(reportFileDir) then
    with TTextRec(reportFile) do if mode=fmOutput then
    begin writeln(reportFile,s); flush(reportFile) end;
    if fileExists(programDir) then
    with TTextRec(initFile) do if mode<>fmClosed then
    close(initFile);
   End;

procedure error60(programDir,proc:string);
 var s:string;
   Begin
    s:='Error 60: Some error in the procedure "'+proc+'" has occuread, turn to the author.';
    showMessage(s);
     if fileExists(reportFileDir) then
    with TTextRec(reportFile) do if mode=fmOutput then
    begin writeln(reportFile,s); flush(reportFile) end;
     if fileExists(programDir) then
    with TTextRec(initFile) do if mode<>fmClosed then
    close(initFile);
   End;

procedure error61(s:string);
 begin
  s:='Error 61.'#13#10 +'The "'+programDir+'" file  (init file)'+s+#13#10'It will be created with the default values. Probably you  wish change the program options.'+
   #13#10'It is recomended now to to click the "OK" button on the option pge  and close and reopen the program or step in the "Options" and click different radiogroups to ensure the "on Click" events will be activated to evaluate the program parameters'+
   ' (especially the ones contained in the "'+ form1.mainMenu1.Items[2].Caption+'\'+form1.PageControl1.Pages[3].Caption+'" page)'#13#10'End of the error 61 description';
   ShowMessage(s);
     if fileExists(reportFileDir) then
    with TTextRec(reportFile) do if mode=fmOutput then
    begin writeln(reportFile,s); flush(reportFile) end;
     if fileExists(programDir) then
    with TTextRec(initFile) do if mode<>fmClosed then
    close(initFile);
   InitDefaults;
 end;

 procedure error62(s:string);
 begin
  s:='Error 62. Pertains results from a table 6 computed by a procedure standardDeviationRatiol\TreeExaminer;'#13#10 +s+#13#10+
  'Error can arrise due to roundings. 0 value will be taken and the procedure will continue.'#13#10+
  'If the value is not very small then this happened due to the program error, turn to the author.'#13#10+ 
  'End of the error description';
  ShowMessage(s);
  writeln(reportFile,s); flush(reportFile);
 end;{error62}

procedure error63(n2,n1:int64); //EventNbr<high(vectList)
 var s:string;
 begin
  s:='Error 63. Take care, some mistake in program exist resulting in unnecessary RAM reallocation in case of data reading braking, turn to the author.'#13#10+
  'EventNbr (='+intToStr(n2)+') should be <high(vectList) (='+intToStr(n1)+') because data reading was broken.'#13#10+
  'No measures will be taken and the program will be continued.'#13#10+
  'End of the error description';
  ShowMessage(s);
  writeln(reportFile,s); flush(reportFile);
 end;{error62}

 procedure error100;
 var s:string;
 begin
  s:='Error 100.'#13#10 +'Error probably caused by erronous data format.'#13#10+
  'Check whether following conditions for the file'#13#10+eventFileDir+#13#10'were fullfilled:'#13#10+
  'All introductory comments appearing at the beginning  will be skipped until the first integer value.'#13#10+
  'Each row contains description of one event: features vector and its classification according to values of three cathegorical variables.'#13#10+
  'Values of the cathegorical variables can be proceeded by any number of spaces and tabs; they will be skipped.'#13#10+
  'Remember! All cathegorical variable values can be encoded with ONLY ONE character!!'#13#10+
  'First integer number greater than 0 will be interpreted as number of events (eventNbr). Every trailing nonvisual'#13#10+
  'signs, spaces and other chars proceeding 0 (#48) will be skipped here.'#13#10+
  'Second one, in the next row, will be interpreted as number of vectors components  (nc).'#13#10+
  'Third one, in the next row, will be interpreted as  components values range.'#13#10+
  'Next row is the table header; cathegorical variable names are read from here.'#13#10+
  'First three column will be interpreted as cathegory, classyfing values (values of three dependent variables)'#13#10+
  'Next nc columns will be read as vectors components'#13#10+
  'Prepare data file with MS Excel and export it as a txt file to avoid unnecessary characters.'#13#10+
  'End of the error 100 description';
   ShowMessage(s);
   if fileExists(reportFileDir) then
    with TTextRec(reportFile) do if mode=fmOutput then
    begin writeln(reportFile,s); flush(reportFile) end;
 end;{error100}

 procedure DivideSet(const n:longword; const lb0,hb0:longWord; var hb1,lb2:longWord; const v1,v2:TmeanVector;
  out centr1,centr2:TmeanVector; var meanDistance1,meanDistance2:extended; out k1,k2:longWord);
 {
 Podziel zbiór na 2 części wg odległości Euklidesa od centroidów
            v1, v2 - wektory, centroidy wejściowe
    centr1,centr2 - wektory,centroidy wyjściowe
lb0,hb1, lb2,hb0 - podzbiory z podziału;   lb1=lb0, a hb2=hb0, więc nie potrzeba ich obliczać
         k1, k2 - moce podzbiorów j.w.
       lb0,hb0 - dzielony zbiór
   excSetCard - moc excludeSet
 }
 var
     i,k,excSetCard : longWord;
                  m : word;
                 vi : TmeanVector;
sd1,sd2,dist1,dist2 : extended;

 procedure summer(const dist:extended; const evAddr:longWord; const firstSet:boolean; const vi:TmeanVector;
  var sd:extended; var currIdx,k:longWord; var centr:TmeanVector);

 //Oblicza: sumy odległości, sumy składowych (dla centroidu), tworzy zbiór i zlicza jego elementy
 //  currIdx - bieżący index roboczej listy adresów, tj. granica zbioru ( lb albo hb);
 //  first - pierwszy potomek z rozbicia
 //evAddr - adres klasyfikowanego zdarzenia
 //  wbl - lista robocza adresów (working border list)

 var m:word;
  Begin
    sd:=sd+dist;
    wbl[currIdx]:=evAddr;
    try
    if firstSet then inc(currIdx)
    else dec(currIdx);
    except
    with form1 do
    if (step=1) and form1.CheckBox16.Checked then
     error37('Procedure "Summer"; Error "Integer overflow" may be caused by wrong "first centroids" read from tree'#13#10'Uncheck the '
     +form1.CheckBox16.Caption+' and try again'#13#10'var firstSet='+intToStr(byte(firstSet))+'; currIdx='+intToStr(currIdx))
    else
    error37('Some unexpected error  "Integer overflow" in the procedure "Summer" occuread. Check whether the'#13#10#13#10'"'+ mainMenu1.Items[2].Caption+'\'+
     pageControl1.Pages[3].Caption+'\'+Label27.Caption+'"'#13#10#13#10'(var multStdDev) is not too small!'#13#10+
     #13#10'step='+intToStr(step)+#13#10'multStdDev='+floatToStr(multStdDev)+#13#10'firstSet='+intToStr(byte(firstSet))+#13#10'currIdx='+
     intToStr(currIdx)+#13#10);
    end;
    inc(k);       //zliczaj elementy zbioru
    for m:=0 to nc-1 do centr[m]:=centr[m]+vi[m];
  End;{summer}

 procedure means(const sd:extended; n:longWord; var centr:TmeanVector; out meanDist:extended;const call:byte);
 //oblicz centroid i śreadnią odległości
 //       n - liczba elementów w zbiorze
 //      sd - suma zwykła
  var i :byte;
  Begin //-------------------means-------------------------------
   if n=0 then n:=error11;
   for i:=0 to nc-1 do centr[i]:=centr[i]/n;
   meanDist:=sd/n;
  End;{means}

  Begin   //--------------------------DivideSet--------------------------------
    k:=0; k1:=0; k2:=0; sd1:=0; sd2:=0; excSetCard:=0;
    for i:=0 to nc-1 do
     begin
      centr1[i]:=0;
      centr2[i]:=0;
     end;
   i:=lb0;   lb2:=hb0;  hb1:=lb0;
   Repeat   //--------------------------------------------Podziel zbiór na 2 części wg odległości Euklidesa od centroidów
    inc(k);                                             //k - licznik elementów znalezionych w dzielonym zbiorze
    for m:=0 to nc-1 do vi[m]:=vectList[sbl[i],m];
    dist1:=dist(v1,vi); dist2:=dist(v2,vi);           //odległość centroid-wektor  (v1, v2, to centroidy! (wstępne))
    if dist1=dist2 then
      begin
       if alloc='b' then
        begin
        summer(dist1,sbl[i],true,vi,sd1,hb1,k1,centr1);
        alloc:='s';
        end
       else
        begin
        summer(dist2,sbl[i],false,vi,sd2,lb2,k2,centr2);
        alloc:='b';
        end;
     end {dist1=dist2}
    else
     if dist1<dist2 then
      begin
      summer(dist1,sbl[i],true,vi,sd1,hb1,k1,centr1);
      alloc:='s';
      end
     else
      begin
      summer(dist2,sbl[i],false,vi,sd2,lb2,k2,centr2);
      alloc:='b';
      end;
    inc(i);
   Until (k>=n) or (i>=wholeEventNbr) or (i>=hb0+1);         //biegaj dotąd, dokąd nie przejrzysz całego zbioru i nie zaklasyfikujesz jego elementów
   dec(hb1); inc(lb2);                                        //bo to są adresy dl następnych zapisów, których już nie będzie, bo podział się skończył
   if -lb0+hb1+1<> k1 then error56(k1,-lb0+hb1+1,'DivideSet');
   if -lb2+hb0+1<> k2 then error56(k2,-lb2+hb0+1,'DivideSet');
   if -hb1+lb2<>1 then error57(-hb1+lb2,'DivideSet');
   if (k<>n) or (k1+k2+excSetCard<>n) then  error31(n,k,k1,k2,'DivideSet');
   means(sd1,k1,centr1,meanDistance1,1);
   means(sd2,k2,centr2,meanDistance2,2);
  End;{DivideSet}

 function IRadius(pk,pqkm:double):extended;
   var r1,r2,pPlusQ:extended;
  Begin  r1:=0; r2:=0; pPlusQ:=(pk+pqkm)/2;
   if pk>0 then r1:=pk*ln(pk/pPlusQ);
   if pqkm>0 then r2:=pqkm*ln(pqkm/pPlusQ);
   IRadius:=r1+r2;
  End;{IRadius}

 procedure CentroDistance(const lb,hb:longWord; const bl:TlwArr; out vi:TmeanVector; out sumDist:extended);
 {
 Centroid i sumę odległości wektorów od centroidu
 bl - border list - lista adresów zdarzeń należących do analizowanego zbioru
 }
  var i,j:longWord; m:word;  vt:TmeanVector;
  Begin
   sumDist:=0;
   for m:=0 to nc-1 do   vi[m]:=0;
   for i:=lb to hb do                                           //obliczyć wektor śreadnich
    for m:=0 to nc-1 do vi[m]:=vi[m]+vectList[bl[i],m];
   if hb>=lb then  j:=-lb+hb+1
   else begin error52('hb, lb', hb, lb); j:=1 end;;
   for m:=0 to nc-1 do if j>0 then vi[m]:=vi[m]/j else vi[m]:=0;//centroid
   for i:=lb to hb do                                           //obliczyć sumę odległości wektorów w zbiorze od centroidu
    begin
     for m:=0 to nc-1 do vt[m]:=vectList[bl[i],m];              //vt - wektor pomocniczy, aby uzgodnić typy wywołania funkcji dist
     sumDist:=sumDist+dist(vi,vt);
    end;{for i}
  End;{CentroDistance}

  function NodeTrialIRProcessing(const n:longword; const nodeHist:Thist; const featureLevelNbr:byte; const Pb:TdbArr):extended;
  {
  Oblicza IR histogramu nodeHist względem histogramu tego samego wrażenia w całej próbie uczącej
  }
   var i:longWord;
    leafIr : extended;
  Begin  //----------------------NodeTrialIRProcessing-------------------
   leafIr:=0;
   for i:=0 to featureLevelNbr do  leafIr:=leafIr+IRadius(Pb[i],nodeHist[i]/n);                               //Pb, to histogram prawdopodobieństw wrażeń w całej próbie (zgodnych z Hash)
   result:=leafIR/ln2;
  End;{NodeTrialIRProcessing}

 procedure  Histograms(const n:longword; const lb,hb:longWord; const m:byte; var k1,k2 : longWord;
  var nodeHist:Thist; const Hash:TcharByte; const response:TcharList; const vim:Double; const featureLevelNbr:word);
 {
 lb,hb - dzielony zbiór
 m       - numer składowej j.w.
 Hash   - lista klasyfikacji zdarzeń wg danego wrażenia (którego wrażenia? - zadanego właśnie listą wartości Hash!)
 response - klasyfikacja zdarzeń, jedna z: eventcath1, eventcath2, eventcath3. Czytane w "vectorAndCathListRead" równolegle z wektorami analiz spektralnych
 vi   - wektor śreadnich w danym zbiorze (ponieważ m= const, więc wystarczy tylko 1 składowa m, stąd vim)
 vim - patrz wyżej
 }
 var i,k : longWord;
  Begin
  for i:=0 to featureLevelNbr do
   begin
    TempHist1[i]:=0; TempHist2[i]:=0; nodeHist[i]:=0;
   end;
   k1:=0; k2:=0; k:=0;
   form1.label17.caption:=intToStr(m);    Application.processMessages;               //show processed component nbr
   for i:=lb to hb do    //---------------------------------------------Podziel zbiór na 2 części wg najlepszej cechy
    begin
     inc(nodeHist[Hash[response[sbl[i]]]]);                     //histogram wrażenia uczącego w dzielonym zbiorze (patrz uwagi przy deklaracji)
     if vectList[sbl[i],m]<=vim then
      begin
       inc(TempHist1[Hash[response[sbl[i]]]]); inc(k1);
      end        //MUSI BYÆ WEKTOR ZBIORÓW I WEKTOR HISTOGRAMÓW!!! (gdyby for było wewnątrz repeat)
     else
      begin
       inc(TempHist2[Hash[response[sbl[i]]]]); inc(k2);
      end;
     inc(k);                                            //licznik zaklasyfikowanych elementów; k<=n
    end;{for}//Until (k>n) or (i>eventNbr);                          //biegaj dotąd, dokąd nie przejrzysz całego zbioru i nie zaklasyfikujesz jego elementów
   if (k<>n) or (k1+k2<>n) then  error31(n,k,k1,k2,'Histograms');
  End;{Histograms}

 procedure CARTsetDivider(const n:longword; const lb0,hb0:longWord; const m:byte; var hb1,lb2: longWord; out k1,k2 : longWord;
  var nodeHist:Thist; const Hash:TcharByte; const response:TcharList; const vim:Double; const featureLevelNbr:byte);
 {
 Dzieli dany zbiór wektorów lb0,hb0 na 2 części względem śreadniej pewnej składowej wektora cechy sterującej,
 i oblicza histogramy wrażenia w otrzymanym podziale.
     lb0, hb0  - dzielony zbiór, granice indeksów
    hb1, lb2  - wynik podziału, granice indeksów
          m  - numer składowej j.w.
      Hash  - lista klasyfikacji zdarzeń wg danego wrażenia (którego wrażenia? - zadanego właśnie listą wartości Hash!)
 response  - klasyfikacja zdarzeń, jedna z: eventcath1, eventcath2, eventcath3. Czytane w "vectorAndCathListRead" równolegle z wektorami analiz spektralnych
      vi  - wektor śreadnich w danym zbiorze (ponieważ m= const, więc wystarczy tylko info o 1 składowej wg wartości której podział jest wykonywany m, stąd vim)
    vim  - patrz wyżej
wbl,sbl -  lista robocza adresów (working border list), lista adresów posortowana wg przynależności zdarzeń do zbiorów (sorted border list)
if form1.radiogroup27.ItemIndex=1 - histogramy robione są tylko w trybie wyboru cechy w trybie "supervised" (nie w "distortion")
 }
 var i,k : longWord;
  Begin
   if form1.radiogroup27.ItemIndex=1 then for i:=0 to featureLevelNbr do begin TempHist1[i]:=0; TempHist2[i]:=0;  NodeHist[i]:=0 end;
   i:=lb0; lb2:=hb0; hb1:=lb0; k1:=0; k2:=0; k:=0;
   form1.label17.caption:=intToStr(m);    Application.processMessages;               //show processed component nbr
   try
    Repeat   //---------------------------------------------Podziel zbiór na 2 części wg najlepszej cechy
     if form1.radiogroup27.ItemIndex=1 then inc(nodeHist[Hash[response[sbl[i]]]]);                     //histogram wrażenia uczącego w dzielonym zbiorze (patrz uwagi przy deklaracji)
     if vectList[sbl[i],m]<=vim then
      begin
       wbl[hb1]:=sbl[i]; inc(hb1);
       if form1.radiogroup27.ItemIndex=1 then inc(TempHist1[Hash[response[sbl[i]]]]);
       inc(k1)
      end        //MUSI BYÆ WEKTOR ZBIORÓW I WEKTOR HISTOGRAMÓW!!! (gdyby for było wewnątrz repeat)
     else
      begin
       wbl[lb2]:=sbl[i]; dec(lb2);
       if form1.radiogroup27.ItemIndex=1 then inc(TempHist2[Hash[response[sbl[i]]]]);
       inc(k2)
      end;
     inc(k);                                            //licznik zaklasyfikowanych elementów; k<=n
     inc(i);
    Until (k>=n) or (i>=wholeEventNbr) or (i>hb0);                          //biegaj dotąd, dokąd nie przejrzysz całego zbioru i nie zaklasyfikujesz jego elementów
    dec(hb1); inc(lb2);
   except
     error37('CARTsetDivider proc.; Error "Integer overflow" may be caused by program error, e.g.  relation vectList[sbl[i],m]=<vim should be checked; turn to the author');
   end;
   if -lb0+hb1+1<> k1 then error56(k1,-lb0+hb1+1,'CARTsetDivider');
   if -lb2+hb0+1<> k2 then error56(k2,-lb2+hb0+1,'CARTsetDivider');
   if -hb1+lb2<>1 then error57(-hb1+lb2,'CARTsetDivider');
   if (k<>n) or (k1+k2<>n) then  error31(n,k,k1,k2,'CARTsetDivider');
  End;{CARTsetDivider}

 procedure DivisionEvaluation_IR(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte;
                               const Pb:TdbArr; out delta2:double;const k1,k2:longWord; const lb0,hb0,hb1,lb2:longWord;
                               const nodeAddr:word; const RadioGroup:TradioGroup;const bl:TlwArr);
 {
 const k1,k2:longWord;  const RadioGroup:TradioGroup potrzebne tylko do zgodności z pozostałymi wersjami
 wrażenie jest determinowane w FeaturesInspectTree poprzez alternatywne wywołanie  FeaturesTreeInspector, np.
 dla fonemów będzie to FeaturesTreeInspector(0,0, cath1Nbr,cath1Hash,eventcath1,cath1Pb,'0');
 Wybór wrażenia tutaj jest reprezentowany przez TempHist1 i TempHist2 oraz NodeHist.
 }

  var d1,d2,d0 : extended;
  begin
   //Ocena podziału wg przyrostu IR - im większy, tym lepszy
   //NodeTrialIRProcessing(const n:longword; const nodeHist:Thist; const featureLevelNbr:byte; const Pb:TdbArr)
   d1:=NodeTrialIRProcessing(n,TempHist1,featureLevelNbr,Pb);  //składniki dla debugingu
   d2:=NodeTrialIRProcessing(n,TempHist2,featureLevelNbr,Pb);
    case RadioGroup.ItemIndex  of            //03.01.2011
    0: d0:=nodeprops[nodeAddr].cath1IR;
    1: d0:=nodeprops[nodeAddr].cath2IR;
    2: d0:=nodeprops[nodeAddr].cath3IR;
   end;{case}
   delta2:=d1+d2-d0;                                           // przyrost IR wskutek rozszczepu
  end;{DivisionEvaluation_IR}

 procedure DivisionEvaluation_Err(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte;
                               const Pb:TdbArr; out delta2:double;const k1,k2:longWord; const lb0,hb0,hb1,lb2:longWord;const nodeAddr:word; const RadioGroup:TradioGroup;const bl:TlwArr);
 {
 Ocena podziału wg błędu rozpoznania - im spadek większy, tym lepszy
 const k1,k2:longWord dla zgodności z wersją '_dist"
 wrażenie jest determinowane w FeaturesInspectTree poprzez alternatywne wywołanie  FeaturesTreeInspector, np.
 dla fonemów będzie to FeaturesTreeInspector(0,0, cath1Nbr,cath1Hash,eventcath1,cath1Pb,'0');
 Wybór wrażenia tutaj jest reprezentowany przez TempHist1 i TempHist2 oraz NodeHist.
}
  var d1,d2,d0 : extended;
      maxPerc1,maxPerc2 : byte;

  procedure PercProcessing(const k:longWord;const NodeHist:THist;const levelNbr:byte; out maxPerc:byte);
  {
  znajdź położenie maximum w danym histogr NodeHist w porównaniu z histogramem w próbie uczącej pb
  }
   var i,p1,p2:longWord;
  Begin  //----------------------PercProcessing-------------------
   p1:=0;  maxPerc:=high(maxPerc);
   for i:=0 to levelNbr do                                            //cath1Pb, to histogram fonemów w całej próbie
    begin
     p2:=nodeHist[i];
     if p2>=p1 then
      begin maxPerc:=i; p1:=p2 end;
    end;
  End;{PercProcessing}

  begin     //----------------------------DivisionEvaluation_Err----------------
   PercProcessing(k1,TempHist1,FeatureLevelNbr,maxPerc1);
   PercProcessing(k2,TempHist2,FeatureLevelNbr,maxPerc2);
   case RadioGroup.ItemIndex  of
    0: d0:=nodeprops[nodeAddr].cath1RecErr;
    1: d0:=nodeprops[nodeAddr].cath2RecErr;
    2: d0:=nodeprops[nodeAddr].cath3RecErr;
   end;{case}
   d1:=-TempHist1[maxPerc1]+k1;
   d2:=-TempHist2[maxPerc2]+k2;
   delta2:=-(d1+d2-d0);                                           // spadek błędu rozpoznania wskutek rozszczepu
   if form1.RadioGroup12.ItemIndex<>0 then                      //dowarunkowanie 18.10, bo występowały wartości ujemne w trybie CART
  end;{DivisionEvaluation_Err}

 //        DivisionEvaluation_IR(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte; const Pb:TdbArr; out delta2:extended);
 //        DivisionEvaluation_Err(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte; const Pb:TdbArr; out delta2:extended;const k1,k2:longWord);

 procedure DivisionEvaluation_distortion(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte;
                               const Pb:TdbArr; out delta2:double;const k1,k2:longWord; const lb0,hb0,hb1,lb2:longWord;const nodeAddr:word; const RadioGroup:TradioGroup;const bl:TlwArr);
 {
 n- liczebności zbiorów,
 const k1,k2:longWord; const nodeAddr:word; ; const RadioGroup:TradioGroup            dla zgodności z wersją "_err"
 lb1=lb0; hb2=hb0
 }
  var d0,d1,d2 : extended;       //składniki dla debugingu
            vi : TmeanVector;  //centroid
            n1,n2:longWord;
  begin
   //Ocena podziału wg spadku błędu odwzorowania: obliczyć centroidy nowych zbiorow, sumę odległości od centrów, sumę odległości węzła rozszczepianego
   //CentroDistance(out j:longword; const lb,hb:longWord; out vi:T128DoubleArr; out sumDist:extended);
   n:=nodeprops[nodeAddr].cardinal;
   d0:=n*nodeprops[nodeAddr].meanDistance;
   CentroDistance(lb0,hb1,bl,vi,d1);
   if hb1>=lb0 then n1:=hb1-lb0+1
   else begin error52('hb1, lb0', hb1, lb0); n1:=1 end;
   CentroDistance(lb2,hb0,bl,vi,d2);
   if hb0>=lb2 then n2:=hb0-lb2+1
   else begin error52('hb0, lb2', hb0, lb2); n2:=1 end;
   with form1.radiogroup4 do                   // spadek dystorsji wskutek rozszczepu
   if itemIndex=1 then delta2:=-(d1+d2)+d0    //dystorsja=suma odległośi
   else delta2:=-(d1/n1+d2/n2)+d0/n;          //dystorsja=śreadnia odległość
  end;{DivisionEvaluation_distortion}


 procedure FindBestFeature(const startNodeIndex,n:longword; const lb0,hb0:longWord; const featureLevelNbr:word;
    const Hash:TcharByte; const response:TcharList; const Pb:TdbArr; out componentNbr:byte; out deltaIR:double);
 {
 Ma znaleźć najlepszy liść do kolejnego podziału i najlepszą cechę, wg której zbiór ma być podzielony
 Podziel zbiór na 2 części wg  cechy najsilniej wyjaśniającej klasyfikację cath1
         k1, k2 - liczebności zbiorów
        lb0,hb0 - dzielony zbiór
              n - liczebność rozszczepianego zbioru
         k1, k2 - liczebności zbiorów z rozbicia
             nc - liczba składników wektora cech
featureLevelNbr - liczba poziomów wrażenia (np. ile różnych fonemów znaleziono w analizowanym sygnale)
           Hash - lista klasyfikacji zdarzeń wg danego wrażenia (którego wrażenia? - zadanego właśnie listą wartości Hash!)
       NodeHist - histogram wrażenia w węźle przodka,  wrażenia - tego samego, co zadanego listą wartości Hash!,
                  czyli cath1NodeHist[nodeNbr] lub cath2NodeHist[nodeNbr] lub cath3NodeHist[nodeNbr]
                  należy zadbać o zgodność Hash i NodeHist w wywołaniu...); odpowiednia wartość jest przypisywana instr. case radiogroup.itemIndex w RUN
             Pb - cath1Pb lub cath2Pb lub cath3Pb                             //prawdopodobieństwa empiryczne w węźle zerowym
   componentNbr - numer komponentu wektora cech najlepiej klasyfikującego dany zbiór
        deltaIR - przyrost IR wskutek rozszczepienia wg componentNbr
 }
 var
    k1,k2 : longWord;
        m : byte;
   delta2 : double;

  Begin   //============================== FindBestFeature ================================
   delta2:=0;  featureFound:=false;
   for m:=0 to nc-1 do                                     //szukaj najlepszej cechy i wykonuj histogramy zbiorów z podziału
    Begin  if not (m in featureSet) then continue;           //uwzględniaj cechy ze wskazanego zbioru
     form1.Label94.Caption:=intToStr(m);  application.ProcessMessages;   //if round(vi[m])<>nodeProps[startNodeIndex].centroid[m] then error32(startNodeIndex,vi[m],'FindBestFeature');   blokada 07.09.07
     CARTsetDivider(n,lb0,hb0,m,hb1glob,lb2glob,k1,k2,NodeHist_glob, Hash,response,nodeProps[startNodeIndex].centroid[m],featureLevelNbr);                                                                             //blokada 07.09.07
     if (k1=0) or (k2=0) then
      begin
       if step=1 then exclude(featureSet,m); //wyłączyć cechę o identycznych wartościach we wszystkich zdarzeniach
       continue
      end//begin delta2:=0;{ componentNbr:=nc-1;vim:=vi[componentNbr] }end  // Gdy nie ma rozbicia zbioru, to przyjmujemy wartośc componentNbr:=nc-1. Może to byc dowolna wartość z przedziału <0,nc-1>. 0 jednak nie bierzemy pod uwagę, bo na ogół gdy bierzemy składowe cepstralne pod uwagę, to składową zerową pomija się. W takim przypadku w krańcowych sytuacjach, w których wszystkie wektory w zbiorze byłyby dokładnie równe, wybrana byłaby wlasnie skladowa zerowa, a tak, to będzie to składowa nr nc-1.
     else
     try
     FeaturesChoiceDivisionEvaluation(n,TempHist1,TempHist2,NodeHist_glob,FeatureLevelNbr,Pb,delta2,k1,k2,lb0,hb0,hb1glob,lb2glob,startNodeIndex,form1.RadioGroup25,wbl)
     except
     error46('FeaturesChoiceDivisionEvaluation',form1.RadioGroup22)
     end;
      {else}
     if (delta2>deltaIR) and (k1>0) and (k2>0) then                                      //wybierz najlepszą składową wektora cech dla dzielonego zbioru
      begin
       componentNbr:=m; featureFound:=true;
       deltaIR:=delta2;
      end
    End;{for}                                                   //oceń wynik podziału zbioru według zadanego kryterium
  End;{FindBestFeature}

  procedure ShowIterationProgress(const iterNbr:word; const leafID:word; const fix:shortString);//,nodeAddr:word);
   var line : string;
   Begin
    with form1 do if checkBox9.checked then                    //------------------------show iteration progress
     begin                                                     //wiersze dla okna memo1
                                                               line:=floatToStrF(step,ffFixed,5,0)+#9;
                                                               line:=line+floatToStrF(iterNbr,ffFixed,5,0)+#9;
                                                               line:=line+floatToStrF(leafID,ffFixed,6,0)+#9#9;
     label19.caption:=intToStr(k1);                            line:=line+floatToStrF(k1,ffFixed,20,0)+#9#9;        line:=line+'    ';//copy(ins,1,5-i2);                     //postęp kwantowania
     label41.caption:=floatToStrF(meanDistance1,fffixed,13,3); line:=line+floatToStrF(meanDistance1,ffFixed,15,3)+#9;
     label21.caption:=intToStr(k2);                            line:=line+FloatToStrF(k2,ffFixed,7,0)+#9;           line:=line+'    ';//copy(ins,1,5-i2);//postęp kwantowania
     label44.caption:=floatToStrF(meanDistance2,fffixed,13,3); line:=line+floatToStrF(meanDistance2,ffFixed,15,3)+#9+fix;
     if checkbox11.Checked then memo1.Lines.Add(line);
     application.ProcessMessages;
     end;
   End;{ShowIterationProgress}

 procedure CARTbestDivision(const ComponentNbr:byte; out v1,v2:TmeanVector; const distMaxNodeAddr:word; const lb0,hb0:longWord;
  out meanDistance1,meanDistance2:extended; out k1,k2:longWord; const step:word;var nodeHist:Thist;const fix:shortString);
  { Ostateczny, twardy podział zbioru
    Dzieli dany zbiór wektorów lb,hb na 2 części względem śreadniej pewnej składowej wektora cechy sterującej,
    i oblicza histogramy wrażenia w otrzymanym podziale.
    Podział był już wykonany  w "CARTsetDivider"; powt.  konieczne, bo z "CARTsetDivider" wychodzą histogramy dotyczące rozszczepu ostatniego liścia, a potrzebujemy dane dot. rozszczepu aktualnie optymalnego liścia.
    Mogłoby pomóc zapamiętywanie, ale wymagałoby to dodatkowych zasobów RAM (tablica [1..K] 3 histogramów: przodka i dwóch następników)
    k1, k2       - aktualne liczebności zbiorów  potomnych
    lb0,hb0      - dzielony zbiór
    v1,v2        - centra  w potomkach
    vim          - składowa centroidu w dzielonym zbiorze (znaleziona w poprzednim kroku, pocz~tkowo w proc. S0)
    n - liczebność dzielonego zbioru
    ComponentNbr - najlepszy składnik wektora cech (cepstrum); globalny, znaleziony w FindBestFeature                              ,cath1Nbr,cath1Has
   Uwaga.                                                                                                                           ,cath3Nbr,
   Podziału dokonujemy wg wartości najlepszej dla tego podziału cechy, która z kolei mogła być wybrana na podstawie
   tego samego lub innego kryterium oceny dokonanego podziału.
  }
  var n:longWord; vim:double;//vi : T128DoubleArr;(*było Tvect;*)
  Begin
   n:=nodeprops[distMaxNodeAddr].cardinal;
   vim:=nodeprops[distMaxNodeAddr].centroid[ComponentNbr];
   case form1.RadioGroup25.ItemIndex  of                                                   //kryteria   - impression for feature choice
   (*CARTsetDivider(n,lb0,hb0,m,hb1glob,lb2glob,k1,k2,nodeHist, Hash,response,nodeProps[startNodeIndex].centroid[m],featureLevelNbr);                                                                             //blokada 07.09.07*)
   -1: CARTsetDivider(n,lb0,hb0,ComponentNbr,hb1glob,lb2glob,k1,k2,emptyHist,emptyHash,emptyResponse,vim,255);      //distortion
    0: CARTsetDivider(n,lb0,hb0,ComponentNbr,hb1glob,lb2glob,k1,k2,nodeHist,cath1Hash,eventcath1,vim,cath1Nbr);      //cath1, IR or error
    1: CARTsetDivider(n,lb0,hb0,ComponentNbr,hb1glob,lb2glob,k1,k2,nodeHist,cath2Hash,eventcath2,vim,cath2Nbr);  //cath2,  IR or error
    2: CARTsetDivider(n,lb0,hb0,ComponentNbr,hb1glob,lb2glob,k1,k2,nodeHist,cath3Hash,eventcath3,vim,cath3Nbr) //cath3, IR or error
   else showMessage('Invalid sensation number (='+intToStr(form1.RadioGroup24.ItemIndex)+'), program error, procedure "CARTbestDivision"');
   end;{case}
  form1.label15.caption:=intToStr(step);form1.label19.caption:=intToStr(k1);form1.label21.caption:=intToStr(k2);         //ShowIterationProgress;
  if (n<>k1+k2) or (k1=0) or (k2=0) then error27(n,k1,k2,'CARTbestDivision');
//CentroDistance(const lb,hb:longWord; const bl:TlwArr;out vi:T128DoubleArr; out sumDist:extended);
   for n:=lb0 to hb0 do sbl[n]:=wbl[n];// przeładować adresy
   CentroDistance(lb0,hb1glob,sbl,v1,meanDistance1);
   if k1>0 then meanDistance1:=meanDistance1/k1 else meanDistance1:=0;          //obliczyć centroidy zbiorów
   if -lb0+hb1glob+1<>k1 then error37('Proc. "CARTbestDivision"; Program error!, set should contain '+intToStr(k1)+' but it turned out, that it contains '+intToStr(-lb0+hb1glob+1)+' components!');
   CentroDistance(lb2Glob,hb0,sbl,v2,meanDistance2);
   if k2>0 then meanDistance2:=meanDistance2/k2 else meanDistance2:=0;
   if -lb2Glob+hb0+1<>k2 then error37('Proc. "CARTbestDivision"; Program error!, set should contain '+intToStr(k2)+
   ' but it turned out, that it contains '+intToStr(-lb2Glob+hb0+1)+' components!');
   ShowIterationProgress(ComponentNbr,distMaxNodeAddr,fix);//,nodeAddr);
  End;{CARTbestDivision}

 procedure FindBestDivision(const nodeAddr:word; var v1,v2:TmeanVector; var lb,hb:longWord;
  out meanDistance1,meanDistance2:extended; out iterNbr:word; var hb1,lb2:longWord; out k1,k2:longWord;const step:word);
  var
   n:longWord; centr1,centr2 : TmeanVector; break:boolean;
  Begin
   iterNbr:=0;
   n:=nodeprops[NodeAddr].cardinal;
   Repeat
    inc(iterNbr);                                                                           //v1,v2 - centra, dane wejściowe i wyjściowe
    form1.label17.Caption:=intToStr(iterNbr);  application.ProcessMessages;
    DivideSet(n,lb,hb,hb1,lb2,v1,v2,centr1,centr2,meanDistance1,meanDistance2,k1,k2);    //Podziel zbiór na 2 części wg odległości Euklidesa od centroidów   pomijając zdarzenia ze zbioru excludeSet
    if form1.CheckBox42.Checked  then ShowIterationProgress(iterNbr,nodeAddr,'trial')
    else  ShowIterationProgress(iterNbr,nodeAddr,'-');
    break:=(dist(v1,centr1)=0) and (dist(v2,centr2)=0);
    v1:=centr1; v2:=centr2;
   Until break;
   for n:=lb to hb do sbl[n]:=wbl[n];   //przeładować rozszczepiony odcinek
   inc(totalIterNbr,iterNbr);
   form1.Label128.Caption:=intToStr(totalIterNbr);
  End;{FindBestDivision}

  procedure LeafSummer(startNodeIndex:longWord);
  {
   biegnij po drzewie w poszukiwaniu liści i sumuj wartości IR, błędu rozpoznania i błędu kwantyzacji brane z props; działa w pętli procedury RUN
  }
  var t9,NodePercNorm :double;
   Begin  //-----------------------LeafSummer------------------
    if nodeHeap[startNodeIndex].son>0 then  LeafSummer(nodeHeap[startNodeIndex].son)
    else
     begin
      inc(leafNodeNbr);                                                     //numer liścia zablokowano tutaj nadawanie
      (*nodeHeap[startNodeIndex].son:=-leafNodeNbr;*)                       //liściom wartości ujemnych, bo prze-
      leafNodes[leafNodeNbr]:=startNodeIndex;    //numeracja liści drzewa   //szkadzałoby to w funkcjonowaniu CART i chyba niepotrzebne, bo liście są
      with form1, nodeProps[startNodeIndex] do
       begin
        if checkbox2.Checked then
         begin
          cath1IrGlob:=cath1IrGlob+cath1Ir;
          inc(cath1RecErrSum,cath1RecErr);               //sumy błędów rozpoznania
         end;
        if checkbox3.Checked then
         begin
          cath2IrGlob:=cath2IrGlob+cath2Ir;
          inc(cath2RecErrSum,cath2RecErr);
         end;
        if checkbox4.Checked then
         begin
          cath3IrGlob:=cath3IrGlob+cath3Ir;
          inc(cath3RecErrSum,cath3RecErr);
         end;
        t9:=cardinal*meanDistance;
        distortion:=distortion+t9;
       end;{with}
      if form1.checkBox27.Checked then             //grafy parametrów liści w funkcji liczby podziałów  (gdy opcja "nodes" włączona)
       begin
        nodePercNorm:=100/nodeProps[startNodeIndex].cardinal;     t9:=t9/nodeProps[startNodeIndex].cardinal;
        nodeCurrX:=(step-1+leafNodeNbr/(step+1))*wspx3+form1.panel3.left;        //NodePrevDistortion,NodePrevIRpers,NodePrevIRvoic,NodePrevErrcath1,NodePrevErrPers,NodePrevErrVoic
        IRdrawings(form1.Panel2,form1.canvas,CentroidsNb_glob,NodePrevX,nodeCurrX,NodePrevDistortion,                                           t9,       wspy2,topHeight2,clYellow);   //strech=prevDistortion:=nodeprops[0].meandistance,
        if form1.checkBox2.Checked then IRdrawings(form1.Panel3,form1.canvas,CentroidsNb_glob,NodePrevX,nodeCurrX,NodePrevIRcath1,                 nodeProps[startNodeIndex].cath1Ir,       wspy3,topHeight3,clBlue);    //strech=IRStretch,
        if form1.checkBox3.Checked then IRdrawings(form1.Panel3,form1.canvas,CentroidsNb_glob,NodePrevX,nodeCurrX,NodePrevIRpers,                 nodeProps[startNodeIndex].cath2Ir,     wspy3,topHeight3,clred);     //strech=IRStretch,
        if form1.checkBox4.Checked then IRdrawings(form1.Panel3,form1.canvas,CentroidsNb_glob,NodePrevX,nodeCurrX,NodePrevIRvoic,                 nodeProps[startNodeIndex].cath3Ir,      wspy3,topHeight3,clGreen);   //strech=IRStretch,
        if form1.checkBox2.Checked then IRdrawings(form1.Panel4,form1.canvas,CentroidsNb_glob,NodePrevX,nodeCurrX,NodePrevErrcath1,   NodePercNorm*nodeProps[startNodeIndex].cath1RecErr,   wspy4,topHeight4,clBlue);   //strech=errStretch,
        if form1.checkBox3.Checked then IRdrawings(form1.Panel4,form1.canvas,CentroidsNb_glob,NodePrevX,nodeCurrX,NodePrevErrPers,   NodePercNorm*nodeProps[startNodeIndex].cath2RecErr, wspy4,topHeight4,clred);    //strech=errStretch,
        if form1.checkBox4.Checked then IRdrawings(form1.Panel4,form1.canvas,CentroidsNb_glob,NodePrevX,NodeCurrX,NodePrevErrVoic,   NodePercNorm*nodeProps[startNodeIndex].cath3RecErr,wspy4,topHeight4,clGreen);  //strech=errStretch,
        NodePrevX:=nodeCurrX;
       end;
     end;
    if nodeHeap[startNodeIndex].brother>0 then  LeafSummer(nodeHeap[startNodeIndex].brother) //przejście
   End;{LeafSummer}

  procedure error17(i:word;j:longWord);
  var s:string;
   Begin
    s:='Error 17.'#13#10'Błąd programu: w histogramie głównym, cath1Pb, na pozycji '+intToStr(i)+
    ' wystąpiła wartość zerowa, a w histogramie cząstkowym, na tej samej pozycji, wartość '+intToStr(j)+#13#10+
    'Kontynuować program?'+#13#10'End of the error 17 description.';
    writeln(reportFile,s);
    if application.MessageBox(pchar(s),pchar('Error'),mb_yesNo)=idNo then halt;
   End;

 procedure error18(i:word;j:longWord);
  var s:string;
   Begin
    s:='Error 18.'#13#10'Błąd programu: w histogramie głównym, cath2Pb, na pozycji '+intToStr(i)+
    ' wystąpiła wartość zerowa, a w histogramie cząstkowym, na tej samej pozycji, wartość '+intToStr(j)+#13#10+
    'Kontynuować program?'+#13#10'End of the error 18 description.';
    writeln(reportFile,s);
    if application.MessageBox(pchar(s),pchar('Error'),mb_yesNo)=idNo then halt;
   End;

   procedure error19(i:word;j:longWord);
  var s:string;
   Begin
    s:='Error 19.'#13#10'Błąd programu: w histogramie głównym, cath3Pb, na pozycji '+intToStr(i)+
    ' wystąpiła wartość zerowa, a w histogramie cząstkowym, na tej samej pozycji, wartość '+intToStr(j)+#13#10+
    'Kontynuować program?'+#13#10'End of the error 19 description.';
    writeln(reportFile,s);
    if application.MessageBox(pchar(s),pchar('Error'),mb_yesNo)=idNo then halt;
   End;

 procedure errIRProcessing(const n:longWord; const nodeAddr:word; const NodeHist:THist;pbHist:TdbArr;
                            const NbrClass:byte; out IR:double; out max:byte; out error:longWord;
                            var checkSet:TcharSet; var all:boolean;const list:TcharList;const cl:longint;
                            var allStep:word; labelx:Tlabel);
{
oblicza IR i błąd klasyfikacji w węźle
pbHist - rozkład wrażenia w całej próbie
nodeHist - j.w. w węźle
NbrClass - liczba wartości (poziomów) zmiennej klasyfikującej
}
   var i,j,k:longWord;
    leafIr,p : extended;
    delta1,delta2:double;
  Begin  //----------------------errIRProcessing-------------------
   leafIr:=0;  delta1:=-5e324;  j:=high(j);
   for i:=0 to NbrClass do                                            //cath1Pb, to histogram fonemów w całej próbie
    begin
     k:=nodeHist[i]; p:=pbHist[i];
     delta2:=k;
     leafIr:=leafIr+IRadius(p,k/n);                                  //pk*ln(pk/pPlusQ)+pqkm*ln(pqkm/pPlusQ); n - liczebność zbioru
     if delta2>=delta1 then begin j:=i; delta1:=delta2 end;          //poszukać maksimum dla obliczenia błędu rozpoznania
    end;
   Ir:=leafIR/ln2;
   max:=j;
   Error:=n-nodeHist[j];
   if not all then    //find if all cathegory values have its own representing set
    with form1 do
    begin
     exclude(checkSet,list[max]);
     if checkSet =[] then
      begin
       all:=true;
       VertLine(panel2,cl4,currX);
       VertLine(panel3,cl,currX);
       VertLine(panel4,cl,currX);
       allStep:=step;
       labelx.Caption:=intToStr(step);
      end;
    end;
  End;{errIRProcessing}

  procedure MakeHistograms(const nodeAddr:longWord);  //oblicz histogramy fonemów i osób w węźle
   var i,n:longWord;
  Begin
   if form1.CheckBox1.Checked then exit;
   n:=0;
   with nodeProps[nodeAddr] do
   for i:=lb to hb do
      begin
       inc(n);
       if form1.CheckBox2.Checked then inc(cath1NodeHist[cath1Hash[eventcath1[sbl[i]]]]);
       if form1.CheckBox3.Checked then inc(cath2NodeHist[cath2Hash[eventcath2[sbl[i]]]]);
       if form1.CheckBox4.Checked then inc(cath3NodeHist[cath3Hash[eventcath3[sbl[i]]]]);
      end;
    with nodeProps[nodeAddr] do if n<> cardinal then  error50(n,cardinal,'MakeHistograms');
  End;{MakeHistograms}

 procedure TreeLeafSetProcess(const nodeAddr:word);
  {
  Oblicza histogram fonemów osób i dźwięczności w zbiorze i porównuje go z odpowiednimi histogramami całej próby
  }

   Begin
    if form1.CheckBox1.Checked then with nodeProps[nodeAddr] do begin cath1RecErr:=cardinal; cath2RecErr:=cardinal; cath3RecErr:=cardinal; exit end;
    HistReset;
    MakeHistograms(nodeAddr);
    with nodeProps[nodeAddr] do
    begin
    if form1.CheckBox2.Checked then errIRProcessing(cardinal,nodeAddr,cath1NodeHist,   cath1Pb,   cath1Nbr,
       nodeprops[nodeAddr].cath1IR,  nodeprops[nodeAddr].cath1,    nodeprops[nodeAddr].cath1RecErr, checkcath1Set,
       allcath1,cath1CodeList,cl1,cath1AllStep,form1.label138)
    else cath1RecErr:=cardinal;    //porównaj histogramy liści z histogramem zerowym
    if form1.CheckBox3.Checked then errIRProcessing(cardinal,nodeAddr,cath2NodeHist, cath2Pb, cath2Nbr,
     nodeprops[nodeAddr].cath2IR,nodeprops[nodeAddr].cath2, nodeprops[nodeAddr].cath2RecErr,checkcath2Set,allcath2,cath2CodeList,cl2,cath2AllStep,form1.label139)
    else cath2RecErr:=cardinal;
    if form1.CheckBox4.Checked then errIRProcessing(cardinal,nodeAddr,cath3NodeHist,cath3Pb,cath3Nbr,
     nodeprops[nodeAddr].cath3IR, nodeprops[nodeAddr].cath3,nodeprops[nodeAddr].cath3RecErr,checkcath3Set,allcath3,cath3CodeList,cl3,cath3AllStep,form1.label140)
    else cath3RecErr:=cardinal;
    end;{with}
   End;{TreeLeafSetProcess}

 procedure CARTtreeConstructor(const startNodeAddr:longWord);
   var i:longWord;
  Begin  //------------------------------------------------CARTtreeConstructor------------------------------
   if nodeHeap[startNodeAddr].son>0 then error9(startNodeAddr);
   with nodeHeap[startNodeAddr] do son:=-son;                                           //adres następnika
   i:=nodeHeap[startNodeAddr].son;
   inc(fissionCounter);                                                                 //28.12.06 w CARTlike nie można powiększać licznika rozszczepień
   with nodeProps[NodeHeap[i].brother] do leafIdx:=fissionCounter;
   if form1.RadioGroup12.ItemIndex =0 then ShowIterationProgress(ComponentNbr,startNodeAddr,'fixed!')
   else ShowIterationProgress(iterNbr,startNodeAddr,'fixed!');
  End;{CARTtreeConstructor}


 procedure treeConstructor(const startNodeAddr:longWord;var heapTop:longWord;const hb1,lb2:longWord;const centro1,centro2:TmeanVector;
  const meanDistance1,meanDistance2:double;const iterNbr:word; const k1,k2:longWord;const trial:boolean; const ComponentNbr:byte);
 {
 konstruuje graf drzewiasty
 startNodeAddr - adres węzła od którego kontynuuje się rozbudowę grafu;
                 będzie ujemny, gdy następniki będą efektem rozszczepienia próbnego (CART)
 }
 var i:longWord;

  Begin  //------------------------------------------------treeConstructor------------------------------
   if nodeHeap[startNodeAddr].son>0 then error9(startNodeAddr);
   nodeProps[startNodeAddr].iterNbr:=iterNbr;
   nodeProps[startNodeAddr].fissionDistance:=dist(centro1,centro2);
   i:=heapTop+1;                                                                                   //radiogroup12, pure CART, PRZODEK (!!) węzła otrzymuje nr optymalnej składowej wektora cech oraz śreadnią tej składowej w
   if form1.RadioGroup12.ItemIndex=0 then nodeProps[startNodeAddr].OptComponentNbr:=ComponentNbr;  //jego zbiorze (wciąż jest jeszcze liściem, więc jego zbiór jest jeszcze dostępny) przodek, bo właściwości tej nie posiadają jeszcze następniko, bo nie były jeszcze rozbijane!
   if trial then nodeHeap[startNodeAddr].son:=-i                              //radiogroup22, CART-like                           //adres następnika //było: form1.RadioGroup22.ItemIndex=3 {09.07.09}
   else nodeHeap[startNodeAddr].son:=i;                                             //ujemna wartość oznacza węzły rozszczepienia próbnego CART
   inc(heapTop,2); if heapTop>nodeHeapTop then error8;
   with NodeHeap[i] do                                                              //węzeł następnika (sonCreate) ==============================
    begin
     brother:=heapTop;
     son:=0;                                                                        //w czystym CART zbiór jest przypisywany poprzednikowi...
     with nodeProps[i] do
      begin
       centroid:=centro1;
       cardinal:=k1;
       leafIdx:=nodeProps[startNodeAddr].leafIdx;                                   //09.11.05   numer liścia jest tu dziedziczony
       lb:=nodeProps[startNodeAddr].lb; hb:=hb1;
       meanDistance:=meanDistance1;
      end;{with}
    end;{with}
   TreeLeafSetProcess(i);       //28.12.06 w CARTlike distortion nie analizować rozkładów
   if not ((form1.checkBox42.Checked) or (form1.RadioGroup12.ItemIndex=0)) then inc(fissionCounter);                                         //28.12.06 w CART i w CARTlike nie można powiększać licznika rozszczepień, bo zliczane byłyby próbne rozszczepy
   with NodeHeap[heapTop] do                                                     //węzeł alternatywy następnika  (brotherCreate) ==============================
    begin
     brother:=0;
     son:=0;                                                                     //w czystym CART zbiór jest przypisywany poprzednikowi...
     with nodeProps[heapTop] do
      begin
       centroid:=centro2;
       cardinal:=k2;
       leafIdx:=fissionCounter;                                                  //09.11.05
       lb:=lb2; hb:=nodeProps[startNodeAddr].hb;
       meanDistance:=meanDistance2
       end;
    end;{with}
   TreeLeafSetProcess(heapTop);  //28.12.06 w CARTlike distortion nie analizować rozkładów
  End;{treeConstructor}

   procedure FeaturesTreeInspector(startNodeIndex:longWord; const featureLevelNbr1,featureLevelNbr2:word;
    var Hash1,Hash2 :TcharByte; var response1,response2:TcharList; var Pb1,Pb2:TdbArr;l94:char);
  {
   Alternatywa do DistancesInspectTree, wywoływać z poziomu lookForBestSet (jako InspectTree)
   Biegnij po drzewie w poszukiwaniu liścia o największym przyroście IR (albo, w zależności od opcji- dystorsji
   albo błędu rozpoznania) wskutek podziału wg pewnej składowej wektora cech.
   Działa na etapie tworzenia drzewa kwantującego.
       rareEventNbr1   - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
       Hash:TcharByte  - lista  poziomów klasyfikacji zdarzeń wg danego wrażenia (skorowidz kodów numerowych);
                         jedna z: cath1Hash, cath2Hash, cath3Hash
       response:TcharList - klasyfikacja zdarzeń, jedna z: eventcath1, eventcath2, eventcath3. Czytane w
                            "vectorAndCathListRead" równolegle z wektorami analiz spektralnych
   Hash1, 2, response1, 2 - dane dotyczące odpowiednio: oceny wyboru cechy i oceny wyboru zbioru do kolejnego podziału
                    Pb - cath1Pb lub cath2Pb lub cath3Pb (prawdopodobieństwa empiryczne w węźle zerowym)
          componentNbr - numer komponentu wektora cech najlepiej klasyfikującego dany zbiór
           deltaIRglob - przyrost IR wskutek rozszczepienia wg componentNbr; zerować przed wywołaniem tej procedury!!!

   Hash służy do tworzenia histogramów, wskazuje numer słupka, który należy powiększać, np.:
         if form1.CheckBox2.Checked then inc(cath1NodeHist[cath1Hash[eventcath1[i]]]);
   (transformacja konieczna, bo histogram jest tablicą dynamiczną, a tam indeks jest liczbowy)
  }

   Begin  //-----------------------FeaturesTreeInspector------------------
    form1.Label94.Caption:=l94;  if not clasRegister then begin classKind:=l94; clasRegister:=true end;
         {deltaIRglob:=0; - zerowanie musi być przed wywołaniem tej procedury!!}
    if nodeHeap[startNodeIndex].son>0 then
     FeaturesTreeInspector(nodeHeap[startNodeIndex].son,featureLevelNbr1,featureLevelNbr2,hash1,hash2,
                           response1,response2,Pb1,Pb2,'s')
    else  //------------------------------------osiągnięto liść
     Begin
      inc(leafCounter);
      with nodeProps[startNodeIndex] do
      if ((cardinal>=rareEventNbr1) and (meanDistance>5e-323)) then
       Begin
        form1.Label79.Caption:=intToStr(startNodeIndex);   Application.processMessages;
        if nodeHeap[startNodeIndex].son<0 then  with form1,nodeHeap[startNodeIndex] do   //liść był już próbnie rozbity, są dane potomków (za wyjątkiem zbioru...)
         begin   //- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
          Label94.Caption:=UpperCase(l94);  featureFound:=true;
          componentNbr:=nodeProps[startNodeIndex].OptComponentNbr;  Label17.Caption:=intToStr(componentNbr);
          k1:=nodeProps[-son].cardinal;     //liczebności potomków
          k2:=nodeProps[nodeHeap[-son].brother].cardinal;
          meanDistance1:=nodeProps[-son].meanDistance;
          meanDistance2:=nodeProps[nodeHeap[-son].brother].meanDistance;
          hb1glob:=nodeProps[-son].hb;
          lb2glob:=nodeProps[nodeHeap[-son].brother].lb;
          deltaIRglob:=ResponseChecker(startNodeIndex);
         end {son<0}
        else            //son=0, liść nie był jeszcze próbnie rozbity
         Begin
          if inSet(startNodeIndex,leafNodeSet) then error34(startNodeIndex,step);
          FindBestFeature(startNodeIndex,cardinal, nodeProps[startNodeIndex].lb,nodeProps[startNodeIndex].hb,
                          featureLevelNbr2,Hash2,response2,Pb2,componentNbr,deltaIRglob);
          if featureFound then
           begin
            includeToSet(leafNodeSet,startNodeIndex);
            CARTbestDivision(ComponentNbr,v1,v2,startNodeIndex,nodeProps[startNodeIndex].lb,nodeProps[startNodeIndex].hb,
             meanDistance1,meanDistance2,k1,k2,step,nodeHist_glob,'trial');  //out: v1,v2 - centra  meanDistance1,meanDistance2 - śreadnia odległość od centroidu w potomkach
            treeConstructor(startNodeIndex,heapTop,hb1glob,lb2glob,v1,v2,meanDistance1,meanDistance2,iterNbr,k1,k2,true,ComponentNbr);
           end;
         End; {son=0}
        if featureFound then
         begin
          if (@SetChoiceDivisionEvaluation<>@FeaturesChoiceDivisionEvaluation) then  //ocena wyboru zbioru, tutaj zmieni się jedynie deltaIRglob, która decyduje o wyborze zbioru do podziału
           begin
            If form1.RadioGroup26.ItemIndex=1 then                    //nowe histogramy są potrzebne tylko w trybie "supervised", dlatego ten warunek
            Histograms(cardinal,nodeProps[startNodeIndex].lb,nodeProps[startNodeIndex].hb,ComponentNbr,k1,k2,nodeHist_glob,
                       Hash1,response1,nodeProps[startNodeIndex].centroid[ComponentNbr],featureLevelNbr1);                //ComponentNbr, bo oceniamy wybrany podział wykonany wg składowej wektora cech o tym numerze
            try
             SetChoiceDivisionEvaluation(cardinal,TempHist1,TempHist2,NodeHist_glob,FeatureLevelNbr1,Pb1,setChoiceCritGlob,
              k1,k2,nodeProps[startNodeIndex].lb,nodeProps[startNodeIndex].hb,hb1glob,lb2glob,startNodeIndex,form1.RadioGroup24,sbl);                         //Hash,event muszą dotyczyć tutaj zmiennej klasyfikującej w przypadku, gdy mamy do czynienia z trybem "supervised"
            except
             error46('SetChoiceDivisionEvaluation',form1.RadioGroup22);
            end;
           end {if @}
          else setChoiceCritGlob:=deltaIRglob;        //******************************************
          if (setChoiceCritGlob>distMax)  then       //zdecydować o wyborze zbioru do podziału
           begin
            nodeFound:=true;
            distMax:=setChoiceCritGlob;
            distMaxNodeAddr:=startNodeIndex;
            globComponentNbr:=ComponentNbr;
           end;
         end;{featureFound}
       End;{with}
     End;{else}
    deltaIRglob:=-1e+324; //bo wartość deltaIRglob jest wleczona w górę przy przeskoku na brata, co blokowało możliwość indywidualnego wyboru cechy, gdy IR w poprzednim węźle uzyskała wysoka wartość
    if nodeHeap[startNodeIndex].brother>0 then
    FeaturesTreeInspector(nodeHeap[startNodeIndex].brother,featureLevelNbr1,featureLevelNbr2,hash1,hash2,
                           response1,response2,Pb1,Pb2,'b') //przejście na brata
  End;{FeaturesTreeInspector}


 procedure FeaturesInspectTree(startNodeIndex:longWord);

    {
    Obudowa do  FeaturesTreeInspector
     Wrażenie jest determinowane poprzez alternatywne wywołanie  FeaturesTreeInspector.
     UWAGA. Dla trybu "distortion" wartości argumentów są bez znaczenia, występują tylko dla uzyskania zgodności zmiennej proceduralnej...
     parametry empty- to tablice puste, nieprzydzielone RAM
    }

    Begin
     leafCounter:=0;    //30.10.07
     deltaIRglob:=-1e+324;  setChoiceCritGlob:=0;
     form1.Label79.Caption:=intToStr(startNodeIndex{nodeProps[startNodeIndex].leafIdx});
     case form1.RadioGroup24.ItemIndex  of                                             //rodzaje wrażeń  (żółte)
     -1:                                                                               //żółte distortion;                                          żółte         zielone
        case form1.RadioGroup25.ItemIndex  of                                          //rodzaje wrażeń (zielone)                                 //wybór zbioru, wybór cechy
         -1: FeaturesTreeInspector(0, 255,255,           emptyHash,emptyHash,  emptyResponse,emptyResponse,emptyIndex,emptyIndex,'A');            //distortion,   distortion
          0: FeaturesTreeInspector(0, 255,cath1Nbr,       emptyHash,cath1Hash,   emptyResponse,eventcath1,    emptyIndex,cath1Pb,'B');                //distortion,   cath1
          1: FeaturesTreeInspector(0, 255,cath2Nbr,     emptyHash,cath2Hash, emptyResponse,eventcath2,  emptyIndex,cath2Pb,'C');              //distortion,   cath2
          2: FeaturesTreeInspector(0, 255,cath3Nbr,emptyHash,cath3Hash,emptyResponse,eventcath3, emptyIndex,cath3Pb,'D');             //distortion,   cath3
         end;{case}
      0:                                                                               //żółte cath1
         case form1.RadioGroup25.ItemIndex  of                                         //rodzaje wrażeń (zielone)
         -1: FeaturesTreeInspector(0, cath1Nbr,255,           cath1Hash,emptyHash,  eventcath1,emptyResponse,cath1Pb,emptyIndex,'E');                 //cath1,      distortion
          0: FeaturesTreeInspector(0, cath1Nbr,cath1Nbr,       cath1Hash,cath1Hash,   eventcath1,eventcath1,    cath1Pb,cath1Pb,'F');                     //cath1,      cath1
          1: FeaturesTreeInspector(0, cath1Nbr,cath2Nbr,     cath1Hash,cath2Hash, eventcath1,eventcath2,  cath1Pb,cath2Pb,'G');                   //cath1,      cath2
          2: FeaturesTreeInspector(0, cath1Nbr,cath3Nbr,cath1Hash,cath3Hash,eventcath1,eventcath3, cath1Pb,cath3Pb,'H');                  //cath1,      cath3
         end;{case}
      1:                                                                               //żółte cath2
         case form1.RadioGroup25.ItemIndex  of                                         //rodzaje wrażeń (zielone)
         -1: FeaturesTreeInspector(0, cath2Nbr,255,           cath2Hash,emptyHash,  eventcath2,emptyResponse,cath2Pb,emptyIndex,'I');         //cath2,       distortion;
          0: FeaturesTreeInspector(0, cath2Nbr,cath1Nbr,       cath2Hash,cath1Hash,   eventcath2,eventcath1,    cath2Pb,cath1Pb,'J');             //cath2,       cath1
          1: FeaturesTreeInspector(0, cath2Nbr,cath2Nbr,     cath2Hash,cath2Hash, eventcath2,eventcath2,  cath2Pb,cath2Pb,'K');           //cath2,       cath2
          2: FeaturesTreeInspector(0, cath2Nbr,cath3Nbr,cath2Hash,cath3Hash,eventcath2,eventcath3, cath2Pb,cath3Pb,'L');          //cath2,       cath3
         end;{case}
      2:                                                                               //żółte  cath3
          case form1.RadioGroup25.ItemIndex  of                                        //rodzaje wrażeń (zielone)
          -1: FeaturesTreeInspector(0, cath3Nbr,255,           cath3Hash,emptyHash,  eventcath3,emptyResponse,cath3Pb,emptyIndex,'M'); //cath3,      distortion;
           0: FeaturesTreeInspector(0, cath3Nbr,cath1Nbr,       cath3Hash,cath1Hash,   eventcath3,eventcath1,    cath3Pb,cath1Pb,'N');     //cath3,      cath1
           1: FeaturesTreeInspector(0, cath3Nbr,cath2Nbr,     cath3Hash,cath2Hash, eventcath3,eventcath2,  cath3Pb,cath2Pb,'O');   //cath3,      cath2
           2: FeaturesTreeInspector(0, cath3Nbr,cath3Nbr,cath3Hash,cath3Hash,eventcath3,eventcath3, cath3Pb,cath3Pb,'P');  //cath3,      cath3
          end;{case}
     else error37('Invalid sensation number, program error, procedure "FeaturesInspectTree"');
     end;{case}
    End;{FeaturesInspectTree}

 procedure QuickSort(var leafCardArr:array of longWord; l,r:longWord);
     //sortuje tablicę liczebności liści
   var i,j,x,y : int64;
   begin
     i:=l; j:=r; x:=leafCardArr[(l+r) DIV 2];
     repeat
      while leafCardArr[i]<x do i:=i+1;
      while x<leafCardArr[j] do j:=j-1;
      if i<=j then
      begin
       y:=leafCardArr[i]; leafCardArr[i]:=leafCardArr[j]; leafCardArr[j]:=y;
       i:=i+1; j:=j-1;
      end;
     until i>j;
     if l<j then QuickSort(leafCardArr,l,j);
     if i<r then QuickSort(leafCardArr,i,r);
   end;{QuickSort}

 function TakeInitialCentroidsSTD(out v1,v2:TmeanVector; const lb,hb:longWord; const centroid:TmeanVector;const nodeAddr:word):boolean;
{
oblicza wektory v1, v2 jako centroidy odległe od środka o pewną ilość (multStdDev) odchyleń standardowych od centrum zbioru
lb,hb - zakres, w którym mieszczą się indeksy rozbijanego zbioru
sbl - lista adresów zbiorów
stdev=sqrt[E(x kw)-(E(x))kw], tj.   śreadnia z kwadratów minus kwadrat śreadniej
TIC(v1,v2,nodeProps[NodeAddr].lb,nodeProps[NodeAddr].hb,nodeProps[NodeAddr].centroid) //TIC=TakeInitialCentroids
}
 var i,j : longword;
  var   temp:double;
 begin //----------------TakeInitialCentroidsSTD--------
  result:=true;
  for j:=0 to nc-1 do
   begin
    sz[j]:=0; sk[j]:=0
   end; //wektory sum
  for i:=lb to hb do                           //sumy zwykłe i sumy kwadratów składowych
   begin
   for j:=0 to nc-1 do                               //składowe wektora odchyleń standardowych
    begin
     temp:=vectList[sbl[i],j];  //vectList[i,sbl[j]];
     sz[j]:=sz[j]+temp;
     sk[j]:=sk[j]+temp*temp;//sqr(vectList[sbl[j],i]); dawał ujemne wyniki!!!!!
    end;
   end; 
  for j:=0 to nc-1 do
   begin if not (j in featureSet) then continue;
    temp:=sz[j]/(hb-lb+1);            //śreadnia składowej
    temp:=-temp*temp+sk[j]/(hb-lb+1); //śreadnia z kwadratów minus kwadrat śreadniej; 18.12.09 zamiana sqr na temp*temp
    if temp<0 then error58('TakeInitialCentroids');
    stdev[j]:=sqrt(temp);
    nodeProps[nodeAddr].nodeStdev[j]:=stdev[j];
    nodeProps[nodeAddr].nodeStep:=step;
    if stdev[j]<0 then error58('TakeInitialCentroids');
    v1[j]:=centroid[j]-multStdDev*stdev[j];
    v2[j]:=centroid[j]+multStdDev*stdev[j];
   end;
 end;{TakeInitialCentroidsSTD}


 function TakeInitialCentroids(out v1,v2:TmeanVector; const lb,hb:longWord; const centroid:Tvect):boolean;
{
wybiera dwa niezbyt odległe wektory v1, v2 jako centroidy
lb,hb - zakres, w którym mieszczą się indeksy rozbijanego zbioru
sbl - lista adresów zbiorów
; const centroid:Tvect - dla zgodności
}
 var i : longword;  k:byte;
 dist1,dist2 : extended;
          vt : TmeanVector;       //l zapamiętuje ostatnią wartość należącą jeszcze bo zbioru
 begin //----------------TakeInitialCentroids--------
  for k:=0 to nc-1 do vt[k]:=vectList[sbl[lb],k];
  v1:=vt; v2:=vt;                                 //v1 - pierwszy centroid, v2 - drugi centroid
  dist2:=0;
  i:=lb;
  Repeat                                                 //znajdź najbliższy najodleglejszy wektor (lokalne maksimum odległości
   dist1:=dist2;
   inc(i);
   for k:=0 to nc-1 do vt[k]:=vectList[sbl[i],k];
   dist2:=dist(v1,vt);
  Until (dist2<dist1) or (i>hb);
  for k:=0 to nc-1 do v2[k]:=vectList[sbl[i-1],k];
  result:=dist(v1,v2)>0;
 end;{TakeInitialCentroids}

 function readFirstCentroids(nc:byte; var centroid1,centroid2:TmeanVector(*;ext:char*)):boolean;
 {
 Odczytuje centroidy pierwszego podziału z uprzednio wykonanej analizy
 }
 var j:word; sTmp:string;  logos:boolean;
 procedure error;
  begin
   result:=false;
   error37('Proc. "ReadFirstCentroids"'#13#10'The first centroids could not be read. The existing tree'#13#10+
    treeFileDir+#13#10'differs, probably does not contain line "Quantization tree" or the line has been changed in some way.'+
    #13#10'The line is a mark signalling end of the initial information part of the tree text.');
   closeFile(treeFile);
  end;{error}

 Begin
  readFirstCentroids:=true;
  assignFile(treeFile,treeFileDir);//+ext); blok 12.03.09
  reset(treeFile);
  try
  readln(treeFile,sTmp);   //date&time...
  readln(treeFile,sTmp);   //Teaching events file:
  readln(treeFile,j);      //CART|centroids
  if j<>form1.RadioGroup12.ItemIndex then
   begin
    case form1.RadioGroup12.ItemIndex of
     0: error37('Proc. "ReadFirstCentroids"'#13#10'The first centroids could''t be read. The existing tree'#13#10+
        treeFileDir+#13#10'was preparead with the "centroids" but now you apply the "CART" method'#13#10'Try again, do not read the "first centroids"');
     1: error37('Proc. "ReadFirstCentroids"'#13#10'The first centroids can''t be read. The existing tree'#13#10+
        treeFileDir+#13#10'was preparead with the "CART" but now you apply the "centroids"  method'#13#10'Try again, do not read the "first centroids"');
    end;{case}
    readFirstCentroids:=false;
    closeFile(treeFile);
    exit;
   end;
  repeat
   readln(treeFile,sTmp);   //Quantization tree
   logos:=(sTmp='Quantization tree') or seekEof(treeFile);
  until logos;
  if  seekEof(treeFile) then begin error; exit; end;
  readln(treeFile,sTmp);   //"son, brother"
  readln(treeFile,sTmp);   //son, brother
  readln(treeFile,sTmp);   //"Centroid"
  for j:=0 to nc-1 do
   readln(treeFile,centroid2[j]);
  readln(treeFile,sTmp);   //"son, brother"
  readln(treeFile,sTmp);   //son, brother
  readln(treeFile,sTmp);   //"Centroid"
  for j:=0 to nc-1 do readln(treeFile,centroid1[j]); readln(treeFile); //empty row
  readln(treeFile,sTmp);   //"son, brother"
  readln(treeFile,sTmp);   //son, brother
  readln(treeFile,sTmp);   //"Centroid"
  for j:=0 to nc-1 do readln(treeFile,centroid2[j]); readln(treeFile); //empty row
  except
   error;
   exit;
  end;{except}
  closeFile(treeFile);
 End;

 function LookForInitialCentroids(const nodeAddr:word):boolean;
 {
 Okresla źródło centroidów
 w zależności od tego, czy jest to pierwszy krok czy dalsze i czy została włączona opcja "Czytaj centroidy z dysku"
 }
  Begin
   result:=true;
   if (step=1) and fileExists(treeFileDir) and (form1.CheckBox16.checked or secondPass and not form1.CheckBox17.checked) then           //form1.CheckBox16.checked = "Read first centroids",
    if secondPass and form1.CheckBox16.checked then readFirstCentroids(nc,v1,v2) //,'1') blok 12.03.09
    else
     if application.MessageBox(pchar('Should I read first centroids (from'#13#10'"'+treeFileDir(*+'1")'*)+'?'),'Centroids reading',mb_YesNo)=idYes then  // form1.CheckBox17.checked = "Overrite existed tree files without warning?"
      begin    //TakeInitialCentroids(out v1,v2:T128DoubleArr; const lb,hb:longWord):boolean;
      result:=readFirstCentroids(nc,v1,v2);//,'1'); blok 12.03.09
      if not result then result:=TIC(v1,v2,nodeProps[NodeAddr].lb,nodeProps[NodeAddr].hb,nodeProps[NodeAddr].centroid,nodeAddr) //TIC=TakeInitialCentroids
      end
     else result:=TIC(v1,v2,nodeProps[NodeAddr].lb,nodeProps[NodeAddr].hb,nodeProps[NodeAddr].centroid,nodeAddr)   //TIC=TakeInitialCentroids
   else   result:=TIC(v1,v2,nodeProps[NodeAddr].lb,nodeProps[NodeAddr].hb,nodeProps[NodeAddr].centroid,nodeAddr);    //TIC=TakeInitialCentroids
  End;{LookForInitialCentroids}

  procedure DistancesInspectTree(startNodeIndex:longWord);
  {
   biegnij po drzewie w poszukiwaniu liścia o największej sumie odległości Euklidesa albo śreadniej odległości Euklidesa
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
   meanDistance - pochodzi z FindBestDivision\DivideSet
  }
   Begin  //-----------------------DistancesInspectTree------------------
    if nodeHeap[startNodeIndex].son>0 then  DistancesInspectTree(nodeHeap[startNodeIndex].son)
    else
     with nodeProps[startNodeIndex] do
     if (cardinal>=rareEventNbr1) and (meanDistance>5e-323) then
     if form1.radiogroup4.ItemIndex=0 then     //śreadniej odległości Euklidesa
      if (meanDistance>distMax) then
      begin
       form1.Label79.Caption:=intToStr(startNodeIndex);
       nodeFound:=true;
       distMax:=meanDistance;
       distMaxNodeAddr:=startNodeIndex;
      end
      else
     else
      if (meanDistance*cardinal>distMax) then  //sumie odległości Euklidesa
      begin
       form1.Label79.Caption:=intToStr(startNodeIndex);
       nodeFound:=true;
       distMax:=meanDistance*cardinal;
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     DistancesInspectTree(nodeHeap[startNodeIndex].brother) //przejście na brata
   End;{DistancesInspectTree}


procedure cath1ErrorInspectTree(startNodeIndex:longWord);
  {
   biegnij po drzewie w poszukiwaniu liścia o najmniejszym błędzie rozpoznania fonemów
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
  cath1RecErr  pochodzi z ErrIrProcessing
  }
   Begin  //-----------------------cath1ErrorInspectTree------------------
    if nodeHeap[startNodeIndex].son>0 then  cath1ErrorInspectTree(nodeHeap[startNodeIndex].son)
    else
     with nodeProps[startNodeIndex] do if (cath1RecErr>distMax) and (cardinal>=rareEventNbr1) and (meanDistance>5e-323) and (cath1RecErr>0) then
      begin
       form1.Label79.Caption:=intToStr(startNodeIndex);
       nodeFound:=true;
       distMax:=nodeProps[startNodeIndex].cath1RecErr;
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     cath1ErrorInspectTree(nodeHeap[startNodeIndex].brother) //przejście na brata
   End;{cath1ErrorInspectTree}

procedure cath2ErrorInspectTree(startNodeIndex:longWord);
  {
   biegnij po drzewie w poszukiwaniu liścia o najmniejszym błędzie rozpoznania osób
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
   cath2RecErr pochodzi z Treecath2IRProcessing
  }
   Begin  //-----------------------cath2ErrorInspectTree------------------
    if nodeHeap[startNodeIndex].son>0 then  cath2ErrorInspectTree(nodeHeap[startNodeIndex].son)
    else
     with nodeProps[startNodeIndex] do if (cath2RecErr>distMax) and (cardinal>=rareEventNbr1) and (meanDistance>5e-323) and (cath2RecErr>0) then
      begin
       form1.Label79.Caption:=intToStr(startNodeIndex);
       nodeFound:=true;
       distMax:=nodeProps[startNodeIndex].cath2RecErr;
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     cath2ErrorInspectTree(nodeHeap[startNodeIndex].brother) //przejście na brata
   End;{cath2ErrorInspectTree}

procedure cath3ErrorInspectTree(startNodeIndex:longWord);
  {
   biegnij po drzewie w poszukiwaniu liścia o najmniejszym błędzie rozpoznania dźwięczności
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
  cath3RecErr pochodzi z Treecath3IRProcessing
  }
   Begin  //-----------------------cath3ErrorInspectTree------------------
    if nodeHeap[startNodeIndex].son>0 then  cath3ErrorInspectTree(nodeHeap[startNodeIndex].son)
    else
     with nodeProps[startNodeIndex] do if (cath3RecErr>distMax) and (cardinal>=rareEventNbr1) and (meanDistance>5e-323)and (cath3RecErr>0) then
      begin
       form1.Label79.Caption:=intToStr(startNodeIndex);
       nodeFound:=true;
       distMax:=nodeProps[startNodeIndex].cath3RecErr;
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     cath3ErrorInspectTree(nodeHeap[startNodeIndex].brother) //przejście na brata
   End;{cath3ErrorInspectTree}

procedure cath1IRInspectTree(startNodeIndex:longWord);
  {
   biegnij po drzewie w poszukiwaniu liścia o najmniejszym promieniu informacji dla  fonemów
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
   cath1Ir pochodzi z TreeLeafSetProcess/ErrIrProcessing
  }
   Begin  //-----------------------cath1IRInspectTree------------------
    if nodeHeap[startNodeIndex].son>0 then  cath1IRInspectTree(nodeHeap[startNodeIndex].son)
    else
     with nodeProps[startNodeIndex] do if (-cath1Ir>=distMax) and (cardinal>=rareEventNbr1) and (meanDistance>5e-323) and (cath1Ir<cath1IRmax)  then        //08-05-09; ujednolicenie wartości początkowej mxDelta: - przed cath1IR i >= zamiast <
      begin
       form1.Label79.Caption:=intToStr(startNodeIndex);
       nodeFound:=true;
       distMax:=-nodeProps[startNodeIndex].cath1Ir;                  //10-05-09; ujednolicenie wartości początkowej mxDelta: wprowadzono - przed nodeProps
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     cath1IRInspectTree(nodeHeap[startNodeIndex].brother) //przejście na brata
   End;{cath1IRInspectTree}

procedure cath2IRInspectTree(startNodeIndex:longWord);
  {
   biegnij po drzewie w poszukiwaniu liścia o najmniejszym promieniu informacji dla osób
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
   cath2Ir pochodzi z TreeLeafSetProcess/ErrIrProcessing
  }
   Begin  //-----------------------cath2IRInspectTree------------------
    if nodeHeap[startNodeIndex].son>0 then  cath2IRInspectTree(nodeHeap[startNodeIndex].son)
    else
     with nodeProps[startNodeIndex] do if (cath2Ir<distMax) and (cardinal>=rareEventNbr1) and (meanDistance>5e-323) and (cath2Ir<cath2IRmax) then
      begin
       form1.Label79.Caption:=intToStr(leafIdx);
       nodeFound:=true;
       distMax:=nodeProps[startNodeIndex].cath2Ir;
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     cath2IRInspectTree(nodeHeap[startNodeIndex].brother) //przejście na brata
   End;{cath2IRInspectTree}


procedure cath3IRInspectTree(startNodeIndex:longWord);
  {
   biegnij po drzewie w poszukiwaniu liścia o najmniejszym promieniu informacji dla dźwięczności
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
   cath3Ir pochodzi z TreeLeafSetProcess/ErrIrProcessing
  }
   Begin  //-----------------------cath3IRInspectTree------------------
    if nodeHeap[startNodeIndex].son>0 then  cath3IRInspectTree(nodeHeap[startNodeIndex].son)
    else
     with nodeProps[startNodeIndex] do if (cath3Ir<distMax) and (cardinal>=rareEventNbr1) and (meanDistance>5e-323) and (cath3Ir<cath3IRmax)  then
      begin
       form1.Label79.Caption:=intToStr(startNodeIndex);
       nodeFound:=true;
       distMax:=nodeProps[startNodeIndex].cath3Ir;
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     cath3IRInspectTree(nodeHeap[startNodeIndex].brother) //przejście na brata
   End;{cath3IRInspectTree}

 procedure deltaCompare(const startNode:word;const newDistortion:double; var tryDelta:double; out distMaxNodeAddr:LongWord; out nodeFound:boolean);
   begin
    with nodeprops[startNode] do if (tryDelta<newDistortion) and (cardinal>=rareEventNbr1) and (meanDistance>5e-323) then
     begin                                  //----------------------wskaż liść do rozszczepienia-----------------
      tryDelta:=newDistortion;              // trik:=cardinal*meanDistance-dist1-dist2; if round(trik)<>round(trydelta) then showMessage('wow!');// 05.08.2007
      distMaxNodeAddr:=startNode; nodeFound:=true;
     end;
   end;{deltaCompare}

 procedure CARTlike(startNode:longWord);
 {
 Alternatywa dla DistancesInspectTree
 }
   procedure CARTiNO(startNode:longWord;sb:char);
   { -------nagłówek Cartino nie zgadza się z nagłówkiem Inspect Tree, dlatego otacza ją CARTlike-------
   Przegląda wszystkie liście i wybiera zbiór do rozszczepienia metodą CARTlike
    k1, k2 - liczebności zbiorów
    ResponseChecker - zmienna proceduralna; ResponseChecker = checkDistortion|checkcath1IR|checkcath2IR|checkcath3IR
    startNode - adres próbnie rozbijanego liścia
   }
   Begin   //---------------look for the best split
    with nodeHeap[startNode] do
    if son>0 then CARTiNo(son,'s')           //biegnij do liścia
    else                                               //osiągnięto liść
     Begin
      if son<0 then                                    //liść był już próbnie rozbity, są dane potomków (za wyjątkiem zbioru...)
       begin
        form1.Label94.Caption:=UpperCase(sb);
        try
         deltaCompare(startNode,ResponseChecker(startNode),tryDelta,distMaxNodeAddr,nodeFound);
        except
         error46('deltaCompare, ResponseChecker',form1.RadioGroup22)
        end {try}
       end {son<0}
      else    //son=0, liść nie był jeszcze próbnie rozbity, i reprezentuje zbiór o więcej niz 1 elemencie, meanDistance>5e-323 dodano 19.12.09, bo walił się na przypadku, gdy zbiór składał się z identycznych elementów
      if (nodeProps[startNode].cardinal>1) and (nodeProps[startNode].meanDistance>5e-323) then
       begin //-------------
        form1.Label94.Caption:=sb;  form1.Label79.Caption:=intToStr(startNode);
        if LookForInitialCentroids(startNode) then
         begin   //treeConstructor wpisze ujemny adres następnika rozszczepianego węzła, co oznaczać będzie rozszczepienie próbne
          FindBestDivision(startNode,v1,v2,nodeProps[startNode].lb,nodeProps[startNode].hb,
           meanDistance1,meanDistance2,iterNbr,hb1glob,lb2glob,k1,k2,step);
          treeConstructor(startNode,heapTop,hb1glob,lb2glob,v1,v2,meanDistance1,meanDistance2,iterNbr,k1,k2,true,0);
          try
           deltaCompare(startNode,ResponseChecker(startNode),tryDelta,distMaxNodeAddr,nodeFound);
              //ResponseChecker(startNode); dokonać oceny wykonanego podziału: czy silnej pomniejsza dystorsję jak poprzedni liść (po podziale)? Jeśli tak, to zpamiętać jego adres
          except
           error46('deltaCompare, ResponseChecker',form1.RadioGroup22)
          end;{try}
         end;{if}
       end;  //------------
     End; {else son>0}
     if nodeHeap[startNode].brother>0 then CARTiNo(nodeHeap[startNode].brother,'b')  //przejdź na alternatywę
   End;{CARTINO}

 Begin
  CARTiNO(startNode,#0);  //CARTINO utworzone, aby przejść do wersji proceduralnej DistancesInspectTree|CARTlike
 End; {CARTlike}


 procedure sentencesDirListDirFix;
 {
 określić położenie pliku sentencesDirList, z którego, w procedurze cath1ListRead, odczytywana jest lista fonemów
 }
   Begin
    //openDialog(form1.OpenDialog1,sentencesDirListDir,5,'Wskaż plik z listą plików Corpory (*.TXT)',form1.edit12);
    if fileexists(sentencesDirListDir) then
      begin
       assignFile(dirListFile,sentencesDirListDir);
       reset(dirListFile);
      end
     else
      begin
       repeat
        showMessage ('Plik o nazwie '+sentencesDirListDir+' nie istnieje,'#13#10+'(plik ma zawierać listę 3'+
         ' ostatnich liter w nazwie pliku wypowiedzi, treść wypowiedzi  oraz listę znaków fonematycznych'+
         ' poprzedzoną wierszem o treści'#13#10'"Lista fonemów (37+3)"');
        //openDialog(form1.OpenDialog1,sentencesDirListDir,5,'Wskaż plik z listą plików Corpory (*.TXT)',form1.edit12);
       until fileexists(sentencesDirListDir);
       assignFile(dirListFile,sentencesDirListDir);
       reset(dirListFile);
      end;
     writeln(reportFile,'Sentences list directory: ',sentencesDirListDir);
    End;{sentencesDirListDirFix}

procedure cathListRead(out cath1Nbr:byte);
{Procedura czytania danych dla bazy Corpora
     eventcath1 : array of char;             //lista przypisująca fonemy zdarzeniom; fonemy są zakodowane umownymi znakami
   eventcath2 : array of byte;             //lista przypisująca osoby zdarzeniom; osoby są zakodowane numerami
    cath2List : of string[9];              //lista osób odczytana z pliku GrochScan.txt
     zdarzenia : wektory cepstralne
# - znak oznaczający wszystkie znaki spoza danego zbioru znaków kodujących fonemy
}

 var   s:shortString;
       z:char;
       i:byte;

procedure error1;
var s : string;
Begin
 s:='Error 1:'#13#10'W pliku '+sentencesDirListDir+'nie napotkano obowiązkowego wiersza o treści'#13#10'"cath1 list (37+3)",'+
  #13#10'po którym, na końcu tekstu, powinna wystąpić lista użytych w opisie bazy "Corpora" fonemów'+
  #13#10'Program zostanie przerwany'+#13#10'End of the error 1 description.';
 showMessage(s);
 writeln(reportFile,s);
 flush(reportFile);
 halt;
End;

 procedure error2;
 var s : string;
  Begin
   s:='Error 2:'#13#10'W wykazie fonemów, w wierszu nr '+intToStr(i)+'o treści "'+s+'", odczytano tekst zawierający '+
     intToStr(length(s))+' znaków, czyli więcej, niż 1 znak.'+#13#10'Tu powinien być 1 znak w wierszu.'#13#10+
     '(Z każdego wiersza tej listy zawsze pobierany jest pierwszy znak i dołączany do zbioru fonemów. W tym'+
     ' wypadku będzie to "'+z+'", a pozostałe znaki tego wiersza zostaną pominięte.)'+
     #13#10'End of the error 2 description.';
   showMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
  End;

  procedure error3;
  var s : string;
   Begin
    s:='Error 3:'#13#10'Na pozycji '+intToStr(i)+' listy '+sentencesDirListDir+' napotkano znak "'+z+'",'#13#10+
    'który już wcześniej został na niej znaleziony.'#13#10'Sprawdź, czy lista ta jest poprawnie napisana.'+
    #13#10'End of the error 3 description.';
   ShowMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
   End;

  procedure error4;
  var s : string;
   Begin
    s:='Error 4: '#13#10'There is something wrong with "'+sentencesDirListDir+
     '".'#13#10'It does not match Corpora''s data;'+
     #13#10' cath2Nbr<>i; cath2Nbr='+intToStr(cath2Nbr)+', and i='+intToStr(i)+
     '.'#13#10'These values should be equal; ask the author or check "'+sentencesDirListDir+
     #13#10'End of the error 4 description.';
    showMessage(s);
    writeln(reportFile,s);
    flush(reportFile);
   End;

  procedure error24(const i:byte; const z:char);
  var s : string;
   Begin
    s:='Jest różnica pomiędzy zbiorem kodów osób utworzonym na etapie czytania danych,'#13#10+
     'a zbiorem utworzonym w wyniku czytania katalogu "'+sentencesDirListDir+'" na pozycji '+intToStr(i)+
     '. Znaku ['+z+'] tam nie było!'+#13#10'End of the error 24 description.';
    showMessage(s);
    writeln(reportFile,s);
    flush(reportFile);
   End;

 Begin   //--------------------------------------cathListRead----------- ! CORPORA ! ----------------
  sentencesDirListDirFix;                                  //określić położenie pliku sentencesDirList
  for i:=1 to 9 do readln(dirListFile,s);                  //dojść do listy osób
  i:=0;    s:='';
  while not seekeof(dirListFile) do     //czytać i kodować nazwy osób
   begin
    readln(dirListFile,s);
    if (s='') or (s='sentence list')  then break;
    cath2NameList[i]:=s;
    z:=s[1];
    cath2CodeList[i]:=char(i);
    if not (z in cath2Set) then begin include(cath2Set,z); error24(i,z) end;
    inc(i);
   end;{while}
  if i<>cath2Nbr then error4;
  cath2Nbr:=i;
  repeat                                                   //dojść do listy fonemów
   readln(dirListFile,s);
  until (s='cath1 list (37+3)') or eof(dirListFile);
  if s<>'cath1 list (37+3)' then error1;
  i:=0;  cath1Set:=[];
  cath1CodeList[0]:=#0; cath1Hash[#0]:=0;                        //# znak oznaczający wszystkie znaki spoza danego zbioru znaków kodujących fonemy
  repeat
   readln(dirListFile,s);
   z:=s[1];
   if length(s)<>1 then error2;
   if not (z in cath1Set) then
    begin
     inc(i);
     cath1CodeList[i]:=z;                                       //dekoder znaków fonematycznych
     cath1Hash[z]:=i;                                       //koder znaków fonematycznych
     include(cath1Set,z);
    end
   else error3;
  until eof(dirListFile);
  cath1Nbr:=i;
  form1.edit9.Text:=intToStr(cath1Nbr);
  form1.edit10.Text:=intToStr(cath2Nbr);
  form1.edit11.Text:=intToStr(cath3Nbr);
 End;{cathListRead}

 procedure H0ToreportTXT;
 var i:byte;
 s:string[6];
 Begin
 if form1.checkbox37.Checked then for i:=1 to 170 do Write(reportFile,'-'); Writeln(reportFile);flush(reportFile); //RAM allocation table underscore
 if form1.checkbox2.Checked then
  begin
   writeln(reportFile);
   writeln(reportFile,Y1name,'''s histogram in all data ("H0-cath1-histogram"). The first position signed with blank,',
   'is reserved for signs not present in the cath1''s set values (for some unknown error situations).');
   write(reportFile,'catheg. ');for i:=0 to cath1Nbr do write(reportFile,cath1CodeList[i]:6,' '); writeln(reportFile);
   write(reportFile,'counts  ');for i:=0 to cath1Nbr do write(reportFile,  cath1H0[i]:6,' '); writeln(reportFile);
   write(reportFile,'probab. ');for i:=0 to cath1Nbr do write(reportFile,cath1Pb[i]:6:3,' '); writeln(reportFile);     //prawdopodobieństwa empiryczne fonemów
  end;
  if form1.checkbox3.Checked then
   begin
    writeln(reportFile,#13#10,Y2Name,'''s histogram in all data. The first position signed with blank, is reserved',
    ' for cath2''s values not taken into consideration (for some unknown error situations).');
    write(reportFile,'catheg. ');
    for i:=0 to cath2Nbr do
     begin
      s:=cath2NameList[i];
      write(reportFile,s);
     end;
    writeln(reportFile);
    write(reportFile,'code    ');for i:=0 to cath2Nbr do write(reportFile,cath2CodeList[i]:6,' ');writeln(reportFile);
    write(reportFile,'counts  ');for i:=0 to cath2Nbr do write(reportFile,cath2H0[i]:6,' '); writeln(reportFile);
    write(reportFile,'probab. ');for i:=0 to cath2Nbr do write(reportFile,cath2Pb[i]:6:3,' '); writeln(reportFile); //prawdopodobieństwa empiryczne osób
    writeln(reportFile);
   end;
   if form1.checkbox4.Checked then
    begin
     writeln(reportFile,Y3Name,'''s histogram. The first position signed with blank, is reserved for the cathegory',
     ' values not taken into account (for some unknown error situations).');
     writeln(reportFile);
     write(reportFile,'catheg.  ');for i:=0 to cath3Nbr do write(reportFile,cath3CodeList[i]:7,' '); writeln(reportFile);
     write(reportFile,'counts   ');for i:=0 to cath3Nbr do write(reportFile,cath3H0[i]:7,' '); writeln(reportFile);
     write(reportFile,'probab.  ');for i:=0 to cath3Nbr do write(reportFile,cath3Pb[i]:7:3,' '); writeln(reportFile); //prawdopodobieństwa empiryczne osób
    end;
  writeln(reportFile);
  flush(reportFile);
 End;{H0ToreportTXT}

procedure H0ToreportExcel;
 var i:byte;
 s:string[6];
 Begin
  if form1.checkbox2.Checked then
   begin
    writeln(reportFile);
    writeln(reportFile,Y1Name,'''s histogram in all data');
    write(reportFile,'catheg. |');for i:=0 to cath1Nbr do write(reportFile,cath1CodeList[i]:6,' |'); writeln(reportFile);     //Uwaga! znak | w zbiorze znaków lisy będzie psuł synchro w nagłówku!!!
    write(reportFile,'counts  |');for i:=0 to cath1Nbr do write(reportFile,cath1H0[i]:6,' |'); writeln(reportFile);
    write(reportFile,'probab. |');for i:=0 to cath1Nbr do write(reportFile,cath1Pb[i]:6:3,' |'); writeln(reportFile);     //prawdopodobieństwa empiryczne fonemów
   end;
  if form1.checkbox3.Checked then
   begin
    writeln(reportFile,#13#10,Y2Name,'''s histogram in all data.');
    write(reportFile,'catheg. |');
    for i:=0 to cath2Nbr do
     begin
      s:=cath2NameList[i];
      write(reportFile,s);
     end;
    writeln(reportFile);
    write(reportFile,'code    |');for i:=0 to cath2Nbr do write(reportFile,cath2CodeList[i]:6,' |');writeln(reportFile);
    write(reportFile,'counts  |');for i:=0 to cath2Nbr do write(reportFile,cath2H0[i]:6,' |'); writeln(reportFile);
    write(reportFile,'probab. |');for i:=0 to cath2Nbr do write(reportFile,cath2Pb[i]:6:3,' |'); writeln(reportFile); //prawdopodobieństwa empiryczne osób
    writeln(reportFile);
   end;
  if form1.checkbox4.Checked then
   begin
    writeln(reportFile,Y3Name,'''s histogram');
    writeln(reportFile);
    write(reportFile,'catheg.  |');for i:=0 to cath3Nbr do write(reportFile,cath3CodeList[i]:7,' |'); writeln(reportFile);
    write(reportFile,'counts   |');for i:=0 to cath3Nbr do write(reportFile,cath3H0[i]:7,' |'); writeln(reportFile);
    write(reportFile,'probab.  |');for i:=0 to cath3Nbr do write(reportFile,cath3Pb[i]:7:3,' |'); writeln(reportFile); //prawdopodobieństwa empiryczne osób
   end;
  writeln(reportFile);
  flush(reportFile);
 End;{H0ToreportExcel}



 procedure MakeH0Hist(const eventNbr:longWord; var cath1H0,cath2H0,cath3:THist);
 {          uwzględnić znaki spoza listy!
 Przebiega po fonemach przypisanych przekrojom spektralnym (cepstralnym)
     eventNbr - liczba zdarzeń (wykonanych przekrojów spektralnych)
     cath1Hash - # lista fonemów (array[char] of byte), skorowidz numerów przypisanych fonemom
    eventcath1 - indeks do listy fonemów przypisanych próbkom akustycznym
           H0 - histogram numerów fonemów; każdy numer na osi odciętych należy dekodować za pomocą listy cath1CodeList
 }

  var    i,k : longWord;

  Begin  //-----------------------MakeH0Hist----------------------------
   begin
    with form1 do
     begin
      if checkbox2.Checked then for i:=0 to cath1Nbr do cath1H0[i]:=0;
      if checkbox3.Checked then for i:=0 to cath2Nbr do cath2H0[i]:=0;
      if checkbox4.Checked then for i:=0 to cath3Nbr do cath3H0[i]:=0;
     end;
    end;
   k:=0;
   for i:=0 to wholeEventNbr-1 do if not inset(i,excludeset) then                                          //czy lista eventcath1 zaczyna się od 0?
    begin                                                             //czy tu nie powinno być if not inset(i,excludeset) then ?? 010210
     inc(k);
     if form1.CheckBox2.Checked then
      if eventcath1[i] in cath1Set then inc(cath1H0[cath1Hash[eventcath1[i]]])
      else inc(cath1H0[0]);                                             //uwzględnić znaki spoza deklarowanego zbioru
     if form1.CheckBox3.Checked then
      if eventcath2[i] in cath2Set then inc(cath2H0[cath2Hash[eventcath2[i]]])
      else inc(cath2H0[0]);
      if form1.CheckBox4.Checked then
      if eventcath3[i] in cath3Set then inc(cath3H0[cath3Hash[eventcath3[i]]])
      else inc(cath3H0[0]);
    end;
    if k<>eventNbr then error33(eventNbr,k);
    if form1.CheckBox2.Checked then for i:=0 to cath1Nbr do cath1Pb[i]:=cath1H0[i]/eventNbr;                //prawdopodobieństwa empiryczne fonemów
    if form1.CheckBox3.Checked then for i:=0 to cath2Nbr do cath2Pb[i]:=cath2H0[i]/eventNbr;          //prawdopodobieństwa empiryczne osób
    if form1.CheckBox4.Checked then for i:=0 to cath3Nbr do cath3Pb[i]:=cath3H0[i]/eventNbr;   //prawdopodobieństwa empiryczne osób
    H0ToReport;
    with nodeProps[0] do
     begin  //errIRProcessing(const n:longWord; const nodeAddr:word; const NodeHist:THist; const ImpresNbr:byte; out IR:double; out max:byte; out error:longWord);
      if form1.CheckBox2.Checked then errIRProcessing(cardinal,0,cath1H0,cath1Pb,cath1Nbr,nodeprops[0].cath1IR,nodeprops[0].cath1,nodeprops[0].cath1RecErr,checkcath1Set,allcath1,cath1CodeList,cl1,cath1AllStep,form1.label138)
      else cath1RecErr:=cardinal;
      if form1.CheckBox3.Checked then errIRProcessing(cardinal,0,cath2H0, cath2Pb, cath2Nbr,nodeprops[0].cath2IR,nodeprops[0].cath2, nodeprops[0].cath2RecErr,checkcath2Set,allcath2,cath2CodeList,cl2,cath2AllStep,form1.label139)
      else cath2RecErr:=cardinal;
      if form1.CheckBox4.Checked then errIRProcessing(cardinal,0,cath3H0,cath3Pb,cath3Nbr,nodeprops[0].cath3IR, nodeprops[0].cath3,nodeprops[0].cath3RecErr,checkcath3Set,allcath3,cath3CodeList,cl3,cath3AllStep,form1.label140)
      else cath3RecErr:=cardinal;
     end;{with}
  End;{MakeH0Hist}                                                                        //na brata

  procedure showLeavesSetsCounts(graphRepeat:boolean);
  //onceShowed - block multiple entering proc IRframe if overlay graphs is on
   var i:word;
    prevX,currX,prevY:double;
   Begin
    try
     if high(leafCardArr)<>(leafNodeNbr) then ToReportRAMinfoCaption;
     if ToReportRAMinfo('leafCardArr',high(leafCardArr),sizeOf(cardinal),leafNodeNbr+1)
     then setLength(leafCardArr,leafNodeNbr+1);
     for i:=1 to leafNodeNbr do leafCardArr[i]:=nodeProps[leafNodes[i]].cardinal;
     quickSort(leafCardArr,1,leafNodeNbr);
     with form1 do  //checkbox10 - nakładaj wykresy, checkBox29 - wstawiaj tabele pośreadnie wynikó końcowych dla liści
     if not checkbox10.Checked or not onceShowed and checkbox10.Checked  or graphRepeat then
      begin
      IRframe(Panel7,Canvas,CentroidsNb_glob{leafNodeNbr},leafCardArr[leafNodeNbr],0,0,0,wspx7,wspy7,topHeight7);
      onceShowed:=true;
     end;
     prevX:=form1.panel7.left; prevY:=leafCardArr[1];
     for i:=1 to leafNodeNbr do with form1 do
      begin
       currX:=i*wspx7+panel7.left;
       IRdrawings(Panel7,canvas,leafNodeNbr,prevX,currX,prevY,leafCardArr[i],wspy7,topHeight7,cl5);  //strech=leafCardArr[leafNodeNbr],
       prevX:=currX; prevY:=leafCardArr[i];
      end;
     except
      error49;
     end;{except}
   End;{showLeavesSetsCounts}

 function DelSpace(s:string):string;
  var i,j:word;
  begin
   j:=length(s);
   for i:=j downto 1 do
    if s[i]=' ' then delete(s,i,1)
    else break;
  delSpace:=s;
 end;

procedure FinalIRToreport(const performance:string; const EventNbr:longWord; const step:word);
  var        i,k:word; s,s11,s12,s13,s21,s22,s23,s31,s32,s33,s4:shortstring;
   sumSetCounts,Err1S, Err2S,Err3S:longWord;
   IR1S,IR2S,IR3S, DistS:double;
   procedure underline;
    begin
     writeln(reportFile,'|=======|========|========|===========|===========|===========|===========|===========|===========|===========|===========|===========|============|=============|');
    end;

 procedure checkPoint(const checked:boolean; const IR:double; const recErr:longWord; const effect:byte;const charList:TcharList;
                      out IRS:double; out errS:longword;out s1,s2,s3:shortString);
 {
 sumuje właściwości IR i recErr (po liściach)
 formułuje wyniki do zapisu w tabeli w formie tekstu
 }
  Begin
   if Checked then
    begin
     IRS:=IRS+Ir;   ErrS:=ErrS+RecErr;
     s1:=floatToStrF(Ir,ffFixed,10,3);s2:=intToStr(RecErr);s3:=charList[effect];
    end
   else
    begin
     s1:='    -    ';s2:=s1;s3:=s1;
    end;
  End; {checkPoint}

  procedure TotalCheckPoint(const checked:boolean; const effect:byte;const charList:TcharList; const IRS:double; const errS:longword;
                            out s1,s2,s3:shortString);
//formułuje wyniki do zapisu w tabeli w formie tekstu dla wiersza totals tabeli 3.
   Begin
    if Checked then
     begin
      s1:=floatToStrF(IRS/leafNodeNbr,ffFixed,10,3); s2:=intToStr(ErrS); s3:=charList[effect];
     end
    else
     begin
     s1:='    -    '; s2:=s1; s3:=s1;
    end;
   End;

  Begin  //-----------------------------------FinalIRToreport---------------------------------
    showLeavesSetsCounts(false); //wykres liczebności
    writeln(reportFile,'Table 2. Totals (sum of values over leaves of the quantization tree)'#13#10,
                       '         step - step, in which given cathegory already got representative events'#13#10,
                       '         groups for all its values (showed by a vertical line on drawings)' );
    writeln(reportFile,'=========================');
    writeln(reportFile,'|Class. |IRadius|  step |');
    writeln(reportFile,'=========================');
    with form1 do
     begin
      write(reportFile,'|',Y1name:7,'|'); if checkBox2.checked then writeln(reportFile,cath1IrGlob/step:7:3,'|',cath1AllStep:7,'|') else writeln(reportFile,'   -   |   -   |');
      write(reportFile,'|',y2Name:7,'|'); if checkBox3.checked then writeln(reportFile,cath2IrGlob/step:7:3,'|',cath2AllStep:7,'|') else writeln(reportFile,'   -   |   -   |');
      write(reportFile,'|',Y3Name:7,'|'); if checkBox4.checked then writeln(reportFile,cath3IrGlob/step:7:3,'|',cath3AllStep:7,'|') else writeln(reportFile,'   -   |   -   |');
     end;
    writeln(reportFile,'=========================');
    writeln(reportFile,'distortion..................',distortion/EventNbr:1:3,
                 #13#10'total iterations number.....',totalIterNbr);

   if not form1.CheckBox6.Checked then exit;                                                            //nie drukować tabeli IR dla liści
   writeln(reportFile,#13#10'Table 3.'#13#10'Recognition errors and information radius (IR) values for histograms in leaves sets of the final tree for ',delSpace(Y1Name),'''s,',delSpace(Y2Name),'''s and the ',delSpace(Y3Name),'''s cathegories.');
   underline;
   if form1.radiogroup17.itemIndex=1 then  //table caption form, 0:txt, 1:Excel
    writeln(reportFile,'|Leaf no|leaf no-|leaf set|--------------| IR for:|-----------|recognition| error for:-|-----------|  maximum| at for:--|-------------|mean Euclid.|   optimal   |')
   else
    writeln(reportFile,'|Leaf no|leaf no-|leaf set|-------------- IR for:-------------|--recognition error for:-----------|--maximum at for:------------------|mean Euclid.|   optimal   |') ;
   writeln(reportFile,'|de nbr |de addr |count   |  ',Y1name:8,' |  ',Y2Name:8,' |  ',Y3Name:8,' |  ',Y1name:8,' |  ',Y2Name:8,' |  ',Y3Name:8,' |  ',Y1name:8,' |  ',Y2Name:8,' |  ',Y3Name:8,' | Distance   | CART feature|');
   underline;
    sumSetCounts:=0; IR1S:=0; IR2S:=0; IR3S:=0; Err1S:=0; Err2S:=0; Err3S:=0; DistS:=0;
   for i:=1 to leafNodeNbr do
    begin
     k:=leafNodes[i];
     with form1,nodeProps[k] do
     begin
    //checkPoint(const checked:boolean; const IR:double; const recErr:longWord; const effect:char; out IRS:double; out errS:longword;out s1,s2,s3:shortString);
      checkPoint(checkBox2.Checked,cath1Ir,cath1RecErr,cath1,cath1CodeList,IR1S,Err1S,s11,s12,s13);
      checkPoint(checkBox3.Checked,cath2Ir,cath2RecErr,cath2,cath2CodeList,IR2S,Err2S,s21,s22,s23);
      checkPoint(checkBox4.Checked,cath3Ir,cath3RecErr,cath3,cath3CodeList,IR3S,Err3S,s31,s32,s33);
      if radiogroup12.ItemIndex=0 then s4:=intToStr(nodeProps[k].OptComponentNbr) else s4:='     -      ';
      DistS:=distS+meanDistance*cardinal;
      sumSetCounts:=sumSetCounts+cardinal;
       writeln(reportFile,'|',i:6,' |',k:7,' |',cardinal:7,' |',
     s11:10,' |',s21:10,' |',s31:10,' |',
     s12:10,' |',s22:10,' |',s32:10,' |',
     s13:10,' |',s23:10,' |',s33:10,' |',             //cath1CodeList[nodeProps[k].cath1]:10,' |',cath2CodeList[nodeProps[k].cath2]:10,' |',cath3CodeList[nodeProps[k].cath3]:10,' |',
     nodeProps[k].meanDistance:11:3,' |',s4:12,' |');//nodeProps[k].OptComponentNbr
     end;{with}
    end;{for}
   underline;
    with form1,nodeProps[0] do      //Totals-------------------------------------------------------------
    //TotalCheckPoint(const checked:boolean; const effect:byte;const charList:TcharList; const IRS:double; const errS:longword;
    //               out s1,s2,s3:shortString);
     begin
      TotalCheckPoint(checkBox2.Checked,cath1,cath1CodeList,IR1S,Err1S,s11,s12,s13);
      TotalCheckPoint(checkBox3.Checked,cath2,cath2CodeList,IR2S,Err2S,s21,s22,s23);
      TotalCheckPoint(checkBox4.Checked,cath3,cath3CodeList,IR3S,Err3S,s31,s32,s33);
      if radiogroup12.ItemIndex=0 then s4:=intToStr(nodeProps[k].OptComponentNbr) else s4:='     -      ';
     end;
    writeln(reportFile,'|','Totals':6,' |',' - ':7,' |',sumSetCounts:7,' |',
     s11:10,' |',s21:10,' |',s31:10,' |',
     s12:10,' |',s22:10,' |',s32:10,' |',
     s13:10,' |',s23:10,' |',s33:10,' |',
     DistS/eventNbr:11:3,' |',s4:12,' |');
   underline;
   writeln(reportFile,'Notes');
    with form1 do
    s:=radiogroup22.caption+'\'+radiogroup22.Items[radiogroup22.ItemIndex]+'"';
   writeln(reportFile,#13#10'1.'#9'Numer liścia wynika z kolejności obróbki jego zbioru, co z kolei jest determinowane kryterium wyboru "',s);
   writeln(reportFile,'2.'#9'The column "leaf node nr" shows rows nr in the tree.',
    #13#10#9'It is a tree node number resulted from order of processing (not from a tree path sequence), determined by the set choice (for spliting) criterion, i.e. "',s);    //Jest to numer węzła w drzewie wynikający z kolejności obróbki (a nie z kolejności na jakiejkolwiek ścieżce)
  End;{FinalIRToreport}


 procedure RowsToReportTableCaptionTXT;
 var i:byte;

  procedure underline;
   begin
    write(reportFile,'=================================================================================================+');
    with form1 do
     begin
      if radiogroup12.itemIndex=0  then write(reportFile,'==================');
      if checkBox2.Checked then write(reportFile,'================');
      if checkBox3.Checked then write(reportFile,'================');
      if checkBox4.Checked then write(reportFile,'================');
     end;
    write(reportFile,'==========|');
   end;

  Begin   //wyprowadza nagłówek do reportu - dane wyprowadzane z pętli RUN
   writeln(reportFile,'Results of histograms comparing with the information radius function');

   writeln(reportFile,'Global totals (sum of IR values over leaves of the quantization tree).'#13#10,
    #13#10'       IR = Information Radius',
    #13#10'     card = count of elements in a given set',
    #13#10'    error = error in a selftest.',
    #13#10'    count = total count of elements in a given cathegory group',
    #13#10'Note: errors for cathegories values are counts of classifications different from classifications dominating in a given clusters group');
   writeln(reportFile,#13#10'Table 1.'#13#10'IR means over all leaves at a given stage of the tree building and, if recquiread, over the dependant variables, i.e.: "',Y1Name,'", "',Y2name,'" and "',Y3Name,'" values clusters groups'#13#10);
   If form1.RadioGroup18.ItemIndex=1 then
    writeln(reportFile,'maxim. - count at the maximum of a given distribution over the sum of clusters belonging to the specified cathegory'#13#10,
                       'count  - total count of members in clusters belonging to the specified cathegory'#13#10,
                       'error(cathegory)=100*(1-maxim(cathegory)/count(cathegory)');
{1} underline;
    with form1 do
    If RadioGroup18.ItemIndex=1 then    //totals and cathegories
     begin
     if checkBox2.Checked then
      begin
      write(reportFile,Y1Name:7,'=============|');
      for i:=0 to cath1Nbr-1 do write(reportFile,'====================+');
      end;
      if checkBox3.Checked then
      begin
      write(reportFile,Y2Name:7,'=============|');
      for i:=0 to cath2Nbr-1 do write(reportFile,'====================+');
      end;
      if checkBox4.Checked then
      begin
      write(reportFile,y3Name:7,'=============|');
      for i:=0 to cath3Nbr-1 do write(reportFile,'====================+');
      end;
     end;
    writeln(reportFile);

{2} write(reportFile,'|      |isolat. |-------node adresses------|-------set counts---------|iter|fission   |distortion|');
    with form1 do
     begin
      if radiogroup12.ItemIndex =0 then write(reportFile,'Optimal component|');
      write(reportFile,'----');
      if checkBox2.Checked then write(reportFile,Y1Name:8,'---|','----');
      if checkBox3.Checked then write(reportFile,Y2Name:8,'---|','----');
      if checkBox4.Checked then write(reportFile,Y3Name:8,'---|','----');
     end;
    write(reportFile,'-Time-|');
    with form1 do
    If RadioGroup18.ItemIndex=1 then
     begin
      if checkBox2.Checked then for i:=0 to cath1Nbr do write(reportFile,cath1CodeList[i]:7,'             |');
      if checkBox3.Checked then for i:=0 to cath2Nbr do write(reportFile,cath2CodeList[i]:7,'             |');
      if checkBox4.Checked then for i:=0 to cath3Nbr do write(reportFile,cath3CodeList[i]:7,'             |');
     end;
    writeln(reportFile);

{3} write(reportFile,'| step |treshold|  father|    son1|    son2|  father|    son1|    son2|','nbr |','distance  |','          |');
   with form1 do
    begin
     if radiogroup12.ItemIndex =0 then write(reportFile,'number|mean value|');
     if checkBox2.Checked then write(reportFile,'  IR   |error %|');
     if checkBox3.Checked then write(reportFile,'  IR   |error %|');
     if checkBox4.Checked then write(reportFile,'  IR   |error %|');
    end;
    write(reportFile,'  [sec]   |');
    with form1 do
    If RadioGroup18.ItemIndex=1 then
     begin
      if checkBox2.Checked then for i:=0 to cath1Nbr do write(reportFile,'    IR|maxim.| count|');
      if checkBox3.Checked then for i:=0 to cath2Nbr do write(reportFile,'    IR|maxim.| count|');
      if checkBox4.Checked then for i:=0 to cath3Nbr do write(reportFile,'    IR|maxim.| count|');
     end;
    writeln(reportFile);

{4} underline;
    with form1 do
    If RadioGroup18.ItemIndex=1 then
     begin
      if checkBox2.Checked then for i:=0 to cath1Nbr do write(reportFile,'======|======|======+');
      if checkBox3.Checked then for i:=0 to cath2Nbr do write(reportFile,'======|======|======+');
      if checkBox4.Checked then for i:=0 to cath3Nbr do write(reportFile,'======|======|======+');
     end;
    writeln(reportFile);
  End;{RowsToreportTableCaptionTXT}

procedure RowsToReportTableCaptionEXCEL;
 var i:byte;
  procedure underline;
   begin
   write(reportFile,'=======|========|========|========|========|========|========|=======|=======|=========|=======|=======|');
    with form1 do
     begin
      if radiogroup12.ItemIndex=0 then write(reportFile,'=======|========|');
      if checkBox2.Checked then write(reportFile,'========|=========|');
      if checkBox3.Checked then write(reportFile,'=======|=========|');
      if checkBox4.Checked then write(reportFile,'==========|=========|');
     end;
    write(reportFile,'======|');
   end;
  Begin   //wyprowadza nagłówek do reportu - dane wyprowadzane z pętli RUN
   writeln(reportFile,'Results of histograms comparing with the information radius function');

   writeln(reportFile,'Global totals (sum of IR values over leaves of the quantization tree).'#13#10,
    #13#10'       IR = Information Radius',
    #13#10'     card = count of elements in a given set',
    #13#10'    error = error in a selftest.',
    #13#10'    count = total count of elements in a given cathegory group',
    #13#10'Note: errors for cathegories values are counts of classifications different from classifications dominating in a given clusters group');
   writeln(reportFile,#13#10'Table 1.'#13#10'IR means over all leaves at a given stage of the tree building and, if recquiread, over ',
                       Y1Name,', ',Y2Name,' and ',Y3Name,' variable values clusters groups'#13#10,
                #13#10'NOTE: This report version should be opened with the MS Excel using the "|" as the separator sign.'#13#10);
    If form1.RadioGroup18.ItemIndex=1 then
    writeln(reportFile,'maxim. - count at the maximum of a given distribution over the sum of clusters belonging to the specified cathegory'#13#10,
                       'count  - total count of members in clusters belonging to the specified cathegory'#13#10,
                       'error(cathegory)=100*(1-maxim(cathegory)/count(cathegory)');
{1} underline;
    with form1 do
    If RadioGroup18.ItemIndex=1 then
     begin
      if checkBox2.Checked then
      begin
      write(reportFile,Y1Name,'|======|=======|');
      for i:=0 to cath1Nbr-1 do write(reportFile,'======|======|======|');
      end;
      if checkBox3.Checked then
      begin
      write(reportFile,Y2Name,'|======|=======|');
      for i:=0 to cath2Nbr-1 do write(reportFile,'======|======|======|');
      end;
      if checkBox4.Checked then
      begin
      write(reportFile,Y3Name,'|======|=====|');
      for i:=0 to cath3Nbr-1 do write(reportFile,'======|======|======|');
      end;
     end;
    writeln(reportFile);

{2} write(reportFile,'|      |isolat. |node addresses---------|||set  counts------------------|||iterations|fission|distortion|');
    with form1 do
     begin
      if radiogroup12.itemIndex=0 then write(reportFile,'Optimal component---------||');
      if checkBox2.Checked then write(reportFile,Y1Name,'------||');
      if checkBox3.Checked then write(reportFile,Y2Name,'------||');
      if checkBox4.Checked then write(reportFile,Y3Name,'------||');
     end;
    write(reportFile,'Time|');
    with form1 do
    If RadioGroup18.ItemIndex=1 then
     begin
      if checkBox2.Checked then for i:=0 to cath1Nbr do write(reportFile,cath1CodeList[i]:7,' | | |');
      if checkBox3.Checked then for i:=0 to cath2Nbr do write(reportFile,cath2CodeList[i]:7,' | | |');
      if checkBox4.Checked then for i:=0 to cath3Nbr do write(reportFile,cath3CodeList[i]:7,' | | |');
     end;
    writeln(reportFile);

{3} write(reportFile,'| step |treshold|  father|    son1|    son2| father |    son1|    son2|','number|','distance  |','          |');
    with form1 do
     begin
      if radiogroup12.itemIndex=0 then write(reportFile,'number|mean value|');
      if checkBox2.Checked then write(reportFile,'IR|error[%]|');
      if checkBox3.Checked then write(reportFile,'IR|error[%]|');
      if checkBox4.Checked then write(reportFile,'IR|error[%]|');
     end;
     write(reportFile,'   [sec]  |');
    with form1 do
    If RadioGroup18.ItemIndex=1 then
     begin
      if checkBox2.Checked then for i:=0 to cath1Nbr do write(reportFile,'    IR|maxim.| count|');
      if checkBox3.Checked then for i:=0 to cath2Nbr do write(reportFile,'    IR|maxim.| count|');
      if checkBox4.Checked then for i:=0 to cath3Nbr do write(reportFile,'    IR|maxim.| count|');
     end;
    writeln(reportFile);

{4} underline;
    with form1 do
    If RadioGroup18.ItemIndex=1 then
     begin
      if checkBox2.Checked then for i:=0 to cath1Nbr do write(reportFile,'======|======|======|');
      if checkBox3.Checked then for i:=0 to cath2Nbr do write(reportFile,'======|======|======|');
      if checkBox4.Checked then for i:=0 to cath3Nbr do write(reportFile,'======|======|======|');
     end;
    writeln(reportFile);
  End;{RowsToReportTableCaptionEXCEL}


 procedure RowsToReport(const step:word;const EventNbr, distMaxNodeAddr:longWord);//const cath11,cath12,pers1,pers2,cath31,cath32:byte);
   var
    t1,t3,t5,t6,t7,t8,t9:double;
    hour,minute,sec,msec:word;
    j:longint;
    k:word;
    k1,k2:longWord;
  Begin  //-----------------------------------RowsToReport---------------------------------
   decodeTime(startTime,hour,minute,sec,msec);
   j:=3600*hour+60*minute+sec;
   decodeTime(time,hour,minute,sec,msec);
   j:=-j+3600*hour+60*minute+sec;
   k1:=nodeprops[nodeHeap[distMaxNodeAddr].son].cardinal;
   k2:=nodeprops[nodeHeap[nodeHeap[distMaxNodeAddr].son].brother].cardinal;
   with form1 do
    begin
     if checkBox2.Checked then
      begin
       t1:=cath1IRGlob/(step+1);
       t3:=percNorm*cath1RecErrSum;        //100*cath1RecErrSum/eventNbr       percNorm=100/evenNbr
      end;
     if checkBox3.Checked then
      begin
       t5:=cath2IRGlob/(step+1);
       t6:=percNorm*cath2RecErrSum;      //100*cath2RecErrSum/eventNbr
      end;
     if checkBox4.Checked then
      begin
       t7:=cath3IRGlob/(step+1);
       t8:=percNorm*cath3RecErrSum;     //100*cath3RecErrSum/eventNbr
      end;
     end;{with}
   t9:=distortion/EventNbr;
   write(reportFile,'| ',step:4,' |',rareEventNbr1:7,' |',distMaxNodeAddr:7,' |',nodeHeap[distMaxNodeAddr].son:7,
    ' |',nodeHeap[nodeHeap[distMaxNodeAddr].son].brother:7,' |',nodeprops[distMaxNodeAddr].cardinal:7,' |',k1:7,' |',k2:7,' |',nodeprops[distMaxNodeAddr].iterNbr:4,'|',nodeprops[distMaxNodeAddr].fissionDistance:10:3,'|',t9:10:3,'|');
    with form1, nodeprops[distMaxNodeAddr] do
     begin
      if radiogroup12.ItemIndex =0 then write(reportFile,OptComponentNbr:6,'|',centroid[OptComponentNbr]:10:3,'|');
      if checkBox2.Checked then write(reportFile,t1:7:3,'|',t3:7:3,'|');
      if checkBox3.Checked then write(reportFile,t5:7:3,'|',t6:7:3,'|');
      if checkBox4.Checked then write(reportFile,t7:7:3,'|',t8:7:3,'|');
     end;{with}
    write(reportFile,intToStr(j):9,'|');
    form1.Label129.Caption:=intToStr(j);
   //--------------------------------------------------------------------------------------liczebności pomocnicze klastrów. gdy l=0, to l:=1, bo wtedy IR=0, a więc można dzielić przez 1. Wtedy również skalowany IR będzie =0.
   If form1.RadioGroup18.ItemIndex=1 then  with form1 do
    begin
     if checkBox2.Checked then
      for k:=0 to cath1Nbr do if cath1ClusterCount[k]<>0 then              cath1ClusterCount1[k]:=cath1ClusterCount[k]    else cath1ClusterCount1[k]:=1;
     if checkBox3.Checked then
      for k:=0 to cath2Nbr do if cath2ClusterCount[k]<>0 then        cath2ClusterCount1[k]:=cath2ClusterCount[k]  else cath2ClusterCount1[k]:=1;
     if checkBox4.Checked then
      for k:=0 to cath3Nbr do if cath3ClusterCount[k]<>0 then cath3ClusterCount1[k]:=cath3ClusterCount[k] else cath3ClusterCount1[k]:=1;
      //--------------------------------------------------------------------------------------reportowanie skalowanych IR dla poszczególnych wrażeń      ,,
     if checkBox2.Checked then
      for k:=0 to cath1Nbr do write(reportFile,cath1IRarray[k]/(cath1ClusterCount1[k]):6:3,'|',phErr[k]:6,'|',cath1CountArray[k]:6,'|');
     if checkBox3.Checked then
      for k:=0 to cath2Nbr do write(reportFile,cath2IRarray[k]/(cath2ClusterCount1[k]):6:3,'|',persErr[k]:6,'|',cath2CountArray[k]:6,'|');
     if checkBox4.Checked then
      for k:=0 to cath3Nbr do write(reportFile,cath3IRarray[k]/(cath3ClusterCount1[k]):6:3,'|',cath3Err[k]:6,'|',cath3CountArray[k]:6,'|');
    end; {if with}
   writeln(reportFile);
   with form1 do
   if  checkBox25.Checked then
    begin
     Label82.Caption:='step '+intToStr(step);
     currX:=step*wspx3+panel3.left;
                                                                                           IRdrawings(form1.Panel2,form1.canvas,CentroidsNb_glob,prevX,currX,prevDistortion,t9,wspy2,topHeight2,cl4);   //strech=prevDistortion:=nodeprops[0].meandistance,
     if form1.checkBox2.Checked then begin Label75.Caption:=floatToStrF(t1,ffFixed,7,3);   IRdrawings(form1.Panel3,form1.canvas,CentroidsNb_glob,prevX,currX,prevIRcath1,t1,wspy3,topHeight3,cl1)  end;      //strech=IRStretch, clBlue
     if form1.checkBox3.Checked then begin Label76.Caption:=floatToStrF(t3,ffFixed,7,3);   IRdrawings(form1.Panel3,form1.canvas,CentroidsNb_glob,prevX,currX,prevIRpers,t5,wspy3,topHeight3,cl2)  end;     //strech=IRStretch, clread
     if form1.checkBox4.Checked then begin Label77.Caption:=floatToStrF(t5,ffFixed,7,3);   IRdrawings(form1.Panel3,form1.canvas,CentroidsNb_glob,prevX,currX,prevIRvoic,t7,wspy3,topHeight3,cl3)  end;    //strech=IRStretch, clGreen
     if form1.checkBox2.Checked then begin Label45.Caption:=floatToStrF(t6,ffFixed,7,3);   IRdrawings(form1.Panel4,form1.canvas,CentroidsNb_glob,prevX,currX,prevErrcath1,t3,wspy4,topHeight4,cl1) end;   //strech=errStretch, clBlue
     if form1.checkBox3.Checked then begin Label46.Caption:=floatToStrF(t7,ffFixed,7,3);   IRdrawings(form1.Panel4,form1.canvas,CentroidsNb_glob,prevX,currX,prevErrPers,t6,wspy4,topHeight4,cl2) end;  //strech=errStretch, clread
     if form1.checkBox4.Checked then begin Label108.Caption:=floatToStrF(t8,ffFixed,7,3);  IRdrawings(form1.Panel4,form1.canvas,CentroidsNb_glob,prevX,currX,prevErrVoic,t8,wspy4,topHeight4,cl3) end; //strech=errStretch, clGreen
     prevX:=currX;
    end;{with}
  End;{RowsToReport}

  procedure ToRemoveSet(EventNbr:longWord);
   {
   Określić zbiór zdarzeń rzadkich, które mają być pominięte przy obliczaniu centroidów.
   Do zbioru tego zaliczone będą rareEventNbr2- elementowe zbiory z rozkładu na zadaną w pierwszym przebiegu punktów  (rareEventNbr2=~1, 2)
   rareEventNbr2 - liczebność, poniżej której zbiór będzie zaliczany do zbioru zdarzeń rzadkich; zdarzenia te będa wykluczane z obliczeń centroidów
  }
  procedure excludeSetMaker(const nodeAddr:longWord);
   var k,l:longWord;
   Begin
    if nodeHeap[nodeAddr].son>0 then  excludeSetMaker(nodeHeap[nodeAddr].son)
     else    //znaleziono liść, więc
      begin
       if nodeProps[nodeAddr].cardinal<=rareEventNbr2 then
        with nodeProps[nodeAddr] do
         begin
          for k:=lb to hb do includeToset(excludeSet,sbl[k]);
          inc(excludeSetCard,cardinal);  k:=hb-lb+1;
          if k<>nodeProps[nodeAddr].cardinal then error54(k,l,nodeProps[nodeAddr].leafIdx,'excludeSetMaker');
         end
      end;
     if nodeHeap[nodeAddr].brother>0 then  excludeSetMaker(nodeHeap[nodeAddr].brother)            //przejście na brata
   End;{excludeSetMaker}

   Begin  //-----------------------ToRemoveSet------------------
    if tryStrToInt(trim(form1.Edit13.Text),rareEventNbr2) then
    else
     begin
      while not
      TrystrToInt(inputBox('Correct edit box text',form1.Edit13.Text+' is not correct integer number!',
       intToStr(round(0.5+EventNbr/(16*CentroidsNb_glob)))),rareEventNbr2) do;
      form1.Edit13.Text:=intToStr(rareEventNbr2);
     end;
    try
     if ToReportRAMinfo('excludeSet',high(excludeSet),sizeOf(TarrSet),(wholeEventNbr+1) div 8+1)
     then setLength(excludeSet,(wholeEventNbr+1) div 8+1);  //aktualizacja rozmiaru, w readExcludeSet mógł uzyskać zbyt dużą wartość, a wymagana jest dokładnie taka sama!
    except
    end;
    excludeSetCard:=cardSet(excludeSet);
    excludeSetMaker(0);
    form1.Label49.Caption:=intToStr(excludeSetCard);
   End;{ToRemoveSet}


 procedure ClassChanger;
  { Eksperyment testujący zachowanie się promienia informacyjnego
   Biegnie po liściach i zmienia klasyfikację zdarzeń przypisując im klasy, do których zostały zaliczone w efekcie grupowania
  }
  var z1,z2,z3 : char;

  procedure MakeHashTable(var List:TcharList; var Hash:TcharByte;var Sets:TcharSet;z:char; var hashCounter:byte);
   //tworzy skorowidze kodów znaków klasyfikujących
   Begin
    if not (z in Sets) then
     begin
      inc(hashCounter);
      List[hashCounter]:=z;                                        //dekoder znaków fonematycznych
      Hash[z]:=hashCounter;                                       //koder znaków fonematycznych
      include(Sets,z);
     end
   End;

 procedure CathClassChanger(nodeAddr:longWord);
   {
   Zmienić wszystkie 3 klasyfikatory dla celów testowych
  }
  var i:longWord;
   Begin  //-----------------------cath1ClassChanger------------------
    with form1 do
    if nodeHeap[nodeAddr].son>0 then  CathClassChanger(nodeHeap[nodeAddr].son)
    else    //znaleziono liść, więc
     begin
      inc(leafNodeNbr);
      if checkBox2.Checked then z1:=char(leafNodeNbr mod cath1Nbr+1);
      if checkBox3.Checked then z2:=char(leafNodeNbr mod cath2Nbr+1);
      if checkBox4.Checked then z3:=char(leafNodeNbr mod cath3Nbr+1);
      if checkBox2.Checked then MakeHashTable(cath1CodeList,cath1Hash,cath1Set,z1,hashCounter1);
      if checkBox3.Checked then MakeHashTable(cath2CodeList,cath2Hash,cath2Set,z2,hashCounter2);
      if checkBox4.Checked then MakeHashTable(cath3CodeList,cath3Hash,cath3Set,z3,hashCounter3);
      for i:=nodeProps[NodeAddr].lb to nodeProps[NodeAddr].hb do
       begin
        if checkBox2.Checked then eventcath1[i]:=z1;
        if checkBox3.Checked then eventcath2[i]:=z2;
        if checkBox4.Checked then eventcath3[i]:=z3;
       end;
     end;
    if nodeHeap[nodeAddr].brother>0 then  CathClassChanger(nodeHeap[nodeAddr].brother)            //przejście na brata
   End;{CathClassChanger}

  BEGIN  //--------------------------ClassChanger------------------
    hashCounter1:=0;hashCounter2:=0;hashCounter3:=0;
    cath1Set:=[]; cath2Set:=[]; cath3Set:=[];
    with form1 do
    begin
    if checkBox2.Checked then begin cath1CodeList[0]:=#0; cath1Hash[#0]:=0 end;                        //# znak oznaczający wszystkie znaki spoza danego zbioru znaków kodujących fonemy
    if checkBox3.Checked then begin cath3CodeList[0]:=#0; cath3Hash[#0]:=0 end;
    if checkBox4.Checked then begin cath2CodeList[0]:=#0; cath2Hash[#0]:=0 end;
    end;
    CathClassChanger(0);
   changeAllClasses:=false;
  END;{ClassChanger}

 procedure OpenreportFile;

 Begin
  reportFileOpened:=false;
  if fileExists(reportFileDir) or not directoryExists(extractFileDir(reportFileDir)) then
   if not SaveDialog(form1.SaveDialog1,reportFileDir,7,'report file saving') then //7=*report*.txt
   begin
    showMessage('The final report will not be created. The old one, namely "'+reportFileDir+'" remains,'#13#10'the program will be halted now!');
    halt;
   end;
  AssignFile(reportFile,reportFileDir);
  try
  rewrite(reportFile);
  except
  error36;
  end;
  form1.edit17.Text:=reportFileDir;
  reportFileOpened:=true;   reportDate:='report created at the '+dateToStr(now)+' '+timeToStr(now);
  writeln(reportFile,'Vector Quantization.'#13#10,reportDate,'.');
  flush(reportFile);
 End;{OpenreportFile;}

 procedure openTreeFile;
  begin
   openDialog(form1.OpenDialog1,treeFileDir,4,'Open tree data file for exclude set reading',form1.edit18);
   writeln(reportFile,'Quantization tree file for exclude set reading "',treeFileDir,'"');
  end;

 procedure spkInputFileParameters(var RadioGroup1,RadioGroup2,RadioGroup3:TRadioGroup;var label1:Tlabel;checkBox1:TcheckBox);
  var i:longint;
  Begin                           //            10          9           11
   with inputRecord do                                                                     //dataRecord do
   begin
    if (signal[2]>=0) and (signal[2]<=4) then RadioGroup1.ItemIndex:=signal[2] else RadioGroup1.ItemIndex:=-1;  //filter
    if (signal[3]>=0) and (signal[3]<=1) then RadioGroup2.ItemIndex:=signal[3] else RadioGroup2.ItemIndex:=-1;  //filter-scaling const
    if (signal[7]>=0) and (signal[7]<=4) then RadioGroup3.ItemIndex:=signal[7] else RadioGroup3.ItemIndex:=-1;  //weighting windows shape
    if signal[11]<>1 then checkBox1.Checked:=false else checkBox1.Checked:=true;                                //preemphase
    i:=powerSpectr[1];
    if i>parametersSize then
     begin
      showmessage('Some error in the source file occured. The  lifter treshold is too high. It should be <'+
       intToStr(parametersSize)+', but it is ='+intToStr(i)+'.'+
       #13#10'It has pure information meaning about signal processing at the spectral analysis stage, '+
       'and no meaning for the clustering process.'#13#10'It is given the value '+intToStr(parametersSize-1)+
       ' for now, but probably it is not true. It was rather ca. 15.'+
       #13#10'You should check what value it was given at the spectral analysis stage.');
      i:=parametersSize;
     end;
    label1.Caption:=intToStr(i-1);
    lifterTreshold:=i-1;                                  //cepstrum filter cut-off
   end;//-----------------------------abs'y, aby czytał starsze wersje spektrów, gdzie to nie było odnotowywane
  End; {spkInputFileParameters}

 procedure txtInputFileParameters(var RadioGroup1,RadioGroup2,RadioGroup3:TRadioGroup;var label1:Tlabel;checkBox1:TcheckBox);
  Begin
   with inputRecord do          //dataRecord do
   begin
    RadioGroup1.ItemIndex:=-1;  //filter
    RadioGroup2.ItemIndex:=-1;  //filter-scaling const
    RadioGroup3.ItemIndex:=-1;  //weighting windows shape
    checkBox1.Checked:=false;
    checkBox1.State:=cbGrayed;  //preemphase
    label1.Caption:=xxx;        //cepstrum filter cut-off
   end;//-----------------------------abs'y, aby czytał starsze wersje spektrów, gdzie to nie było odnotowywane
  End; {txtInputFileParameters}

 function realTypeRead(var vector:T128SmallIntArr; startRecording,realTypeSize:word;param:string):double;
  {
  for reading real values  rate and step from input file with integer components
  }
  var
  IntRealArr:array[0..3] of smallInt;
  k,l:byte;
  Begin
   k:=sizeOf(double) div 2;
   if k<>realTypeSize then
    begin
    ShowMessage('The realType size declaread in the Spectrum analyzer (='+intToStr(realTypeSize)+
     '), differs from the realType declaread here (='+intTostr(k)+
     ').'#13#10'The parameter'#13#10#13#10+param+#13#10#13#10'will be incorrectly read out.'+
     #13#10'This influences averaging parameters in the spectra or cepstra preprocessing consisted in time-constant'+
     ' contribution removal.'#13#10'You should set this parameter manually'+
     #13#10'The discrepancy can appear if you use analysis resultst from before march 2007,'+
     #13#10'which were recorded without sending this parameter...');
     result:=0;
     exit
    end;
   if startRecording>3+k+1 then
    begin
     ShowMessage('There is something wrong with reading of the start point of the '+param+
     '. You should set this parameter manually..(as well as the second)'); result:=0; exit
    end;
   for l:=0 to k-1 do IntRealArr[l]:=vector[l+startRecording];
   result:=double(IntRealArr);
  End;{realTypeRead}

 procedure spkDataParameters(var EventNbr:longWord);
  //reads the data parameters from the 0-th record of the data file
  var  i:byte;
  Begin
   read(eventFile,inputRecord);                                                                                    //dataRecord);
     with inputRecord do                                                                                           //dataRecord do
     begin
      EventNbr:=sliceNbr;   form1.Edit15.Text:=intToStr(EventNbr);                                                 //round(vect[0]);
      with form1.Edit1 do if not tryStrToInt(trim(Text),nc) then showMessage(Text+' is not an integer number!');   //nc:=round(vect[1]);
      FFTwindowsWidth:=signal[0];  form1.edit8.Text:=intToStr(FFTwindowsWidth);                                                                     //vect[3]); //Orig:=round(signal[0]);
      cath2Nbr:=byte(cath2);
      cath1Nbr:=byte(cath1);
      cath3Nbr:=byte(cath3);
      with form1 do spkInputFileParameters(RadioGroup10,RadioGroup9,RadioGroup11,label86,checkBox28);
      frameStep:=realTypeRead(powerSpectr,3,powerSpectr[2],'STEP');
      rate:=realTypeRead(powerSpectr,3+powerSpectr[2]+1,powerSpectr[2],'RATE');
      charArray:=TcharArray(smoothedSpectr);
      if (charArray[0]=#0) or (charArray[0]>#255) then  waveFileDir:='Unknown'
      else for i:=1 to byte(chararray[0]) do waveFileDir:=chararray[i];
      writeln(reportFile,'Wave file "',waveFileDir,'"');
      with form1 do
      if checkBox30.Checked then
       begin
        Edit22.Text:=floatToStr(frameStep);  Edit23.Text:=floatToStr(rate);
       end
      else
      begin
       Edit22.Text:=XXX;  Edit23.Text:=XXX;
      end;
     end;{with}
  End; {spkDataParameters}

 procedure txtDataParameters(var EventNbr:longWord);
 //reads the data parametersfrom of the *.txt file
  var s:shortString; c:integer;

  function name(var s:shortString;i:byte):shortString;
  //reads cath. variable names from header
   begin
    result:='';
    while  (s[1] in [#0..#32]) and (length(s)>0) do delete(s,1,1);
    while  not (s[1] in [#0..#32]) and (length(s)>0) do
     begin
      result:=result+s[1];
      delete(s,1,1);
     end;
    if result='' then result:='Y'+intToStr(i);
   end;

  Begin
   try
   repeat
   readln(txtEventFile,s);
   while  (s[1] in [#0..#47]) and (length(s)>0) do delete(s,1,1); //skip trailing nonvisual signs, spaces and other chars
   c:=pos(' ',s);
   val(copy(s,1,pos(' ',s)-1),eventNbr,c);
   if c<>0 then
    begin
    c:=pos(#9,s);
    val(copy(s,1,pos(#9,s)-1),eventNbr,c);
   end
   until c=0;                                                  //events data
   form1.Edit15.Text:=intToStr(EventNbr);
   readln(txtEventFile,nc,s);                                                //number of vectors components
   readln(txtEventFile,txtStretch,s);                                       //components values range
   readln(txtEventFile,s); //header
   except
    error100;
   end;

   y1Name:=name(s,1);  form1.edit30.Text:=y1Name;
   Y2Name:=name(s,2);  form1.edit31.Text:=y2Name;
   y3Name:=name(s,3);  form1.edit32.Text:=y3Name;
   YnameActualize;

   with form1.Edit1 do text:=intToStr(nc);
   form1.edit8.Text:=xxx;                                               //FFT signal portions
   with form1 do txtInputFileParameters(RadioGroup10,RadioGroup9,RadioGroup11,label86,checkBox28);
   AveragingTime:=100; frameNbr:=10; frameStep:=1; rate:=10000; multStdDev:=1; s:='';//we take here default values
   with form1.checkbox32 do begin Checked:=true; enabled:=false end;
   with form1 do
   if checkBox30.Checked then                 //remove time constant contribution
    begin
     Edit22.Text:=floatToStr(frameStep);      //floatToStr(frameStep);
     Edit23.Text:=floatToStr(rate);           //floatToStr(rate);
    end
   else
   begin
    Edit22.Text:=XXX;  Edit23.Text:=XXX;
   end;
   writeln(reportFile,'Wave file "',waveFileDir,'"');
  End; {txtDataParameters}


procedure spkInputer(out dataRecord:TdataRecord);
 //czyta cały rekord z wejścia i odpowiednio do opcji podstawia pod wyjście jeden z wektorów parametrow
  var i:byte;
  Begin
   read(eventFile,InputRecord);
   with inputRecord,dataRecord do
    case form1.RadioGroup2.ItemIndex of   //events feature
     0: vect:=inputRecord.powerSpectr;
     1: vect:=inputRecord.smoothedSpectr;
     2: vect:=inputRecord.melSmoothSpectr;
     3: vect:=inputRecord.powerCepstr;
     4: vect:=inputRecord.melCepstr;
    end;{case}
   with inputRecord do
    begin
     dataRecord.cath1:=cath1;
     dataRecord.cath2:=cath2;
     dataRecord.cath3:=cath3;
     if form1.CheckBox13.Checked then showSpkInputRecord(cath2,cath1,cath3,256);
    end;{with}
    with dataRecord do    //oznaczyć wartości skrajne  dla każdej składowej wektora cech niezależnie od tego, czy została użyta, bądź wogóle określona
     for i:=0 to parametersSize do with minMax[i] do
      begin
       if vect[i]<min then min:=vect[i];
       if vect[i]>max then max:=vect[i];
      end;{for}
    if form1.CheckBox15.Checked then
     if
      application.MessageBox('Ok, to show next record, No to turn off stepwise reading','Stepwise reading',4)=idNo
     then
      begin
       form1.checkbox13.SetFocus;
       form1.CheckBox15.Checked:=false;
      end;
  End; {spkInputer}

procedure txtInputer(out dataRecord:TdataRecord);
 //czyta cały rekord z wejścia i odpowiednio do opcji podstawia pod wyjście jeden z wektorów parametrow

 function skipper:char;
  begin
   repeat read(txtEventFile,result) until not (result in [#32,#9]); //(result<>' ') and  (result<>#9);
  end;

  var i:byte;
  Begin
   with dataRecord do
    begin
     try
      cath1:=skipper;
      cath2:=skipper;
      cath3:=skipper;
      for i:=0 to nc-1 do read(txtEventFile,vect[i]); readln(txtEventFile);
     except
      error100;
     end;
     if form1.CheckBox13.Checked then  showTxtInputRecord(cath2,cath1,cath3,txtStretch);
    end;{with}
   with dataRecord do   //oznaczyć wartości skrajne  dla każdej składowej wektora cech niezależnie od tego, o ile jest określona
    for i:=0 to nc-1 do with minMax[i] do
     begin
      if vect[i]<min then min:=vect[i];
      if vect[i]>max then max:=vect[i];
     end;{for}
   if form1.CheckBox15.Checked then
    if
     application.MessageBox('Ok, to show next record, No to turn off stepwise reading','Stepwise reading',4)=idNo
    then
     begin
      form1.checkbox13.SetFocus;
      form1.CheckBox15.Checked:=false;
     end;
  End; {txtInputer}

 procedure error260(s:shortString);

   Begin
    s:='Error260, program error. Unproper procedure i.e. "'+s+'" was chosen, program will be halted now.'#13#10+
       'Turn to the author!'#13#10'End of the error 262 description.';
    ShowMessage(s);
    writeln(reportFile,s);
    flush(reportFile);
    halt;
   End;

 procedure setSPKclassifiersNumbers(i,j,k:byte);

   procedure error26(s : string; l,m:byte);
    Begin   if stopReading then exit; //05.11.08; nie generować komunikatu, gdy nastąpiła przerwa czytania danych, bo kontrolowane parametr są czytane z nagłówka danych i dotyczą całego zbioru, a nie jego części.
     s:='Error 26.'#13#10'The parameter '+s+' differs from expected ones. It should be '+intToStr(l)+
     ', but it turned out that its set contains '+intToStr(m)+' elements. Check "'+eventFileDir+'" data file.';
     s:=s+#13#10'Probably no consequences for computations - proper values will  be applied.'+
     #13#10'End of the error 26 description.';
     ShowMessage(s);
     writeln(reportFile,s);
     flush(reportFile);
    end;{error26}

  Begin  //------setClassifiersNumbers-------
   if spk_txt then
   with form1 do
    begin
     cath1Nbr:=card(Tset(cath1Set));
     if i<>cath1Nbr then error26(y1Name,i,cath1Nbr);
     if checkBox2.Checked then Edit9.Text:=intToStr(cath1Nbr);
     cath2Nbr:=card(Tset(cath2set));
     if j<>cath2Nbr then error26(y2Name,j,cath2Nbr);
     if checkBox3.Checked then Edit10.Text:=intToStr(cath2Nbr);
     cath3Nbr:=card(Tset(cath3Set));
     if k<>cath3Nbr then error26(y3Name,k,cath3Nbr);
     if checkBox4.Checked then Edit11.Text:=intToStr(cath3Nbr);
    end
    else error260('setSPKclassifiersNumbers');
  End; {setSPKclassifiersNumbers}

 procedure setTXTclassifiersNumbers(i,j,k:byte);

  Begin  //------setClassifiersNumbers-------
   if not spk_txt then
   with form1 do
    begin
     cath1Nbr:=card(Tset(cath1Set));
     if checkBox2.Checked then Edit9.Text:=intToStr(cath1Nbr);
     cath2Nbr:=card(Tset(cath2set));
     if checkBox3.Checked then Edit10.Text:=intToStr(cath2Nbr);
     cath3Nbr:=card(Tset(cath3Set));
     if checkBox4.Checked then Edit11.Text:=intToStr(cath3Nbr);
    end
   else error260('setTXTclassifiersNumbers');
  End; {setTXTclassifiersNumbers}

 procedure DataPrepare;
{
 czyta parametry analiz z pierwszego rekordu
}
var extension:shortString;
  Begin    //----------------------------DataPrepare;-------------------
    form1.PageControl2.ActivePageIndex:=1;
     case form1.RadioGroup17.ItemIndex of   //txt|excel switch
     0 : begin
          RowsToReportTableCaption:=RowsToReportTableCaptionTXT;
          H0ToReport:=H0ToReportTXT
         end;
     1 : begin
          RowsToReportTableCaption:=RowsToReportTableCaptionEXCEL;
          H0ToReport:=H0ToReportExcel
         end;
    end;{case}
    form1.statusbar1.SimpleText:='Data reading start (DataPrepare)'; application.ProcessMessages;
    OpenreportFile;
    with form1 do
    begin
     groupbox1.Visible:=true; RadioGroup2.Enabled:=false; GroupBox6.Enabled:=false;
     CheckBox36.Enabled:=false; Edit29 .Enabled:=false;
    end;
    with form1 do
     if CheckBox36.Checked then
      label123.Caption :='Data reading will be broken at '+edit29.Text+#13#10'click the "'+button22.Caption+'" button to change it!'
     else label123.Caption :='';
    cath1Set:=[]; cath2Set:=[]; cath3Set:=[];  form1.PageControl2.Visible:=true;
    openDialog(form1.OpenDialog1,eventFileDir,6,'Open event data file',form1.edit5);
    writeln(reportFile,'Processed file "',eventFileDir,'"'); form1.Caption:='Vector Quantizier processes '+eventFileDir;
    extension:=extractFileExt(eventFileDir);
    if extension='.spk' then
     begin
      assignFile(eventFile,eventFileDir);
      inputer:=spkInputer;
      DataParameters:=spkDataParameters;
      showModifiedInput:=showModifiedSpkInput;
      setClassifiersNumbers:=setSPKclassifiersNumbers;
      with form1 do
       begin
        panel3.Visible:=true; panel4.Visible:=true;
        label56.Visible:=true;label57.Visible:=true;label58.Visible:=true;label59.Visible:=true;
        label60.Visible:=true; label61.Visible:=true; 
        with RadioGroup2 do
         begin
          Enabled:=true;
          if ItemIndex<0 then button22ClickInside;
          itemIndex:=4;
          if ItemIndex<0 then showMessage('You have should picked X data stream, but you had''nt. Default value "'+
             form1.radioGroup2.Items[4]+'"  was picked. You can still change it by choosing the "'+
             form1.mainMenu1.Items[2].Caption +'".');
         end;{with radio2}
       end;{with}
      spk_txt:=true;
      try
      reset(eventFile);
      except
       showmessage('Have you received message "I/O error 32"? - if yes, check whether you have not opened the file '+eventFileDir+' with an another program.');
      end;
     end
    else   // input data is in text file
     begin
      assignFile(txtEventFile,eventFileDir);
      inputer:=txtInputer;
      waveFileDir:='Does not refer to';
      DataParameters:=txtDataParameters;
      showModifiedInput:=showModifiedTxtInput;
      setClassifiersNumbers:=setTXTclassifiersNumbers;
      with form1 do
       begin
        RadioGroup2.ItemIndex:=-1;
        RadioGroup2.Enabled:=false;
        panel3.Visible:=false; panel4.Visible:=false;
        label56.Visible :=false;label57.Visible :=false;label58.Visible :=false;label59.Visible :=false; label64.Visible :=false;
        label60.Visible :=false; label61.Visible:=false;
       end;{with}
      spk_txt:=false;
      try
       reset(txtEventFile);
      except
       showmessage('Have you received message "I/O error 32"? - if yes, check whether you have not opened the file '+eventFileDir+' with an another program, i.e. MS Word');
      end;
     end;{else}
    form1.edit5.Text:=eventFileDir;
    form1.edit5.Enabled:=false;
    form1.Button2.Enabled:=false;
    //eventnbr:=fileSize(eventFile)-1;                           //-1, bo pierwszy rekord, zawiera PARAMETRY danych
     DataParameters(wholeEventNbr);
     with form1.Button21 do   //OK|Break reading
      begin
       form1.label53.Alignment:=taLeftJustify;
       form1.label53.Color:=cllime;
       form1.label53.Caption:='Click Options to check and correct'#13#10'the analysis parameters or'#13#10'OK to continue data feature'#13#10'vectors reading...';
       top:=top+height;
       Caption:='OK';
       form1.label53.Width:=274;
       form1.label53.Height:=60;
       form1.GroupBox1.Height:=145;
       form1.button22.Top:=115;
      end;
   End; {DataPrepare}

procedure finishDataStepIn(var EventNbr:longWord);
{
koniec czytania i ujawniania parametrów analiz
}

 procedure error23;
   var s:string;
   begin
    s:='Error 23.'#13#10'Parametry różne od parametrów CORPOR''y '#13#10+
    '             cath1Nbr    cath2Nbr   cath3Cath'#13#10+
    'pow. być'#9'40,'#9'45,'#9'2'#13#10+
    'jest'#9#9+intToStr(cath1Nbr)+','#9+intToStr(cath2Nbr)+','#9+intToStr(cath3Nbr)+#13#10'End of the error 23 description.';
    showMessage(s);
    writeln(reportFile,s);
    flush(reportFile);
   end;

  procedure zeroHistory;
   var i,j:word;
   Begin
    if frameStep<=0 then
    frameStep:=strToInt(inputBox('Averaging time','You have forgotten to input frameStep. Input it now - integer number in ms','5'));;
    if frameNbr=0 then
     begin
     averagingTime:=strToInt(inputBox('Averaging time','You have forgotten to input averaging time. Input it now - integer number, in miliseconds','300'));
     frameNbr:=round(averagingTime/frameStep);
     if frameNbr>high(History) then
      begin
       showMessage(delAmpers(('zeroHistory, "'+form1.label97.Caption +'" must be <= then '+intToStr(high(History))+
       #313#10'It means that Averaging time must be <='+intToStr(high(history)*round(frameStep))+'.'#13#10'You must change the array "History" declaration'#13#10'if you need longer averaging time')));
       frameNbr:=high(history);
      end;
     averagingTime:=round(frameStep*frameNbr);
      form1.edit20.Text:=intToStr(averagingTime);
      form1.edit21.Text:=intToStr(frameNbr);
     end;{frameNbr=0}
    for i:=0 to nc-1 do meanVector[i]:=0;
    for i:= 0 to frameNbr-1 do
     for j:=0 to nc-1 do
     history[i,j]:=0;
   End; {zeroHistory}

 procedure error30(s:string;var p1:byte;p2:byte;edit:Tedit);
  Begin
    s:='Error 30; Unknown ERROR cause - '+s+#13#10'Now is '+intToStr(p1)+', should be '+intToStr(p2)+
        #13#10'or the "'+programDir+'" has not been found.'+
        #13#10'The parameter will be set to proper value, however there is something wrong with the environment or the program...';
    showMessage(s); s:=s+#13#10'End of the error 30 description.';
    writeln(reportFile,s);
    p1:=p2;
    edit.Text:=intToStr(p1);
    flush(reportFile);
  End;

 Begin //---------------------------------FinishDataStepIn------------------
  if spk_txt then
    with form1,inputRecord do
     begin
      if checkBox2.Checked then if cath1Nbr<>byte(cath1) then error30(y1Name+' change!!',cath1Nbr,byte(cath1),edit9);
      if checkBox3.Checked then if cath2Nbr<>byte(cath2) then error30(y2Name+' change!!',cath2Nbr,byte(cath2),edit10);
      if checkBox4.Checked then if cath3Nbr<>byte(cath3) then error30(y3Name+' change!!',cath3Nbr,byte(cath3),edit11);
     end;{with}
     with form1 do
     begin
      with Button21 do                          //"Break" on groupBox1 "Data reading"
      begin
      top:=top-height;
      Caption:='Break';
      label53.Caption:='';                      //number of event
      label53.width:=0;
      label53.height:=15;
      label53.Alignment:=taRightJustify;
      label53.left:=label10.left+label10.width;
      button22.Top:=70;                         //"options"  on groupBox1 "Data reading"
      groupBox1.Height:=104;
      application.ProcessMessages;
      end;
     end;
     with form1 do
     if checkBox30.Checked then                 //remove time constant contribution
      begin
       Edit22.Text:=floatToStr(frameStep);  Edit23.Text:=floatToStr(rate);
      end
    else
     begin
      Edit22.Text:=XXX;  Edit23.Text:=XXX;
     end;
    form1.Edit15.Text:=intToStr(EventNbr);      //whole samle number of events
    if CentroidsNb_glob<=0 then error42(CentroidsNb_glob,form1.edit2,form1.label5,'procedure finishDataStepIn');
{!} if  form1.checkBox36.Checked and (BreakReadingPoint<EventNbr) then EventNbr:=BreakReadingPoint;              //check36 - "Break data reading at:"
    with form1 do
     if checkBox19.Checked then edit7.Text:=xxx                                                                   //check19 - Degresive isolation set power treshold
     else Edit7.Text:=intToStr(round(0.5+EventNbr/(8*CentroidsNb_glob)));                                         //edit7: rare events power treshold for isolation
    form1.StatusBar1.SimpleText:='vectorAndCathListRead: Rezerwuję pamięć dla wektorów zdarzeń i trzech list kategorii ('
     +intToStr(EventNbr)+') dla każdego zdarzenia, listy fonemów ('+intToStr(cath1Nbr)+'), listy osób ('+
     intToStr(cath2Nbr)+') i listy kategorii dźwięczności ('+intToStr(cath2Nbr);
   ToReportRAMinfoCaption;
   with form1.RadioGroup15 do                   //radio15 - "Memory reservation"
    begin
     visible:=true;
     Caption:='Memory reservation, wait...';       ItemIndex:=0;
     if form1.checkBox30.Checked then  zeroHistory;                               //pamięć dla uśreadniania
     Items[0]:=Items[0]  +'  '+intToStr(sizeOf(double)*nc*frameNbr+sizeOf(double)*nc);
     Items[1]:=Items[1]  +'  '+intToStr(sizeOf(TVect)*(EventNbr+1));
     Items[2]:=Items[2]  +'  '+intToStr(sizeOf(char)*(EventNbr+1));
     Items[3]:=Items[3]  +'  '+intToStr(sizeOf(char)*(EventNbr+1));
     Items[4]:=Items[4]  +'  '+intToStr(sizeOf(char)*(EventNbr+1));
     Items[5]:=Items[5]  +'  '+intToStr(sizeOf(longWord)*(EventNbr+1));
     Items[6]:=Items[6]  +'  '+intToStr(sizeOf(longWord)*(EventNbr+1));
     Items[7]:=Items[7]  +'  '+intToStr(sizeOf(char)*(cath1Nbr+2));
     Items[8]:=Items[8]  +'  '+intToStr(sizeOf(char)*(cath2Nbr+1));
     Items[9]:=Items[9]  +'  '+intToStr(sizeOf(char)*(cath2Nbr+1));
     Items[10]:=Items[10]+'  '+intToStr(sizeOf(char)*(cath3Nbr+1));
     Application.ProcessMessages;
     ItemIndex:=1;
     if ToReportRAMinfo('vectList (1)',high(vectList),sizeOf(Tvect),(EventNbr+1))
     then setLength(vectList,EventNbr+1);
     ItemIndex:=2;
     if ToReportRAMinfo('eventcath1 (1)',high(eventcath1),sizeOf(TcharList),(EventNbr+1))
     then setLength(eventcath1,EventNbr+1);
     ItemIndex:=3;
     if ToReportRAMinfo('eventcath2 (1)',high(eventcath2),sizeOf(TcharList),(EventNbr+1))
     then setLength(eventcath2,EventNbr+1);
     ItemIndex:=4;
     if ToReportRAMinfo('eventcath3 (1)',high(eventcath3),sizeOf(TcharList),(EventNbr+1))
     then setLength(eventcath3,EventNbr+1);
     ItemIndex:=5;
     if ToReportRAMinfo('wbl (1)',high(wbl),sizeOf(TlwArr),EventNbr)
     then setLength(wbl,EventNbr);
     ItemIndex:=6;
     if ToReportRAMinfo('sbl (1)',high(sbl),sizeOf(TlwArr),EventNbr)
     then setLength(sbl,EventNbr);
     ItemIndex:=7;
     if ToReportRAMinfo('cath1CodeList',high(cath1CodeList),sizeOf(TcharList),(cath1Nbr+2))
     then setLength(cath1CodeList,cath1Nbr+2);
     ItemIndex:=8;
     if ToReportRAMinfo('cath2NameList',high(cath2NameList),sizeOf(Tstring9),(cath1Nbr+1))
     then setLength(cath2NameList,cath2Nbr+1);
     ItemIndex:=9;
     if ToReportRAMinfo('cath2CodeList',high(cath2CodeList),sizeOf(TcharList),(cath2Nbr+1))
     then setLength(cath2CodeList,cath2Nbr+1);
     ItemIndex:=10;
     if ToReportRAMinfo('cath3CodeList',high(cath3CodeList),sizeOf(TcharList),(cath3Nbr+1))
     then setLength(cath3CodeList,cath3Nbr+1);
     ItemIndex:=11;               
     Caption:='Almost all needed RAM reserved!';
    end;{with}
  form1.StatusBar1.SimpleText:='vectorAndCathListRead, czytam dane';
  if not form1.CheckBox13.Checked then application.Minimize;
  form1.label53.caption:=intToStr(EventNbr);
  Application.ProcessMessages;
 End;{finishDataStepIn}

 procedure error5;
   var s1,s:string; i:byte;
   Begin
    s:='';
    with form1 do
     begin
     s1:=mainMenu1.Items[2].Caption+'\'+PageControl1.Pages[6].Caption+'\'+label11.Caption +'\'+label127.Caption +'\'+label36.Caption+'\'+label37.Caption;
    for i:=1 to length(s1) do if s1[i]<>' ' then s:=s+s1[i]; //usunąć spacje 
    s:='Error 5'#13#10'All events were included to the  "Exclude" set of  events!, nothing to compute. '+
     'Check the'#13#10'"'+s+'"'+#13#10'option.'#13#10+
     'The tresholds are too high, so all leaf sets were included to the exclude set.'+#13#10+
     'You should lower them or lower the number of classes, i.e. "'+ mainMenu1.Items[2].Caption+'\'+PageControl1.Pages[0].caption+'\'+label5.Caption+'"'+
     #13#10'In this case sets will be bigger. The program will be halted now.'#13#10'Important!! Set the "'+
     label37.Caption+'" treshold to 0 if you wanted to repeat analysis with the same data (because the exclude set can grow with every next pass)'
     +#13#10'End of the error 5 description.';
    end;{with}
    s:=delAmpers(s);
    showMessage(s);
    writeln(reportFile,s);
    flush(reportFile);
    halt;
   End;

 procedure vectorAndCathListRead(var eventNbr:longWord);
 {
  Odczytuje z dysku listę wektorów cech (listę zdarzeń, czyli listę przekrojów spektralnych lub cepstralnych)
  oraz ich transkrypcję, osobę i kategorię dźwięczności
 }
  var     i:longWord;

 procedure error6(const eventNbr:longWord);
  var s:string;
   Begin
    s:='Error 6'#13#10'Program error, or the file '+eventFileDir+' is too short.'#13#10'It was expected to find '+
    intToStr(eventNbr)+' features vectors, but it was read '+intToStr(i)+'!'#13#10'despite the file '#9+eventFileDir+
    #9' has '+intToStr(fileSize(eventFile))+' members.';
    if eof(eventFile) then s:=s+#13#10'It was reached end of file during reading the file [eof(eventFile)].'#13#10;   s:=s+
    #13#10'End of the error 6 description.';
    showMessage(s);
    writeln(reportFile,s);
    flush(reportFile);
   End;

  procedure error7(const i:longWord);
   var s:string;
   Begin
    s:='Error 7'#13#10'Some unknown error happened in "'+eventFileDir+'". Reading it has stopped at the position '+
    intToStr(i)+#13#10'End of the error 7 description.';
    showMessage(s);
    writeln(reportFile,s);
    flush(reportFile);
   End;

 procedure cath1SetAndListCreate(const sp:char;var j:byte);
  Begin
   if not (sp in cath1Set) then
    begin
     inc(j);
     if j>high(cath1CodeList) then with form1 do
      begin
       if ToReportRAMinfo('cath1CodeList',high(cath1CodeList),sizeOf(TcharList),(j+1+j div 5))
       then setLength(cath1CodeList,j+1+j div 5);
      if checkBox2.Checked then edit9.Text:=intToStr(j);
      end;
     cath1CodeList[j]:=sp;                 //dekoder znaków fonematycznych
     cath1Hash[sp]:=j;                 //koder znaków fonematycznych
     include(cath1Set,sp);
    end; {if}
  End;{cath1SetAndListCreate}

 procedure cath2SetAndListCreate(const sp:char;var k:byte);

  Begin
   if not (sp in cath2Set) then
    begin
     inc(k);
     if k>high(cath2CodeList) then with form1 do
      begin
       if ToReportRAMinfo('cath2CodeList',high(cath2CodeList),sizeOf(TcharList),(k+1+k div 5))
       then setLength(cath2CodeList,k+1+k div 5);
      if checkBox3.Checked then edit10.Text:=intToStr(k);
      end;
     cath2CodeList[k]:=sp;           //dekoder osobników
     cath2Hash[sp]:=k;               //koder osobników
     include(cath2Set,sp);
    end;
  End;{cath2SetAndListCreate}

 procedure cath3SetAndListCreate(const sp:char;var l:byte);
  Begin
   if not (sp in cath3Set) then
    begin
     inc(l);
     if l>high(cath3CodeList) then with form1 do
      begin
       if ToReportRAMinfo('cath3CodeList',high(cath3CodeList),sizeOf(TcharList),(l+1+l div 5))
       then setLength(cath3CodeList,l+1+l div 5);
       if checkBox4.Checked then edit11.Text:=intToStr(l);
      end;
     cath3CodeList[l]:=sp;           //dekoder kategorii dźwięczności
     cath3Hash[sp]:=l;               //koder kategorii dźwięczności
     include(cath3Set,sp);
    end;
   End;{cath3SetAndListCreate}

  procedure minMaxReset;
  var i:byte;
   begin
   for i:=0 to parametersSize do with minMax[i] do
     begin
      min:=high(smallInt);
      max:=low(smallInt);
     end;{for}
   end;
  procedure constantContributionRemove(var vect:T128SmallIntArr; n:longword);
  var i,j:word;
   Begin
    with form1 do
     begin
      panel7.visible:=checkBox30.Checked;    // added 240311
      label100.visible:=checkBox30.Checked;
      label101.visible:=checkBox30.Checked;
     end;
    i:=n mod frameNbr;                                              //bieg po pierścieniu buforująym
    for j:=0 to nc-1 do meanVector[j]:=meanVector[j]-History[i][j];  //odejmij od śreadniej jej pierwszy (najstarszy) składnik
    for j:=0 to nc-1 do
     History[i][j]:=vect[j]/frameNbr;                                 //wprowadź wektor cechy do bufora (historii)
    for j:=0 to nc-1 do meanVector[j]:=meanVector[j]+History[i][j];    //dodaj do śreadniej najnowszy składnik
    for j:=0 to nc-1 do vect[j]:=round((vect[j]-meanVector[j])/2);      //usuń składową czasową stałą z aktualnego wektora cech
    if form1.CheckBox13.Checked then showModifiedInput;                  //show input graphics
   End;{constantContributionRemove}

  var j,k,l:byte;
  Begin  //-------------------------vectorAndCathListRead--------------------------
   minMaxReset;
   i:=0;  // eventNbr:=38823;
   form1.CheckBox36.Enabled:=false;                                       //check - "Break data reading at:"
   form1.Edit29 .Enabled:=false;                                          //edit - "Break data reading at:"
   while (i<EventNbr) and not stopReading do                              //not (eof(eventFile)) do   ten strażnik nie sprawdza się!, czyta tylko do 941847 elementów z pliku....
    begin
     if  form1.checkBox36.Checked and (i>=(BreakReadingPoint-1)) then
      begin stopReading:=true; form1.button22.Enabled:=true end;            //przerwać czytanie w pkcie BreakReadingPoint
     inputer(dataRecord);                                                                                         //read(eventFile,dataRecord);
     if form1.checkBox30.Checked then constantContributionRemove(dataRecord.vect,i);
     with dataRecord do
      begin
       vectList[i]:=vect;
       eventcath1[i]:=cath1;         cath1SetAndListCreate(cath1,j);        form1.Label31.Caption:=cath1;
       eventcath2[i]:=cath2;     cath2SetAndListCreate(cath2,k);    form1.Label32.Caption:=cath2;            //+#13#10'nbr='+intToStr(byte(cath2)-65);
       eventcath3[i]:=cath3;   cath3SetAndListCreate(cath3,l);  form1.Label33.Caption:=cath3;
      end;{with}
     inc(i);
     form1.label10.Caption:=intToStr(i);   Application.ProcessMessages;
    end;{while}
   if not stopReading then
    begin
     writeln(reportFile,EventNbr,' vectors  was read.');
     if i<>EventNbr then error6(EventNbr)
     else
    end
   else                                 //przerwano czytanie, więc skrócić tablice

    begin
     writeln(reportFile,i,' vectors of ',EventNbr,' was read.');
     EventNbr:=i;                       //Uwaga, próba obcięcia tablic przez setLength(*,i) nie powiodła się!, program daje złe wyniki po takiej akcji....
     if EventNbr<high(vectList) then
       try
       if ToReportRAMinfo('vectList (2)',high(vectList),sizeOf(Tvect),(EventNbr+1))
       then setLength(vectList,EventNbr+1);
       if ToReportRAMinfo('eventcath1 (2)',high(eventcath1),sizeOf(TcharList),(EventNbr+1))
       then setLength(eventcath1,EventNbr+1);
       if ToReportRAMinfo('eventcath2 (2)',high(eventcath2),sizeOf(TcharList),(EventNbr+1))
       then setLength(eventcath2,EventNbr+1);
       if ToReportRAMinfo('eventcath3 (2)',high(eventcath3),sizeOf(TcharList),(EventNbr+1))
       then setLength(eventcath3,EventNbr+1);
       if ToReportRAMinfo('wbl (2)',high(wbl),sizeOf(TlwArr),(EventNbr))
       then setLength(wbl,EventNbr);
       if ToReportRAMinfo('sbl (2)',high(sbl),sizeOf(TlwArr),(EventNbr))
       then setLength(sbl,EventNbr);
       except
       error48;
       end
     else if EventNbr>high(vectList) then error63(EventNbr,high(vectList));
    end;

   form1.PageControl2.Visible:=false;;
   form1.RadioGroup2.Enabled:=false;
   form1.WindowState:=wsMaximized; Application.ProcessMessages;
   form1.Edit12.Text:=intToStr(eventNbr);      //read eventNbr
   windows.beep(400,200);
   flush(reportFile);
  End;{vectorAndCathListRead}

 procedure saveTree(centroidsNb, nc:word; var treeFileDir:string);//; const ext:shortString);
  var
     decision : byte;
            i : longWord;
            j : longword;
            s,s1 : String;

  function openTreeFile:boolean;
   Begin
    openTreeFile:=true;  s:=treeFileDir;
    if not form1.CheckBox18.Checked then   //nie wpisywać w pętli step RUN
    begin
     if not form1.CheckBox17.Checked then  //brak pozwolenia na nadpisywanie bez ostrzeżenia
     Begin
      s1:=extractFileName(reportFileDir);           //wziąć nazwę raportu i dodać rozszerzenie vq
      delete(s1,pos('.',s1),length(s1)-pos('.',s1)+1);
      treeFileDir:=extractFilePath(reportFileDir)+s1+'.vq';
      if fileExists(treeFileDir) then
       repeat
        if not saveDialog(form1.SaveDialog1,treeFileDir,4,'Quantisation tree saving') then //4=*.vq*
        decision:=messageDlg('No result savings?',mtConfirmation,mbyesNo,0)
        else break;
        showMessage('Resulted quantisation tree was not saved!');
        writeln(reportFile,'Resulted quantisation tree (on user request) was not saved!');
        openTreeFile:=false;
        exit;                                    //wyniki nie będą zapisane!!
       until decision=mrYes
      else showMessage('Results quantisation tree was saved in "'+treeFileDir+'"');
    End;
    end{form1.CheckBox18.Checked}
    else form1.CheckBox17.Checked:=false;  //w pętli nadpisuj bez ostrzegania
    if s<>treeFileDir then
     begin initWrite; form1.Edit18.Text:=treeFileDir end;
    assignFile(treeFile,treeFileDir);
    rewrite(treeFile);
    //form1.edit18.Text:=treeFileDir;
   End;{openTreeFile}

  Begin //---------------------saveTree--------------------
   form1.Label66.Caption:='Output tree saving';
   decision:=mrNo;    treeSaved:=false;
   if not openTreeFile then exit;
   if spk_txt then with form1.RadioGroup2 do s:=Items[ItemIndex]
   else s:='One stream data from the text file';
   s:='. Analysed feature "'+s+'".';    setArray:=TsetArray(featureSet);
   writeln(treeFile,'date: '+dateToStr(date)+' time: '+timeToStr(time),', report date: ',reportDate,', heap size=',intToStr(heapTop),s);
   writeln(treeFile,wholeEventNbr,' - number of the data vectors; teaching events file: ', eventFileDir);
   writeln(treeFile,form1.RadioGroup12.ItemIndex:6,' ', form1.radiogroup12.caption);//CART|centroids dividing method, if =0 then CART, if =1 then centroids');
                    writeln(treeFile,centroidsNb:6,' ',heapTop:6,' ',wholeEventNbr:6,' ',lifterTreshold,' ',waveFileDir);              //Centroids number, heapTop, eventNbr ',
                             writeln(treeFile,nc:6,' ',FFTwindowsWidth,' Consideread components number (nc), FFT windows width ');
    writeln(treeFile,form1.RadioGroup2.ItemIndex:6,' ', form1.radiogroup2.caption);            //index of the chosen feature (radiobutton index), '
    for i:=0 to 3 do write(treeFile,TSAC(cath1Set)[i],' ');
    for i:=0 to 3 do write(treeFile,TSAC(cath2Set)[i],' ');
    for i:=0 to 3 do write(treeFile,TSAC(cath3Set)[i],' ');
    writeln(treeFile,' coded cathegories sets values');
    for i:=1 to 8 do write(treeFile,setArray[i],' ');
    with form1 do
     Begin
        writeln(treeFile,Label112.caption);                  //featureSet
        writeln(treeFile,byte(CheckBox1.checked):6,' ',byte(CheckBox2.checked):6,' ',byte(CheckBox3.checked):6,' ',byte(CheckBox4.checked):6,' ',byte(CheckBox19.checked):6,' ',label119.caption,CheckBox19.caption);//'Classificators for supervised training:, degressive isolation',
       writeln(treeFile,byte(CheckBox30.checked):6,' ', checkBox30.caption);                   //averaging On, Off '
            writeln(treeFile,ComboBox1.itemIndex:6,' ',label95.caption);                       //-averaging method'
                  writeln(treeFile,AveragingTime:6,' ',label96.caption);                       //- averaging time'#13#10,
                       writeln(treeFile,FrameNbr:6,' ',label97.caption);                       //- number of frames'#13#10,
                      writeln(treeFile,FrameStep:6,' ',label99.caption);                       //- analysis step'#13#10,
                         writeln(treeFile,rate:6:0,' ',label98.caption);                       //- wave sampling frequency'#13#10,
                    writeln(treeFile,rareEventNbr1,' ',rareEventNbr2,' rareEventNbr1, rareEventNbr2');
          writeln(treeFile,radiogroup4.ItemIndex:6,' ', radiogroup4.caption);   //'distortion=mean|sum of distances
          writeln(treeFile,radiogroup9.ItemIndex:6,' ', radiogroup9.caption);   //' filter for Input signal'#13#10,
         writeln(treeFile,radiogroup10.ItemIndex:6,' ', radiogroup10.caption);  //' filter shape for the Input signal (FFT power spectrum domain)'#13#10,
         writeln(treeFile,radiogroup11.ItemIndex:6,' ', radiogroup11.caption);  //' weighting window shape (for WAW input signal)'#13#10,
         writeln(treeFile,radiogroup12.ItemIndex:6,' ', radiogroup12.caption);  //' Set dividing method (CART|Centroids)'#13#10,
         writeln(treeFile,radiogroup22.ItemIndex:6,' ', radiogroup22.caption);  //' kryteria wyboru zbioru do podziału'#13#10,
         writeln(treeFile,radiogroup23.ItemIndex:6,' ', radiogroup23.caption);  //' kryteria wyboru cechy w trybie CART wg wartości której był dzielony zbiór'#13#10,
         writeln(treeFile,radiogroup24.ItemIndex:6,' ', radiogroup24.caption);  //' kryteria wyboru zbioru do podziału, wrażenie , tryb supervised training'#13#10,
         writeln(treeFile,radiogroup25.ItemIndex:6,' ', radiogroup25.caption);  //' kryteria wyboru cechy w trybie CART, wrażenie , tryb supervised training'#13#10,
         writeln(treeFile,radiogroup26.ItemIndex:6,' ', radiogroup26.caption);  //' kryteria wyboru zbioru do podziału, unsupervise|supervised training (0 i 1 odpowiednio)'#13#10,
         writeln(treeFile,radiogroup27.ItemIndex:6,' ', radiogroup27.caption);  //' kryteria wyboru cechy w trybie CART, unsupervise|supervised training (0 i 1 odpowiednio)'#13#10,
       writeln(treeFile,byte(checkBox28.checked):6,' ', checkBox28.caption);    //' card(rarae_events_set) i.e. count of the elements of the rare events  (excluded from computations of distances and centroids), radiobutton indexes for the train signal handlings ');
       writeln(treeFile,byte(checkBox42.checked):6,' ', checkBox42.caption);          //' CART-like
     End;{with}
   writeln(treeFile,'Leaf nodes addresses:');                        //01.11.05
   for i:=0 to centroidsNb do write(treeFile,' ',leafNodes[i]);
   writeln(treeFile);
   writeln(treeFile,excludeSetCard,'  Exclude set:');                                   //01.11.05
   if excludeSetCard>0 then
   for i:=0 to (wholeEventNbr+1) div 8 do write(treeFile,' ',excludeSet[i]);//01.11.05, zbiór zdarzeń b. rzadkich
   writeln(treeFile);
                                                   //01.11.05
   writeln(treeFile,cath2Nbr,' ',cath1Nbr,' ',cath3Nbr,' ','Cathegory values numbers'); //21.02.06

   writeln(treeFile,'Cathegory hash tables:');
   writeln(treeFile,y2Name,' codes List');                                                        //21.02.06
   for i:=0 to cath2Nbr do write(treeFile,cath2CodeList[i],' '); writeln(treeFile);
   writeln(treeFile,y1Name,' codes list');                                                        //21.02.06
   for i:=0 to cath1Nbr do write(treeFile,cath1CodeList[i],' '); writeln(treeFile);
   writeln(treeFile,y3Name,' codes list');                                                        //21.02.06
   for i:=0 to cath3Nbr do write(treeFile,cath3CodeList[i],' '); writeln(treeFile);
   writeln(treeFile,'Classification variable names (3 pieces):');
   writeln(treeFile,y1Name);
   writeln(treeFile,y2Name);
   writeln(treeFile,y3Name);
   writeln(treeFile,'Quantization tree');                                                    //01.11.05
   for i:=0 to heapTop do
    with nodeHeap[i] do
    begin
     writeln(treeFile,i:5,' node nbr; next row: son, brother, leafIdx, ',y1Name,', ',y2Name,', ',y3Name,' OptComponentNbr, fission distance');  //,cath1,cath2,cath3, OptComponentNbr
     writeln(treeFile,' ',son,' ',brother,' ',nodeProps[i].leafIdx,' ',nodeProps[i].cath1,' ',nodeProps[i].cath2,' ',nodeProps[i].cath3,' ',nodeProps[i].OptComponentNbr,' ',nodeProps[i].fissionDistance);
     writeln(treeFile,'Centroid');
     for j:=0 to nc-1 do writeln(treeFile,' ',nodeProps[i].centroid[j]);
    end;{for}
    if form1.CheckBox24.checked then
    begin
     writeln(treeFile,'LeafNodeSets -----------------------------------------');
     for i:=0 to centroidsNb-1 do        //saveLeafNodeSets
      begin
       writeln(treeFile,'node nbr=',i);
       for j:=nodeProps[i].lb to nodeProps[i].hb do writeln(treeFile,sbl[j]);
      end;
    end;{if}
   CloseFile(treeFile);
   treeSaved:=true;
   form1.Label66.Caption:='Output tree saving finished!';
  End;{saveTree}

procedure treeToreport;//(s:shortString);
{
Zapis drzewa wynikowego do reportu
}
 var i,j:longword; s,s1:shortString;

 procedure underline;
  var i:longWord;
  begin
   for i:=1 to 66 do  write(reportFile,'=');
   if form1.CheckBox8.checked then for i:=1 to nc do if  (i in featureSet) then write(reportFile,'|===========');
   writeln(reportFile,'|');
  end;

 Begin    //--------------------------------------------treeToreport------------------
  if not form1.CheckBox26.Checked then exit;
  writeln(reportFile,#13#10'Table 4. Quantization tree.'#13#10,
                           '         Node parameter son<0 means, that the node is a leaf'#13#10,
                           '         and that the parameter''s value is its nr multiplied by -1. '{,s});
  underline;
  write(reportFile,'node| tree',' ':12,'|     mean  |','     fission    |','CART   | node ');
   s:='';
  if form1.CheckBox8.checked then s1:='|-centroids components' else s1:='';
  if form1.CheckBox8.checked then
   begin
   for i:=0 to nc-1 do if  (i in featureSet) then s:=s+'--------';
  delete(s,1,length('components'));
   end;
  insert(s1,s,1);
  s:=s+'| ';
  if form1.CheckBox7.checked then s:=s+'|-leaf set (events numbers)';
  writeln(reportFile,s);
  //                    5    6    6     6      11                16                12           6
  write(reportFile,' nbr|  son| broth|leaf|   distance|        distance|feature| count|');
  if form1.CheckBox8.checked then
   for j:=0 to nc-1 do  if  (j in featureSet) then  write(reportFile,j:11,'|');
  writeln(reportFile);
  underline;
  for i:=0 to heapTop do
   with nodeHeap[i] do
    begin
     write(reportFile,i:4,'|',son:5,'|',brother:5,'|',nodeProps[i].leafIdx:5,'| ');
     write(reportFile,nodeProps[i].MeanDistance:10:3,'| ',nodeProps[i].fissionDistance:15:3,'| ',nodeProps[i].OptComponentNbr:6,'| ',nodeProps[i].cardinal:5,'| ');
     if form1.CheckBox8.checked then                                                     //drukuj centroidy
     for j:=0 to nc-1 do  if  (j in featureSet) then  write(reportFile,nodeProps[i].centroid[j]:10:3,'| ');
     if form1.CheckBox7.checked then                                                     //drukuj zbiory liści
     if son=0 then    //było if son<0, zmieniono w związku z blokadą InspectLeafPicker 31.03.09 (numeracji liści przez instrukcję nodeHeap[startNodeIndex].son:=-leafNodeNbr)
     for j:=nodeProps[i].lb to nodeProps[i].hb do write(reportFile,sbl[j]:8,'| ');      //wydruk zbioru zablokowany 09.11.05 aby obniżyc wymiar indexSet
     writeln(reportFile);
    end;
  underline;
  flush(reportFile);
 End;{treeToreport}

 procedure excludeSetToreport;
  var i,j:longWord;
  Begin
   writeln(reportFile,#13#10'List of numbers of rare events which will not be taken into account at the second pass (contains ',excludeSetCard,' members)');
   j:=0;
   for i:=0 to wholeEventNbr-1 do
    Begin
     if inset(i,excludeSet) then
      begin
       if j mod 18=0 then writeln(reportFile);
       inc(j);
       write(reportFile,intToStr(i):6,#9);       //#9, aby liczby były rozróżnialne w excelu
      end;
    End;
   writeln(reportFile,#13#10);
   Flush(reportFile);
  End;{excludeSetToreport;}

  procedure featuresUsageHistToReport;
  var i,j,k:integer;  r:double; sum:longWord;
   Begin
    Writeln(reportFile);
    Writeln(reportFile,'----------------------CART mode -------------------------------------------------');
    Writeln(reportFile,'Table 4. Distribution of features usage in the CART mode');  Writeln(reportFile);
    k:=featureUseCounter[0];
    for i:=0 to nc do if k<featureUseCounter[i] then k:=featureUseCounter[i];   k:=k*5; if k<23 then k:=23;
    for i:=0 to k+27 do Write(reportFile,'=');Writeln(reportFile);
    Write(reportFile,'|feature|count|corr. coeff.| u s e d  i n  s t e p');
    for i:=22 to -2+k do Write(reportFile,'.');Writeln(reportFile,'|');
    for i:=0 to k+27 do Write(reportFile,'=');Writeln(reportFile);
    for i:=0 to nc do
     begin
      sum:=0;
      for j:=0 to featureUseCounter[i] do inc(sum,featureUseHist[i,j]);
      r:=(CentroidsNb_glob*featureUseCounter[i]-sum)/(CentroidsNb_glob*(CentroidsNb_glob-1));
      Write(reportFile,'|',i:7,'|',featureUseCounter[i]:5,'|',r:12:3,'|');
      for j:=1 to featureUseCounter[i] do  Write(reportFile,featureUseHist[i,j-1]:4,'|');Writeln(reportFile);   //-1, bo dla 0 0-1<0 wychodzi poza word
     end;
     for i:=0 to k+27 do Write(reportFile,'=');Writeln(reportFile);
   End;{featuresUsageHistToReport}

 procedure S0;
  var i,j,k:longWord; msd,idistance:extended; s:string; centroid0,centroid0double,vt:TmeanVector; m:word;
  Begin
   s:='Parameters of the first node of the quantization tree -';
   form1.statusbar1.SimpleText:=s+' obliczam centroid zerowy - sumowanie wszystkich wektorów zdarzeń (S0)'; application.ProcessMessages;
   k:=0;  j:=high(longWord);                       //------------zainicjować listy zakresów adresów zdarzeń z wyłączeniem zdarzeń rzadkich ("2" przebieg)
   for i:=0 to wholeEventNbr-1 do
    begin
     wbl[i]:=j; sbl[i]:=j;
     if not inset(i,excludeSet) then
      begin
       wbl[k]:=i; sbl[k]:=i;
       inc(k);
      end;
    end;
   trueEventNbr:=k; form1.Edit33.Text:=intToStr(k); form1.Edit14.Text:=intToStr(wholeEventNbr-k);
   for j:=0 to nc-1 do centroid0double[j]:=0;
   msd:=0; k:=0;
   for i:=0 to wholeEventNbr-1 do  if not (inSet(i,excludeSet)) then           //------------zsumować wszystkie wektory zdarzeń nie należące do zbioru wykluczeń
     begin
      inc(k);
      for j:=0 to nc-1 do centroid0double[j]:=centroid0double[j]+vectList[sbl[i],j];
     end;{if inset}
    if k>0 then                          //------------obliczyć wektor śreadni (centroid), śreadnią odległość od centrum i wariancję
     begin
      for j:=0 to nc-1 do centroid0[j]:=centroid0double[j]/k;
      for i:=0 to wholeEventNbr-1 do   if not (inSet(i,excludeSet)) then
       begin
        for m:=0 to nc-1 do vt[m]:=vectList[i,m];
        idistance:=dist(centroid0,vt);  //------------odległość od centr.
        msd:=msd+idistance;             //------------suma odległości wektorów od centrum
       end;{for}
      msd:=msd/k;                        //------------śreadnia odległość
     end{if k>0}
    else error5;                         //'Error 6'#13#10'The  event set is empty or all events belong to exclude set!, nothing to do, program will be halted.';
   form1.statusbar1.SimpleText:=s+' the node S0 properties are determined (procedure S0)'; application.ProcessMessages;
   with nodeHeap[0] do                   //------------określić parametry pierwszego węzła w drzewie
      begin
       son:=0;
       brother:=0;
       nodeProps[0].cardinal:=k;
       nodeProps[0].meanDistance:=msd;
       for m:=0 to nc-1 do nodeProps[0].centroid[m]:=round(centroid0[m]);
       nodeProps[0].lb:=0; nodeProps[0].hb:=trueEventNbr-1;
      end;
   form1.statusbar1.SimpleText:='Processing of the S0 finished';application.ProcessMessages;
  End;{S0}

function checkDistortion(const startNode:longWord):double;
 { CARTlike:
 oblicza zniekształcenia po rozszczepieniu danego liścia,
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newDistortion,dist1,dist2:double; i:longint;
  Begin
   with form1.radiogroup4 do
    begin
     i:=-nodeHeap[startNode].son;
     if ItemIndex=1 then    //distortion=sum of distances
      begin
       dist1:=nodeProps[i].cardinal*nodeProps[i].meanDistance;
       dist2:=nodeProps[nodeHeap[i].brother].cardinal*nodeProps[nodeHeap[i].brother].meanDistance;
       newDistortion:=nodeprops[startNode].cardinal*nodeprops[startNode].meanDistance-dist1-dist2;
      end
     else
      begin            //distortion=mean distance
       dist1:=nodeProps[i].meanDistance;
       dist2:=nodeProps[nodeHeap[i].brother].meanDistance;
       newDistortion:=nodeprops[startNode].meanDistance-dist1-dist2;
      end;
    end;{with radiogroup4}
   result:=newDistortion;
  End;{checkDistortion}

function checkcath1Error(const startNode:longWord):double;
 { CARTlike:
 oblicza błąd rozpoznania (w trybie autotestu) po rozszczepieniu danego liścia,   (cath1RecErr,cath2RecErr,cath3RecErr)
 poszukuje się liścia o największym spadku błędu po jego podziale (metodą centroidów)
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newRecErr,recErr1,recErr2:double;
  Begin
   with nodeprops[startNode] do
    begin
     recErr1:=nodeProps[-nodeHeap[startNode].son].cath1RecErr;
     recErr2:=nodeProps[nodeHeap[-nodeHeap[startNode].son].brother].cath1RecErr;
     newRecErr:=(cath1RecErr-(recErr1+recErr2));
     result:=newRecErr;
    end;{with}
  End;{checkcath1Error}

function checkcath2Error(const startNode:longWord):double;
 { CARTlike:
 oblicza błąd rozpoznania (w trybie autotestu)  po rozszczepieniu danego liścia,   (cath1RecErr,cath2RecErr,cath3RecErr)
 poszukuje się liścia o największym spadku błędu po jego podziale (metodą centroidów)
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newRecErr,recErr1,recErr2:double;
  Begin
   with nodeprops[startNode] do
    begin
     recErr1:=nodeProps[-nodeHeap[startNode].son].cath2RecErr;
     recErr2:=nodeProps[nodeHeap[-nodeHeap[startNode].son].brother].cath2RecErr;
     newRecErr:=cath2RecErr-(recErr1+recErr2);
     result:=newRecErr;
    end;{with}
  End;{checkcath2Error}

function checkcath3Error(const startNode:longWord):double;
 { CARTlike:
 oblicza błąd rozpoznania (w trybie autotestu)  po rozszczepieniu danego liścia,   (cath1RecErr,cath2RecErr,cath3RecErr)
 poszukuje się liścia o największym spadku błędu po jego podziale (metodą centroidów)
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newRecErr,recErr1,recErr2:double;
  Begin
   with nodeprops[startNode] do
    begin
     recErr1:=nodeProps[-nodeHeap[startNode].son].cath3RecErr;
     recErr2:=nodeProps[nodeHeap[-nodeHeap[startNode].son].brother].cath3RecErr;
     newRecErr:=cath3RecErr-(recErr1+recErr2);
     result:=newRecErr;
    end;{with}
  End;{checkcath3Error}

function checkcath1IR(const startNode:longWord):double;
 { CARTlike:
 oblicza zniekształcenia  po rozszczepieniu danego liścia,
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newIR,IR1,IR2:double;
  Begin
   with nodeprops[startNode] do
    begin
     IR1:=nodeProps[-nodeHeap[startNode].son].cath1Ir;
     IR2:=nodeProps[nodeHeap[-nodeHeap[startNode].son].brother].cath1Ir;
     newIR:=-cath1Ir+IR1+IR2; //
     result:=newIR;
    end;{with}
  End;{checkcath1IR}

function checkcath2IR(const startNode:longWord):double;
 { CARTlike:
 oblicza zniekształcenia  po rozszczepieniu danego liścia,
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newIR,IR1,IR2:double;
  Begin
   with nodeprops[startNode] do
    begin
     IR1:=nodeProps[-nodeHeap[startNode].son].cath2Ir;
     IR2:=nodeProps[nodeHeap[-nodeHeap[startNode].son].brother].cath2Ir;
     newIR:=-cath2Ir+IR1+IR2;
     result:=newIR;
    end;{with}
  End;{checkcath2IR}

function checkcath3IR(const startNode:longWord):double;
 { CARTlike:
 oblicza zniekształcenia  po rozszczepieniu danego liścia,
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newIR,IR1,IR2:double;
  Begin
   with nodeprops[startNode] do
    begin
     IR1:=nodeProps[-nodeHeap[startNode].son].cath3Ir;
     IR2:=nodeProps[nodeHeap[-nodeHeap[startNode].son].brother].cath3Ir;
     newIR:=-cath3Ir+IR1+IR2;
     result:=newIR;
    end;{with}
  End;{checkcath3IR}

  procedure perceptionsDiscrimination(const cath11,cath12,pers1,pers2,cath31,cath32:byte);
  {
  Obliczaj parametry cząstkowe, dla poszczególnych wartości wrażeń, wywoływać PO określeniu każdego rozbicia (obojętnie jaką metodą)
  oblicza IR dla rozkładów poszczególnych percepcji w liściach grupowanych według percepcji dominującej
  wywoływać po każdym etapie kontrukcji drzewa (TreeConstructor)
  cath11,cath12,pers1,pers2,cath31,cath32 - wartości 3 wrażeń dominujące w nowo utworzonych liściach: następniku i jego alternatywie
  }

   procedure treat(const perc0,perc:byte; const IRarray:TdbArr;const ErrArr:TlwArr; const ClusterCount:TWordArr;IR:double;err:longWord; const CountArr:TlwArr; card:longWord);
   { Fenomen! działa na stałych!
   sumator,
   perc0, perc - liczbowy id (numer) wartości wrażenia z powstałego ostatnio liścia (perc0) i z widzianego aktualnie liścia (perc)
   }
   Begin
    if (perc0=perc)  then
     begin
      IRarray[perc]:=IRarray[perc]+IR;
      ErrArr[perc]:=ErrArr[perc]+err;
      CountArr[perc]:=CountArr[perc]+card;
      inc(ClusterCount[perc])
     end;
   End;

  procedure LeafInspectTree(startNodeIndex:longWord);
  {
   biegnij po drzewie w poszukiwaniu liścia, gdy go znajdziesz, to zobacz, czy dominujące w nim wrażenie (1-no z 3)
   jest takie samo, jak w ostatnio utworzonym. Jeśli tak, to liść ten należy do tej samej grupy ze względu na wartość tego wrażenia, więc dodajemy jego IR (treat)
   działa w procedurze PerceptionsDiscrimination
   cath11,cath12,pers1,pers2,cath31,cath32 - wartości 3 wrażeń dominujące w nowo utworzonych liściach: następniku i jego alternatywie, czyli np. cath1=argMax(cath1Hist)
  }
   Begin

    if nodeHeap[startNodeIndex].son>0 then  LeafInspectTree(nodeHeap[startNodeIndex].son)
    else
    with nodeProps[startNodeIndex], form1 do
     Begin
      if checkBox2.Checked then
       begin
        treat(cath1,cath11,cath1IRarray,phErr,cath1ClusterCount,cath1Ir,cath1RecErr,cath1CountArray,cardinal);      //1. potomek
        if cath12<>cath11 then
        treat(cath1,cath12,cath1IRarray,phErr,cath1ClusterCount,cath1Ir,cath1RecErr,cath1CountArray,cardinal);     //brat
       end;
      if checkBox3.Checked then
       begin
        treat(cath2,pers1,cath2IRarray,persErr,cath2ClusterCount,cath2Ir,cath2RecErr,cath2CountArray,cardinal);
        if pers2<>pers1 then
        treat(cath2,pers2,cath2IRarray,persErr,cath2ClusterCount,cath2Ir,cath2RecErr,cath2CountArray,cardinal);
       end;
      if checkBox4.Checked then
       begin
        treat(cath3,cath31,cath3IRarray,cath3Err,cath3ClusterCount,cath3Ir,cath3RecErr,cath3CountArray,cardinal);
        if cath32<>cath31 then
        treat(cath3,cath32,cath3IRarray,cath3Err,cath3ClusterCount,cath3Ir,cath3RecErr,cath3CountArray,cardinal);
       end;
     End;{WITH}
    if nodeHeap[startNodeIndex].brother>0 then LeafInspectTree(nodeHeap[startNodeIndex].brother)
   End;{LeafInspectTree}

  Begin  //----------------------------perceptionsDiscrimination-------------------------
   with form1 do
    begin
     if checkBox2.Checked then
      begin
       cath1IRarray[cath11]:=0; cath1ClusterCount[cath11]:=0;      phErr[cath11]:=0; cath1CountArray[cath11]:=0;         //zerujemy tylko te pozycje tabel, w których dominują wrażenia w nowo dodanych węzłach
       cath1IRarray[cath12]:=0; cath1ClusterCount[cath12]:=0;      phErr[cath12]:=0; cath1CountArray[cath12]:=0;        //będą one ponownie obliczone w trakcie przeglądu wszystkich liści łącznie z nowo dodanymi.
      end;
     if checkBox3.Checked then
      begin
       cath2IRarray[pers1]:=0; cath2ClusterCount[pers1]:=0;  persErr[pers1]:=0; cath2CountArray[pers1]:=0;
       cath2IRarray[pers2]:=0; cath2ClusterCount[pers2]:=0;  persErr[pers2]:=0; cath2CountArray[pers2]:=0;
      end;
     if checkBox4.Checked then
      begin
       cath3IRarray[cath31]:=0; cath3ClusterCount[cath31]:=0; cath3Err[cath31]:=0; cath3CountArray[cath31]:=0;
       cath3IRarray[cath32]:=0; cath3ClusterCount[cath32]:=0; cath3Err[cath32]:=0; cath3CountArray[cath32]:=0;
      end;
    end;{with}
   LeafInspectTree(0);
  End;{perceptionsDiscrimination}

 procedure inspectTreeSettings(radio:TradioGroup);   //radio=radio24
  Begin
   case form1.radiogroup12.itemIndex of               // CART|centroids
    0: inspectTree:=FeaturesInspectTree;              // CART
    1: begin
        if form1.checkBox42.Checked then inspectTree:=CARTlike                     // CART-like
        else
        case  form1.radiogroup22.ItemIndex of          // Centroids
         0: inspectTree:=DistancesInspectTree;         // cohrence
         1: case  radio.ItemIndex of                   // error----------------------
             0: inspectTree:=cath1ErrorInspectTree;    // cath1
             1: inspectTree:=cath2ErrorInspectTree;    // cath2
             2: inspectTree:=cath3ErrorInspectTree; // cath3
            end;{case radiogroup24}
         2:  case  radio.ItemIndex of                  // IR-------------------------
              0: inspectTree:=cath1IRInspectTree;      // cath1
              1: inspectTree:=cath2IRInspectTree;    // cath2
              2: inspectTree:=cath3IRInspectTree;   // cath3
             end;{case radiogroup24}
        end;{case radiogroup22}
       end;{case radio12=1}
     else error35(delAmpers('Program error, in the procedure RUN, "'+form1.radiogroup12.caption+'". No method identified as nr '+intToStr(form1.radiogroup12.itemIndex)+
                     ' exists!'#13#10'Check "'+ form1.mainMenu1.Items[2].Caption+'\'+form1.pagecontrol1.Pages[3].Caption+'".'#13#10'Turn to the author...'));
   end;{case radiogroup12}
  End;{inspectTreeSettings}


 {++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

 procedure RUN(const centroidsNb:word; const performance:string);//;ext:char); blok 12.03.09

 var
  s : shortString;

 procedure error13(const eventNbr:longWord);
  var s : string;
  begin
   with form1 do if (checkBox42.Checked) and (RadioGroup22.ItemIndex=1) then
    s:='Error 13.'#13#10'Nie znaleziono już ani jednego liścia, którego dzielenie dałoby spadek błędu rozpoznania.'
   else s:='Error 13.'#13#10'Nie znaleziono już ani jednego liścia ze zbiorem o śreadniej odległości Euklidesa pomiędzy wektorami zdarzeń >0.';
   s:=s+#13#10'Proces doszedł do '+intTostr(step)+' poziomu.'#13#10'Graf ma '+intToStr(nodeNbr+1);
   if (nodeNbr+1) mod 10 in [2,3,4] then s:=s+' węzły.'
   else s:=s+' węzłów.';
    if centroidsNb>=eventNbr then
    s:=s+#13#10'Liczba żądanych podziałów (='+intToStr(centroidsNb)+
    ') dorównuje lub przewyższa liczbę klasyfikowanych zdarzeń (='+intToStr(eventNbr)+')';
    s:=s+#13#10+#13#10'No more dividing action possible due to chosen restrictions or because all sets contain identical or only 1 member each.'+
    #13#10'End of the error 13 description.';
   showMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
  end;{error13}

 procedure error14;
  var s : string;
  begin
   s:='Error 14.'#13#10'The end of the dividing possibilities was reached.'#13#10'The proces has achieved '+intTostr(step)+
   ' level.'+#13#10'End of the error 14 description.';
  ShowMessage(s);
  writeln(reportFile,s);
  flush(reportFile);
 end;

 procedure error15;
  var s : string;
  begin
   s:='Error 15.'#13#10'A programm error or the number of class is too big; step='+intTostr(step)+' <> leafNodeNbr='+
   intTostr(leafNodeNbr)+#13#10'End of the error 15 description.';
   showMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
  end;

procedure error16;
  var s : string;
  begin
   s:='Error 16.'#13#10'The event (features vectors) set is empty.'#13#10+
   'Prawdopodobnie na etapie określania zdarzeń rzadkich doszło do kompletnego rozbicia na zbiory 1-no elementowe, lub o elementach identycznych.'#13#10+
   'Należy obniżyć liczbę centroidów i powtórzyć obliczenia'+#13#10'End of the error 16 description.';
   showMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
  end;
 procedure error28;
  var s : string;
  begin
   s:='Error 28.'#13#10'step<>leafNodeNbr-1; nie zgadza się bilans liści i kroków iteracyjnych; step='+
   intToStr(step)+', a leafNodeNbr-1='+intToStr(leafNodeNbr-1)+#13#10'End of the error 28 description.';
   showMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
 End; {error28}

 procedure AnalysisSettingsToreport;
 //zapisuje opcje analizy do reportu
 var sp,sdot:shortString;
  Begin
   if spk_txt then with form1.RadioGroup2 do s:=Items[itemIndex]  //0: s:='power spectrum'; 1: s:='cepstrally smoothed spectrum'; 2: s:='mel cepstrally smoothed spectrum';  3: s:='power cepstrum';  4: s:='mel cepstrum (invers FFT of mel cepstrally smoothed spectrum)';
   else s:='One stream data from the text file';
   writeln(reportFile,#13#10,
   'Processed feature:               = ',s,#13#10,
   'Number of consideread components = ',nc,' (counting nr 0 component)'#13#10,
   'Isolation treeshold              < ',rareEventNbr1,#13#10,
   'Elimination treshold             <=',rareEventNbr2);
   with form1 do s:='Features accordingly to the"'+label109.Caption+'" and "'+label110.Caption+'" edit windows contents';
   with form1 do
   begin
   writeln(reportFile,s,'; '#13#10,GroupBox9.Caption,', ',label111.Caption,': [',Label112.Caption,']');
   sp:=' - ';
   sdot:=' .....................................................................................................';
   writeln(reportFile,delAmpers(mainMenu1.Items[2].Caption+'\'+form1.PageControl1.Pages[3].Caption),':');
   s:=sdot; s:=radiogroup12.Caption; setLength(s,35);
   if RadioGroup12.itemIndex>=0 then s:=s+sp+RadioGroup12.Items[RadioGroup12.itemIndex]
   else s:=s+sp+'not determined';               //CART|centroid
   if (RadioGroup12.itemIndex=1) and checkBox42.Checked  then s:=s+', '+checkBox42.Caption;//CART-like
   writeln(reportFile,s);
   s:=sdot; s:=radiogroup22.Caption; setLength(s,35);
   if RadioGroup22.itemIndex>=0 then s:=s+sp+RadioGroup22.Items[RadioGroup22.itemIndex]
   else s:=s+sp+'not determined';               //CART|centroid
   writeln(reportFile,s);
   s:=sdot; s:=radiogroup24.Caption; setLength(s,35);
   if RadioGroup24.itemIndex>=0 then s:=s+sp+RadioGroup24.Items[RadioGroup24.itemIndex]
   else s:=s+sp+'not determined';               //CART|centroid
   writeln(reportFile,s);
   s:=sdot; s:=radiogroup26.Caption; setLength(s,35);
   if RadioGroup26.itemIndex>=0 then s:=s+sp+RadioGroup26.Items[RadioGroup26.itemIndex]
   else s:=s+sp+'not determined';               //CART|centroid
   writeln(reportFile,s);
   s:=sdot; s:=radiogroup23.Caption; setLength(s,35);
   if RadioGroup23.itemIndex>=0 then s:=s+sp+RadioGroup23.Items[RadioGroup23.itemIndex]
   else s:=s+sp+'not determined';               //CART|centroid
   writeln(reportFile,s);
   s:=sdot; s:=radiogroup25.Caption; setLength(s,35);
   if RadioGroup25.itemIndex>=0 then s:=s+sp+RadioGroup25.Items[RadioGroup25.itemIndex]
   else s:=s+sp+'not determined';               //CART|centroid
   writeln(reportFile,s);
   s:=sdot; s:=radiogroup27.Caption; setLength(s,35);
   if RadioGroup27.itemIndex>=0 then s:=s+sp+RadioGroup27.Items[RadioGroup27.itemIndex]
   else s:=s+sp+'not determined';               //CART|centroid
   writeln(reportFile,s);
   end;{with}
   if form1.CheckBox19.Checked then
     s:='- Degressive isolation treshold'+#13#10
   else s:='- Constant isolation treeshold='+intToStr(rareEventNbr1)+#13#10;
   writeln(reportFile,'Set counts constrain method........ ',s);
   if form1.RadioGroup12.ItemIndex=1 then
   writeln(reportFile,'Standard deviation multipier (for initial centroids computations) ...',multStdDev:5:2);
   if form1.CheckBox31.Checked then
   writeln(reportFile,'Input signal averaging parameters:'#13#10,
   byte(Form1.CheckBox30.checked):6,' - averaging: if=1, then was turned On, if = 0, then was turned  Off '#13#10,
        form1.ComboBox1.itemIndex:6,' - averaging method'#13#10,
                    AveragingTime:6,' - averaging time'#13#10,
                         FrameNbr:6,' - number of frames'#13#10,
                      FrameStep:6:0,' - analysis step'#13#10,
                           rate:6:0,' - wave sampling frequency'#13#10)
   else writeln(reportFile,'No averaging of the input signal was applied.');
  End;{AnalysisSettingsToreport}

 procedure lookForBestSet;
 {
 wybiera kolejny zbiór do podziału
 }

  Begin  //---------------lookForBestSet
   distMaxNodeAddr:=0;
   repeat                                                             //repeat jest potrzebny, bo tutaj następuje aktualizacja progu ograniczenia liczebności i ponowienie InspectTree
    bestFeature:=nc-1;
    form1.StatusBar1.SimpleText:=form1.StatusBar1.SimpleText+' śreadniej odległości Euklidesa elementów od centrum (DistancesInspectTree)'; application.ProcessMessages;
    InspectTree(0);                                                 //znajdź zbiór o największej śreadniej odległości jego elementów od jego centroidu
    if form1.CheckBox19.Checked then    //degres                      //RUN: if form1.radiogroup12.itemIndex=2 then inspectTree:=DistancesInspectTree else inspectTree:=CARTlike;
    if not nodeFound then  rareEventNbr1:=rareEventNbr1 div 2;        //degresja dolnego ograniczenia liczebności
    form1.label63.Caption:=intToStr(rareEventNbr1);
   until nodeFound or (rareEventNbr1=1) or not form1.CheckBox19.Checked         // ?? czy ...or not form1.CheckBox19.Checked nie powinno warunkować wywołanie repeat?
  End;{lookForBestSet}


  procedure leavesParametersSave(const EventNbr:longWord);
   Begin
    begin
     form1.statusbar1.SimpleText:='I am making histograms';     //
     FinalIRToreport(performance,EventNbr,step);
    end;
   End;{leavesParametersSave}

   procedure initialSettings;

    Begin  //------------------initialSettings
     form1.GroupBox3.Enabled:=false;
     treeSaved:=false;
     fissionCounter:=0;
     with form1 do
     if checkBox19.Checked then                                      //obsługa trybu "deggressive isolation set count"
      begin
       rareEventNbr1:=trueEventNbr div 2;
       edit7.Text:=xxx;
      end;
     case form1.RadioGroup17.ItemIndex of
      0 : begin
           RowsToReportTableCaption:=RowsToReportTableCaptionTXT;
           H0ToReport:=H0ToReportTXT
          end;
      1 : begin
           RowsToReportTableCaption:=RowsToReportTableCaptionEXCEL;
           H0ToReport:=H0ToReportExcel
          end;
     end;{case}
     TIC:=TakeInitialCentroidsSTD;
    End;{initialSettings}

  procedure nodeHistCreate;
  //alokuje pomocnicze zmienne NodeHist_glob,TempHist1, TempHist2 służące jako histogramy,
  //korzysta z odczytanej z pliku danych liczebności zbiorów kategorii, wybiera największą z nich
   var i:byte;
   Begin
    i:=cath1Nbr;
    if i<cath2Nbr then i:=cath2Nbr;
    if i<cath3Nbr then i:=cath3Nbr;
    inc(i);
    if (high(NodeHist_glob)+1)<>i then ToReportRAMinfoCaption;
    if ToReportRAMinfo('NodeHist_glob',high(NodeHist_glob),sizeOf(THist),(i))
    then setLength(NodeHist_glob,i);
    try
     for i:=0 to high(NodeHist_glob) do  NodeHist_glob[i]:=high(NodeHist_glob[1]);
    except
     error35('Error in the procedure nodeHistCreate for some reason the "NodeHist_glob" variable could not be filled'+
       #13#10'probably because of its wrong size (empty). The size actually is='+intToStr(high(NodeHist_glob)));
    end;
    if form1.radiogroup12.ItemIndex=0 then
     begin
      if ToReportRAMinfo('TempHist1',high(TempHist1),sizeOf(THist),(high(NodeHist_glob)+1))
      then setLength(TempHist1,high(NodeHist_glob)+1);
      if ToReportRAMinfo('TempHist2',high(TempHist2),sizeOf(THist),(high(NodeHist_glob)+1))
      then setLength(TempHist2,high(NodeHist_glob)+1);
     end;
   End;

  var i : word;
      treeFileDirTemp:string;
  BEGIN  //--------------------RUN--------------------------
   InitialSettings;  totalIterNbr:=0;  exclude(insertSet,0);
   with form1 do if edit19.Text <>'' then label133.Caption:=edit19.Text else label133.Caption:='No!';
   curvesColors;
   writeln(reportFile,performance);
   AnalysisSettingsToreport;
   form1.Memo1.Lines.Add(performance); form1.Label52.caption:=intToStr(centroidsNb-1);
   NodeNbr:=0; HeapTop:=0; step:=0;
   with form1 do if checkBox9.checked then if nodeProps[0].cardinal=0 then begin error16; exit end;
   with nodeProps[0] do distortion:=cardinal*meanDistance;
   InspectTreeSettings(form1.RadioGroup24);
   nodeHistCreate;
   RowsToReportTableCaption;                                                                         //28.09.05
   with form1 do
    begin
     radiogroup17.Enabled:=false; radiogroup18.Enabled:=false;
     if checkBox2.Checked then
     for i:=0 to cath1Nbr do begin cath1IRarray[i]:=0; cath1ClusterCount[i]:=0; phErr[i]:=0; cath1CountArray[i]:=0; end;
     if checkBox3.Checked then
     for i:=0 to cath2Nbr do begin cath2IRarray[i]:=0; cath2ClusterCount[i]:=0; persErr[i]:=0;cath2CountArray[i]:=0; end;
     if checkBox4.Checked then
     for i:=0 to cath3Nbr do begin cath3IRarray[i]:=0; cath3ClusterCount[i]:=0; cath3Err[i]:=0; cath3CountArray[i]:=0; end;
     prevX:=form1.panel3.left;   nodePrevX:=prevX;  step:=1;
     if RadioGroup12.ItemIndex=0 then emptySet(leafNodeSet);
    end;{with}
   while not (step>=centroidsNb) do
   Begin
    cath1IrGlob:=0; cath2IrGlob:=0; cath3IrGlob:=0;
    cath1RecErrSum:=0; cath2RecErrSum:=0; cath3RecErrSum:=0; //sumy błędów rozpoznania
    tryDelta:=-1.7e308;
    form1.label15.Caption:=intToStr(step);
    nodeFound:=false;             // centroids       Set choice=IR
    distMax:=-1e+324;  application.ProcessMessages;
    form1.StatusBar1.SimpleText:='step='+intToStr(step)+'Run, szukanie liścia ze zbiorem o największej';
{!}    lookForBestSet;
     if not nodeFound then
     begin
      error13(trueEventNbr);
      break
     end;                                                                //brak zbiorów o zróżnicowanych elementach
    form1.label135.caption:=intToStr(distMaxNodeAddr);
    form1.label47.Caption:=intToStr(nodeProps[distMaxNodeAddr].cardinal);                     //pokaż liczebność dzielonego zbioru    (pod spodem)
    form1.label48.Caption:=floatToStrF(nodeProps[distMaxNodeAddr].meanDistance,ffFixed,13,1); //pokaż odległości w dzielonym zbiorze (pod spodem)
    application.ProcessMessages;
    with form1 do if checkBox9.checked then if nodeProps[distMaxNodeAddr].cardinal<2 then begin error14;dec(step); break end;   //koniec możliwości podziałów
     //-------------------------------------------------------------------------------------------------pierwsze centroidy
    with form1 do
     if (radiogroup12.itemIndex=0) then
     else if not checkBox42.Checked then LookForInitialCentroids(distMaxNodeAddr);             //check42 - CART-like; wyszukać prototypy centroidów (w trybie cohrence) warunek 24.04.10
    application.ProcessMessages;
    form1.StatusBar1.SimpleText:='Run, step='+intToStr(step)+' The best division of the chosen set (FindBestDivision)'; application.ProcessMessages;
{!!}if form1.radioGroup12.ItemIndex=0 then
     begin
      form1.Label128.Caption:=xxx;
      featureUseHist[globComponentNbr, featureUseCounter[globComponentNbr]]:=step;
      inc(featureUseCounter[globComponentNbr]);
     end
    else  if not form1.checkBox42.Checked then // 17.04.10
     FindBestDivision(distMaxNodeAddr,v1,v2,nodeProps[distMaxNodeAddr].lb,nodeProps[distMaxNodeAddr].hb,
    meanDistance1,meanDistance2,iterNbr,hb1glob,lb2glob,k1,k2,step);
    inc(nodeNbr,2);
    form1.StatusBar1.SimpleText:='Run, step='+intToStr(step)+' Konstruktor drzewa'; application.ProcessMessages;
    application.ProcessMessages;
    if (form1.checkBox42.Checked) or (form1.RadioGroup12.ItemIndex=0) then CARTtreeConstructor(distMaxNodeAddr)//jeśli jest tryb CARTlike, to uproszczony konstruktor
    else treeConstructor(distMaxNodeAddr,heapTop,hb1glob,lb2glob,v1,v2,meanDistance1,meanDistance2,iterNbr,k1,k2,false,0);
    leafNodeNbr:=0;  prevDist:=distortion; distortion:=0;                            //licznik liści, distortion                    28.09.05, 19.12.06
    leafSummer(0);
    If form1.RadioGroup18.ItemIndex=1 then        //obliczaj parametry cząstkowe, dla poszczególnych wartości wrażeń
     perceptionsDiscrimination(nodeProps[heapTop-1].cath1,nodeProps[heapTop].cath1,nodeProps[heapTop-1].cath2,
      nodeProps[heapTop].cath2,nodeProps[heapTop-1].cath3,nodeProps[heapTop].cath3);
    with nodeprops[distMaxNodeAddr] do RowsToReport(step,trueEventNbr,distMaxNodeAddr);//,nodeProps[heapTop-1].cath1,nodeProps[heapTop].cath1,nodeProps[heapTop-1].cath2,
    form1.label91.Caption:=floatToStrF(distortion/trueEventNbr,ffFixed,10,3);
    form1.label92.Caption:=floatToStrF((distortion-prevDist)/trueEventNbr,ffFixed,10,3);
    application.ProcessMessages;
    if form1.CheckBox18.Checked then  //save tree after every steo
     begin
      treeFileDirTemp:=treeFileDir;
      saveTree(step+1, nc,treeFileDir);//,ext);    blok 12.03.09
      treeFileDir:=treeFileDirTemp;
     end;
    if step<>leafNodeNbr-1 then error28;
    if form1.checkBox29.Checked then       //zapisz parametry liści aktualnego drzewa
     if step in insertSet then //breakingLeafSave
      begin
       writeln(reportFile,'--------------------------------------------------------------------------------------------------'#13#10,
        'Table 1 will be continued!!');
       writeln(reportFile,'--------------------------------------------------------------------------------------------------'#13#10);
       leavesParametersSave(trueEventNbr);
       writeln(reportFile,'--------------------------------------------------------------------------------------------------'#13#10,
        'Now table 1 is continued');
       writeln(reportFile,'--------------------------------------------------------------------------------------------------'#13#10);
      end;
    inc(step);
    if interrupt then
     begin
      interrupt:=false;
      writeln(reportFile, 'Interrupted at the current step on user request'); flush(reportFile);
       BREAK
     end;                                                       //poziom drzewa kwantującego
   End{while};                    //każde wejście do konstruktora oznacza dodanie jednego liścia
   writeln(reportFile,'--------------------------------------------------------------------------------------------------'#13#10,
    #13#10'NOTE, Centroids_number=step+1');//podkreślenie tabeli wyników z pętli
   leavesParametersSave(trueEventNbr);
   if leafNodeNbr<>step then if nodeFound then error15;
   with form1 do begin radiogroup17.Enabled:=true; radiogroup18.Enabled:=true; GroupBox3.Enabled:=true end;
  END;{run}


procedure RAMresources(const centroidsNb:word);

Begin
   ToReportRamInfoCaption;
   form1.statusbar1.SimpleText:='Dynamiccaly RAM assigning  (RAMresources)'; application.ProcessMessages;
   try
   if ToReportRAMinfo('leafNodes',high(leafNodes),sizeOf(TlwArr),(CentroidsNb+1))
   then setLength(leafNodes,CentroidsNb+1);
   except
   error47('IR leaves histograms, procedure "RAMresources"');
   end;

   //if not form1.checkBox1.checked then  //--------------------------żadnych klasyfikacji, tylko samo kwantowanie   zablokowano 15.10.08
   with form1 do
    begin
     try
      if checkBox2.Checked then
       begin
        if ToReportRAMinfo('cath1H0',high(cath1H0),sizeOf(Thist),(cath1Nbr+1))
        then setLength(cath1H0,cath1Nbr+1);                                                         //dane Corpory są ustalane do-
        if ToReportRAMinfo('cath1Pb',high(cath1Pb),sizeOf(TdbArr),(cath1Nbr+1))
        then setLength(cath1Pb,cath1Nbr+1);
        if ToReportRAMinfo('cath1NodeHist',high(cath1NodeHist),sizeOf(Thist),(cath1Nbr+1))
        then setLength(cath1NodeHist,cath1Nbr+1);             //centroidsNb+1,cath1Nbr+1);
       end
      else
       begin
        if ToReportRAMinfo('cath1H0',high(cath1H0),sizeOf(Thist),(0))
        then setLength(cath1H0,0);                                                     //dane Corpory są ustalane do-
        if ToReportRAMinfo('cath1Pb',high(cath1Pb),sizeOf(TdbArr),(0))
        then setLength(cath1Pb,0);
        if ToReportRAMinfo('cath1NodeHist',high(cath1NodeHist),sizeOf(Thist),(0))
        then setLength(cath1NodeHist,0);            //centroidsNb+1,cath1Nbr+1);
       end;{check1}
      if checkBox3.Checked then
       begin
        if ToReportRAMinfo('cath2H0',high(cath2H0),sizeOf(Thist),(cath2Nbr+1))
        then setLength(cath2H0,cath2Nbr+1);
        if ToReportRAMinfo('cath2Pb',high(cath2Pb),sizeOf(TdbArr),(cath2Nbr+1))
        then setLength(cath2Pb,cath2Nbr+1);                                                //piero w cath1ListRead(cath1Nbr);
        if ToReportRAMinfo('cath2NodeHist',high(cath2NodeHist),sizeOf(Thist),(cath2Nbr+1))
        then setLength(cath2NodeHist,cath2Nbr+1);        //centroidsNb+1,cath2Nbr+1);
       end
      else
      begin
       if ToReportRAMinfo('cath2H0',high(cath2H0),sizeOf(Thist),(0))
       then setLength(cath2H0,0);
       if ToReportRAMinfo('cath2Pb',high(cath2Pb),sizeOf(TdbArr),(0))
       then setLength(cath2Pb,0);
       if ToReportRAMinfo('cath2NodeHist',high(cath2NodeHist),sizeOf(Thist),(0))
       then setLength(cath2NodeHist,0);              //centroidsNb+1,cath2Nbr+1);
      end;{check3}
      if checkBox4.Checked then
       begin
        if ToReportRAMinfo('cath3H0',high(cath3H0),sizeOf(Thist),(cath3Nbr+1))
        then setLength(cath3H0,cath3Nbr+1);
        if ToReportRAMinfo('cath3Pb',high(cath3Pb),sizeOf(TdbArr),(cath3Nbr+1))
        then setLength(cath3Pb,cath3Nbr+1);
        if ToReportRAMinfo('cath3NodeHist',high(cath3NodeHist),sizeOf(Thist),(cath3Nbr+1))
        then setLength(cath3NodeHist,cath3Nbr+1);    //centroidsNb+1,cath3Nbr+1);
       end
      else
      begin
       if ToReportRAMinfo('cath3H0',high(cath3H0),sizeOf(Thist),(0))
       then setLength(cath3H0,0);
       if ToReportRAMinfo('cath3Pb',high(cath3Pb),sizeOf(TdbArr),(0))
       then setLength(cath3Pb,0);
       if ToReportRAMinfo('cath3NodeHist',high(cath3NodeHist),sizeOf(Thist),(0))
       then setLength(cath3NodeHist,0);             //centroidsNb+1,cath3Nbr+1);//centroidsNb+1,cath3Nbr+1);
      end;{check4}
     except
     error47('answers'' histograms, procedure "RAMresources"');
     end;
    end; {not check1}
   nodeHeapTop:=2*CentroidsNb+1;
   form1.Edit16.Text:=intToStr(nodeHeapTop); form1.Edit1.Enabled:=false;form1.Edit2.Enabled:=false;
   try
   if ToReportRAMinfo('nodeHeap',high(nodeHeap),sizeOf(Tnode),(nodeHeapTop))
   then setLength(nodeHeap,nodeHeapTop);           //centroidsNb+1,cath3Nbr+1);
   except
   error47('the output tree nodes, procedure "RAMresources"');
   end;
   try
   if ToReportRAMinfo('excludeSet',high(excludeSet),sizeOf(TArrSet),((wholeEventNbr+1) div 8+1))
   then setLength(excludeSet,(wholeEventNbr+1) div 8+1);
   except
   error47('exclude set, procedure "RAMresources"');
   end;
   try
   if ToReportRAMinfo('nodeProps',high(nodeProps),sizeOf(TnodeProps),(nodeHeapTop))
   then setLength(nodeProps,nodeHeapTop);
   if form1.RadioGroup12.ItemIndex=0 then
    begin
     if ToReportRAMinfo('featureUseHist',high(featureUseHist),sizeOf(Word),((nc+1)*(CentroidsNb_glob+1)))
     then setLength(featureUseHist,nc+1, CentroidsNb_glob+1);
     if ToReportRAMinfo('featureUseCounter',high(featureUseCounter),sizeOf(TWordArr),(nc+1))
     then setLength(featureUseCounter,nc+1);
     if ToReportRAMinfo('leafNodeSet',high(leafNodeSet),sizeOf(TArrSet),(centroidsNb div 4))
     then setLength(leafNodeSet,centroidsNb div 4);
    end;
   if ToReportRAMinfo('sz',high(sz),sizeOf(double),nc)
   then setLength(sz,nc);
   if ToReportRAMinfo('sk',high(sk),sizeOf(double),nc)
   then setLength(sk,nc);
   if ToReportRAMinfo('stdev',high(stdev),sizeOf(double),nc)
   then setLength(stdev,nc);
   with form1 do
   if not CheckBox1.Checked then
    begin
     if CheckBox2.Checked then
      begin
       if ToReportRAMinfo('cath1IRarray',high(cath1IRarray),sizeOf(double),(cath1Nbr+1))
       then setLength(cath1IRarray,cath1Nbr+1); setLength(cath1ClusterCount,cath1Nbr+1);
       if ToReportRAMinfo('cath1ClusterCount1',high(cath1ClusterCount1),sizeOf(word),(cath1Nbr+1))
       then setLength(cath1ClusterCount1,cath1Nbr+1);
       if ToReportRAMinfo('phErr',high(phErr),sizeOf(longword),(cath1Nbr+1))
       then setLength(phErr,cath1Nbr+1);
       if ToReportRAMinfo('cath1CountArray',high(cath1CountArray),sizeOf(longword),(cath1Nbr+1))
       then setLength(cath1CountArray,cath1Nbr+1);
      end
     else
       begin
        if ToReportRAMinfo('(cath1IRarray',high(cath1IRarray),sizeOf(double),(0))
        then setLength(cath1IRarray,0);
        if ToReportRAMinfo('cath1ClusterCount',high(cath1ClusterCount),sizeOf(word),(0))
        then setLength(cath1ClusterCount,0);
        if ToReportRAMinfo('cath1ClusterCount1',high(cath1ClusterCount1),sizeOf(word),(0))
        then setLength(cath1ClusterCount1,0);
        if ToReportRAMinfo('phErr',high(phErr),sizeOf(longword),(0))
        then setLength(phErr,0);
        if ToReportRAMinfo('cath1CountArray',high(cath1CountArray),sizeOf(longword),(0))
        then setLength(cath1CountArray,0)
       end;
     if CheckBox3.Checked then
      begin
       if ToReportRAMinfo('cath2IRarray',high(cath2IRarray),sizeOf(double),(cath2Nbr+1))
       then setLength(cath2IRarray,cath2Nbr+1);
       if ToReportRAMinfo('cath2ClusterCount',high(cath2ClusterCount),sizeOf(word),(cath2Nbr+1))
       then setLength(cath2ClusterCount,cath2Nbr+1);
       if ToReportRAMinfo('cath2ClusterCount1',high(cath2ClusterCount1),sizeOf(word),(cath2Nbr+1))
       then setLength(cath2ClusterCount1,cath2Nbr+1);
       if ToReportRAMinfo('persErr',high(persErr),sizeOf(longword),(cath2Nbr+1))
       then setLength(persErr,cath2Nbr+1);
       if ToReportRAMinfo('cath2CountArray',high(cath2CountArray),sizeOf(longword),(cath2Nbr+1))
       then setLength(cath2CountArray,cath2Nbr+1);
      end
     else
      begin
       if ToReportRAMinfo('cath2IRarray',high(cath2IRarray),sizeOf(double),(0))
       then setLength(cath2IRarray,0);
       if ToReportRAMinfo('cath2ClusterCount',high(cath2ClusterCount),sizeOf(word),0)
       then setLength(cath2ClusterCount,0);
       if ToReportRAMinfo('cath2ClusterCount1',high(cath2ClusterCount1),sizeOf(word),0)
       then setLength(cath2ClusterCount1,0);
       if ToReportRAMinfo('persErr',high(persErr),sizeOf(longword),0)
       then setLength(persErr,0);
       if ToReportRAMinfo('cath2CountArray',high(cath2CountArray),sizeOf(longword),0)
       then setLength(cath2CountArray,0);
      end;
     if CheckBox4.Checked then
       begin
        if ToReportRAMinfo('cath3IRarray',high(cath3IRarray),sizeOf(double),cath3Nbr+1)
        then setLength(cath3IRarray,cath3Nbr+1);
        if ToReportRAMinfo('cath3ClusterCount',high(cath3ClusterCount),sizeOf(word),cath3Nbr+1)
        then setLength(cath3ClusterCount,cath3Nbr+1);
        if ToReportRAMinfo('cath3ClusterCount1',high(cath3ClusterCount1),sizeOf(word),cath3Nbr+1)
        then setLength(cath3ClusterCount1,cath3Nbr+1);
        if ToReportRAMinfo('cath3Err',high(cath3Err),sizeOf(longword),cath3Nbr+1)
        then setLength(cath3Err,cath3Nbr+1);
        if ToReportRAMinfo('cath3CountArray',high(cath3CountArray),sizeOf(longword),cath3Nbr+1)
        then setLength(cath3CountArray,cath3Nbr+1);
       end
     else
      begin
       if ToReportRAMinfo('cath3IRarray',high(cath3IRarray),sizeOf(double),0)
       then setLength(cath3IRarray,0);
       if ToReportRAMinfo('cath3ClusterCount',high(cath3ClusterCount),sizeOf(word),0)
       then setLength(cath3ClusterCount,0);
       if ToReportRAMinfo('cath3ClusterCount1',high(cath3ClusterCount1),sizeOf(word),0)
       then setLength(cath3ClusterCount1,0);
       if ToReportRAMinfo('cath3Err',high(cath3Err),sizeOf(longword),cath3Nbr+1)
       then setLength(cath3Err,0);
       if ToReportRAMinfo('cath3CountArray',high(cath3CountArray),sizeOf(longword),0)
       then setLength(cath3CountArray,0);
      end;
    end
   else
    begin
     if ToReportRAMinfo('cath1IRarray',high(cath1IRarray),sizeOf(double),0)
     then setLength(cath1IRarray,0);
     if ToReportRAMinfo('cath1ClusterCount',high(cath1ClusterCount),sizeOf(Word),0)
     then setLength(cath1ClusterCount,0);
     if ToReportRAMinfo('cath1ClusterCount1',high(cath1ClusterCount1),sizeOf(Word),0)
     then setLength(cath1ClusterCount1,0);
     if ToReportRAMinfo('phErr',high(phErr),sizeOf(longWord),0)
     then setLength(phErr,0);
     if ToReportRAMinfo('cath1CountArray',high(cath1CountArray),sizeOf(longWord),0)
     then setLength(cath1CountArray,0);
     if ToReportRAMinfo('cath2IRarray',high(cath2IRarray),sizeOf(double),0)
     then setLength(cath2IRarray,0);
     if ToReportRAMinfo('cath2ClusterCount',high(cath2ClusterCount),sizeOf(Word),0)
     then setLength(cath2ClusterCount,0);
     if ToReportRAMinfo('cath2ClusterCount1',high(cath2ClusterCount1),sizeOf(Word),0)
     then setLength(cath2ClusterCount1,0);
     if ToReportRAMinfo('persErr',high(persErr),sizeOf(longWord),0)
     then setLength(persErr,0);
     if ToReportRAMinfo('cath2CountArray',high(cath2CountArray),sizeOf(longWord),0)
     then setLength(cath2CountArray,0);
     if ToReportRAMinfo('cath3IRarray',high(cath3IRarray),sizeOf(double),0)
     then setLength(cath3IRarray,0);
     if ToReportRAMinfo('cath3ClusterCount',high(cath3ClusterCount),sizeOf(Word),0)
     then setLength(cath3ClusterCount,0);
     if ToReportRAMinfo('cath3ClusterCount1',high(cath3ClusterCount1),sizeOf(Word),0)
     then setLength(cath3ClusterCount1,0);
     if ToReportRAMinfo('cath3Err',high(cath3Err),sizeOf(longWord),0)
     then setLength(cath3Err,0);
     if ToReportRAMinfo('cath3CountArray',high(cath3CountArray),sizeOf(longWord),0)
     then setLength(cath3CountArray,0);
    end;{not form1.CheckBox1.Checked}
   except
   error47('a lot of miscelaneous small arrays could not be created, procedure "RAMresources"');
   end;
  // if form1.checkBox5.checked then cath1ListRead(cath1Nbr);      // dane z Corpory, to..(tu są ustalane kontrolnie parametry cath1Nbr i cath2Nbr; nie uaktywniane w "teście")
   form1.statusbar1.SimpleText:='RAMresources, RAM assigning finished. The set of the all events is loaded now'; application.ProcessMessages;                                                           //parametry pierwszego węzła drzewa wynikowego
End;{RAMresources}

 procedure DataReading;

  Begin //----------------------------------DataReading--------------
   finishDataStepIn(wholeEventNbr);
   vectorAndCathListRead(wholeEventNbr);   //------------------------------------------------------------------
   trueEventNbr:=wholeEventNbr;
   with form1 do
     if (FeatureSetCheck(edit4)) or
     (application.MessageBox(pchar('Data reading finished. Click yes, if you want to check options (strongly recomended!)'#13#10+
     'After then click START to begin processing'),'Check options',4{mb_YesNo})=6)//idYes=6  
     then
      begin
       checkbox36.Enabled:= false; edit29.Enabled:=false;
       controlPageShow(0,form1.Button1);
      end
     else
     begin
      InitWrite;
      if checkBox9.Checked then with groupBox2 do begin top:=panel2.Top; left:=radiogroup15.Left end;
      groupBox2.Visible:=checkBox9.Checked;
      Button12.Visible:=true; Button12.setfocus;
      label49.Caption:=xxx;    checkbox10.Visible:=true;  checkbox21.Visible:=true; button24.Visible:=true; checkbox25.Visible:=true; checkbox27.Visible:=true; checkbox38.Visible:=true;
     end;
   form1.RadioGroup15.visible:=false;  form1.groupbox1.Visible:=false;   
   with form1.CheckBox13 do begin Checked:=false; Enabled:=false end;
   application.ProcessMessages;
   setClassifiersNumbers(cath1Nbr,cath2Nbr,cath3Nbr);
   dataread:=true;
   stopReading:=false;//przeniesione z końca  vectorAndCathListRead; w. 2505, 05.11.08
  End;{DataReading}

 procedure readExcludeSet(treeFileDir:String);
 //czyta zbiór zdarzeń wykluczanych znalezionych w poprzednim przebiegu
 var i:longword; sTmp:string;
     j,k,l,m:integer;
 Begin
  showMessage('Attention!'#13#10'The program works in the "'+form1.RadioGroup3.Items[form1.RadioGroup3.itemIndex]+
   '" mode.'#13#10'All settings by which the excluce set was obtained will be automatically restoread.'#13#10+
   'The settings and the exclude set itself are read from the tree file.');
  assignFile(treeFile,treeFileDir);
  reset(treeFile);
  with form1 do
   begin
    readln(treeFile,sTmp);                                 //'date: '+dateToStr(date)+' time: '+timeToStr(time),', report date: ',reportDate,', heap size=',intToStr(heapTop),s);
    readln(treeFile,sTmp);                            //eventNbr,' - number of the data vectors; teaching events file: ', eventFileDir
    readln(treeFile,sTmp);                                 //CART|centroids dividing method, if =0 then CART, if =1 then centroids'  .radiogroup12.caption
    CentroidsNb_glob0:=CentroidsNb_glob;
    readln(treeFile,CentroidsNb_glob,j,i);  Edit2.Text:=intToStr(CentroidsNb_glob);                           //Centroids number, heapTop, eventNbr
    try
     if ToReportRAMinfo('excludeSet',high(excludeSet),sizeOf(TarrSet),((i+1) div 8+1))
     then setLength(excludeSet,(i+1) div 8+1);                   //setLength(excludeSet,(eventNbr+1) div 8+1);
     emptySet(excludeSet);
    except
    error47('exclude set, procedure "readExcludeSet" (1)');
    end;
    readln(treeFile,nc,sTmp);                Edit1.Text:=intToStr(nc);   //nc
    readln(treeFile,i,sTmp);                 RadioGroup2.ItemIndex:=i;             //RadioGroup2Click(RadioGroup2); blok, bo daje złe reakcje (ustawia nc domyślnie)
    readln(treeFile,k,sTmp);          //radiogroup5.ItemIndex:=k;           RadioGroup5Click(RadioGroup5);//index of the omited vectors components (radiobutton index)
    for i:=1 to 8 do read(treeFile,setArray[i]);
    featureSet:=ToutSet(setArray);
    readln(treeFile,sTmp);              //featureSet   EditExit(Edit4,label114,outSetIn); featureSet:=outSetIn;
    Edit4.Text:=sTmp; Edit28.Text:='';  //odtworzenie konstruktora zbioru cech
    featureSet:=outSetIn;
    label112.caption:=SetConstructorReconstruction(featureSet);   label117.Caption:=label112.caption;
    readln(treeFile,i,j,k,l,m,sTmp);                       //Classificators for supervised training:, degressive isolation
    CheckBox1.checked:=boolean(i); CheckBox1.tag:=1;           CheckBox1Click(CheckBox1);
    CheckBox2.checked:=boolean(j);                             CheckBox2Click(CheckBox2);
    CheckBox3.checked:=boolean(k);                             CheckBox3Click(CheckBox3);
    CheckBox4.checked:=boolean(l);                             CheckBox4Click(CheckBox4);
    CheckBox19.checked:=boolean(m);
    readln(treeFile,k,sTmp); CheckBox30.checked:=boolean(k);   CheckBox30Click(CheckBox30);//averaging On, Off '
    readln(treeFile,k,sTmp);        ComboBox1.itemIndex:=k;          //averaging method'
    readln(treeFile,AveragingTime,sTmp);                             // averaging time'
    readln(treeFile,FrameNbr,sTmp);                                  //number of frames'
    readln(treeFile,FrameStep,sTmp);                                 //analysis step'#13#10,
    readln(treeFile,rate,sTmp);                                      //wave sampling frequency'#13#10,
    readln(treeFile,rareEventNbr1,rareEventNbr2,sTmp);               //rareEventNbr1, rareEventNbr2'#13#10,
    readln(treeFile,k,sTmp); radiogroup4.ItemIndex:= k;              //distortion =mean|sum of distances
    readln(treeFile,k,sTmp); radiogroup9.ItemIndex:= k;                            // filter for Input signal'#13#10,
    readln(treeFile,k,sTmp); radiogroup10.ItemIndex:=k;                            // filter shape for the Input signal (FFT power spectrum domain)'#13#10,
    readln(treeFile,k,sTmp); radiogroup11.ItemIndex:=k;                            // weighting window shape (for WAW input signal)'#13#10,
    readln(treeFile,k,sTmp); radiogroup12.ItemIndex:=k;      RadioGroup12Click(RadioGroup12);                       // Set dividing method (CART|Centroids)
    readln(treeFile,k,sTmp); radiogroup22.ItemIndex:=k;      RadioGroup22Click(RadioGroup22);                       // kryteria wyboru zbioru do podziału'#13#10,
    readln(treeFile,k,sTmp); radiogroup23.ItemIndex:=k;      RadioGroup23Click(RadioGroup23);                       // kryteria wyboru cechy w trybie CART wg wartości której był dzielony zbiór'#13#10,
    readln(treeFile,k,sTmp); radiogroup24.ItemIndex:=k;      RadioGroup24Click(RadioGroup24);                       // kryteria wyboru zbioru do podziału, wrażenie , tryb supervised training'#13#10,
    readln(treeFile,k,sTmp); radiogroup25.ItemIndex:=k;      RadioGroup25Click(RadioGroup25);                       // kryteria wyboru cechy w trybie CART, wrażenie , tryb supervised training'#13#10,
    readln(treeFile,k,sTmp); radiogroup26.ItemIndex:=k;                            // kryteria wyboru zbioru do podziału, unsupervise|supervised training (0 i 1 odpowiednio)'#13#10,
    readln(treeFile,k,sTmp); radiogroup27.ItemIndex:=k;                            // kryteria wyboru cechy w trybie CART, unsupervise|supervised training (0 i 1 odpowiednio)'#13#10,
    readln(treeFile,k,sTmp); checkBox28.checked:=boolean(k);                       // card(rarae_events_set) i.e. count of the elements of the rare events  (excluded from computations of distances and centroids), radiobutton indexes for the train signal handlings ');
    readln(treeFile,k,sTmp); checkBox42.checked:=boolean(k); CheckBox42Click(CheckBox42);                      //CART-like
    readln(treeFile,sTmp);                          //'Leaf nodes addresses:'
    readln(treeFile,sTmp);                            //' ',leafNodes[i]
    try
     readln(treeFile,excludeSetCard,sTmp);  form1.label49.caption:=intTostr(excludeSetCard);           //'Exclude set'
     if excludeSetCard<=0 then begin error44; emptySet(excludeSet); closeFile(treeFile); exit end;
     for i:=0 to (wholeEventNbr+1) div 8 do
      begin
       tempus:=i;
       read(treeFile,excludeSet[i]);       //03.11.05, zbiór zdarzeń b. rzadkich       i:=0 to (n+1) div 8 , bo zbiór jest zapisywany do struktury zdolnej pomieścić całośĆ  i całą tę strukturę należy wczytać!
      end;
      readln(treeFile);
    except
     error45(excludeSetCard,wholeEventNbr,wholeEventNbr);
    end;{try}
  end;{with}
  closeFile(treeFile);
  i:=cardSet(excludeSet);
  if i<>excludesetCard then error53(i,excludesetCard);
  try
   if ToReportRAMinfo('excludeSet',high(excludeSet),sizeOf(TarrSet),(wholeEventNbr+1) div 8+1)
   then setLength(excludeSet,(wholeEventNbr+1) div 8+1);  //przywrócenie długości tablicy kodującej zbiór dostosowany do aktualnej ilości danych; jest też w RAMresources!
  except                                             //to chyba na wszelki wypadek, gdyby excludeSet zastosowano do innych danych?
   error47('exclude set, procedure "readExcludeSet" (2)');
  end;
  ResponseCheckerSettings;
  initWrite;
 End; {readExcludeSet}

 function IRmax(M:word;checkBox:TcheckBox):double;
//M - Number of cathegory values
 Begin
  if checkBox.checked then
  IRmax:= (1/(M*ln2))*ln(2/(M+1))+(1/ln2)*ln(2*M/(M+1))+(M-1)/M
  else IRmax:=0;
 End;

function stretch(const cath1IRmax,cath2IRmax,cath3IRmax:double):double;
//znaleźć największą wartość
 Begin
   result:=cath1IRmax;
   if result<cath2IRmax then result:=cath2IRmax;
   if result<cath3IRmax then result:=cath3IRmax;
 End;

procedure frameStretches(const eventNbr:longWord);
//określa wartości maksymalne funkcji i ramek wykresów
var wsp:double;
 Begin //cath1IRmax,cath2IRmax,cath3IRmax
   //IR
   with form1 do
   begin
   cath1IRmax:=IRmax(cath1Nbr,checkBox2);
   cath2IRmax:=IRmax(cath2Nbr,checkBox3);
   cath3IRmax:=IRmax(cath3Nbr,checkBox4);
   end;
   IRStretch:=Stretch(cath1IRmax,cath2IRmax,cath3IRmax);
    //error
   wsp:=100/eventNbr;
  if form1.CheckBox21.checked then  //100% reference for error graphs
   begin
    cath1ErrMax:=100;  cath2ErrMax:=100;  cath3ErrMax:=100;
   end
   else
   begin
    cath1ErrMax:=nodeprops[0].cath1RecErr*wsp;
    cath2ErrMax:=nodeprops[0].cath2RecErr*wsp;
    cath3ErrMax:=nodeprops[0].cath3RecErr*wsp;
   end;
   errStretch:=stretch(cath1ErrMax,cath2ErrMax,cath3ErrMax);
 End;

Procedure Frames;
//procedure IRframe(Panel:TPanel;canvas:tcanvas;const classNbr:Word; const stretch:double; ceil1,ceil2,ceil3:double; out wspx,wspy,topHeight:double);
const IRWSPY=0.9;
Begin
 with form1 do
 begin
  if checkbox10.Checked and oncePerformed and not errStretchChange then exit;   //nakładaj wykresy
  errStretchChange:=false;     //zmiana referencji wykresów błędu
  IRframe(Panel2,Canvas,CentroidsNb_glob-1,nodeProps[0].meanDistance,0,0,0,wspx2,wspy2,topHeight2);
  IRframe(Panel3,Canvas,CentroidsNb_glob-1,IRstretch,IRWSPY*cath1IRmax,IRWSPY*cath2IRmax,IRWSPY*cath3IRmax,wspx3,wspy3,topHeight3);  wspy3:=IRWSPY*wspy3;
  IRframe(Panel4,Canvas,CentroidsNb_glob-1,errStretch,0,0,0,wspx4,wspy4,topHeight4);//cath1ErrMax,cath2ErrMax,cath3ErrMax,
 end;
End;

procedure outputGraphDataPrepare(const eventNbr:longWord);
 //przygotowuje parametry grafów obrazujących wyniki
  Begin
    frameStretches(eventNbr);
    frames;
    prevIRcath1:=0;prevIRpers:=0; prevIRvoic:=0; NodePrevIRcath1:=0;
    prevDistortion:=nodeprops[0].meandistance;  NodePrevDistortion:=prevDistortion;
    if form1.CheckBox21.checked then  //100% reference for error graphs
    begin
     prevErrcath1:=100;  prevErrPers:=100;  prevErrVoic:=100;  NodePrevErrcath1:=100;  NodePrevErrPers:=100;  NodePrevErrVoic:=100;
    end
    else
    begin
     prevErrcath1:=100*nodeProps[0].cath1RecErr/eventNbr;  prevErrPers:=100*nodeProps[0].cath2RecErr/eventNbr;  prevErrVoic:=100*nodeProps[0].cath3RecErr/eventNbr;
    end;
   percNorm:=100/eventNbr;
  End;{outputGraphDataPrepare}

  Procedure ShowSpaceQuantization(const nc:byte; const nodeHeapTop1,nodeHeapTop2:word);
  {
  Shows features space quantization
  }

   procedure centroReset(const Top:word);
    var i,j:word;
    Begin
     for i:=0 to nc-1 do
      for j:=0 to Top+1 do //2*step+1-1
       centroArr[i,j]:=1.7e308;
    End; {centroReset}

    procedure takeCentroids(const Top:word);
    //run through the tree and pick up centroids
    var i,j:word;
     begin
      for j:=0 to nc-1 do centroArr[j,0]:=minMax[j].min;
      for i:=1 to Top do
       with nodeHeap[i] do
        begin
         for j:=0 to nc-1 do
          centroArr[j,i]:=nodeProps[i].centroid[j];
        end;{for i}
      for j:=0 to nc-1 do centroArr[j,Top+1]:=minMax[j].max;
     end;

    procedure sortCentroArr(const Top:word);
    //sorts increasingly columns of array of centroids

     procedure QuickSort(var collumn:Tdbarr; l,r:longWord);
       //sortuje tablicę liczebności liści
     var i,j:longint; x,y:double;
     begin
       i:=l; j:=r; x:=collumn[(l+r) DIV 2];
       repeat
        while collumn[i]<x do i:=i+1;
        while x<collumn[j] do j:=j-1;
        if i<=j then
        begin
         y:=collumn[i]; collumn[i]:=collumn[j]; collumn[j]:=y;
         i:=i+1; j:=j-1;
        end;
       until i>j;
       if l<j then QuickSort(collumn,l,j);
       if i<r then QuickSort(collumn,i,r);
     end;{QuickSort}

    var i:word;
     Begin
      for i:=0 to nc-1 do
       QuickSort(centroArr[i],0,Top+1); //2*step
     End;{sortCentroArr}

  procedure QuantizationToReport(const Top:word);
   var i,l:integer; j,k:byte; s:shortString;

   procedure underline(const k:byte;const s:shortString;const t:char;out l:integer);
   //t - tick
    var i,j:byte;
   Begin
    l:=0;
    write(reportFile,'|',s);
    for j:=0 to nc-1 do  if j in featureSet then
     begin
      write(reportFile,t);
      for i:=1 to k+2 do write(reportFile,'=');
      inc(l,k+3);
     end;
     writeln(reportFile,'|');
   End; {underline}

   Begin   //-----------------------QuantizationToReport--------------------
    k:=12; //długość zapisu liczby w formacie "naukowym"
    writeln(reportFile,'Table 5. Features Space Quantization - min-max range and centers of intervals');
    underline(k,'========','-',l);
    s:='|Features numbers';
    l:=l-length(s);
    write(reportFile,'|        ',s); for i:=1 to l do write(reportFile,' ');
    if l>0 then writeln(reportFile,'|') else writeln(reportFile);
    underline(k,'Interval','-',l);
    write(reportFile,'|  number| ');
    for j:=0 to nc-1 do if j in featureSet then
     write(reportFile,j:k,' | ');
    writeln(reportFile);
    underline(k,'========','|',l);
    for i:=0 to Top+1 do
     begin
      if i=0 then write(reportFile,'|','minimum':8,'| ') else
      if i=Top+1 then write(reportFile,'|','maximum':8,'| ')
      else  write(reportFile,'|',i:8,'| ');
      for j:=0 to nc-1 do   if j in featureSet then
       write(reportFile, centroArr[j,i]:k,' | '); writeln(reportFile);
     end;{for i}
    underline(k,'========','=',l);
   End;{QuantizationToReport}
   var n1,n2:int64;
   Begin   //----------------------------------------------ShowSpaceQuantization-----------------------------------
    flush(reportFile);
    if ((high(centroArr)+1)*sizeOf(TdbArr)*(nodeHeapTop1+2))<>sizeOf(TdbArr)*(nodeHeapTop2+2)*nc then ToReportRAMinfoCaption;
    if ToReportRAMinfo('centroArr',((high(centroArr)+1)*sizeOf(TdbArr)*(nodeHeapTop1+2)-1),1,sizeOf(TdbArr)*(nodeHeapTop2+2)*nc) then
    setLength(centroArr,nc,nodeHeapTop2+2);      //2*step+1
    n1:=sizeOf(centroArr);
    centroReset(nodeHeapTop2);
    takeCentroids(nodeHeapTop2);
    sortCentroArr(nodeHeapTop2);
    QuantizationToReport(nodeHeapTop2);
    flush(reportFile);
   End;{ShowSpaceQuantization}

 procedure standardDeviationRatio;

 procedure ratioEstimate(var RatioVector:TmeanVector; const centroid1, centroid:TmeanVector;var StepRatioSum, StepRatioSqrSum:extended;const nodeAddr:word; var ratioSumVector:TmeanVector;const sign:shortInt);
  var i:byte;   tmp:extended;
   Begin
   with nodeHeap[nodeAddr],nodeProps[nodeAddr] do
    for i:=0 to nc-1 do
     if i in featureSet then
      begin
       if nodeStdev[i]<>0 then RatioVector[i]:=sign*(-centroid1[i]+centroid[i])/nodeStdev[i]
       else RatioVector[i]:=0; //c1[i]=c0[i]-n*stdev[i] hence n=(c0[i]-c1[i])/stdev, thus if stdev=0, then n=0, because c1[i]=c0[i], thus we have  0/0
       tmp:=RatioVector[i];    //where c0 - preadecessor, c1 - first successor
       StepRatioSum:=StepRatioSum+tmp;
       StepRatioSqrSum:=StepRatioSqrSum+tmp*tmp;
       ratioSumVector[i]:=ratioSumVector[i]+RatioVector[i]
      end;
   End;

  var
   leftRatioVector,rightRatioVector,ratioSumVector:TmeanVector;  //, leftRatioSumVector
   StepLeftRatioSum,StepLeftRatioSqrSum,StepRightRatioSum,StepRightRatioSqrSum,lStdev,rStDev,
   leftSum,rightSum,lStdevSum,rStdevSum,tmp:extended;
   counter:word;

  procedure TreeExaminer(nodeAddr:word);
  {
  biegnie po drzewie i oblicza, o ile odchyleń standardowych odległe są wartości składowych wektorów opisujących
  zdarzenia w węźle przodka od tych składowych w węzłach następników
  abs(son) - ponieważ w trybie CART i CART-like pojawiają się rozbicia niewykorzystane połączone ujemnym parametrem son
  }
   var i:byte;
   Begin
    with nodeHeap[nodeAddr],nodeProps[nodeAddr] do
     if son<>0 then
      Begin
       StepLeftRatioSum:=0; StepLeftRatioSqrSum:=0; StepRightRatioSum:=0; StepRightRatioSqrSum:=0;
       inc(counter);
       ratioEstimate(leftRatioVector,nodeProps[abs(son)].centroid,centroid,StepLeftRatioSum, StepLeftRatioSqrSum,nodeAddr,ratioSumVector,1);
       ratioEstimate(rightRatioVector,nodeProps[nodeHeap[abs(son)].brother].centroid,centroid,StepRightRatioSum, StepRightRatioSqrSum,nodeAddr,ratioSumVector,-1);
       lStdev:=StepLeftRatioSqrSum/featureSetCard-sqr(StepLeftRatioSum/featureSetCard);
       if lStDev>=0 then lStDev:=sqrt(lStDev)
       else
        begin
         error62('left variance<0!;'#13#10'step='+intToStr(nodeStep)+', node address ='+intToStr(nodeAddr)+', node counter='+intToStr(counter)+', left variance='+floatToStr(lstDev)+'; node''s set power='+intToStr(nodeProps[nodeAddr].cardinal));
         lStDev:=0;
        end;
       rStdev:=StepRightRatioSqrSum/featureSetCard-sqr(StepRightRatioSum/featureSetCard);
       if rStDev>=0 then rstdev:=sqrt(rStDev)
       else
        begin
         error62('right variance<0!;'#13#10'step='+intToStr(nodeStep)+', node address ='+intToStr(nodeAddr)+', node counter='+intToStr(counter)+', right variance='+floatToStr(rstDev)+'; node''s set power='+intToStr(nodeProps[nodeAddr].cardinal));
         rStDev:=0;
        end;
       StepLeftRatioSum:=StepLeftRatioSum/featureSetCard;
       StepRightRatioSum:=StepRightRatioSum/featureSetCard;

     //To report
       with nodeProps[nodeAddr] do
        write(reportFile,'|',nodeStep:5,'|',nodeAddr:5,'|',cardinal:8,'|',StepLeftRatioSum:6:3,'|',lstDev:6:3,'|',
                                                           StepRightRatioSum:6:3,'|',rstDev:6:3,'|',
         (StepLeftRatioSum+StepRightRatioSum)/2:6:3,'|',(lstDev+lstDev)/2:6:3,'|',iterNbr:6,'|');
          if form1.RadioGroup5.ItemIndex=2 then
           begin
            for i:=0 to nc-1 do if i in featureSet then write(reportFile,'|',leftRatioVector[i]:6:3); writeln(reportFile,'|');
            write(reportFile,'|     |     |        |      |      |      |      |      |      |      |');
            for i:=0 to nc-1 do if i in featureSet then write(reportFile,'|',rightRatioVector[i]:6:3); writeln(reportFile,'|');
           end
          else writeln(reportFile,'|');{if}

     //totals
        leftSum :=leftSum +StepLeftRatioSum;  lStdevSum:=lStdevSum+lStdev;
        rightSum:=rightSum+StepRightRatioSum; rStdevSum:=rStdevSum+rStdev;
        flush(reportFile);
       TreeExaminer(abs(nodeHeap[NodeAddr].son))
      End;{son<>0}
    if nodeHeap[nodeAddr].brother>0 then TreeExaminer(nodeHeap[NodeAddr].brother);
   End;{TreeExaminer}

 procedure underline;
  var i:byte;
  Begin
    write(reportFile,'|=====|=====|========|======|======|======|======|======|======|======|');
    if form1.RadioGroup5.ItemIndex=2 then
     for i:=0 to nc-1 do if i in featureSet then write(reportFile,'|======');   writeln(reportFile,'|');
  End;

 procedure TableCaption;
  var i:byte;
  Begin
   writeln(reportFile,#13#10'Table 6. Standard deviation ratio estimates');
   underline;
   write(reportFile,'| Step| node|    car-|  Left|l. std| Right|r. std| l.+r.| l.+r.|Iterat|');
   if form1.RadioGroup5.ItemIndex=2 then  write(reportFile,'| left and right standard deviation multipier vectors');
   writeln(reportFile);
   write(reportFile,'|     |addr |   dinal| ratio|deviat|ratio |deviat| ratio|deviat|   nbr|');
   if form1.RadioGroup5.ItemIndex=2 then  for i:=0 to nc-1 do if i in featureSet then write(reportFile,'|',i:6);
   writeln(reportFile,'|');
   underline;
  End;

 var i:byte;
 Begin   //--------------------------------------------------- standardDeviationRatio --------------
  leftSum:=0; rightSum:=0; lStdevSum:=0; rStdevSum:=0; counter:=0;
  for i:=0 to nc-1 do if i in featureSet then ratioSumVector[i]:=0;
  TableCaption;
  TreeExaminer(0);
  underline;
  write(reportFile,'|Totals              |',leftSum/counter:6:3,'|',lStdevSum/counter:6:3,'|',rightSum/counter:6:3,'|',
  rStdevSum/counter:6:3,'|',(leftSum+rightSum)/(2*counter):6:3,'|',(lStdevSum+rStdevSum)/(2*counter):6:3,'|',totalIterNbr:6,'|');
  if form1.RadioGroup5.ItemIndex=2 then for i:=0 to nc-1 do if i in featureSet then write(reportFile,'|',RatioSumVector[i]/(2*counter):6:3); writeln(reportFile,'|');
  underline;
 End;{standardDeviationRatio}

 procedure showNodeFission;

  procedure printCentroid(const nodeAddr:word);
   var m:byte;
   Begin
    write(reportFile,'|centroid:|',nodeAddr:9,'|');
    with nodeProps[nodeAddr] do
    for m:=0 to nc-1 do
    if m in featureSet then write(reportFile,'|',round(centroid[m]):6); writeln(reportFile,'|'#13#10)
   End;{printCentroid}

  procedure NodeSetToReport(const nodeAddr:word;s:string);
   var i:longWord;
       m:byte;
   Begin
    writeln(reportFile,s);
    printCentroid(nodeAddr);
    with NodeProps[nodeAddr] do
     begin
      for i:=lb to hb do
       begin
        write(reportFile,'|',i:9,'|',sbl[i]:9,'|');
        for m:=0 to nc-1 do
         if m in featureSet then write(reportFile,'|',vectList[sbl[i],m]:6); writeln(reportFile,'|')
       end;{for i}
     end;{with}
   End;{NodeSetToReport}

  procedure underline;
   var k:byte;
   Begin
    write(reportFile,'|=========|=========|');
    for k:=0 to nc-1 do if k in featureSet then write(reportFile,'|======');writeln(reportFile,'|');
   End;

   procedure Caption;
    var k:byte;
    Begin
     writeln(reportFile,#13#10'Table 7. Node fission');
     underline;
     write(reportFile,'|'); write(reportFile,'  events |  events |');  for k:=0 to nc-1 do if k in featureSet then write(reportFile,'|      ');writeln(reportFile,'|');
     write(reportFile,'|'); write(reportFile,'   index |addresse |');  for k:=0 to nc-1 do if k in featureSet then write(reportFile,'|',k:6);     writeln(reportFile,'|');
     underline;
    End;

  var k,l:word;  s:string;
 Begin//------------------- ShowNodeFission ---------------
  Caption;      l:=high(nodeHeap);
  for k:=0 to 255 do
   if (k in FissionSet) and (k<l) then
    with nodeHeap[k] do
     begin
      writeln(reportFile,#13#10'Fission of the node ',k,'; events count=',nodeProps[k].cardinal,
       ' fission distance=',nodeProps[k].fissionDistance:12);
      printCentroid(k);
      s:='Node '+intToStr(son)+'; first descendant, events count='+intToStr(nodeProps[abs(son)].cardinal);
      NodeSetToReport(abs(son),s);
      s:='Node '+intToStr(nodeHeap[abs(nodeHeap[k].son)].brother)+'; second descendant, events count='+
                intToStr(nodeProps[nodeHeap[abs(nodeHeap[k].son)].brother].cardinal);
      NodeSetToReport(nodeHeap[abs(nodeHeap[k].son)].brother,s);
     end {with}
    else exclude(fissionSet,k);
  form1.edit34.Text:=SetConstructorReconstruction(fissionSet);
  underline;
 End;{ShowNodeFission}

 procedure perform;
 var
  performance:string;  k:word;

 procedure treeReset;
 var i,j:word; nullNode:TnodeProps;
 type TbyteArr=array[0..sizeOf(nullNode)-1] of byte;
 Begin
  for i:=0 to sizeOf(nullNode)-1 do tbyteArr(nullNode)[i]:=0;
  with nullNode do
   begin
    cath1RecErr:=4294967295;
    cath2RecErr:=4294967295;
    cath3RecErr:=4294967295;
    cath2:=255;
    cath1:=255;
    cath3:=255;
    iterNbr:=$FFFF;
   end;
  for i:=0 to nodeHeapTop-1 do nodeProps[i]:=nullNode;
  if form1.RadioGroup12.ItemIndex=0 then
   begin  //array[0..nc, 0..K] of Word i 1-wymiarową tablicę featureUseCounter:array[0..nc]
    for i:=0 to nc do     //zerowanie histogramu użycia cech w CART
     begin
      featureUseCounter[i]:=0;
      for j:=0 to CentroidsNb_glob do featureUseHist[i,j]:=0
     end;
   end;
 End;
 var i:byte;
 BEGIN    //---------------------------------perform----------------------------------------------------
  with form1 do
  begin
   if not checkBox2.Checked then label138.Caption:=xxx else label138.Caption:='';
   if not checkBox3.Checked then label139.Caption:=xxx else label139.Caption:='';
   if not checkBox4.Checked then label140.Caption:=xxx else label140.Caption:='';
   if not checkBox10.Checked then onceShowed:=false;
  end;
  dist:=EuclidDist; trueEventNbr:=wholeEventNbr;featureSetCard:=0;  alloc:='b';  step:=0;
  allcath1:=false; allcath2:=false; allcath3:=false;
  Checkcath1Set:=cath1Set; Checkcath2Set:=cath2Set; Checkcath3Set:=cath3Set;
  for i:=0 to nc-1 do if  (i in featureSet) then inc(featureSetCard);
  with form1 do begin Label75.Caption:=xxx; Label76.Caption:=xxx; Label77.Caption:=xxx;Label45.Caption:=xxx;Label46.Caption:=xxx;Label108.Caption:=xxx;  end; //label66.Caption:='Note! the "Fission distance" is not computed yet!'
  with form1 do if checkBox11.Checked and (radiogroup12.ItemIndex=1) then     //show history, centroids
   checkBox11.Checked:=application.MessageBox('Turn off "Show history" to save memory!','Warning',mb_yesNo)=idno;
  if form1.RadioGroup3.ItemIndex=1 then   //first|second pass
   begin
    OpenTreeFile;
    if fileExists(treeFileDir) then
     begin
      readExcludeSet(treeFileDir);
      performance:='second performance. Elements from sets contained less then or aequal '+intToStr(rareEventNbr2)+' members will not be taken into account during centroids computations';
     end
    else showMessage('You have chosen the "'+form1.radiogroup3.Items[1]+'" option.' +#13#10'Can not perform second pass because file '+treeFileDir+(*'1'+*)' does not exist. The first pass will be performed instead.')
   end
  else;
  if (form1.checkBox42.Checked) or (form1.RadioGroup12.ItemIndex=0) then k:=2*CentroidsNb_glob  //RamResources(2*CentroidsNb_glob) wtrybie CART-like trzeba rezerwowa~2*wiecej miejsca na stos węzłów
  else k:=CentroidsNb_glob;                                     //RamResources(CentroidsNb_glob
  RamResources(k);
  treeReset;
  if form1.RadioGroup3.ItemIndex=0 then emptySet(ExcludeSet);   //zeruj, gdy "first pass"
  S0;
  if changeAllClasses then classChanger;
  form1.Button12.Visible:=false;
  application.ProcessMessages;
   //------------------------------------------Zaczyna się!----------------------------------------------------
  OutputGraphDataPrepare(trueEventNbr);
  currX:=Form1.panel3.left;
  if not form1.CheckBox1.Checked then MakeH0Hist(trueEventNbr,cath1H0,cath2H0,cath3H0);  //wykonać histogram całej próby
  performance:=#13#10'First performance'#13#10+
   'Now are detected rare events, which you can exclude from the quantizing process'#13#10'at the next performance (if you judge it for necessary).'#13#10;
  if not form1.checkBox19.Checked then
  if tryStrToInt(trim(form1.Edit7.Text),rareEventNbr1) then
  else
   begin
    while not
     TryStrToInt(inputBox('Correct edit box text',form1.Edit7.Text+' is not correct integer number!',
     intToStr(round(0.5+trueEventNbr/(8*CentroidsNb_glob)))),rareEventNbr1) do;
     form1.Edit7.Text:=intToStr(rareEventNbr1);
   end;
  secondPass:=false;
  RUN(CentroidsNb_glob,performance);//,'1');  blok 12.03.09      //****************************************************************
  treeToReport;//(performance);
  ToRemoveSet(trueEventNbr);                                                      //zbiór zdarzeń, które mają być pominięte przy obliczaniu centroidów
   if form1.RadioGroup12.ItemIndex=0 then featuresUsageHistToReport;
  excludeSetToReport;                                          //parametry pierwszego węzła
  saveTree(CentroidsNb_glob, nc,treeFileDir);//,'1'); blok 12.03.09

  ShowSpaceQuantization(nc,2*CentroidsNb_glob0-2,2*CentroidsNb_glob-2);
  CentroidsNb_glob0:=CentroidsNb_glob;
  with form1 do
   if RadioGroup12.ItemIndex=1 then   //tylko dla metody centroidów!
    if RadioGroup5.ItemIndex>0 then
     standardDeviationRatio;
  if form1.checkBox5.Checked then  ShowNodeFission;   
  CloseFile(reportFile);
  if form1.checkBox33.Checked or form1.checkBox35.Checked then SuspendOrHibernate(true,false);
  showMessage('Program finished.'#13#10'See:'#13#10'report file at   '#8'"'+reportFileDir+'",'#13#10+
              'tree file at      '#8'"'+treeFileDir+'".');
  form1.Edit2.Enabled:=true;
 END;{perform}

 Begin
 ln2:=ln(2);
 prevIRcath1:=0;    prevIRpers:=0;    prevIRvoic:=0; FFTwindowsWidth:=0;
 prevErrcath1:=100; prevErrPers:=100; prevErrVoic:=100;
 wholeEventNbr:=high(wholeEventNbr);
 trueEventNbr:=high(trueEventNbr);
end.


