unit FormUnit;

interface

uses
  Windows, Messages, dialogs,SysUtils, Variants, Classes, Graphics, Controls, Forms,
StdCtrls, ComCtrls;

type
  TForm2 = class(TForm)
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Button1: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Edit1: TEdit;
    Label1: TLabel;
    Edit2: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Edit3: TEdit;
    Label4: TLabel;
    Edit4: TEdit;
    Button2: TButton;
    Label5: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}
uses corelAnalysis;

procedure InitWrite;
 Begin
  assignFile(initFile,programDir);
  rewrite(initFile);
  writeln(initFile,dataDir);
  writeln(initFile,resultsDir);
  closeFile(initFile);
 End;

procedure initRead;
 {
  czyta ostatnio uyte pooenie plikw
 }
 Begin
 programDir:=getCurrentDir;
 form2.Edit1.Text:=programDir;
 programDir:=programDir+'\Init.txt';
 with form2 do
 if fileExists(programDir) then
  begin
   Edit2.Text:=programDir;
   assignFile(initFile,programDir);
   reset(initFile);
   readln(initFile,dataDir);      Edit3.Text:=dataDir;
   readln(initFile,resultsDir);   Edit4.Text:=resultsDir;
  closeFile(initFile);
 end
 else form2.Edit2.Text:='No init file found';
 end;


procedure openDataFile;
 begin
  with form2.OpenDialog1 do
   begin
   InitialDir:=dataDir;  fileName:=dataDir;
   Execute()
   end;
 end;

procedure saveResultsFileOpen;
 begin
  with form2.saveDialog1 do
   begin
    saveDialog(form2.saveDialog1,resultsDir,0,'Save file to "'+resultsDir+'"');
   end;
  form2.Edit4.Text:=resultsDir;
  assignFile(resultsFile,resultsDir);
  rewrite(resultsFile);
  writeln(resultsFile,'CART; features correlation analysis.'#13#10'Data file: "',dataDir,'"',#13#10'Output file "',
  resultsDir,'"'#13#10'report created at the '+dateToStr(now),' ',timeToStr(now));
  writeln(resultsFile,'Rows: quantization step,'#13#10'      correlation coefficient.');
  flush(resultsFile);
 end;

 procedure saveResults(fCounter,featureNbr:byte);
  var i:byte;
  Begin
   write(resultsFile,featureNbr);
   case  featureNbr of
    1:writeln(resultsFile,' -st feature');
    2:writeln(resultsFile,' -nd feature');
    3:writeln(resultsFile,' -rd feature');
    else writeln(resultsFile,' -th feature');
   end;
   for i:=1 to fCounter do write(resultsFile,stepArr[i]:7,#9);writeln(resultsFile);
   for i:=1 to fCounter do write(resultsFile,rArr[i]:7:5,#9);writeln(resultsFile);
   flush(resultsFile);
  End;

 procedure readAndProceedData;
  var s:string;
  l,k,fCounter,sum,totalClassNbr : word;
  r:double;
  begin
   dataDir:= form2.OpenDialog1.FileName;
   with form2 do caption:=caption+'.  Analysed data: "'+dataDir+'"';
   assignFile(dataFile,dataDir);
   reset(dataFile);
   readln(dataFile,totalClassNbr);
   readln(dataFile,s);
   repeat
    read(dataFile,featureNbr);  fCounter:=0;  sum:=0;
    while not seekeoln(dataFile) and not seekEof(dataFile) do
     Begin
      read(dataFile,l);
      inc(sum,l);
      inc(fCounter);
      r:=correl(l,fCounter,sum);
      stepArr[fCounter]:=l;
      rArr[fCounter]:=r;
     End;{while}
    readln(dataFile);
    r:=correl(totalClassNbr,fCounter,sum);     //na koniec wiersza obliczamy r dla cakowitej iloci klas
    inc(fCounter);
    stepArr[fCounter]:=totalClassNbr;
    rArr[fCounter]:=r;
    saveResults(fCounter,featureNbr);
   until seekEof(dataFile);
   close(resultsFile);
  end;

procedure TForm2.Button1Click(Sender: TObject);
begin
 form2.Label5.Font.Color:=clRed;
 form2.Label5.Caption:='CART Features Correlation Analysis';
 openDataFile;
 saveResultsFileOpen;
 InitWrite;
 readAndProceedData;
 form2.Label5.Font.Color:=clGreen;
 form2.Label5.Caption:='Done!';
 ShowMessage('Find results in "'+resultsDir+'"');
 form2.Button2.SetFocus;
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
 initRead;
end;

procedure TForm2.Button2Click(Sender: TObject);
begin
 showMessage('Halt!');
 InitWrite;
 Halt
end;

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 InitWrite;
 showMessage('Close!');
end;

end.


