﻿unit equation;

 //Fortran IV, Siegmund Brandt(1970). Statistical and Computational Method in Data Analysis. North-Holland, Elsevier, Amsterdam, London, New York

interface
 uses sysUtils,forms;
 procedure testEquation;
 procedure testInvertion;
implementation
 uses inverter,unit1;
 type TM=array of array of double;
 var
  nl:byte=16;
  gridStart:word=0;

 procedure MTXWRT(const A:TM; const m,n,nl:word; var y:word;comment:string);
 {
 prints matrix; after each nl elements prints new line
 m - cols count
 n - rows count
 y - row start point for grid
 }
 var i,j,k,l:word;
  Begin
  // adjust the grid size
   if form1.StringGrid1.ColCount<m then form1.StringGrid1.colCount:=m+1;      application.processMessages;
   if form1.StringGrid1.RowCount<y+n+1 then form1.StringGrid1.rowCount:=y+n+2;application.processMessages;
   Writeln(reportFile,#13#10,comment);
   form1.StringGrid1.cells[0,y]:=comment;                                     application.processMessages;
   inc(y);
   for i:=0 to m-1 do
    begin
     for j:=0 to n-1 do  with form1.StringGrid1 do
      begin
       if ((j+1) mod nl)<>0 then
        begin
         Write(reportFile,A[i,j]:10:5);
         col:=j mod nl;                 application.processMessages;
         row:=i+(j+1) div nl+y;         application.processMessages;
         form1.StringGrid1.cells[col+1,row]:=floatTostrF(A[i,j],ffGeneral,10,5); application.processMessages;
        end
       else Writeln(reportFile);
      end;{for j}
     Writeln(reportFile);
    end;{for i}
    inc(y,n*(((m-1) div nl)+1)+1); //move start point for grid
   flush(reportFile)
  End;

  procedure MTXUNIT(var R:TM;n:word);
   var i,j:word;
   Begin
    for i:=0 to n-1 do
     for j:=0 to n-1 do
      if i=j then R[i,j]:=1
      else R[i,j]:=0;
   End; {MTXUNIT}

  procedure MTXEQU(A,B:TM;n,m:word);
  var i,i1,j,J1,J2,k,k1,l : byte;
                AMAX,save : double;

   Begin
//Write original Matrices A and B
    MTXWRT(A,n,n,nl,gridStart,'Matrix A');
    MTXWRT(B,n,m,nl,gridStart,'Matrix B');
//Reduction of matrix A
//Steps of reduction are counted by index k

//search for largest coefficient of a (denoted by amax)
//in first column of reduced system
    for k:=0 to n-2 do  //do 90
     begin
      amax:=0;
      J2:=k;
      for J1:=k to n-1 do
       begin
        if  abs(amax)-abs(a[j1,k])<0 then
         begin
{10}      AMAX:=A[J1,k];
          J2:=J1
         end;{if}
       end;{for j1 20}

//exchange row nbr k with row nbr J2 if necessary
     if (J2-k)<>0 then
      begin
{30}   for j:=k to n-1 do
        begin
         save:=A[k,j];
         A[k,j]:=A[j2,j];
{40}     A[j2,j]:=save;
        end;{for j 40}
       for j:=0 to m-1 do
        begin
         save:=B[k,j];
         B[k,j]:=B[j2,j];
{50}     B[J2,j]:=save;
        end;{for j 50}
      end;{if J2<>k}

//write A and B (rows exchanged) before step k
      MTXWRT(A,n,n,nl,gridStart,'Rows exchanged'#13#10'Matrix A');
      MTXWRT(B,n,m,nl,gridStart,'Matrix B');

//Actual reduction
{60} k1:=k+1;
     for i:=k1 to n-1 do  //do 80
      begin
       for j:=k1 to n-1 do //do 70
{70}    A[i,j]:=A[i,j]-A[k,j]*A[i,k]/A[k,k];
       for j:=0 to m-1 do //do 80
{80}    B[i,j]:=B[i,j]-B[k,j]*A[i,k]/A[k,k];
      end;{for i 80}

//write A and B after step k of reduction
      MTXWRT(A,n,n,nl,gridStart,'Step '+intToStr(k+1)+' of reduction'#13#10'Matrix A');
      MTXWRT(B,n,m,nl,gridStart,'Matrix B');
{90}end;{for k 90}

//back substitution
    for j:=0 to m-1 do //do 110
     begin
      B[n-1,j]:=B[n-1,j]/A[n-1,n-1];
      if n-1>0 then
{95}   for i1:=0 to n-2 do  //do 110
        begin
         i:=n-i1-2;
         for l:=i+1 to n-1 do //do 100
{100}     B[i,j]:=B[i,j]-A[i,l]*B[l,j];
         B[i,j]:=B[i,j]/A[i,i];
        end;{for i1  110}
{110}end;{for j 110}

//write result
    MTXWRT(B,n,m,nl,gridStart,'Matrix X');
   End;{MTXEQU}

   procedure testEquation;
    var MA,MB:TM;  comment:string;
    Begin
     setLength(MA,4,4);
     setLength(MB,4,3);
     comment:='First example';
     Writeln(reportFile,#13#10,comment);
     form1.StringGrid1.cells[0,gridStart]:=comment;                                application.processMessages;
     inc(gridStart);
     MA[0,0]:=4; MA[0,1]:=2; MA[0,2]:=3; MA[0,3]:=1;
     MA[1,0]:=1; MA[1,1]:=2; MA[1,2]:=3; MA[1,3]:=4;
     MA[2,0]:=3; MA[2,1]:=4; MA[2,2]:=1; MA[2,3]:=2;
     MA[3,0]:=2; MA[3,1]:=1; MA[3,2]:=3; MA[3,3]:=4;

     MB[0,0]:=2; MB[0,1]:=1; MB[0,2]:=0;
     MB[1,0]:=1; MB[1,1]:=4; MB[1,2]:=0.5;
     MB[2,0]:=2; MB[2,1]:=3; MB[2,2]:=0;
     MB[3,0]:=0; MB[3,1]:=0; MB[3,2]:=1;
     MTXEQU(MA,MB,4,3);
      //Results should be:
      MB[0,0]:=-0.21667;  MB[0,1]:= -1.85000;  MB[0,2]:= 0.20833;
      MB[1,0]:= 0.78333;  MB[1,1]:=  2.15000;  MB[1,2]:=-0.29167;
      MB[2,0]:= 0.61667;  MB[2,1]:=  1.65000;  MB[2,2]:=-0.20833;
      MB[3,0]:=-0.55000;  MB[3,1]:= -0.85000;  MB[3,2]:= 0.37500;
      MTXWRT(MB,4,3,5,gridStart,'Results should be:');
      //Next example: 2x+3y=7 and x-2y=3
      comment:='Second example: 2x+3y=7 and x-2y=3';
      Writeln(reportFile,#13#10,comment);
      form1.StringGrid1.cells[0,gridStart]:=comment;                                application.processMessages;
      inc(gridStart);
      MA[0,0]:=2; MA[0,1]:=3;  MA[0,2]:=0;
      MA[1,0]:=1; MA[1,1]:=-2; MA[1,1]:=0;
      MB[0,0]:=7;
      MB[1,0]:=3;
      MTXEQU(MA,MB,2,1);
        MB[0,0]:=3+2/7;
      MB[1,0]:=1/7;
      MTXWRT(MB,2,1,3,gridStart,'Results should be:');
    End;
    procedure testInvertion;
    var MA,MB:TM;
    Begin
     setLength(MA,3,3);
     setLength(MB,3,3);
     MA[0,0]:=1; MA[0,1]:=2; MA[0,2]:= 3;
     MA[1,0]:=2; MA[1,1]:=1; MA[1,2]:=-2;
     MA[2,0]:=1; MA[2,1]:=1; MA[2,2]:= 2;
     MTXUNIT(MB,3);
     MTXEQU(MA,MB,3,3);
     //results should be:
      MB[0,0]:=-0.80000;   MB[0,1]:=0.20000;   MB[0,2]:=1.40000;
      MB[1,0]:=1.20000;    MB[1,1]:=0.20000;  MB[1,2]:=-1.60000;
      MB[2,0]:=-0.20000;   MB[2,1]:=-0.20000;  MB[2,2]:=0.60000;
      MTXWRT(MB,3,3,4,gridStart,'Reverted matrix should be:');
    End;
  end.

  

