unit inverter;

interface
uses dialogs,StdCtrls, windows,math,messages,Forms,sysUtils,controls, ExtCtrls;
 var
                      dataDir : string ='C:\APL\LVQ\invertMatrix\data\data.txt';
                   reportDir : string ='C:\APL\LVQ\invertMatrix\results\report.txt';
                   programDir : string;
 initFile,dataFile,reportFile : textFile;
                   featureNbr : byte;
                      stepArr : array[byte] of word;
                         rarr : array[byte] of double;

 function correl(l,fCounter,sum:word):double;
 function saveDialog(dialog:TSaveDialog;var s:String; fltIdx:byte;const tit:string):boolean;
 procedure readAndProceedData;

implementation
 uses unit1,formUnit;
 function saveDialog(dialog:TSaveDialog;var s:String; fltIdx:byte;const tit:string):boolean;

 var decision:byte;

   Begin   {---------otwiera okno saveDialog--------------}
    decision:=mrYes;
    repeat
     with Dialog do
     begin
      Title:=tit;     FilterIndex:=fltIdx;
      initialDir:=s;  fileName:=s;
      if execute then s:=fileName
     end;
     if fileExists(s) then
      begin
       decision:=messageDlg('File:'#13#10'"'+s+'"'#13#10'exists. Overwrite it?',mtConfirmation,[mbYes,mbNo,MbCancel],0);
       result:=decision=mrYes;
      end
     else result:=true;
    until result or (decision=mrCancel);
   End;{saveDialog}

 function correl(l,fCounter,sum:word):double;
  Begin
   inc(l); //bo liczba klas jest o 1 wiksza od liczby krokw, a l jest tu liczb krokw postpowania kwantujcego
   correl:=2*((l*fCounter-sum)/(l*(l-1)))
  End;

 procedure saveResults(fCounter,featureNbr:byte);
  var i:byte;
  Begin
   write(reportFile,featureNbr);
   case  featureNbr of
    1:writeln(reportFile,' -st feature');
    2:writeln(reportFile,' -nd feature');
    3:writeln(reportFile,' -rd feature');
    else writeln(reportFile,' -th feature');
   end;
   for i:=1 to fCounter do write(reportFile,stepArr[i]:7,#9);writeln(reportFile);
   for i:=1 to fCounter do write(reportFile,rArr[i]:7:5,#9);writeln(reportFile);
   flush(reportFile);
  End;

 procedure readAndProceedData;
  var s:string;
  l,k,fCounter,sum,totalClassNbr : word;
  r:double;
  begin
   dataDir:= form1.OpenDialog1.FileName;
   with form1 do caption:=caption+'.  Analysed data: "'+dataDir+'"';
   assignFile(dataFile,dataDir);
   if not fileExists(dataDir) then begin showMessage('No data file exists or the path is wrong'); exit end;
   reset(dataFile);
   readln(dataFile,totalClassNbr);
   readln(dataFile,s);
   repeat
    read(dataFile,featureNbr);  fCounter:=0;  sum:=0;
    while not seekeoln(dataFile) and not seekEof(dataFile) do
     Begin
      read(dataFile,l);
      inc(sum,l);
      inc(fCounter);
      r:=correl(l,fCounter,sum);
      stepArr[fCounter]:=l;
      rArr[fCounter]:=r;
     End;{while}
    readln(dataFile);
    r:=correl(totalClassNbr,fCounter,sum);     //na koniec wiersza obliczamy r dla cakowitej iloci klas
    inc(fCounter);
    stepArr[fCounter]:=totalClassNbr;
    rArr[fCounter]:=r;
    saveResults(fCounter,featureNbr);
   until seekEof(dataFile);
   close(reportFile);
  end;

end.

interface
uses dialogs,StdCtrls, windows,math,messages,Forms,sysUtils,controls, ExtCtrls;
 var
                      dataDir : string ='C:\APL\LVQ\invertMatrix\data.txt';
                   reportDir : string ='C:\APL\LVQ\invertMatrix\report.txt';
                   programDir : string;
initFile,dataFile,reportFile : textFile;
                   featureNbr : byte;
                      stepArr : array[byte] of word;
                         rarr : array[byte] of double;
 function correl(l,fCounter,sum:word):double;
 function saveDialog(dialog:TSaveDialog;var s:String; fltIdx:byte;const tit:string):boolean;

implementation

 function saveDialog(dialog:TSaveDialog;var s:String; fltIdx:byte;const tit:string):boolean;

 var decision:byte;

   Begin   {---------otwiera okno saveDialog--------------}
    decision:=mrYes;
    repeat
     with Dialog do
     begin
      Title:=tit;     FilterIndex:=fltIdx;
      initialDir:=s;  fileName:=s;
      if execute then s:=fileName
     end;
     if fileExists(s) then
      begin
       decision:=messageDlg('File:'#13#10'"'+s+'"'#13#10'exists. Overwrite it?',mtConfirmation,[mbYes,mbNo,MbCancel],0);
       result:=decision=mrYes;
      end
     else result:=true;
    until result or (decision=mrCancel);
   End;{saveDialog}

 function correl(l,fCounter,sum:word):double;
  Begin
   inc(l); //bo liczba klas jest o 1 wiksza od liczby krokw, a l jest tu liczb krokw postpowania kwantujcego
   correl:=2*((l*fCounter-sum)/(l*(l-1)))
  End;
end.
