﻿unit setEditService;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Label1: TLabel;
    Button1: TButton;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Button2: TButton;
    Edit2: TEdit;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Button3: TButton;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    procedure Edit2KeyPress(Sender: TObject; var Key: Char);
    procedure Edit2Exit(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Label5Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure FormCreate(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
type ToutSet = set of byte;
var   outSetIn : ToutSet=[]; outSetEx : ToutSet=[];

function SetConstructorReconstruction(const outSet:ToutSet):shortString;
{
na podstawie danego zbioru outSet tworzy jego konstruktor s1
}
var i,e1,e2 : integer;
         s1 : shortString;
       dots : boolean;
 Begin
  e1:=0; e2:=0; s1:='';  dots:=false;
  for i:=0 to high(byte) do
   if i in outset then
    begin
     e2:=i; e1:=i;
     s1:=s1+intToStr(i);
     break;
    end;{1-wszy element}
  for i:=e2+1 to high(byte) do
   if i in outset then
    Begin
     e2:=i;
     if e2-e1=1 then         //-------dodaj 2 kropki lub granice przedzialu
      if not dots then begin s1:=s1+'..'; dots:=true; end
      else
     else
      begin
       if dots then begin s1:=s1+intToStr(e1); dots:=false end;
       s1:=s1+','+intToStr(i);
      end;
     e1:=i;
    End; {for}
  if dots then s1:=s1+intToStr(e1);// else s1:=s1+','+intToStr(e1);
   SetConstructorReconstruction:=s1;
 End;{SetConstructorReconstruction}

procedure deleteLastChar(var s1:shortstring; edit:Tedit;str:shortString);
 var l:byte;
 Begin {------------------nie jest cyfra ani kropka}
  if str<>'' then showMessage(str);
  s1:=edit.text;
  l:=length(s1);
  if l=0 then exit;
  if s1[l] in ['0'..'9'] then exit;//aby nie usuwać cyfr kończących konstruktor
  delete(s1,l,1);
  edit.text:=s1;              //tu po tekscie 1..4,3..9, i Enter, label1 zmienia tekst z 1..9 na 1..4 (bez widocznego powodu!!)****
  l:=length(edit.text);      //mimo iż nie ma instrukcji dotyczących tej etykiety, bo WCHODZI DO ZDARZENIA ON CHANGE DLA EDIT!!!
  edit.SelStart:=l; //bo kursor po tej operacji ustawia sie na poczatku tekstu!
  application.ProcessMessages;
 End;

function setConstructor(var s1:shortString;edit:Tedit;labelx:Tlabel):ToutSet;
 {
 na podstawie konstruktora (tj. tekstu zapisanego w oknie edycyjnym edit.text)
 tworzy zbiór OutSet
 }
var       s2 : shortstring;
j,k,l,m,dots : integer;
         fig : set of char;
      ch,last : char;
            c : integer;
       outset : Toutset;
procedure intoSet;
 begin
  val(s2,j,c); if (j<0) or (j>255) then showMessage('Only numbers from the range <0..255> are allowed here!');
  if c<>0 then begin showMessage(s2+' is not a number!'); exit end;
  s2:='';
  include(outset,j);
 end;{intoSet}

procedure insertDot;
 Begin    {-----------------------------tylko 1 kropka}
  insert('.',s1,k-1);
  edit.text:=s1;
  showMessage('There was only 1 dot!'+#13#10'another 1 was added');
  dots:=0;
  edit.SelStart:=length(edit.text);  //bo kursor po tej operacji ustawia sie na poczatku tekstu!
 End;{insertDot}

 var r1,r2:byte;
 procedure analyseAndAdd;
 var m:byte;
  Begin
   if not (last in fig) and (last<>#0) then deleteLastChar(s1,edit,'Comma can follow figures only!')  //#0 aby nie usuwac przecinka, gdy oknoedycyjne jest puste
   else
    if last in fig then
     if dots = 2 then  {wprowadz zakres elementow}
      begin
       val(s2,r2,c);  if c<>0 then showMessage(s2+' is not a number!'); s2:='';
       if (r2<0) or (r2>255) then showMessage('Only numbers from the range <0..255> are allowed here!');
       if r1<r2 then for m:=r1 to r2 do include(outSet,m)  {*************}
       else
        begin
        deleteLastChar(s1,edit,'Warning!'#13#10'Upper range bound (='
         +intToStr(r2)+') should be higher then bottom one (='+intToStr(r1)+
         ')!');
        end;
       dots:=0;
      end {dots=2}
     else
      if dots=1 then insertDot
      else intoSet                                        {*************}
     else intoSet;                                        {*************}
  End;{analyseAndAdd}

BEGIN //=============================setConstructor ===================
 l:=length(s1);
 s2:='';  dots:=0;   outSet:=[];
 last:=#0;  r1:=0;
 fig:=['0','1','2','3','4','5','6','7','8','9'];
 k:=0;    outSet:=[];
 while k<l do   {ponownie analizuj caly tekst w Edit}
  Begin
   inc(k);
   ch:=s1[k];
   if ch in fig then
    begin              {------------------------------cyfra}
     s2:=s2+s1[k];
      if (last='.') and (dots=1) then insertDot;
    end{ch in fig}
   else
    begin
     case ch of
      ',' : analyseAndAdd;
      '.' : if (not (last in fig)) and (last<>'.') then  deleteLastChar(s1,edit,'Only figure is allowed here!')
            else
             if dots>=2 then
              begin
               if last in fig then deleteLastChar(s1,edit,'Comma or figure allowed here!')
               else                deleteLastChar(s1,edit,'Too much dots!, only 2 are allowed'#13#10'1 dot was deleted')
              end
             else
              begin
               inc(dots);
               if dots>1 then continue;
               val(s2,r1,c); if c<>0 then showMessage('"'+s2+'" is not a number!'); s2:='';
               if (r1<0) or (r1>255) then showMessage('Only numbers from the range <0..255> are allowed here!');
              end
      else  deleteLastChar(s1,edit,'Character "'+ch+'" not allowed here, it will be deleted');
     end;{case}
    end;{else ch in fig}
   last:=ch;
  End;{while}
 labelx.Caption:=SetConstructorReconstruction(outSet); application.ProcessMessages;
 setConstructor:=outSet;
End; {setConstructor}

function finishConstruction(edit:Tedit;labelx:Tlabel; outSet:Toutset):Toutset;
{
Kończy interpretację konstruktora zbioru (tj. tekstu edit.Text)
}
var s1,s2:shortString; set1:Toutset; k:byte;
Begin
 outSet:=[];
 with form1 do
   Begin
     s1:=edit.Text;
     //if s1='' then exit;
     if s1[length(s1)]='.' then
     begin
      showMessage('All last dots will be removed (after dots  should follow upper range boundary)');
      while s1[length(s1)]='.' do delete(s1,length(s1),1);
      edit.Text:=s1;
     end;{if}
     if s1[length(s1)]=',' then                                  //odtworzyc tylko konstruktora, gdy na koncu wpisano przecinek
      begin
       s2:=SetConstructorReconstruction(outSet);
       deleteLastChar(s1,edit,'last comma will be deleted');     //ta instr. zmienia też tekst etykiety, więc zapamiętano ją w s2 celem przywrócenia
       labelx.Caption:=s2;
       application.ProcessMessages;
       exit
      end;
     s1:=s1+',';   application.ProcessMessages;    //chwilowo dodac przecinek, aby zaladowac do zbioru
     outSet:=setConstructor(s1,edit,labelx);
     deleteLastChar(s1,edit,'');
     edit.SelStart:=length(edit.text);   //ustawia kursor na końcu textu w edit
   End;{with}
  finishConstruction:=outSet;
End;{finishConstruction}

procedure TForm1.Edit1Change(Sender: TObject);
var s:shortString;
 Begin
 s:=edit1.Text;
 outSetIn:=setConstructor(s,edit1,label1);
End;

procedure OnEditExit(Edit:tedit;labelX,labelY:Tlabel;var outSetIn, outSetEx:ToutSet);
 begin
  outSetIn:=finishConstruction(edit,labelX,outSetIn);
  labelY.caption:=SetConstructorReconstruction(outSetIn-outSetEx);
 end;

procedure TForm1.FormCreate(Sender: TObject);
begin
edit1.Text:='0..255';
edit2.Text:='';
label1.Caption:='________';
label8.Caption:='________';
label10.Caption:='________';
OnEditExit(Edit1,label1,label10,outSetIn, outSetEx);
end;


procedure TForm1.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
 if key<>#13 then exit;
 outSetIn:=finishConstruction(edit1,label1,outSetIn);
 label10.caption:=SetConstructorReconstruction(outSetIn-outSetEx);
end;

procedure TForm1.Edit1Exit(Sender: TObject);
begin
 OnEditExit(Edit1,label1,label10,outSetIn, outSetEx);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 halt
end;

procedure TForm1.Label5Click(Sender: TObject);
begin
showMessage('Hi,'#13#10'             All rights reserved                   '#13#10+
            #13#10'                            Andrzej Pluciński'#13#10);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
ShowMessage('You can introduce set members using commas and double dots as'+
' separators,'#13#10'exactly like for the Pascal set constructor with the'+
' exception that you do not need to close it with brackets')
end;

procedure TForm1.Edit2Change(Sender: TObject);
var s:shortString;
begin
 s:=edit2.Text;
 outSetEx:=setConstructor(s,edit2,label8);
end;

procedure TForm1.Edit2Exit(Sender: TObject);
begin
 outSetEx:=finishConstruction(edit2,label8,outSetEx);
 label10.caption:=SetConstructorReconstruction(outSetIn-outSetEx);
end;

procedure TForm1.Edit2KeyPress(Sender: TObject; var Key: Char);
begin
 if key<>#13 then exit;
 outSetEx:=finishConstruction(edit2,label8,outSetEx);
 label10.caption:=SetConstructorReconstruction(outSetIn-outSetEx);
end;

end.

