unit MegaSets;

interface

 type
  TarrSet = array of byte;// megaSets container
 function inMegaSet(i:longword;s:TarrSet):boolean;
procedure includeToMegaSet(var s:TarrSet;i:longword);
procedure excludeFromMegaSet(i:longword; var s:TarrSet);
procedure sumMegaSet(set1,set2:TarrSet;var result:TarrSet);
procedure MegaSetInterSection(set1,set2:TarrSet; var result:TarrSet);
 function diffMegaSet(set1,set2:TarrSet):TarrSet;
 function cardMegaSet(s:TarrSet):longword; //computes number of members of a megaset
 function MegaSetContent(const s:TarrSet):string;
procedure emptyMegaSet(var result:TarrSet);
 function compareMegaSet(set1,set2:TarrSet):boolean;
 function MegaSetConstructorReconstruction(const outSet:TarrSet):string;
 function MegaSetConstructor(var s1:string):TArrSet;
procedure copyMegaSet(var set1,set2:TarrSet);
 var control1,control2,control3 : int64;
implementation

uses sysUtils,dialogs,forms,MegasetTestUnit1;

 procedure ilmn(const i:longword;var l,m,n:longword);
 {
 Evaluates a position of a bit which represent given member of a set. In order to do this:
  - finds an elements number of container in which this bit sits,
  - finds the bits number in this elements,
  - makes a mask which enables to reach this bit and only this
 }
  Begin
   m:=i div 8;     //find nbr of an element of container
   n:=i mod 8;    //find nbr of a bit in the element of container
   l:=1 shl n;   //create a mask for setting or for reading the bit
  End;{lmn}

 function inMegaSet(i:longword;s:TarrSet):boolean;
 //checks whether i belongs to a set "s"
  var l,m,n:longword;
   Begin
    result:=false;
    l:=high(s);
    try
    ilmn(i,l,m,n);                                 //show m-th byte and a n-th bit, which would denote present of a number "i" in a given megaSet "s". (Wska bajt m oraz bit n, ktry odnotowywaby obecno liczby i w megasecie)
    if m<=high(s) then result:=s[m] and l=l;       //s[m]-m-th element of container; l= 2^n, so it is a number with one bit set to true.
    except                                         //this relationship occures, when the n-th bit is set to true
    showMessage('Some error occured in the function "inMegaSet", program error, turn to the author');
    end;
   end;{inMegaSet}

  procedure includeToMegaSet(var s:TarrSet;i:longword);
 //wcza liczb i do zbioru
  var l,m,n:longword;
  Begin
   ilmn(i,l,m,n);               //number, mask, member, bit
   if m<=high(s) then s[m]:=l or s[m]
   else showMessage('Procedure "IncludeToMegaSet", program error.'#13#10'Number '+intToStr(m)+
   ' could not be included to set because was too big (because of lack of the target container capacity).'#13#10+
   'Numbers should be<='+intToStr(high(s)));
  End;{includeToMegaSet}

 procedure excludeFromMegaSet(i:longword; var s:TarrSet);
 //throws out a number i from a set s
  var l,m,n:longword;
   begin
    try
    ilmn(i,l,m,n);              //liczba, maska, skadnik, bit
    if m<=high(s) then
     s[m]:=not l and s[m];    // every one byte can contain 8 elements
    except
     showMessage('An error occured in procedure "excludeFromMegaSet"');
    end;
   end;{excludeFromMegaSet}

function diffMegaSet(set1,set2:TarrSet):TarrSet;
  //computes difference betweeh sets, i.e. set1-set2
  //8*high(s)+7=8*(high(s)+1)-1=(number of bits)-1; -1 because the bits are counted from 0
   var i,j,k:longword;  tmpSet:TarrSet;
    begin
     i:=high(set1); j:=high(set2);
     if i<j then j:=i;
     setLength(tmpSet,i+1);
     for k:=0 to i do tmpSet[k]:=set1[k];
     setLength(result,i+1);                //to separate result from arguments
     k:=8*j+7;
     for i:=0 to k do
      if inMegaSet(i,set2) then
       excludeFromMegaSet(i,tmpSet);
     for i:=0 to high(tmpSet) do result[i]:=tmpSet[i];
    end;{diffMegaSet}

 function cardMegaSet(s:TarrSet):longword;
 //counts number of a set members (more precisely - a number of bits set to 1)
  var k:longword;
  begin
   result:=0;
   k:=8*length(s)-1;
   for k:=0 to k do
    if inMegaSet(k,s) then inc(result);
  end;{cardMegaSet}

 function MegaSetContent(const s:TarrSet):string;
 {
 Shows sets members represented by the "s" container content
 }
  var i:longWord;
  begin
   result:='';
   i:=8*length(s)-1;
   for i:=0 to i do
    if inMegaSet(i,s) then result:=result+intTostr(i)+', ';
    i:=length(result); //debug prp
    delete(result,length(result)-1,1);
  end;

 procedure copyMegaSet(var set1,set2:TarrSet);
   var i,j:longWord;
    begin
     i:=high(set1); j:=high(set2);
     if j<=i then
      for i:=0 to high(set2) do set1[i]:=set2[i]
     else
      begin
       for i:=0 to high(set1) do set1[i]:=set2[i];
       ShowMessage('copyMegaSet: Set2 is of greater capacity than Set1, so, may be, not all components from the Set2 were copied to the Set1');
      end;
    end; {copyMegaSet}

 procedure emptyMegaSet(var result:TarrSet);
  var i:longInt;
  Begin
   i:=high(result);
   if i<0 then begin showMessage('procedure emptyMegaSet, a set which should be empted, was not allocated RAM, correct the program!'); exit end;
   for i:=0 to high(result) do result[i]:=0
  End;{emptyMegaSet}

 function compareMegaSet(set1,set2:TarrSet):boolean;
  {
  compares megasets both of aequal or different capacities
  }
  var i,j,k:longword;
  begin
   j:=high(set1); k:=high(set2);
   result:=true;
   if j=k then
    begin
     for i:=0 to j do
      if set1[i]<>set2[i] then begin result:=false; exit end;
    end
   else   //j<>k
    begin
     if j>k then
      begin
       for i:=0 to k do
        if set1[i]<>set2[i] then begin result:=false; exit end;
        for i:=k+1 to j do if set1[i]<>0 then begin result:=false; exit end; // if result then
      end
     else  //k>j
      begin
        for i:=0 to j do
        if set1[i]<>set2[i] then begin result:=false; exit end;
        for i:=j+1 to k do if set2[i]<>0 then begin result:=false; exit end;   // if result then
      end;
    end;{j<>k}
  end;{compareMegaSet}

 procedure sumMegaSet(set1,set2:TarrSet;var result:TarrSet);  //130320
  var k:longword;
  begin
   emptyMegaSet(result);
   k:=8*high(result)+7;
   for k:=0 to k do
   if inMegaSet(k,set1) or inMegaSet(k,set2) then includeToMegaSet(result,k)
 end;

 procedure MegaSetInterSection(set1,set2:TarrSet; var result:TarrSet);
  var k:longword;
  begin
   emptyMegaSet(result);
   if (high(set1)<0) or (high(set2)<0)  then showMessage('procedure "MegaSetInterSection", at least one of data container was not allocated RAM'#13#10'Program error, turn to the author');
   if high(set1)<high(set2) then k:=length(set1) else k:=length(set2);
   setLength(result,k);
   k:=8*k-1;
   for k:=0 to k do
    if inMegaSet(k,set1) and inMegaSet(k,set2) then includeToMegaSet(result,k)
 end;

 function MegaSetConstructorReconstruction(const outSet:TarrSet):string;
{
Creates a constructor of a given set (na podstawie danego zbioru outSet tworzy jego konstruktor s1)
}
var i,j,e1,e2 : integer;
         s1 : string;
       dots : boolean;
 Begin
  e1:=0; e2:=0; s1:='';  dots:=false;
  j:=8*length(outSet)-1;
  for i:=0 to j do
   begin
  // control:=i;
   if inMegaSet(i, outset) then
    begin
     e2:=i; e1:=i;
     s1:=s1+intToStr(i);
     break;
    end;{1-th object (1. element)}
   end;{for}
  for i:=e2+1 to j do
   begin
  // control:=i;
   if inMegaSet(i,outset) then
    Begin
     e2:=i;
     if e2-e1=1 then         //-------add 2 dots or  range bounds (dodaj 2 kropki lub granice przedzialu)
      if not dots then begin s1:=s1+'..'; dots:=true; end
      else
     else
      begin
       if dots then begin s1:=s1+intToStr(e1); dots:=false end;
       s1:=s1+','+intToStr(i);
      end;
     e1:=i;
    End; {for}
    end;
  if dots then s1:=s1+intToStr(e1);
  result:='['+s1+']';
 End;{MegaSetConstructorReconstruction}


 function MegaSetConstructor(var s1:String):TArrSet;
 { Create a set on a basis of a given set constructor
 na podstawie konstruktora (tj. tekstu zapisanego w oknie edycyjnym edit.text)
 tworzy zbir OutSet
 }
var                s2 : string;
    j,k,setRange,dots : integer;
                  fig : set of char;
              ch,last : char;
                    c : integer;
       outset,lastSet : TarrSet;

procedure intoSet;
 begin
  val(s2,j,c);
  if (j<0) or (j>setRange) then
   begin
    showMessage('intoSet: Only numbers from the range <0..'+intToStr(setRange)+'> are allowed here!, but you have written j='+intToStr(j)+'.');
    exit
   end;
   if (c<>0) and (s2<>'') then
   begin
    showMessage('intoSet: "'+s2+'" is not a number!');
    exit
   end;
  if (c=0) and (s2<>'') then
   if inMegaSet(j,outSet) then
   else includeToMegaSet(outset,j);     //includeToMegaSet(var s:TarrSet;i:longword);
 end;{intoSet}

 var r1,r2:Integer;

 procedure analyseAndAdd(k:byte);
  var m:longWord;
  setInsert,tmpSet : TarrSet;
   Begin
    setLength(setInsert,setRange div 8+1);
    setLength(tmpSet,setRange div 8+1);
    emptyMegaSet(setInsert);emptyMegaSet(tmpSet);
    if dots = 2 then  //introduce range of objects numbers (wprowad zakres elementw)
     begin
      val(s2,r2,c);
      if (c<>0) and (s2<>'') then
      begin
       showMessage('analyseAndAdd:"'+s2+'" is not a number!'); delete(s2,c,1);
       exit
      end;
      if (r2<0) or (r2>setRange) then
       begin
        showMessage('Only numbers from the range <0..'+intToStr(setRange)+'> are allowed here!, but you have written r2='+intToStr(r2)+'.');
        exit
       end;
      control1:=r1; control2:=r2; control3:=high(setInsert);   //debug prp
      if r1<r2 then
       for m:=r1 to r2 do
        begin
         control1:=m;     //debug prp
         includeToMegaSet(setInsert,m)
        end
      else   for m:=r2 to r1 do includeToMegaSet(setInsert,m);
      sumMegaSet(outSet,setInsert,tmpSet);      //sumSet(set1,set2:TarrSet;var result:TarrSet);
      copyMegaSet(outSet,tmpSet);
     end {dots=2}
    else
     if dots=1 then
      begin
       insert('.',s1,k-1);
       MegaSetConstructor(s1);
      end
     else intoSet; // (last in fig set)
   End;{analyseAndAdd}

  function range(s:string):longint;
  //each sign from outside of the set fig is treated as an end of the record of some number particularly also the space             (kady znak spoza bioru fig jest traktowany jako koniec zapisu liczby, w szczegolnoci take spacja)
  //function "range" should be called after clearing (i.e. removing erronous sign) of a content of a given set constructor content (funkcje range woa po oczyszczeniu danego konstruktora zbioru)
   var i:word; s1:string; figFound:boolean;
   begin
    i:=length(s); //debug prp
    if i=0 then begin result:=0;exit end;
    i:=0;  s1:=''; result:=0;  figFound:=false;
    repeat
    inc(i);
    if s[i] in fig then //['0','1','2','3', '4','5','6','7','8','9']
     begin
      s1:=s1+s[i]; figFound:=true;
     end
     else
      if figFound then
      begin
       if strToint(s1)>result then result:=strToint(s1);
       s1:='';
       figFound:=false;
      end;
    until i>=length(s);
    if figFound then
       if strToint(s1)>result then result:=strToint(s1);
   end;{range}

var nextOperand:char; l:word; sc:string;  i:byte;

BEGIN //=============================MegaSetConstructor ===================
fig:=['0','1','2','3','4','5','6','7','8','9'];
//clear given set constructor
 k:=0;
 if s1<>'' then
   while not(s1[1] in fig) do     //(length(s1)>0) is the must, because s[1] will have a random value may be not from fig and the program will hang here when the edit window will be empty!!!
    begin
    delete(s1,1,1);
    if (length(s1)=0) then break;
    end;
 if (length(s1)>0) then
  repeat
   inc(k);
   if not (s1[k] in fig+['.',',']) then
    begin delete(s1,k,1); dec(k) end;
  until(k>=length(s1)) or (length(s1)=0);

setRange:=range(s1);
k:=setRange div 8+1;
 setlength(outSet,k);      setlength(lastSet,k);setlength(result,k);
 s2:='';  dots:=0;   emptyMegaSet(outSet);
 last:=#0;  r1:=0;nextOperand:=#0;  emptyMegaSet(lastSet);//:=[];
 k:=1;  l:=length(s1);
 while k<=l do   {analyse ab ovo (ponownie analizuj caly tekst w Edit)}
  Begin
   ch:=s1[k]; sc:='';
   if ch in fig then
    begin              {------------------------------figure}
     while (ch in fig) and (k<=l) do     //k<, because the loop exceedes analysed strig on the contrary
      begin
       s2:=s2+s1[k];
       inc(k);
       if k<=l then ch:=s1[k];
      end;
     dec(k);
     ch:=s1[k];      //in order to enable to increase "dots" (aby mc powikszy "dots")
     if (last='.') and (dots=1) then
      begin
       insert('.',s1,k-1);
       MegaSetConstructor(s1);
      end;
     analyseAndAdd(k);
    end{ch in fig}
   else
    begin
     case ch of
      ',' : begin
             if not (last in fig) then
              begin
               setLength(sc,k);
               for i:=1 to k do sc[i]:=s1[i];
               ShowMessage('Procedure "MegaSetConstructor" error: Here "'+sc+'" Comma can follow digits only! (now it follows the "'+last+'")');
               exit;
              end;
             nextOperand:='.';
             if dots in [0,2,3] then copyMegaSet(lastSet,outSet);
             s2:='';   dots:=0;
            end;
      '.' :  Begin
              if nextOperand=',' then   //construction of the form a..b..c not allowed
               begin
                setLength(sc,k);
                for i:=1 to k do sc[i]:=s1[i];
                ShowMessage('MegaSetConstructor error: Only digit or comma  is allowed here or too much dots, i.e. "'+sc+'"! You have written the "'+ch+'"');
                exit
               end;
              if (not (last in fig+['.'])) and (k>1) then
              begin
               setLength(sc,k);
               for i:=1 to k do sc[i]:=s1[i];
               ShowMessage('MegaSetConstructor error: Only digit is allowed here, i.e. "'+sc+'"! You have written the "'+ch+'"');
               exit
              end
             else
              begin
               if last in fig then dots:=0;
               if dots>=2 then
                begin
                 if (last in fig)  then
                 begin
                  setLength(sc,k);
                  for i:=1 to k do sc[i]:=s1[i];
                  ShowMessage('MegaSetConstructor error: Comma allowed here, i.e. "'+sc+'"!');
                  exit
                  end
                 else
                  begin
                   setLength(sc,k);
                   for i:=1 to k do sc[i]:=s1[i];
                   ShowMessage('MegaSetConstructor error: Too much dots!, only 2 are allowed here, i.e. "'+sc+'"!');
                   exit
                  end;
                end{dots>=2}
               else
                begin
                 inc(dots);
                 if dots>=2 then nextOperand:=',';
                 if dots>1 then begin inc(k); continue end;
                 val(s2,r1,c);
                 if (c<>0) and (s2<>'') then
                  begin
                   showMessage('setConstructor: "'+s2+'" is not a number!'); s2:='';
                   exit
                  end;
                 if (r1<0) or (r1>setRange) then
                  begin
                   showMessage('MegaSetConstructor: Only numbers from the range <0..'+intToStr(setRange)+'> are allowed here, but you have written r1='+intToStr(r1)+'.');
                   exit
                  end;
                 s2:='';
                end{else dots>=2}
              end;
             End;{case '.'}
      else {case}
       begin
        if ch<>' ' then
        begin
         setLength(sc,k);
         for i:=1 to k do sc[i]:=s1[i];
         ShowMessage('MegaSetConstructor error: Character "'+ch+'" is not allowed here, i.e.'#13#10'"'+sc+'"'#13#10'Check the "'+
         form1.label109.Caption+'" and the "'+form1.Label110.Caption+'" edition windows content.');
         exit
        end;
       end;
     end;{case}
    end;{else ch in fig}
   last:=ch;
   inc(k);
  End;{while}
 copyMegaSet(result,outSet);
End; {MegasetConstructor}

 end.


