unit MegaSets;

interface

 type
  TarrSet = array of byte;//[0..1000] of byte;   120320               //typ przeznaczony na przechowywanie zbiorw
 var
  featureMegaSet,featMegaSetInclude,featMegaSetExclude,
              InsertMegaSet,fissionMegaSet : TarrSet;
  function inMegaSet(i:longword;s:TarrSet):boolean;
 procedure includeToMegaSet(var s:TarrSet;i:longword);
 procedure excludeFromMegaSet(i:longword; var s:TarrSet);
 procedure sumMegaSet(set1,set2:TarrSet;var result:TarrSet);
 procedure MegaSetInterSection(set1,set2:TarrSet; var product:TarrSet);
  function diffMegaSet(set1,set2:TarrSet):TarrSet;
  function cardMegaSet(s:TarrSet):longword;                  //oblicza liczb elementw zbioru
  function MegaSetContent(const s:TarrSet):string;
 procedure emptyMegaSet(var result:TarrSet);         //120320 procedure instead of function
  function SetEmptyCheck(const nc:word):boolean;
  function compareMegaSet(set1,set2:TarrSet):boolean;
  function MegaSetConstructorReconstruction(const outSet:TarrSet):string;
  function MegaSetConstructor(var s1:String):TArrSet;
 procedure copyMegaSet(var set1,set2:TarrSet);
  function featuresMegaSetTotal(MegaSetInclude,MegaSetExclude:TarrSet; const vectorsSize:word; var nc:integer):TArrSet;

implementation

uses sysUtils,dialogs,forms,unit1;
var control1,control2,control3:integer;  //debug prp

 procedure ilmn(const i:longword;var l,m,n:longword);
 {
 Okrela pooenie bitu reprezentujcego dany element zbioru. W tym celu:
  - odszukuje nr elementu pojemnika, w ktrym ten bit jest,
  - numer bitu w tym elemencie,
  - tworzy mask liczbow, pozwalajc dotrze do tego bitu i tylko do niego
 }
  Begin
   m:=i div 8;     //znajd nr elementu pojemnika
   n:=i mod 8;    //znajd nr bitu w elemencie pojemnika
   l:=1 shl n;   //utwrz mask do ustawienia bd odczytu bitu
  End;{lmn}

 function inMegaSet(i:longword;s:TarrSet):boolean;
 //checks whether i belongs to a set "s"
  var l,m,n:longword;
   Begin
    result:=false;
    l:=high(s);
    if l<0 then
     begin
      showMessage('Function "inMegaSet", Processed set does not exists, RAM has not been allocated to it. It is a programm error.'#13#10'The "False" value will be assigned (i.e. informing, that the set does not contain value "'+intToStr(i)+'".');
      exit
     end;
    try
    ilmn(i,l,m,n);                                 //show m-th byte and a n-th bit, which would denote present of a number "i" in a given megaSet "s". (Wska bajt m oraz bit n, ktry odnotowywaby obecno liczby i w megasecie)
    if m<=high(s) then result:=s[m] and l=l;       //s[m]-m-th element of container; l= 2^n, so it is a number with one bit set to true.
    except                                         //this relationship occures, when the n-th bit is set to true
    showMessage('Some error occured in the function "inMegaSet", program error, turn to the author');
    end;
   end;{inMegaSet}

 procedure includeToMegaSet(var s:TarrSet;i:longword);
 //includes a number i into a set s
  var l,m,n:longword;
  Begin
   ilmn(i,l,m,n);               //liczba, maska,skadnik, bit
   if m<=high(s) then s[m]:=l or s[m]
   else showMessage('Procedure "IncludeToMegaSet", program error.'#13#10'Number '+intToStr(m)+
   ' could not be included to set because was too big (because of lack of the target container capacity).'#13#10+
   'Numbers should be<='+intToStr(high(s)));
  End;{includeToMegaSet}

 procedure excludeFromMegaSet(i:longword; var s:TarrSet);
 //throws out a number i from a set s
  var l,m,n:longword;
   begin
    try
    ilmn(i,l,m,n);              //liczba,maska,skadnik, bit
    if m<=high(s) then
     s[m]:=not l and s[m];    // every one byte can contain 8 elements
    except
     showMessage('An error occured in procedure "excludeFromMegaSet"');
    end;
   end;{excludeFromMegaSet}

 function diffMegaSet(set1,set2:TarrSet):TarrSet;
  //computes difference betweeh sets, i.e. set1-set2
  //8*high(s)+7=8*(high(s)+1)-1==(number of bits)-1; -1 because the bits are counted from 0
   var i,j,k:longword;  tmpSet:TarrSet;
    begin
     i:=high(set1); j:=high(set2);
     if i<j then j:=i;
     setLength(tmpSet,i+1);
     for k:=0 to i do tmpSet[k]:=set1[k];   //290520, to separate argument set1
     setLength(result,i+1);                //210520  to separate result from arguments, 310520 i zamiast j
     k:=8*j+7;
     control1:=cardMegaSet(set1);  control2:=cardMegaSet(set2);       //debug prp
     for i:=0 to k do
      if inMegaSet(i,set2) then
       excludeFromMegaSet(i,tmpSet);
     for i:=0 to high(tmpSet) do result[i]:=tmpSet[i];         //310520 to high
    end;{diffMegaSet}

 function cardMegaSet(s:TarrSet):longword;
 //odczytuje liczb elementw (a dokadniej - liczb ustawionych bitw)
  var k:longInt;
  begin
   result:=0;
   k:=8*length(s)-1;
   for k:=0 to k do
    if inMegaSet(k,s) then inc(result);
  end;{cardMegaSet}

 function MegaSetContent(const s:TarrSet):string;
 {
 Pokazuje zbir reprezentowany treci pojemnika s
 }
  var i:longWord;
  begin
   result:='';
   i:=8*length(s)-1;
   for i:=0 to i do
    if inMegaSet(i,s) then result:=result+intTostr(i)+', ';
    i:=length(result); //debug prp
    delete(result,length(result)-1,1);
  end;

 procedure emptyMegaSet(var result:TarrSet);  //120320 procedure instead of function
  var i:longWord;
  Begin
   if high(result)<0 then
    begin
     showMessage('Procedure "emptyMegaSet", a container which should be empted, has not allocated RAM, correct the program! (or turn to the author)');
     exit
    end
   else i:=high(result);  //debug prp
   for i:=0 to high(result) do result[i]:=0
  End;{emptyMegaSet}

function SetEmptyCheck(const nc:word):boolean;
//check whether a features set is not empty
 var emptySet:boolean; i:word;
 Begin
  emptySet:=true;
  for i:=0 to nc do if inMegaSet(i,featureMegaSet) then emptySet:=false;
  result:=(cardMegaSet(featureMegaSet)=0) or emptySet;
 End; {SetEmptyCheck}

  procedure copyMegaSet(var set1,set2:TarrSet);
   var i,j:longWord;
    begin
     i:=high(set1); j:=high(set2);
     if j<=i then
      for i:=0 to high(set2) do set1[i]:=set2[i]
     else
      begin
       for i:=0 to high(set1) do set1[i]:=set2[i];
       ShowMessage('MegaSetCopier: Set2 is of greater capacity than Set1, so, may be, not all components from the Set2 were copied to the Set1');
      end;
    end; {MegaSetCopier}

 function compareMegaSet(set1,set2:TarrSet):boolean;
  {
  compares megasets both of aequal or of different capacities
  }
  var i,j,k:longword;
  begin
   j:=high(set1); k:=high(set2);
   result:=true;
   if j=k then
    begin
     for i:=0 to j do
      if set1[i]<>set2[i] then begin result:=false; exit end;
    end
   else   //j<>k
    begin
     if j>k then
      begin
       for i:=0 to k do
        if set1[i]<>set2[i] then begin result:=false; exit end;
        for i:=k+1 to j do if set1[i]<>0 then begin result:=false; exit end; // if result then
      end
     else  //k>j
      begin
        for i:=0 to j do
        if set1[i]<>set2[i] then begin result:=false; exit end;
        for i:=j+1 to k do if set2[i]<>0 then begin result:=false; exit end;   // if result then
      end;
    end;{j<>k}
  end;{compareMegaSet}

 procedure sumMegaSet(set1,set2:TarrSet;var result:TarrSet);
 //the result container must be of greater or aequl capacity as capatities of a set1 and as capacity of a set2 containers !
  var k:longword;
  begin
   if high(set2)<high(set1) then setLength(result,high(set1)+1) else setLength(result,high(set2)+1);
   emptyMegaSet(result);
   k:=8*high(result)+7;  //????????? 7 ??????
   for k:=0 to k do
   if inMegaSet(k,set1) or inMegaSet(k,set2) then includeToMegaSet(result,k)
 end;

 procedure MegaSetInterSection(set1,set2:TarrSet; var product:TarrSet);
  var k:longWord;
  begin
   if (high(set1)<0) or (high(set2)<0)  then showMessage('procedure "MegaSetInterSection", at least one of data container was not allocated RAM'#13#10'Program error, turn to the author');
   if high(set1)<high(set2) then k:=length(set1) else k:=length(set2);
   setLength(product,k);
   emptyMegaSet(product);
   k:=8*k-1;
   for k:=0 to k do
    if inMegaSet(k,set1) and inMegaSet(k,set2) then
     includeToMegaSet(product,k)
 end;

 function featuresMegaSetTotal(MegaSetInclude,MegaSetExclude:TarrSet; const vectorsSize:word; var nc:integer):TArrSet;
 {Remember!
 nc, vectorsSize, concern vectors component indexes, not their values, so the maximal index value imply the maximal  value collected in a MegaSet as well
 }
 var i,j,k:longint;
  tmpMegaSet1,tmpMegaSet2, tmpMegaSet3:TarrSet;
  s:String;
 Begin
  if nc>vectorsSize then
   with form1 do
   begin
    nc:=vectorsSize;
    Edit1.Text:=intToStr(nc);
    label86.Caption:=Edit1.Text;
   end;
  setLength(tmpMegaset1,(vectorsSize+1) div 8 +1);      //150520
  setLength(result,(vectorsSize+1) div 8 +1);      //150520
  setLength(tmpMegaSet3,(vectorsSize+1) div 8 +1);      //150520
  s:=intToStr(0)+'..'+intToStr(nc);

  j:=length(tmpMegaset1)-1;                //separate containers
  tmpMegaSet2:=megasetConstructor(s);
  k:=high(tmpMegaSet2);
  if j>k then
   begin
    for i:= 0 to k do tmpMegaSet1[i]:=tmpMegaSet2[i];
    for i:=k+1 to j do tmpMegaSet1[i]:=0; //empty remaining container contens
   end
  else for i:= 0 to j do tmpMegaSet1[i]:=tmpMegaSet2[i];

  j:=length(tmpMegaSet3)-1;                   //separate containers
  tmpMegaSet2:=diffMegaSet(MegaSetInclude,MegaSetExclude);
  k:=high(tmpMegaSet2);
  if j>k then
   begin
    for i:= 0 to k do tmpMegaSet3[i]:=tmpMegaSet2[i];
    for i:=k+1 to j do tmpMegaSet3[i]:=0; //empty remaining container contens
   end
  else for i:= 0 to j do tmpMegaSet3[i]:=tmpMegaSet2[i];

  MegaSetInterSection(tmpMegaSet3,tmpMegaSet1,result);

 End;{featuresMegaSetTotal}

 function MegaSetConstructorReconstruction(const outSet:TarrSet):string;
{
Creates a constructor of a given set (na podstawie danego zbioru outSet tworzy jego konstruktor s1)
}
var i,j,e1,e2 : integer;
         s1 : string;
       dots : boolean;
 Begin
  e1:=0; e2:=0; s1:='';  dots:=false;
  j:=8*length(outSet)-1;
  for i:=0 to j do
   begin
  // control:=i;
   if inMegaSet(i, outset) then
    begin
     e2:=i; e1:=i;
     s1:=s1+intToStr(i);
     break;
    end;{1-th object (1. element)}
   end;{for}
  for i:=e2+1 to j do
   begin
  // control:=i;
   if inMegaSet(i,outset) then
    Begin
     e2:=i;
     if e2-e1=1 then         //-------add 2 dots or  range bounds (dodaj 2 kropki lub granice przedzialu)
      if not dots then begin s1:=s1+'..'; dots:=true; end
      else
     else
      begin
       if dots then begin s1:=s1+intToStr(e1); dots:=false end;
       s1:=s1+','+intToStr(i);
      end;
     e1:=i;
    End; {for}
    end;
  if dots then s1:=s1+intToStr(e1);
  result:='['+s1+']';
 End;{MegaSetConstructorReconstruction}


function MegaSetConstructor(var s1:String):TArrSet;
 { Create a set on a basis of a given set constructor
 na podstawie konstruktora (tj. tekstu zapisanego w oknie edycyjnym edit.text)
 tworzy zbir OutSet
 }
var                s2 : string;
    j,k,setRange,dots : integer;
                  fig : set of char;
              ch,last : char;
                    c : integer;
       outset,lastSet : TarrSet;

procedure intoSet;
 begin
  val(s2,j,c);
  if (j<0) or (j>setRange) then
   begin
    showMessage('intoSet: Only numbers from the range <0..'+intToStr(setRange)+'> are allowed here!, but you have written j='+intToStr(j)+'.');
    exit
   end;
   if (c<>0) and (s2<>'') then
   begin
    showMessage('intoSet: "'+s2+'" is not a number!');
    exit
   end;
  if (c=0) and (s2<>'') then
   if inMegaSet(j,outSet) then
   else includeToMegaSet(outset,j);     //includeToMegaSet(var s:TarrSet;i:longword);
 end;{intoSet}

 var r1,r2:Integer;

 procedure analyseAndAdd(k:byte);
  var m:longWord;
  setInsert,tmpSet : TarrSet;
   Begin
    setLength(setInsert,setRange div 8+1);
    setLength(tmpSet,setRange div 8+1);
    emptyMegaSet(setInsert);emptyMegaSet(tmpSet);
    if dots = 2 then  //introduce range of objects numbers (wprowad zakres elementw)
     begin
      val(s2,r2,c);
      if (c<>0) and (s2<>'') then
      begin
       showMessage('analyseAndAdd:"'+s2+'" is not a number!'); delete(s2,c,1);
       exit
      end;
      if (r2<0) or (r2>setRange) then        //odblokowano 180320
       begin
        showMessage('Only numbers from the range <0..'+intToStr(setRange)+'> are allowed here!, but you have written r2='+intToStr(r2)+'.');
        exit
       end;
      control1:=r1; control2:=r2; control3:=high(setInsert);   //debug prp
      if r1<r2 then
       for m:=r1 to r2 do
        begin
         control1:=m;     //debug prp
         includeToMegaSet(setInsert,m)
        end
      else   for m:=r2 to r1 do includeToMegaSet(setInsert,m);
      sumMegaSet(outSet,setInsert,tmpSet);      //sumSet(set1,set2:TarrSet;var result:TarrSet);
      copyMegaSet(outSet,tmpSet);
     end {dots=2}
    else
     if dots=1 then
      begin
       insert('.',s1,k-1);
       MegaSetConstructor(s1);    //odblokowano 180320
      end
     else intoSet; // (last in fig set)
   End;{analyseAndAdd}

  function range(s:string):longint;
  //kazdy znak spoza bioru fig jest traktowany jako koniec zapisu liczby, w szczegolnosci takze spacja
  //funkcje range wolac po oczyszczeniu danego konstruktora zbioru
   var i:word; s1:string; figFound:boolean;
   begin
    i:=length(s); //debug prp
    if i=0 then begin result:=0;exit end;
    i:=0;  s1:=''; result:=0;  figFound:=false;
    repeat
    inc(i);
    if s[i] in fig then //['0','1','2','3', '4','5','6','7','8','9']
     begin
      s1:=s1+s[i]; figFound:=true;
     end
     else
      if figFound then
      begin
       if strToint(s1)>result then result:=strToint(s1);
       s1:='';
       figFound:=false;
      end;
    until i>=length(s);
    if figFound then
       if strToint(s1)>result then result:=strToint(s1);
   end;{range}

var nextOperand:char; l:word; sc:string;  i:byte;

BEGIN //=============================MegaSetConstructor ===================
fig:=['0','1','2','3','4','5','6','7','8','9'];
//clear given set constructor
 k:=0;
 if s1<>'' then
   while not(s1[1] in fig) do     //(length(s1)>0) is the must, because s[1] will have a random value may be not from fig and the program will hang here when the edit window will be empty!!!
    begin
    delete(s1,1,1);
    if (length(s1)=0) then break;
    end;
 if (length(s1)>0) then
  repeat
   inc(k);
   if not (s1[k] in fig+['.',',']) then
    begin delete(s1,k,1); dec(k) end;
  until(k>=length(s1)) or (length(s1)=0);

setRange:=range(s1);
k:=setRange div 8+1;
 setlength(outSet,k);      setlength(lastSet,k);setlength(result,k);
 s2:='';  dots:=0;   emptyMegaSet(outSet);
 last:=#0;  r1:=0;nextOperand:=#0;  emptyMegaSet(lastSet);//:=[];
 k:=1;  l:=length(s1);
 while k<=l do   {analyse ab ovo (ponownie analizuj caly tekst w Edit)}
  Begin
   ch:=s1[k]; sc:='';
   if ch in fig then
    begin              {------------------------------figure}
     while (ch in fig) and (k<=l) do     //k<, because the loop exceedes analysed strig on the contrary
      begin
       s2:=s2+s1[k];
       inc(k);
       if k<=l then ch:=s1[k];
      end;
     dec(k);
     ch:=s1[k];      //aby moc powiekszyc "dots"
     if (last='.') and (dots=1) then
      begin
       insert('.',s1,k-1);
       MegaSetConstructor(s1);// 160320 blokada, 190320 odblokowano
      end;
    // megaSetCopier(outSet,lastSet);  //przywraca poprzednia wartosc,zbiorowi outset, gdy jeszcze nie wczytano calej liczby, np gdy liczba jest 27, to do outset zostanie wstepnie wlaczone 2, ale poniewaz nastepnym znakiem jest 7 to lastSet nie otrzyma tej wartosci, bo nie bylo przecinka, ktory zglasza koniec liczby, ale wciaz oferuje zbior pusty
     analyseAndAdd(k);
    end{ch in fig}
   else
    begin
     case ch of
      ',' : begin
             if not (last in fig) then
              begin
               setLength(sc,k); //sc[0]:=char(k);
               for i:=1 to k do sc[i]:=s1[i];
               ShowMessage('Procedure "MegaSetConstructor" error: Here "'+sc+'" Comma can follow digits only! (now it follows the "'+last+'")');
               exit;
              end;
             nextOperand:='.';
             if dots in [0,2,3] then copyMegaSet(lastSet,outSet);
             s2:='';   dots:=0;
            end;
      '.' :  Begin
              if nextOperand=',' then   //construction of the form a..b..c not allowed
               begin
                setLength(sc,k);//sc[0]:=char(k);
                for i:=1 to k do sc[i]:=s1[i];
                ShowMessage('MegaSetConstructor error: Only digit or comma  is allowed here or too much dots, i.e. "'+sc+'"! You have written the "'+ch+'"');
                exit
               end;
              if (not (last in fig+['.'])) and (k>1) then
              begin
               setLength(sc,k);//sc[0]:=char(k);
               for i:=1 to k do sc[i]:=s1[i];
               ShowMessage('MegaSetConstructor error: Only digit is allowed here, i.e. "'+sc+'"! You have written the "'+ch+'"');
               exit
              end
             else
              begin
               if last in fig then dots:=0;
               if dots>=2 then
                begin
                 if (last in fig)  then
                 begin
                  setLength(sc,k);//sc[0]:=char(k);
                  for i:=1 to k do sc[i]:=s1[i];
                  ShowMessage('MegaSetConstructor error: Comma allowed here, i.e. "'+sc+'"!');
                  exit
                  end
                 else
                  begin
                   setLength(sc,k);//sc[0]:=char(k);
                   for i:=1 to k do sc[i]:=s1[i];
                   ShowMessage('MegaSetConstructor error: Too much dots!, only 2 are allowed here, i.e. "'+sc+'"!');
                   exit
                  end;
                end{dots>=2}
               else
                begin
                 inc(dots);
                 if dots>=2 then nextOperand:=',';
                 if dots>1 then begin inc(k); continue end;
                 val(s2,r1,c);
                 if (c<>0) and (s2<>'') then
                  begin
                   showMessage('setConstructor: "'+s2+'" is not a number!'); s2:='';
                   exit
                  end;
                 if (r1<0) or (r1>setRange) then
                  begin
                   showMessage('MegaSetConstructor: Only numbers from the range <0..'+intToStr(setRange)+'> are allowed here, but you have written r1='+intToStr(r1)+'.');
                   exit
                  end;
                 s2:='';
                end{else dots>=2}
              end;
             End;{case '.'}
      else {case}
       begin
        if ch<>' ' then
        begin
         setLength(sc,k);//sc[0]:=char(k);
         for i:=1 to k do sc[i]:=s1[i];
         ShowMessage('MegaSetConstructor error: Character "'+ch+'" is not allowed here, i.e.'#13#10'"'+sc+'"'#13#10'Check the "'+
         form1.label109.Caption+'" and the "'+form1.Label110.Caption+'" edition windows content.');
         exit
        end;
       end;
     end;{case}
    end;{else ch in fig}
   last:=ch;
   inc(k);
  End;{while}
 copyMegaSet(result,outSet);
End; {MegasetConstructor}

Begin
setLength(featureMegaSet,1);
setLength(featMegaSetInclude,1);
setLength(featMegaSetExclude,1);
setLength(InsertMegaSet,1);
setLength(fissionMegaSet,1);
featureMegaSet[0]:=0;featMegaSetInclude[0]:=0;featMegaSetExclude[0]:=0;InsertMegaSet[0]:=0;fissionMegaSet[0]:=0;//empty megasets
//showMessage(MegaSetConstructorReconstruction(featureMegaSet)); //debug prp
End.




old versions


 function diffMegaSet(s1,s2:TarrSet):TarrSet;
  //computes difference betweeh sets, i.e. s1-s2
  //only for aequal container capacities, i.e. high(s1)=high(s2)=high(s3) is a must!
  //8*high(s2)+7=8*(high(s2)+1)-1==(number of bits)-1; -1 because the bits are counted from 0
  //attention! data s1 will be corrupted !!!    !!! !!! !!! !!! !!! !!!
   var i,j:longword;
    begin
     i:=high(s1); j:=hihg(s2);
     if i<j then j:=i;
     setLength(result,high(s1)+1);//210520  to separate result from arguments
     j:=8*high(s2)+7;
     control1:=cardMegaSet(s1);  control2:=cardMegaSet(s2);       //debug prp
     for i:=0 to j do
      if inMegaSet(i,s2) then
       excludeFromMegaSet(i,s1);
     for i:=0 to high(s1) do result[i]:=s1[i];//210520
    end;
