unit visualization;

interface

uses
  Windows,Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, MPlayer, StdCtrls, Buttons, ComCtrls, Grids, ExtDlgs;

type
  TForm2 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Button1: TButton;
    Label8: TLabel;
    Label12: TLabel;
    Panel7: TPanel;
    Button2: TButton;
    Button4: TButton;
    Button6: TButton;
    CheckBox2: TCheckBox;
    CheckBox1: TCheckBox;
    Label61: TLabel;
    Label62: TLabel;
    Label63: TLabel;
    Label68: TLabel;
    Button7: TButton;
    Button8: TButton;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    CheckBox11: TCheckBox;
    CheckBox12: TCheckBox;
    CheckBox13: TCheckBox;
    CheckBox14: TCheckBox;
    CheckBox15: TCheckBox;
    CheckBox16: TCheckBox;
    CheckBox17: TCheckBox;
    Panel5: TPanel;
    CheckBox23: TCheckBox;
    CheckBox26: TCheckBox;
    CheckBox27: TCheckBox;
    CheckBox28: TCheckBox;
    Label1: TLabel;
    CheckBox29: TCheckBox;
    Edit13: TEdit;
    Label4: TLabel;
    OpenDialog1: TOpenDialog;
    Button3: TButton;
    Label21: TLabel;
    Label17: TLabel;
    Panel9: TPanel;
    CheckBox24: TCheckBox;
    Label2: TLabel;
    RadioGroup7: TRadioGroup;
    Label64: TLabel;
    Label65: TLabel;
    Label66: TLabel;
    Label67: TLabel;
    Label70: TLabel;
    Label5: TLabel;
    Label10: TLabel;
    Label13: TLabel;
    RadioGroup3: TRadioGroup;
    Label3: TLabel;
    Label9: TLabel;
    Label11: TLabel;
    Button5: TButton;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    CheckBox3: TCheckBox;
    Button11: TButton;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    RadioGroup4: TRadioGroup;
    StringGrid1: TStringGrid;
    Label25: TLabel;
    ListBox1: TListBox;
    Label26: TLabel;
    Bevel1: TBevel;
    Label27: TLabel;
    Label30: TLabel;
    Label28: TLabel;
    SaveTextFileDialog1: TSaveTextFileDialog;
    CheckBox30: TCheckBox;
    CheckBox31: TCheckBox;
    CheckBox32: TCheckBox;
    CheckBox33: TCheckBox;
    CheckBox34: TCheckBox;
    CheckBox36: TCheckBox;
    CheckBox40: TCheckBox;
    CheckBox41: TCheckBox;
    CheckBox35: TCheckBox;
    CheckBox42: TCheckBox;
    CheckBox43: TCheckBox;
    CheckBox25: TCheckBox;
    CheckBox37: TCheckBox;
    CheckBox38: TCheckBox;
    CheckBox39: TCheckBox;
    CheckBox44: TCheckBox;
    Label29: TLabel;
    Label31: TLabel;
    Edit0: TEdit;
    Edit2: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    Edit9: TEdit;
    Edit10: TEdit;
    Edit11: TEdit;
    Edit1: TEdit;
    Edit3: TEdit;
    Edit12: TEdit;
    Label32: TLabel;
    Button9: TButton;
    GroupBox1: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    Label33: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    ListBox2: TListBox;
    procedure Button9Click(Sender: TObject);
    procedure CheckBox44Click(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure Edit1Click(Sender: TObject);
    procedure CheckBox42Click(Sender: TObject);
    procedure CheckBox25Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox7Click(Sender: TObject);
    procedure FormMouseWheel(Sender: TObject; Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint; var Handled: Boolean);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure Button10Click(Sender: TObject);
    procedure RadioGroup7Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure Edit24Enter(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
   procedure WMVScroll(var Msg :TMessage); message WM_VSCROLL;
   procedure WMHScroll(var Msg :TMessage); message WM_HSCROLL;

  public
    { Public declarations }
  end;
  procedure ShowControls;
  function spacesRemove(s:shortString):shortString;
  procedure AutoSizeCol(Grid: TStringGrid; Column: integer);
  procedure editsInitAndEnabler;
  procedure checkedStream(var k,l:byte);
var
  Form2: TForm2;
  myCursorPos : Tpoint;
  edits : array of Tedit; //[0..11]
implementation

{$R *.dfm}
uses  LVQ_spr_Drawings,VQUnit,dataProcessor, Unit1, MegaSets;
type TlabelSet=set of byte;

procedure Tform2.WMVScroll(var Msg : TMessage);
begin   //https://www.tek-tips.com/viewthread.cfm?qid=1409264 (thanks to courtesy of zpksoft, see https://groups.google.com/forum/?hl=pl#!topic/pl.comp.lang.delphi/sTQPQcPQcfQ)
  inherited;
  manager:='R';
end;
//------------------------
procedure Tform2.WMHScroll(var Msg : TMessage);
begin   //https://www.tek-tips.com/viewthread.cfm?qid=1409264 (thanks to courtesy of zpksoft, see https://groups.google.com/forum/?hl=pl#!topic/pl.comp.lang.delphi/sTQPQcPQcfQ)
  inherited;
  manager:='R';
end;
procedure editInit;
//it is assummed, that numbers in edits names correspond to numbers in streams names
 var i:byte;
 Begin
  setlength(edits,maxStreamNbr);
  with form2 do
   begin
    edits[0]:=edit0;
     edits[1]:=edit1;
      edits[2]:=edit2;
       edits[3]:=edit3;
        edits[4]:=edit4;
         edits[5]:=edit5;
          edits[6]:=edit6;
           edits[7]:=edit7;
            edits[8]:=edit8;
             edits[9]:=edit9;
              edits[10]:=edit10;
               edits[11]:=edit11;
     for i:=0 to maxStreamNbr-1 do edits[i].Text:='XXXX';
     for i:=0 to maxStreamNbr-1 do edits[i].Enabled:=false;
   end;
 End;{EditInit}


procedure streamPointerArrInit;
  var i:byte;
  Begin
   setLength(streamPointerArr,maxStreamNbr);
   with form2 do
    begin  // streams Id   checkBoxes pointing processed stream
      streamPointerArr[0]:=checkbox30;  //      input signal sample
      streamPointerArr[1]:=checkbox31;  //PS    power spectrum
      streamPointerArr[2]:=checkbox36;  //      signal spectrum phase
      streamPointerArr[3]:=checkbox32;  //sPS   smoothed spectr
      streamPointerArr[4]:=checkbox35;  //cPS   power spectrum of time constant response
      streamPointerArr[5]:=checkbox34;  //vPS   time centralized power spectrum
      streamPointerArr[6]:=checkbox33;  //msPS  mels from smoothed power spectrum
      streamPointerArr[7]:=checkbox40;  //PC    power cepstrum
      streamPointerArr[8]:=checkbox43;  //cPC   power cepstrum of time constant response
      streamPointerArr[9]:=checkbox42;  //vPC   time centralized power cepstrum
     streamPointerArr[10]:=checkbox41;  //mPC   mel power cepstrum
     streamPointerArr[11]:=checkbox44;  //mmcPS power spectrum of time constant response multimean
    end;
    for i:=0 to maxStreamNbr-1 do streamPointerArr[i].checked:=false;
  End;{streamPointerArrInit}


 procedure scaleCoefficientsRead;
 //reads scale coefficients from edits controls
 //it is assummed, that numbers in edits names correspond to numbers in streams names
 //m - stream index on the streams list
  var i,j,m:integer;
        s:shortString; sc:single;
  Begin
   m:=0; //streams index in a streams array (it can differ from streams number as its ID)
    with form2 do
   begin
    for i:=0 to maxStreamNbr-1 do
     if edits[i].enabled then
      begin   //read edit text and converse it to a number
       if not  tryStrTofloat(edits[i].Text,sc) then
        begin showMessage('The "'+edits[i].Text+ '" is not a number; correct it!'#13#10'Use localization information contained in global variables (i.e. coma or period as decimal point)'); edits[i].Text:='1' end
       else
        begin  //read streams number as j
         s:=spacesRemove(copy(StreamNamesArr[m],1,pos('.',StreamNamesArr[m])-1)); //read streams nbr
         if not  tryStrToInt(s,j) then
          begin
           showMessage('The "'+s+ '" in the string name "'+StreamNamesArr[m]+'" is not a number; correct it in the "Spectrum analyser" program (turn to the author)!'#13#10'A magnifier coeff will be set to 1');
           scc[i]:=1;
           edits[i].Text:='1';
          end
         else
          begin  //check the correspondency
           if i<>j then showMessage('Program error.'#13#10'There is no correspondency between edit windows names and between streams names, i.e. their numbers '+intTostr(i)+'<>'+intToStr(j))
           else scc[i]:=sc;
          end;
        end;{streams number}
       inc(m);
      end;{enabled}
   end;
  End;{scaleCoefficientsRead}

 procedure editsInitAndEnabler;
//enables edits controls assigned to existing streams
//analyses streams names, reads theirs numbers and assign values 20 or 1 depending on that that a name begins with the $ sign or not
 var i,j,k:integer;
 s:shortString;
 Begin
  setLength(scc,maxStreamNbr);
   for i:= 0 to nbrOfStreams-1 do
    with form2 do
     begin
      s:=spacesRemove(copy(StreamNamesArr[i],1,pos('.',StreamNamesArr[i])-1));
      if not  tryStrToInt(s,j) then                              //read the stream number as j value
       begin
        showMessage('The "'+s+ '" in the stream name "'+StreamNamesArr[i]+'" is not a number; correct it in the "Spectrum analyser" program (turn to the author)!'#13#10'Procedure will be broken now');
        exit
       end
       else
        begin
         k:=pos('.',StreamNamesArr[i])+2;     //debug prp
         s:= StreamNamesArr[i][k];           //debug prp
         edits[j].Enabled:=true;
         if StreamNamesArr[i][pos('.',StreamNamesArr[i])+2]='$' then scc[j]:=20
         else scc[j]:=1;
         edits[j].Text:=floatToStr(scc[j]);
        end;;
     end;{with, for}
 End;{editsInitAndEnabler}

procedure TForm2.Button1Click(Sender: TObject);
begin
 if application.messageBox('Break data reading?'#13#10'NOTE, You should use the "Train_Verif" program from the "Waver" package'+
  ' to prepare smaller teaching sample when you like to keep proportional contribution'+
  #13#10' of all cathegories as in the whole sample.','Finish?',MB_YesNo)=IdYes then breakDataReading:=true;
end;

procedure TForm2.Button3Click(Sender: TObject);  //START
var callChain:string;
begin
 callChain:=callChain+'>TForm2.Button3Click="'+button3.Caption+'"';
 button3.Enabled:=false;
 editInit; streamPointerArrInit;
 dataProcess(callChain);
 button3.enabled:=true;
 button1.Visible:=true;
end;

procedure labelsClear_(labelSet:TlabelSet);  //[Arivald 2012]
var ctrl: TLabel;  i,j:Integer;  s:string;
Begin
 with form2 do
 for i := 0 to Panel1.ControlCount-1 do
  if panel1.Controls[i] is Tlabel then
  begin
    ctrl :=form2.panel1.controls[i] as Tlabel;
    s:=ctrl.Name;
    if TryStrToInt(Copy(s, Length(s) - 1, 2), j) then
    if j in labelSet
    then ctrl.caption:='_';
  end;
End;

  function spacesRemove(s:shortString):shortString;
   var j:byte;
   begin
    j:=1;
    while j<=length(s) do
     begin
     if s[j]=' ' then delete(s,j,1)
     else inc(j);
     end;
    result:=s;
   end;{spacesRemove}

 procedure StreamCheckArrReload;
  var i,j:word; s:shortString;
  Begin
    for i:= 0 to nbrOfStreams-1 do
    with form2 do
     begin
      s:=spacesRemove(copy(StreamNamesArr[i],1,pos('.',StreamNamesArr[i])-1));
      j:=strToInt(s);
      case j of //                    visualize checkBox
        0: begin  StreamCheckArr[j]:= checkbox7.checked end; // 0
        1: begin  StreamCheckArr[j]:= checkbox9.checked end; // 1
        2: begin  StreamCheckArr[j]:=checkbox26.checked end; // 2
        3: begin  StreamCheckArr[j]:=checkbox10.checked end; // 3
        4: begin  StreamCheckArr[j]:=checkbox13.checked end; // 4
        5: begin  StreamCheckArr[j]:=checkbox12.checked end; // 5
        6: begin  StreamCheckArr[j]:=checkbox11.checked end; // 6
        7: begin  StreamCheckArr[j]:=checkbox14.checked end; // 7
        8: begin  StreamCheckArr[j]:=checkbox17.checked end; // 8
        9: begin  StreamCheckArr[j]:=checkbox16.checked end; // 9
       10: begin  StreamCheckArr[j]:=checkbox15.checked end; //10
       11: begin  StreamCheckArr[j]:=checkbox24.checked end; //11
      end;{case}
     end;{with}
  End;{StreamCheckArrReload}


procedure ShowControls;
 var i,j:word; s:shortString;

 procedure checkColorUnderLine(check:TcheckBox);
  Begin
   with form2.canvas do
   begin
    Pen.Color:=check.color;
    moveTo(check.left,check.top+check.Height+2);  //penPos.x,penPos.y
    lineTo(check.Left+check.Width,check.Top+check.Height+2);
   end;
   Application.ProcessMessages
  End;{checkColorUnderLine}

 Begin 
  form2.label2.caption:='';
  for i:=0 to form2.ControlCount-1 do if i<>form2.Label35.ComponentIndex then form2.Controls[i].Visible:=true;
  for i:= 0 to nbrOfStreams-1 do
    with form2 do
     begin
      s:=spacesRemove(copy(StreamNamesArr[i],1,pos('.',StreamNamesArr[i])-1));
      j:=strToInt(s);
      case j of
        0: begin  checkbox7.caption:=StreamNamesArr[i];  checkbox7.enabled:=true;  checkbox7.Color:=drawingsArr[i].chartColor; checkbox7.checked:=true; checkbox30.enabled:=checkbox7.checked;   checkColorUnderLine(checkbox7)   end;  // 0   chartColor
        1: begin  checkbox9.caption:=StreamNamesArr[i];  checkbox9.enabled:=true;  checkbox9.Color:=drawingsArr[i].chartColor;  checkbox9.checked:=true; checkbox31.enabled:=checkbox9.checked;  checkColorUnderLine(checkbox31) end;  // 1
        2: begin checkbox26.caption:=StreamNamesArr[i]; checkbox26.enabled:=true; checkbox26.Color:=drawingsArr[i].chartColor; checkbox26.checked:=true; checkbox36.enabled:=checkbox26.checked; checkColorUnderLine(checkbox36) end;  // 2
        3: begin checkbox10.caption:=StreamNamesArr[i]; checkbox10.enabled:=true; checkbox10.Color:=drawingsArr[i].chartColor; checkbox10.checked:=true; checkbox32.enabled:=checkbox10.checked; checkColorUnderLine(checkbox32) end;  // 3
        4: begin checkbox13.caption:=StreamNamesArr[i]; checkbox13.enabled:=true; checkbox13.Color:=drawingsArr[i].chartColor; checkbox13.checked:=true; checkbox35.enabled:=checkbox13.checked; checkColorUnderLine(checkbox35) end;  // 4
        5: begin checkbox12.caption:=StreamNamesArr[i]; checkbox12.enabled:=true; checkbox12.Color:=drawingsArr[i].chartColor; checkbox12.checked:=true; checkbox34.enabled:=checkbox12.checked; checkColorUnderLine(checkbox34) end;  // 5
        6: begin checkbox11.caption:=StreamNamesArr[i]; checkbox11.enabled:=true; checkbox11.Color:=drawingsArr[i].chartColor; checkbox11.checked:=true; checkbox33.enabled:=checkbox11.checked; checkColorUnderLine(checkbox11) end;  // 6
        7: begin checkbox14.caption:=StreamNamesArr[i]; checkbox14.enabled:=true; checkbox14.Color:=drawingsArr[i].chartColor; checkbox14.checked:=true; checkbox40.enabled:=checkbox14.checked; checkColorUnderLine(checkbox14) end;  // 7
        8: begin checkbox17.caption:=StreamNamesArr[i]; checkbox17.enabled:=true; checkbox17.Color:=drawingsArr[i].chartColor; checkbox17.checked:=true; checkbox43.enabled:=checkbox17.checked; checkColorUnderLine(checkbox17) end;  // 8
        9: begin checkbox16.caption:=StreamNamesArr[i]; checkbox16.enabled:=true; checkbox16.Color:=drawingsArr[i].chartColor; checkbox16.checked:=true; checkbox42.enabled:=checkbox16.checked; checkColorUnderLine(checkbox16) end;  // 9
       10: begin checkbox15.caption:=StreamNamesArr[i]; checkbox15.enabled:=true; checkbox15.Color:=drawingsArr[i].chartColor; checkbox15.checked:=true; checkbox41.enabled:=checkbox15.checked; checkColorUnderLine(checkbox42) end;  //10
       11: begin checkbox24.caption:=StreamNamesArr[i]; checkbox24.enabled:=true; checkbox24.Color:=drawingsArr[i].chartColor; checkbox24.checked:=true; checkbox44.enabled:=checkbox24.checked; checkColorUnderLine(checkbox44) end;  //11
      end;{case}
     end;{with}
  form2.panel1.Visible:=false; form2.edit12.Visible:=false;  form2.label32.Visible:=false;
 End;{ShowControls}

procedure HideControls;
var i:word;
 begin
 with form2 do
  begin
   for i := 0 to ControlCount-1 do
    Controls[i].Visible:=false;
   //Button1.Visible:=true;
   Button3.Visible:=true;
   label2.Visible:=true;
  end;{with}
 end;{HideControls}

procedure AutoSizeCol(Grid: TStringGrid; Column: integer);
var
  i, W, WMax: byte;
begin
  WMax := 0; 
  for i := 0 to (Grid.RowCount - 1) do
   begin
    W := Grid.Canvas.TextWidth(Grid.Cells[Column, i]);
    if W > WMax then 
    WMax := W;
  end;
  Grid.ColWidths[Column]:= WMax+5;
end;

 procedure TForm2.FormCreate(Sender: TObject);
 var i:word;
begin
 with screen do if (Width<>1920) or (height<>1080) then
  if MessageDlg('The interface of the program was prepared for the 1920x1080 screen resolution!'#13#10+
  'Your screen parameters are: '+intToStr(width)+'x'+intToStr(height)+'.'#13#10+
  'Try to change your graphic card parameters to these values.'#13#10'Change the "vertScrollBar.Range" and the'+
  ' "HorzScrollBar.Range" to adapt the scrolling ranges to other resolution'#13#10+
  'Command "Repaint frames" in the step mode can help if you can''t to do this and graphs are going out of their frames.',
  mtInformation,[mbIgnore,mbAbort],0)=mrAbort then halt;
  left:=0; top:=0;
  vertScrollBar.Range:=900; vertScrollBar.Position:=0;
  HorzScrollBar.Range:=1600; HorzScrollBar.Position:=0;
 form2.Label2.Caption:='Data reader';
 form2.Label2.Left:=300;
 form2.Label2.Top :=340;
 form2.Label2.Font.Size:=32;
 form2.Label2.font.Color:=clScrollBar;
 form2.label26.Visible:=false;
 form2.ListBox1.Visible:=false;
 //form2.Label21.Top:=form2.Panel1.Top+form2.Panel1.Height-form2.Label21.Font.Height;
 form2.WindowState:=wsMaximized;
 button1.Visible:=false;
 button2.Hint:='Show previous portion';
 Button2.Enabled:=false;
 button4.Hint:='Show next portion';
 button6.Hint:='Break the analysis';
 checkBox3.Checked:=true;
 checkBox8.Hint:='Weighted signal is here multiplied by averaging period, i.e. 256';
 checkBox11.Hint:='Zakres melowy zosta rozcignity tak,'#13#10+
  'aby jego skrajne wartoci pokryway si na osi odcitych wykresu'#13#10+
  'ze skrajnymi wartociami czstotliwoci wyraonej w hercach';
 checkBox23.Checked:=true;
 KeyPreview:=true;


 labelsClear_([17..24,27,27,30..37,39,40,45..54]);
 radiogroup3.Enabled:=false;
 radiogroup7.Enabled:=false;
 form2.panel9.Visible:=true;form2.panel9.left:= form2.panel1.left+10;  form2.panel9.top:= form2.panel1.top+1; form2.panel9.Height:=form2.panel1.Height;
 HideControls;
 for i:=1 to 255 do form2.stringGrid1.cells[i,0]:=intToStr(i);   //greed headers
 form2.stringGrid1.cells[0,1]:='h. Phon';
 form2.stringGrid1.cells[0,2]:='d. Phon';
 form2.stringGrid1.cells[0,3]:='h. Person';
 form2.stringGrid1.cells[0,4]:='d. Person';
 form2.stringGrid1.cells[0,5]:='h. Gender';
 form2.stringGrid1.cells[0,6]:='d. Gender';
 form2.stringGrid1.cells[0,7]:='h. Age';
 form2.stringGrid1.cells[0,8]:='d. Age';
 for i:=0 to 255 do AutoSizeCol(StringGrid1,i);
 //streamPointerArrInit;
 //editInit;
end;{FormCreate}

procedure TForm2.CheckBox1Click(Sender: TObject);
begin
 CheckBox2.Checked:=CheckBox1.Checked;
 CheckBox3.Checked:=CheckBox1.Checked; //show T0 plot
 button3.Enabled:=checkBox1.Checked;   //start
end;

procedure TForm2.Button2Click(Sender: TObject);
begin     //back
 manager:='B';
end;

procedure TForm2.Button4Click(Sender: TObject);
begin   //Next
 manager:='N';
 nextPortion:=true;
 button3.Enabled:=true;
 Button2.Enabled :=checkBox2.Checked;    //Back
end;

procedure TForm2.Button5Click(Sender: TObject);
begin    //save record
 manager:='S';
end;

procedure TForm2.Button6Click(Sender: TObject);
begin    //break
form2.CheckBox2.Checked:=not form2.CheckBox2.Checked;
 manager:='C';    //in order to step into the "stepManager" to perform command break (i.e. "C")
end;

function checkStreamsChecking:byte;
 var i,j:byte;
 begin
  j:=0;
  for i:=0 to maxStreamNbr-1 do if streamPointerArr[i].checked then inc(j);
  result:=j;
 end;{checkStreamsChecking}

procedure TForm2.CheckBox2Click(Sender: TObject);
 var j:byte;
begin     //wykonanie krokowe
 j:=checkStreamsChecking;
 if not form2.CheckBox2.Checked then 
  if j=0 then
   begin
    showMessage('You have not pointed any stream for processing. Do it now!'#13#10'Unlock the "'+form2.Label29.Caption+'" - click "'+form2.CheckBox25.Caption+'" if it is checked');
    form2.CheckBox2.Checked:=true  //Step performance
   end
  else
   if checkStreamsChecking>1 then
    begin
     showMessage('You have pointed too many streams for processing; Change it now'#13#10'Unlock the "'+form2.Label29.Caption+'" - click "'+form2.CheckBox25.Caption+'" if it is checked');
     form2.CheckBox2.Checked:=true
    end;
 button3.Enabled:=checkBox2.Checked;     //Start
 Button2.Enabled :=checkBox2.Checked;    //Back
 Button4.Enabled :=checkBox2.Checked;    //Next
 if Button4.enabled then button4.setFocus;
 //Button5.Enabled :=checkBox2.Checked;    //Save record
 manager:=#0;       //aby wyj z ptli wykonywania krokowego (z oczekiwania na kliknicie Back|Next)
end;

procedure TForm2.Button7Click(Sender: TObject);
begin   //repeat
 manager:='r';
 if Button4.enabled then button4.setFocus;
end;

procedure TForm2.Button8Click(Sender: TObject);
begin   //repaint
  // odrysowuje ramki okien po ponownym wczeniu grafiki
   manager:='R';
   if Button4.enabled then button4.setFocus;
end;

procedure TForm2.Edit24Enter(Sender: TObject);
begin
checkbox2.Checked:=true
end;

procedure TForm2.CheckBox4Click(Sender: TObject);
begin
 manager:='R';
end;

procedure TForm2.CheckBox5Click(Sender: TObject);
begin
 manager:='R';
end;

procedure TForm2.CheckBox6Click(Sender: TObject);
begin
 if checkBox6.Checked then panel4Scale:=5000
 else  panel4Scale:=700;
 manager:='R';
end;

procedure TForm2.FormResize(Sender: TObject);
begin
  Application.ProcessMessages;
 form2.Panel1.Width:=width-form2.Panel1.left-50;
 manager:='R';
 {if Form2.WindowState = wsMinimized then }form1.Button25.Visible:=true;  //the condition does not work 03.05.2023
 Application.ProcessMessages;
end;

procedure TForm2.RadioGroup7Click(Sender: TObject);
begin
 winNbr:=RadioGroup7.ItemIndex;
end;

procedure TForm2.Button10Click(Sender: TObject);
begin
 manager:='H';
end;

procedure TForm2.FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
 var  graphNbr:byte;

procedure labelColor(labelx:Tlabel);
 var color:Tcolor;
 begin
  Color:=Canvas.Pixels[myCursorPos.x,myCursorPos.y];
  labelx.Color:=color;
  labelx.font.Color:=clblack;
  if color=clBlack then labelx.font.Color:=clWhite;
  application.ProcessMessages;
 end;

Begin //----------------------------------------------------- Tform2.FormMouseMove -----------------------------------
 graphNbr:=1;
 GetCursorPos(myCursorPos);
 with form2,myCursorPos do
  begin
   label21.caption:='(x, y)=('+intToStr(x)+', '+intToStr(y)+')';
   y:=y-form2.Top-22-8;            //pozycja kursora musi by pomniejszona 0 22 prawdopodobnie, bo Cursor pos wskazuje pozycj na ekranie; 22, to szeroko caption.form2
   x:=x-form2.Left-8;              //j.w., +8, bo wykrywane w programie form2.top=-8, a form2.left=-8
   labelColor(form2.label17);
  try
     if (x<=panel1.Left+panel1.Width) and (y>panel1.top) and (y<=panel1.Top +panel1.Height) then
    begin
     inc(graphNbr); label17.Visible:=true;
     x:=round((x-panel1.Left)/wspx1);  y:=y-panel1.top;
     label17.top:=panel1.top+panel1.height-16; label17.Left:=panel1.Left+10;  //top must be first evaluated because on the panel2 appeares a patch
     label17.Caption:=intToStr(x)+'='+floatToStrF(x*wspx1*paramRec.pJump/rate,ffFixed,8,2)+'s, '+
     floatToStrF(y/wspy1,ffFixed,8,3)+'ms='+intToStr(round(1000*wspy1/y))+'Hz';
      //floatToStrF(((1000*count/(2*rate))+(y-centr1)/wspy1),ffFixed,8,3)+'ms='+intToStr(round(1000/((1000*count/(2*rate))+(y-centr1)/wspy1)))+'Hz'; //-panel1.top
    end
   else

   if (x<=panel2.Left+panel2.Width) and (y>=panel2.top) and (y<=panel2.Top +panel2.Height) then
    begin
     inc(graphNbr); label17.Visible:=true;
     x:=round((x-panel2.Left)/wspx2);
     label17.top:=panel2.top+2; label17.Left:=panel2.Left+10;  //top must be first evaluated because on the panel2 appeares a patch
     label17.Caption:=intToStr(x)+',  '+floatToStrF(x*1000/rate,ffFixed,8,2)+'ms, '+intToStr(round(-(y-centr2)/wspy2)); //-panel2.top
    end
   else

   if (x<=panel3.Left+panel3.Width) and (y>=panel3.top) and (y<=panel3.Top +panel3.Height) then
    begin
     inc(graphNbr); label17.Visible:=true;
     label17.top:=panel3.top+2; label17.Left:=panel3.Left+10;
     x:=round((x-panel3.Left)/wspx3);
     if x/d_count>0.5 then x:=x-d_count;       //first half is placed in negative frequency area
     label17.Caption:=intToStr(x)+',  '+floatToStrF(x*rate/d_count,ffFixed,8,0)+'Hz, '+floatToStrF((-(y-centr3)/wspy3),ffFixed,8,2);//intToStr(round(-(y-centr3)/wspy3)); //-panel2.top
    end
   else

   if (x<=panel4.Left+panel4.Width) and (y>=panel4.top) and (y<=panel4.Top +panel4.Height) then
    begin
     inc(graphNbr); label17.Visible:=true;
     label17.top:=panel4.top+2;label17.Left:=panel4.Left+10;
     x:=round((x-panel4.Left)/wspx4);
     if x>(d_count div 2) then x:=x-d_count;      //first half is placed in negative quefrency area
     label17.Caption:=intToStr(x)+'pt.,  '+floatToStrF(1000*x/rate,ffFixed,8,2)+'ms='+floatToStrF((rate/x),ffFixed,8,2)+'Hz. '; //-panel2.top
     label17.caption:=label17.caption+' Cepstr. ampl.='+intToStr(round(-(y-centr4)/wspy4));
    end
   else

   if (x<=panel5.Left+panel5.Width) and (y>=panel5.top) and (y<=panel5.Top +panel5.Height) then
    begin
     inc(graphNbr); label17.Visible:=true;
     x:=round((x-panel5.Left)/wspx5);
     if x/d_count>0.5 then x:=x-d_count;
     label17.Left:=panel5.Left+10; label17.top:=panel5.top;
     label17.Caption:=intToStr(x)+',  '+floatToStrF(x*rate/d_count,ffFixed,8,0)+'Hz, '+floatToStrF((-(y-centr5)/wspy5),ffFixed,8,2)+' rad'; //-panel2.top
    end
   else
    begin
    label17.Visible:=false;
    label17.top:=panel2.top+16; label17.Left:=panel2.Left+10; //must be in order not to have patch on the "filter" graph
   (* label18.Caption:=label18Caption;                         //in order to restore actual graph description, i.e. 'Filters shape'|'Weights spectrum'
    label19.Caption:='Weighting windows shape'; *)
    end;
  except
  (* showMessage('There is some error in procedure "Tform2.FormMouseMove". Check it or turn to the author.'#13#10+
   'Probably some scaling coefficient (i.e. wspx# or wspy#)) of a panel area  being inspected (for the graph nbr '+intTostr(graphNbr)+')  is equal to 0'); ;*)
  end;
  end;{with}
End;{Tform2.FormMouseMove}

procedure TForm2.FormMouseWheel(Sender: TObject; Shift: TShiftState; WheelDelta: Integer;
  MousePos: TPoint; var Handled: Boolean);
begin
 DataFrames;
end;

procedure TForm2.CheckBox7Click(Sender: TObject);  //check7 - "0. Original signal"
//called from each "visualise" checkBox 9-17 and 26-29
begin
 StreamCheckArrReload;
 manager:='R';          //in order to immediately execute on|off of chosen graphs
 if Button4.enabled then Button4.SetFocus;
end;

procedure TForm2.CheckBox3Click(Sender: TObject);    //T0 show
begin
 if Button4.enabled then Button4.SetFocus;
 zn1:=#0; //in order to annotatate a begining of a continuation after a break
end;

procedure falseOutChecks;
Begin
 with form2 do
  begin//31-45
   if not checkbox25.Checked then checkbox2.Checked:=true; //turn on stepwise analysis when outputs are opened
   checkbox30.checked:=false; //0.signal
   checkbox31.checked:=false; //1.PS
   checkbox32.checked:=false; //3.sPS
   checkbox33.checked:=false; //6.mPS
   checkbox34.checked:=false; //5.vPS
   checkbox35.checked:=false; //4.cPS
   checkbox36.checked:=false; //2.phase
   checkbox37.Enabled:=false; //phase
   checkbox38.Enabled:=false; //phase
   checkbox39.Enabled:=false; //phase
   checkbox40.checked:=false; //7.PC
   checkbox41.checked:=false; //10.mPC
   checkbox42.checked:=false; //9.vPC
   checkbox43.checked:=false; //8.cPC
   checkbox44.checked:=false; //11.mmcPS
  end;
 End;{falseOutChecks}


procedure TForm2.CheckBox25Click(Sender: TObject);    //"lock output"
 var logos:boolean;
Begin
 with form2 do
  begin//31-45
   logos:=not form2.CheckBox25.Checked;
   if logos then checkbox2.Checked:=true;//turn on stepwise analysis when outputs are opened
   checkbox30.Enabled:=logos and checkBox7.Checked;
   checkbox31.Enabled:=logos and checkBox9.Checked;
   checkbox32.Enabled:=logos and checkBox10.Checked;
   checkbox33.Enabled:=logos and checkBox11.Checked;
   checkbox34.Enabled:=logos and checkBox12.Checked;
   checkbox35.Enabled:=logos and checkBox13.Checked;
   checkbox36.Enabled:=logos and checkBox26.Checked;
   checkbox37.Enabled:=false and checkBox27.Checked;  //?
   checkbox38.Enabled:=false and checkBox28.Checked;  //?
   checkbox39.Enabled:=false and checkBox29.Checked;  //?
   checkbox40.Enabled:=logos and checkBox14.Checked;
   checkbox41.Enabled:=logos and checkBox15.Checked;
   checkbox42.Enabled:=logos and checkBox16.Checked;
   checkbox43.Enabled:=logos and checkBox17.Checked;
   checkbox44.Enabled:=logos and checkBox24.Checked;
   radiogroup4.enabled:=checkbox44.enabled;
  end;
 if logos then falseOutChecks;
 Application.ProcessMessages;
 label2.Visible:=not checkBox25.Checked;
 if not checkBox25.Checked then showMessage('Any selection change of the output stream will start data reading from scratch');
End;{CheckBox25Click "lock output"}

procedure checkedStream(var k,l:byte);
 //indicates an index in the streamPointerArr  of a checked output checkbox
   var i:byte; s:string;
   Begin
    for i:=0 to 255 do
     try
      if streamPointerArr[i].Checked then
       begin
        k:=i;
        break
       end
     except
      showMessage('No stream was chosen yet...');
      exit
     end;
    for i:= 0 to nbrOfStreams-1 do
     if StreamsNbrs[i]=k then
     begin
      l:=i;
      break
     end;
 if MessageDlg('There was chosen a stream nbr '+intTostr(l)+' labelled with a number "'+intToStr(k)+'", ie. "'+
                 streamNamesArr[l]+'"'#13#10'Double Click the "'+form2.CheckBox25.Caption+'" checkbox to change the selection.'#13#10+
                 'Current parameters: "'+form1.label1.Caption+'"='+intToStr(nc)+', "'+form1.label111.Caption+'"='+form1.label112.Caption+
                 '.'#13#10'Click Yes, if you like to change the first of these parameters...',mtInformation,[mbYes, mbNo],0)=mrYes then
     begin
      with form1.Edit1 do
      repeat
       s:=inputBox(form1.label1.Caption,form1.Edit1.text,form1.Edit1.text);
       if  tryStrToInt(s,nc) then break;
       showMessage('"'+s+'" is not an integer number! Correct it.');
      until false;
      form1.edit1.text:=intToStr(nc);      //this also enters edit1.OnExit
      form1.edit1.OnExit(form1.edit1);
     end
   End; {checkedStream}

procedure outCheckClick;
 begin   //common part for CheckBox42Click and for CheckBox44Click
  form2.CheckBox25.Checked := true;
  checkedStream(checkedStreamNbr,StreamIdx);  // checkedStreamNbr:= 01012022
  dataProcessor.InitWrite;
 end;

procedure TForm2.CheckBox42Click(Sender: TObject);
begin            //processed stream 9 "Time centralized PC"
 outCheckClick;  //calls the "checkedStream" function, which calls setLength fuctions for eventCatch#, whwere #=1,2,3,4
 fromScratch:=true;
end;

procedure TForm2.Edit1Click(Sender: TObject);
begin
  scaleCoefficientsRead;
  manager:='R';
end;

procedure TForm2.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
 if key=#13 then
  begin
   scaleCoefficientsRead;
   manager:='R';
  end;
end;

procedure TForm2.CheckBox44Click(Sender: TObject);
begin            //processed stream 11 "Spectrum of time constant response"
 form2.edit12.Visible:=true;  form2.label32.Visible:=true;
 outCheckClick;  //calls the "checkedStream" function, which calls setLength fuctions for eventCatch#, whwere #=1,2,3,4
end;

procedure TForm2.Button9Click(Sender: TObject);
var color:longint;
begin
  form2.CheckBox2.Checked:= true;
  color:=drawingsArr[StreamIdx].chartColor;
  drawingsArr[StreamIdx].chartColor:=clWhite;
  showGraph(StreamIdx,scc[streamsNbrs[StreamIdx]],inputRecord.IstreamArray[StreamIdx],inputRecord.IF0);
  drawingsArr[StreamIdx].chartColor:=color;
end;

end.


procedure falseOutChecks(checkBox:TcheckBox);

Begin
 with form2 do
  begin//31-45
   if not checkbox25.Checked then checkbox2.Checked:=true; //turn on stepwise analysis when outputs are opened
   if checkBox<>checkbox30 then checkbox30.checked:=false; //signal
   if checkBox<>checkbox31 then checkbox31.checked:=false; //PS
   if checkBox<>checkbox32 then checkbox32.checked:=false; //sPS
   if checkBox<>checkbox33 then checkbox33.checked:=false; //mPS
   if checkBox<>checkbox34 then checkbox34.checked:=false; //vPS
   if checkBox<>checkbox35 then checkbox35.checked:=false; //cPS
   if checkBox<>checkbox36 then checkbox36.checked:=false; //phase
   if checkBox<>checkbox37 then checkbox37.Enabled:=false; //phase ?
   if checkBox<>checkbox38 then checkbox38.Enabled:=false; //phase ?
   if checkBox<>checkbox39 then checkbox39.Enabled:=false; //phase ?
   if checkBox<>checkbox40 then checkbox40.checked:=false; //PC
   if checkBox<>checkbox41 then checkbox41.checked:=false; //mPC
   if checkBox<>checkbox42 then checkbox42.checked:=false; //vPC
   if checkBox<>checkbox43 then checkbox43.checked:=false; //cPC
   if checkBox<>checkbox44 then checkbox44.checked:=false; //mmcPS
  end;
 End;{falseOutChecks}



