unit ErrorsUnit;

interface
uses sysUtils,dialogs,StdCtrls,ExtCtrls,forms,windows,ExtDlgs,MegaSets,controls;
  procedure error0(callChain,s:string);
  procedure error1(var treeFile : textFile; var result:boolean);
  procedure error2(var treeFile : textFile);
  procedure error5(callChain:string);
  procedure error6(const i,eventNbr:longWord);
  procedure error7(callChain:string);
  procedure error8;
  procedure error9(startNodeAddr:longWord;callChain:string);
  function error11(callChain:string;var step:word):word;
  procedure error13(const eventNbr:longWord; const nodeNbr,centroidsNb,leafNodeNbr:word; callChain:string);
  procedure error14(callChain:string);
  procedure error15(const leafNodeNbr:word;callChain:string);
  procedure error16(callChain:string);
  procedure error19(i:word;j:longWord;cathPB,callChain:String); //not used now 271120
  procedure error26(s : string; l,m:byte);
  procedure error27(n,k1,k2:longWord; s:string);
  procedure error28(const leafNodeNbr:word;callChain:string);
  procedure error29(result:double;i:word);
  procedure error31(n,k,k1,k2:longWord;s:shortString;callChain:string);
  procedure error32(const startNodeAddr:longWord;vim:double;s:shortString);
  procedure error33(const eventNbr,k:longWord);
  procedure error34(s:shortString; const startNodeAddr:longWord;step:word);
  procedure error35(s:string);
  procedure error36(FileDir:string);
  procedure error37;
  procedure error38(s:string);
  procedure error39(s:string);
  procedure error42(var i:integer; edit:Tedit;labelx:Tlabel;s:string);
  procedure error44;
  procedure error45(const card1,n,eventNbr:longWord);  //error44(excludeSetCard,(n+1) div 8,n,eventNbr);
  procedure error46(s:string;radio:Tradiogroup);
  procedure error47(s:string);
  procedure error48;
  procedure error49;
  procedure error50(n,cardinal:longWord;s:shortString);
  procedure error51;
  procedure error52(s:shortString; hb,lb:longWord);
  procedure error53(n,excludesetCard:longWord);
  procedure error54(const n,Card:longWord; const leaf:word; s:String;callChain:string);
  procedure error55(s:shortString;callChain:string);
  procedure error56(const j,lbhb:int64; s:shortString;callChain:string);
  procedure error57(const lb2hb1:int64; s:shortString;callChain:string);
  procedure error58(s:shortString);
   function error59(programDir:string):boolean;
  procedure error60(programDir,proc:string);
  procedure error61(s:string);
  procedure error62(s:string);
  procedure error63(n2,n1:int64); //EventNbr<high(vectList)
  procedure error64(i:integer;callChain:string);
  procedure error65(s1, cathName:string; const p1,p2:extended;mult:integer;step:word;callChain:shortString);
  procedure Error66(i,readEventNbr:longWord; excludeSet:TarrSet;callChain:string);
  procedure error67(inpFileDir,currentDataSource,callChain:string);
  procedure error68(i,readEventNbr:longWord;callChain:string);
  procedure error69(excludeSetCard,readEventNbr,rareEventNbr2:longWord;callChain:string);
  procedure Error70(callChain:string);
  procedure error71(nc,vectorsSize:word;callChain:string);
  procedure error80;
  procedure error100;
  procedure error260(s:shortString);

  implementation
 uses system.UITypes,unit1,vQUnit,dataProcessor;


  procedure error0(callChain,s:string);
   begin
    callChain:=callChain+'>Error0';
    with form1 do
    s:=callChain+#13#10'Error in the file name, ('+s+') correct  or chose from the list '+
     #13#10'If the things are going wrong, close the program, reopen, go to the'#13#10'"'+ mainMenu1.Items[2].Caption+'\'+
     PageControl1.Pages[1].Caption+label7.Caption +'"'#13#10'and manually write down correct path and filename'+
     ' accordingly to the DOS rules or the *.* wild cards and continue chosing the proper file from the opened list'+
     #13#10'or remove the "'+LVQinitDir+'" init.txt file  or manually correct its contents. You will find the file in the same directory, where the program is located';
    messageDlg(s,mtConfirmation,[mbOK],0);
   end;

procedure error1(var treeFile : textFile; var result:boolean);
  begin
   result:=false;
   error39('error1.'#13#10'Proc. "ReadFirstCentroids"'#13#10'The first centroids could not be read. The existing tree'#13#10+
    treeFileDir+#13#10'differs, probably does not contain line "Quantization tree" or the line has been changed in some way.'+
    #13#10'The line is a mark signalling end of the initial information part of the tree text.');
   closeFile(treeFile);
  end;{error1}

 procedure error2(var treeFile : textFile);
  begin
   error38('error2. '#13#10'Proc. "readExcludeSet"'#13#10'The "Exclude set" could not be read. The existing tree'#13#10+
    treeFileDir+#13#10'probably does not contain line "Exclude set:" or the line has been changed in some way.'+
    #13#10'The line is a mark signalling existing  of the exclude set savings');
   closeFile(treeFile);
  end;{error}

 procedure error5(callChain:string);
   var s1,s:string; i:byte;
   Begin
    callChain:=callChain+'>Error 5';
    s:='';
    with form1 do
     begin
     s1:=mainMenu1.Items[2].Caption+'\'+PageControl1.Pages[6].Caption+'\'+label11.Caption +'\'+label127.Caption +'\'+label36.Caption+'\'+label37.Caption;
     for i:=1 to length(s1) do if s1[i]<>' ' then s:=s+s1[i]; //usun spacje
     s:=callChain+#13#10'All events were included to the  "Exclude" set of  events!, nothing to compute. '+
     'Check the'#13#10'"'+s+'"'+#13#10'option.'#13#10+
     'The tresholds are too high, so all leaf sets were included to the exclude set.'+#13#10+
     'You should lower them or lower the number of classes, i.e. "'+ mainMenu1.Items[2].Caption+'\'+PageControl1.Pages[0].caption+'\'+label5.Caption+'"'+
     #13#10'In this case sets will be bigger. The program will be halted now.'#13#10'Important!! Set the "'+
     label37.Caption+'" treshold to 0 if you wanted to repeat analysis with the same data (because the exclude set can grow with every next pass)'
     +#13#10'End of the error 5 description.';
    end;{with}
    s:=delAmpers(s);
    showMessage(s);
    writeln(reportFile,s);
    flush(reportFile);
    halt;
   End;{error5}

 procedure error6(const i, eventNbr:longWord);
  var s:string;
   Begin
    s:='Error 6.'#13#10'Program error, or the file '+inpFileDir+' is too short.'#13#10'It was expected to find '+
    intToStr(eventNbr)+' features vectors, but it was read '+intToStr(i)+'!'#13#10'despite the file '#9+inpFileDir+
    #9' has '+intToStr(fileSize(inpFile))+' members.';
    if eof(inpFile) then s:=s+#13#10'It was reached end of file during reading the file [eof(eventFile)].'#13#10;   s:=s+
    #13#10'End of the error 6 description.';
    showMessage(s);
    writeln(reportFile,s);
    flush(reportFile);
   End;

 procedure error7(callChain:string);
   begin
    callChain:=callChain+'>error7';
     showMessage(callChain+#13#10'Program code error, turn to the author');
   end;

 procedure error8;
  var s : string;
  Begin
   s:='Error 8, program error.'#13#10'Heap for the tree nodes is too small.'#13#10'Now heapTop='+intToStr(heapTop)+'. Its size is determinined as '+
      '2*('+form1.Label5.Caption+')+1='+intToStr(2*CentroidsNb_glob+1)+'. The error can occure in the CART or CART-like mode or in the "second pass" eliminating rare events.'+
      'In the last case try to run the program in the "second pass" alone.'#13#10'The programm should be changed, contact the author.'+
       #13#10'End of the error 8 description.';
   s:=delAmpers(S);
   ShowMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
  End;{error8}

  procedure error9(startNodeAddr:longWord;callChain:string);
   var s : string;
   Begin
    s:=callChain+#13#10'Error 9. Program error.'#13#10'A node (nr '+intToStr(startNodeAddr)+
    ', from which the graph constructio should be continued already has a successor!'#13#10+'This is the node nbr '+
    intToStr(nodeHeap[startNodeAddr].son)+#13#10'Program will be halted'+#13#10'End of the error 9 description.';
    ShowMessage(s);
    writeln(reportFile,s);
    flush(reportFile);
    halt;
   End;{error9}

  function error11(callChain:string;var step:word):word;
   var s : string;
   begin
    s:=callChain+#13#10'Error 11, step='+intToStr(step)+#13#10'Computation error (procedure DivideSet\means), one of the descendant set contains no members (k=0).'+
    #13#10'The error could arrise as an effect of dividing a set, which contained identical members,'+
    #13#10'or when switch "alloc" in the procedure DivideSet does not work properly in case when different events are equally spaced from centroids'+
    #13#10'or initial centroids were extremaly bad established e.g. obtained for another, far cluster'+
    #13#10'Turn to the author in these cases'+
    #13#10'If the error appearead at the same beginning of the program execution (step=1),';
    s:=s+#13#10'then check, whether the reading of the centroids obtained in some previous execution'+
    ' was justified'#13#10'(erase file "'+treeFileDir+'"), or whether the generated set of rare events'+
    ' does not contain all events (because of too high treshold "'+ form1.mainMenu1.Items[2].Caption+'\'+
    form1.PageControl1.Pages[6].Caption+'\'+form1.Label37.Caption+'" all events were included to the rare events set).'+
    #13#10'or whether the set is not erronous  (may be it was obtained for different options!)'+
    #13#10'OK="We take the k=1 and we continue computations for (diagnostic purposes only)'+
    #13#10'End of the error 11 description.';
    s:=delAmpers(s);
    writeln(reportFile,s);
    result:=1;
    if application.MessageBox(pchar(s),pchar('Error! Continue?'),mb_yesNo)=idNo then halt;
    flush(reportFile);
   end; {error11}

  procedure error13(const eventNbr:longWord; const nodeNbr,centroidsNb,leafNodeNbr:word; callChain:string);
  var s : string;
  begin
   with form1 do if (checkBox42.Checked) and (RadioGroup22.ItemIndex=1) then
    s:='Error 13.'+callChain+#13#10'Nie znaleziono ju ani jednego licia, ktrego dzielenie daoby spadek bdu rozpoznania.'
   else s:='Error 13.'#13#10'Nie znaleziono ju ani jednego licia ze zbiorem o redniej odlegoci Euklidesa pomidzy wektorami zdarze >0.';
   s:=s+#13#10'Proces doszed do '+intTostr(step)+' poziomu.'#13#10'Graf ma '+intToStr(nodeNbr+1);
   if (nodeNbr+1) mod 10 in [2,3,4] then s:=s+' wzy, w tym '+intToStr(leafNodeNbr)+' licie.'
   else s:=s+' wzw, w tym '+intToStr(leafNodeNbr)+' lici.';
    if centroidsNb>=eventNbr then
    s:=s+#13#10'Liczba danych podziaw (='+intToStr(centroidsNb)+
    ') dorwnuje lub przewysza liczb klasyfikowanych zdarze (='+intToStr(eventNbr)+')';
    s:=s+#13#10+#13#10'No more dividing action possible due to chosen restrictions or because all sets contain identical or only 1 member each.'+
    #13#10'End of the error 13 description. Obtained tree graph has '+intToStr(nodeNbr+1)+' nodes, in which '+intToStr(leafNodeNbr)+' leaves';
   showMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
  end;{error13}

 procedure error14(callChain:string);
  var s : string;
  begin
   s:='Error 14.'+callChain+#13#10'The end of the dividing possibilities was reached.'#13#10'The proces has achieved '+intTostr(step)+
   ' level.'+#13#10'End of the error 14 description.';
  ShowMessage(s);
  writeln(reportFile,s);
  flush(reportFile);
 end;

 procedure error15(const leafNodeNbr:word;callChain:string);
  var s : string;
  begin
   s:='Error 15.'+callChain+#13#10'A programm error or the number of class is too big; step='+intTostr(step)+' <> leafNodeNbr='+
   intTostr(leafNodeNbr)+#13#10'End of the error 15 description.';
   showMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
  end;

 procedure error16(callChain:string);
  var s : string;
  begin
   s:='Error 16.'+callChain+#13#10'The event (features vectors) set is empty.'#13#10+
   'Prawdopodobnie na etapie okrelania zdarze rzadkich doszo do kompletnego rozbicia na zbiory 1-no elementowe, lub o elementach identycznych.'#13#10+
   'Naley obniy liczb centroidw i powtrzy obliczenia'+#13#10'End of the error 16 description.';
   showMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
  end;

 procedure error28(const leafNodeNbr:word;callChain:string);
  var s : string;
  begin
   s:='Error 28. '+callChain+#13#10'step<>leafNodeNbr-1; nie zgadza si bilans lici i krokw iteracyjnych; step='+
   intToStr(step)+', a leafNodeNbr-1='+intToStr(leafNodeNbr-1)+#13#10'End of the error 28 description.';
   showMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
 End; {error28}

 procedure error19(i:word;j:longWord;cathPB,callChain:String); //not used now 271120
   //cathPb= cath1Pb|cath2Pb|cath3Pb|cath4Pb
  var s:string;
   Begin
    s:='Error 19.'+callChain+#13#10'Bd programu: w histogramie gwnym, '+cathPb+' na pozycji '+intToStr(i)+
    ' wystpia warto zerowa, a w histogramie czstkowym, na tej samej pozycji, warto '+intToStr(j)+#13#10+
    'Kontynuowa program?'+#13#10'End of the error 19 description.';
    writeln(reportFile,s);
    if application.MessageBox(pchar(s),pchar('Error'),mb_yesNo)=idNo then halt;
   End;

 procedure error260(s:shortString);
   Begin
    s:='Error260, program error. Unproper procedure i.e. "'+s+'" was chosen, program will be halted now.'#13#10+
       'Turn to the author!'#13#10'End of the error 262 description.';
    ShowMessage(s);
    writeln(reportFile,s);
    flush(reportFile);
    halt;
   End;

  procedure error26(s : string; l,m:byte);
    Begin   if stopReading or breakDataReading then exit; //05.11.08; nie generowa komunikatu, gdy nastpia przerwa czytania danych, bo kontrolowane parametry s czytane z nagwka danych i dotycz caego zbioru, a nie jego czci.
     s:='Error 26.'#13#10'The parameter '+s+' differs from expected ones. It should be '+intToStr(l)+
     ', but it turned out that its set contains '+intToStr(m)+' elements. Check "'+inpFileDir+'" data file.';
     s:=s+#13#10'Probably no consequences for computations - proper values will  be applied.'+
     #13#10'End of the error 26 description.';
     ShowMessage(s);
     writeln(reportFile,s);
     flush(reportFile);
    end;{error26}

 procedure error27(n,k1,k2:longWord; s:string);
  Begin
    begin
     s:='Error 27.'#13#10'Program error. Sets counts does not balance or one set is empty: given set has '+intTostr(n)+' members. The first descendant set has '+intToStr(k1)+' memebers, the second has '+intTostr(k2)+' members'+
     #13#10'The sum of the division result is equal to '+intToStr(k1+k2)+#13#10'called from '+s+#13#10'End of the error 27 description.';
     showMessage(s);
     writeln(reportFile,s); flush(reportFile);
    end;
  End;

 procedure error29(result:double;i:word);
  var s : string;
  begin
   s:='error29'#13#10'function "EuclidDist", sum of squares<0!; ='+floatToStrF(result,fffixed,10,2)+
   '; occuread at component nbr='+inttoStr(i)+#13#10'End of the error 29 description';
   showMessage(s);
   writeln(reportFile,s);
   flush(reportFile);
 End; {error29}

 procedure error31(n,k,k1,k2:longWord;s:shortString;callChain:string);
  Begin
   s:='Error31.'+callChain+#13#10'Program error, the balance does not square,'#13#10'set count='+intToStr(n)+
        ' members, found '+intToStr(k)+'.'#13#10'First descendand set contains '+intToStr(k1)+
        #13#10'Second descendand set contains '+intToStr(k2)+#13#10'Sum='+intToStr(k1+k2)+
        #13#10'Called from "'+s+'"'+#13#10'End of the error 31 description.';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
  End;

 procedure error32(const startNodeAddr:longWord;vim:double;s:shortString);

  Begin
   with nodeProps[startNodeAddr] do
    s:='Error 32.'#13#10'Program error, procedure "'+s+'",'#13#10'centroid[componentNbr]<>round(vim), i.e.'+
       ' centroid[componentNbr]='+floatToStr(centroid[componentNbr])+',  round(vim)='+floatToStr(round(vim))+
       #13#10'componentNbr='+intToStr(componentNbr)+#13#10'startNodeAddr='+intToStr(startNodeAddr)+
       #13#10'End of the error 31 description.';
   showMessage(s);
   writeln(reportFile,s); flush(reportFile);
  End;

 procedure error33(const eventNbr,k:longWord);
  var s:shortString;
   Begin
    s:='Error 33.'#13#10'Program error!'#13#10'Should be '+intToStr(eventNbr)+' events in the set free of '+
    'excluded rare events, but it was found '+intToStr(k)+' events!'#13#10'Turn to the author';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

  procedure error34(s:shortString; const startNodeAddr:longWord;step:word);

   Begin
    s:=s+#13#10'Error 34.'#13#10'Program error!'#13#10'Leaf node  was already processed!'#13#10'nbr='+
    intToStr(startNodeAddr)+#13#10'son='+intToStr(nodeHeap[startNodeAddr].son)+
     #13#10'step='+intToStr(step)+#13#10'Turn to the author...'+#13#10'End of the error 34 description.';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

  procedure error35(s:string);
   Begin
    s:='Error 35.'#13#10+s+#13#10'End of the error35  description.';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

  procedure error36(FileDir:string);
   var s:string;
   Begin
    s:=delAmpers('Error36.'#13#10'I/O error, can not rewrite file.'#13#10'Check if directory "'+FileDir+'" is correct!'+
    #13#10'At least the path must exist!'#13#10+
    #13#10'Look at "'+programDir+'" file.'#13#10'May be the file is opened with'+
    ' other program.'#13#10'Check, whether you have not ascribe the questioned file name once more, i. e. a "report" file name to a "collection" file.'+
    #13#10'If yes, then change it in the "Direction" Options tab or close it if opened in other program and run the LVQ again, '#13#10'otherwise remove the"'+FileDir+
    '" file, the new will be created automatically or check if '#13#10'"'+form1.label1.caption+
    '"'#13#10'was not too large) actually it must be <= than '+intToStr(FFTwindowsWidth)+#13#10'Program will be halted now...'#13#10+
    #13#10'End of the error 36 description.');
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
    halt;
   End;

   procedure error37;
    var s:string;
    begin
     s:='You must point a file with the "txt" extension to append to it instead of the'#13#10'"'+Table2CollectionFileDir+'"';
     ShowMessage(s);
     writeln(reportFile,s); flush(reportFile);
    end;

 procedure error39(s:string);
   Begin
    s:='Error 37'#13#10+s+#13#10'End of the error 37 description.';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

  procedure error38(s:string);
   Begin
    s:='Error 38'#13#10+s+#13#10'End of the error 38 description.';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

  procedure error40(i:integer);
   var s:string;
   Begin
    s:=delAmpers('You wanted current analysis should be for "'+form1.RadioGroup2.Caption+'\'+ form1.RadioGroup2.Items[form1.RadioGroup2.ItemIndex]+
   '" feature (see "'+form1.MainMenu1.Items[2].Caption+'\'+form1.TabSheet6.Caption+'),'#13#10'but the previous analysis was performed for the '+
   intToStr(i)+' one, and it was changed to those feature');
    s:='Error 40, procedure "readExcludeSet".'#13#10+s+#13#10'End of the error 40 description.';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

 procedure error42(var i:integer; edit:Tedit;labelx:Tlabel;s:string);
   //CentroidsNb_glob=0, wic zamienia to na 1 i ostrzega
   Begin
    s:=s+#13#10+labelx.Caption+' is<=0!, (see the "'+form1.MainMenu1.Items[2].Caption+'\'+
         form1.PageControl1.Pages[0].Caption+'"). It will be changed to 1.'#13#10'Check the "'+ form1.mainMenu1.Items[2].Caption+'\'+
         form1.PageControl1.Pages[0].Caption+'" and write down a proper value!';
    s:=delAmpers('Error 42, procedure "readExcludeSet".'#13#10+s+#13#10'End of the error 42 description.');
    showMessage(s);
   // writeln(reportFile,s); flush(reportFile);     blokada, bo moe by woany podczas czytania INIT, a wtedy plik report nie jest jeszcze otwarty!
    i:=1; edit.Text:='1';
   End;

 procedure error44;
   var s:string;
   Begin
    s:='You have chosen the "'+form1.RadioGroup3.Caption+'\'+form1.RadioGroup3.Items[1]+'" option, but the exclude set is empty, so '+
        'the program will be performed as if the "'+form1.RadioGroup3.Items[0]+'" was chosen. Nevertheless the reading from the pointed tree parameters will be applied.'+
        'Cause that the set is empty: probably the "'+form1.Label37.Caption+'" treshold value='+intToStr(rareEventNbr2)+' was too low.'#13#10+
        'Check the Table 3 - the "leaf set count" column - in report, to be able to choose a proper value';
    s:=delAmpers('Error 44, procedure "readExcludeSet".'#13#10+s+#13#10'End of the error 44 description.');
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

 procedure error45(const card1,n,eventNbr:longWord);  //error44(excludeSetCard,(n+1) div 8,n,eventNbr);
   var s:string;
   Begin
    s:='Error during reading exclude set was encounteread. Check the "'+treeFileDir+'" file. May be corrupted.'+
    #13#10'If  the "exclude set" is not empty (excludeSetCard>0), then in following rows should appear huge'+
    #13#10'structure containing members of this set, otherwise the next row should be empty';
    s:=s+#13#10'Remember, the "'+form1.radiogroup3.Items[1]+'" pass should be performed with exactly the same options as the "'+form1.radiogroup3.Items[0]+'" one unless you have special purposes.';
     s:=s+#13#10'Size of the exclude set ='+intToStr(card1);
    if n<>eventNbr then s:=s+#13#10'Number of the read event is ='+intToStr(eventNbr)+'. It should be rather set to '+intToStr(n);
    s:=s+#13#10'Reading of the exclude set not completed. It can contain errenously assigned events as "rare event".'+
     ' We recommend to break the program or at lesat to change options, especially change the "'+form1.RadioGroup3.Caption+'\'+
     form1.RadioGroup3.Items[1]+'" option to the "'+form1.RadioGroup3.Items[0]+'".';
    s:=delAmpers('Error 45, procedure "readExcludeSet".'#13#10+s+#13#10'End of the error 45 description.');
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

 procedure error46(s:string;radio:Tradiogroup);
  Begin
  s:=delAmpers('Error 46. '#13#10'Probably the procedure variable "'+s+'" has been not evaluated. You must click proper value in radiogroup "'+
      radio.Caption+'".'#13#10'If it was the case, then next time launching (in order the evaluation takes place)'+
      ' click other value and then the proprer one.'#13#10'The program will be halted now.'+
      #13#10'End of the error 46 description.');
  showMessage(s);
  writeln(reportFile,s); flush(reportFile);
  Halt;
 end;{error46}

 procedure error47(s:string);
  begin
   with form1 do
   s:=delAmpers('Error 47'#13#10'The RAM resources assigning for '+s+' failed.'#13#10'You must lower class number, i.e. "'+ mainMenu1.Items[2].Caption+'\'+
   PageControl1.Pages[1].Caption+'\'+Label5.Caption+'" or readuce data size, use "'+ mainMenu1.Items[2].Caption+'\'+PageControl1.Pages[1].Caption+
   '\'+CheckBox36.Caption+'".'#13#10'The program will be halted now'#13#10'End of the error 47 description');
   showMessage(s);
   writeln(reportFile,s); flush(reportFile);
   Halt;
  end;{error47}

 procedure error48;
  var s:string;
  begin
   with form1 do
   s:=delAmpers('Error 48'#13#10'The RAM resources assigning for vector list or for one of the answer list failed (procedure "vectorAndCathListRead").'#13#10+
   'You must readuce data size, use "'+ mainMenu1.Items[2].Caption+'\'+PageControl1.Pages[1].Caption+
   '\'+CheckBox36.Caption+'".'#13#10'The program will be halted now'#13#10'End of the error 48 description');
   showMessage(s);
   writeln(reportFile,s); flush(reportFile);
   Halt;
  end;{error48}

 procedure error49;
  var s:string;
  begin
   with form1 do
   s:=delAmpers('Error 49'#13#10'The RAM resources assigning for leaves sets cardinals list failed (procedure "FinalIRToreport").'#13#10+
   'May be you must reduce data size, use "'+ mainMenu1.Items[2].Caption+'\'+PageControl1.Pages[1].Caption+
   '\'+CheckBox36.Caption+'". May be the feature set is empty, so check also "'+label109.Caption+'" or the "'+
    label110.Caption+'".'#13#10'You must also take into account the "'+label1.Caption+'" parameter.'#13#10+
    'Check RAM allocation for the "vectList" variable.'#13#10+ 'or you have tried to repaint plots just after decreasing of "'+label5.caption+'"'#13#10+
    'Check, whether the number of events  is >=2'#13#10+
    'Number of read events is='+intToStr(trueEventNbr)+#13#10+
    'End of the error 49 description');
   showMessage(s);
   writeln(reportFile,s); flush(reportFile);
  end;{error49}

 procedure error50(n,cardinal:longWord;s:shortString);
  Begin
   s:='Error50,'+s+'.'#13#10'Program error, the balance does not square,'#13#10'found '+intToStr(n)+' members,'+
        #13#10'set should contain '+intToStr(cardinal)+'.'#13#10'End of the error 50 description.';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
  End;{error50}

procedure error51;
 var s:string;
 Begin
  s:='Error51, some error with "'+form1.RadioGroup24.Caption +'" occuread'#13#10'End of the error 51 description.';
  showMessage(s);
  writeln(reportFile,s); flush(reportFile);
 End;{error51}

 procedure error52(s:shortString; hb,lb:longWord);
  Begin
   s:='Error 52'#13#10'Indeks borders ('+s+') are wrong - the first one should be >= then the second one, meanwhile they are: ('+intTostr(hb)+',  '+intToStr(lb)+').'+
  #13#10'Program error, turn to the author'#13#10'End of the error 52 description.';
   showMessage(s);
   writeln(reportFile,s); flush(reportFile);
  End;

 procedure error53(n,excludesetCard:longWord);
  var s:String;
   Begin
    s:='Error 53: Error in reading or saving exclude set. It contains '+intToStr(n)+
    ' members, but should contain (as read from the tree file) '+intToStr(excludesetCard)+' members'#13#10+
    'Probably program error or the tree file ('+treeFileDir+') is corrupted'#13#10'End of the error 53 description';
    showMessage(s);
    writeln(reportFile,s); flush(reportFile);
   End;

 procedure error54(const n,Card:longWord; const leaf:word; s:String;callChain:string);
  Begin
   s:='Error 54; '+callChain+#13#10' Error in making leaf sets. Leaf set nbr '+intToStr(leaf) +' contains '+intToStr(n)+
      ' members, but should contain '+intToStr(Card)+' members'#13#10'Program error, turn to the author'#13#10+
      'Occuread in the procedure '+s+#13#10'End of the error 54 description';
   showMessage(s);
   writeln(reportFile,s); flush(reportFile);
  End;

 procedure error55(s:shortString;callChain:string);
  Begin
   s:='Error 55; '+callChain+#13#9'Unknown error occuread in the procedure "CARTbestDivision".'#13#10+
   'The parameter "trial_or_fixed" equal to "'+s+'" and is different both from "trial" and from "fixed"'#13#10+
   'The program should be checked, turn to the author...'#13#10'End of the error 55 description';
   showMessage(s);
   writeln(reportFile,s); flush(reportFile);
  End;

 procedure error56(const j,lbhb:int64; s:shortString;callChain:string);
  Begin
   s:='Error 56; '+callChain+#13#10'Error detected in the procedure "'+s+'".'#13#10+
   'Count of created set members does not balance with borders indexes. Should be '+ intToStr(lbHb)+' but is '+intToStr(j)+
   #13#10'The program should be checked, turn to the author...'#13#10'End of the error 56 description';
   showMessage(s);
   writeln(reportFile,s); flush(reportFile);
  End;

 procedure error57(const lb2hb1:int64; s:shortString;callChain:string);
  Begin
   s:='Error 57; '+callChain+#13#10' Error detected in the procedure "'+s+'".'#13#10+
   'High and low indexes of descendant sets  differ too much. The difference should be 1, but is '+ intToStr(lb2Hb1)+
   #13#10'The program should be checked, turn to the author...'#13#10'End of the error 57 description';
   showMessage(s);
   writeln(reportFile,s); flush(reportFile);
  End;

 procedure error58(s:shortString);
  Begin
   s:='Error 58: Error detected in the procedure "'+s+ #13#10'Standard deviation <0'+
   #13#10'The program should be checked, turn to the author...'#13#10'End of the error 58 description';
   showMessage(s);
   writeln(reportFile,s); flush(reportFile);
  End;

 function error59(programDir:string):boolean;
  var s:string;
  Begin

   s:='Error 59: File of last used options, i.e.'#13#10'"'+programDir+
   '"'#13#10'is corrupted'#13#10'Check it or remove - in this case the new one will be generated automatically, or'#13#1'would you load defaults settings now?';
   result:=messageDlg(s,mtConfirmation,mbyesNo,0)=mrYes;
   if fileExists(reportFileDir) then
   with TTextRec(reportFile) do if mode=fmOutput then
   begin writeln(reportFile,s); flush(reportFile) end;
   if fileExists(programDir) then
   with TTextRec(initFile) do if mode<>fmClosed then
   close(initFile);
  End;

procedure error60(programDir,proc:string);
 var s:string;
   Begin
    s:='Error 60: Some error in the procedure "'+proc+'" or file "'+programDir+'" has occuread, turn to the author.';
    showMessage(s);
     if fileExists(reportFileDir) then
    with TTextRec(reportFile) do if mode=fmOutput then
    begin writeln(reportFile,s); flush(reportFile) end;
     if fileExists(programDir) then
    with TTextRec(initFile) do if mode<>fmClosed then
    close(initFile);
   End;

 procedure error61(s:string);
  begin
   s:='Error 61.'#13#10 +'The "'+LVQinitDir+'" file  (init file)'+s+#13#10'It will be created with the default values. Probably you will wish to change the program options.'+
    #13#10'It is reccomended now to to click the "OK" button on the option page  and close and reopen the program or step in the "Options" and click different radiogroups to ensure the "on Click" events will be activated to evaluate the program parameters'+
    ' (especially the ones contained in the "'+ form1.mainMenu1.Items[2].Caption+'\'+form1.PageControl1.Pages[3].Caption+'" page)'#13#10'End of the error 61 description';
   ShowMessage(s);
   if fileExists(reportFileDir) then
    with TTextRec(reportFile) do if mode=fmOutput then
    begin writeln(reportFile,s); flush(reportFile) end;
     if fileExists(programDir) then
    with TTextRec(initFile) do if mode<>fmClosed then
   close(initFile);
   InitDefaults;
  end;

 procedure error62(s:string);
  begin
   s:='Error 62. Pertains results from a table 6 computed by a procedure standardDeviationRatiol\TreeExaminer;'#13#10 +s+#13#10+
   'Error can arrise due to roundings. 0 value will be taken and the procedure will continue.'#13#10+
   'If the value is not very small then this happened due to the program error, turn to the author.'#13#10+
   'End of the error description';
   ShowMessage(s);
   writeln(reportFile,s); flush(reportFile);
  end;{error62}

 procedure error63(n2,n1:int64); //EventNbr<high(vectList)
  var s:string;
  begin
   s:='Error 63. Take care, some mistake in program exists resulting in unnecessary RAM reallocation in case of data reading braking, turn to the author.'#13#10+
   'EventNbr (='+intToStr(n2)+') should be <high(vectList) (='+intToStr(n1)+') because data reading was broken.'#13#10+
   'No measures will be taken and the program will be continued.'#13#10+
   'End of the error description';
   ShowMessage(s);
   writeln(reportFile,s); flush(reportFile);
  end;{error62}

 procedure error64(i:integer;callChain:string);
  begin
   callChain:=callChain+'>error64';
   showMessage('Error 64 occured at the "for i='+intToStr(i)+' point. It could be caused because of killing the "leafCardArr" variable, or false RAM allocation to it');
  end;

 procedure error65(s1, cathName:string; const p1,p2:extended;mult:integer;step:word;callChain:shortString);
 //s1 - parameter name, cathName - cath#Name, #=1, 2, 3, 4
  var s:string;
  begin
   callChain:=callChain+'>error65';
   if p1+p2=0 then exit;
   if round(mult*(p1-p2)/(p1+p2))<>0 then
    begin
     s:='error65'#13#10'Program Error, located in a call chain:" '+callChain+'", at step='+intToStr(step)+'. Turn to the author.'#13#10'Control sum of the "'+cathName+'" cathegory of the parameter "'+s1+
        '" processing value is significantly different from the expected "'+s1+'" value, i.e. '#13#10+
        FloatToStrF(p1,ffexponent,6,2)+'<>'+FloatToStrF(p2,ffexponent,6,2)+'; delta='+FloatToStrF(p1-p2,ffexponent,6,2)+#13#10'X=Cancel="'+form1.button16.caption+
       '". Program can be continued with current data,'#13#10'Abort=Check out this control';
     case MessageDlg(s,mtWarning,[mbOk,mbCancel,mbAbort],0) of

    1:  begin {mrOK}
         s:=s+#13#10' "OK" chosen, program continued';
        end ;
     2: begin {mrCancel}
         s:=s+' "Cancel" chosen, session thrown out';
         unit1.button16_click(callChain);
        end;
    3:  begin {mrAbort}
         s:=s+#13#10' "Abort" chosen, this control will not be performed. ';
         s:= s+#13#10'End of the error65 description';
         Writeln(reportFile,#13#10'------------'#13#10+s+#13#10'------------'#13#10);
         form1.checkBox55.checked := false;
        end;
     end; {case}
     s:= s+#13#10'End of the error65 description';
  Writeln(reportFile,#13#10'------------'#13#10+s+#13#10'------------'#13#10);
    end
   else exit;
  end;{error65}


 procedure Error66(i,readEventNbr:longWord; excludeSet:TarrSet;callChain:string);
  var s:string;
  begin
   callChain:=callChain+'>error66';
   s:='Callchain= "'+callChain+'".';
   s:=s+#13#10'The exclude set card (='+intToStr(i)+')  is bigger than 5% of numbers of events (='+
   intToStr(readEventNbr)+' the 5% is='+intToStr(round(readEventNbr*0.05))+').'+#13#10'You should lower the "';
   with form1 do s:=s+TabSheet7.Caption+'\'+label37.Caption+'" parameter (='+edit13.Text +' for now).';
   s:=s+#13#10'Should the Exclude Set be empted (OK), or Exclude Set stay unchanged, program continued (Cancel),'+
   ' or should the Exclude Set stay unchanged, and sesion thrown out (Abort) - to continue with changed Options ?';
   case MessageDlg(s,mtWarning,[mbOk,mbCancel,mbAbort],0) of

    1:  begin {mrOK}
         s:=s+#13#10'OK chosen, The Exclude Set empted, program continued';
         emptyMegaSet(excludeSet);
        end ;
     2: begin {mrCancel}
         s:=s+'Cancel chosen, The Exclude Set unchanged, program continued';
        end;
    3:  begin {mrAbort}
         s:=s+#13#10'Abort chosen, The Exclude Set unchanged, sesion thrown out;'+
           ' you can change settings now and continue as the next session with the same data';
         unit1.button16_click(callChain);
        end;
    end; {case}
    s:=s+'End of the error66 description';
    Writeln(reportFile,#13#10'------------'#13#10+s+#13#10'------------'#13#10);
  end;{error66}

 procedure error67(inpFileDir,currentDataSource,callChain:string);
  var s:string;
  Begin
   callChain:=callChain+'>error67';
   s:='call chain="'+callChain+'"'#13#10;
   s:=s+'The data source for the tree building, i.e. the "'+ inpFileDir+
     '", and consequently - for the Exclude Set creating - differs from actually processed, i.e. the "'+currentDataSource+'".'+
     #13#10'Remember, the Exclude Set contains time adresses of events, not events itself!'+
     #13#10'Should the processing be continued (OK), or canceled (Cancel) or halted (Abort)?';

    case MessageDlg(s,mtWarning,[mbOk,mbCancel,mbAbort],0) of
    1:  begin {mrOK}
         s:=s+#13#10'OK chosen, program continued, processing with current data';
        end ;
     2: begin {mrCancel}
         s:=s+'Cancel chosen, sesion thrown out, you can change settings (e.g. treeFileDir containing the proper Exclude Set) now, and continue processing with current data source';
         unit1.button16_click(callChain);
        end;
    3:  begin {mrAbort}
         s:=s+#13#10'Abort chosen, program halted on request';
         s:= s+#13#10'End of the error67 description';
         Writeln(reportFile,#13#10'------------'#13#10+s+#13#10'------------'#13#10);
         halt
        end;
    end; {case}
    s:=s+#13#10'End of the error67 description';
    Writeln(reportFile,#13#10'------------'#13#10+s+#13#10'------------'#13#10);
  End;{error67}

 procedure error68(i,readEventNbr:longWord;callChain:string);
  var s:string;
  Begin
   callChain:=callChain+'>error68';
   s:='call chain="'+callChain+'"'#13#10;
   s:=s+'Actually processed data file contains more events (i.e. '+intToStr(readEventNbr)+'), than the one, which was used for the Exclude Set creation (i.e.'+ intToStr(i)+')'+
      #13#10'It means, that the Exclude Set can not contain all rare events.'#13#10+
      'Decide, whether: continue current data processsing (OK), or cancel current session (Cancel) or halt processing (Abort)';
   case MessageDlg(s,mtWarning,[mbOk,mbCancel,mbAbort],0) of
    1:  begin {mrOK}
         s:=s+#13#10'OK chosen, program continued, processing with current data';
        end ;
     2: begin {mrCancel}
         s:=s+'Cancel chosen, sesion thrown out, you can change settings (e.g. treeFileDir containing the proper Exclude Set) now, and continue processing with current data source';
         unit1.button16_click(callChain);
        end;
    3:  begin {mrAbort}
         s:=s+#13#10'Abort chosen, program halted on request'#13#10'End of the error68 description';;
         Writeln(reportFile,#13#10'------------'#13#10+s+#13#10'------------'#13#10);
         halt
        end;
    end; {case}
    s:=s+#13#10'End of the error68 description';
    Writeln(reportFile,#13#10'------------'#13#10+s+#13#10'------------'#13#10);
  End;{error68}

 procedure error69(excludeSetCard,readEventNbr,rareEventNbr2:longWord;callChain:string);
  var s:string;
  Begin
    callChain:=callChain+'>error69';
   s:='Call Chain: "'+callChain+'"'#13#10+
    'Exclude set contains all events, i.e. "'+form1.label6.Caption+'='+intToStr(excludeSetCard)+
    '" and a "Number of read events='+intToStr(readEventNbr)+'", so no cluster analysis can be performed.'#13#10+
    'The parameter "'+form1.Label37.Caption+'" was too big (='+intToStr(rareEventNbr2)+
    ').'#13#10'Revise this parameter and perform new cluster analysis in the mode "'+
    form1.RadioGroup3.Caption+'/'+ form1.RadioGroup3.Items[0]+ '" to obtain a proper set of rare events'#13#10+
    'Click "'+form1.MainMenu1.Items[2].Caption+'" change the options, and try again'#13#10+
    #13#10'Decide, whether: cancel current session (Cancel) or halt processing (Abort)';
     case MessageDlg(s,mtWarning,[mbCancel,mbAbort],0) of
    1:  begin {mrOK}
         s:=s+#13#10'OK chosen, program continued, processing with current data';
        end ;
     2: begin {mrCancel}
         s:=s+'Cancel chosen, sesion thrown out, you can change settings now, and continue processing with current data source.'#13#10+
         'The "'+form1.RadioGroup3.Caption+'" will be switched to the "'+form1.RadioGroup3.Items[0]+'" position.';
         unit1.button16_click(callChain);
        end;
    3:  begin {mrAbort}
         s:=s+#13#10'Abort chosen, program halted on request'#13#10'End of the error69 description';;
         Writeln(reportFile,#13#10'------------'#13#10+s+#13#10'------------'#13#10);
         halt
        end;
    end;{case}
   s:=s+#13#10'End of the error69 description';
   Writeln(reportFile,#13#10'------------'#13#10+s+#13#10'------------'#13#10);
   form1.RadioGroup3.ItemIndex:=0;
  End;{error69}


 procedure Error70(callChain:string);
  var s:string;
  begin
   s:= 'Error70. '+callChain+#13#10'Program tried to save last options to "'+LVQinitDir+'", but failed to do it.'+
       #13#10'Next time the program will be opened with old or default parameters';
   ShowMessage(s);
   Writeln(reportFile,callChain,#13#10'------------'#13#10+s+#13#10'------------'#13#10);
  end;{error70}

  procedure Error71(nc,vectorsSize:word;callChain:string);
   var s:string;
   Begin
    s:='Error71. '+callChain+#13#10'The index cut-off treshold for features including is too high. It should be <='+
     intToStr(vectorsSize)+', it is = '+intToStr(nc)+'.'+
     #13#10'It was given the value '+intToStr(vectorsSize)+' for now.'+
     #13#10'You should check what value it was given at the spectral analysis stage.'+
     #13#10'To check and correct to suitable value the "'+form1.Label1.Caption+'" at the "'+form1.TabSheet1.Caption+ '(click the "'+
     form1.mainmenu1.Items[2].Caption+'" at the main menu).';
    ShowMessage(s);
    Writeln(reportFile,callChain,#13#10'------------'#13#10+s+#13#10'------------'#13#10);
   End;

 procedure error80;
  begin
   ShowMessage('The "SetSuspendState" function failed, komputer will not be hibernated.'#13#10'May be the "SuspendOrHibernate" program should was applied.');//'SuspendOrHibernate failed'#13#10'May be newer version of this procedure should be applied');
  end;

 procedure error100;
  var s:string;
  begin
   s:='Error 100.'#13#10 +'Error probably caused by erronous data format, or RAM was not allocated to "dataRecord.vect", or "'+inpFileDir+'" was not reset'#13#10+
   ' 1. Check whether following conditions for the file'#13#10+inpFileDir+#13#10'were fullfilled:'#13#10+
   ' 2. All introductory comments appearing at the beginning  will be skipped until the first integer value.'#13#10+
   ' 3. Each row contains description of one event: features vector and its classification according to values of 4 cathegorical variables.'#13#10+
   ' 4. Values of the cathegorical variables can be proceeded by any number of spaces and tabs; they will be skipped.'#13#10+
   ' 5. Remember! All cathegorical variable values can be encoded with ONLY ONE character!!'#13#10+
   ' 6. First integer number greater than 0 will be interpreted as number of events (eventNbr). Every trailing nonvisual'#13#10+
   ' 7. signs, spaces and other chars proceeding 0 (#48) will be skipped here.'#13#10+
   ' 8. Second one, in the next row, will be interpreted as number of vectors components  (nc).'#13#10+
   ' 9. Third one, in the next row, will be interpreted as  components values range.'#13#10+
   '10. Next row is the table header; cathegorical variable names are read from here.'#13#10+
   '11. First 4 columns will be interpreted as cathegory, classyfying values (values of 4 dependent variables)'#13#10+
   '12. Next nc columns will be read as vectors components'#13#10+
   '13. Prepare data file with MS Excel and export it as a txt file to avoid unnecessary characters.'#13#10+
   'End of the error 100 description';
    ShowMessage(s);
    if fileExists(reportFileDir) then
     with TTextRec(reportFile) do if mode=fmOutput then
     begin writeln(reportFile,s); flush(reportFile) end;
  end;{error100}


end.


