unit LVQ_spr_Drawings;

interface
uses ExtCtrls,graphics,forms,sysutils,types,dataProcessor;
const max_buffer =512;                       {power of 2! (FFT)}
type

        TdbArr = array of double;
      realType = double;
        v_l_vc = array[0..max_buffer-1] of realType;
      rAryType = ^v_l_vc;
TdrawingsParam = record
          rPanelNbr,rDecimals:byte;
                   rHalf,rRev:boolean;
                xrange,yrange:word;
                   chartColor:longint;
                 end;

var
                            StartShift,count_cp : longWord;
      wspx1,wspy1,wspx2,wspy2,wspx3,wspy3,wspx4,
      wspy4,wspx5,wspy5,wspx6,wspy6,panel4Scale : double;        //wspczynniki proporcjonalnoci dla poszczeglnych paneli
      centr1,centr2,centr3,centr4,centr5,centr6 : integer;        //centra pionowe dla poszczeglnych paneli
                rep,clear2,clear3,clear4,clear5 : boolean;
                       cathFileDir, waveFileDir : shortString;
ringBuffChangePointArr,frameNbrArr,frameNbr0Arr : array of integer;  //for multi CCR processing
                                    drawingsArr : array of TdrawingsParam;
                                         winNbr : byte;
                             StreamsGraphColors : array[0..10] of longint=(clWhite,clBlue,clBlue,clBlack,clLime,clYellow,clRed,clBlue+100,clLime,clYellow,clRed);
                                x1range,y1range : word;
                                            zn1 : AnsiChar=#0;
                                            scc : array of single; //[0..11], scale coefficients (magnifiers)
                                         contr1 : variant;
procedure FramesRepaint;
procedure DataFrame(Panel:TPanel;canvas:tcanvas;const xStretch:longWord; const stretch:double;
 const decimals:shortInt; out wspx,wspy:double; out centr:integer; const half,revers:boolean;Xdescr:shortString);
procedure OscDraw(panel:tpanel;const scaler:single;canvas:tcanvas; const y:TresArray; wspx,wspy : double; centr:integer;
  const count:longWord; const clear:boolean;const chartColor:longInt; it:longWord; var annotation:boolean);
procedure SpcDraw(panel:tpanel;const scaler:single;canvas:tcanvas; const y:TresArray; wspx,wspy:double; const centr:integer;
  const count:longWord; var clear:boolean; var chartColor:longInt; const clip:boolean; const F0:single);

procedure mainOscTics(const i:dword; const jumpNbrSamples:word);
procedure DataFrames;
procedure showGraph(const i:byte; const scaler:single; const analysis:TresArray;const F0:single);
procedure T0plot(const iw:dword;F0:single; zn2:AnsiChar);

implementation
uses system.UITypes,visualization;
var
 //count : word; //odczyta warto //blokada 190219
 temp,tempus : variant;
 annotation : boolean;
procedure FramesRepaint;  //Nie wywietla niczego, tylko czyci!
  //repaints drawings frames
 Begin
   DataFrames;
 End;{FrameRepaint}


  procedure HorizTic(Panel:TPanel;canvas:tcanvas;const wspx:double; const xStretch,Xrefr:dword;Yrefr:integer);
  { refr - polozenie podpisu w pionie
    Xrefr - odniesienie poczatkowe opisu wsp X
  }
   var d:double; i:byte; x:word; s:shortString;
   Begin
    d:=xStretch/20;
    with Panel,canvas do
     begin
      for i:=0 to 20 do
       begin
        x:=round(left+round(i*d)*wspx);
        moveTo(x,Yrefr);
        if i mod 2 =0 then
         begin
          lineTo(x,Yrefr+8);  application.processmessages;           //tic
          s:=intToStr(round(i*d)+Xrefr);                             //nbr
          TextOut(x,Yrefr-6-Font.Height,s);                          //write nbr
         end
        else lineTo(x,Yrefr+6);  application.processmessages;        //small tic
       end;
     end;{with}
   End;{HorizTic}


procedure DataFrame(Panel:TPanel;canvas:tcanvas;const xStretch:longWord; const stretch:double;
 const decimals:shortInt; out wspx,wspy:double; out centr:integer; const half,revers:boolean;Xdescr:shortString);
  //Wykrela ramki pokazujce pole wykresu
  //wspx,wspy - wspczynniki proporcjonalnoci dla okna
  //centr - rodek w pionie pola rysunku
  //fest - liczba przedziaw zmiennej na posi (zalena od wysokoci cyfr)
  var i,j,k,fest:integer; d:integer; s:shortString;

  procedure tick(const sign:shortInt);
  Begin
   k:=j;
   with panel,canvas do
    begin
     if half then
      if revers then j:=top+sign*round(i*height/fest)
      else j:=centr-sign*round(i*height/fest)
     else j:=centr-sign*round(i*height/(2*fest));
     if revers and half then d:=d-j+k
     else d:=d+j-k;                     //d increases until a tick number is writen down, then d:=0
     moveTo(left-3,j);
     lineTo(left,j); application.processMessages;     //tick
    end;
  End;{tick}

  procedure number(const sign:shortInt);
   var m:Integer;
   begin
    with panel,canvas do
     begin
      if sign*d<Font.Height then
      begin
       s:=floatToStrF(sign*(i*stretch/fest),ffFixed,8,decimals);
       for m:=1 to 7-length(s) do s:=' '+s;  //equalizing of the description length to 8 by adding spaces fom front
       canvas.TextOut(left-6*font.Size,j+Font.Height,s);   application.processMessages;
       moveTo(left-5,j);
       lineTo(left+1,j); application.processMessages;     // numbers tick
       d:=0;                             //d increases until a tick number is writen down, then d:=0
      end;{if}
     end;{with}
   end;{number}

  Begin  //--------------------------------DataFrame---------------------------
   with Panel,canvas do
    begin
     if half then
      begin
       fest:=height div 16;   //ticks spaces
       centr:=top+height;
       wspy:=(height)/stretch;
      end
     else
      begin
       fest:=height div 16;   //ticks spaces
       centr:=round(top+height/2);
       wspy:=0.5*(height)/stretch;
      end;
     wspx:=(width)/xStretch;
     Pen.Color:=clBlack;//clred;      //big red rectangle
     Rectangle(left-16-5*font.Size,top-5,left+Width+5, top+Height-font.Height+10); application.processMessages;  //big rectangle
     Pen.Color:=clwhite;  application.processmessages;
     Rectangle(left{-2},top{-1},left+Width{+1}, top+Height+{1}2); application.processmessages;                         //exact rectangle
     moveTo(left,centr);
     lineTo(left+width,centr);    application.processmessages;
     d:=0; if revers and half then j:=top else j:=centr;
     for i:=1 to fest do  // positive part of dependent axis
      begin
       tick(1);
       number(1);        //<, because font.height is <0
      end;
     d:=0; j:=centr;
     if not half then
     for i:=1 to fest do    // negative part of dependent axis
      begin
       tick(-1);
       number(-1);
      end;
      moveTo(left,centr);
    end;
    with panel do canvas.TextOut(left,top+height+14,Xdescr);
 //  HorizTic(horizScaleRefr);      procedure HorizTic(Panel:TPanel;canvas:tcanvas;const wspx:double; const xStretch,Xrefr,Yrefr:word);
   application.processmessages;
  End;{DataFrame}

procedure DataFrames;
 (*
  procedure frame(Panel:TPanel;canvas:tcanvas;const xStretch:longWord; const stretch:double;
 const decimals:shortInt; out wspx,wspy:double; out centr:integer; const half,revers:boolean;const horizScaleRefr:word);
  *)
  var i:shortint;  panelSet:set of byte;
 begin
  form2.canvas.Font.Height:=-9;
  with F0panelDecHalfRev,form2 do DataFrame(Panel1,form2.canvas,x1range,{y1range}1000*F0count/(2*rate),rDecimals,wspx1,wspy1,centr1,rHalf,rRev,'     Time points'); //,panel1.top+panel1.height
  panelSet:=[];
  for i:= 0 to nbrOfStreams-1 do
   with form2, drawingsArr[i] do
      begin
       if not (rPanelNbr in panelSet) then
        begin
         case rPanelNbr of   //frame(Panel:TPanel;canvas:tcanvas;const xStretch:longWord; const stretch:double;const decimals:shortInt; out wspx,wspy:double; out centr:integer; const half,revers:boolean);
          2 : begin          //HorizTic(Panel:TPanel;canvas:tcanvas;const wspx:double; const xStretch,Xrefr,Yrefr:word);
               DataFrame(Panel2,canvas,xrange,yrange,rDecimals,wspx2,wspy2,centr2,rHalf,rRev,'Time points');
               HorizTic(Panel2,canvas,wspx2,xRange,0,panel2.top+panel2.height);
              end;
          3 : begin
               DataFrame(Panel3,canvas,xrange,yrange,rDecimals,wspx3,wspy3,centr3,rHalf,rRev,'Frequency FFT points');
               HorizTic(Panel2,canvas,wspx3,xRange,0,panel3.top+panel3.height);
              end;
          4 : begin
               DataFrame(Panel4,canvas,xrange,yrange,rDecimals,wspx4,wspy4,centr4,rHalf,rRev,'FFT time points');
               HorizTic(Panel2,canvas,wspx4,xRange,0,panel4.top+panel4.height);
              end;
          5 : begin
               DataFrame(Panel5,canvas,xrange,yrange,rDecimals,wspx5,wspy5,centr5,rHalf,rRev,'FFT time points');
               HorizTic(Panel2,canvas,wspx5,xRange,0,panel5.top+panel5.height);
              end;
         end;{case}
         panelSet:=panelSet+[rPanelNbr];
        end;{if}
      end;{with}
 end;{DataFrames}

 function T0annotate(panel:Tpanel;chartColor:longint;var zn1,zn2:AnsiChar):boolean;
 var
      tp:Tpoint;
  Begin
   result:=true;
   if (zn1<>zn2) then                 //opis fonematyczny maego oscylogramu
  with form2,panel do
    begin
     form2.Canvas.Pen.Color:=clyellow;
     tp:=canvas.penPos;
     canvas.TextOut(tp.X-8,top+2,zn2);
     canvas.MoveTo(tp.X-1,top+2);
     canvas.LineTo(tp.X,top+24);
     canvas.MoveTo(tp.X,tp.y);
     zn1:=zn2;
     form2.Canvas.Pen.Color:=chartColor;
    end {opis fonem.}
   else result:=false;
  End;{T0annotate}

 procedure OscDraw(panel:tpanel;const scaler:single;canvas:tcanvas; const y:TresArray; wspx,wspy : double; centr:integer;
  const count:longWord; const clear:boolean;const chartColor:longInt; it:longWord; var annotation:boolean);
//---------------------oscylogram danych wave
var
    i,k : longWord;
      j : longint;
    zn1 : char;
waveVal : TsingInt;
    label e1;
 procedure clipper;
  Begin
   with panel do
    begin
     if j<top then j:=top;
     if j>top+Height then j:=top+Height;
    end;{with}
  End;{clipper}

  Begin  //========================OscDraw=========================
   if not form2.CheckBox1.Checked then exit;//show graphics
   panel.Visible:=false;
   if not rep and clear then    //do not clear graph when repeat command was sent
    with panel,canvas do
     begin
      pen.Color:=clWhite;
      rectangle(Left,Top,left+Width,Top+Height+2);
      canvas.Pen.Color:=clOlive;              //clear rubish at the end of the graph
      canvas.moveTo(left+width,top);
      canvas.LineTo(left+width,top+height);
      Canvas.Pen.Color:=clLime;
     end;{with}
   zn1:=#0;
   with panel do
    begin
     j:=centr;
     if j<=top then goto e1;
     if j>=top+Height then goto e1;
     form2.Canvas.Pen.Color:=clwhite;
     form2.Canvas.moveTo(left,centr);            //--------------------ten kolor nie jest aktywowany!
     form2.Canvas.lineTo(left+width,centr);
e1:  form2.Canvas.moveTo(left,centr);
     form2.Canvas.Pen.Color:=chartColor;
    end;
   application.processMessages;
   waveVal:=TsingInt(y[0]);     //go to start a line plotting
   j:=round(waveVal[0]*wspy*scaler+centr);
   with panel do
    begin
     clipper;
     form2.Canvas.moveTo(left,j);
    end;{with}
   k:=0;
   for i:=0 to (count+1) div 2-1 do
    with Panel do
     begin
      waveVal:=TsingInt(y[i]);      //decode every one number of the type single as some two numbers of the type smallInt
      j:=round(waveVal[0]*wspy*scaler+centr);
      clipper;
      canvas.LineTo(round(k*wspx+left),j);
      inc(k);
      j:=round(waveVal[1]*wspy+centr);
      clipper;
      canvas.LineTo(round(k*wspx+left),j);
      inc(k);
      application.processMessages;                  //Uwaga! skasuje narysowany oscylogram, jeli wczeniej nie wywoano jeszcze processmessages
     end;{for}
  End;{OscDraw}

 procedure T0Line(cpstrPoint:word;wspx,wspy:double;LineColor:tcolor; panel:Tpanel);
  begin
   with Panel,form2.canvas do
    begin
     form2.Canvas.Pen.Color:=lineColor;
     form2.Canvas.moveTo(round(cpstrPoint*wspx+left),top);
     form2.canvas.LineTo(round(cpstrPoint*wspx+left),top+height);
    end;
  end; {lifterLine}

procedure SpcDraw(panel:tpanel;const scaler:single;canvas:tcanvas; const y:TresArray; wspx,wspy:double; const centr:integer;
  const count:longWord; var clear:boolean; var chartColor:longInt; const clip:boolean;const F0:single);
//---------------------oscylogram danych wave

var
    i : longWord;
    j : int64;
    label e1;
procedure clipper;
 Begin
  with panel do
   begin
    if j<top then j:=top;
    if j>top+Height then j:=top+Height;
   end;{with}
 End;{clipper}

  Begin  //----------------SpcDraw-------------------------------
   if not form2.CheckBox1.Checked then exit;//show graphics
   panel.Visible:=false;
   if not rep and clear then    //do not clear graph when repeat command was sent
    with panel,canvas do
     begin
      pen.Color:=clWhite;
      rectangle(Left,Top,left+Width,Top+Height+2);
      canvas.Pen.Color:=clOlive;              //clear rubish at the end of the graph
      canvas.moveTo(left+width,top);
      canvas.LineTo(left+width,top+height);
      Canvas.Pen.Color:=clLime;

     end;{with}
   clear:=false;
   with panel do
    begin
     j:=centr; i:=0;
     if j<top then goto e1;
     if j>top+Height then goto e1;
     form2.Canvas.Pen.Color:=clwhite;
     form2.Canvas.moveTo(left,centr);                                           //--------------------ten kolor nie jest aktywowany!
     form2.Canvas.lineTo(left+width,centr);
e1:  form2.Canvas.moveTo(left,centr);
     form2.Canvas.Pen.Color:=chartColor;
    end;
   j:=high(y);
   application.processMessages;
   j:=round(-y[0]*wspy*scaler+centr);
   if clip then clipper;
   canvas.MoveTo(round(panel.left),j);
   for i:=1 to count do with Panel do
    begin
     j:=round(-y[i]*wspy*scaler+centr);
     if clip then clipper;
     canvas.LineTo(round(i*wspx+left),j);
     application.processMessages;                  //Uwaga! skasuje narysowany oscylogram, jeli wczeniej nie wywoano jeszcze processmessages
    end;
    if panel=form2.Panel4 then
     try
      T0Line(round((rate/F0)),wspx,wspy,clgreen, panel);
      T0Line(cpstrPoint,wspx,wspy,clWhite, panel)
     except
     end;{try}
  End;{SpcDraw}

procedure showGraph(const i:byte; const scaler:single; const analysis:TresArray; const F0:single);
{
 OscDraw(panel:tpanel;canvas:tcanvas; const y:TdbArr; wspx,wspy : double; centr:integer;const count:longWord; const clear:boolean;const chartColor:longInt; it:longWord; var annotation:boolean);
 drawingsArr contains graphics data of panels. It was created on the basis of the 4-th record of the data
}
 Begin
  with drawingsArr[i] do
   with form2 do //SpcDraw(panel:tpanel;canvas:tcanvas; const y:TdbArr; wspx,wspy:double; const centr:integer; const count:longWord; clear:boolean; const chartColor:longint; const clip:boolean; const F0:single);
   case rPanelNbr of //procedure OscDraw(panel:tpanel;canvas:tcanvas; const y:TresArray; wspx,wspy : double; centr:integer;const count:longWord; const clear:boolean;const chartColor:longInt; it:longWord; var annotation:boolean);
    2 : OscDraw(panel2,scaler,canvas,analysis,wspx2,wspy2,centr2,xrange,true,chartColor,i,annotation);       //oscylogram okienka;
    3 : SpcDraw(panel3,scaler,canvas,analysis,wspx3,wspy3,centr3,xrange,clear3,chartColor,checkBox4.Checked,F0);
    4 : SpcDraw(panel4,scaler,canvas,analysis,wspx4,wspy4,centr4,xrange,clear4,chartColor,checkBox5.Checked,F0);       //cepstrum urednione czasowo z korekt poczatku (show)
    5 : SpcDraw(panel5,scaler,canvas,analysis,wspx5,wspy5,centr5,xrange,clear5,chartColor,checkBox5.Checked,F0);
   end;{case}
 End; {showGraph}

procedure mainOscTics(const i:dword; const jumpNbrSamples:word);
 {
 Rysuje tiki pokazujce na oscylogramie gwnym granice porcji
 }
 var k:longWord;
  Begin
   with form2 do
   with Panel1 do
   begin      // --------------------------------------niebieskie, pocztkowe tiki na osc. gwnym----------
    form2.canvas.Pen.Color:=clnavy;
    k:=i+d_count-1-jumpNbrSamples;
    canvas.moveTo(round(k*wspx1+left),top+height);
    canvas.lineTo(round(k*wspx1+left),top+height-5);
   end;
   form2.canvas.Pen.Color:=clred;
    with form2 do
   with Panel1 do
   begin      // ---------------------------------------czerwone, kocowe tiki na osc. gwnym----------
    canvas.moveTo(round((i+d_count-1)*wspx1+left),top+height);
    canvas.lineTo(round((i+d_count-1)*wspx1+left),top+height-5);
   end;
  End;{mainOscTics}

 procedure T0plot(const iw:dword;F0:single; zn2:AnsiChar);
   var x,y : longint;
   Begin
    with form2.Panel1, form2.Canvas  do
      begin
       Pen.Color:=clLime;
       x:=round(iw *wspx1) mod width;  //(iw div paramRec.pJump) provided slice number in analogous procedure in the Spectrum program not necessary here, because iw here is slice number itself
       if x=0 then with form2.Panel1 do
        begin
         zn1:=#0;                     //131218
         // procedure HorizTic(Panel:TPanel;canvas:tcanvas;const wspx:double; const xStretch,Xrefr,Yrefr:word);
         contr1:=form2.panel1.top+form2.panel1.height;  //debug prp
         horizTic(form2.panel1,form2.canvas,wspx1,x1range,iw,form2.panel1.top+form2.panel1.height);
         form2.Panel9.Left:=left+1;   //111218 added in order not to clear Y axis
         form2.canvas.moveTo(left+width,top);       //close back of the plot
         form2.Canvas.Pen.Color:=clWhite;
         form2.Canvas.LineTo(left+width,top+height);

         form2.Canvas.Pen.Color:=clRed;                 //close back of the red frame
         form2.canvas.moveTo(left+width+4,top-5);
         form2.Canvas.LineTo(left+Width+4, top+Height+10);

         Pen.Color:=clLime;
         application.ProcessMessages;          //it is a must, because the closing line is annuled without it! (bez tego linia zamykajjest kasowana!!!)
        end;
       application.ProcessMessages;
       y:=round((1000/F0)*(wspy1)+top);       //result  F0??
       form2.Panel9.Left:=x+left+5;  application.ProcessMessages;
       moveTo(x+1+left,y);
       lineTo(x+left+5,y); //draw horisontal mark 5 pts long
      end;
      with form2 do T0annotate(panel1,Canvas.Pen.Color,zn1,zn2);//T0 plot annotation
   End; {T0plot}
end.


