unit blind_dec_Drawings;

interface
uses ExtCtrls,graphics,forms,sysutils,types,dataProcessor;
const max_buffer =512;                       {power of 2! (FFT)}
type
 TSmallIntFile = file of smallInt;
        TdbArr = array of double;
      realType = double;
        v_l_vc = array[0..max_buffer-1] of realType;
       rAryType=^v_l_vc;
TdrawingsParam = record
          rPanelNbr,rDecimals:byte;
                   rHalf,rRev:boolean;
                xrange,yrange:word;
                   chartColor:longint;
                 end;

var
            StartShift,dataBlockLength,count_cp : longWord;
      wspx1,wspy1,wspx2,wspy2,wspx3,wspy3,wspx4,
      wspy4,wspx5,wspy5,wspx6,wspy6,panel4Scale : double;        //wspczynniki proporcjonalnoci dla poszczeglnych paneli
      centr1,centr2,centr3,centr4,centr5,centr6 : integer;        //centra pionowe dla poszczeglnych paneli
                rep,clear2,clear3,clear4,clear5 : boolean;
                                    waveFileDir : shortString;
ringBuffChangePointArr,frameNbrArr,frameNbr0Arr : array of integer;  //for multi CCR processing
                                    drawingsArr : array of TdrawingsParam;
                                         winNbr : byte;
                             StreamsGraphColors : array[0..10] of longint=(clWhite,clBlue,clBlue,clBlack,clLime,clYellow,clRed,clBlue+100,clLime,clYellow,clRed);
                                x1range,y1range : word;
                                            zn1 : char=#0;
                                            scc : array of single; //[0..11], scale coefficients (magnifiers)
procedure FramesRepaint;
procedure DataFrame(Panel:TPanel;canvas:tcanvas;const dataBlockLength:longWord; const stretch:double;
 const decimals:shortInt; out wspx,wspy:double; out centr:integer; const half,revers:boolean);
procedure OscDraw(panel:tpanel;const scaler:single;canvas:tcanvas; const y:TresArray; wspx,wspy : double; centr:integer;
  const count:longWord; const clear:boolean;const chartColor:longInt; it:longWord; var annotation:boolean);
procedure SpcDraw(panel:tpanel;const scaler:single;canvas:tcanvas; const y:TresArray; wspx,wspy:double; const centr:integer;
  const count:longWord; var clear:boolean; var chartColor:longInt; const clip:boolean; const F0:single);

procedure mainOscTics(const i:dword; const jumpNbrSamples:word);
procedure DataFrames;
procedure showGraph(const i:byte; const scaler:single; const analysis:TresArray;const F0:single);
procedure T0plot(const iw:dword;F0:single;zn2:char);

implementation
uses visualization;
var
 count : word; //odczyta warto
 temp,tempus : variant;
 annotation : boolean;
procedure FramesRepaint;  //Nie wywietla niczego, tylko czyci!
  //repaints drawings frames
 Begin
   DataFrames;
 End;{FrameRepaint}

procedure DataFrame(Panel:TPanel;canvas:tcanvas;const dataBlockLength:longWord; const stretch:double;
 const decimals:shortInt; out wspx,wspy:double; out centr:integer; const half,revers:boolean);
  //Wykrela ramki pokazujce pole wykresu
  //wspx,wspy - wspczynniki proporcjonalnoci dla okna
  //centr - rodek w pionie pola rysunku
  //fest - liczba przedziaw zmiennej na posi (zalena od wysokoci cyfr)
  var i,j,k,fest:integer; d:integer; s:shortString;

  procedure tick(const sign:shortInt);
  Begin
   k:=j;
   with panel,canvas do
    begin
     if half then
      if revers then j:=top+sign*round(i*height/fest)
      else j:=centr-sign*round(i*height/fest)
     else j:=centr-sign*round(i*height/(2*fest));
     if revers and half then d:=d-j+k
     else d:=d+j-k;                     //d increases until a tick number is writen down, then d:=0
     moveTo(left-3,j);
     lineTo(left,j); application.processMessages;     //tick
    end;
  End;{tick}

  procedure number(const sign:shortInt);
   var m:Integer;
   begin
    with panel,canvas do
     begin
      if sign*d<Font.Height then
      begin
       s:=floatToStrF(sign*(i*stretch/fest),ffFixed,8,decimals);
       for m:=1 to 7-length(s) do s:=' '+s;  //equalizing of the description length to 8 by adding spaces fom front
       canvas.TextOut(left-6*font.Size,j+Font.Height,s);   application.processMessages;
       moveTo(left-5,j);
       lineTo(left+1,j); application.processMessages;     // numbers tick
       d:=0;                             //d increases until a tick number is writen down, then d:=0
      end;{if}
     end;{with}
   end;{number}

  Begin  //--------------------------------DataFrame---------------------------
   with Panel,canvas do
    begin
     panel.Font.Height:=8;
     if half then
      begin
       fest:=height div 16;   //tick interval
       centr:=top+height;
       wspy:=(height)/stretch;
      end
     else
      begin
       fest:=height div 16;   //tick interval
       centr:=round(top+height/2);
       wspy:=0.5*(height)/stretch;
      end;
     wspx:=(width)/dataBlockLength;
     Pen.Color:=clred;                                         //------------------------------------a ten jest!
     Rectangle(left-16-5*font.Size,top-10,left+Width+10, top+Height+10); application.processMessages;  //big rectangle
     Pen.Color:=clwhite;
     Rectangle(left-15-5*font.Size,top-8,left+Width+9, top+Height+9);  application.processMessages;   //second big rectangle
     Pen.Color:=clgray;
     Rectangle(left-2,top-2,left+Width+2, top+Height+2); application.processMessages;                 //small rectangle
     Pen.Color:=clwhite;
     Rectangle(left-2,top-1,left+Width+1, top+Height+1); application.processmessages;                         //exact rectangle
     Pen.Color:=clwhite;
     moveTo(left,centr);                                           //--------------------ten kolor nie jest aktywowany!
     lineTo(left+width,centr);    application.processmessages;
     d:=0; if revers and half then j:=top else j:=centr;
     for i:=1 to fest do  // positive part of dependent axis
      begin
       tick(1);
       number(1);        //<, because font.height is <0
      end;
     d:=0; j:=centr;
     if not half then
     for i:=1 to fest do    // negative part of dependent axis
      begin
       tick(-1);
       number(-1);
      end;
      moveTo(left,centr);
    end;
   application.processmessages;
  End;{frame}

procedure DataFrames;
 (*
  procedure frame(Panel:TPanel;canvas:tcanvas;const dataBlockLength:longWord; const stretch:double;
 const decimals:shortInt; out wspx,wspy:double; out centr:integer; const half,revers:boolean);
  *)
  var i:shortint;  panelSet:set of byte;
 begin
   with F0panelDecHalfRev do DataFrame(form2.Panel1,form2.canvas,x1range,y1range,rDecimals,wspx1,wspy1,centr1,rHalf,rRev);
  panelSet:=[];
  for i:= 0 to nbrOfStreams-1 do
   with form2, drawingsArr[i] do
      begin
       if not (rPanelNbr in panelSet) then
        begin
         case rPanelNbr of   //frame(Panel:TPanel;canvas:tcanvas;const dataBlockLength:longWord; const stretch:double;const decimals:shortInt; out wspx,wspy:double; out centr:integer; const half,revers:boolean);
          2 : DataFrame(Panel2,canvas,xrange,yrange,rDecimals,wspx2,wspy2,centr2,rHalf,rRev);
          3 : DataFrame(Panel3,canvas,xrange,yrange,rDecimals,wspx3,wspy3,centr3,rHalf,rRev);
          4 : DataFrame(Panel4,canvas,xrange,yrange,rDecimals,wspx4,wspy4,centr4,rHalf,rRev);
          5 : DataFrame(Panel5,canvas,xrange,yrange,rDecimals,wspx5,wspy5,centr5,rHalf,rRev);
         end;{case}
         panelSet:=panelSet+[rPanelNbr];
        end;{if}
      end;{with}
 end;{DataFrames}

 function T0annotate(panel:Tpanel;chartColor:longint;var zn1,zn2:char):boolean;
 var
      tp:Tpoint;
  Begin
   result:=true;
   if (zn1<>zn2) then                 //opis fonematyczny maego oscylogramu
  with form2,panel do
    begin
     form2.Canvas.Pen.Color:=clyellow;
     tp:=canvas.penPos;
     canvas.TextOut(tp.X-8,top+2,zn2);
     canvas.MoveTo(tp.X-1,top+2);
     canvas.LineTo(tp.X,top+24);
     canvas.MoveTo(tp.X,tp.y);
     zn1:=zn2;
     form2.Canvas.Pen.Color:=chartColor;
    end {opis fonem.}
   else result:=false;
  End;

procedure OscDraw(panel:tpanel;const scaler:single;canvas:tcanvas; const y:TresArray; wspx,wspy : double; centr:integer;
  const count:longWord; const clear:boolean;const chartColor:longInt; it:longWord; var annotation:boolean);
//---------------------oscylogram danych wave
var
    i,k : longWord;
      j : longint;
zn1,zn2 : char;
waveVal : TsingInt;
    label e1;
  begin if not form2.CheckBox1.Checked then exit;//show graphics
   panel.Visible:=not rep and clear;             //do not clear graph when repeat command was sent
   panel.Visible:=false;
   zn1:=#0;
   with panel do
    begin
     j:=centr;
     if j<top then goto e1;
     if j>top+Height then goto e1;
     form2.Canvas.Pen.Color:=clwhite;
     form2.Canvas.moveTo(left,centr);            //--------------------ten kolor nie jest aktywowany!
     form2.Canvas.lineTo(left+width,centr);
e1:  form2.Canvas.moveTo(left,centr);
     form2.Canvas.Pen.Color:=chartColor;
    end;
   application.processMessages;
   k:=0;
   for i:=0 to count div 2-1 do
    with Panel do
     begin
      waveVal:=TsingInt(y[i]);
      j:=round(waveVal[0]*wspy*scaler+centr);
      if j<top then j:=top;
      if j>top+Height then j:=top+Height;
      canvas.LineTo(round(k*wspx+left),j);
      inc(k);
      j:=round(waveVal[1]*wspy+centr);
      if j<top then j:=top;
      if j>top+Height then j:=top+Height;
      canvas.LineTo(round(k*wspx+left),j);
      inc(k);
      application.processMessages;                  //Uwaga! skasuje narysowany oscylogram, jeli wczeniej nie wywoano jeszcze processmessages
     end;{for}
  end;{OscDraw}

 procedure T0Line(cpstrPoint:word;wspx,wspy:double;LineColor:tcolor; panel:Tpanel);
  begin
   with Panel,form2.canvas do
    begin
     form2.Canvas.Pen.Color:=lineColor;
     form2.Canvas.moveTo(round(cpstrPoint*wspx+left),top);
     form2.canvas.LineTo(round(cpstrPoint*wspx+left),top+height);
    end;
  end; {lifterLine}

procedure SpcDraw(panel:tpanel;const scaler:single;canvas:tcanvas; const y:TresArray; wspx,wspy:double; const centr:integer;
  const count:longWord; var clear:boolean; var chartColor:longInt; const clip:boolean;const F0:single);
//---------------------oscylogram danych wave
var
    i : longWord;
    j : int64;
    label e1;

  Begin  //----------------SpcDraw-------------------------------
   if not form2.CheckBox1.Checked then exit;//show graphics
   panel.Visible:=not rep and clear;       //do not clear graph when repeat command was sent
   clear:=false;
   panel.Visible:=false;

   with panel do
    begin
     j:=centr;
     if j<top then goto e1;
     if j>top+Height then goto e1;
     form2.Canvas.Pen.Color:=clwhite;
     form2.Canvas.moveTo(left,centr);                                           //--------------------ten kolor nie jest aktywowany!
     form2.Canvas.lineTo(left+width,centr);
e1:  form2.Canvas.moveTo(left,centr);
     form2.Canvas.Pen.Color:=chartColor;
    end;
   application.processMessages;
   for i:=0 to count-1 do with Panel do
    begin
     j:=round(-y[i]*wspy*scaler+centr);
     if clip then
      begin
       if j<top then j:=top;
       if j>top+Height then j:=top+Height;
      end;
     canvas.LineTo(round(i*wspx+left),j);
     application.processMessages;                  //Uwaga! skasuje narysowany oscylogram, jeli wczeniej nie wywoano jeszcze processmessages
    end;
   if panel=form2.Panel4 then
    T0Line(round((rate/F0)),wspx,wspy,clgreen, panel);;
  End;{SpcDraw}

procedure showGraph(const i:byte; const scaler:single; const analysis:TresArray; const F0:single);
{
 OscDraw(panel:tpanel;canvas:tcanvas; const y:TdbArr; wspx,wspy : double; centr:integer;const count:longWord; const clear:boolean;const chartColor:longInt; it:longWord; var annotation:boolean);
 drawingsArr contains graphics data of panels. It was created on the basis of the 4-th record of the data
}
 Begin
  with drawingsArr[i] do
   with form2 do //SpcDraw(panel:tpanel;canvas:tcanvas; const y:TdbArr; wspx,wspy:double; const centr:integer; const count:longWord; clear:boolean; const chartColor:longint; const clip:boolean; const F0:single);
   case rPanelNbr of //procedure OscDraw(panel:tpanel;canvas:tcanvas; const y:TresArray; wspx,wspy : double; centr:integer;const count:longWord; const clear:boolean;const chartColor:longInt; it:longWord; var annotation:boolean);
    2 : OscDraw(panel2,scaler,canvas,analysis,wspx2,wspy2,centr2,xrange,true,chartColor,i,annotation);       //oscylogram okienka;
    3 : SpcDraw(panel3,scaler,canvas,analysis,wspx3,wspy3,centr3,xrange,clear3,chartColor,checkBox4.Checked,F0);
    4 : SpcDraw(panel4,scaler,canvas,analysis,wspx4,wspy4,centr4,xrange,clear4,chartColor,checkBox5.Checked,F0);       //cepstrum urednione czasowo z korekt poczatku (show)
    5 : SpcDraw(panel5,scaler,canvas,analysis,wspx5,wspy5,centr5,xrange,clear5,chartColor,checkBox5.Checked,F0);
   end;{case}
 End; {showGraph}

procedure mainOscTics(const i:dword; const jumpNbrSamples:word);
 {
 Rysuje tiki pokazujce na oscylogramie gwnym granice porcji
 }
 var k:longWord;
  Begin
   with form2 do
   with Panel1 do
   begin      // --------------------------------------niebieskie, pocztkowe tiki na osc. gwnym----------
    form2.canvas.Pen.Color:=clnavy;
    k:=i+count-1-jumpNbrSamples;
    canvas.moveTo(round(k*wspx1+left),top+height);
    canvas.lineTo(round(k*wspx1+left),top+height-5);
   end;
   form2.canvas.Pen.Color:=clred;
    with form2 do
   with Panel1 do
   begin      // ---------------------------------------czerwone, kocowe tiki na osc. gwnym----------
    canvas.moveTo(round((i+count-1)*wspx1+left),top+height);
    canvas.lineTo(round((i+count-1)*wspx1+left),top+height-5);
   end;
  End;{mainOscTics}


  procedure T0plot(const iw:dword;F0:single; zn2:char);
   var x,y : longint;
   Begin
    with form2.Panel1, form2.Canvas  do
      begin
       Pen.Color:=clred;
       x:=round(iw*wspx1) mod width;     //5 - stroke length
       application.ProcessMessages;
       y:=round((1000/F0)*(wspy1)+top);       //result  F0??
       form2.Panel9.Left:=x+left;  application.ProcessMessages;  //in order not to leave start points on the plot aby nie pozostawial pocztkow na wykresie
       form2.Panel9.Left:=x+left+5;  application.ProcessMessages;
       moveTo(x+left,y);
       lineTo(x+left+5,y); //draw horisontal mark 5 pts long
      end;
      with form2 do T0annotate(panel1,Canvas.Pen.Color,zn1,zn2);//T0 plot annotation
   End; {T0plot}
end.

