unit dataProcessor;

interface
uses sysUtils,forms,dialogs, StdCtrls;

const maxStreamNbr : byte=12;  //the highest number of streams
const cathNbr=4;

 type
     TcathNamesArr = array[0..cathNbr-1] of shortString;
        TsingleArr = array of single;
         TresArray = TsingleArr;//array of single;
          TsingInt = array[0..1] of smallInt;
  TpanelDecHalfRev = record rPanelNbr,rDecimals:byte; rHalf,rRev:boolean end;
         TparamRec = record pWinShape,pF0WinShape, p0component, pJump:byte; end;
      TinPutRecord = record
                    IsliceNbr : longWord;
                 IstreamArray : array of TresArray; // = array of single;
   Iphon,Iperson,Igender,Iage : AnsiChar;
                          IF0 : single;
                     end;{record}
 var
                                   nbrOfStreams : byte;
          phonNbr, personNbr, genderNbr, ageNbr : byte;
               phonSetCounter, personSetCounter,
                genderSetCounter, ageSetCounter : byte;
                                        manager : char;
                                    cathNameArr : array[0..3] of shortString;
                                           rate : integer;
                                       sliceNbr : longWord;//integer; 22022022
                                   d_count,jump : word;
                             panelDecHalfRevArr : array[0..5] of TpanelDecHalfRev;
              panelDecHalfRev,F0panelDecHalfRev : TpanelDecHalfRev;
                                       paramRec : TparamRec;
                                 StreamNamesArr : array of shortString;
                                    StreamsNbrs : array of byte;
                                 StreamCheckArr : array of boolean;
                                StreamColorsArr : array of longint;
                               StreamPointerArr : array of TcheckBox;
                                    nextPortion : boolean;
                                        inpFile : file of single;
                                        recSize : word;
                   breakDataReading,fromScratch : boolean;
                             InitDir,programDir : shortString;
                    checkedStreamNbr,StreamIdx  : byte;
                                    inPutRecord : TinPutRecord;
                                     inpFileDir : shortString='E:\apl\spectrum\results\*.spc';
                     cpstrPoint,F0Count,scratch : word;
                                   cathNamesArr : TcathNamesArr;
allNormChecksStatesCode, allOutChecksStatesCode : word;
                                            c,d : array[byte] of word;

   type
   TcountsRec = record count1, count2 : word end;
     TcathArr = array[0..3] of AnsiChar;
 TratePeriods = record rRate:word;rNbrOfMultiMean, rFrameNbr:byte end;
          Txy = record x,y:word end;
     var
               countsRec : TcountsRec;
          RecSizeCounter : longword;
                 cathArr : TcathArr;
             ratePeriods : TratePeriods;
 NbrOfMultiMean,FrameNbr : byte;       //frameNbr - a count of number of frames under time averaging in the program Spectrum. It has here only informational meaning, significant when we process a green or a yellow stream (cPS, vPS, cPC, vPC)
          radioItemIndex : shortInt;
                    head : word;
                dataSize : int64;


procedure InitWrite;
procedure dataProcess(callChain:shortString);
function equStrV(str:string; l:word):string;
procedure OutNormCheckBoxesStates;
implementation
 uses visualization,LVQ_spr_Drawings,VQUnit,unit1;

 var
          initFile : textFile;
         singleArr : TsingleArr;
         control1 : integer;
 procedure InitWrite;
   Begin
    try
     assignFile(initFile,InitDir);
     Rewrite(initFile);
     Writeln(initFile,inpFileDir);
     Writeln(initFile,checkedStreamNbr,' checkedStreamNbr'); //streamPointerArr[StreamsNbrs[StreamIdx]].Checked:=true;
     CloseFile(initFile);
    except
     showMessage('There was something wrong with writing initial informations, check the "'+InitDir+
     '" file (open, inspect and save, resaving helps, may be the file was corrupted in some way or had been'+
     ' already opened by some other program), or delete it'#13#10'Turn to the author if problem will repeat');
    end;
   End;{InitWrite}

 procedure InitRead;
   Begin
    programDir:=ExtractFileDir(application.ExeName);//programDir:=getCurrentDir;
    InitDir:=programDir+'\DataReaderInit.txt';
    if fileExists(InitDir) then
     begin
      assignFile(initFile,InitDir);
      reset(initFile);
      try
       readln(initFile,inpFileDir);
       readln(initFile,checkedStreamNbr);  //streamPointerArr[StreamsNbrs[StreamIdx]].Checked:=true;
      except
       showMessage('There was something wrong with reading initial informations, check the "'+InitDir+'" file, or delete it'#13#10'Turn to the author if problem will repeat');
      end; {try}
      CloseFile(initFile);
     end;{if}
   End; {InitRead}

 function inArr(intArr:array of byte; var k,l:byte):boolean; //inArr(StreamsNbrs,checkedStreamNbr)
  var i:byte;
  begin
   result:=false;
   for i:=0 to high(intArr) do
    begin
     if k=intArr[i] then begin result:=true;
     l:=i; exit end
    end;
  end;{inArr}

 function OpenFile(var FileDir:shortString; title,ext,filter,callChain:shortString):boolean;

 //---------------wskazuje i modyfikuje ciek do pliku danych

  begin
   callChain:=callChain+'>OpenFile';
   InitRead;
   with form2 do
    begin
     opendialog1.FileName:=FileDir; opendialog1.Title:=title;
     opendialog1.InitialDir :=extractFileDir(fileDir);
     opendialog1.DefaultExt:=ext;
     opendialog1.Filter:=filter;
     result:=opendialog1.Execute();
     inpfileDir:=opendialog1.FileName;
     if result then with form2 do
      begin
       Label2.Top:=280;
       Label2.Left:=button3.left;
       Label2.caption:='Choose a stream for processing!';
      end;
     if not result then
     if not fileExists(fileDir) then showMessage('You have not pointed an existing data file, or a default file'#13#10+fileDir+#13#10'does not exist');
    end;{with}
   InitWrite;
 end;

 procedure error7;
  var s:string;
  Begin
   s:='Error 7, procedure dataProcess.'#13#10'There was read an erronous value of the "checked stream number" from the init file, i.e. from the "'+
       initDir+'". The value was ='+intToStr(checkedStreamNbr)+
       ', which was not contained in the array of the data events streams numbers '
       +'the last of the streams will be chosen for analyses instead.'+
       #13#10'Try to select a proper stream once again (uncheck the " '+form2.CheckBox25.Caption+'" checkBox).'#13#10'Turn to the author if it falls.'#13#10'End of the "Error 7" description';
   showMessage(s);
   writeln(reportFile,s);
  End;{error7}

 function equStrV(str:string; l:word):string;
  begin
   while length(str)<l do
   begin
    str:=' '+str;
   end;
    result:=str;
   end;

 procedure OutNormCheckBoxesStates;

   function outOnOff(const ChecksStatesCode, i:word):AnsiChar;
    Begin
     result:=' ';
     if ChecksStatesCode and (1 shl i)>0 then result:='T' else result:='F'
    End;

   var i,k:byte;
   Begin
    k:=6;
    Writeln(reportFile,#13#10'-------------------------------------------------------');
    Writeln(reportFile,#13#10'Extended info on out and standardise checkboxes states:');
    Writeln(reportFile,'MM - means: "multimean"', #13#10'cvs means: cPS, vPS, sPS[0]:=0',#13#10'"Bundle" means radiogroup4.itemIndex nbr in the SPECTRUM program');

    Writeln(reportFile,'Settings code of all "Output" check boxes, and the "CCR bundle" radiogr state: ',allOutChecksStatesCode:k);
    Writeln(reportFile,' Settings code of all "standardize" and the "cPS vPS sPS[0]:=0" check boxes:   ',allNormChecksStatesCode:k);

    writeln(reportFile,'Check nbr ':26,7:k,8:k,9:k,10:k,11:k,12:k,13:k,26:k,14:k,15:k,16:k,17:k,24:k,'lab.3':k,' radiogroup4');
    writeln(reportFile,'Check caption':26,'wav':k,'wwav':k,'PS':k,'sPS':k,'msPS':k,'vPS':k,'cPS':k,'aPS':k,'PC':k,'mPC':k,'vPC':k,'cPC':k,'MM':k,'cvs':k,' CCR Bundle');

    write(reportFile,'Out Checks states:        '); for i:=0 to 12 do  write(reportFile,outOnOff(allOutChecksStatesCode,i):k);        writeln(reportFile,'-':k,(allOutChecksStatesCode shr 13):k);  //last two: Multi Mean ; Multimean bundle
  //write(reportFile,'Out Checks states:         '); for i:=0 to 12 do  write(reportFile,(allOutChecksStatesCode and (1 shl i)>0):k);  writeln(reportFile,'-':k,(allOutChecksStatesCode shr 13):k);   debug

    writeln(reportFile);  //last two: Multi Mean ; Multimean bundle
    write(reportFile,'Standardize Checks states:'); for i:=0 to 13 do  write(reportFile,outOnOff(allNormChecksStatesCode,i):k); writeln(reportFile,'-':k);
    Writeln(reportFile,'-------------------------------------------------------'#13#10);
    flush(reportFile);
   End; {OutNormCheckBoxesStates}

 procedure dataProcess;
 type
  TmeanDevRecord = record
                    X,Xsqr:extended;
                   end;

           Tset =  set of char;
  var
     i,j,k : longint;
         s : String;
   waveVal : TsingInt;
                    phonSet, personSet, genderSet,ageSet : Tset;
checkPhonSet, checkPersonSet, checkGenderSet,checkAgeSet : Tset;


 function cathNameDecoder(var singleArr:TsingleArr; recSize:longWord;  cathNbr:byte):TcathNamesArr;

  type Tencode = array[1..4] of AnsiChar;
  var    i,j,k : word;
        encode : Tencode;
        outStr : string;
  Begin
   outStr:='';
   if (recSize mod 4)>0 then ShowMessage('Record size (='+intToStr(recSize)+') is not a multiplicity of 4, it is wrong value, because the output record is encoded as single type container');
   k:=(recSize div 4)-1;
   for i:=0 to k do
    begin
     encode:=Tencode(singleArr[i]);
     for j:=1 to 4 do
      outStr:=outStr+encode[j];
    end;{for i}
   for j:=0 to cathNbr-1  do result[j]:='';
   j:=0;
   for i:=1 to length(outStr) do
   if outStr[i]=#0 then inc(j)
   else
    if j<=cathNbr then result[j]:=result[j]+outStr[i];
  End;{cathNameDecoder}

  procedure cathSetsDecoder(var singleArr:TsingleArr);

  //it is asumed that singleArr overlays inputRecord by absolute declaration

  type Tencode = array[0..7] of single;
  var   j,k : word;
   encode : Tencode;

  function setRetriev(encodedSet:shortString):Tset;
   var i:byte;
   Begin
    for i:=0 to 7 do
     if i+j<=high(singleArr) then encode[i]:=singleArr[i+j]
     else
      begin
       showMessage('signal streams were too short (i.e. the windows width='+intToStr(d_count)+
       ' was too narrow) to encode all cathegories values sets; it was broken at decoding of the "'+encodedSet+'" stage');
       break
      end;
    result:= Tset(encode);
    inc(j,8); //because every set is encrypted with 8 numbers of type single
   End;{setRetriev}

  Begin
   j:=0; k:=high(singleArr);//debug prp
   phonSet:=setRetriev('phonSet');
   personSet:=setRetriev('personSet');
   genderSet:=setRetriev('genderSet');
   ageSet:=setRetriev('ageSet');
  End;{cathSetsDecoder}

 procedure retrieveMultiMeanList(var singleArr:TsingleArr;nbrOfMultiMean:byte);
  type      TtimArr=array[0..3] of byte;
  var i,j,k,n:word;
             timArr:TtimArr;
  Begin
   n:=RecSize div 4;  k:=0; i:=0;
   while i< (nbrOfMultiMean div 4)+byte(nbrOfMultiMean mod 4 >0) do //+byte(nbrOfMultiMean mod 4 >0, to retreave ending,  because it can occure that nbrnbrOfMultiMean mod 4 >0
    if i<=n then
    begin
      timarr:=Ttimarr(singleArr[i]);
     for j:=0 to 3 do  frameNbrArr[j+k]:=timarr[j];
     inc(i);
     inc(k,4) //because every 4 byte type values are encrypted with 1 single typevalue
    end {while}
    else showMessage('Some program structure error was encountered.'#13#10'Only '+intToStr(n)+' of '+
     intToStr(nbrOfMultiMean)+' average constant from entire list could be retrieved.'#13#10'Turn to the author');
  End;{retrieveMultiMeanList}

 function inputRecordFromFile:boolean;
  var i,j:smallInt;
  cath:array[0..3] of AnsiChar;    //array for conversion cathegory values
   Begin
    result:=true;
     try
      with inPutRecord do
       begin
        i:=-1;
        read(inpFile,single(TsingInt(inputRecord.IsliceNbr)));  //can also be: read(inPutRecordFile,psingle(@sliceNbr)^);
        for i:=0 to nbrOfStreams-1 do
         for j:=0 to d_count div 2 do
          read(inpFile,IstreamArray[i,j]);
        read(inpFile,single(cath));
        Iphon:=cath[0]; Iperson:=cath[1];Igender:=cath[2]; Iage:=cath[3];
        read(inpFile,IF0);
       end;
     except
      result:=false;
      showMessage('Incapable reading, break at '+intToStr(i)+'-th stream. Probably end of file has been encountered');
     end;
   End;{inputRecordFromFile}

procedure streamsNamesRetrieve(var caption:shortString;const stream:TresArray);
  //retrieves stream name from a stream instance
   type
   TsingleInfo=array of single;
   TtextInfo=array of AnsiChar;
   var i,j:word;
   textInfo:TtextInfo;
   singleInfo:TsingleInfo absolute textInfo;
   Begin
    j:=high(stream);
    setLength(singleInfo,j+1);
    setLength(textInfo,(j+1)*4);
    for i:=0 to j do singleInfo[i]:=stream[i];
    i:=0;  caption:='';
    while textInfo[i]<>#0 do
     begin
      caption:=caption+textInfo[i];
      inc(i);
     end;
   End; {streamsNamesRetrieve}

  procedure pathRetrieve(var caption:shortString);
  //retrieves path from an inputRecord instance
   type
   TtxtInfo=array of AnsiChar;
   TtxtBit=array[0..3] of AnsiChar;
   var  i,j : word;
    txtInfo : TtxtInfo;
     txtBit : TtxtBit;
   Begin
    //i:=filePos(inpFile); //debug prp
    setLength(txtInfo,recsize);
    i:=high(txtInfo);
    i:=0;  j:=0; caption:='';
    for i:=0 to recSize-1 do txtInfo[i]:=#0;
    repeat
     read(inpFile,single(txtBit));
     for i:=0 to 3 do txtInfo[i+j]:=txtBit[i];
     inc(j,4);
    until j>recSize-1;
    //i:=filePos(inpFile); //debug prp
    i:=0;
    while (txtInfo[i]<>#0) and (i<recSize) do
     begin
      caption:=caption+txtInfo[i];
      inc(i);
     end;
   End; {pathRetrieve}

procedure error10(P:longWord);
 Begin
  s:= 'Error10'#13#10'The "Out of memory" error occured, because a bite of the size of '+intToStr(((P+1)*nc*sizeOf(vectList0[0,0])))+
       ' bytes (for registering of '+intToStr(P)+' events) is too big.'#13#10+
       'Now we will try to find the bigest reachable (due to this 32 bytes software) bite in an iteration process.'+
       #13#10'It can at least give you an estimate how to prepare adequate data sample';
  showMessage(s);
  writeln(reportFile,s+#13#10'end.');
 End;

function approx(sliceNbr:longWord; nc:word):int64;
//not overcome a hidden treshold = reachable RAM cluster
 var step:integer; S:single;
 a,P,b:longWord;
 OK:boolean;
 a1,b1:integer;
 Begin
  a:=sliceNbr;
  b:=0; P:=a;   OK:=true; step:=0;
  a1:=a; b1:=b;
  form2.ListBox2.Items.Add('Data RAM allocating process');
  form2.ListBox2.Items.Add(equStr('NR',3)+equStr('T|F',3)+equStr('Bottom',10)+equStr('mid',10)+equStr('Up',10));
  application.ProcessMessages;
  form2.ListBox2.Items.Add(equStr(equStr(intToStr(step),3)+' - ',3)+  equStr(intToStr(b),10)+ equStr(intToStr(P),10)+ equStr(intToStr(a),10));
  application.ProcessMessages;
  repeat
   inc(step);
    try
     setLength(vectList0,0,0);
     setLength(vectList0,P+1,nc+1);
     begin
      a1:=a; b1:=b;
      OK:=true;
      b:=P;
      P:=(a+b) div 2;
      form2.ListBox2.Items.Add(equStr(equStr(intToStr(step),3)+'T:',3)+  equStr(intToStr(b),10)+ equStr(intToStr(P),10)+ equStr(intToStr(a),10));
      application.ProcessMessages;
     end
    except
     begin
      if step=1 then error10(P);
      setLength(vectList0,0,0);
      a:=P;
      P:=(a+b) div 2;
      OK:=false;
      form2.ListBox2.Items.Add(equStr(equStr(intToStr(step),3)+ 'F:',3)+ equStr(intToStr(b),10)+ equStr(intToStr(P),10)+ equStr(intToStr(a),10));
      application.ProcessMessages;
     end;
    end;{except}
  until OK and ((b1=b) or (b=P) or (step=1));
  result:=P;
 End;{approx}

procedure dataRAMallocator;
  var tBrP:longWord;
  Begin
   streamPointerArr[checkedStreamNbr].Checked:=true;   //tick checkbox pointing choosen stream (here first one in data records)
   if StreamsNbrs[StreamIdx]=0 then vectorsSize:=d_count-1 else vectorsSize:=d_count div 2; //odblokowano 040619 aby peny sygna, a nie tylko poow, zamiana id parametersSize na vectorsSize
   form1.edit35.Text:=intToStr(vectorsSize+1);
   if form1.CheckBox36.Checked and (BreakReadingPoint<sliceNbr) then tBrP:=BreakReadingPoint else tBrP:=sliceNbr; //take into account braekPoint when RAM allocating
   try
     if checkedStreamNbr=0 then  //gdy do kwantowania wybrano sygna vaw
      begin
       nc:=d_count-1;
       form1.edit1.text:=intToStr(nc);
       dataSize:=(sliceNbr+1)*d_count*sizeOf(vectList0[0,0]);
       breakReadingPoint:=approx(tBrP,d_count)-1;
       dataSize:=(breakReadingPoint+1)*d_count*sizeOf(vectList0[0]);
      end
     else
      begin
       if nc>d_count div 2 then
        begin
         nc:=d_count div 2;
         form1.edit1.text:=intToStr(nc)
        end;
       form1.edit1.text:=intToStr(nc);
       dataSize:=(sliceNbr+1)*nc*sizeOf(vectList0[0,0]);
       breakReadingPoint:=approx(tBrP,nc)-1;
       dataSize:=(breakReadingPoint)*nc*sizeOf(vectList0[0]);
       form2.ListBox2.Items.Add('It can  be read up to '+intToStr(breakReadingPoint)+' events.');
       form2.ListBox2.Items.Add('This data sample contains '+intToStr(sliceNbr+1)+ 'events, its size ='+intToStr(dataSize)+' bytes,');
       form2.ListBox2.Items.Add('i.e. 2^'+floatToStr(ln(dataSize)/ln(2)));
       application.ProcessMessages;
      end;
     except
      s:='dataRAMallocator'#13#10'Too much events! We will try 2-times smaller sample, i.e. '+intToStr((sliceNbr div 2)+1)+' instead of '+intToStr(sliceNbr+1);
      writeln(reportFile,s+#13#10'end.');
      showMessage(s);
      try
       setLength(vectList0,(sliceNbr div 2)+1,nc+1);
        BreakReadingPoint:=sliceNbr div 2;
      except
       s:='dataRAMallocator'#13#10'Still too much events...';
       ShowMessage(s);
       writeln(reportFile,s+#13#10'end.');
      end;
     end;
    if breakReadingPoint<sliceNbr then
     begin
      form1.CheckBox36.Checked:=false;
      form1.CheckBox36.Checked:=true;
      form2.label35.Visible:=true;
      form1.edit29.Text:=intToStr(breakReadingPoint);
      s:='dataRAMallocator. Data reading (due to current choice at: "'+form1.tabSheet6.Caption+'>'+form1.checkBox36.caption+'") will be broken at '+form1.edit29.Text+'-th slices.';   //at: "'+form1.tabSheet6.Caption+'>'+form1.checkBox36.caption+'")
      form2.label35.Caption:=s;
      writeln(reportFile,s+#13#10'End.');
      application.ProcessMessages;
     end;
    form1.Label4.Caption:=intToStr(breakReadingPoint *(nc*sizeOf(vectList0[0])+4*sizeOf(AnsiChar)+4));
    setLength(vectList,breakReadingPoint+1,nc+1);
  End;{dataRAMallocator}

  procedure readingSteering;
   Begin
     repeat
      application.ProcessMessages; //is a must! otherwise program stops here
     until nextPortion or not form2.CheckBox2.Checked or (manager in['B','R','r'])  or breakDataReading;
     nextPortion:=false;
     if manager='B' then
      begin
       //j:=filePos(inpFile);    //debug prp
       if i>=2 then
        begin
         seek(inpFile,(i-1+head)*recSize div 4);
         dec(i,2);
         //j:=filePos(inpFile);  //debug prp
        end
       else form2.Button2.Enabled:=false;  //back
       if i<=0 then         //not enter bak
       with form2 do
        begin
         Button2.Enabled:=false;
         if Button4.enabled then button4.setFocus;  //next, redirect steering
        end;
       manager:=#0;
      end;{if manager='B'}

     if manager in ['R','r'] then      //Repaint frames (butt. 8, check 4, 5, 6, 7) repeat (butt. 7)
      begin
        manager:=#0;
        framesRepaint;
       try  //to avoid limiting of input file size to maxLongWord
        j:=filePos(inpFile);
        if j>=recSize div 4 then
         begin
          seek(inpFile,j-recSize div 4);
          dec(i);
          j:=filePos(inpFile);
         end
        else form2.Button2.Enabled:=false;
       except
        ShowMessage('Can not perform this command, i.e. the "'+form2.Button8.Caption+'" or the "'+form2.Button7.Caption+'", in this point of input file, because the file position, i.e. '+intTostr(j)+', has exceeded the high(LongWod) value, i.e. the '+intToStr(high(LongWord))+'.') ;
       end;{try}
      end;{if manager in ['R','r']}
   End;{readingSteering}


  var s1,s3,s4:shortString;
  label Q;
   //streamPointerArr[StreamsNbrs[StreamIdx]].Checked:=true;
  Begin //---------------------------------------------dataProcess-------------------------------
   callChain:=callChain+'>dataProcess';
   with form2 do
    begin
     form2.label35.Visible:=form1.CheckBox36.Checked;
     form2.label35.Caption:='Data reading (due to your choice at: "'+form1.tabSheet6.Caption+'>'+form1.checkBox36.caption+'") will be broken at '+form1.edit29.Text+'-th slice.';
     form2.label35.Visible:=form1.CheckBox36.Checked;
    end;
   if openFile(inpfileDir,callChain+'>"Input"','spc','Spectrum files (*.spc)|*.spc|Text files (*.txt)|*txt',callChain) then
    begin
     s1:=extractFileDir(reportFileDir);
     if s1[length(s1)]='\'  then delete(s1,length(s1),1);
     s3:=extractFileName(inpFileDir);
     s4:=extractFileExt(inpFileDir);
     reportFileDir:=s1+'\'+copy(s3,1, pos(s4,s3)-1)+'_Report.txt';
     openReportFile(callChain);                //270319
     if extractFileExt(extractFileName(inpFileDir))='.spc' then
       begin
        if not fileExists(inpFileDir) then          //300122
         begin
          showMessage('The events input file, i.e. the '#13#10'"'+inpFileDir+'"'#13#10'does not exists choose proper one!');
          openDialog(form1.OpenDialog1,inpFileDir,5,'Open event data file',form1.edit5,callChain);
         end;
        assignFile(inpFile,inpfileDir);
        Reset(inpFile);
        form1.CheckBox15.Caption:='Stepwise data processing'
       end
      else goto Q
     end
    else begin showMessage('Procedure dataProcess; input file, i.e. "'+inpFileDir+'" was not opened; turn to the author'); exit end;
    //------------------------------1-th record----------------------------------------------------
    RecSizeCounter:=0; form2.Label17.Caption:='';
    read(inpFile,single(TsingInt(inputRecord.IsliceNbr)));
    inc(RecSizeCounter,4);
    try                                                                      //Spectrum: with countsRec do begin rCount1:=count; rCount2:=nbrOfStream end;
     d_count:=TcountsRec(inputRecord.IsliceNbr).Count1;                        //windows width applied for slice classification
     nbrOfStreams:=TcountsRec(inputRecord.IsliceNbr).Count2;
     setLength(inputRecord.IstreamArray,nbrOfStreams,d_count div 2+1);  //allocate memory to the stream array
     for i:=0 to nbrOfStreams-1 do
      for j:=0 to d_count div 2 do
       begin
        read(inpFile,inputRecord.IstreamArray[i,j]);
        inc(RecSizeCounter,4);
       end;
     read(inpFile,single(cathArr));  inc(RecSizeCounter,4);
     read(inpFile,inputRecord.IF0);  inc(RecSizeCounter,4);

     //----------------------decode some of features from 1-th record -------- Spectrum:  with countsRec do begin rCount1:=recSize; rCount2:=F0Count end;
     countsRec:=TcountsRec(inputRecord.IstreamArray[0,0]);                    //record: record size and windows width applied for fundamental period measurements
     paramRec:=TparamRec(inputRecord.IstreamArray[0,1]);                      //record of some analysis features codes, see TparamRec declaration
     phonNbr:=byte(cathArr[0]); personNbr:=byte(cathArr[1]); genderNbr:=byte(cathArr[2]); ageNbr:=byte(cathArr[3]);
    except
     showMessage('Improper number of streams - probably too high. It is equal to '+intToStr(TcountsRec(inputRecord.IsliceNbr).Count1)+', however it can not exceed 255.'#13#10'Check data; program will be halted now.');
     halt;
    end;
    with countsRec do
     begin
      RecSize:=count1; //input record size
      F0Count:=count2; //windows width used for fundamental frequency measdurements
      if(RecSizeCounter<>RecSize) then
       showMessage('There is a difference between computed record size (='+intToStr(RecSizeCounter)+
       ') and this writed down as output data info (='+intToStr(RecSize)+'). It must be explained, turn to the author');
     end;
    setLength(singleArr,RecSizeCounter div 4);
    for i:=0 to cathNbr-1 do cathNamesArr[i]:=''; //debug prp
    for i:=0 to RecSizeCounter div 4-1 do read(inpFile,singleArr[i]);    //read 2-nd record
    cathNamesArr:=cathNameDecoder(singleArr, recSizeCounter,cathNbr {cathNbr});//21072016
    setLength(drawingsArr,nbrOfStreams);
    setLength(StreamNamesArr,nbrOfStreams);
    setLength(StreamsNbrs,nbrOfStreams);
    setLength(StreamCheckArr,maxStreamNbr);
    setLength(StreamPointerArr,maxStreamNbr);
    setLength(StreamColorsArr,nbrOfStreams);
    seek(inpFile,0);
    for i:=0 to cathNbr-1 do cathNamesArr[i]:=''; //debug prp
{1} inputRecordFromFile;          //renewed from 0-th record reading
    with inputRecord do
     begin
      countsRec:=TcountsRec(iSliceNbr);                //count, nbrOfStreams
      d_count:=countsRec.count1;                      //spectrum windows width
       Writeln(reportFile,'Spectrum windows width ',d_count,' points');
      nbrOfStreams:=countsRec.count2;
      countsRec:=TcountsRec(IstreamArray[0,0]);    //record: record size and windows width applied for fundamental period measurements
      RecSize:=countsRec.count1;                  //input record size
      F0Count:=countsRec.count2;                 //windows width used for fundamental frequency measurements
      paramRec:=TparamRec(IstreamArray[0,1]);   //windows shapes, 0-th component removed, filter applied,
      allNormChecksStatesCode:=Txy(IstreamArray[0,2]).x;
      allOutChecksStatesCode :=Txy(IstreamArray[0,2]).y;
     // OutNormCheckBoxesStates;               //show in report extended info on out and standardise checkboxes states
      phonNbr:=byte(Iphon); personNbr:=byte(Iperson); genderNbr:=byte(Igender); ageNbr:=byte(Iage);
      ratePeriods:=TratePeriods(iF0);
      with ratePeriods do
       begin
        rate:=rRate; NbrOfMultimean:=rNbrOfMultimean; frameNbr:=rFrameNbr;   //rate - sampling frequency
       end;{with}
      setLength(frameNbrArr,NbrOfMultimean+4*byte(nbrOfMultiMean mod 4 >0));
      with form2 do
       begin
        label14.Caption:=intToStr(phonNbr); label15.Caption:=intToStr(personNbr);
        label16.Caption:=intToStr(genderNbr); label18.Caption:=intToStr(ageNbr);
        edit3.Text:=intToStr(nbrOfStreams);
        label23.Caption:=intToStr(d_count); label24.Caption:=intToStr(F0count);
       end{with}
     end; {with}
    form2.label9.Caption:=intToStr(paramRec.pJump);
    with paramRec do
     begin
      Jump:=pJump;
      form2.RadioGroup7.ItemIndex:=pWinShape;                                                         //weighting windows shape for recognition prp.
      form2.RadioGroup3.ItemIndex:=pF0WinShape;                                                       //weighting windows shape for F0 measurements prp.
      if boolean(p0Component) then form2.Label3.Caption:='True' else form2.Label3.Caption:='False';   //0-th component:=0
      //form2.CheckBox58.Checked:=boolean(round(inputRecord.streamArray[0,3]));                       //wczenie preemfazy
      //form2.RadioGroup1.ItemIndex:=round(inputRecord.streamArray[0,5]);                             //analizy od 0|poowy okna
      //form2.RadioGroup9.ItemIndex:=pArtSignal);                                                     //parametry sztucznego sygnau
     end;
{2} for i:=0 to RecSizeCounter div 4-1 do read(inpFile,singleArr[i]);//inputRecordFromFile;                                              //cathegory names
    cathNamesArr:=cathNameDecoder(singleArr, recSizeCounter,cathNbr); //21072016
    with form2 do
     begin
      label64.Caption:=cathNamesArr[0];
      label66.Caption:=cathNamesArr[1];
      label70.Caption:=cathNamesArr[2];
      label5.Caption:=cathNamesArr[3];
     end;
{3} inputRecordFromFile;                                 //stream names  and numbers
    for i:= 0 to nbrOfStreams-1 do
      with inputRecord do
       begin
        streamsNamesRetrieve(StreamNamesArr[i],IstreamArray[i]);
         s:=spacesRemove(copy(StreamNamesArr[i],1,pos('.',StreamNamesArr[i])-1));
         if not tryStrToInt(s,k) then
          begin
           showMessage('Error, proc. "dataProcess".'#13#10'The "'+s+ '" in the string name "'+
           StreamNamesArr[i]+'" is not a number; correct it in the "Spectrum analyser" program (turn to the author)!'#13#10'Procedure will be exited now');
           exit
          end;
        StreamsNbrs[i]:=k;
       end;
    sliceNbr:=inputRecord.IsliceNbr;     wholeEventNbr:=sliceNbr;  // wholeEventNbr originates from VQUnit!
    if not form1.CheckBox36.Checked or(breakReadingPoint>=sliceNbr) then form2.Label30.Caption:=intToStr(sliceNbr)
    else  form2.Label30.Caption:=intToStr(breakReadingPoint);    //Number of Slices to read
    form2.Label28.Caption:=intToStr(sliceNbr*paramRec.pJump);   //of nbr of wave events
    if sliceNbr=0 then showMessage('Number of slices is = 0. Probably The "Spectrum" program was closed incorrectly. The true number you will see after data will be read entirely');
    radioItemIndex:=shortInt(inputRecord.Iphon);
    if radioItemIndex<-1 then radioItemIndex:=-1;
    if radioItemIndex>3 then radioItemIndex:=3;
    form2.RadioGroup4.ItemIndex:=radioItemIndex;
    setLength(eventcath1,sliceNbr+1);
    setLength(eventcath2,sliceNbr+1);
    setLength(eventcath3,sliceNbr+1);
    setLength(eventcath4,sliceNbr+1);
    setLength(F0Arr,sliceNbr+1);
{4} inputRecordFromFile;                                                   //graphics parameters
    with inputRecord do F0panelDecHalfRev:=TpanelDecHalfRev(IsliceNbr);   //F0 plot Frame(Panel1,canvas,x1range,y1range,rDecimals,wspx1,wspy1,centr1,rHalf,rRev);
    x1Range:=Txy(inputRecord.IF0).x; cpstrPoint:=Txy(inputRecord.IF0).y; //F0 plot TpanelDecHalfRev = object rPanelNbr,rDecimals:byte; rHalf,rRev:boolean end; 220219 w "Spectrum" odnotowywany jest odtad cpstrPoint zamiast y1Range
     for i:=0 to nbrOfStreams-1 do                                      //streams plots parameters
       with drawingsArr[i] do   //object TdrawingsParam(TpanelDecHalfRev) = record panel:byte; xrange,yrange:word; chartColor:longint  end;
        with inputRecord do     //       TinPutRecord = record IsliceNbr : longWord;IstreamArray : array of TresArray;Iphon,Iperson,Igender,Iage : char;IF0 : single;  end;{record}
         try                    //object TpanelDecHalfRev = record rPanelNbr,rDecimals:byte; rHalf,rRev:boolean end;
          panelDecHalfRev:=TpanelDecHalfRev(IstreamArray[i,0]);
          rPanelNbr:=panelDecHalfRev.rPanelNbr;
          rDecimals:=panelDecHalfRev.rDecimals;
          rHalf:=panelDecHalfRev.rHalf;
          rRev:=panelDecHalfRev.rRev;
          xrange:=Txy(IstreamArray[i,1]).x;
          yrange:=Txy(IstreamArray[i,1]).y;
          try
           j:=longint(TsingInt(IstreamArray[i,2]));
           chartColor:=j;
           c[i]:=Txy(IstreamArray[i,3]).x;
           d[i]:=Txy(IstreamArray[i,3]).y;
          except
           showMessage('Streams are too short to encode the streams colors. We accept black for the "'+StreamNamesArr[i]+'" stream plot instead.');
           chartColor:=0;
          end;{try}
         except
          showMessage('Some graphics parameters were not retrieved, some graph can be not correct drawed probably due to too narrow window width(='+intToStr(d_count)+'; 4 at least is necessary)');
         end; {for i, try, with inputRecord, with drawingsArr[i]}

{5} for i:=0 to RecSizeCounter div 4-1 do read(inpFile,singleArr[i]);//inputRecordFromFile;          //cathegory sets retrieve
    cathSetsDecoder(singleArr);
    for i:=1 to 32 do
     begin
      if char(i) in phonSet then  form2.StringGrid1.Cells[i,1]:='#'+intToStr(i);
      if char(i) in personSet then  form2.StringGrid1.Cells[i,3]:='#'+intToStr(i);
      if char(i) in genderSet then  form2.StringGrid1.Cells[i,5]:='#'+intToStr(i);
      if char(i) in ageSet then  form2.StringGrid1.Cells[i,7]:='#'+intToStr(i);
     end;
    for i:=33 to 255 do
     begin
      if char(i) in phonSet then  form2.StringGrid1.Cells[i,1]:=char(i);
      if char(i) in personSet then  form2.StringGrid1.Cells[i,3]:=char(i);
      if char(i) in genderSet then  form2.StringGrid1.Cells[i,5]:=char(i);
      if char(i) in ageSet then  form2.StringGrid1.Cells[i,7]:=char(i);
     end;
    for i:=0 to 255 do AutoSizeCol(form2.StringGrid1,i);
{6} for i:=0 to RecSizeCounter div 4-1 do read(inpFile,singleArr[i]);//inputRecordFromFile;         //average constant list retrieve
     retrieveMultiMeanList(singleArr,nbrOfMultiMean);
    for i:= 0 to nbrOfMultiMean-1 do
     begin
     control1:=i;
     form2.ListBox1.addItem('',form2.listBox1);
     form2.ListBox1.Items[i]:=intToStr(frameNbrArr[i]);
     end;
    i:=filePos(inpFile);
{7} pathRetrieve(waveFileDir);       form2.Label7.Caption:=waveFileDir;
    i:=filePos(inpFile);
{8} pathRetrieve(cathFileDir);       form2.Label34.Caption:=cathFileDir;
    i:=filePos(inpFile);
    ShowControls;
    DataFrames;
    form2.panel1.Visible:=false;  form2.Button3.Visible:=false;
     nextPortion:=false;
    if form2.Button4.enabled then form2.button4.SetFocus;
    head:=filePos(inpFile) div (recSize div 4);                        //head limit; recSize is in bytes and filePos is in single=4 bytes;
    editsInitAndEnabler;
    try
     initRead  //in order to apply a previous choice of a stream for processing
    except
     checkedStreamNbr:=nbrOfStreams-1;                                 //default stream selection: a last stream on the list; acts in case InitRead is absent or erronous
     showMessage('The init file, i.e. the "'+initDir+'" could not succesfully be read, so a defauld stream, i.e. "'+
     StreamNamesArr[StreamIdx]+'" was chosed.'#13#10'Change it if necessary');
    end;{try}
    if not inArr(StreamsNbrs,checkedStreamNbr,streamIdx) then
     begin error7;
     checkedStreamNbr:=StreamsNbrs[high(StreamsNbrs)];
     InitWrite
     end; //in order to prevent the program falling in case of erronous data reading from the init file
    dataRAMallocator;
    control1:=high(vectList0[0]);
    //control2:=high(inputRecord.IstreamArray[StreamIdx]);
    control3:=high(vectList0);   //debug prp
    i:=0; manager:=#0;  checkPhonSet:=[]; checkPersonSet:=[]; checkGenderSet:=[]; checkAgeSet:=[]; breakDataReading:=false;
    scratch:=filePos(inpFile);
    fromScratch:=false;
    phonSetCounter:=0; personSetCounter:=0; genderSetCounter:=0; ageSetCounter:=0;
     Repeat   //===============================MAIN LOOP=======================================
      if fromScratch then
       begin
        control1:=high(vectList0[0]); control2:=high(inputRecord.IstreamArray[StreamIdx]); control3:=high(vectList0);   //debug prp
        dataRAMallocator;
        control1:=high(vectList0[0]); control2:=high(inputRecord.IstreamArray[StreamIdx]); control3:=high(vectList0);   //debug prp
        fromScratch:=false;
        seek(inpFile,scratch);
        i:=0;
       end;
       clear2:=true;clear3:=true;clear4:=true;clear5:=true;
       breakDataReading:=breakDataReading or form1.checkbox36.Checked and (i>=BreakReadingPoint-1);
  {9}  if not inputRecordFromFile then break;
        with form2,inPutRecord do //check if sets of cathegory values retrieved from the "Spectrum" data are correct
         begin
          include(checkPhonSet,Iphon);
          include(checkPersonSet,Iperson);
          include(checkGenderSet,Igender);
          include(checkAgeSet,Iage);
         end;
       with form2,inPutRecord do
         begin
         //Iphon:=cath[0]; Iperson:=cath[1];Igender:=cath[2]; Iage:=cath[3];
          k:=0;
          if StreamsNbrs[StreamIdx]<>0 then for j:=0 to nc do
           vectList0[i,j]:=IstreamArray[StreamIdx][j]
          else
           for j:=0 to nc div 2-1 do  //11072022
            begin   //decode every one single value as 2 integer values;
             control1:=j; control2:=k; control3:=i;             //debug prp
             waveVal:=TsingInt(IstreamArray[StreamIdx][j]);
             vectList0[i,k]:=waveVal[0];
             inc(k);
             vectList0[i,k]:=waveVal[1];
             inc(k);
            end;{for}
            // waveVal:=TsingInt(IstreamArray[StreamIdx][d_count div 2]);   debug prp., it should be aequal (0,0) or random
            //or (32000, -32000) if proper insert was introduced in the program Spectrum, in its procedure signalToOutStream, i.e.  the two lines:
            // singInt[0]:=32000; singInt[1]:=-32000;          //empty values finishes wav piece
            // outputRecord.streamArray[streamIdx[0],count div 2]:=single(singInt);
            // as the last instruction at this procedure (i.e. at the "signalToOutStream" procedure, rows c.a. 1877, 1878, unit NewSpectrum)

          //---------------------------cathegories load start   phonSetCounter, personSetCounter, genderSetCounter, ageSetCounter
          eventcath1[i]:=Iphon;   spcCath1SetAndListCreate(Iphon,phonSetCounter);      // form1.Label31.Caption:=cath1;
          eventcath2[i]:=Iperson; spcCath2SetAndListCreate(Iperson,personSetCounter);  //form1.Label32.Caption:=cath2;            //+#13#10'nbr='+intToStr(byte(cath2)-65);
          eventcath3[i]:=Igender; spcCath3SetAndListCreate(Igender,genderSetCounter);  //form1.Label33.Caption:=cath3;
          eventcath4[i]:=Iage;    spcCath4SetAndListCreate(Iage,ageSetCounter);        //form1.Label148.Caption:=cath4;
          F0Arr[i]:=IF0;
           //---------------------------cathegories load end
          form2.Label63.Caption:=intToStr(i+1);
          form2.Label61.Caption:=intToStr(i*paramRec.pJump);
          label65.Caption:=Iphon;
          label67.Caption:=Iperson;
          label10.Caption:=Igender;
          label13.Caption:=intToStr(byte(Iage));
         end;
       for j:=0 to nbrOfStreams-1 do     //xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        if StreamCheckArr[streamsNbrs[j]] then
         showGraph(j,scc[streamsNbrs[j]],inputRecord.IstreamArray[j],inputRecord.IF0);
       if form2.checkbox3.Checked then T0plot(i,inputRecord.IF0,inputRecord.Iphon);
       inc(i);
       readingSteering;
     Until breakDataReading;
    if not
{10} inputRecordFromFile then  dec(i);
    showMessage('In total '+intToStr(i)+' data record|s was|were read.');
    readEventNbr:=i;
    form2.CheckBox1.Checked:=true;                    //show graphics
    form2.button3.Enabled:=form2.checkBox1.Checked;   //start
    closeFile(inpFile);

    for i:=1 to 32 do
     begin
      if char(i) in checkPhonSet then  form2.StringGrid1.Cells[i,2]:='#'+intToStr(i);
      if char(i) in checkPersonSet then  form2.StringGrid1.Cells[i,4]:='#'+intToStr(i);
      if char(i) in checkGenderSet then  form2.StringGrid1.Cells[i,6]:='#'+intToStr(i);
      if char(i) in checkAgeSet then  form2.StringGrid1.Cells[i,8]:='#'+intToStr(i);
     end;
    for i:=33 to 255 do
     begin
      if char(i) in checkPhonSet then  form2.StringGrid1.Cells[i,2]:=char(i);
      if char(i) in checkPersonSet then  form2.StringGrid1.Cells[i,4]:=char(i);
      if char(i) in checkGenderSet then  form2.StringGrid1.Cells[i,6]:=char(i);
      if char(i) in checkAgeSet then  form2.StringGrid1.Cells[i,8]:=char(i);
     end;
    phonSetCounter:=0; personSetCounter:=0; genderSetCounter:=0; ageSetCounter:=0;
   for i:=0 to 255 do
    begin
      if char(i) in checkPhonSet   then inc(phonSetCounter);
      if char(i) in checkPersonSet then inc(personSetCounter);
      if char(i) in checkGenderSet then inc(genderSetCounter);
      if char(i) in checkAgeSet    then inc(ageSetCounter);
    end;
   if not breakDataReading then
    begin
     s:='';
     if phonSet<>checkPhonSet     then s:=s+'"'+cathNamesArr[0]+'" cathegory sets differ, i.e. the "'+cathNamesArr[0]+'"-set<>check-"'+cathNamesArr[0]+'"-set'#13#10;
     if personSet<>checkPersonSet then s:=s+'"'+cathNamesArr[1]+'" cathegory sets differ, i.e. the "'+cathNamesArr[1]+'"-set<>check-"'+cathNamesArr[1]+'"-set'#13#10;
     if genderSet<>checkGenderSet then s:=s+'"'+cathNamesArr[2]+'" cathegory sets differ, i.e. the "'+cathNamesArr[2]+'"-set<>check-"'+cathNamesArr[2]+'"-set'#13#10;
     if ageSet<>checkAgeSet       then s:=s+'"'+cathNamesArr[3]+'" cathegory sets differ, i.e. the "'+cathNamesArr[3]+'"-set<>check-"'+cathNamesArr[3]+'"-set';
     if s<>'' then showMessage(s);
     showMessage('"'+cathNamesArr[0]+'" cathegory set contains '+intToStr(phonSetCounter)  +' values vs '+  intToStr(phonNbr)+' values,'#13#10'"'+
                     cathNamesArr[1]+'" cathegory set contains '+intToStr(personSetCounter)+' values vs '+intToStr(personNbr)+' values,'#13#10'"'+
                     cathNamesArr[2]+'" cathegory set contains '+intToStr(genderSetCounter)+' values vs '+intToStr(genderNbr)+' values,'#13#10'"'+
                     cathNamesArr[3]+'" cathegory set contains '+intToStr(ageSetCounter)   +' values vs '+intToStr(ageNbr)   +' values.');
    end;{if}
  // setLength(singleInfo,0);                //local in proc. streamsNamesRetrieve
  // setLength(textInfo,0);                  //local in proc. streamsNamesRetrieve
   setLength(inputRecord.IstreamArray,0,0);  //allocate memory to the stream array
   setLength(singleArr,0);
   //setLength(drawingsArr,0);               //each time is used an one value drawingsArr[checkedStreamNbr].yRange in Unit2
   //setLength(StreamNamesArr,0);            //needed for stream radiogroups description (i.e. form1.radiogroup2 and 8
   //setLength(StreamsNbrs,0);
   setLength(StreamCheckArr,0);
   setLength(StreamColorsArr,0);
   setLength(frameNbrArr,0);
   //setLength(eventcath1,0); //lists used for IR computing
   //setLength(eventcath2,0);
   //setLength(eventcath3,0);
   //setLength(eventcath4,0);
   //setLength(vectList0,0,0);
Q: form2.Visible := false;
  //setlength(edits,0);            //jest inicjowane w formCreate
  //setLength(StreamPointerArr,0); //jest inicjowane w formCreate
   vqUnit.dataPrepare2(callChain);
  End;{dataProcess}


end.

