unit disco;


interface
uses Windows,Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, MPlayer, StdCtrls, Buttons, ComCtrls, Grids;

implementation

uses visualization,dataProcessor;
type
  pathStr = String;
   dirStr = string[80];
  nameStr = string[80];
   ExtStr = string[80];
  charSet = set of char;
var
ReportFile, GaussSearchFile : textFile;

 function ampersandRemove(caption:shortString):shortString;
  var i:byte;
  begin
     i:=0;                                               //delete &
    while i<byte(caption[0]) do
     begin
      inc(i);
      if caption[i]='&' then begin delete(caption,i,1); dec(i) end;
     end;{del&}
   ampersandRemove:=caption;
  end;{ampersandRemove}

 function WhereSave(var outFileDir:pathStr; const title,ext:pathStr):boolean;

 //---------------points a path, where results should be saved

  var dlg:longint;  logic:boolean;
  begin
   with form1 do
    begin
     Repeat
      repeat
       saveTextFileDialog1.title:=title+'.'+ext+'"';
       saveTextFileDialog1.defaultExt:=ext;
       saveTextFileDialog1.FileName:=outFileDir;
       saveTextFileDialog1.InitialDir :=extractFileDir(outFileDir);
       saveTextFileDialog1.Filter := 'Dedicated files, i.e. *.'+ext+'|*.'+ext+'|All files, i.e. *.*|*.*';
       logic:=directoryExists(saveTextFileDialog1.InitialDir);
       if logic then
       else showMessage('[WhereSave] A proposed directory, i.e. the "'+saveTextFileDialog1.InitialDir+'" does not exist.');
       result:=saveTextFileDialog1.Execute;
       Case result of
        true : begin
                 outFileDir:=saveTextFileDialog1.FileName;
                 InitWrite;
               end; {case result}
       false : begin
                dlg:=MessageDlg(pchar('[WhereSave] You have''nt pointed a file. Should a default file be pointed, i.e. "'+
                #13#10+OutFileDir+'"?'),mtWarning,[mbRetry,mbAbort,mbYes],1);  //retry=4, abort=3 yes=6
                if logic then showMessage('[WhereSave] Check, whether there was not something wrong with the file path "'
                +OutFileDir+'" or check'+' the init file text, i.e. the "'+InitDir+'". Repair or delete it, espe'+
                'cially when no "Save Dialog"'+' was opened for this file.');
                case dlg of
                 4 : if logic then                  //retry=4; to open save dialog with  initial directory = programDir
                      begin
                       saveTextFileDialog1.FileName:=extractFileName(OutFileDir);
                       saveTextFileDialog1.InitialDir :=programDir+'\';
                       result:=saveTextFileDialog1.Execute;
                      end;
                 6 : result:=true;                   //yes=6
                 3 : exit;                          //abort=3
                end;{case dlg}
               end; {case result=false}
        End;{Case result}
      until result;
      if fileExists(OutFileDir) then
       if application.messageBox(pchar('[WhereSave] File "'+OutFileDir+'" exists, overwrite it?.'),pchar('Saving spectral analyses results'),4)=7 {no}
       then result:=false
       else
     else showMessage('[WhereSave] File "'+OutFileDir+'" does not exists.') ;
     Until result;
    end{with}
 end; {WhereSave}

 procedure AnalysisParamRegisterToReport;
   type TparamRec=record pWinShape,pF0WinShape, p0component, pJump:byte; end;

   var   i, recSize : longword;
           paramRec : TparamRec;
                 ic : byte; //streamNames counter

 Begin      //--------------------------------AnalysisParamRegisterToReport------------------------------------
  writeln(reportFile,'Analysis parameters:');
  i:=1;
  with inPutRecord do   //--------------------------------------write down parameters of analysis at the first record
   begin
    writeln(reportFile,i:3,') number of streams ', nbrOfStreams,', i.e. (stream name):');
    for ic:=0 to nbrOfStreams-1 do writeln(reportFile,'    > ',streamNames[ic]); writeln(reportFile);
    inc(i);
    F0Count:=count;
    writeln(reportFile,i:3,') windows width  for F0 measurements ',F0Count,' (temporary value accepted until windows width and shape for F0 measurements will be developed)');
    inc(i);
    writeln(reportFile,i:3,') Size of records ',recSize,' bytes');
    inc(i);
    writeln(reportFile,i:3,') Jump nbr samples ',jumpNbrSamples,' samples');
    inc(i);
   with paramRec do
    begin
     pWinShape:=  form1.RadioGroup7.ItemIndex;
     writeln(reportFile,i:3,') weighting windows shape used for spectrum analyses nbr ',pWinShape, ' i.e. ',ampersandRemove(form2.RadioGroup7.Items[form2.RadioGroup7.ItemIndex]));
     inc(i);
     p0component:=byte(form2.checkBox30.Checked);
     write(reportFile,i:3,') 0-th component=0? - '); if p0component=0 then writeln(reportFile,'no') else writeln(reportFile,'yes');
     inc(i);
     writeln(reportFile,i:3,') filter nbr ',form1.RadioGroup2.ItemIndex);
     inc(i);
     pF0WinShape:=pWinShape;
     writeln(reportFile,i:3,') weighting windows shape nbr used for F0 measurements ', pF0WinShape,
      ' i.e. ',ampersandRemove(form2.RadioGroup7.Items[form2.RadioGroup3.ItemIndex]), //radio7 because radio 3 has no labels
      ' (temporary value accepted until windows width and shape for F0measurements will be developed)');
     inc(i);
     with form2 do
      writeln(reportFile,#13#10,i:3,') There was analysed '+label61.caption+' of '+label11.caption+
                         ' samples, i.e. '+label63.caption+' of '+label30.caption+' slices.');
    end;{with}
    inc(i);
    writeln(reportFile,i:3,') number of the "',cathNameArr[1],'" values ', phonNbr);
    inc(i);
    writeln(reportFile,i:3,') number of the "',cathNameArr[2],'" values ',personNbr);
    inc(i);  //number of persons (liczba osb)
     writeln(reportFile,i:3,') number of the "',cathNameArr[3],'" values ',genderNbr);
    inc(i);
     writeln(reportFile,i:3,') number of the "',cathNameArr[4],'" values ',ageNbr);
    inc(i);
    writeln(reportFile,i:3,')rate=', rate:5:0);
    inc(i);
    writeln(reportFile,i:3,') basic average frames (for vPS, cPS, vPC, cPC)=',frameNbr);
    if form1.CheckBox49.Checked then
     try
      writeln(reportFile,'CCR bundle="',form1.radiogroup4.Items[form1.radiogroup4.ItemIndex],'"', '; number of multimean=',nbrOfMultimean);
      writeln(reportFile,'Averaging constants:');
      for ic:=0 to nbrOfMultimean-1 do write(reportFile,#9,frameNbrArr[ic]);writeln(reportFile);
     except
     end;{try}
    flush(reportFile);
   end;{with}
 End;{AnalysisParamRegisterToReport}

 function writePathsToReport:boolean;
  begin
   try
     writeln(reportFile,'Report file path:');
     writeln(reportFile,'  ',ReportFilePath);
     Writeln(reportFile,'Input files paths:');
     Writeln(reportFile,'  ',waveFilePath);
     Writeln(reportFile,'  ',cathFilePath);
     writeln(reportFile,'Output files paths:');
     writeln(reportFile,'  ',OutRecordFilePath);
     Writeln(reportFile,'  ',GaussSearchFilePath);
     Writeln(reportFile,'Cathegories names:');
     Writeln(reportFile,'  ',form1.edit3.Text);
     Writeln(reportFile,'  ',form1.edit4.Text);
     Writeln(reportFile,'  ',form1.edit6.Text);
     Writeln(reportFile,'  ',form1.edit7.Text);
     writeln(ReportFile,flush(ReportFile));
     writePathsToReport:=true;
    except
     writePathsToReport:=false
    end;
  end;



end.

 repeat
 {6,save} reportSave:=whereSave(ReportFilePath,'Save to report file slides and windows searching results into eg. "'+fileDir+'\'+fileName+'Report','txt');
          if reportSave then
            begin
             form1.label93.Caption:=ReportFilePath;
       {7=4} fileDateSize(ReportFilePath,tmp1,tmp2); form1.label95.caption:=tmp1; form1.label94.caption:=tmp2;application.ProcessMessages;
             assignFile(ReportFile,ReportFilePath);
             rewrite(ReportFile);
             writeln(ReportFile,#13#10,FormatDateTime('dd.mm.yyyy hh:nn:ss', Now));
             writeln(ReportFile,'Results from "',application.ExeName,'" launching.');
             flush(ReportFile);
             form2.Button5.Enabled:=true; form2.Button10.Enabled:=true;
            end {if}
            else
            begin
             form2.Button5.Enabled:=false; form2.Button10.Enabled:=false;   //block slide and history saving
             if MessageDlg(pchar('[openFiles], Report file, i.e. "'+ReportFilePath+'" will not be created! Remember, it is a must for the WindowsSearch procedure.'#13#10+
                'You can retry or abort to continue with no saving.'),
                mtWarning,[mbRetry,mbAbort],1)=3   //retry=4, abort=3 yes=6
             then break;
            end;
         until reportSave;

