unit Unit2;

interface
uses unit1,types,ExtCtrls, Graphics, forms,VQUnit,sysutils, dialogs;

 var
  wspx1,wspy1,topHeight1, wspx2,wspy2,topHeight2, wspx3,wspy3,topHeight3, wspx4,wspy4,topHeight4, wspx5,
                                         wspy5,topHeight5, wspx6,wspy6topHeight6,wspx7,wspy7,topHeight7 : double;   //wspczynniki proporcjonalnoci dla poszczeglnych paneli
                                                                      centr2,centr3,centr4,centr5,centr7: integer;                              //centra pionowe dla poszczeglnych paneli
  cath1IRmax,cath2IRmax,cath3IRmax,cath4IRmax,IRstretch,cath1ErrMax,cath2ErrMax,cath3ErrMax,cath4ErrMax,
                                                                                             errStretch : double;
                                                                                             txtStretch : smallInt;
                                                                                            T0plotStart : dword;
IRdrawings : procedure (Panel:TPanel;canvas:tcanvas;const classNbr:Word; const  prevX,currX:double;
                        var prevY:double; currY:double; const wspy,topHeight:double; const lineColor:longInt);

 function GetColor(i:longWord):Tcolor;
 procedure curvesColors(callChain:string);
 procedure frame(Panel:TPanel;canvas:tcanvas;const xStretch:longWord; const stretch:double; var wspx,wspy:double; var centr:integer; const centrDraw:boolean;const xDescr:shortString);
 procedure IRframe(Panel:TPanel;canvas:tcanvas;const classNbr:Word; const stretch:double; ceil1,ceil2,ceil3,ceil4:double;
                   out wspx,wspy,topHeight:double;const ceils:boolean;const Xdescr:shortString;callChain:string);
 procedure IRdrawings_clipped(Panel:TPanel;canvas:tcanvas;const classNbr:Word; const  prevX,currX:double;
                      var prevY:double; currY:double; const wspy,topHeight:double; const lineColor:longInt);
 procedure IRdrawings_noClipping(Panel:TPanel;canvas:tcanvas;const classNbr:Word; const  prevX,currX:double;
                      var prevY:double; currY:double; const wspy,topHeight:double; const lineColor:longInt);
 procedure VertLine(const panel:Tpanel; const cl:longint;const currX:double;currY:integer);
 procedure showSpcInputRecord(panel:Tpanel;const cath1,cath2,cath3,cath4:AnsiChar; const count:word; const yRange:word;stndrd:boolean;var xDescr:shortString);
 procedure showTxtInputRecord(panel:Tpanel;const cath1,cath2,cath3,cath4:AnsiChar;const txtStretch:smallInt;var xDescr:shortString);
 procedure VertTicker(panel:Tpanel;canvas:Tcanvas;const stretch:double;const wspy:double; const centr:word; const dir:shortInt;const sgn:shortInt);
 procedure HorizTic(Panel:TPanel;canvas:tcanvas; const xStretch:word; const wspx:double;const k:dWord);
 procedure showModifiedSpcInput(panel:tpanel;const stndrd:boolean;const xDescr:shortString);
 procedure showModifiedTxtInput(panel:tpanel;const stndrd:boolean;const xDescr:shortString);
 procedure blindFrames(rColor:Tcolor);
 procedure VQT0plot(const iw:dword;F0:single; zn2:AnsiChar; var T0plotStart:dword);
 procedure Repaint(const step:dword);

 implementation
uses system.UITypes,dataProcessor,LVQ_spr_Drawings,math,distributions;
var xF0T0 : word;
 function cathShow(cath:AnsiChar):string;
  begin
   if byte(cath)<=32 then result:='#'+intToStr(byte(cath))
   else result:=cath;
  end;{cathShow}

 function GetColor(i:longWord):Tcolor;
 begin
   case i of
    0: result:=clBlack;
    1: result:=clWhite;
    2: result:=clBlue;
    3: result:=clFuchsia;
    4: result:=clYellow;
    5: result:=clTeal;
    6: result:=clRed;
    7: result:=clAqua;
    8: result:=clLime
    else result:=0;
   end
 end;{GetColor}

procedure curvesColors(callChain:string);
var labelColor : longint;
 begin
  callChain:=callChain+'>curvesColors';
   with form1 do     //kolory linii wykresw wynikw analiz (Uwaga, to nie ma nic wsplnego z kolorami strumieni!
   begin
   if byte(checkBox2.Checked)+byte(checkBox3.Checked)+byte(checkBox4.Checked)+byte(checkBox28.Checked)=1 then
    begin //-----------------------some single classifier is used-----------------------
     singleClass:=true;
     if not checkBox10.Checked then //preserve last session labels colors when graph overlay mode is executed
      begin
       cl1:=clBlack; cl2:=clBlack; cl3:=clBlack; cl4:=clBlack; cl5:=clBlack;  //in order, when single classifier is used; a previous session classifier used changed to black color
      end;
     labelColor:=GetColor(perfCounter mod 9);
     if checkBox2.Checked then cl1:=labelColor
     else
      if checkBox3.Checked then cl2:=labelColor
      else
       if checkBox4.Checked then cl3:=labelColor
       else
        if checkBox28.Checked then cl4:=labelColor;
     cl5:=labelColor;
     if ovrGraphs then checkBox10.Checked:=true;
     label56.Caption:='Distortion; curve nbr:';
     Application.ProcessMessages;//bo nie pojawia si pierwszy numer wykresu - 0.
     canvas.font.color:=getColor(perfCounter mod 9);
     canvas.Font.Style:=[fsBold];
     canvas.TextOut(round((perfCounter mod 9)*20+label56.left+length(label56.Caption)*label56.Font.Size/1.35),label56.Top, intToStr(perfCounter))
    end  {a single classification}
   else
    begin //colors when more than one classifier is used
     singleClass:=false;
     cl1:=clblue; cl2:=clRed; cl3:=clgreen; cl4:=clYellow; cl5:=clBlack;
     label56.Caption:='Mean distortion (average distances over tree leaves)';
     label56.color:= label64.Color;
    end;

   label71.Color:=cl1; label72.Color:=cl2; label73.Color:=cl3; label149.Color:=cl4;
   label57.Color:=cl1; label58.Color:=cl2; label59.Color:=cl3; label153.Color:=cl4;

   if (cl1=clBlack) or (cl1=clBlue) then label71.font.Color:=clWhite else label71.font.Color:=clBlack;
   if (cl2=clBlack) or (cl2=clBlue) then label72.font.Color:=clWhite else label72.font.Color:=clBlack;
   if (cl3=clBlack) or (cl3=clBlue) then label73.font.Color:=clWhite else label73.font.Color:=clBlack;
   if (cl4=clBlack) or (cl4=clBlue) then label149.font.Color:=clWhite else label149.font.Color:=clBlack;

   if (cl1=clBlack) or (cl1=clBlue) then label57.font.Color:=clWhite else label57.font.Color:=clBlack;
   if (cl2=clBlack) or (cl2=clBlue) then label58.font.Color:=clWhite else label58.font.Color:=clBlack;
   if (cl3=clBlack) or (cl3=clBlue) then label59.font.Color:=clWhite else label59.font.Color:=clBlack;
   if (cl4=clBlack) or (cl4=clBlue) then label153.font.Color:=clWhite else label153.font.Color:=clBlack;

   Application.ProcessMessages;
  end;{with}
  ovrGraphs:=false;
 end;{curvesColors}

  procedure HorizTic(Panel:TPanel;canvas:tcanvas; const xStretch:word; const wspx:double; const k:dword);
   var d:double; i:byte; x,bottom,xNbr:word; switch:boolean;
   Begin
    d:=xStretch/21;
    with Panel,canvas do
     begin
      bottom:=top+height;  switch:=true;
      for i:=0 to 20 do
       begin
        x:=left+round(round(i*d)*wspx);                     //x:=round(left+(round(i*d) div 5)*5*wspx); 241119
        moveTo(x,bottom-1);                                //tic, begin
        lineTo(x,bottom-3);  application.processmessages; //tic end
        if switch then                                   //underscore every second point (podpis na co 2. dzialce)
         begin
          moveTo(x,bottom+2);                          //longer tic
          lineTo(x,bottom-4);  application.processmessages;
          xNbr:=round(i*d);                          //081119, kompilator nie zezwala na uzycie tych wyrae w textOut
          TextOut(x+1,bottom+1,intToStr(xNbr+k)); application.processmessages;
         end;
        switch:=not switch;
       end;{for}
     end;{with}
   End;{HorizTic}

procedure VertTicker(panel:Tpanel;canvas:Tcanvas;const stretch:double;const wspy:double; const centr:word; const dir:shortInt;const sgn:shortInt);

  var   tickCount,tickSpace, d:word; j:integer; nbrStep:extended;
        s:shortString;
  const decimals=9;

  procedure Tick(const i:byte;const centr:word);

  Begin
   with panel,canvas do
    begin
     j:=(top+round(centr-dir*i*NbrStep*wspy));                     //d increases until a tick number is writen down, then d:=0
     moveTo(left,j);
     lineTo(left+3,j); application.processMessages;          //tick
    end;
   End;{tick}

   function delZeros(s:shortString):shortString;
    var relFig:boolean; cd:char; c:ansiChar; i:byte;
    Begin
     relFig:=false;
     cd:=FormatSettings.decimalSeparator;  //debug prp
     repeat
      i:=length(s);
      c:=s[i];
      relFig:=(c in ['1','2','3','4','5','6','7','8','9']) or (pos(FormatSettings.decimalSeparator,s)=0);
      if (((c='0') and (pos(FormatSettings.decimalSeparator,s)<i)) or (c=ansiChar(FormatSettings.decimalSeparator))) and not relFig then delete(s,i,1);
     until relFig;
     result:=s;
    End;

  procedure number(i:byte);
   var m:Integer;
   begin
    with panel,canvas do
     begin
      if (d>=-2*Font.Height) or (d=0) then
      begin
       s:=delZeros(floatToStrF((dir*sgn*i*NbrStep),ffFixed,8,decimals));
       for m:=1 to 5-length(s) do s:=' '+s;  //equalizing of the description length to 8 by adding spaces fom front
       canvas.TextOut(left-22,j+Font.Height,s);   application.processMessages; //-6*font.Size
       moveTo(left-1,j);  //-5
       lineTo(left+5,j); application.processMessages;     // numbers tick  bylo +1
       d:=0;                             //d increases until a tick number is writen down, then d:=0
      end;{if}
      inc(d,tickSpace);
     end;{with}
   end;{number}

   var i:byte; a:shortInt; stretch1000,mult:extended;  nbrJump:byte;
   Begin //----------vertTicker-------------
     stretch1000:=abs(stretch);  a:=0;
     if stretch=0 then exit;  // 18.01.20
     if stretch<1000 then
     while stretch1000<1000 do
      begin
       stretch1000:=stretch1000*10;
       inc(a);
      end
     else
      while stretch1000>10000 do
      begin
       stretch1000:=stretch1000/10;
       dec(a);
      end;
     i:=1;  mult:=power(10,a); nbrJump:=50;//desired tics spaces
     repeat
      nbrStep:=(round(i*stretch1000/nbrJump) div nbrJump)*nbrJump; //minimal number step space for ticks
      tickSpace:=round(wspY*nbrStep/mult);
      control1:=i; inc(i);    //control1 - debug prp
     until tickSpace>=5{pixels};
     nbrStep:=nbrStep/mult;
     tickCount:=trunc(panel.height/tickSpace);
     d:=0;  i:=0; j:=panel.top+1;
     While (j>=panel.Top) and (j<=panel.Top+panel.Height) do  //for i:=0 to tickCount do
      begin
       tick(i,centr);
       number(i);        //<, because font.height is <0
       inc(i);
      end;
  End;{VertTicker}


 procedure IRframe(Panel:TPanel;canvas:tcanvas;const classNbr:Word; const stretch:double; ceil1,ceil2,ceil3,
  ceil4:double; out wspx,wspy,topHeight:double;const ceils:boolean;const Xdescr:shortString;callChain:string);
  //Wykrela ramki pokazujce pole wykresu
  //strech - zakres zmiennoci y
  //wspx,wspy - wspczynniki proporcjonalnoci dla okna
  //ceil - grne ograniczenie wykresu
  var leftWidth:integer;  str:string; maxCeil:double;

  procedure ceilDraw(const ceil:double);
   begin
    if not ceils then exit;
    canvas.moveTo(panel.left,round(ceil));
    canvas.lineTo(round(leftwidth),round(ceil));
   end;

  Begin   //--------------------------------IRframe---------------------------
    callChain:=callChain+'>IRframe';
   with Panel,canvas do
    begin
     pen.Color:=clWhite;
     leftWidth:=left+Width;   topHeight:=top+Height;
     try
      wspy:=height/stretch;
     except
      wspy:=1.7e308
     end;
     if panel=form1.panel3 then    //okreli pooenie etykiety najwyszego progu na wykresie IR
      begin
       if ceil1>ceil2 then maxCeil:=ceil1 else maxCeil:=ceil2;
       if maxCeil<ceil3 then maxCeil:=ceil3;
      end;
     ceil1:=top+Height-ceil1*wspy; ceil2:=top+Height-ceil2*wspy; ceil3:=top+Height-ceil3*wspy; ceil4:=top+Height-ceil4*wspy;
     if classNbr=0 then wspx:=0 else wspx:=width/classNbr;
     Pen.Color:=clblack;                                           //------------------------------------a ten jest!
     Rectangle(left-24,top-5,round(leftWidth+10), round(topHeight+15));         Application.ProcessMessages;
     Pen.Color:=clwhite;
     Rectangle(left,top,leftWidth, top+Height);                                 Application.ProcessMessages;
     Pen.Color:=clblue;   if form1.checkBox2.checked then ceilDraw(ceil1);       Application.ProcessMessages;//linie wyznaczajce grne ograniczenia wykresw: cath1
     Pen.Color:=clred;    if form1.checkBox3.checked then ceilDraw(ceil2);       Application.ProcessMessages;//                                                cath2
     Pen.Color:=clgreen;  if form1.checkBox4.checked then ceilDraw(ceil3);       Application.ProcessMessages;//                                                cath3
     Pen.Color:=clYellow; if form1.checkBox28.checked then ceilDraw(ceil4);      Application.ProcessMessages;//                                                cath4
     if panel=form1.panel3 then str:=floatToStrF(maxCeil,ffNumber,6,4)
     else str:=intToStr(round(stretch));
     if panel=form1.panel3 then TextOut(leftWidth+15,round(top+Height-maxCeil*wspY)+font.Height,'          ')
     else TextOut(round(leftWidth)+15,top+font.Height,'          ');    //wyczy pole tekstowe (ma znaczenie dla error i card przy przerwaniach i insertach)
     if panel = form1.panel4 then str:=str+'%';                   //bd poda w %
     if panel=form1.panel3 then TextOut(leftWidth+15,round(top+Height-maxCeil*wspY)+font.Height,str)
     else TextOut(leftWidth+15,top+font.Height,str);
     TextOut(leftWidth+15,round(top+Height+font.Height),'0');
    end;
   canvas.Pen.Color:=clwhite; //canvas.pen.Width:=2;   Panel:TPanel;canvas:tcanvas; const xStretch:word; const wspx:double
   with panel do canvas.TextOut(left,top+height+10,Xdescr);
   HorizTic(Panel,canvas,classNbr,wspx,0);  application.processmessages;
   VertTicker(panel,canvas,stretch,wspy,panel.Height,1,1); application.processmessages;
   canvas.pen.Width:=1;
  End;{IRframe}

  function interX(x1,x2,y,y1,y2:double):double;
   begin
    result:=((y-y1)*(x2-x1)+(y2-y1)*x1)/(y2-y1);
   end;

 procedure IRdrawings_clipped(Panel:TPanel;canvas:tcanvas;const classNbr:Word; const  prevX,currX:double;
                      var prevY:double; currY:double; const wspy,topHeight:double; const lineColor:longInt);
 //wykresy biecych wartoci IR lub error lub distortion
 //strech - zakres Y,
 //prevX,prevY - wsporzdne poprzeniego punktu (poprzednia warto step i IR) nieskalowane Y!
 //currX,currY - wsporzdne biecego punktu (warto step i IR)              nieskalowane Y!
  var prevYwspY,currYwspy,tY:double;
      newX,newY:word;
  Begin
  // panel.visible:=false;    //28042019 - dodano, bo wykresy IR nie pojawiasiw 1. sesji programu o ile nie potwierdzono nastaw po wczytaniu danych
   with panel,canvas do
   begin
    Pen.Color:=lineColor;
    currYwspy:=currY*wspy;  prevYwspY:=prevY*wspY;
    prevY:=top+Height-prevYwspy;               //skalowa prevY; prevX:=(step-1)*wspx+left;    10.04.09
    tY:=currY;                                //zapaminieskalowan currY
    currY:=top+Height-currYwspy;               //skalowa currY
    with canvas do                            //currX:=step*wspx;             10.04.09
    if (prevY>=top) and (prevY<=top+Height) then
     moveTo(round(prevX),round(prevY)) //punkt docelowy jest w zakresie
    else
    Begin //------------------------------------------------------move clipping-----------
     if (currY>=top) then                                                     //punkt docelowy poniej grnej ramki
     if (prevY<top) then                                                          //start powyej grnej ramki
      begin
       newX:=round(interX(prevX,currX,top,prevY,currY));                      //debug prp
       newY:=top;
       moveTo(newX,newY);
     end;
     if (currY<=top+Height) then                                               //punkt docelowy powyej  dolnej ramki
     if (prevY>top+Height) then                                                    //start poniej dolnej ramki
     begin
      newX:=round(interX(prevX,currX,Height,prevY,currY));                 //debug prp
      newY:= top+Height;
      moveTo(newX,newY);
     end;
    End;  //-------------------------------------------------------------------------------
    if (currX<=width+left) then
     Begin
      if (currY>=top) and (currY<=top+Height)  then
       canvas.lineTo(round(currX),round(currY))         //punkt docelowy jest w zakresie  (a goal point is in a range)
      else
       begin   //=====================================line clipping==================================
         prevY:=top+Height-prevYwspy;
        if (prevY>top) and (currY<top) then                //punkt docelowy powyej  ramki
         begin
          newX:=round((interX(prevX,currX,top,prevY,currY)));
          canvas.lineTo(newX,top);
         end;
        if (prevY>top) and (currY>top+Height) then                //punkt docelowy poniej ramki
         begin
          newX:=round((interX(prevX,currX,top+Height,prevY,currY)));
          canvas.lineTo(newX,top+Height); //punkt docelowy poniej ramki
         end;
       end;{else}
     End;
   end;{with}
    prevY:=tY;
  End; {IRdrawings_clipped}

 procedure IRdrawings_noClipping(Panel:TPanel;canvas:tcanvas;const classNbr:Word; const  prevX,currX:double;
                      var prevY:double; currY:double; const wspy,topHeight:double; const lineColor:longInt);
 //wykresy biecych wartoci IR lub error lub distortion
 //strech - zakres Y,  prevX,prevY - wsporzdne poprzeniego punktu (poprzednia warto step i IR)

  Begin
   with panel,canvas do
   begin
    Pen.Color:=lineColor;
    prevY:=top+Height-prevY*wspy;
    with canvas do
    moveTo(round(prevX),round(prevY));
    prevY:=currY;
    currY:=currY*wspy;
    currY:=topHeight-currY;  //currX:=currX+left;             10.04.09
    canvas.lineTo(round(currX),round(currY));
   end;
  End;{IRdrawings_noClipping}

  procedure blindFrame(Panel:TPanel;canvas:tcanvas;const rColor:Tcolor);
  //Wykrela tylko zewntrzne ramki pokazujce pola wykresw
  begin
   with Panel,canvas do
    begin
     form1.Canvas.TextOut(left+width-45,top-25,'                  ');
     TextOut(left,top+height+10,'                         ');
     Pen.color:=form1.Color-15;
     Rectangle(left+Width+11,top-15,form1.GroupBox2.Left-1,top+Height+15);  //clear left side
     Pen.Color:=rColor;
     Rectangle(left-24,top-5,left+Width+10,top+Height+15);
    end;{with}
   application.processMessages;
  end;{blindFrame}

  procedure blindFrames(rColor:Tcolor);
   Begin
    with form1 do
     begin
      label56.Visible:=False; label61.Visible:=False;  Application.ProcessMessages;
      blindFrame(Panel2,canvas,rColor);
      label64.Visible:=False; label57.Visible:=False; label58.Visible:=False; label59.Visible:=False; label153.Visible:=False; Application.ProcessMessages;
      blindFrame(Panel3,canvas,rColor);
      label60.Visible:=False; label157.Visible:=False;  Application.ProcessMessages;
      blindFrame(Panel4,canvas,rColor);
      label100.Visible:=False; label168.Visible:=False; Application.ProcessMessages;
      blindFrame(Panel7,canvas,rColor);
     end
   End;

  procedure frame(Panel:TPanel;canvas:tcanvas;const xStretch:longWord; const stretch:double; var wspx,wspy:double; var centr:integer; const centrDraw:boolean;const xDescr:shortString);
  //Wykrela ramki pokazujce pole wykresu
  //wspx,wspy - wspczynniki proporcjonalnoci dla okna
  //centr - rodek w pionie pola rysunku
  var leftWidth,topHeight:integer;
  begin
   with Panel,canvas do
    begin
     leftWidth:=left+Width;   topHeight:=top+Height;
     centr:=round(top+height/2);
     wspy:=(height)/stretch;
     wspx:=width/xStretch;
     Pen.Color:=clblack;
     Rectangle(left-24,top-5,leftWidth+10, topHeight+15);
     Pen.Color:=clwhite;
     Application.ProcessMessages;
     Rectangle(left,top,leftWidth, topHeight);
     Application.ProcessMessages;
     if centrDraw then
      begin
       moveTo(left,centr);
       Application.ProcessMessages;
       lineTo(left+width,centr);
       Application.ProcessMessages;
      end;
     moveTo(left,centr);
     Application.ProcessMessages;
    end;{with}
   canvas.Font.Size:=6;
   if form1.CheckBox32.Checked then  HorizTic(Panel,canvas,xStretch,wspx,0) //full plot
   else HorizTic(Panel,canvas,nc,wspx,0);
   application.processmessages;
   vertLine(panel,clGray,round((nc)*wspx+panel.left),panel.top);
   with panel do canvas.TextOut(left,top+height+10,Xdescr);
   application.processMessages;
  end;{frame}

 procedure VertLine(const panel:Tpanel; const cl:longint;const currX:double;currY:integer);
 {
 draws vertical line pointing step, when all cathegorical values have their own representative set
 }
 var origCl:longInt;
  begin
   with form1,panel,canvas do
    begin
     origCl:=Pen.Color;
     Canvas.Pen.Color:=cl;
     Canvas.moveTo(round(currX),top+height);
     Canvas.lineTo(round(currX),top);
     Canvas.moveTo(round(currX),currY);
     Canvas.Pen.Color:=origCl;
    end;
  end;{VertLine}

  procedure U2OscDraw(panel:tpanel;canvas:tcanvas; const y:Tvect;{array of smallInt;}wspx,wspy : double; centr:integer;
  const count:longWord;const xF0:word; const clear:boolean;const chartColor:longInt; const cath1,cath2,cath3,cath4:AnsiChar);
//---------------------oscylogram danych wave    var Yzero,wagi,xr,yi : rAryType;
var
      i : longWord;
      j : longint;
    label e1;
  begin if not form1.CheckBox13.Checked then exit;//poka grafik
   panel.Visible:=clear;
   panel.Visible:=false;
   with panel do
    begin
     j:=centr;
     if j<top then goto e1;
     if j>top+Height then goto e1;
     form1.Canvas.Pen.Color:=clgreen;
     form1.Canvas.moveTo(round((nc)*wspx+left),top);   //vertical line - cut off marker
     form1.canvas.LineTo(round((nc)*wspx+left),top+height);
     form1.Canvas.TextOut(left+width-45,top-25,'                .');
     form1.Canvas.TextOut(left+width-45,top-25,cathShow(cath1)+', '+cathShow(cath2)+', '+cathShow(cath3)+', '+cathShow(cath4));
e1:  form1.Canvas.Pen.Color:=chartColor;
    i:=high(y);                               //debug prp
     j:=round(-y[0]*wspy+centr);
     if j<top then j:=top;
     if j>top+Height then j:=top+Height;
     canvas.moveTo(left,j);
    end;{with}
   application.processMessages;
   for i:=1 to count-1 do with Panel do
    begin
     control1:=i;                     //debug prp
     control2:=y[i];                  //debug prp
     control3:=-y[i]*wspy+centr;      //debug prp
     j:=round(-y[i]*wspy+centr);
     if j<top then j:=top;
     if j>top+Height then j:=top+Height;
     canvas.LineTo(round(i*wspx+left),j);
    end;{for}
   if form1.CheckBox32.Checked or (xF0<nc) then  VertLine(panel,clgreen,xF0,panel.top);//check32 = "Full Plot" i.e. 0..nc
   application.processMessages;                  //Uwaga! skasuje narysowany oscylogram, jeli wczeniej nie wywoano jeszcze processmessages
  end;{U2OscDraw}

 procedure spcDraw(panel:tpanel;canvas:tcanvas; const dataRecord:TdataRecord{y:Tvect}; wspx,wspy:double; centr:integer;
  const count:longWord; const xF0:word;const clear:boolean;const chartColor:longInt);
//---------------------oscylogram danych wave    var Yzero,wagi,xr,yi : rAryType;
var
    i : longWord;
    j : integer;
label e1;
  begin if not form1.CheckBox13.Checked then exit;//Show input graphics (poka grafik)
   panel.Visible:=clear;
   panel.Visible:=false;

   with panel do
    begin
     j:=centr; i:=0;
     if j<top then goto e1;
     if j>top+Height then goto e1;
     form1.Canvas.Pen.Color:=clwhite;//clred;
     form1.Canvas.moveTo(left,centr);                                           //--------------------ten kolor nie jest aktywowany!
     form1.Canvas.lineTo(left+width,centr);
e1:  form1.Canvas.moveTo(left,centr);
     form1.Canvas.Pen.Color:=chartColor;
    end;
   application.processMessages;
   with dataRecord, Panel do
    begin
     j:=round(-vect[0]*wspy+centr);
     if j<top then j:=top;
     if j>top+Height then j:=top+Height;
     canvas.MoveTo(panel.left,j);
     for i:=1 to count do
      begin
       control1:=i;//debug prp
       j:=round(-vect[i]*wspy+centr);
       if j<top then j:=top;
       if j>top+Height then j:=top+Height;
       canvas.LineTo(round(i*wspx+left),j);
       application.processMessages;                  //Uwaga! skasuje narysowany oscylogram, jeli wczeniej nie wywoano jeszcze processmessages
      end;
    end;{with}
    if form1.CheckBox32.Checked or (xF0<nc) then  VertLine(panel,clgreen,xF0,panel.top); //f0 mark line; round(rate/dataRecord.F0*wspx+panel.left) for cepstrum
  end;{spcDraw}

 procedure showSpcInputRecord(panel:Tpanel;const cath1,cath2,cath3,cath4:AnsiChar;const count:word;const yRange:word;stndrd:boolean; var xDescr:shortString);
  var count_cp,shift:word;
  (*
  TinPutRecord = record
                    IsliceNbr : longWord;
                 IstreamArray : array of TresArray; // = array of single;
   Iphon,Iperson,Igender,Iage : char;
                          IF0 : single;
                     end;{record}

  TdataRecord = record
                   vect : Tvect;
cath1,cath2,cath3,cath4 : char;
                  end;
  *)
  //   frame(Panel:TPanel;canvas:tcanvas;const xStretch:longWord; const stretch:double; var wspx,wspy:double; var centr:integer; centrDraw:boolean);
  //U2OscDraw(panel:tpanel;canvas:tcanvas; const y:Tvect;wspx,wspy:double; centr:integer;const count:longWord; const clear:boolean;const chartColor:longInt; const cath1,cath2,cath3,cath4:char);
  //spcDraw(panel:tpanel;canvas:tcanvas; const dataRecord:TdataRecord; wspx,wspy:double; centr:integer;const count:longWord; const xF0:word;const clear:boolean;const chartColor:longInt);
  //VertTicker(panel:Tpanel;canvas:Tcanvas;const stretch:double;const wspy:double; const centr:word; const sgn:shortInt);
  Begin    //===========================================showSpcInputRecord======================================
   with form1,inputRecord,dataRecord do
    begin
     count_cp:=count div 2;
     label31.Caption:=cathShow(cath1); label32.Caption:=cathShow(cath2); label33.Caption:=cathShow(cath3); label148.Caption:=cathShow(cath4);
     case StreamsNbrs[StreamIdx] of //in the case statement we call  streams ID, these are however specified in the StreamsNbrs array
      0: begin     //wave
          xDescr:='Time points';
          Frame(panel,canvas,count-1,yRange*2,wspx2,wspy2,centr2,true,xDescr);
          xF0T0:=round(rate/dataRecord.F0*wspx2+panel.left);
          U2OscDraw(panel,canvas,dataRecord.vect,wspx2,wspy2,centr2,count,xF0T0,false,drawingsArr[StreamIdx].chartColor,cath1,cath2,cath3,cath4);                     //waony oscylogram okienka
          vertTicker(panel,canvas,yRange*2,wspy2,centr2-panel.top,1,1);
          vertTicker(panel,canvas,yRange*2,wspy2,centr2-panel.top,-1,1);
         end;
      1,3..6,11:  //spectra
         begin
          xDescr:='FFT frequency points';
          if stndrd then shift:=0 else shift:=round(panel.Height/4.4);
          Frame(panel,canvas,count_cp,yRange,wspx2,wspy2,centr2,false,xDescr);
          xF0T0:=round(wspx2*F0*(count_cp-1)*2/rate)+panel.left;
          SpcDraw(panel,canvas,dataRecord,wspx2,wspy2,centr2+shift,count_cp,xF0T0,false,drawingsArr[StreamIdx].chartColor);       //wykres spektrum; centr+round(panel3.Height/1.75) - eksperymentalne obnienie wykresu dla neperw
          vertTicker(panel,canvas,yRange,wspy2,centr2+shift-panel.top,1,1);
          vertTicker(panel,canvas,yRange,wspy2,centr2+shift-panel.top,-1,1);
         end;
      7..10:      //cepstra
         begin
          if stndrd then shift:=0 else shift:=round(panel.Height/5.5);
          xDescr:='FFT time points';
          if form1.CheckBox32.Checked then      //full plot
            Frame(panel,canvas,count_cp,yRange,wspx2,wspy2,centr2,false,xDescr)
          else
            Frame(panel,canvas,nc,yRange,wspx2,wspy2,centr2,false,xDescr);
          xF0T0:=round(rate/dataRecord.F0*wspx2+panel.left);
          SpcDraw(panel,canvas,dataRecord,wspx2,wspy2,centr2+shift,nc,xF0T0,false,drawingsArr[StreamIdx].chartColor);                               //cepstrum mocy
          vertTicker(panel,canvas,yRange,wspy2,centr2+shift-panel.top,1,1);   //centr4+round(panel4.Height/5.5) in ordert to shift dow the plot for optimal drawing
          vertTicker(panel,canvas,yRange,wspy2,centr2+shift-panel.top,-1,1);
         end;
     end;{case}
    end;{with}
  End;{showSpcInputRecord}

 procedure showTxtInputRecord(panel:Tpanel;const cath1,cath2,cath3,cath4:AnsiChar;const txtStretch:smallInt;var xDescr:shortString);

  Begin
   //     frame(Pane:TPanel;canvas:tcanvas;const xStretch:longWord; const stretch:double;  out wspx,wspy:double; out centr:integer);
  // U2OscDraw(panel:tpanel;canvas:tcanvas; const y:Tvect;wspx,wspy:double; centr:integer;const count:longWord; const clear:boolean;const chartColor:longInt; const cath1,cath2,cath3,cath4:char);
  //VertTicker(panel:Tpanel;canvas:Tcanvas;const stretch:double;const wspy:double; const centr:word; const sgn:shortInt);
    with form1,dataRecord do
   begin
    xDescr:='Events features nbrs';
    Frame(Panel,canvas,nc,2*txtStretch,wspx2,wspy2,centr2,true,xDescr);
    U2OscDraw(panel,canvas,vect,wspx2,wspy2,centr2,nc+1,0,false,clblue,cath1,cath2,cath3,cath4);                                     //waony oscylogram okienka
    vertTicker(panel,canvas,txtStretch,wspy2,centr2-panel.top,1,1);
    vertTicker(panel,canvas,txtStretch,wspy2,centr2-panel.top,-1,1);
   end;
  End;{showTxtInputRecord}

 procedure meanInputDraw(panel:tpanel;canvas:tcanvas; const y:TmeanVector; wspx,wspy:double; centr:integer;
  const count:longWord; const clear:boolean;const chartColor:longInt);
//---------------------wykres strumienia urednionego
//Rni si od spcDraw typem y - jest double, co zapobiega koniecznoci zaokrglonego przeadowywania tablic
var
    i : longWord;
    j : integer;
label e1;
  begin if not form1.CheckBox13.Checked then exit;//poka grafik
   //panel.Visible:=clear;
   //panel.Visible:=false;
   with panel do
    begin
     j:=centr; i:=0;
     if j<top then goto e1;
     if j>top+Height then goto e1;
     form1.Canvas.Pen.Color:=clwhite;
     form1.Canvas.moveTo(left,centr);                                           //--------------------ten kolor nie jest aktywowany!
     form1.Canvas.lineTo(left+width,centr);
e1:  form1.Canvas.moveTo(left,centr);
     form1.Canvas.Pen.Color:=chartColor;
     application.processMessages;
     j:=round(-y[0]*wspy+centr);
     if j<top then j:=top;
     if j>top+Height then j:=top+Height;
     canvas.MoveTo(round(i*wspx+left),j);
     control1:=high(y);
     for i:=1 to count do
      begin
       control2:=i;
       j:=round(-y[i]*wspy+centr);
       if j<top then j:=top;
       if j>top+Height then j:=top+Height;
       canvas.LineTo(round(i*wspx+left),j);
       end;{with panel}
      application.processMessages;                  //Uwaga! skasuje narysowany oscylogram, jeli wczeniej nie wywoano jeszcze processmessages
    end;
  end;{meanInputDraw}

 procedure showModifiedSpcInput(panel:tpanel; const stndrd:boolean;const xDescr:shortString);
 //wywietla dane po odjciu redniej czasowej i redni czasow; check32 = "Wide cpstr"
  var count,shift:word; yRange:longint;
  Begin
   if stndrd then
    begin
     shift:=0;
     yRange:=5;
    end
    else
    begin
     shift:=round(panel.Height/5.5);
     yRange:=drawingsArr[StreamIdx].yRange;
    end;
   with form1 do
    begin
     label157.refresh;
     if StreamsNbrs[StreamIdx]=0 then count:=FFTwindowsWidth-1 else count:=FFTwindowsWidth div 2;
     if not checkBox32.Checked and  (StreamsNbrs[StreamIdx]<>0) then count:=nc;
     Frame(Panel,canvas,count,yRange,wspx4,wspy4,centr4,false,xDescr);                                    //krel poszerzone cepstrum
     vertTicker(panel,canvas,yRange,wspy4,centr4-panel4.top+shift,1,1);
     vertTicker(panel,canvas,yRange,wspy4,centr4-panel4.top+shift,-1,1);
     meanInputDraw(panel,canvas,meanVector,wspx4,wspy4,centr4+shift,count,false,form1.Label60.Color);    //redni czasowa
     spcDraw(panel,canvas,dataRecord,wspx4,wspy4,centr4+shift,count,xF0T0,false,form1.Label157.Color);   //cepstrum|spektrum po odjciu redniej czasowej //round(rate/dataRecord.F0*wspx4+panel4.left)
    end;
  End;{showModifiedSpcInput}

 procedure showModifiedTxtInput(panel:Tpanel;const stndrd:boolean;const xDescr:shortString);
 //wywietla dane po odjciu redniej czasowej i redni czasow
 //         frame(Pane:TPanel;canvas:tcanvas;const xStretch:longWord; const stretch:double;  out wspx,wspy:double; out centr:integer);
 //    U2OscDraw(panel:tpanel;canvas:tcanvas; const y:Tvect;wspx,wspy:double; centr:integer;const count:longWord; const clear:boolean;const chartColor:longInt; const cath1,cath2,cath3,cath4:char);
 //meanInputDraw(panel:tpanel;canvas:tcanvas; const y:TmeanVector; wspx,wspy:double; centr:integer;const count:longWord; const clear:boolean;const chartColor:longInt);
 //VertTicker(panel:Tpanel;canvas:Tcanvas;const stretch:double;const wspy:double; const centr:word;sgn:shortInt);
  var count:word; yStretch:double;
  Begin
   with form1 do
    begin      //frame(Pane:TPanel;canvas:tcanvas;const xStretch:longWord; const stretch:double;  out wspx,wspy:double; out centr:integer);
     if form1.CheckBox32.Checked then count:=vectorsSize else count:=nc;     //krel zawony wykres (narrowed data plot)
     if checkBox39.Checked then Ystretch:=2   //check39="Standardise events"
     else yStretch:=2*txtStretch;
     label157.refresh;
     Frame(Panel4,canvas,count,yStretch,wspx4,wspy4,centr4,false,xDescr);
     //centr7:=centr4+round(panel4.Height/5.5);  //plot shift
     vertTicker(panel4,canvas,yStretch,wspy4,centr4-panel4.top,1,1);
     vertTicker(panel4,canvas,yStretch,wspy4,centr4-panel4.top,-1,1);
     meanInputDraw(panel4,canvas,meanVector,wspx4,wspy4,centr4,count,false,form1.Label60.Color);   //redni czasow (time mean data plot)
     spcDraw(panel4,canvas,dataRecord,wspx4,wspy4,centr4,count,count,false,form1.Label157.Color);  //strumie po odjciu redniej czasowej (time centralized data plot)
    end;
  End;{showModifiedTxtInput}

 function VQT0annotate(panel:Tpanel;chartColor:longint;var zn1,zn2:AnsiChar):boolean;
 var
      tp:Tpoint;
  Begin
   result:=true;
   if (zn1<>zn2) then                 //opis fonematyczny maego oscylogramu
  with form1,panel do
    begin
     form1.Canvas.Pen.Color:=clyellow;
     tp:=canvas.penPos;
     canvas.TextOut(tp.X-8,top+2,zn2);
     canvas.MoveTo(tp.X-1,top+2);
     canvas.LineTo(tp.X,top+24);
     canvas.MoveTo(tp.X,tp.y);
     zn1:=zn2;
     form1.Canvas.Pen.Color:=chartColor;
    end {opis fonem.}
   else result:=false;
  End;{VQT0annotate}

procedure VQT0plot(const iw:dword;F0:single; zn2:AnsiChar;var T0plotStart:dword);
   var x,y : longint; Hstretch:word;      //Frame(form2.Panel1,form2.canvas,x1range,{y1range}1000*F0count/(2*rate),rDecimals,wspx1,wspy1,centr1,rHalf,rRev);
   Begin
    with form1.Panel7, form1.Canvas  do
      begin
       x:=round(iw *wspx7) mod width;  //(iw div paramRec.pJump) provided slice number in analogous procedure in the Spectrum program not necessary here, because iw here is slice number itself
       if x=0 then with form1.Panel7 do
        begin
         T0plotStart:=iw;
         zn1:=#0; Hstretch:=round(form1.panel7.width/5);                    //131218
         form1.Panel9.Left:=left+1;   //111218 added in order not to clear Y axis
         form1.canvas.moveTo(left+width,top);       //close back of the plot
         form1.Canvas.Pen.Color:=clWhite;
         form1.Canvas.LineTo(left+width,top+height);
         vertTicker(form1.panel7,form1.canvas,1000*F0count/(2*rate),wspy7,0,-1,-1);// division by 2, because T0 is evaluated on the basis of a distribution of maximums in cepstrum, and a cepstrum encloses in a range of indexes [0 ... fft_windows_width/2]
         HorizTic(form1.panel7,form1.canvas,Hstretch,wspx7,iw);
         application.ProcessMessages;          //bez tego linia zamykajjest kasowana!!!
        end;
       Pen.Color:=form1.label100.color;
       application.ProcessMessages;
       y:=round((1000/F0)*(wspy7)+top);
       form1.Panel9.Left:=x+left+5;  application.ProcessMessages;
       moveTo(x+1+left,y);
       lineTo(x+left+5,y); //draw horisontal mark 5 pts long
      end;
      with form1 do VQT0annotate(panel7,Canvas.Pen.Color,zn1,zn2);//T0 plot annotation
   End; {VQT0plot}

 procedure Repaint(const step:dword);

 procedure RePlot(Panel:TPanel;canvas:tcanvas; const wspX, wspy,topHeight:double; const lineColor:longInt; const rowsArr:TresultsDistr; const groupNbr:dword);
 //wykresy biecych wartoci IR lub error lub distortion
 //strech - zakres Y,  prevX,prevY - wsporzdne poprzeniego punktu (poprzednia warto step i IR)
  var X, Y:double;
         i:word;
  Begin
   with panel,canvas do
   begin
    Pen.Color:=lineColor;
    X:=left{+wspx};
    Y:=top+Height-rowsArr[0,0]*wspy;
    with canvas do
    moveTo(round(X),round(Y));
    for i:=1 to step do   //----------------------------plot table inside ---------------------------------
     begin
      X:=(i)*wspX+left;
      Y:=rowsArr[i,0]*wspy;
      Y:=topHeight-Y;  //             10.04.09
      canvas.lineTo(round(X),round(Y));
     end;{i}
   end;{with}
  End;{RePlot}

 var logos:boolean;
 begin
  if CentroidsNb_glob<step then begin ShowMessage('The "'+form1.Button3.Caption+'" can not be performed now,'#13#10'just after lowering the "'+form1.label5.caption+'" parameter.'); exit end;
  with form1 do
   if not checkbox1.Checked and (checkBox2.Checked or checkBox3.Checked or checkBox4.Checked or checkBox28.Checked) then
    Begin
     logos:=form1.CheckBox10.Checked; form1.CheckBox10.Checked:=false;
     Frames(false,'Repaint');
     if checkBox2.Checked then RePlot(Panel2,canvas,  wspX2, wspy2,topHeight2,cl5,cath1DistortDistrRes,step)
     else
      if checkBox3.Checked then RePlot(Panel2,canvas,  wspX2, wspy2,topHeight2,cl5,cath2DistortDistrRes,step)
      else
       if checkBox4.Checked then RePlot(Panel2,canvas,  wspX2, wspy2,topHeight2,cl5,cath3DistortDistrRes,step)
       else
        if checkBox28.Checked then RePlot(Panel2,canvas,  wspX2, wspy2,topHeight2,cl5,cath4DistortDistrRes,step);


     if checkBox2.Checked then RePlot(Panel3,canvas,  wspX3, wspy3,topHeight3,cl1,cath1IRDistrRes,step);    //clblue
     if checkBox3.Checked then RePlot(Panel3,canvas,  wspX3, wspy3,topHeight3,cl2,cath2IRDistrRes,step);    //clred
     if checkBox4.Checked then RePlot(Panel3,canvas,  wspX3, wspy3,topHeight3,cl3,cath3IRDistrRes,step);    //clgreen
     if checkBox28.Checked then RePlot(Panel3,canvas, wspX3, wspy3,topHeight3,cl4,cath4IRDistrRes,step);    //clyellow

     if checkBox2.Checked then RePlot(Panel4,canvas,  wspX4, wspy4,topHeight4,cl1,cath1RecErrDistrRes,step);  //clblue
     if checkBox3.Checked then RePlot(Panel4,canvas,  wspX4, wspy4,topHeight4,cl2,cath2RecErrDistrRes,step);  //clred
     if checkBox4.Checked then RePlot(Panel4,canvas,  wspX4, wspy4,topHeight4,cl3,cath3RecErrDistrRes,step);  //clgreen
     if checkBox28.Checked then RePlot(Panel4,canvas, wspX4, wspy4,topHeight4,cl4,cath4RecErrDistrRes,step);  //clyellow
     form1.CheckBox10.Checked:=logos;
    End  {with form1}
   else
    showMessage('No plot repaint possible when no cathegorical classification is turned on'#13#10+
    'because the "'+button3.Caption+'" command works on the basis of distributions of quantisation parameters over cathegory values');
  showLeavesSetsCounts(true,'>Repaint');
 end;{Repaint}


Initialization
 IRdrawings :=IRdrawings_clipped;
end.



