﻿unit VQUnit;

interface
uses windows,math,dialogs,StdCtrls,messages,Forms,sysUtils,controls, ExtCtrls,megasets,classes,Graphics,visualization,dataProcessor;

 const
               rareEventNbr1 : integer=2;
               rareEventNbr2 : integer=2;
                 WaveFileDir : shortstring ='C:\APL\Waver\results\*.wav';
                 treeFileDir : shortString ='C:\apl\LVQ\Results\tree.vqt';                  //plik wynikowy - drzewo kwantujące
             prevTreeFileDir : shortString ='C:\apl\LVQ\Results\tree.vqt';
               reportFileDir : shortString ='C:\apl\LVQ\Results\report.txt';
     Table2CollectionFileDir : shortString ='C:\apl\LVQ\Results\Table2Collection.txt';
                  LVQinitDir : string      ='C:\apl\LVQ\LVQInit.txt';
             LVQinitFileLogo : shortString ='LVQ Init File';
                          nc : integer=15;                                                  //liczba uwzględnianych składowych wektorów cech zdarzeń
                    cath1Nbr : byte=40;
                    cath2Nbr : byte=45;
                    cath3Nbr : byte=3;
                    cath4Nbr : byte=4;
            reportFileOpened : boolean=false;
 Table2CollectiontFileOpened : boolean=false;
                    dataread : boolean=false;
               newPreprocess : boolean=false;
            PreprocessChange : boolean=false;
                   interrupt : boolean=false;
                 stopReading : boolean=false;
           BreakReadingPoint : integer=high(BreakReadingPoint)-1;
                 vectorsSize : word = 0;

 Type
         realtype = double;
            TVect = TsingleArr;
      TmeanVector = array of extended;         //wektor do przechowywania średniej 280719: [0.. vectorsSize]
         THistory = array of TmeanVector;      //historia-wektory o składowych podzielonych przez stałą uśredniania 270719: [0..400]
            THist = array of longWord;         //histograms type
           TdbArr = array of double;
           TlwArr = array of longWord;
        TcharList = array of AnsiChar;
      TdataRecord = record
                       vect : Tvect;
dCath1,dCath2,dCath3,dCath4 : AnsiChar;
                         F0 : single;
                    end; {TdataRecord}
          nameStr = String[7];
            TDist = function (const v1,v2:TmeanVector):extended;
            TcharByte = array[char] of byte;

   // T128DoubleArr = array[0..parametersSize] of double;
 var
                   CentroidsNb_glob : integer;
  heapTop,nodeHeapTop,wholeEventNbr,
          trueEventNbr,readEventNbr : longWord;
                             ramSum : int64;
                           initFile : text;
   reportFile, Table2CollectionFile : text;
                         temp,temp1 : variant;
                                ln2 : extended;
                          startTime : tDateTime;
                          treeSaved : boolean=false;
                            spc_txt : boolean=true;
                   breakingLeafSave : integer=0;
                          FrameStep : realType;
                        NbrOfFrames : integer;
                                rap : word=0;       //RAM allocation process
                             MinMax : array of record min, max:single end;//[0.. vectorsSize] 280719
                    ResponseChecker : function(const startNode:longWord):double;
                        xDescr_Glob : shortString;
                           wbl, sbl : TlwArr;         //lista robocza adresów (working border list), lista adresów posortowana wg przynależności zdarzeń do zbiorów (sorted border list)
        SetChoiceDivisionEvaluation,
   FeaturesChoiceDivisionEvaluation : procedure(n:longWord; const TempHist1,TempHist2,NodeHist:Thist;
                                                 const FeatureLevelNbr:byte;const Pb:TdbArr; out delta2:double;
                                                 const k1,k2:longWord; const lb0,hb0,hb1,lb2:longWord;
                                                 const nodeAddr:word; const RadioGroup:TradioGroup; const bl:TlwArr;callChain:string);
                      vi,meanVector : TmeanVector;                         //wektor do przechowywania średniej
                            History : THistory;                            //historia-wektory o składowych podzielonych przez stałą uśredniania (bufor pierścieniowy)
                         dataRecord : TdataRecord;
                             Y1Name : nameStr='cath1';                     //nazwy opisowe zmiennych klasyfikującyh (do wydruków)
                             Y2Name : nameStr='cath2 ';
                             Y3Name : nameStr='cath3';
                             Y4Name : nameStr='cath4';
                          classKind : char;
                       clasRegister : boolean=false;
           AveragingTime,multStdDev : single;
                cl1,cl2,cl3,cl4,cl5 : Tcolor;
                        perfCounter : byte=1;
                             tempus : variant;
                         onceShowed : boolean=false;
                        inputFormat : byte;
                 vectList,vectList0 : array of TVect;
                         eventcath1 : TcharList;             //lista przypisująca fonemy zdarzeniom; fonemy są zakodowane umownymi znakami
                         eventcath2 : TcharList;             //lista przypisująca osoby zdarzeniom; osoby są zakodowane umownymi znakami
                         eventcath3 : TcharList;             //lista przypisująca płeć osób zdarzeniom; fonemy są zakodowane umownymi znakami
                         eventcath4 : TcharList;             //lista przypisująca wiek osób zdarzeniom; fonemy są zakodowane umownymi znakami
                              F0Arr : array of single;
               FFTwindowsWidth,step : word;
                          extension : shortString;
                           control1 : variant; //debug prp
                           control2 : variant; //debug prp
                           control3 : variant;//debug prp
            controlArr1,controlArr2 : array of longint;
                          vectStDev : extended;
                                TIC : function (var v1,v2:TmeanVector; const lb,hb:longWord; const centroid:TmeanVector; const nodeAddr:word):boolean;
                  showModifiedInput : procedure(panel:tpanel;const stndrd:boolean;const xDescr:shortString);
                        singleClass : boolean=false;
cath1IrGlob,cath2IrGlob,cath3IrGlob,
    cath4IrGlob,tryDelta,distortion : double;
                               dist : TDist;
                      percNorm_glob : extended; //recognition error normalization
      cath1RecErrSum,cath2RecErrSum,
      cath3RecErrSum,cath4RecErrSum : longWord;

procedure DataPrepare1(callChain:string);
procedure dataPrepare2(callChain:shortString);
procedure DataReading(const xDescr:shortString;callChain:shortString);
procedure Perform(callChain:string);
function openDialog(dialog:TOpenDialog;var s:shortString;const fltIdx:byte; const tit:string;edit:Tedit;callChain:string):boolean;
function checkDistortion(const startNode:longWord):double;
function checkcath1IR(const startNode:longWord):double;
function checkcath2IR(const startNode:longWord):double;
function checkcath3IR(const startNode:longWord):double;
function checkcath4IR(const startNode:longWord):double;
function checkcath1Error(const startNode:longWord):double;
function checkcath2Error(const startNode:longWord):double;
function checkcath3Error(const startNode:longWord):double;
function checkcath4Error(const startNode:longWord):double;
procedure DivisionEvaluation_distortion(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte;
           const Pb:TdbArr; out delta2:double;const k1,k2:longWord; const lb0,hb0,hb1,lb2:longWord;const nodeAddr:word; const RadioGroup:TradioGroup;const bl:TlwArr;callChain:string);
procedure DivisionEvaluation_Err(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte;
           const Pb:TdbArr; out delta2:double;const k1,k2:longWord; const lb0,hb0,hb1,lb2:longWord;const nodeAddr:word; const RadioGroup:TradioGroup;const bl:TlwArr;callChain:string);
 procedure DivisionEvaluation_IR(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte;
                               const Pb:TdbArr; out delta2:double;const k1,k2:longWord; const lb0,hb0,hb1,lb2:longWord;
                               const nodeAddr:word; const RadioGroup:TradioGroup;const bl:TlwArr;callChain:string);
procedure inspectTreeSettings(radio:TradioGroup);
procedure OpenReportFile(callChain:shortString);
procedure showLeavesSetsCounts(graphRepeat:boolean;callChain:string);
function DelSpace(s:string):string;
procedure spcCath1SetAndListCreate(const sp:AnsiChar;var j:byte);
procedure spcCath2SetAndListCreate(const sp:AnsiChar;var k:byte);
procedure spcCath3SetAndListCreate(const sp:AnsiChar;var l:byte);
procedure spcCath4SetAndListCreate(const sp:AnsiChar;var m:byte);
procedure streamRadiodescr;
function checkIncludeTreshold(newVal:word):word;
procedure RAMresources(const centroidsNb:word;callChain:shortString);
function saveDialog(dialog:TSaveDialog;var s:shortString; fltIdx:byte;const tit:shortString):boolean;
Procedure Frames(check10:boolean;callChain:string);
type
 TnodeProps = record
               centroid,nodeStDev:TmeanVector;
               iterNbr:word;
               cardinal,lb,hb:longWord;          //liczebność zbioru, indeksy graniczne
               leafIdx,nodeStep:word;
               cath1Ir,cath2Ir,cath3Ir,cath4Ir:double;
               maxCath1,maxCath2,maxCath3,maxCath4:byte;
               cath1RecErr,cath2RecErr,cath3RecErr,cath4RecErr:longWord;
               meanDistance,fissionDistance:double;
               OptComponentNbr:word;       //CART optymalna składowa (jej numer) podziału
              end;{TnodeProps}
     Tnode = record
             son,brother:smallInt;
            end;

var
    nodeProps : array of TnodeProps;
 componentNbr : word;
     nodeHeap : array of Tnode;
     emptyHash,cath1Hash,cath2Hash,cath3Hash,cath4Hash : TcharByte;
     treeFile : textFile;
implementation

uses system.UITypes,LVQ_spr_Drawings,unit1,unit2,setEdit,ErrorsUnit,distributions;

type

         Tset = set of byte;
     TcharSet = set of AnsiChar;
     TWordArr = array of word;
    T2WordArr = array of array of Word;
         TSAC = array[0..3] of int64;

var                                                                   reportDate : shortString;
                                                                  featureUseHist : T2WordArr;      //histogram użycia cech w CART
                                                               featureUseCounter : TWordArr;       //licznik użyć cech w CART
                                 distMax,deltaIRGlob, setChoiceCritGlob,prevDist : double;
                                                  distMaxNodeAddr,excludeSetCard : LongWord;
                                                                     leafCardArr : array of longWord;
                                                                   emptyResponse : TcharList;             //pusta lista (bez przydziału RAM!) stosowana, gdy jest wybierana dystorsja, aby podnieść pewność kodu programu
                                                                     dirListFile : text;
                         cath1CodeList,cath2CodeList,cath3CodeList,cath4CodeList : TcharList;
                                        nodeNbr,leafNodeNbr,iterNbr,totalIterNbr : word;                      //całkowita liczba węzłów i liści w drzewie
                                                           k1,k2,hb1glob,lb2glob : longWord;
                                       cath1NodeHist,cath2NodeHist,cath3NodeHist,
                                           cath4NodeHist,NodeHist_glob,emptyHist : Thist;
                                                 cath1H0,cath2H0,cath3H0,cath4H0,                             //histogramy liczebności w węźle zerowym
                                                             tempHist1,tempHist2 : THist;                     //chwilowe histogramy liczebności dla pure CART
                                      emptyIndex,cath1Pb,cath2Pb,cath3Pb,cath4Pb : TdbArr;                    //prawdopodobieństwa empiryczne w węźle zerowym;  TdbArr = array of double;
                                                                       leafNodes : TlwArr;                    //skorowidz węzłów liści
                                            cath1Set, cath2Set,cath3Set,cath4Set,
                         Checkcath1Set,Checkcath2Set,Checkcath3Set,Checkcath4Set : TcharSet;
                                                excludeEventsMegaSet,leafNodeSet : TArrSet;                   //excludeEventsMegaSet zbiór zdarzeń rzadkich                                                                                         //drzewo kwantujące na dysk
                                                                    txtEventFile : textFile;
                                                          nodeFound,featureFound,
                                             allcath1,allcath2,allcath3,allcath4 : boolean;
              fissionCounter,cath1AllStep,cath2AllStep,cath3AllStep,cath4AllStep : word;
                             hashCounter1,hashCounter2,hashCounter3,hashCounter4,
                      bestFeature,featureSetCard,globComponentNbr,lifterTreshold : word;     //dla klasyfikacji eksperymentalnej 16.11.05; bestFeature - Pure CART, FeaturesInspectTree, bieg po liściach; zapamiętać najlepszą cechę w danym liściu
                                                                           v1,v2 : TmeanVector;
                                                                      secondPass : boolean;
                                                                     InspectTree : procedure(startNodeIndex:longWord;callChain:string;recurs:dword);
                                                     meanDistance1,meanDistance2 : extended;
                                             cath1ClusterCount,cath2ClusterCount,
                                             cath3ClusterCount,cath4ClusterCount : TWordArr;
                                                         leafCounter,nodeCounter : word;
                                 prevIRcath1,prevIRCath2,prevIRCath3,prevIRCath4,
                 NodePrevIRcath1,NodePrevIRcath2,NodePrevIRCath3,NodePrevIRCath4,
             NodePrevErrcath1,NodePrevErrCath2,NodePrevErrCath3,NodePrevErrCath4,
                             prevErrCath1,prevErrCath2,prevErrCath3,prevErrCath4,
                     NodePrevDistortion,prevDistortion,prevX,NodePrevX, NodeWspx,
                                                                 currX,nodeCurrX : double;
                                                                     singleCurve : boolean;
                                                                           alloc : char;
                                                                     sz,sk,stdev : array of double;
                                                           centroArr, bordersArr : array of TdbArr;
                                                                   centr1,centr2 : TmeanVector;//przeniesion z divideSet, w.905 i findBestDivision, w. 1290;  160919
                                             RowsToReportTableCaption,H0ToReport : procedure;
                                                                         inputer : procedure(const i:longword; var dataRecord:TdataRecord);
                                                                  DataParameters : procedure(var EventNbr:longWord;callChain:string);
                                                           setClassifiersNumbers : procedure (i,j,k,l:byte);
                                     cath1Count,cath2Count,cath3Count,cath4Count : byte;

 procedure zeroHistory(callChain:string);
   var i,j:word;
   Begin
    callChain:=callChain+'>zeroHistory';
    if extension='.spc' then
     begin
      if frameStep<=0 then
        frameStep:=strToInt(inputBox(form1.label99.Caption ,'You have forgotten to input "'+form1.label99.Caption+'". Input it now - integer number in ms','5'));; //label99=frame step [ms]
      if NbrOfFrames<=0 then
        NbrOfFrames:=strToInt(inputBox(form1.label97.Caption ,'You have forgotten to input "'+form1.label97.Caption+'". Input it now - an integer number>=0','10'));
      averagingTime:=nbrOfFrames*frameStep;
      form1.edit20.Text:=floatToStr(averagingTime);  form1.edit25.Text:=form1.edit20.Text;
      InitWrite(callChain);;
     end{extension='.spc'}
    else
     if NbrOfFrames<=0 then
      begin
       NbrOfFrames:=strToInt(inputBox(form1.label97.Caption ,'You have forgotten to input "'+form1.label97.Caption+'". Input it now - an integer number>=0','10'));
       averagingTime:=frameStep*NbrOfFrames;
       form1.edit21.Text:=intToStr(NbrOfFrames);  with form1 do  edit24.Text:=edit21.Text;
       InitWrite(callChain);
      end;{else, NbrOfFrames=0}
    setLength(history,NbrOfFrames,vectorsSize+1);
    setLength(meanVector,vectorsSize+1);
    for i:=0 to nc do if inMegaSet(i,featureMegaSet) then meanVector[i]:=0;
    control1:=high(history);
    if high(history)>0 then
     for i:= 0 to NbrOfFrames-1 do
      for j:=0 to nc do if inMegaSet(j,featureMegaSet) then
       history[i,j]:=0;
   End; {zeroHistory}

 procedure MemoryReservation(const EventNbr:longWord;callChain:string);
  Begin
   callChain:=callChain+'>MemoryReservation';
   if spc_txt then //kill RAM allocations from DataReader
    begin
     //setLength(singleInfo,0);                //local in proc. streamsNamesRetrieve
     //setLength(textInfo,0);                  //local in proc. streamsNamesRetrieve
    // setLength(drawingsArr,0);               //each time is used an one value drawingsArr[checkedStreamNbr].yRange in Unit2
    // setLength(StreamNamesArr,0);            //needed for stream radiogroups description (i.e. form1.radiogroup2 and 8
    // setLength(StreamsNbrs,0);
    // setLength(eventcath1,0);                //lists used for IR computing
    // setLength(eventcath2,0);
    // setLength(eventcath3,0);
    // setLength(eventcath4,0);
    // setLength(vectList,0,0);
     setlength(edits,0);                    //jest allokowane w formCreate "visualization"
     setLength(StreamPointerArr,0);         //jest allokowane w formCreate "visualization"
    end{if, kill RAM allocations}
    else
     begin
      setLength(vectList0,EventNbr+1,vectorsSize+1);
      setLength(vectList,EventNbr+1,vectorsSize+1);
      setLength(eventcath1,EventNbr+1);
      setLength(eventcath2,EventNbr+1);
      setLength(eventcath3,EventNbr+1);
      setLength(eventcath4,EventNbr+1);
     end;

    begin
     (*
      TmeanVector = array of extended;//wektor do przechowywania średniej 280719: [0.. vectorsSize]
         THistory = array of TmeanVector;      //historia-wektory o składowych podzielonych przez stałą uśredniania 270719: [0..400]
     *)
     setLength(minMax,vectorsSize+1);  //+1 deleted 241019
     //setLength(vectList,EventNbr+1,vectorsSize);   //exists!

     //setLength(eventcath1,EventNbr+1);             //exists!
     //setLength(eventcath2,EventNbr+1);             //exists!
      //setLength(eventcath3,EventNbr+1);            //exists!
      //setLength(eventcath4,EventNbr+1);            //exists!
     setLength(wbl,EventNbr);
     setLength(sbl,EventNbr);
     //setLength(cath1CodeList,cath1Nbr+2);          //exists!
     //setLength(cath2CodeList,cath2Nbr+1);          //exists!
     //setLength(cath3CodeList,cath3Nbr+1);          //exists
     //setLength(cath4CodeList,cath4Nbr+1);          //exists
    end;{with}
    if form1.checkBox30.Checked then  zeroHistory(callChain);   //RAM for averaging (pamięć dla uśredniania)
    if spc_txt {extractFileExt(inpFileDir)='.spc'} then
     if StreamsNbrs[StreamIdx]=0 then setLength(dataRecord.vect, FFTwindowsWidth)
     else setLength(dataRecord.vect, FFTwindowsWidth  div 2+1);
   End; {MemoryReservation}

 procedure spcCath1SetAndListCreate(const sp:AnsiChar;var j:byte);
  Begin
   if not (sp in cath1Set) then
    begin
     inc(j);
     if j>high(cath1CodeList) then with form1 do
      begin
       setLength(cath1CodeList,j+1+j div 5);
       if checkBox2.Checked then edit9.Text:=intToStr(j);
      end;
     cath1CodeList[j]:=sp;                 //dekoder znaków fonematycznych
     cath1Hash[sp]:=j;                 //koder znaków fonematycznych
     include(cath1Set,sp);
    end; {if}
  End;{spcCath1SetAndListCreate}

 procedure spcCath2SetAndListCreate(const sp:AnsiChar;var k:byte);

  Begin
   if not (sp in cath2Set) then
    begin
     inc(k);
     if k>high(cath2CodeList) then with form1 do
      begin
       setLength(cath2CodeList,k+1+k div 5);
      if checkBox3.Checked then edit10.Text:=intToStr(k);
      end;
     cath2CodeList[k]:=sp;           //dekoder osobników
     cath2Hash[sp]:=k;               //koder osobników
     include(cath2Set,sp);
    end;
  End;{spcCath2SetAndListCreate}

 procedure spcCath3SetAndListCreate(const sp:AnsiChar;var l:byte);
  Begin
   if not (sp in cath3Set) then
    begin
     inc(l);
     if l>high(cath3CodeList) then with form1 do
      begin
       setLength(cath3CodeList,l+1+l div 5);
       if checkBox4.Checked then edit11.Text:=intToStr(l);
      end;
     cath3CodeList[l]:=sp;           //dekoder kategorii gender
     cath3Hash[sp]:=l;               //koder kategorii gender
     include(cath3Set,sp);
    end;
   End;{spcCath3SetAndListCreate}

 procedure spcCath4SetAndListCreate(const sp:AnsiChar;var m:byte);
  Begin
   if not (sp in cath4Set) then
    begin
     inc(m);
     if m>high(cath4CodeList) then with form1 do
      begin
       setLength(cath4CodeList,m+1+m div 5);
       if checkBox28.Checked then edit38.Text:=intToStr(m);
      end;
     cath4CodeList[m]:=sp;           //dekoder kategorii age
     cath4Hash[sp]:=m;               //koder kategorii age
     include(cath4Set,sp);
    end;
   End;{spcCath4SetAndListCreate}

 function openDialog(dialog:TOpenDialog;var s:shortString;const fltIdx:byte; const tit:string;edit:Tedit;callChain:string):boolean;

   Begin {---------otwiera okno openDialog--------------}
    callChain:=callChain+'>openDialog';
    repeat
     application.ProcessMessages;
     with Dialog do
     begin
      Title:=tit;   FilterIndex:=fltIdx;
      initialDir:=s;  fileName:=s;
      result:=execute;
      if result then s:=fileName;
     end;
     if (not fileExists(s)) and result then  error0(callChain,s);
    until fileExists(s) or not result;
    Edit.Text:=s;
    Edit.Enabled:=false;
   End;{openDialog}

 function saveDialog(dialog:TSaveDialog;var s:shortString; fltIdx:byte;const tit:shortString):boolean;

 var decision:byte;

   Begin   {---------otwiera okno saveDialog--------------}
    decision:=mrYes;
    repeat
     application.ProcessMessages;
     with Dialog do
     begin
      Title:=tit;     FilterIndex:=fltIdx;
      initialDir:=s;  fileName:=s;
      if execute then s:=fileName
     end;
     if fileExists(s) then
      begin
       decision:=messageDlg('File:'#13#10'"'+s+'"'#13#10'exists. Overwrite it?',mtConfirmation,[mbYes,mbNo,MbCancel],0);
       result:=decision=mrYes;
      end
     else result:=true;
    until result or (decision=mrCancel);
   End;{saveDialog}

 procedure HistReset;
  var j:word;
  Begin
   with form1 do
    begin
     if checkbox2.Checked then for j:=0 to cath1Nbr do cath1NodeHist[j]:=0;
     if checkbox3.Checked then for j:=0 to cath2Nbr do cath2NodeHist[j]:=0;
     if checkbox4.Checked then for j:=0 to cath3Nbr do cath3NodeHist[j]:=0;
    if checkbox28.Checked then for j:=0 to cath4Nbr do cath4NodeHist[j]:=0;
    end;
  End;

function card(setVar:Tset):word;
//zlicza elementy zbioru
 var i:byte;
 begin
  result:=0;
  for i:=0 to 255 do if i in setVar then inc(result);
 end;

function EuclidDist(const v1,v2:TmeanVector):extended;
{
oblicz odległość pomiędzy dwoma punktami
}
 var i:word;
 begin
  result:=0;
  for i:=0 to nc do
   begin  if not inMegaSet(i,featureMegaSet) then continue;           //uwzględniaj cechy ze wskazanego zbioru
    temp1:=v1[i]-v2[i];
    result:=result+sqr(temp1);  //bezpośrednie obliczanie kwadratu różnicy dawało wynik <0!!
    if result <0 then error29(result,i);
   end;
  if result>=0 then result:=sqrt(result)
  else result:=0;
 end;{EuclidDist}


 procedure DivideSet(const n:longword; const lb0,hb0:longWord; var hb1,lb2:longWord; const v1,v2:TmeanVector;
  var centr1,centr2:TmeanVector; var meanDistance1,meanDistance2:extended; out k1,k2:longWord;callChain:string);
 {
 Podziel zbiór na 2 części wg odległości Euklidesa od centroidów
               v1, v2 - wektory, centroidy wejściowe
       centr1,centr2 - wektory,centroidy wyjściowe
   lb0,hb1, lb2,hb0 - podzbiory z podziału;   lb1=lb0, a hb2=hb0, więc nie potrzeba ich obliczać
            k1, k2 - moce podzbiorów j.w.
          lb0,hb0 - dzielony zbiór
excEventsSetCard - moc excludeEventsMegaSet
          alloc - switch to handle a case, when an event (vector) is equally spaced from actual centroids v1, v2
 }
 var
     i,k,excEventsSetCard : longWord;
                        m : word;
                     //vi : TmeanVector; przeniesiono do implementation 160919
sd1,sd2,dist1,dist2 : extended;

 procedure summer(const dist:extended; const evAddr:longWord; const firstSet:boolean; const vi:TmeanVector;
  var sd:extended; var currIdx,k:longWord; var centr:TmeanVector);

 //Oblicza: sumy odległości, sumy składowych (dla centroidu), tworzy zbiór i zlicza jego elementy
 //  currIdx - bieżący index roboczej listy adresów, tj. granica zbioru ( lb albo hb);
 //  first - pierwszy potomek z rozbicia
 //evAddr - adres klasyfikowanego zdarzenia
 //  wbl - lista robocza adresów (working addresse list)
 var m:word;
  Begin
    sd:=sd+dist;
    wbl[currIdx]:=evAddr;            //events addresse assigning
    try
    if firstSet then inc(currIdx)    //binary sorting
    else dec(currIdx);
    except
    with form1 do
    if (step=1) and form1.CheckBox16.Checked then
     error39('Procedure "Summer"; Error "Integer overflow" may be caused by wrong "first centroids" read from tree'#13#10'Uncheck the '
     +form1.CheckBox16.Caption+' and try again'#13#10'var firstSet='+intToStr(byte(firstSet))+'; currIdx='+intToStr(currIdx))
    else
    error39('Some unexpected error  "Integer overflow" in the procedure "Summer" occuread. Check whether the'#13#10#13#10'"'+ mainMenu1.Items[2].Caption+'\'+
     pageControl1.Pages[3].Caption+'\'+Label27.Caption+'"'#13#10#13#10'(var multStdDev) is not too small!'#13#10+
     #13#10'step='+intToStr(step)+#13#10'multStdDev='+floatToStr(multStdDev)+#13#10'firstSet='+intToStr(byte(firstSet))+#13#10'currIdx='+
     intToStr(currIdx)+#13#10);
    end;
    inc(k);       //count set elements
    for m:=0 to nc do if inMegaSet(m,featureMegaSet) then centr[m]:=centr[m]+vi[m];  //101019
  End;{summer}

 procedure means(const sd:extended; n:longWord; var centr:TmeanVector; out meanDist:extended;const call:byte; callChain:string);
 //oblicz centroid i średnią odległości
 //       n - liczba elementów w zbiorze
 //      sd - suma zwykła
  var i:word;
  Begin //-------------------means-------------------------------
   callChain:=callChain+'>means';
   if n=0 then
     n:=error11(callChain,step);
   for i:=0 to nc do if inMegaSet(i,featureMegaSet) then centr[i]:=centr[i]/n;
   meanDist:=sd/n;
  End;{means}

  Begin   //--------------------------DivideSet--------------------------------
   callChain:=callChain+'>DivideSet';
    k:=0; k1:=0; k2:=0; sd1:=0; sd2:=0; excEventsSetCard:=0;
    //setLength(vi,vectorsSize); //allokowano centralnie w RAMresources
    for i:=0 to vectorsSize do
     begin
      centr1[i]:=0;
      centr2[i]:=0;
      vi[i]:=0;
     end;
   i:=lb0;   lb2:=hb0;  hb1:=lb0;
   Repeat   //--------------------------------------------Podziel zbiór na 2 części wg odległości Euklidesa od centroidów
    inc(k);                                             //k - licznik elementów znalezionych w dzielonym zbiorze
    for m:=0 to nc do if inMegaSet(m,featureMegaSet) then vi[m]:=vectList[sbl[i],m];
    dist1:=dist(v1,vi);
    dist2:=dist(v2,vi);           //odległość centroid-wektor  (v1, v2, to centroidy! (wstępne))
    if dist1=dist2 then
      begin
       if alloc='b' then //b - brother
        begin
         summer(dist1,sbl[i],true,vi,sd1,hb1,k1,centr1);
         alloc:='s';      //s - son
        end
       else
        begin
         summer(dist2,sbl[i],false,vi,sd2,lb2,k2,centr2);
         alloc:='b';      //brother
        end;
     end {dist1=dist2}
    else
     if dist1<dist2 then
      begin
       summer(dist1,sbl[i],true,vi,sd1,hb1,k1,centr1);
       alloc:='s';        //son
      end
     else
      begin
       summer(dist2,sbl[i],false,vi,sd2,lb2,k2,centr2);
       alloc:='b';        //brother
      end;
    inc(i);
   Until (k>=n) or (i>=TrueEventNbr) or (i>=hb0+1);         //biegaj dotąd, dokąd nie przejrzysz całego zbioru i nie zaklasyfikujesz jego elementów
   dec(hb1); inc(lb2);                                        //bo to są adresy dla następnych zapisów, których już nie będzie, bo podział się skończył
   if -lb0+hb1+1<> k1 then error56(k1,-lb0+hb1+1,'DivideSet',callChain);
   if -lb2+hb0+1<> k2 then error56(k2,-lb2+hb0+1,'DivideSet',callChain);
   if -hb1+lb2<>1 then error57(-hb1+lb2,'DivideSet',callChain);
   if (k<>n) or (k1+k2+excEventsSetCard<>n) then  error31(n,k,k1,k2,'DivideSet',callChain);
   means(sd1,k1,centr1,meanDistance1,1,callChain);
   means(sd2,k2,centr2,meanDistance2,2,callChain);
  End;{DivideSet}

 function IRadius(pk,pqkm:double):extended;
   var r1,r2,pPlusQ:extended;
  Begin  r1:=0; r2:=0; pPlusQ:=(pk+pqkm)/2;
   if pk>0 then r1:=pk*ln(pk/pPlusQ);
   if pqkm>0 then r2:=pqkm*ln(pqkm/pPlusQ);
   IRadius:=r1+r2;
  End;{IRadius}

 procedure CentroDistance(const lb,hb:longWord; const bl:TlwArr; var vi:TmeanVector; out sumDist:extended);
 {
 Centroid i sumę odległości wektorów od centroidu
 bl - border list - lista adresów zdarzeń należących do analizowanego zbioru
 }
  var i,j:longWord; m:word;  vt:TmeanVector;
  Begin
   setLength(vt,vectorsSize+1);
   sumDist:=0;  control1:=high(vi);
   for m:=0 to nc do if inMegaSet(m,featureMegaSet) then  vi[m]:=0;
   for i:=lb to hb do                                           //obliczyć wektor średnich
    for m:=0 to nc do if inMegaSet(m,featureMegaSet) then vi[m]:=vi[m]+vectList[bl[i],m];
   if hb>=lb then  j:=-lb+hb+1
   else begin error52('hb, lb', hb, lb); j:=1 end;;
   for m:=0 to nc do if inMegaSet(m,featureMegaSet) then if j>0 then vi[m]:=vi[m]/j else vi[m]:=0;//centroid
   for i:=lb to hb do                                           //obliczyć sumę odległości wektorów w zbiorze od centroidu
    begin
     for m:=0 to nc do if inMegaSet(m,featureMegaSet) then vt[m]:=vectList[bl[i],m];              //vt - wektor pomocniczy, aby uzgodnić typy wywołania funkcji dist
     sumDist:=sumDist+dist(vi,vt);
    end;{for i}
   setLength(vt,0);
  End;{CentroDistance}

  function NodeTrialIRProcessing(const n:longword; const nodeHist:Thist; const featureLevelNbr:byte; const Pb:TdbArr;callChain:string):extended;
  {
  Oblicza IR histogramu nodeHist względem histogramu tego samego wrażenia w całej próbie uczącej
  }
   var i:longWord;
    leafIr : extended;
  Begin  //----------------------NodeTrialIRProcessing-------------------
   callChain:=callChain+'>NodeTrialIRProcessing';
   leafIr:=0;
   for i:=0 to featureLevelNbr do  leafIr:=leafIr+IRadius(Pb[i],nodeHist[i]/n);                               //Pb, to histogram prawdopodobieństw wrażeń w całej próbie (zgodnych z Hash)
   result:=leafIR/ln2;
  End;{NodeTrialIRProcessing}

 procedure  Histograms(const n:longword; const lb,hb:longWord; const m:byte; var k1,k2 : longWord;
  var nodeHist:Thist; const Hash:TcharByte; const response:TcharList; const vim:Double; const featureLevelNbr:word;callChain:string);
 {
 lb,hb    - dzielony zbiór
 m        - numer składowej j.w.
 Hash     - lista klasyfikacji zdarzeń wg danego wrażenia (którego wrażenia? - zadanego właśnie listą wartości Hash!)
 response - klasyfikacja zdarzeń, jedna z: eventcath1, eventcath2, eventcath3, eventcath4. Czytane w "vectorAndCathListRead" równolegle z wektorami analiz spektralnych
 vi       - wektor średnich w danym zbiorze (ponieważ m= const, więc wystarczy tylko 1 składowa m, stąd vim)
 vim      - patrz wyżej
 }
 var i,k : longWord;
  Begin //================================= Histograms ===============================
  callChain:=callChain+'>Histograms';
  for i:=0 to featureLevelNbr do
   begin
    TempHist1[i]:=0; TempHist2[i]:=0; nodeHist[i]:=0;
   end;
   k1:=0; k2:=0; k:=0;
   Application.processMessages;               //show processed component nbr
   for i:=lb to hb do    //---------------------------------------------Podziel zbiór na 2 części wg najlepszej cechy
    begin
     inc(nodeHist[Hash[response[sbl[i]]]]);                     //histogram wrażenia uczącego w dzielonym zbiorze (patrz uwagi przy deklaracji)
     if vectList[sbl[i],m]<=vim then
      begin
       inc(TempHist1[Hash[response[sbl[i]]]]); inc(k1);
      end        //MUSI BYÆ WEKTOR ZBIORÓW I WEKTOR HISTOGRAMÓW!!! (gdyby for było wewnątrz repeat)
     else
      begin
       inc(TempHist2[Hash[response[sbl[i]]]]); inc(k2);
      end;
     inc(k);                                            //licznik zaklasyfikowanych elementów; k<=n
    end;{for}//Until (k>n) or (i>eventNbr);                          //biegaj dotąd, dokąd nie przejrzysz całego zbioru i nie zaklasyfikujesz jego elementów
   if (k<>n) or (k1+k2<>n) then  error31(n,k,k1,k2,'Histograms',callChain);
  End;{Histograms}

 procedure CARTsetDivider(const n:longword; const lb0,hb0:longWord; const m:word; var hb1,lb2: longWord; out k1,k2 : longWord;
  var nodeHist:Thist; const Hash:TcharByte; const response:TcharList; const vim:Double; const featureLevelNbr:byte;callChain:string);
 {
 Dzieli dany zbiór wektorów lb0,hb0 na 2 części względem średniej pewnej składowej wektora cechy sterującej,
 i oblicza histogramy wrażenia w otrzymanym podziale.
     lb0, hb0  - dzielony zbiór, granice indeksów
    hb1, lb2  - wynik podziału, granice indeksów
          m  - numer składowej j.w.
      Hash  - lista klasyfikacji zdarzeń wg danego wrażenia (którego wrażenia? - zadanego właśnie listą wartości Hash!)
 response  - klasyfikacja zdarzeń, jedna z: eventcath1, eventcath2, eventcath3, eventcath4. Czytane w "vectorAndCathListRead" równolegle z wektorami analiz spektralnych
      vi  - wektor średnich w danym zbiorze (ponieważ m= const, więc wystarczy tylko info o 1 składowej wg wartości której podział jest wykonywany m, stąd vim)
    vim  - patrz wyżej
wbl,sbl -  lista robocza adresów (working border list), lista adresów posortowana wg przynależności zdarzeń do zbiorów (sorted border list)
if form1.radiogroup27.ItemIndex=1 - histogramy robione są tylko w trybie wyboru cechy w trybie "supervised" (nie w "distortion")
 }
 var i,k : longWord;
  Begin //===================================CARTsetDivider===================================
   callChain:=callChain+'>CARTsetDivider';
   control1:=high(TempHist1); control2:=high( TempHist2); control3:=high(NodeHist);  //debug prp
   if form1.radiogroup27.ItemIndex=1 then
    for i:=0 to featureLevelNbr do
     begin
      TempHist1[i]:=0; TempHist2[i]:=0;  NodeHist[i]:=0
     end;
   i:=lb0; lb2:=hb0; hb1:=lb0; k1:=0; k2:=0; k:=0;
   Application.processMessages;               //show processed component nbr
   try
    Repeat   //---------------------------------------------Podziel zbiór na 2 części wg najlepszej cechy
     if form1.radiogroup27.ItemIndex=1 then inc(nodeHist[Hash[response[sbl[i]]]]);  //Training=supervised; histogram wrażenia uczącego w dzielonym zbiorze (patrz uwagi przy deklaracji)
     if vectList[sbl[i],m]<=vim then
      begin
       wbl[hb1]:=sbl[i]; inc(hb1);
       if form1.radiogroup27.ItemIndex=1 then inc(TempHist1[Hash[response[sbl[i]]]]);
       inc(k1)
      end        //MUSI BYÆ WEKTOR ZBIORÓW I WEKTOR HISTOGRAMÓW!!! (gdyby for było wewnątrz repeat)
     else
      begin
       wbl[lb2]:=sbl[i]; dec(lb2);
       if form1.radiogroup27.ItemIndex=1 then inc(TempHist2[Hash[response[sbl[i]]]]);
       inc(k2)
      end;
     inc(k);                                            //licznik zaklasyfikowanych elementów; k<=n
     inc(i);
    Until (k>=n) or (i>=trueEventNbr) or (i>hb0);                          //biegaj dotąd, dokąd nie przejrzysz całego zbioru i nie zaklasyfikujesz jego elementów
    dec(hb1); inc(lb2);
   except
     error39('CARTsetDivider proc.; Error "Integer overflow" may be caused by program error, e.g.  relation vectList[sbl[i],m]=<vim should be checked; turn to the author');
   end;
   if -lb0+hb1+1<> k1 then error56(k1,-lb0+hb1+1,'CARTsetDivider',callChain);
   if -lb2+hb0+1<> k2 then error56(k2,-lb2+hb0+1,'CARTsetDivider',callChain);
   if -hb1+lb2<>1 then error57(-hb1+lb2,'CARTsetDivider',callChain);
   if (k<>n) or (k1+k2<>n) then  error31(n,k,k1,k2,'CARTsetDivider',callChain);
  End;{CARTsetDivider}

 procedure DivisionEvaluation_IR(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte;
                               const Pb:TdbArr; out delta2:double;const k1,k2:longWord; const lb0,hb0,hb1,lb2:longWord;
                               const nodeAddr:word; const RadioGroup:TradioGroup;const bl:TlwArr;callChain:string);
 {
 const k1,k2:longWord;  const RadioGroup:TradioGroup potrzebne tylko do zgodności z pozostałymi wersjami
 wrażenie jest determinowane w FeaturesInspectTree poprzez alternatywne wywołanie  FeaturesTreeInspector, np.
 dla fonemów będzie to FeaturesTreeInspector(0,0, cath1Nbr,cath1Hash,eventcath1,cath1Pb,'0');
 Wybór wrażenia tutaj jest reprezentowany przez TempHist1 i TempHist2 oraz NodeHist.
 }

  var d1,d2,d0 : extended;
  begin
   callChain:=callChain+'>DivisionEvaluation_IR';
   //Ocena podziału wg przyrostu IR - im większy, tym lepszy
   //NodeTrialIRProcessing(const n:longword; const nodeHist:Thist; const featureLevelNbr:byte; const Pb:TdbArr)
   d1:=NodeTrialIRProcessing(n,TempHist1,featureLevelNbr,Pb,callChain);  //składniki dla debugingu
   d2:=NodeTrialIRProcessing(n,TempHist2,featureLevelNbr,Pb,callChain);
    case RadioGroup.ItemIndex  of            //03.01.2011
    0: d0:=nodeprops[nodeAddr].cath1IR;
    1: d0:=nodeprops[nodeAddr].cath2IR;
    2: d0:=nodeprops[nodeAddr].cath3IR;
    3: d0:=nodeprops[nodeAddr].cath4IR;
   end;{case}
   delta2:=d1+d2-d0;                                           // przyrost IR wskutek rozszczepu
  end;{DivisionEvaluation_IR}

 procedure DivisionEvaluation_Err(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte;
                               const Pb:TdbArr; out delta2:double;const k1,k2:longWord; const lb0,hb0,hb1,lb2:longWord;
                               const nodeAddr:word; const RadioGroup:TradioGroup;const bl:TlwArr;callChain:string);
 {
 Ocena podziału wg błędu rozpoznania - im spadek większy, tym lepszy
 const k1,k2:longWord dla zgodności z wersją '_dist"
 wrażenie jest determinowane w FeaturesInspectTree poprzez alternatywne wywołanie  FeaturesTreeInspector, np.
 dla fonemów będzie to FeaturesTreeInspector(0,0, cath1Nbr,cath1Hash,eventcath1,cath1Pb,'0');
 Wybór wrażenia tutaj jest reprezentowany przez TempHist1 i TempHist2 oraz NodeHist.
}
  var d1,d2,d0 : extended;
      maxPerc1,maxPerc2 : byte;

  procedure PercProcessing(const k:longWord;const NodeHist:THist;const levelNbr:byte; out maxPerc:byte);
  {
  znajdź położenie maximum w danym histogr NodeHist w porównaniu z histogramem w próbie uczącej pb
  }
   var i,p1,p2:longWord;
  Begin  //----------------------PercProcessing-------------------
   p1:=0;  maxPerc:=high(maxPerc);
   for i:=0 to levelNbr do                                            //cath1Pb, to histogram fonemów w całej próbie
    begin
     p2:=nodeHist[i];
     if p2>=p1 then
      begin maxPerc:=i; p1:=p2 end;
    end;
  End;{PercProcessing}

  begin     //----------------------------DivisionEvaluation_Err----------------
   callChain:=callChain+'>DivisionEvaluation_Err';
   PercProcessing(k1,TempHist1,FeatureLevelNbr,maxPerc1);
   PercProcessing(k2,TempHist2,FeatureLevelNbr,maxPerc2);
   case RadioGroup.ItemIndex  of
    0: d0:=nodeprops[nodeAddr].cath1RecErr;
    1: d0:=nodeprops[nodeAddr].cath2RecErr;
    2: d0:=nodeprops[nodeAddr].cath3RecErr;
    3: d0:=nodeprops[nodeAddr].cath4RecErr;
   end;{case}
   d1:=-TempHist1[maxPerc1]+k1;
   d2:=-TempHist2[maxPerc2]+k2;
   delta2:=-(d1+d2-d0);                                           // spadek błędu rozpoznania wskutek rozszczepu
   if form1.RadioGroup12.ItemIndex<>0 then                      //dowarunkowanie 18.10, bo występowały wartości ujemne w trybie CART
  end;{DivisionEvaluation_Err}

 //        DivisionEvaluation_IR(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte; const Pb:TdbArr; out delta2:extended);
 //        DivisionEvaluation_Err(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte; const Pb:TdbArr; out delta2:extended;const k1,k2:longWord);

 procedure DivisionEvaluation_distortion(n:longWord; const TempHist1,TempHist2,NodeHist:Thist; const FeatureLevelNbr:byte;
                               const Pb:TdbArr; out delta2:double;const k1,k2:longWord; const lb0,hb0,hb1,lb2:longWord;const nodeAddr:word; const RadioGroup:TradioGroup;const bl:TlwArr;callChain:string);
 {
 n- liczebności zbiorów,
 const k1,k2:longWord; const nodeAddr:word; ; const RadioGroup:TradioGroup            dla zgodności z wersją "_err"
 lb1=lb0; hb2=hb0
 }
  var d0,d1,d2 : extended;       //składniki dla debugingu
            vt : TmeanVector;  //centroid
            n1,n2:longWord;
  begin
   //Ocena podziału wg spadku błędu odwzorowania: obliczyć centroidy nowych zbiorow, sumę odległości od centrów, sumę odległości węzła rozszczepianego
   //procedure CentroDistance(const lb,hb:longWord; const bl:TlwArr; var vi:TmeanVector; out sumDist:extended);
   callChain:=callChain+'>DivisionEvaluation_distortion';
   setLength(vt,vectorsSize+1);
   n:=nodeprops[nodeAddr].cardinal;
   d0:=n*nodeprops[nodeAddr].meanDistance;
   CentroDistance(lb0,hb1,bl,vt,d1);
   if hb1>=lb0 then n1:=hb1-lb0+1
   else begin error52('hb1, lb0', hb1, lb0); n1:=1 end;
   CentroDistance(lb2,hb0,bl,vt,d2);
   if hb0>=lb2 then n2:=hb0-lb2+1
   else begin error52('hb0, lb2', hb0, lb2); n2:=1 end;
   with form1.radiogroup4 do                   // spadek dystorsji wskutek rozszczepu
   if itemIndex=1 then delta2:=-(d1+d2)+d0    //dystorsja=suma odległośi
   else delta2:=-(d1/n1+d2/n2)+d0/n;          //dystorsja=średnia odległość
   setLength(vt,0);
  end;{DivisionEvaluation_distortion}


 procedure FindBestFeature(const startNodeIndex,n:longword; const lb0,hb0:longWord; const featureLevelNbr:word;
    const Hash:TcharByte; const response:TcharList; const Pb:TdbArr; out componentNbr:word; out deltaIR:double;callChain:string);
 {
 Ma znaleźć najlepszy liść do kolejnego podziału i najlepszą cechę, wg której zbiór ma być podzielony
 Podziel zbiór na 2 części wg  cechy najsilniej wyjaśniającej klasyfikację cath1
         k1, k2 - liczebności zbiorów
        lb0,hb0 - dzielony zbiór
              n - liczebność rozszczepianego zbioru
         k1, k2 - liczebności zbiorów z rozbicia
             nc - liczba uwzglednionych składników wektora cech
featureLevelNbr - liczba poziomów wrażenia (np. ile różnych fonemów znaleziono w analizowanym sygnale)
           Hash - lista klasyfikacji zdarzeń wg danego wrażenia (którego wrażenia? - zadanego właśnie listą wartości Hash!)
       NodeHist - histogram wrażenia w węźle przodka,  wrażenia - tego samego, co zadanego listą wartości Hash!,
                  czyli cath1NodeHist[nodeNbr] lub cath2NodeHist[nodeNbr] lub cath3NodeHist[nodeNbr] lub cath4NodeHist[nodeNbr]
                  należy zadbać o zgodność Hash i NodeHist w wywołaniu...); odpowiednia wartość jest przypisywana instr. case radiogroup.itemIndex w RUN
             Pb - cath1Pb lub cath2Pb lub cath3Pb lub cath4Pb            //prawdopodobieństwa empiryczne w węźle zerowym
   componentNbr - numer komponentu wektora cech najlepiej klasyfikującego dany zbiór
        deltaIR - przyrost IR wskutek rozszczepienia wg componentNbr
 }
 var
    k1,k2 : longWord;
        m : word;
   delta2 : double;

  Begin   //============================== FindBestFeature ================================
   callChain:=callChain+'>FindBestFeature';
   delta2:=0;  featureFound:=false;
   for m:=0 to nc do                                               //szukaj najlepszej cechy i wykonuj histogramy zbiorów z podziału
    Begin
     if not inMegaSet(m,featureMegaSet) then continue;                     //uwzględniaj cechy ze wskazanego zbioru
     CARTsetDivider(n,lb0,hb0,m,hb1glob,lb2glob,k1,k2,NodeHist_glob, Hash,response,nodeProps[startNodeIndex].centroid[m],featureLevelNbr,callChain);                                                                             //blokada 07.09.07
     if (k1=0) or (k2=0) then
      begin
       if step=1 then excludeFromMegaSet(m,featureMegaSet); //wyłączyć cechę o identycznych wartościach we wszystkich zdarzeniach
       continue //begin delta2:=0;{ componentNbr:=nc;vim:=vi[componentNbr] }end  // Gdy nie ma rozbicia zbioru, to przyjmujemy wartośc componentNbr:=nc.
      end      //Może to byc dowolna wartość z przedziału <0,nc>. 0 jednak nie bierzemy pod uwagę, bo na ogół gdy bierzemy składowe cepstralne pod uwagę,
     else     //to składową zerową pomija się. W takim przypadku w krańcowych sytuacjach, w których wszystkie wektory w zbiorze byłyby dokładnie równe,
     try     //wybrana byłaby wlasnie skladowa zerowa, a tak, to będzie to składowa nr nc.
     FeaturesChoiceDivisionEvaluation(n,TempHist1,TempHist2,NodeHist_glob,FeatureLevelNbr,Pb,delta2,k1,k2,lb0,hb0,hb1glob,lb2glob,startNodeIndex,form1.RadioGroup25,wbl,callChain)
     except
     error46('FeaturesChoiceDivisionEvaluation',form1.RadioGroup22)
     end;
      {else}
     if (delta2>deltaIR) and (k1>0) and (k2>0) then      //wybierz najlepszą składową wektora cech dla dzielonego zbioru
      begin
       componentNbr:=m; featureFound:=true;
       deltaIR:=delta2;
      end
    End;{for}                                            //oceń wynik podziału zbioru według zadanego kryterium
  End;{FindBestFeature}

  procedure ShowIterationProgress(const k1,k2,iterNbr0:longWord;const fatherID:word; const v1,v2:TmeanVector;const distance1,distance2:double;optComponentNbr0:word; const fix:shortString);
   { k1, k2 - liczebności zbiorów potomnych
     father - adres przetwarzanego węzłą
     v1, v2 - centroidy zbiorów potomnych
     distance1, distance2
form1.memo2.lines[0]:=equStr('Step',4)+equStr('Curr',7)  +equStr('Processed',10)+equStr('Node mean',12)  +equStr('Fission',12)+equStr('Sons',6)   +equStr('Son set',9)+equStr('Son mean',12)+equStr('Brot',6) +equStr('Brot set',10) +
equStr('Brot mean',12) +equStr('Opt',15);
form1.memo2.lines[1]:=equStr('nbr',4) +equStr('iterat',7)+equStr('leaf node',10)+equStr('distance',12)   +equStr('distance',12)+equStr('node',6)  +equStr('card',9)+equStr('distance',12)   +equStr('node',6) +equStr('card',10)      +
equStr('distance',12)  +equStr('Fission',9)  +equStr('comp',6);
   }
   var line : string;     i1, i2 : integer;  md1, md2: double;
   Begin
    with form1,nodeProps[fatherID] do if checkBox9.checked then //------------------------show iteration progress
     begin                                                     //wiersze dla okna memo1
      fissionDistance:=dist(nodeProps[abs(nodeHeap[fatherID].son)].centroid,nodeProps[nodeHeap[abs(nodeHeap[fatherID].son)].brother].centroid);
      fissionDistance:=dist(v1,v2);
      i1:=abs(nodeHeap[fatherID].son);                      //son addresse
      i2:=nodeHeap[abs(nodeHeap[fatherID].son)].brother;   //brother addresse

      md1:=nodeProps[abs(nodeHeap[fatherID].son)].meanDistance;                   // zamiast meanDistance1
      md2:=nodeProps[nodeHeap[abs(nodeHeap[fatherID].son)].brother].meanDistance;// zamiast meanDistance2

      line:=equStr(floatToStrF(step,ffFixed,5,0),4);
      line:=line+equStr(floatToStrF(iterNbr0,ffFixed,5,0),7);   //iterNbr 12042023
      line:=line+equStr(floatToStrF(fatherID,ffFixed,6,0),10);
      line:=line+equStr(floatToStrF(meanDistance,ffFixed,15,3),12);
      line:=line+equStr(floatToStrF(fissionDistance,ffFixed,15,3),12);       //this does not change as function of iterations!
      if fix[length(fix)]<>'D' then line:=line+equStr(floatToStrF(i1,ffFixed,5,0),6)
      else  line:=line+equStr('-',6);
      line:=line+equStr(floatToStrF(k1,ffFixed,20,0),9);                    // nodeProps[nodeHeap[fatherID].son].cardinal zamiast k1     09042023
      line:=line+equStr(floatToStrF(Distance1,ffFixed,15,3),12);                //md1=nodeProps[nodeHeap[fatherID].son].meanDistance zamiast meanDistance1
      if fix[length(fix)]<>'D' then line:=line+equStr(floatToStrF(i2,ffFixed,5,0),6)
      else line:=line+equStr('-',6);
      line:=line+equStr(FloatToStrF(k2,ffFixed,7,0),10);                  //nodeProps[nodeHeap[nodeHeap[fatherID].son].brother].cardinal  zamiast k2
      line:=line+equStr(floatToStrF(Distance2,ffFixed,15,3),12)+equStr(fix,9); //nodeProps[nodeHeap[nodeHeap[fatherID].son].brother].meanDistance,ffFixed,15,3) zamiast meanDistance2
      if radioGroup12.ItemIndex=0 then line:=line+equStr(intToStr(optComponentNbr0),6) else line:=line+equStr('-',6);
      if checkbox11.Checked then memo1.Lines.Add(line);
      memo2.Lines[2]:=line;                          //head line
      application.ProcessMessages;
     end;
   End;{ShowIterationProgress}

 procedure CARTbestDivision(const ComponentNbr:word; var v1,v2:TmeanVector; const distMaxNodeAddr:word; const lb0,hb0:longWord;
  out meanDistance1,meanDistance2:extended; out k1,k2:longWord; const step:word;var nodeHist:Thist;const fix:shortString;callChain:string);
  { Ostateczny, twardy podział zbioru
    Dzieli dany zbiór wektorów lb,hb na 2 części względem średniej pewnej składowej wektora cechy sterującej,
    i oblicza histogramy wrażenia w otrzymanym podziale.
    Podział był już wykonany  w "CARTsetDivider"; powt.  konieczne, bo z "CARTsetDivider" wychodzą histogramy dotyczące rozszczepu ostatniego liścia, a potrzebujemy dane dot. rozszczepu aktualnie optymalnego liścia.
    Mogłoby pomóc zapamiętywanie, ale wymagałoby to dodatkowych zasobów RAM (tablica [1..K] 3 histogramów: przodka i dwóch następników)
    k1, k2       - aktualne liczebności zbiorów  potomnych
    lb0,hb0      - dzielony zbiór
    v1,v2        - centra  w potomkach
    vim          - składowa centroidu w dzielonym zbiorze (znaleziona w poprzednim kroku, pocz~tkowo w proc. S0)
    n - liczebność dzielonego zbioru
    ComponentNbr - najlepszy składnik wektora cech (cepstrum); globalny, znaleziony w FindBestFeature                              ,cath1Nbr,cath1Has
   Uwaga.                                                                                                                           ,cath3Nbr,cath4Nbr
   Podziału dokonujemy wg wartości najlepszej dla tego podziału cechy, która z kolei mogła być wybrana na podstawie
   tego samego lub innego kryterium oceny dokonanego podziału.
  }
  var n:longWord; vim:double;//vi : T128DoubleArr;(*było Tvect;*)
  Begin
   callChain:=callChain+'>CARTbestDivision';
   iterNbr:=0;
   n:=nodeprops[distMaxNodeAddr].cardinal;
   vim:=nodeprops[distMaxNodeAddr].centroid[ComponentNbr];
   case form1.RadioGroup25.ItemIndex  of                                                   //kryteria   - impression for feature choice
   (*CARTsetDivider(n,lb0,hb0,m,hb1glob,lb2glob,k1,k2,nodeHist, Hash,response,nodeProps[startNodeIndex].centroid[m],featureLevelNbr);                                                                             //blokada 07.09.07*)
   -1: CARTsetDivider(n,lb0,hb0,ComponentNbr,hb1glob,lb2glob,k1,k2,emptyHist,emptyHash,emptyResponse,vim,255,callChain);      //distortion
    0: CARTsetDivider(n,lb0,hb0,ComponentNbr,hb1glob,lb2glob,k1,k2,nodeHist,cath1Hash,eventcath1,vim,cath1Nbr,callChain);   //cath1, IR or error
    1: CARTsetDivider(n,lb0,hb0,ComponentNbr,hb1glob,lb2glob,k1,k2,nodeHist,cath2Hash,eventcath2,vim,cath2Nbr,callChain);  //cath2, IR or error
    2: CARTsetDivider(n,lb0,hb0,ComponentNbr,hb1glob,lb2glob,k1,k2,nodeHist,cath3Hash,eventcath3,vim,cath3Nbr,callChain); //cath3, IR or error
    3: CARTsetDivider(n,lb0,hb0,ComponentNbr,hb1glob,lb2glob,k1,k2,nodeHist,cath4Hash,eventcath4,vim,cath4Nbr,callChain) //cath4, IR or error
   else showMessage('Invalid sensation number (='+intToStr(form1.RadioGroup24.ItemIndex)+'), program error, procedure "CARTbestDivision"');
   end;{case}
  if (n<>k1+k2) or (k1=0) or (k2=0) then error27(n,k1,k2,'CARTbestDivision');
//procedure CentroDistance(const lb,hb:longWord; const bl:TlwArr; var vi:TmeanVector; out sumDist:extended);
   for n:=lb0 to hb0 do sbl[n]:=wbl[n];// przeładować adresy
   CentroDistance(lb0,hb1glob,sbl,v1,meanDistance1);
   if k1>0 then meanDistance1:=meanDistance1/k1 else meanDistance1:=0;          //obliczyć centroidy zbiorów
   if -lb0+hb1glob+1<>k1 then error39('Proc. "CARTbestDivision"; Program error!, set should contain '+intToStr(k1)+' but it turned out, that it contains '+intToStr(-lb0+hb1glob+1)+' components!');
   CentroDistance(lb2Glob,hb0,sbl,v2,meanDistance2);
   if k2>0 then meanDistance2:=meanDistance2/k2 else meanDistance2:=0;
   if -lb2Glob+hb0+1<>k2 then error39('Proc. "CARTbestDivision"; Program error!, set should contain '+intToStr(k2)+
   ' but it turned out, that it contains '+intToStr(-lb2Glob+hb0+1)+' components!');
   ShowIterationProgress(k1,k2,iterNbr,distMaxNodeAddr,v1,v2,meanDistance1,meanDistance2,ComponentNbr,'trialCD');
  End;{CARTbestDivision}

 procedure FindBestDivision(const nodeAddr:word; var v1,v2:TmeanVector; var lb,hb:longWord;
  out meanDistance1,meanDistance2:extended; out iterNbr:word; var hb1,lb2:longWord; out k1,k2:longWord;const step:word;callChain:string);
  var
   n:longWord;  break:boolean; i:word; //centr1,centr2 : TmeanVector; przeniesiono do implementacji
  Begin
   callChain:=callChain+'>FindBestDivision';
   //setLength(centr1,vectorsSize+1); setLength(centr2,vectorsSize+1); alokowano w RAMresources 160919
   iterNbr:=0;
   n:=nodeprops[NodeAddr].cardinal;
   Repeat
    inc(iterNbr);                                                                           //v1,v2 - centra, dane wejściowe i wyjściowe
    DivideSet(n,lb,hb,hb1,lb2,v1,v2,centr1,centr2,meanDistance1,meanDistance2,k1,k2,callChain);    //Podziel zbiór na 2 części wg odległości Euklidesa od centroidów   pomijając zdarzenia ze zbioru excludeEventsMegaSet
    if form1.CheckBox42.Checked  then ShowIterationProgress(k1,k2,iterNbr,nodeAddr,v1,v2,meanDistance1,meanDistance2,ComponentNbr,'trialFD')
    else  ShowIterationProgress(k1,k2,iterNbr,nodeAddr,v1,v2,meanDistance1,meanDistance2,ComponentNbr,'- FD');//ShowIterationProgress(iterNbr,nodeAddr,'-');
    break:=(dist(v1,centr1)=0) and (dist(v2,centr2)=0);  //break iteration process when centroids does not change already
    if not break then
     for i:=0 to nc do if inMegaSet(i,featureMegaSet) then begin v1[i]:=centr1[i]; v2[i]:=centr2[i] end; //031019, bo podstawienie typu v1:=cent1 polega na przypisaniu adresu w pamięci, a w DivideSet centr musza byc zerowane, co pociaga zerowanie v1 i v2
   Until break;
   for n:=lb to hb do sbl[n]:=wbl[n];   //przeładować rozszczepiony odcinek (reload splitted  fragment)
   inc(totalIterNbr,iterNbr);
   form1.Label128.Caption:=intToStr(totalIterNbr);
  End;{FindBestDivision}

 procedure LeafSummer(startNodeIndex,father:longWord;callChain:string);
  {
   biegnij po drzewie w poszukiwaniu liści i sumuj wartości IR, błędu rozpoznania i błędu kwantyzacji brane z props; działa w pętli procedury RUN
  }
  var ds,NodePercNorm :double;
       i:byte;
   Begin  //-----------------------LeafSummer------------------
    callChain:=callChain+'>LeafSummer';
    if nodeHeap[startNodeIndex].son>0 then
      LeafSummer(nodeHeap[startNodeIndex].son,startNodeIndex,callChain)  //030320
    else
     begin
      inc(leafNodeNbr);                                                     //numer liścia zablokowano tutaj nadawanie
      (*nodeHeap[startNodeIndex].son:=-leafNodeNbr;*)                       //liściom wartości ujemnych, bo prze-
      leafNodes[leafNodeNbr]:=startNodeIndex;    //numeracja liści drzewa   //szkadzałoby to w funkcjonowaniu CART i chyba niepotrzebne, bo liście są
      with form1, nodeProps[startNodeIndex] do
       Begin
        if checkbox2.Checked then
         begin
          cath1IrGlob:=cath1IrGlob+cath1Ir;
          inc(cath1RecErrSum,cath1RecErr);                //sums of recognition error over actual tree leaves (sumy błędów rozpoznania)
          If form1.RadioGroup18.ItemIndex=1 then
           DistribSums(cath1Nbr,maxCath1,cath1RecErr,cath1IR,startNodeIndex,sumCath1RecErrDistr,
            Cath1NodesDistr,sumCath1IRdistr,cath1IRnodeDistrArr,sumCath1DistortDistr,
            cath1DistortLeafDistribArr,callChain);
         end;
        if checkbox3.Checked then
         begin
          cath2IrGlob:=cath2IrGlob+cath2Ir;
          inc(cath2RecErrSum,cath2RecErr);
          If form1.RadioGroup18.ItemIndex=1 then
           DistribSums(cath2Nbr,maxCath2,cath2RecErr,cath2IR,startNodeIndex,sumCath2RecErrDistr,    //14062021
            Cath2NodesDistr,sumCath2IRdistr,cath2IRnodeDistrArr,sumCath2DistortDistr,
            cath2DistortLeafDistribArr,callChain);
         end;
        if checkbox4.Checked then
         begin
          cath3IrGlob:=cath3IrGlob+cath3Ir;
          inc(cath3RecErrSum,cath3RecErr);
          If form1.RadioGroup18.ItemIndex=1 then
           DistribSums(cath3Nbr,maxcath3,cath3RecErr,cath3IR,startNodeIndex,sumcath3RecErrDistr,
            cath3NodesDistr,sumcath3IRdistr,cath3IRnodeDistrArr,sumcath3DistortDistr,
            cath3DistortLeafDistribArr,callChain);
         end;
        if checkbox28.Checked then
         begin
          cath4IrGlob:=cath4IrGlob+cath4Ir;
          inc(cath4RecErrSum,cath4RecErr);
          If form1.RadioGroup18.ItemIndex=1 then
           DistribSums(cath4Nbr,maxcath4,cath4RecErr,cath4IR,startNodeIndex,sumcath4RecErrDistr,
            cath4NodesDistr,sumcath4IRdistr,cath4IRnodeDistrArr,sumcath4DistortDistr,
            cath4DistortLeafDistribArr,callChain);
         end;
        ds:=cardinal*meanDistance;
        distortion:=distortion+ds;
       End;{with}
       nodePercNorm:=100/nodeProps[startNodeIndex].cardinal; ds:=ds/nodeProps[startNodeIndex].cardinal;

        if father=distMaxNodeAddr then   //020320
         Begin
          inc(nodeCounter);
          nodeCurrX:=form1.panel2.left+(nodeCounter)*nodeWspx;

         if form1.checkBox27.Checked then             //grafy parametrów liści w funkcji liczby podziałów  (========= !!! GDY OPCJA "NODES" JEST WŁĄCZONA !!! ========)
          begin
           IRdrawings(form1.Panel2,form1.canvas,CentroidsNb_glob,NodePrevX,nodeCurrX,NodePrevDistortion,ds,wspy2,topHeight2,clYellow);   //strech=prevDistortion:=nodeprops[0].meandistance,


           if form1.checkBox2.Checked then IRdrawings(form1.Panel3,form1.canvas,CentroidsNb_glob,NodePrevX,nodeCurrX,NodePrevIRcath1,nodeProps[startNodeIndex].cath1Ir,wspy3,topHeight3,clBlue);  //strech=IRStretch,
           if form1.checkBox3.Checked then IRdrawings(form1.Panel3,form1.canvas,CentroidsNb_glob,NodePrevX,nodeCurrX,NodePrevIRcath2,nodeProps[startNodeIndex].cath2Ir,wspy3,topHeight3,clred);   //strech=IRStretch,
           if form1.checkBox4.Checked then IRdrawings(form1.Panel3,form1.canvas,CentroidsNb_glob,NodePrevX,nodeCurrX,NodePrevIRcath3,nodeProps[startNodeIndex].cath3Ir,wspy3,topHeight3,clGreen); //strech=IRStretch,
           if form1.checkBox28.Checked then IRdrawings(form1.Panel3,form1.canvas,CentroidsNb_glob,NodePrevX,nodeCurrX,NodePrevIRcath4,nodeProps[startNodeIndex].cath4Ir,wspy3,topHeight3,clYellow);//strech=IRStretch,


           if form1.checkBox2.Checked then IRdrawings(form1.Panel4,form1.canvas,CentroidsNb_glob,NodePrevX,nodeCurrX,NodePrevErrcath1,NodePercNorm*nodeProps[startNodeIndex].cath1RecErr,wspy4,topHeight4,clBlue);   //strech=errStretch,
           if form1.checkBox3.Checked then IRdrawings(form1.Panel4,form1.canvas,CentroidsNb_glob,NodePrevX,nodeCurrX,NodePrevErrCath2,NodePercNorm*nodeProps[startNodeIndex].cath2RecErr,wspy4,topHeight4,clred);    //strech=errStretch,
           if form1.checkBox4.Checked then IRdrawings(form1.Panel4,form1.canvas,CentroidsNb_glob,NodePrevX,NodeCurrX,NodePrevErrCath3,NodePercNorm*nodeProps[startNodeIndex].cath3RecErr,wspy4,topHeight4,clGreen);  //strech=errStretch,
           if form1.checkBox28.Checked then IRdrawings(form1.Panel4,form1.canvas,CentroidsNb_glob,NodePrevX,NodeCurrX,NodePrevErrCath4,NodePercNorm*nodeProps[startNodeIndex].cath4RecErr,wspy4,topHeight4,clYellow);  //strech=errStretch,
          end  {if form1.checkBox27.Checked}
          else   //prevY; in order to catch a first prev Y after checking on the checkbox "Nodes"   090320
           begin
            NodePrevDistortion:=ds;

            NodePrevIRcath1:=nodeProps[startNodeIndex].cath1Ir;
            NodePrevIRcath2:=nodeProps[startNodeIndex].cath2Ir;
            NodePrevIRcath3:=nodeProps[startNodeIndex].cath3Ir;
            NodePrevIRcath4:=nodeProps[startNodeIndex].cath4Ir;

            NodePrevErrcath1:=NodePercNorm*nodeProps[startNodeIndex].cath1RecErr;
            NodePrevErrCath2:=NodePercNorm*nodeProps[startNodeIndex].cath2RecErr;
            NodePrevErrCath3:=NodePercNorm*nodeProps[startNodeIndex].cath3RecErr;
            NodePrevErrCath4:=NodePercNorm*nodeProps[startNodeIndex].cath4RecErr;
           end; {else if form1.checkBox27}
          NodePrevX:=nodeCurrX;
         End;{father=distMaxNodeAddr}
     end;{else}
    if nodeHeap[startNodeIndex].brother>0 then  LeafSummer(nodeHeap[startNodeIndex].brother,father,callChain) //father, 030320
   End;{LeafSummer}

 procedure errIRProcessing(const n:longWord; const nodeAddr:word; const NodeHist:THist;pbHist:TdbArr;
                            const NbrClass:byte; out IR:double; out max:byte; out error:longWord;
                            var checkSet:TcharSet; var all:boolean;const list:TcharList;const cl:longint;
                            var allStep:word; labelx:Tlabel; var cathIRnodeDistr: array of double;callChain:string);
{
compares leaf histograms with the 0-node histograms and computes IR and classification error in a node (oblicza IR i błąd klasyfikacji w węźle)
pbHist   - distribution  of cathegory values in the all sample                                        (rozkład wrażenia w całej próbie)
nodeHist - the distribution like above, but in a node                                                (j.w. w węźle)
NbrClass - number of cathegory values                                                               (liczba wartości (poziomów) zmiennej klasyfikującej)
calling: errIRProcessing(cardinal, nodeAddr, cath1NodeHist, cath1Pb, cath1Nbr, nodeprops[nodeAddr].cath1IR, nodeprops[nodeAddr].maxCath1, nodeprops[nodeAddr].cath1RecErr, checkcath1Set, allcath1, cath1CodeList, cl1,     cath1AllStep, form1.label138, cath1IRnodeDistrArr[Addr],callChain)
head:    errIRProcessing(n;        nodeAddr; NodeHist;      pbHist;  NbrClass; IR;                          max;                          error;                           checkSet;      all;      list;          cl;      allStep;      labelx;         cathIRnodeDistr;          callChain);
                        :longWord :word     :THist         :TdbArr  :byte     :double                      :byte                         :longWord                        :TcharSet      :boolean  :TcharList     :longint :word         :Tlabel         :array of double          :string
                         const     const     const                   const     out                          out                           out                              var            var       const          const     var                           var
}
   var      j,k,m : longWord;
       leafIr,p,z : extended;
    delta1,delta2 : double;
  Begin  //----------------------errIRProcessing-------------------
   callChain:=callChain+'>errIRProcessing';
   leafIr:=0;  delta1:=-5e324;  j:=high(j);
   for m:=0 to NbrClass do                         //cath1Pb, to histogram kategorii_1 (fonemów) w całej próbie
    begin
     k:=nodeHist[m]; p:=pbHist[m];
     delta2:=k;
     z:=IRadius(p,k/n);
     leafIr:=leafIr+z;                        //pk*ln(pk/pPlusQ)+pqkm*ln(pqkm/pPlusQ); n - liczebność zbioru
     cathIRnodeDistr[m]:=z;                  //22042021
     if delta2>=delta1 then begin j:=m; delta1:=delta2 end; //poszukać maksimum dla obliczenia błędu rozpoznania
    end;
   Ir:=leafIR/ln2;
   max:=j;
   Error:=n-nodeHist[j];
   if not all then                     //find if all cathegory values have its own representing set
    with form1 do
    begin
     exclude(checkSet,list[max]);
     if checkSet =[] then
      begin
       all:=true;
       VertLine(panel2,cl,step*wspx2+form1.panel2.left,panel2.top);
       VertLine(panel3,cl,step*wspx3+form1.panel3.left,panel3.top);
       VertLine(panel4,cl,step*wspx4+form1.panel4.left,panel4.top);
       allStep:=step;
       labelx.Caption:=equStr(intToStr(step),6);
      end;{if}
    end;{with}
  End;{errIRProcessing}

  procedure MakeHistograms(const nodeAddr:longWord);
  //oblicz histogramy wartości kategorialnych w węźle
  //Make Histograms of cahegories values in a node
   var i,n:longWord;
  Begin
   if form1.CheckBox1.Checked then exit;
   n:=0;
   with nodeProps[nodeAddr] do
   for i:=lb to hb do
      begin
       inc(n);
       if form1.CheckBox2.Checked then inc(cath1NodeHist[cath1Hash[eventcath1[sbl[i]]]]);
       if form1.CheckBox3.Checked then inc(cath2NodeHist[cath2Hash[eventcath2[sbl[i]]]]);
       if form1.CheckBox4.Checked then inc(cath3NodeHist[cath3Hash[eventcath3[sbl[i]]]]);
       if form1.CheckBox28.Checked then inc(cath4NodeHist[cath4Hash[eventcath4[sbl[i]]]]);
      end;
    with nodeProps[nodeAddr] do if n<> cardinal then  error50(n,cardinal,'MakeHistograms');
  End;{MakeHistograms}


 procedure TreeLeafSetProcess(const nodeAddr,IRDistrAddr:word;callChain:string);
  {
  computes and compares cathegories histograms in a node set with the histograms in the all teaching sample
  Oblicza histogramy kategorii w zbiorze i porównuje je z odpowiednimi histogramami całej próby
  }
  //var //addr : word;
  //temp1, temp2,temp3:extended; //debug prp
   Begin
   callChain:=callChain+'>TreeLeafSetProcess';
    if form1.CheckBox1.Checked then with nodeProps[nodeAddr] do begin cath1RecErr:=cardinal; cath2RecErr:=cardinal; cath3RecErr:=cardinal; cath4RecErr:=cardinal;exit end;
    HistReset;                 //set to 0 cath#NodeHist, # = 1, 2, 3, 4
    MakeHistograms(nodeAddr); //Make Histograms cath#NodeHist of cahegories values in a node
    with nodeProps[nodeAddr] do
    begin
     control1:=high(cath1IRnodeDistrArr);
     if nodeAddr>control1 then showMessage(callChain+' '+intToStr(nodeAddr)+'>'+intToStr(control1));
    // If form1.RadioGroup18.ItemIndex=1 then addr:=leafIdx else addr:=0;
      if form1.CheckBox2.Checked then errIRProcessing(cardinal,nodeAddr,cath1NodeHist,   cath1Pb,   cath1Nbr,
         nodeprops[nodeAddr].cath1IR,nodeprops[nodeAddr].maxCath1,nodeprops[nodeAddr].cath1RecErr,checkCath1Set,allcath1,cath1CodeList,cl1,cath1AllStep,form1.label138,cath1IRnodeDistrArr[IRDistrAddr],callChain)
      else cath1RecErr:=cardinal;    //compare leaf histograms with the 0-node histograms (porównaj histogramy liści z histogramem zerowym)
      if form1.CheckBox3.Checked then errIRProcessing(cardinal,nodeAddr,cath2NodeHist, cath2Pb, cath2Nbr,
         nodeprops[nodeAddr].cath2IR,nodeprops[nodeAddr].maxCath2, nodeprops[nodeAddr].cath2RecErr,checkCath2Set,allcath2,cath2CodeList,cl2,cath2AllStep,form1.label139,cath2IRnodeDistrArr[IRDistrAddr],callChain)
      else cath2RecErr:=cardinal;
      if form1.CheckBox4.Checked then errIRProcessing(cardinal,nodeAddr,cath3NodeHist,cath3Pb,cath3Nbr,
         nodeprops[nodeAddr].cath3IR, nodeprops[nodeAddr].maxCath3,nodeprops[nodeAddr].cath3RecErr,checkCath3Set,allcath3,cath3CodeList,cl3,cath3AllStep,form1.label140,cath3IRnodeDistrArr[IRDistrAddr],callChain)
      else cath3RecErr:=cardinal;
      if form1.CheckBox28.Checked then errIRProcessing(cardinal,nodeAddr,cath4NodeHist,cath4Pb,cath4Nbr,
         nodeprops[nodeAddr].cath4IR, nodeprops[nodeAddr].maxCath4,nodeprops[nodeAddr].cath4RecErr,checkCath4Set,allcath4,cath4CodeList,cl4,cath4AllStep,form1.label152,cath4IRnodeDistrArr[IRDistrAddr],callChain)
      else cath4RecErr:=cardinal;
     end;{with}
   End;{TreeLeafSetProcess}

 procedure NodesFix(const startNodeAddr:longWord;callChain:string);
   var i,  i1,i2, card1,card2:longword;  meanDistance1,meanDistance2:double;
  Begin  //------------------------------------------------NodesFix------------------------------
   callChain:=callChain+'>NodesFix';
   if nodeHeap[startNodeAddr].son>0 then error9(startNodeAddr,callChain);
   with nodeHeap[startNodeAddr] do
    begin
     son:=-son;                                           //adres następnika
     i:=son;
   //inc(fissionCounter);                                                                 //28.12.06 w CARTlike nie można powiększać licznika rozszczepień  09.09.21 blokada
    i1:=abs(nodeHeap[startNodeAddr].son);
    i2:=nodeHeap[abs(nodeHeap[startNodeAddr].son)].brother;
    meanDistance1:=nodeProps[i1].meanDistance;
    meanDistance2:=nodeProps[i2].meanDistance;

    card1:=nodeProps[i1].cardinal;       // zamiast k1 12042023
    card2:=nodeProps[i2].cardinal;      // zamiast k2
    //fissionDistance:=dist(nodeProps[abs(nodeHeap[fatherID].son)].centroid,nodeProps[nodeHeap[abs(nodeHeap[fatherID].son)].brother].centroid);
    if form1.RadioGroup12.ItemIndex =0 then
         ShowIterationProgress(card1,card2,nodeProps[startNodeAddr].iterNbr,startNodeAddr,nodeProps[i1].centroid,nodeProps[i2].centroid,
          nodeProps[i1].meanDistance, nodeProps[i2].meanDistance,nodeProps[startNodeAddr].OptComponentNbr,'fixed!NF'{,intToStr(nodeProps[startNodeAddr].OptComponentNbr)})
    else ShowIterationProgress(card1,card2,nodeProps[startNodeAddr].iterNbr,startNodeAddr,nodeProps[i1].centroid,nodeProps[i2].centroid,
          nodeProps[i1].meanDistance, nodeProps[i2].meanDistance,nodeProps[startNodeAddr].OptComponentNbr,'fixed!NF'{,'-'});
   end {with}
  End;{NodesFix}

 procedure treeConstructor(const startNodeAddr:longWord;var heapTop:longWord;const hb1,lb2:longWord;const centro1,centro2:TmeanVector;
  const meanDistance1,meanDistance2:double;const iterNbr:word; const k1,k2:longWord;const trial:boolean; const ComponentNbr:word;callChain:string);
 {
 konstruuje graf drzewiasty
 startNodeAddr - adres węzła od którego kontynuuje się rozbudowę grafu;
                 będzie ujemny, gdy następniki będą efektem rozszczepienia próbnego (CART)
 }
 var i:longWord; j:word;   fix:shortString;

  Begin  //------------------------------------------------treeConstructor------------------------------
   callChain:=callChain+'>treeConstructor';
   if nodeHeap[startNodeAddr].son>0 then error9(startNodeAddr,callChain);
   nodeProps[startNodeAddr].iterNbr:=iterNbr;
   nodeProps[startNodeAddr].fissionDistance:=dist(centro1,centro2);
   i:=heapTop+1; //son's addresse     //radiogroup12, pure CART, PRZODEK (!!) węzła otrzymuje nr optymalnej składowej wektora cech oraz średnią tej składowej w
   if form1.RadioGroup12.ItemIndex=0 then nodeProps[startNodeAddr].OptComponentNbr:=ComponentNbr;  //jego zbiorze (wciąż jest jeszcze liściem, więc jego zbiór jest jeszcze dostępny) przodek, bo właściwości tej nie posiadają jeszcze następniko, bo nie były jeszcze rozbijane!
   if trial then nodeHeap[startNodeAddr].son:=-i                              //radiogroup22, CART-like                           //adres następnika //było: form1.RadioGroup22.ItemIndex=3 {09.07.09}
   else nodeHeap[startNodeAddr].son:=i;                                       //ujemna wartość oznacza węzły rozszczepienia próbnego CART
   inc(heapTop,2); if heapTop>nodeHeapTop then error8;
   with NodeHeap[i] do   //sons's assignings                                  //węzeł następnika (sonCreate) ==============================
    begin
     brother:=heapTop;
     son:=0;                                                                  //w czystym CART zbiór jest przypisywany poprzednikowi...
     nodeProps[i].iterNbr:=iterNbr;
     with nodeProps[i] do
      begin
       for j:=0 to nc do if inMegaSet(j,featureMegaSet) then centroid[j]:=centro1[j]; //for was introduced at 081019
       cardinal:=k1;
       leafIdx:=nodeProps[startNodeAddr].leafIdx;                                     //09.11.05   numer liścia jest tu dziedziczony
       lb:=nodeProps[startNodeAddr].lb; hb:=hb1;
       meanDistance:=meanDistance1;
      end;{with}
    end;{with}
    TreeLeafSetProcess(i,i,callChain);       //28.12.06; w CARTlike distortion nie analizować rozkładów
   inc(fissionCounter);
   with NodeHeap[heapTop] do  //assignings   //węzeł alternatywy następnika  (brotherCreate) ==============================
    begin
     brother:=0;
     son:=0;                                 //w czystym CART zbiór jest przypisywany poprzednikowi...
     nodeProps[heapTop].iterNbr:=iterNbr;
     with nodeProps[heapTop] do
      begin
       for j:=0 to nc do if inMegaSet(j,featureMegaSet) then centroid[j]:=centro2[j]; //for was introduced at 081019
       cardinal:=k2;
       leafIdx:=fissionCounter;                                                       //09.11.05
       lb:=lb2; hb:=nodeProps[startNodeAddr].hb;
       meanDistance:=meanDistance2
      end;
    end;{with}
   TreeLeafSetProcess(heapTop,heapTop,callChain);  //28.12.06 w CARTlike distortion nie analizować rozkładów
   if nodeHeap[startNodeAddr].son<0 then fix:='trialTC' else if not form1.CheckBox42.Checked then fix :='fixedTC' else fix :='- TC';
   ShowIterationProgress(k1,k2,iterNbr,startNodeAddr,v1,v2,meanDistance1,meanDistance2,ComponentNbr,fix);
  End;{treeConstructor}

   procedure FeaturesTreeInspector(startNodeIndex:longWord; const featureLevelNbr1,featureLevelNbr2:word;
    var Hash1,Hash2 :TcharByte; var response1,response2:TcharList; var Pb1,Pb2:TdbArr;l94:char;CallChain:string);
  {
   Alternatywa do DistancesInspectTree, wywoływać z poziomu lookForBestSet (jako InspectTree)
   Biegnij po drzewie w poszukiwaniu liścia o największym przyroście IR (albo, w zależności od opcji- dystorsji
   albo błędu rozpoznania) wskutek podziału wg pewnej składowej wektora cech.
   Działa na etapie tworzenia drzewa kwantującego.
       rareEventNbr1   - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
       Hash:TcharByte  - lista  poziomów klasyfikacji zdarzeń wg danego wrażenia (skorowidz kodów numerowych);
                         jedna z: cath1Hash, cath2Hash, cath3Hash, cath4Hash
    response:TcharList - klasyfikacja zdarzeń, jedna z: eventcath1, eventcath2, eventcath3, eventcath4. Czytane w
                            "vectorAndCathListRead" równolegle z wektorami analiz spektralnych
Hash1, 2, response1, 2 - dane dotyczące odpowiednio: oceny wyboru cechy i oceny wyboru zbioru do kolejnego podziału
                    Pb - cath1Pb lub cath2Pb lub cath3Pb lub cath4Pb (prawdopodobieństwa empiryczne w węźle zerowym)
          componentNbr - numer komponentu wektora cech najlepiej klasyfikującego dany zbiór
           deltaIRglob - przyrost IR wskutek rozszczepienia wg componentNbr; zerować przed wywołaniem tej procedury!!!

   Hash służy do tworzenia histogramów, wskazuje numer słupka, który należy powiększać, np.:
         if form1.CheckBox2.Checked then inc(cath1NodeHist[cath1Hash[eventcath1[i]]]);
   (transformacja konieczna, bo histogram jest tablicą dynamiczną, a tam indeks jest liczbowy)
  }

   Begin  //-----------------------FeaturesTreeInspector------------------
    callChain:=callChain+'>FeaturesTreeInspector';
    if not clasRegister then begin classKind:=l94; clasRegister:=true end;
         {deltaIRglob:=0; - zerowanie musi być przed wywołaniem tej procedury!!}
    if nodeHeap[startNodeIndex].son>0 then
     FeaturesTreeInspector(nodeHeap[startNodeIndex].son,featureLevelNbr1,featureLevelNbr2,hash1,hash2,
                           response1,response2,Pb1,Pb2,'s',callChain)
    else  //------------------------------------a tree leaf was reached
     Begin
      inc(leafCounter);
      with nodeProps[startNodeIndex] do
      if ((cardinal>=rareEventNbr1) and (meanDistance>minDouble)) then
       Begin
        if nodeHeap[startNodeIndex].son<0 then  with form1,nodeHeap[startNodeIndex] do   //liść był już próbnie rozbity, są dane potomków (za wyjątkiem zbioru...)
         begin   //- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
          featureFound:=true;
          componentNbr:=nodeProps[startNodeIndex].OptComponentNbr;
          k1:=nodeProps[-son].cardinal;     //liczebności potomków
          k2:=nodeProps[nodeHeap[-son].brother].cardinal;
          meanDistance1:=nodeProps[-son].meanDistance;
          meanDistance2:=nodeProps[nodeHeap[-son].brother].meanDistance;
          hb1glob:=nodeProps[-son].hb;
          lb2glob:=nodeProps[nodeHeap[-son].brother].lb;
          deltaIRglob:=ResponseChecker(startNodeIndex);
         end {son<0}
        else            //son=0, the leaf was not divided yet on a trial basis (liść nie był jeszcze próbnie rozbity)
         Begin
          if inMegaSet(startNodeIndex,leafNodeSet) then error34(callChain,startNodeIndex,step);
          FindBestFeature(startNodeIndex,cardinal, nodeProps[startNodeIndex].lb,nodeProps[startNodeIndex].hb,
                          featureLevelNbr2,Hash2,response2,Pb2,componentNbr,deltaIRglob,callChain);
          if featureFound then
           begin
            includeToMegaSet(leafNodeSet,startNodeIndex);
            CARTbestDivision(ComponentNbr,v1,v2,startNodeIndex,nodeProps[startNodeIndex].lb,nodeProps[startNodeIndex].hb,
             meanDistance1,meanDistance2,k1,k2,step,nodeHist_glob,'trial',callChain);  //out: v1,v2 - centra  meanDistance1,meanDistance2 - średnia odległość od centroidu w potomkach
            treeConstructor(startNodeIndex,heapTop,hb1glob,lb2glob,v1,v2,meanDistance1,meanDistance2,iterNbr,k1,k2,true,ComponentNbr,callChain);
           end;
         End; {son=0}
        if featureFound then
         begin
          if (@SetChoiceDivisionEvaluation<>@FeaturesChoiceDivisionEvaluation) then  //ocena wyboru zbioru, tutaj zmieni się jedynie deltaIRglob, która decyduje o wyborze zbioru do podziału
           begin
            If form1.RadioGroup26.ItemIndex=1 then                    //nowe histogramy są potrzebne tylko w trybie "supervised", dlatego ten warunek
            Histograms(cardinal,nodeProps[startNodeIndex].lb,nodeProps[startNodeIndex].hb,ComponentNbr,k1,k2,nodeHist_glob,
                       Hash1,response1,nodeProps[startNodeIndex].centroid[ComponentNbr],featureLevelNbr1,callChain);                //ComponentNbr, bo oceniamy wybrany podział wykonany wg składowej wektora cech o tym numerze
            try
             SetChoiceDivisionEvaluation(cardinal,TempHist1,TempHist2,NodeHist_glob,FeatureLevelNbr1,Pb1,setChoiceCritGlob,
              k1,k2,nodeProps[startNodeIndex].lb,nodeProps[startNodeIndex].hb,hb1glob,lb2glob,startNodeIndex,form1.RadioGroup24,sbl,callChain);                         //Hash,event muszą dotyczyć tutaj zmiennej klasyfikującej w przypadku, gdy mamy do czynienia z trybem "supervised"
            except
             error46(CallChain,form1.RadioGroup22);
            end;
           end {if @}
          else setChoiceCritGlob:=deltaIRglob;        //******************************************
          if (setChoiceCritGlob>distMax)  then       //zdecydować o wyborze zbioru do podziału
           begin
            nodeFound:=true;
            distMax:=setChoiceCritGlob;
            distMaxNodeAddr:=startNodeIndex;
            globComponentNbr:=ComponentNbr;
           end;
         end;{featureFound}
       End;{with}
     End;{else}
    deltaIRglob:=-1e+324; //bo wartość deltaIRglob jest wleczona w górę przy przeskoku na brata, co blokowało możliwość indywidualnego wyboru cechy, gdy IR w poprzednim węźle uzyskała wysoka wartość
    if nodeHeap[startNodeIndex].brother>0 then
    FeaturesTreeInspector(nodeHeap[startNodeIndex].brother,featureLevelNbr1,featureLevelNbr2,hash1,hash2,
                           response1,response2,Pb1,Pb2,'b',callChain) //przejście na brata
  End;{FeaturesTreeInspector}


 procedure FeaturesInspectTree(startNodeIndex:longWord;callChain:string;recurs:dword);
    {
    Obudowa do  FeaturesTreeInspector
     Wrażenie jest determinowane poprzez alternatywne wywołanie  FeaturesTreeInspector.
     UWAGA. Dla trybu "distortion" wartości argumentów są bez znaczenia, występują tylko dla uzyskania zgodności zmiennej proceduralnej...
     parametry empty - to tablice puste, nieprzydzielone RAM

   procedure FeaturesTreeInspector(startNodeIndex:longWord; const featureLevelNbr1,featureLevelNbr2:word;
    var Hash1,Hash2 :TcharByte; var response1,response2:TcharList; var Pb1,Pb2:TdbArr;l94:char;CallChain:string);
    }
    Begin
     callChain:=callChain+'>FeaturesInspectTree';
     leafCounter:=0;    //30.10.07
     deltaIRglob:=-1e+324;  setChoiceCritGlob:=0;
     case form1.RadioGroup24.ItemIndex  of                                             //rodzaje wrażeń  (żółte)
     -1:                                                                               //żółte distortion;                                          żółte         zielone
        case form1.RadioGroup25.ItemIndex  of                                          //rodzaje wrażeń (zielone)                                 //wybór zbioru, wybór cechy
         -1: FeaturesTreeInspector(0, 255,255,     emptyHash,emptyHash,emptyResponse,emptyResponse,emptyIndex,emptyIndex,'A',callChain);       //distortion,   distortion
          0: FeaturesTreeInspector(0, 255,cath1Nbr,emptyHash,cath1Hash,emptyResponse,eventcath1,   emptyIndex,cath1Pb,'B',callChain);          //distortion,   cath1
          1: FeaturesTreeInspector(0, 255,cath2Nbr,emptyHash,cath2Hash,emptyResponse,eventcath2,   emptyIndex,cath2Pb,'C',callChain);          //distortion,   cath2
          2: FeaturesTreeInspector(0, 255,cath3Nbr,emptyHash,cath3Hash,emptyResponse,eventcath3,   emptyIndex,cath3Pb,'D',callChain);          //distortion,   cath3
          3: FeaturesTreeInspector(0, 255,cath4Nbr,emptyHash,cath4Hash,emptyResponse,eventcath4,   emptyIndex,cath4Pb,'E',callChain);          //distortion,   cath4
         end;{case}
      0:                                                                               //żółte cath1
         case form1.RadioGroup25.ItemIndex  of                                         //rodzaje wrażeń (zielone)
         -1: FeaturesTreeInspector(0, cath1Nbr,255,     cath1Hash,emptyHash,eventcath1,emptyResponse,cath1Pb,emptyIndex,'F',callChain);        //cath1,      distortion
          0: FeaturesTreeInspector(0, cath1Nbr,cath1Nbr,cath1Hash,cath1Hash,eventcath1,eventcath1,   cath1Pb,cath1Pb,'G',callChain);           //cath1,      cath1
          1: FeaturesTreeInspector(0, cath1Nbr,cath2Nbr,cath1Hash,cath2Hash,eventcath1,eventcath2,   cath1Pb,cath2Pb,'H',callChain);           //cath1,      cath2
          2: FeaturesTreeInspector(0, cath1Nbr,cath3Nbr,cath1Hash,cath3Hash,eventcath1,eventcath3,   cath1Pb,cath3Pb,'I',callChain);           //cath1,      cath3
          3: FeaturesTreeInspector(0, cath1Nbr,cath4Nbr,cath1Hash,cath4Hash,eventcath1,eventcath4,   cath1Pb,cath4Pb,'J',callChain);           //cath1,      cath4
         end;{case}
      1:                                                                               //żółte cath2
         case form1.RadioGroup25.ItemIndex  of                                         //rodzaje wrażeń (zielone)
         -1: FeaturesTreeInspector(0, cath2Nbr,255,     cath2Hash,emptyHash,eventcath2,emptyResponse,cath2Pb,emptyIndex,'K',callChain);  //cath2,       distortion;
          0: FeaturesTreeInspector(0, cath2Nbr,cath1Nbr,cath2Hash,cath1Hash,eventcath2,eventcath1,   cath2Pb,cath1Pb,'L',callChain);     //cath2,       cath1
          1: FeaturesTreeInspector(0, cath2Nbr,cath2Nbr,cath2Hash,cath2Hash,eventcath2,eventcath2,   cath2Pb,cath2Pb,'M',callChain);     //cath2,       cath2
          2: FeaturesTreeInspector(0, cath2Nbr,cath3Nbr,cath2Hash,cath3Hash,eventcath2,eventcath3,   cath2Pb,cath3Pb,'N',callChain);     //cath2,       cath3
          3: FeaturesTreeInspector(0, cath2Nbr,cath4Nbr,cath2Hash,cath4Hash,eventcath2,eventcath4,   cath2Pb,cath4Pb,'O',callChain);     //cath2,       cath4
         end;{case}
      2:                                                                               //żółte  cath3
          case form1.RadioGroup25.ItemIndex  of                                        //rodzaje wrażeń (zielone)
          -1: FeaturesTreeInspector(0, cath3Nbr,255,     cath3Hash,emptyHash, eventcath3,emptyResponse,cath3Pb,emptyIndex,'P',callChain);   //cath3,      distortion;
           0: FeaturesTreeInspector(0, cath3Nbr,cath1Nbr,cath3Hash,cath1Hash, eventcath3,eventcath1,cath3Pb,cath1Pb,'Q',callChain);       //cath3,      cath1
           1: FeaturesTreeInspector(0, cath3Nbr,cath2Nbr,cath3Hash,cath2Hash, eventcath3,eventcath2,cath3Pb,cath2Pb,'R',callChain);      //cath3,      cath2
           2: FeaturesTreeInspector(0, cath3Nbr,cath3Nbr,cath3Hash,cath3Hash, eventcath3,eventcath3,cath3Pb,cath3Pb,'S',callChain);    //cath3,      cath3
           3: FeaturesTreeInspector(0, cath3Nbr,cath4Nbr,cath3Hash,cath4Hash, eventcath3,eventcath4,cath3Pb,cath4Pb,'T',callChain);  //cath3,      cath4
          end;{case}
      3:                                                                               //żółte  cath4
          case form1.RadioGroup25.ItemIndex  of                                        //rodzaje wrażeń (zielone)
          -1: FeaturesTreeInspector(0, cath4Nbr,255,     cath4Hash,emptyHash, eventcath4,emptyResponse,cath4Pb,emptyIndex,'P',callChain);   //cath4,      distortion;
           0: FeaturesTreeInspector(0, cath4Nbr,cath1Nbr,cath4Hash,cath1Hash, eventcath4,eventcath1,cath4Pb,cath1Pb,'U',callChain);       //cath4,      cath1
           1: FeaturesTreeInspector(0, cath4Nbr,cath2Nbr,cath4Hash,cath2Hash, eventcath4,eventcath2,cath4Pb,cath2Pb,'V',callChain);      //cath4,      cath2
           2: FeaturesTreeInspector(0, cath4Nbr,cath3Nbr,cath4Hash,cath3Hash, eventcath4,eventcath3,cath4Pb,cath3Pb,'W',callChain);    //cath4,      cath3
           3: FeaturesTreeInspector(0, cath4Nbr,cath4Nbr,cath4Hash,cath4Hash, eventcath4,eventcath4,cath4Pb,cath4Pb,'Z',callChain);  //cath4,      cath4
          end;{case}
     else error39('Invalid sensation number, program error, procedure "FeaturesInspectTree"');
     end;{case}
    End;{FeaturesInspectTree}

 procedure QuickSort(var leafCardArr,leafNodes:array of longWord; l,r:longWord);
     //sortuje tablicę liczebności liści
   var i,j,x,y,z : int64;
   begin
     i:=l; j:=r;
     x:=leafCardArr[(l+r) DIV 2];
     repeat
      while
       leafCardArr[i]<x
      do i:=i+1;
      while x<leafCardArr[j] do j:=j-1;
      if i<=j then
      begin
       y:=leafCardArr[i]; leafCardArr[i]:=leafCardArr[j]; leafCardArr[j]:=y;
       z:=leafNodes[i];   leafNodes[i]:=leafNodes[j];     leafNodes[j]:=z;
       i:=i+1; j:=j-1;
      end;
     until i>j;
     if l<j then QuickSort(leafCardArr,leafNodes,l,j);
     if i<r then QuickSort(leafCardArr,leafNodes,i,r);
   end;{QuickSort}

 function TakeInitialCentroidsSTD(var v1,v2:TmeanVector; const lb,hb:longWord; const centroid:TmeanVector;const nodeAddr:word):boolean;
{
oblicza wektory v1, v2 jako centroidy odległe od środka o pewną ilość (multStdDev) odchyleń standardowych od centrum zbioru
lb,hb - zakres, w którym mieszczą się indeksy na liscie haszujacej rozbijanego zbioru
sbl - lista adresów zdarzen zbioru (sorted border list)
stdev=sqrt[E(x kw)-(E(x))kw], tj.   średnia z kwadratów minus kwadrat średniej
TIC(v1,v2,nodeProps[NodeAddr].lb,nodeProps[NodeAddr].hb,nodeProps[NodeAddr].centroid) //TIC=TakeInitialCentroids
}
 var i,j : longword;
  var   temp:double;
 begin //----------------TakeInitialCentroidsSTD--------
  result:=true;
  for j:=0 to nc do  if inMegaSet(j,featureMegaSet) then
   begin
    sz[j]:=0; sk[j]:=0
   end;                            //wektory sum
  for i:=lb to hb do              //sumy zwykłe "sz" i sumy kwadratów "sk" składowych
   begin
    control1:=i;//debug prp
   for j:=0 to nc do            //składowe wektora odchyleń standardowych
    begin if not inMegaSet(j,featureMegaSet) then continue; //101019 oblokowano
     control2:=i;//debug prp
     temp:=vectList[sbl[i],j];//vectList[i,sbl[j]];
     sz[j]:=sz[j]+temp;      //sz - suma zwykla
     sk[j]:=sk[j]+temp*temp;//sqr(vectList[sbl[j],i]); dawał ujemne wyniki!!!!!  ; suma kwadratow
    end;
   end;
  for j:=0 to nc do
   begin if not inMegaSet(j,featureMegaSet) then continue;
    temp:=sz[j]/(hb-lb+1);             //średnia składowej
    temp:=-temp*temp+sk[j]/(hb-lb+1); //średnia z kwadratów minus kwadrat średniej; 18.12.09 zamiana sqr na temp*temp
    if temp<0 then error58('TakeInitialCentroids');
    stdev[j]:=sqrt(temp);
    nodeProps[nodeAddr].nodeStdev[j]:=stdev[j];
    nodeProps[nodeAddr].nodeStep:=step;
    if stdev[j]<0 then error58('TakeInitialCentroids');
    v1[j]:=centroid[j]-multStdDev*stdev[j];
    v2[j]:=centroid[j]+multStdDev*stdev[j];
   end;
 end;{TakeInitialCentroidsSTD}


 function readFirstCentroids(nc:word; var centroid1,centroid2:TmeanVector(*;ext:char*)):boolean;
 {
 Odczytuje centroidy pierwszego podziału z uprzednio wykonanej analizy
 }
 var j:word; sTmp:string;  logos:boolean;

 Begin  //--------------------------readFirstCentroids------------------------
  readFirstCentroids:=true;
  assignFile(treeFile,treeFileDir);//+ext); blok 12.03.09
  reset(treeFile);
  try
  readln(treeFile,j);      //CART|centroids
  if j<>form1.RadioGroup12.ItemIndex then
   begin
    case form1.RadioGroup12.ItemIndex of
     0: error39('Proc. "ReadFirstCentroids"'#13#10'The first centroids could''t be read. The existing tree'#13#10+
        treeFileDir+#13#10'was prepared with the "centroids" but now you apply the "CART" method'#13#10'Try again, do not read the "first centroids"');
     1: error39('Proc. "ReadFirstCentroids"'#13#10'The first centroids can''t be read. The existing tree'#13#10+
        treeFileDir+#13#10'was prepared with the "CART" but now you apply the "centroids"  method'#13#10'Try again, do not read the "first centroids"');
    end;{case}
    readFirstCentroids:=false;
    closeFile(treeFile);
    exit;
   end;
  repeat
   readln(treeFile,sTmp);   //Quantization tree
   logos:=(sTmp='Quantization tree') or seekEof(treeFile);
  until logos;
  if  seekEof(treeFile) then begin error1(treeFile,result); exit end;
  //read 0-th centroid
  readln(treeFile,sTmp);   //"son, brother"
  readln(treeFile,sTmp);   //son, brother
  readln(treeFile,sTmp);   //"Centroid"
  for j:=0 to nc do   if inMegaSet(j,featureMegaSet) then
   readln(treeFile,centroid2[j]);
  //read 1-sth centroid
  readln(treeFile,sTmp);   //"son, brother"
  readln(treeFile,sTmp);   //son, brother
  readln(treeFile,sTmp);   //"Centroid"
  for j:=0 to nc do  if inMegaSet(j,featureMegaSet) then
   readln(treeFile,centroid1[j]);
  //read 2-nd centroid
  readln(treeFile,sTmp);   //"son, brother"
  readln(treeFile,sTmp);   //son, brother
  readln(treeFile,sTmp);   //"Centroid"
  for j:=0 to nc do  if inMegaSet(j,featureMegaSet) then
   readln(treeFile,centroid2[j]);

  except
   error1(treeFile,result);
   exit;
  end;{except}
  closeFile(treeFile);
 End;{readFirstCentroids}

 function LookForInitialCentroids(const nodeAddr:word):boolean;
 {
 Określa źródło centroidów
 w zależności od tego, czy jest to pierwszy krok czy dalsze i czy została włączona opcja "Czytaj centroidy z dysku"
 }
  Begin
   result:=true;
   if (step=1) and fileExists(treeFileDir) and (form1.CheckBox16.checked or secondPass and not form1.CheckBox17.checked) then           //form1.CheckBox16.checked = "Read first centroids",
    if secondPass and form1.CheckBox16.checked then readFirstCentroids(nc,v1,v2) //,'1') blok 12.03.09
    else
     if application.MessageBox(pchar('Should I read first centroids (from'#13#10'"'+treeFileDir(*+'1")'*)+'?'),'Centroids reading',mb_YesNo)=idYes then  // form1.CheckBox17.checked = "Overrite existed tree files without warning?"
      begin    //TakeInitialCentroids(out v1,v2:T128DoubleArr; const lb,hb:longWord):boolean;
      result:=readFirstCentroids(nc,v1,v2);//,'1'); blok 12.03.09
      if not result then result:=TIC(v1,v2,nodeProps[NodeAddr].lb,nodeProps[NodeAddr].hb,nodeProps[NodeAddr].centroid,nodeAddr) //TIC=TakeInitialCentroids
      end
     else result:=TIC(v1,v2,nodeProps[NodeAddr].lb,nodeProps[NodeAddr].hb,nodeProps[NodeAddr].centroid,nodeAddr)   //TIC=TakeInitialCentroids
   else   result:=TIC(v1,v2,nodeProps[NodeAddr].lb,nodeProps[NodeAddr].hb,nodeProps[NodeAddr].centroid,nodeAddr);  //TIC=TakeInitialCentroids
  End;{LookForInitialCentroids}

  procedure DistancesInspectTree(startNodeIndex:longWord;callChain:string;recurs:dword);
  {
   biegnij po drzewie w poszukiwaniu liścia o największej sumie odległości Euklidesa albo średniej odległości Euklidesa
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
   meanDistance - pochodzi z FindBestDivision\DivideSet
  }
   Begin  //-----------------------DistancesInspectTree------------------
    callChain:=callChain+'>DistancesInspectTree'+' '+intToStr(recurs)+' ';
    if nodeHeap[startNodeIndex].son>0 then  DistancesInspectTree(nodeHeap[startNodeIndex].son,callChain,recurs)
    else
     with nodeProps[startNodeIndex] do
     if (cardinal>=rareEventNbr1) and (meanDistance>minDouble) then
     if form1.radiogroup4.ItemIndex=0 then     //średniej odległości Euklidesa
      if (meanDistance>distMax) then
      begin
       nodeFound:=true;
       distMax:=meanDistance;
       distMaxNodeAddr:=startNodeIndex;
      end
      else
     else
      if (meanDistance*cardinal>distMax) then  //sumie odległości Euklidesa
      begin
       nodeFound:=true;
       distMax:=meanDistance*cardinal;
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     DistancesInspectTree(nodeHeap[startNodeIndex].brother,callChain,recurs) //przejście na brata
   End;{DistancesInspectTree}


procedure cath1ErrorInspectTree(startNodeIndex:longWord;callChain:string;recurs:dword);
  {
   biegnij po drzewie w poszukiwaniu liścia o najmniejszym błędzie rozpoznania fonemów
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
  cath1RecErr  pochodzi z ErrIrProcessing
  }
   Begin  //-----------------------cath1ErrorInspectTree------------------
    callChain:=callChain+'>cath1ErrorInspectTree'+' '+intToStr(recurs)+' ';
    if nodeHeap[startNodeIndex].son>0 then  cath1ErrorInspectTree(nodeHeap[startNodeIndex].son,callChain,recurs)
    else
     with nodeProps[startNodeIndex] do if (cath1RecErr>distMax) and (cardinal>=rareEventNbr1) and (meanDistance>minDouble) and (cath1RecErr>=0) then
      begin
       nodeFound:=true;
       distMax:=nodeProps[startNodeIndex].cath1RecErr;
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     cath1ErrorInspectTree(nodeHeap[startNodeIndex].brother,callChain,recurs) //przejście na brata
   End;{cath1ErrorInspectTree}

procedure cath2ErrorInspectTree(startNodeIndex:longWord;callChain:string;recurs:dword);
  {
   biegnij po drzewie w poszukiwaniu liścia o najmniejszym błędzie rozpoznania osób
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
   cath2RecErr pochodzi z Treecath2IRProcessing
  }
   Begin  //-----------------------cath2ErrorInspectTree------------------
    callChain:=callChain+'>cath2ErrorInspectTree'+' '+intToStr(recurs)+' ';
    if nodeHeap[startNodeIndex].son>0 then  cath2ErrorInspectTree(nodeHeap[startNodeIndex].son,callChain,recurs)
    else
     with nodeProps[startNodeIndex] do if (cath2RecErr>distMax) and (cardinal>=rareEventNbr1) and (meanDistance>minDouble) and (cath2RecErr>=0) then
      begin
       nodeFound:=true;
       distMax:=nodeProps[startNodeIndex].cath2RecErr;
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     cath2ErrorInspectTree(nodeHeap[startNodeIndex].brother,callChain,recurs) //przejście na brata
   End;{cath2ErrorInspectTree}

procedure cath3ErrorInspectTree(startNodeIndex:longWord;callChain:string;recurs:dword);
  {
   biegnij po drzewie w poszukiwaniu liścia o najmniejszym błędzie rozpoznania wieku
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
  cath3RecErr pochodzi z Treecath3IRProcessing
  }
   Begin  //-----------------------cath3ErrorInspectTree------------------
    callChain:=callChain+'>cath3ErrorInspectTree'+' '+intToStr(recurs)+' ';
    if nodeHeap[startNodeIndex].son>0 then  cath3ErrorInspectTree(nodeHeap[startNodeIndex].son,callChain,recurs)
    else
     with nodeProps[startNodeIndex] do if (cath3RecErr>distMax) and (cardinal>=rareEventNbr1) and (meanDistance>minDouble)and (cath3RecErr>=0) then
      begin
       nodeFound:=true;
       distMax:=nodeProps[startNodeIndex].cath3RecErr;
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     cath3ErrorInspectTree(nodeHeap[startNodeIndex].brother,callChain,recurs) //przejście na brata
   End;{cath3ErrorInspectTree}

procedure cath4ErrorInspectTree(startNodeIndex:longWord;callChain:string;recurs:dword);
  {
   biegnij po drzewie w poszukiwaniu liścia o najmniejszym błędzie rozpoznania płc
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
  cath4RecErr pochodzi z Treecath4IRProcessing
  }
   Begin  //-----------------------cath4ErrorInspectTree------------------
    callChain:=callChain+'>cath4ErrorInspectTree'+' '+intToStr(recurs)+' ';
    if nodeHeap[startNodeIndex].son>0 then  cath4ErrorInspectTree(nodeHeap[startNodeIndex].son,callChain,recurs)
    else
     with nodeProps[startNodeIndex] do if (cath4RecErr>distMax) and (cardinal>=rareEventNbr1) and (meanDistance>minDouble)and (cath4RecErr>=0) then
      begin
       nodeFound:=true;
       distMax:=nodeProps[startNodeIndex].cath4RecErr;
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     cath4ErrorInspectTree(nodeHeap[startNodeIndex].brother,callChain,recurs) //przejście na brata
   End;{cath4ErrorInspectTree}

procedure cath1IRInspectTree(startNodeIndex:longWord;callChain:string;recurs:dword);
  {
   biegnij po drzewie w poszukiwaniu liścia o najmniejszym promieniu informacji dla  fonemów
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
   cath1Ir pochodzi z TreeLeafSetProcess/ErrIrProcessing
  }

    Begin  //-----------------------cath1IRInspectTree------------------
     inc(recurs);
     callChain:=callChain+'>cath1IRInspectTree'+' '+intToStr(recurs)+' ';
    if nodeHeap[startNodeIndex].son>0 then  cath1IRInspectTree(nodeHeap[startNodeIndex].son,callChain,recurs)
    else
     with nodeProps[startNodeIndex] do if (-cath1Ir>=distMax) and (cardinal>=rareEventNbr1) and (meanDistance>minDouble) and (cath1Ir<=cath1IRmax)  then        //08-05-09; ujednolicenie wartości początkowej mxDelta: - przed cath1IR i >= zamiast <
      begin
       nodeFound:=true;
       distMax:=-nodeProps[startNodeIndex].cath1Ir;                  //10-05-09; ujednolicenie wartości początkowej mxDelta: wprowadzono - przed nodeProps
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     cath1IRInspectTree(nodeHeap[startNodeIndex].brother,callChain,recurs) //przejście na brata
   End;{cath1IRInspectTree}

procedure cath2IRInspectTree(startNodeIndex:longWord;callChain:string;recurs:dword);
  {
   biegnij po drzewie w poszukiwaniu liścia o najmniejszym promieniu informacji dla osób
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
   cath2Ir pochodzi z TreeLeafSetProcess/ErrIrProcessing
  }
   Begin  //-----------------------cath2IRInspectTree------------------
    inc(recurs);
    callChain:=callChain+'>cath2IRInspectTree'+' '+intToStr(recurs)+' ';
    if nodeHeap[startNodeIndex].son>0 then  cath2IRInspectTree(nodeHeap[startNodeIndex].son,callChain,recurs)
    else
     with nodeProps[startNodeIndex] do if (-cath2Ir>=distMax) and (cardinal>=rareEventNbr1) and (meanDistance>minDouble) and (cath2Ir<=cath2IRmax) then
      begin
       nodeFound:=true;
       distMax:=nodeProps[startNodeIndex].cath2Ir;
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     cath2IRInspectTree(nodeHeap[startNodeIndex].brother,callChain,recurs) //przejście na brata
   End;{cath2IRInspectTree}


procedure cath3IRInspectTree(startNodeIndex:longWord;callChain:string;recurs:dword);
  {
   biegnij po drzewie w poszukiwaniu liścia o najmniejszym promieniu informacji dla wieku
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
   cath3Ir pochodzi z TreeLeafSetProcess/ErrIrProcessing
  }
   Begin  //-----------------------cath3IRInspectTree------------------
    inc(recurs);
    callChain:=callChain+'>cath3IRInspectTree'+' '+intToStr(recurs)+' ';
    if nodeHeap[startNodeIndex].son>0 then  cath3IRInspectTree(nodeHeap[startNodeIndex].son,callChain,recurs)
    else
     with nodeProps[startNodeIndex] do if (-cath3Ir>=distMax) and (cardinal>=rareEventNbr1) and (meanDistance>minDouble) and (cath3Ir<=cath3IRmax)  then
      begin
       nodeFound:=true;
       distMax:=nodeProps[startNodeIndex].cath3Ir;
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     cath3IRInspectTree(nodeHeap[startNodeIndex].brother,callChain,recurs) //przejście na brata
   End;{cath3IRInspectTree}

procedure cath4IRinspectTree(startNodeIndex:longWord;callChain:string;recurs:dword);
  {
   biegnij po drzewie w poszukiwaniu liścia o najmniejszym promieniu informacji dla płc
   działa na etapie tworzenia drzewa kwantującego
   rareEventNbr1 - tylko zbiory o liczebnościach przewyższających ten próg będą wybierane do dalszego dzielenia
   cath4Ir pochodzi z TreeLeafSetProcess/ErrIrProcessing
  }
   Begin  //-----------------------cath4IRinspectTree------------------
    inc(recurs);
    callChain:=callChain+'>cath4IRInspectTree'+' '+intToStr(recurs)+' ';
    if nodeHeap[startNodeIndex].son>0 then  cath4IRInspectTree(nodeHeap[startNodeIndex].son,callChain,recurs)
    else
     with nodeProps[startNodeIndex] do if (-cath4Ir>=distMax) and (cardinal>=rareEventNbr1) and (meanDistance>minDouble) and (cath4Ir<=cath4IRmax)  then
      begin
       nodeFound:=true;
       distMax:=nodeProps[startNodeIndex].cath4Ir;
       distMaxNodeAddr:=startNodeIndex;
      end;
    if nodeHeap[startNodeIndex].brother>0 then
     cath4IRInspectTree(nodeHeap[startNodeIndex].brother,callChain,recurs) //przejście na brata
   End;{cath4IRinspectTree}

 procedure deltaCompare(const startNode:word;const newDistort_IR_recErr:double; var tryDelta:double; out distMaxNodeAddr:LongWord; out nodeFound:boolean);
   begin
    with nodeprops[startNode] do if (tryDelta<newDistort_IR_recErr) and (cardinal>=rareEventNbr1) and (meanDistance>minDouble) then
     begin                                  //----------------------wskaż liść do rozszczepienia-----------------
      tryDelta:=newDistort_IR_recErr;              // trik:=cardinal*meanDistance-dist1-dist2; if round(trik)<>round(trydelta) then showMessage('wow!');// 05.08.2007
      distMaxNodeAddr:=startNode; nodeFound:=true;
     end;
   end;{deltaCompare}

 procedure CARTlike(startNode:longWord;callChain:string;recurs:dword);
 {
 Alternative for DistancesInspectTree
 }
  procedure CARTiNO(startNode:longWord;sb:char;callChain:string);
   { -------nagłówek Cartino nie zgadza się z nagłówkiem Inspect Tree, dlatego otacza ją CARTlike-------
   Przegląda wszystkie liście i wybiera zbiór do rozszczepienia metodą CARTlike
    k1, k2 - liczebności zbiorów
    ResponseChecker - zmienna proceduralna; ResponseChecker = checkDistortion|checkcath1IR|checkcath2IR|checkcath3IR|checkcath4IR
    startNode - adres próbnie rozbijanego liścia
   }
   Begin   //---------------look for the best split
    callChain:=callChain+'>Cartino'+' '+intToStr(recurs)+' ';
    with nodeHeap[startNode] do
    if son>0 then CARTiNo(son,'s',callChain)           //biegnij do liścia
    else                                               //osiągnięto liść
     Begin
      if son<0 then                                    //liść był już próbnie rozbity, są dane potomków (za wyjątkiem zbioru...)
       begin
        try
         deltaCompare(startNode,ResponseChecker(startNode),tryDelta,distMaxNodeAddr,nodeFound);
        except
         error46(callChain+' son<0'#13#10'deltaCompare, ResponseChecker',form1.RadioGroup22)
        end {try}
       end {son<0}
      else    //son=0, liść nie był jeszcze próbnie rozbity, i reprezentuje zbiór o więcej niz 1 elemencie, meanDistance>minDouble dodano 19.12.09, bo walił się na przypadku, gdy zbiór składał się z identycznych elementów
      if (nodeProps[startNode].cardinal>1) and (nodeProps[startNode].meanDistance>minDouble) then
       begin //-------------
        if LookForInitialCentroids(startNode) then
         begin   //treeConstructor wpisze ujemny adres następnika rozszczepianego węzła, co oznaczać będzie rozszczepienie próbne
          FindBestDivision(startNode,v1,v2,nodeProps[startNode].lb,nodeProps[startNode].hb,
           meanDistance1,meanDistance2,iterNbr,hb1glob,lb2glob,k1,k2,step,callChain);
          treeConstructor(startNode,heapTop,hb1glob,lb2glob,v1,v2,meanDistance1,meanDistance2,iterNbr,k1,k2,true,0,callChain);
          try
           deltaCompare(startNode,ResponseChecker(startNode),tryDelta,distMaxNodeAddr,nodeFound);
          //ResponseChecker(startNode); dokonać oceny wykonanego podziału: czy silnej pomniejsza dystorsję jak poprzedni liść (po podziale)? Jeśli tak, to zpamiętać jego adres
          except
           error46(callChain+'son=0'#13#10'deltaCompare, ResponseChecker',form1.RadioGroup22)
          end;{try}
         end;{if}
       end;  //------------
     End; {else son>0}
     if nodeHeap[startNode].brother>0 then CARTiNo(nodeHeap[startNode].brother,'b',callChain)  //przejdź na alternatywę
   End;{CARTINO}

 Begin
  callChain:=callChain+'>CARTlike';
  CARTiNO(startNode,#0,callChain);  //CARTINO utworzone, aby przejść do wersji proceduralnej DistancesInspectTree|CARTlike
 End; {CARTlike}

 procedure H0ToreportTXT;
 var i:byte;
 s:string[6];
 Begin
 if form1.checkbox2.Checked then
  begin
   writeln(reportFile,#13#10'Histograms in all data (H0-cath# histograms). The first position signed with blank,'+
   'is reserved for signs not present in the cath#''s set values (for some unknown error situations).'#13#10);
   writeln(reportFile,Y1name,'''s histogram.');
   write(reportFile,'catheg. ');for i:=0 to cath1Nbr do write(reportFile,cath1CodeList[i]:6,' '); writeln(reportFile);
   write(reportFile,'counts  ');for i:=0 to cath1Nbr do write(reportFile,  cath1H0[i]:6,' '); writeln(reportFile);
   write(reportFile,'probab. ');for i:=0 to cath1Nbr do write(reportFile,cath1Pb[i]:6:3,' '); writeln(reportFile);     //prawdopodobieństwa empiryczne fonemów
  end;
  if form1.checkbox3.Checked then
   begin
    writeln(reportFile,#13#10,Y2Name,'''s histogram.');
    write(reportFile,'catheg. ');for i:=0 to cath2Nbr do write(reportFile,cath2CodeList[i]:6,' ');writeln(reportFile);
    write(reportFile,'counts  ');for i:=0 to cath2Nbr do write(reportFile,cath2H0[i]:6,' '); writeln(reportFile);
    write(reportFile,'probab. ');for i:=0 to cath2Nbr do write(reportFile,cath2Pb[i]:6:3,' '); writeln(reportFile); //prawdopodobieństwa empiryczne osób
    writeln(reportFile);
   end;
   if form1.checkbox4.Checked then
    begin
     writeln(reportFile,Y3Name,'''s histogram.');
     write(reportFile,'catheg.  ');for i:=0 to cath3Nbr do write(reportFile,cath3CodeList[i]:7,' '); writeln(reportFile);
     write(reportFile,'counts   ');for i:=0 to cath3Nbr do write(reportFile,cath3H0[i]:7,' '); writeln(reportFile);
     write(reportFile,'probab.  ');for i:=0 to cath3Nbr do write(reportFile,cath3Pb[i]:7:3,' '); writeln(reportFile); //prawdopodobieństwa empiryczne plci osób
     writeln(reportFile);
    end;

   if form1.checkbox28.Checked then
    begin
     writeln(reportFile,Y4Name,'''s histogram in all data. The first position signed with blank, is reserved for the cathegory',
     ' values not taken into account (for some unknown error situations).');
     write(reportFile,'catheg.  ');for i:=0 to cath4Nbr do write(reportFile,cath4CodeList[i]:7,' '); writeln(reportFile);
     write(reportFile,'counts   ');for i:=0 to cath4Nbr do write(reportFile,cath4H0[i]:7,' '); writeln(reportFile);
     write(reportFile,'probab.  ');for i:=0 to cath4Nbr do write(reportFile,cath4Pb[i]:7:3,' '); writeln(reportFile); //prawdopodobieństwa empiryczne wieku osób
    end;
  writeln(reportFile);
  flush(reportFile);
 End;{H0ToreportTXT}

procedure H0ToreportExcel;
 var i:byte;
 s:string[6];
 Begin
  if form1.checkbox2.Checked then
   begin
    writeln(reportFile,#13#10'Histograms in all data (H0-cath# histograms). The first position signed with blank,'+
   'is reserved for signs not present in the cath#''s set values (for some unknown error situations).'#13#10);
    writeln(reportFile,Y1Name,'''s histogram.');
    write(reportFile,'catheg. |');for i:=0 to cath1Nbr do write(reportFile,cath1CodeList[i]:6,' |'); writeln(reportFile);     //Uwaga! znak | w zbiorze znaków lisy będzie psuł synchro w nagłówku!!!
    write(reportFile,'counts  |');for i:=0 to cath1Nbr do write(reportFile,cath1H0[i]:6,' |'); writeln(reportFile);
    write(reportFile,'probab. |');for i:=0 to cath1Nbr do write(reportFile,cath1Pb[i]:6:3,' |'); writeln(reportFile);     //prawdopodobieństwa empiryczne fonemów
   end;
  if form1.checkbox3.Checked then
   begin
    writeln(reportFile,#13#10,Y2Name,'''s histogram.');
    write(reportFile,'code    |');for i:=0 to cath2Nbr do write(reportFile,cath2CodeList[i]:6,' |');writeln(reportFile);
    write(reportFile,'counts  |');for i:=0 to cath2Nbr do write(reportFile,cath2H0[i]:6,' |'); writeln(reportFile);
    write(reportFile,'probab. |');for i:=0 to cath2Nbr do write(reportFile,cath2Pb[i]:6:3,' |'); writeln(reportFile); //prawdopodobieństwa empiryczne osób
    writeln(reportFile);
   end;
  if form1.checkbox4.Checked then
   begin
    writeln(reportFile,Y3Name,'''s histogram.');
    write(reportFile,'catheg.  |');for i:=0 to cath3Nbr do write(reportFile,cath3CodeList[i]:7,' |'); writeln(reportFile);
    write(reportFile,'counts   |');for i:=0 to cath3Nbr do write(reportFile,cath3H0[i]:7,' |'); writeln(reportFile);
    write(reportFile,'probab.  |');for i:=0 to cath3Nbr do write(reportFile,cath3Pb[i]:7:3,' |'); writeln(reportFile); //prawdopodobieństwa empiryczne osób
    writeln(reportFile);
   end;
   if form1.checkbox28.Checked then
   begin
    writeln(reportFile,Y4Name,'''s histogram in all data.');
    write(reportFile,'catheg.  |');for i:=0 to cath4Nbr do write(reportFile,cath4CodeList[i]:7,' |'); writeln(reportFile);
    write(reportFile,'counts   |');for i:=0 to cath4Nbr do write(reportFile,cath4H0[i]:7,' |'); writeln(reportFile);
    write(reportFile,'probab.  |');for i:=0 to cath4Nbr do write(reportFile,cath4Pb[i]:7:3,' |'); writeln(reportFile); //prawdopodobieństwa empiryczne osób
    writeln(reportFile);
   end;
  flush(reportFile);
 End;{H0ToreportExcel}



 procedure MakeH0Hist(const eventNbr:longWord; var cath1H0,cath2H0,cath3H0,cath4H0:THist;callChain:string);
 {          uwzględnić znaki spoza listy!
 Przebiega m.in. po fonemach przypisanych przekrojom spektralnym (cepstralnym)
     eventNbr - liczba zdarzeń (wykonanych przekrojów spektralnych)
    cath#Hash - #=1..4, #=1, to lista fonemów (array[char] of byte), skorowidz numerów przypisanych fonemom
   eventcath1 - indeks do listy fonemów przypisanych próbkom akustycznym
           H0 - histogram numerów fonemów; każdy numer na osi odciętych należy dekodować za pomocą listy cath1CodeList
 }

  var    i,k : longWord;

  Begin  //-----------------------MakeH0Hist----------------------------
   callChain:=callChain+'>MakeH0Hist';
   begin
    with form1 do
     begin
      if checkbox2.Checked then for i:=0 to cath1Nbr do cath1H0[i]:=0;
      if checkbox3.Checked then for i:=0 to cath2Nbr do cath2H0[i]:=0;
      if checkbox4.Checked then for i:=0 to cath3Nbr do cath3H0[i]:=0;
     if checkbox28.Checked then for i:=0 to cath4Nbr do cath4H0[i]:=0;
     end;
    end;
   k:=0;
   control2:=high(eventcath4); control3:=high(cath4H0);      //debug prp
   for i:=0 to readEventNbr-1 do if not inMegaSet(i,excludeEventsMegaSet) then      //czy lista eventcath1 zaczyna się od 0?
    begin                                                             //czy tu nie powinno być if not inMegaSet(i,excludeEventsMegaSet) then ?? 010210
     inc(k);
     if form1.CheckBox2.Checked then                                  //debug prp
      if eventCath1[i] in cath1Set then inc(cath1H0[cath1Hash[eventCath1[i]]])
      else inc(cath1H0[0]);                                           //uwzględnić znaki spoza deklarowanego zbioru
     if form1.CheckBox3.Checked then
      if eventCath2[i] in cath2Set then inc(cath2H0[cath2Hash[eventCath2[i]]])
      else inc(cath2H0[0]);
     if form1.CheckBox4.Checked then
      if eventCath3[i] in cath3Set then inc(cath3H0[cath3Hash[eventCath3[i]]])
      else inc(cath3H0[0]);
     if form1.CheckBox28.Checked then
      if eventCath4[i] in cath4Set then inc(cath4H0[cath4Hash[eventCath4[i]]])
      else inc(cath4H0[0]);
    end;
    if k<>eventNbr then error33(eventNbr,k);
    if form1.CheckBox2.Checked then for i:=0 to cath1Nbr do cath1Pb[i]:=cath1H0[i]/eventNbr;   //prawdopodobieństwa empiryczne fonemów
    if form1.CheckBox3.Checked then for i:=0 to cath2Nbr do cath2Pb[i]:=cath2H0[i]/eventNbr;   //prawdopodobieństwa empiryczne osób
    if form1.CheckBox4.Checked then for i:=0 to cath3Nbr do cath3Pb[i]:=cath3H0[i]/eventNbr;   //prawdopodobieństwa empiryczne plci osób
    if form1.CheckBox28.Checked then for i:=0 to cath4Nbr do cath4Pb[i]:=cath4H0[i]/eventNbr;  //prawdopodobieństwa empiryczne wieku osób
    H0ToReport;                                                                                                                                                                                   // var allStep:word; labelx:Tlabel
    with nodeProps[0] do
     begin  //errIRProcessing(const n:longWord; const nodeAddr:word; const NodeHist:THist;pbHist:TdbArr;const NbrClass:byte; out IR:double; out max:byte; out error:longWord;var checkSet:TcharSet; var all:boolean;const list:TcharList;const cl:longint;var allStep:word; labelx:Tlabel; var cathIRnodeDistr: array of double;callChain:string););
      if form1.CheckBox2.Checked then errIRProcessing(cardinal,0,cath1H0,cath1Pb,cath1Nbr,nodeprops[0].cath1IR,nodeprops[0].maxCath1,nodeprops[0].cath1RecErr,checkcath1Set,allcath1,cath1CodeList,cl1,cath1AllStep,form1.label138,cath1IRnodeDistrArr[0],callChain)
      else cath1RecErr:=cardinal;
      if form1.CheckBox3.Checked then errIRProcessing(cardinal,0,cath2H0,cath2Pb,cath2Nbr,nodeprops[0].cath2IR,nodeprops[0].maxCath2,nodeprops[0].cath2RecErr,checkcath2Set,allcath2,cath2CodeList,cl2,cath2AllStep,form1.label139,cath2IRnodeDistrArr[0],callChain)
      else cath2RecErr:=cardinal;
      if form1.CheckBox4.Checked then errIRProcessing(cardinal,0,cath3H0,cath3Pb,cath3Nbr,nodeprops[0].cath3IR,nodeprops[0].maxCath3,nodeprops[0].cath3RecErr,checkcath3Set,allcath3,cath3CodeList,cl3,cath3AllStep,form1.label140,cath3IRnodeDistrArr[0],callChain)
      else cath3RecErr:=cardinal;
     if form1.CheckBox28.Checked then errIRProcessing(cardinal,0,cath4H0,cath4Pb,cath4Nbr,nodeprops[0].cath4IR,nodeprops[0].maxCath4,nodeprops[0].cath4RecErr,checkcath4Set,allcath4,cath4CodeList,cl4,cath4AllStep,form1.label152,cath4IRnodeDistrArr[0],callChain)
      else cath4RecErr:=cardinal;
     end;{with}
  End;{MakeH0Hist}                                                                        //na brata

  procedure showLeavesSetsCounts(graphRepeat:boolean;callChain:string);
  //onceShowed - block multiple entering proc IRframe if overlay graphs is on
   var i:word; s:shortString;
    prevX,currX,prevY,sum:double;
   Begin
    try
     setLength(leafCardArr,leafNodeNbr+1);
     for i:=0 to leafNodeNbr do leafCardArr[i]:=nodeProps[leafNodes[i]].cardinal;
     quickSort(leafCardArr,leafNodes,1,leafNodeNbr);
     with form1 do  //checkbox10 - nakładaj wykresy, checkBox29 - wstawiaj tabele pośrednie wyników końcowych dla liści
     if not checkbox10.Checked or not onceShowed and checkbox10.Checked  or graphRepeat then
      begin
       label100.Visible:=true;label100.Font.Style:=[fsBold]; Label100.BringToFront;
       Label100.Caption:='Cardinals (manyness of members) of final tree leaves';
       IRframe(Panel7,Canvas,CentroidsNb_glob{leafNodeNbr},leafCardArr[leafNodeNbr],0,0,0,0,wspx7,wspy7,topHeight7,false,'Sorted leaves nbrs',callChain);
       onceShowed:=true;
     end;
     prevX:=form1.panel7.left; prevY:=leafCardArr[1]; sum:=0;
      case -1+leafNodeNbr of
       2 : s:='After 2-nd step';
       3 : s:='After 3-rd step'
      else s:='After '+intToStr(-1+leafNodeNbr)+'-th step';
      end;
     form1.Label168.Caption:=s;
     for i:=1 to -1+leafNodeNbr do with form1 do
      begin
       currX:=i*wspx7+panel7.left;  sum:=sum+prevY;
       IRdrawings(Panel7,canvas,leafNodeNbr,prevX,currX,prevY,leafCardArr[i],wspy7,topHeight7,cl5);  //strech=leafCardArr[leafNodeNbr],
       prevX:=currX; prevY:=leafCardArr[i];
      end;{for}
     except
      error49;
     end;{except}
   End;{showLeavesSetsCounts}

 procedure LeavesSetsCountsToReport(callChain:string);
  //it was assumed, that the procedure "showLeavesSetsCounts" was prior performed
   var i:word; count:dword;
    prevX,currX,prevY,sum:double;
   Begin
    callChain:=callChain+'>LeavesSetsCountsToReport';
    try
   //  setLength(leafCardArr,leafNodeNbr+1);
   //  for i:=0 to leafNodeNbr do leafCardArr[i]:=nodeProps[leafNodes[i]].cardinal;
   //  quickSort(leafCardArr,1,leafNodeNbr);
     i:=high(i);  count:=0;
     writeln(reportFile,#13#10'Table 9. Groups (i.e. leafs) sets cardinals sorted according to their manyness.'+
     #13#10'The beneath list can help to denote rare events treshold');
     writeln(reportFile,#13#10'|=============================|');
     writeln(reportFile,      '|group |nodeAddr.|set manyness|');
     writeln(reportFile,      '|=============================|');
     for i:=1 to leafNodeNbr do with form1 do
      begin
       Writeln(reportFile,'|',i:5,' |',leafNodes[i]:9,'|',leafCardArr[i]:11,' |');
       inc(count,leafCardArr[i]);
      end;
      writeln(reportFile,     '|=============================|');
      writeln(reportFile,'| Total           ',count:11, ' |');
      writeln(reportFile,     '|=============================|');
     except
      error64(i,callChain);
     end;{except}
   End;{LeavesSetsCountsToReport}

 function DelSpace(s:string):string;
  var i,j:word;
  begin
   j:=length(s);
   for i:=j downto 1 do
    if s[i]=' ' then delete(s,i,1)
    else break;
  delSpace:=s;
 end;

 procedure Table2CollectionRow(callChain:shortString);

  function checkRadio(Radio:TradioGroup):shortString;
   Begin
    with radio do
    if itemIndex>=0 then result:=Items[itemIndex] else result:='*';
   End; {checkRadio}

  function ftsF(const amount:extended):string;
   Begin
    result:=FloatToStrF(amount, ffExponent,6, 2)
   End;

  var Row:string;  c1,c2:AnsiChar;

//  9	 10	 11	 12	 13	 14
//R22	R24	R26	R23	R25	R27

  Begin       //----------------------------------Table2CollectionRow------------------------------------------------
   with form1 do
   begin   Row:='';

           Row:= '|'+IntToStr(perfCounter-1)+'|'+Table2CollectionFileDir+'|'+reportDate+'|'+checkRadio(RadioGroup2)+'|';
            //                6                       12                     13               6
            //                1                        2                      3               4
            if checkBox42.Checked and (RadioGroup12.ItemIndex=1) then c1:='Y' else  c1:='N';
           Row:=Row+intToStr(trueEventNbr)+'|'+inpFileDir+'|'+intToStr(allNormChecksStatesCode)+'|'+intToStr(allOutChecksStatesCode)+'|'+form1.label112.Caption+'|'+checkRadio(RadioGroup12)+'|' +c1+'|'+checkRadio(RadioGroup22)+'|';
           //       7                          11                                                                                         10                         11                           12       13
           //       5                           6                                                                                          7                          8                            9       10
           Row:=Row+checkRadio(RadioGroup24)+'|'+checkRadio(RadioGroup26)+'|'+checkRadio(RadioGroup23)+'|'+checkRadio(RadioGroup25)+'|'+checkRadio(RadioGroup27)+'|';
           //       16                           9                            13                           15                            9
           //       11                          12                            13                           14                           15
           if checkBox39.Checked  then c1:='Y' else  c1:='N'; if checkBox45.Checked  then c2:='Y' else  c2:='N';

           Row:=Row+c1+'|'+c2+'|'+intToStr(step)+'|'+ftsF(distortion/TrueEventNbr)+'|'+intToStr(round(AveragingTime))+'|'+intToStr(round(AveragingTime/frameStep))+'|';
           //        7      7      6                  8                                 7                       12
           //       16     17     18                  19                               20                       21
           Row:=Row+'|'+ftsF(cath1IrGlob/step)+'|'+ftsF(cath2IrGlob/step)+'|'+ftsF(cath3IrGlob/step)+'|'+ftsF(cath4IrGlob/step)+'|';
           //            8                          8                          8                           8
           //           22                         23                         24                          25
           Row:=Row+'|'+ftsF(percNorm_glob*cath1RecErrSum)+'|'+ftsF(percNorm_glob*cath2RecErrSum)+'|'+ftsF(percNorm_glob*cath3RecErrSum)+'|'+ftsF(percNorm_glob*cath4RecErrSum)+'|';
           //        8                                            8                                            8                                            8
           //       25                                           26                                           27                                           28
     writeln(Table2CollectionFile,Row);
     flush(Table2CollectionFile);
   end;
  End;{Table2CollectionRow}


procedure FinalIRToreport(const performance:string; const EventNbr:longWord; const step:word;callChain:string);
  var        i,k:word; s,s11,s12,s13,s21,s22,s23,s31,s32,s33,s41,s42,s43,s4:shortstring;
   sumSetCounts,Err1S, Err2S,Err3S, Err4S :longWord;
   IR1S,IR2S,IR3S,IR4S, DistS:double;
   procedure underline;
    begin
     writeln(reportFile,'|=======|========|========|===========|===========|===========|===========|===========|===========|===========|===========|===========|===========|===========|===========|============|=============|');
    end;

 procedure checkPoint(const checked:boolean; const IR:double; const recErr:longWord; const effect:byte;const charList:TcharList;
                      out IRS:double; out errS:longword;out s1,s2,s3:shortString);
 {
 sumuje właściwości IR i recErr (po liściach)
 formułuje wyniki do zapisu w tabeli w formie tekstu
 }
  Begin
   if Checked then
    begin
     IRS:=IRS+Ir;   ErrS:=ErrS+RecErr;
     s1:=floatToStrF(Ir,ffFixed,10,3);s2:=intToStr(RecErr);s3:=charList[effect];
    end
   else
    begin
     s1:='    -    ';s2:=s1;s3:=s1;
    end;
  End; {checkPoint}

  procedure TotalCheckPoint(const checked:boolean; const effect:byte;const charList:TcharList; const IRS:double;
                            const errS:longword;out s1,s2,s3:shortString);
//formułuje wyniki do zapisu w tabeli w formie tekstu dla wiersza totals tabeli 3.
   Begin
    if Checked then
     begin
      s1:=floatToStrF(IRS/leafNodeNbr,ffFixed,10,3); s2:=intToStr(ErrS); s3:=charList[effect];
     end
    else
     begin
     s1:='    -    '; s2:=s1; s3:=s1;
    end;
   End;{TotalCheckPoint}

  var sCath1AllStep, sCath2AllStep, sCath3AllStep, sCath4AllStep : shortString;
  Begin  //-----------------------------------FinalIRToreport---------------------------------
   callChain:=callChain+'>FinalIRtoReport';
    showLeavesSetsCounts(false,callChain); //wykres liczebności1

    if cath1AllStep<>0 then sCath1AllStep:=intToStr(cath1AllStep) else sCath1AllStep:='   ?   ';
    if cath1AllStep<>0 then sCath2AllStep:=intToStr(cath2AllStep) else sCath2AllStep:='   ?   ';
    if cath1AllStep<>0 then sCath3AllStep:=intToStr(cath3AllStep) else sCath3AllStep:='   ?   ';
    if cath1AllStep<>0 then sCath4AllStep:=intToStr(cath4AllStep) else sCath4AllStep:='   ?   ';

    writeln(reportFile,'Table 2. Totals (sum of values over leaves of the quantization tree)'#13#10,
                       '         step - step, in which given cathegory already got representative events'#13#10,
                       '         groups for all its values (showed by a vertical line on drawings)' );
    writeln(reportFile,'=================================');
    writeln(reportFile,'|Class. |IRadius|Err %  |  step |');
    writeln(reportFile,'=================================');
    with form1 do
     begin            //percNorm*cath#RecErrSum;  percNorm:=100/eventNbr;
      write(reportFile,'|',Y1name:7,'|'); if checkBox2.checked  then writeln(reportFile,cath1IrGlob/step:7:3,'|',percNorm_glob*cath1RecErrSum:7:3,'|',sCath1AllStep:7,'|') else writeln(reportFile,'   -   |   -   |');
      write(reportFile,'|',y2Name:7,'|'); if checkBox3.checked  then writeln(reportFile,cath2IrGlob/step:7:3,'|',percNorm_glob*cath2RecErrSum:7:3,'|',sCath2AllStep:7,'|') else writeln(reportFile,'   -   |   -   |');
      write(reportFile,'|',Y3Name:7,'|'); if checkBox4.checked  then writeln(reportFile,cath3IrGlob/step:7:3,'|',percNorm_glob*cath3RecErrSum:7:3,'|',sCath3AllStep:7,'|') else writeln(reportFile,'   -   |   -   |');
      write(reportFile,'|',Y4Name:7,'|'); if checkBox28.checked then writeln(reportFile,cath4IrGlob/step:7:3,'|',percNorm_glob*cath4RecErrSum:7:3,'|',sCath4AllStep:7,'|') else writeln(reportFile,'   -   |   -   |');
     end;
    writeln(reportFile,'=================================');
    writeln(reportFile,'distortion..................',distortion/EventNbr:1:3,
                 #13#10'total iterations number.....',totalIterNbr);
    if form1.RadioGroup12.ItemIndex=0 then writeln(reportFile,'Note: There are no iterations in the "CART" approach');
   Table2CollectionRow(callChain);
   if not form1.CheckBox6.Checked then exit;                                                            //nie drukować tabeli IR dla liści
   writeln(reportFile,#13#10,
    'Table 3.'#13#10'Recognition errors and information radius (IR) values for histograms in leaves sets of the final tree for ',
    delSpace(Y1Name),'''s,',delSpace(Y2Name),'''s, ',delSpace(Y3Name),'''s, and the ',delSpace(Y4Name),'''s cathegories.');
   underline;
   if form1.radiogroup17.itemIndex=1 then  //table caption form, 0:txt, 1:Excel
    writeln(reportFile,'|Leaf no|leaf no-|leaf set|--------------------| IR for:|-----------------------|recognition| error for:-|-----------------------|  maximum| at for:--|-------------------|mean Euclid.|   optimal   |')
   else
    writeln(reportFile,'|Leaf no|leaf no-|leaf set|-------------------- IR for:-------------------|--------recognition error for:-----------------|--------maximum at for:------------------------|mean Euclid.|   optimal   |') ;
   writeln(reportFile,'|de nbr |de addr |count   |  ',Y1name:8,' |  ',Y2Name:8,' |  ',Y3Name:8,' |  ',Y4Name:8,' |  ',
                                                      Y1name:8,' |  ',Y2Name:8,' |  ',Y3Name:8,' |  ',Y4Name:8,' |  ',
                                                      Y1name:8,' |  ',Y2Name:8,' |  ',Y3Name:8,' |  ',Y4Name:8,' | Distance   | CART feature|');
   underline;
    sumSetCounts:=0; IR1S:=0; IR2S:=0; IR3S:=0; IR4S:=0; Err1S:=0; Err2S:=0; Err3S:=0; Err4S:=0; DistS:=0;
   for i:=1 to leafNodeNbr do
    begin
     k:=leafNodes[i];
     with form1,nodeProps[k] do
     begin
    //checkPoint(const checked:boolean; const IR:double; const recErr:longWord; const effect:char; out IRS:double; out errS:longword;out s1,s2,s3:shortString);
      checkPoint(checkBox2.Checked,cath1Ir,cath1RecErr,maxCath1,cath1CodeList,IR1S,Err1S,s11,s12,s13);
      checkPoint(checkBox3.Checked,cath2Ir,cath2RecErr,maxCath2,cath2CodeList,IR2S,Err2S,s21,s22,s23);
      checkPoint(checkBox4.Checked,cath3Ir,cath3RecErr,maxCath3,cath3CodeList,IR3S,Err3S,s31,s32,s33);
     checkPoint(checkBox28.Checked,cath4Ir,cath4RecErr,maxCath4,cath4CodeList,IR4S,Err4S,s41,s42,s43);
      if radiogroup12.ItemIndex=0 then s4:=intToStr(nodeProps[k].OptComponentNbr) else s4:='     -      ';
      DistS:=distS+meanDistance*cardinal;
      sumSetCounts:=sumSetCounts+cardinal;
       writeln(reportFile,'|',i:6,' |',k:7,' |',cardinal:7,' |',
     s11:10,' |',s21:10,' |',s31:10,' |',s41:10,' |',
     s12:10,' |',s22:10,' |',s32:10,' |',s42:10,' |',
     s13:10,' |',s23:10,' |',s33:10,' |',s43:10,' |',             //cath1CodeList[nodeProps[k].cath1]:10,' |',cath2CodeList[nodeProps[k].cath2]:10,' |',cath3CodeList[nodeProps[k].cath3]:10,' |',
     nodeProps[k].meanDistance:11:3,' |',s4:12,' |');//nodeProps[k].OptComponentNbr
     end;{with}
    end;{for}
   underline;
    with form1,nodeProps[0] do      //Table 3,  Totals-------------------------------------------------------------
    //TotalCheckPoint(const checked:boolean; const effect:byte;const charList:TcharList; const IRS:double; const errS:longword;
    //               out s1,s2,s3:shortString);
     begin
      TotalCheckPoint(checkBox2.Checked,maxCath1,cath1CodeList,IR1S,Err1S,s11,s12,s13);
      TotalCheckPoint(checkBox3.Checked,maxCath2,cath2CodeList,IR2S,Err2S,s21,s22,s23);
      TotalCheckPoint(checkBox4.Checked,maxCath3,cath3CodeList,IR3S,Err3S,s31,s32,s33);
      TotalCheckPoint(checkBox28.Checked,maxCath4,cath4CodeList,IR4S,Err4S,s41,s42,s43);
      if radiogroup12.ItemIndex=0 then s4:=intToStr(nodeProps[k].OptComponentNbr) else s4:='     -      ';
     end;{form1,nodeProps[0]}
    writeln(reportFile,'|','Totals':6,' |',' - ':7,' |',sumSetCounts:7,' |',
     s11:10,' |',s21:10,' |',s31:10,' |',s41:10,' |',
     s12:10,' |',s22:10,' |',s32:10,' |',s42:10,' |',
     s13:10,' |',s23:10,' |',s33:10,' |',s43:10,' |',
     DistS/eventNbr:11:3,' |',s4:12,' |');
   underline;
   writeln(reportFile,'Notes');
    with form1 do
    s:=radiogroup22.caption+'\'+radiogroup22.Items[radiogroup22.ItemIndex]+'"';
   writeln(reportFile,#13#10'1.'#9'Numer liścia wynika z kolejności obróbki jego zbioru, co z kolei jest determinowane kryterium wyboru "',s);
   writeln(reportFile,'2.'#9'The column "leaf node nr" shows rows nr in the tree.',
    #13#10#9'It is a tree node number resulted from order of processing (not from a tree path sequence), determined by the set choice (for spliting) criterion, i.e. "',s);    //Jest to numer węzła w drzewie wynikający z kolejności obróbki (a nie z kolejności na jakiejkolwiek ścieżce)
  End;{FinalIRToreport}


 procedure RowsToReportTableCaptionTXT;
 var i:byte;

  procedure underline;
   begin
    write(reportFile,'=================================================================================================+');
    with form1 do
     begin
      if radiogroup12.itemIndex=0  then write(reportFile,'==================');
      if checkBox2.Checked         then write(reportFile,'================');
      if checkBox3.Checked         then write(reportFile,'================');
      if checkBox4.Checked         then write(reportFile,'================');
       if checkBox28.Checked       then write(reportFile,'================');
     end;
    write(reportFile,'==========|');
   end;

  Begin   //wyprowadza nagłówek do reportu - dane wyprowadzane z pętli RUN
   writeln(reportFile,'Results of histograms comparing with the information radius function');

   writeln(reportFile,'Global totals (sum of IR values over leaves of the quantization tree).'#13#10,
    #13#10'       IR = Information Radius',
    #13#10'     card = count of elements in a given set',
    #13#10'    error = error in a selftest.',
    #13#10'    count = total count of elements in a given cathegory group',
    #13#10'Note: errors for cathegories values are counts of classifications different from classifications dominating in a given clusters group');
   writeln(reportFile,#13#10'Table 1.'#13#10,
    'IR means over all leaves at a given stage of the tree building and, if recquiread, over the dependant variables, i.e.: "',
    Y1Name,'", "',Y2name,'", "',Y3name,'" and "',Y4Name,'" values clusters groups'#13#10);
{1} underline;
    writeln(reportFile);

{2} write(reportFile,'|      |isolat. |-------node adresses------|-------set counts---------|iter|fission   |distortion|');
    with form1 do
     begin
      if radiogroup12.ItemIndex =0 then write(reportFile,'Optimal component|');
      write(reportFile,'----');
      if checkBox2.Checked then write(reportFile,Y1Name:8,'---|','----');
      if checkBox3.Checked then write(reportFile,Y2Name:8,'---|','----');
      if checkBox4.Checked then write(reportFile,Y3Name:8,'---|','----');
     if checkBox28.Checked then write(reportFile,Y4Name:8,'---|','----');
     end;
    write(reportFile,'-Time-|');
    writeln(reportFile);

{3} write(reportFile,'| step |treshold|  father|    son | brother|  father|    son | brother|','nbr |','distance  |','          |');
   with form1 do
    begin
     if radiogroup12.ItemIndex =0 then write(reportFile,'number|mean value|');
     if checkBox2.Checked  then write(reportFile,'  IR   |error %|');
     if checkBox3.Checked  then write(reportFile,'  IR   |error %|');
     if checkBox4.Checked  then write(reportFile,'  IR   |error %|');
     if checkBox28.Checked then write(reportFile,'  IR   |error %|');
    end;
    write(reportFile,'  [sec]   |');
    writeln(reportFile);
{4} underline;
    writeln(reportFile);
  End;{RowsToreportTableCaptionTXT}

procedure RowsToReportTableCaptionEXCEL;
 var i:byte;
  procedure underline;
   begin
   write(reportFile,'=======|========|========|========|========|========|========|=======|=======|=========|=======|=======|');
    with form1 do
     begin
      if radiogroup12.ItemIndex=0 then write(reportFile,'=======|========|');
      if checkBox2.Checked        then write(reportFile,'========|=========|');
      if checkBox3.Checked        then write(reportFile,'=======|=========|');
      if checkBox4.Checked        then write(reportFile,'==========|=========|');
      if checkBox28.Checked       then write(reportFile,'==========|=========|');
     end;
    write(reportFile,'======|');
   end;
  Begin   //wyprowadza nagłówek do reportu - dane wyprowadzane z pętli RUN
   writeln(reportFile,'Results of histograms comparing with the information radius function');

   writeln(reportFile,'Global totals (sum of IR values over leaves of the quantization tree).'#13#10,
    #13#10'       IR = Information Radius',
    #13#10'     card = count of elements in a given set',
    #13#10'    error = error in a selftest.',
    #13#10'    count = total count of elements in a given cathegory group',
    #13#10'Note: errors for cathegories values are counts of classifications different from classifications dominating in a given clusters group');
   writeln(reportFile,#13#10'Table 1.'#13#10'IR means over all leaves at a given stage of the tree building and, if recquiread, over ',
                       Y1Name,', ',Y2Name,', ',Y3Name,' and ',Y4Name,' variable values clusters groups'#13#10,
                #13#10'NOTE: This report version should be opened with the MS Excel using the "|" as the separator sign.'#13#10);

{1} underline;
  (*  with form1 do
    If RadioGroup18.ItemIndex=1 then  //totals and cathegories
     begin
      if checkBox2.Checked then
      begin
      write(reportFile,Y1Name,'|======|=======|');
      for i:=0 to cath1Nbr-1 do write(reportFile,'======|======|======|');
      end;
      if checkBox3.Checked then
      begin
      write(reportFile,Y2Name,'|======|=======|');
      for i:=0 to cath2Nbr-1 do write(reportFile,'======|======|======|');
      end;
      if checkBox4.Checked then
      begin
      write(reportFile,Y3Name,'|======|=====|');
      for i:=0 to cath3Nbr-1 do write(reportFile,'======|======|======|');
      end;
      if checkBox28.Checked then
      begin
      write(reportFile,Y4Name,'|======|=====|');
      for i:=0 to cath4Nbr-1 do write(reportFile,'======|======|======|');
      end;
     end; *)
    writeln(reportFile);

{2} write(reportFile,'|      |isolat. |node addresses---------|||set  counts------------------|||iterations|fission|distortion|');
    with form1 do
     begin
      if radiogroup12.itemIndex=0 then write(reportFile,'Optimal component---------||');
      if checkBox2.Checked then write(reportFile,Y1Name,'------||');
      if checkBox3.Checked then write(reportFile,Y2Name,'------||');
      if checkBox4.Checked then write(reportFile,Y3Name,'------||');
     if checkBox28.Checked then write(reportFile,Y4Name,'------||');
     end;
    write(reportFile,'Time|');
 (*   with form1 do
    If RadioGroup18.ItemIndex=1 then    //totals and cathegories
     begin
      if  checkBox2.Checked then for i:=0 to cath1Nbr do write(reportFile,cath1CodeList[i]:7,' | | |');
      if  checkBox3.Checked then for i:=0 to cath2Nbr do write(reportFile,cath2CodeList[i]:7,' | | |');
      if  checkBox4.Checked then for i:=0 to cath3Nbr do write(reportFile,cath3CodeList[i]:7,' | | |');
      if checkBox28.Checked then for i:=0 to cath4Nbr do write(reportFile,cath4CodeList[i]:7,' | | |');
     end; *)
    writeln(reportFile);

{3} write(reportFile,'| step |treshold|  father|    son | brother| father |    son | brother|','number|','distance  |','          |');
    with form1 do
     begin
      if radiogroup12.itemIndex=0 then write(reportFile,'number|mean value|');
      if checkBox2.Checked then write(reportFile,'IR|error[%]|');
      if checkBox3.Checked then write(reportFile,'IR|error[%]|');
      if checkBox4.Checked then write(reportFile,'IR|error[%]|');
      if checkBox28.Checked then write(reportFile,'IR|error[%]|');
     end;
     write(reportFile,'   [sec]  |');
(*    with form1 do
    If RadioGroup18.ItemIndex=1 then  //totals and cathegories
     begin
      if  checkBox2.Checked then for i:=0 to cath1Nbr do write(reportFile,'    IR|maxim.| count|');
      if  checkBox3.Checked then for i:=0 to cath2Nbr do write(reportFile,'    IR|maxim.| count|');
      if  checkBox4.Checked then for i:=0 to cath3Nbr do write(reportFile,'    IR|maxim.| count|');
      if checkBox28.Checked then for i:=0 to cath4Nbr do write(reportFile,'    IR|maxim.| count|');
     end; *)
    writeln(reportFile);

{4} underline;
  (*  with form1 do
    If RadioGroup18.ItemIndex=1 then
     begin
      if  checkBox2.Checked then for i:=0 to cath1Nbr do write(reportFile,'======|======|======|');
      if  checkBox3.Checked then for i:=0 to cath2Nbr do write(reportFile,'======|======|======|');
      if  checkBox4.Checked then for i:=0 to cath3Nbr do write(reportFile,'======|======|======|');
      if checkBox28.Checked then for i:=0 to cath4Nbr do write(reportFile,'======|======|======|');
     end;  *)
    writeln(reportFile);
  End;{RowsToReportTableCaptionEXCEL}


 procedure RowsToReport(const step:word;const EventNbr, distMaxNodeAddr:longWord);//const cath11,cath12,pers1,pers2,cath31,cath32:byte);
   var
    t1,t3,t5,t6,t7,t8,t9,t10,t11:double;
    hour,minute,sec,msec:word;
    j:longint;
    k:word;
    k1,k2:longWord;
  Begin  //-----------------------------------RowsToReport---------------------------------
   decodeTime(startTime,hour,minute,sec,msec);
   j:=3600*hour+60*minute+sec;
   decodeTime(time,hour,minute,sec,msec);
   j:=-j+3600*hour+60*minute+sec;
   k1:=nodeprops[nodeHeap[distMaxNodeAddr].son].cardinal;
   k2:=nodeprops[nodeHeap[nodeHeap[distMaxNodeAddr].son].brother].cardinal;
   with form1 do
    begin
     if checkBox2.Checked then
      begin
       t1:=cath1IRGlob/(step+1);
       t3:=percNorm_glob*cath1RecErrSum;        //100*cath1RecErrSum/eventNbr       percNorm=100/evenNbr
      end;
     if checkBox3.Checked then
      begin
       t5:=cath2IRGlob/(step+1);
       t6:=percNorm_glob*cath2RecErrSum;      //100*cath2RecErrSum/eventNbr
      end;
     if checkBox4.Checked then
      begin
       t7:=cath3IRGlob/(step+1);
       t8:=percNorm_glob*cath3RecErrSum;     //100*cath3RecErrSum/eventNbr
      end;
     if checkBox28.Checked then
      begin
       t9:=cath4IRGlob/(step+1);
       t10:=percNorm_glob*cath4RecErrSum;     //100*cath4RecErrSum/eventNbr
      end;
     end;{with}
   t11:=distortion/EventNbr;
   write(reportFile,'| ',step:4,' |',rareEventNbr1:7,' |',distMaxNodeAddr:7,' |',nodeHeap[distMaxNodeAddr].son:7,
    ' |',nodeHeap[nodeHeap[distMaxNodeAddr].son].brother:7,' |',nodeprops[distMaxNodeAddr].cardinal:7,' |',k1:7,' |',
    k2:7,' |',nodeprops[distMaxNodeAddr].iterNbr:4,'|',nodeprops[distMaxNodeAddr].fissionDistance:10:3,'|',t11:10:3,'|');
    with form1, nodeprops[distMaxNodeAddr] do
     begin //------------------------------Table 1. IR,      recognition error--- to report  -----------------
      if radiogroup12.ItemIndex =0 then write(reportFile,OptComponentNbr:6,'|',centroid[OptComponentNbr]:10:3,'|');  //CART
      if checkBox2.Checked then write(reportFile,t1:7:3,'|',t3:7:3,'|');
      if checkBox3.Checked then write(reportFile,t5:7:3,'|',t6:7:3,'|');
      if checkBox4.Checked then write(reportFile,t7:7:3,'|',t8:7:3,'|');
     if checkBox28.Checked then write(reportFile,t9:7:3,'|',t10:7:3,'|');
     end;{with}
    write(reportFile,j:10,'|');
    form1.Label129.Caption:=intToStr(j);
   //--------------------------------------------------------------------------------------liczebności pomocnicze klastrów. gdy l=0, to l:=1, bo wtedy IR=0, a więc można dzielić przez 1. Wtedy również skalowany IR będzie =0.
   writeln(reportFile);
   with form1 do
  // if  checkBox25.Checked then     //averages
    begin
    (*
    IRdrawings_clipped(Panel:TPanel;canvas:tcanvas;const classNbr:Word; const  prevX,currX:double;
                      var prevY:double; currY:double; const wspy,topHeight:double; const lineColor:longInt);
    *)
     Label82.Caption:='Nbr of leaves'#13#10+intToStr(leafNodeNbr);
     //distortion plot:
     currX:=(step)*wspx2+panel2.left;
     if  checkBox25.Checked then IRdrawings(form1.Panel2,form1.canvas,CentroidsNb_glob,prevX,currX,prevDistortion,t11,wspy2,topHeight2,cl5);   //strech=prevDistortion:=nodeprops[0].meandistance,
     //IR plots:
     currX:=(step)*wspx3+panel3.left;
     if form1.checkBox2.Checked then begin Label75.Caption:=floatToStrF(t1,ffFixed,7,3);  if  checkBox25.Checked then   IRdrawings(form1.Panel3,form1.canvas,CentroidsNb_glob,prevX,currX,prevIRcath1,t1,wspy3,topHeight3,cl1)  end; //strech=IRStretch, clBlue
     if form1.checkBox3.Checked then begin Label76.Caption:=floatToStrF(t5,ffFixed,7,3);  if  checkBox25.Checked then   IRdrawings(form1.Panel3,form1.canvas,CentroidsNb_glob,prevX,currX,prevIRCath2,t5,wspy3,topHeight3,cl2)  end; //strech=IRStretch, clread
     if form1.checkBox4.Checked then begin Label77.Caption:=floatToStrF(t7,ffFixed,7,3);  if  checkBox25.Checked then   IRdrawings(form1.Panel3,form1.canvas,CentroidsNb_glob,prevX,currX,prevIRCath3,t7,wspy3,topHeight3,cl3)  end; //strech=IRStretch, clGreen
    if form1.checkBox28.Checked then begin Label150.Caption:=floatToStrF(t9,ffFixed,7,3); if  checkBox25.Checked then   IRdrawings(form1.Panel3,form1.canvas,CentroidsNb_glob,prevX,currX,prevIRCath4,t9,wspy3,topHeight3,cl4)  end; //strech=IRStretch, clYellow
      //recognition error plots:
     currX:=(step)*wspx4+panel4.left;
     if form1.checkBox2.Checked then begin Label45.Caption:=equStr(floatToStrF(t3,ffFixed,8,3),8);  if  checkBox25.Checked then  IRdrawings(form1.Panel4,form1.canvas,CentroidsNb_glob,prevX,currX,prevErrCath1,t3, wspy4,topHeight4,cl1) end; //strech=errStretch, clBlue
     if form1.checkBox3.Checked then begin Label46.Caption:=equStr(floatToStrF(t6,ffFixed,8,3),8);  if  checkBox25.Checked then  IRdrawings(form1.Panel4,form1.canvas,CentroidsNb_glob,prevX,currX,prevErrCath2,t6, wspy4,topHeight4,cl2) end; //strech=errStretch, clread
     if form1.checkBox4.Checked then begin Label108.Caption:=equStr(floatToStrF(t8,ffFixed,8,3),8); if  checkBox25.Checked then  IRdrawings(form1.Panel4,form1.canvas,CentroidsNb_glob,prevX,currX,prevErrCath3,t8, wspy4,topHeight4,cl3) end; //strech=errStretch, clGreen
    if form1.checkBox28.Checked then begin Label151.Caption:=equStr(floatToStrF(t10,ffFixed,8,3),8);if  checkBox25.Checked then  IRdrawings(form1.Panel4,form1.canvas,CentroidsNb_glob,prevX,currX,prevErrCath4,t10,wspy4,topHeight4,cl4) end; //strech=errStretch, clYellow
     prevX:=currX;
    end;{with}
  End;{RowsToReport}

  procedure ToRemoveSet(EventNbr:longWord;callChain:string);
   {
   Określić zbiór zdarzeń rzadkich, które mają być pominięte przy obliczaniu centroidów.
   rareEventNbr2 - liczebność, poniżej której zbiór będzie zaliczany do zbioru zdarzeń rzadkich; zdarzenia te będa wykluczane z obliczeń centroidów
  }
  procedure excludeSetMaker(const nodeAddr:longWord;callChain:string);
   var k,l:longWord;
   Begin
    callChain:=callChain+'>excludeSetMaker';
    if nodeHeap[nodeAddr].son>0 then  excludeSetMaker(nodeHeap[nodeAddr].son,callChain)
     else    //znaleziono liść, więc
      begin
       if nodeProps[nodeAddr].cardinal<=rareEventNbr2 then
        with nodeProps[nodeAddr] do
         begin
          for k:=lb to hb do includeToMegaSet(excludeEventsMegaSet,sbl[k]);
          inc(excludeSetCard,cardinal);  k:=hb-lb+1;
          if k<>nodeProps[nodeAddr].cardinal then error54(k,l,nodeProps[nodeAddr].leafIdx,'excludeSetMaker',callChain);
         end
      end;
     if nodeHeap[nodeAddr].brother>0 then  excludeSetMaker(nodeHeap[nodeAddr].brother,callChain)            //przejście na brata
   End;{excludeSetMaker}

   Begin  //-----------------------ToRemoveSet------------------
    callChain:=callChain+'>ToRemoveSet';
    if tryStrToInt(trim(form1.Edit13.Text),rareEventNbr2) then
    else
     with form1 do
     begin
      while not
      TrystrToInt(inputBox('Correct edit box text',form1.Edit13.Text+' is not correct integer number! Write eg.:',
       intToStr(round(0.5+EventNbr/(16*CentroidsNb_glob)))),rareEventNbr2) do;
      Edit13.Text:=intToStr(rareEventNbr2); label162.Caption:=edit13.Text;
     end;
    excludeSetCard:=cardMegaSet(excludeEventsMegaSet);
    form1.Label49.Caption:=intToStr(excludeSetCard);
    excludeSetMaker(0,callChain);
    form1.Label49.Caption:=intToStr(excludeSetCard);
    form1.Label6.Caption:='Now created';
   End;{ToRemoveSet}


procedure OpenTable2CollectionFile(callChain:shortString);

 procedure Table2CollectionHeader;
  Begin
   writeln(Table2CollectionFile,#13#10'New append, date: ',dateToStr(now)+' '+timeToStr(now));
   writeln(Table2CollectionFile,'This document contains data gathered in the table 2. supplied with all analysis conditions'#13#10,
    'The data will be added automaticaly  after each session to a chosen, existing *.txt file, which can contain data gathered in previous analyses or a new, not existing file or can be overwriten such a file');
   writeln(Table2CollectionFile,#13#10'Note!''This document is intended for opening and processing wit the MS EXCEL program.'#13#10'The opening should use the"|" sign as the table columns delimitier'#13#10);
   writeln(Table2CollectionFile,'Y - means "Yes"'#13#10'N - means "Not"'#13#10'* - means "does not concern to..."');
   write(Table2CollectionFile,'|======|============|============|======|=======|=========|===================|==========|===========|');writeln(Table2CollectionFile,'=====|============|================|=========|=============|===============|=========|=========|=======|======|=======|=======|============||========|========|========|========||========|========|========|========|');
   write(Table2CollectionFile,'|      |            |            |      |       |         |Spectrum analyses  |          |           |');writeln(Table2CollectionFile,'     |            |                |         |             |               |         |         |       |      |       |       |            ||Information Radius||||Auto Error [%]||||');
   write(Table2CollectionFile,'|report| report     |report crea-|Stream|Nbr of |Processed|checkboxes settings|Resulting |Sets divi- |');writeln(Table2CollectionFile,'CART-|Kind of set |Classifier for  |Training |Kind of feat.|Classifier for |Training |standard.|y[0]:=0|nbr of|distor-|Averag.|nbr of aver.||--------|--------|--------|--------||--------|--------|--------|--------|');
   write(Table2CollectionFile,'|nbr   | file       |ted at the  |nbr   |events |file     | Output  |standard.|feat. set:|ding method|');writeln(Table2CollectionFile,'like |choice crit.|set choice crit.|supervis.|choice crit. |features choice|supervis.|         |       |steps |tion   |[ms]   |slides      ||',y1Name:8,'|',Y2Name:8,'|',y3Name:8,'|',y4Name:8,'||',y1Name:8,'|',y2Name:8,'|',y3Name:8,'|',y4Name:8,'|');
   write(Table2CollectionFile,'|======|============|============|======|=======|=========|=========|=========|======================|');writeln(Table2CollectionFile,'=====|============|================|=========|=============|===============|=========|=========|=======|======|=======|=======|============||========|========|========|========||========|========|========|========|')
   //                               6        12            12      6     7          9                             10          11                                         5      12          16                 9            13          15            9            9      7       6      7       7       12             8            8            8            8            8             8
   //                               1         2             3      4     5          6                              7           8                                         9      10          11                12            13          14           15           16     17      18     19      20       21            22           23           24            25           26           27
  End;{Table2CollectionHeader}

  function AppendOrRewrite:boolean;
   Begin
   result:=
     messageDlg('Append or Rewrite the "'+Table2CollectionFileDir+'"?'#13#10'File "'+Table2CollectionFileDir+'"exists.'#13#10+
      'Would you Append the current table 2 results to this collection, or rewrite it?'#13#10+
      '"No" - means you have choosed "Rewrite it" or create a new one, with different name, '#13#10'while'#13#10'"Yes" - means "Append" to it''',mtConfirmation,mbyesNo,0)=mrYes
    //Table2CollectiontFileOpened:=true;
   End;{AppendOrRewrite}

   procedure fileSaveDialog;
    var logos:boolean;
    Begin
       repeat
        logos:=SaveDialog(form1.SaveDialog1,Table2CollectionFileDir,2,callChain+'>"Table2Collection file saving"');
        if logos then
        begin
         try
          AssignFile(Table2CollectionFile,Table2CollectionFileDir);
          Rewrite(Table2CollectionFile)
         except
          logos:=false;
          error36(Table2CollectionFileDir);
         end;
         Append(Table2CollectionFile)
        end
       until logos;
    End; {fileSaveDialog}

   Begin       //----------------------------------------OpenTable2CollectionFile---------------------
    callChain:=callChain+'>OpenTable2Collection';
    if perfCounter=1 then //
     begin
      Table2CollectiontFileOpened:=false;
      if fileExists(Table2CollectionFileDir)  then  //or not directoryExists(extractFileDir(Table2CollectionFileDir)) 17082023
       Begin
       if AppendOrRewrite then
        begin
         try
          AssignFile(Table2CollectionFile,Table2CollectionFileDir);
          Append(Table2CollectionFile)
         except
          error37;
         end;
         end
       else fileSaveDialog;{not AppendOrRewrite}
       form1.edit39.Text:=Table2CollectionFileDir
       end
      else fileSaveDialog; {file exists}
      Table2CollectiontFileOpened:=true;
      Table2CollectionHeader;
     end;
   End;{OpenTable2CollectionFile}

 procedure OpenReportFile(callChain:shortString);

 Begin
  callChain:=callChain+'>OpenReportFile';
  reportFileOpened:=false;
  if fileExists(reportFileDir) or not directoryExists(extractFileDir(reportFileDir)) then
   if not SaveDialog(form1.SaveDialog1,reportFileDir,2,callChain+'>"report file saving"') then //7=*report*.txt
   begin
    showMessage('The final report will not be created. The old one, namely "'+reportFileDir+'" remains,'#13#10'the program will be halted now!');
    halt;
   end;
  AssignFile(reportFile,reportFileDir);
  try
  rewrite(reportFile);
  except
  error36(reportFileDir);
  end;
  form1.edit17.Text:=reportFileDir;
  OpenTable2CollectionFile(callChain);
  form1.edit17.Text:=reportFileDir;
  reportFileOpened:=true;   reportDate:=dateToStr(now)+' '+timeToStr(now);
  writeln(reportFile,'Program written in the Delphi 12 (32-bit)');
  writeln(reportFile,'Vector Quantization.'#13#10,'report created at the '+reportDate,'.');
  writeln(reportFile,'Report file            "',reportFileDir,'"');
  writeln(reportFile,'Table2 Collection File "',Table2CollectionFileDir,'"');
  writeln(reportFile,'Processed file         "',inpFileDir,'"');
  flush(reportFile);
 End;{OpenreportFile}

 function openTreeFile(var treeFileDir:shortString;callChain:string):boolean;
  var s:string;
  Begin
   callChain:=callChain+'>openTreeFile';
   result:= openDialog(form1.OpenDialog1,treeFileDir,2,callChain+'>"Open tree data file for exclude set reading"',form1.edit18,callChain);
   if not result then with form1 do
    begin
     s:='Session with the mode "'+RadioGroup3.Items[1]+'" was given up, the switch "'+radioGroup3.Caption+'" was turned on to the "'+radiogroup3.Items[0]+'" position .';
     showMessage(s);
     radioGroup3.ItemIndex:=0;
     writeln(reportFile,S);
     flush(reportFile);
    end
   else writeln(reportFile,'Quantization tree file for exclude set read from "',treeFileDir,'"');
  End; {openTreeFile}

  function checkIncludeTreshold(newVal:word):word;
  //check modifications of nc variable - keep it in acceptable range
   begin
    if (newVal>vectorsSize-1) or (newVal<=0) then result:=vectorsSize-1
    else result:=newVal;
    form1.Edit1.Text:=intToStr(result);
    form1.Label144.Caption:=intToStr(result); form1.Label86.Caption:=intToStr(result);
   end;{checkIncludeTreshold}

 procedure lifterCutOffChecker(callChain:string);
  Begin
   callChain:=callChain+'>lifterCutOffChecker';
  if nc>vectorsSize then
   begin
    error71(nc,vectorsSize,callChain);
    nc:=vectorsSize;
    form1.Edit1.Text:=intToStr(nc);  form1.Label144.Caption:=intToStr(nc); form1.Label86.Caption:=intToStr(nc);
   end;
   initWrite(callChain);
   form1.label86.Caption:=intToStr(nc);  form1.Label144.Caption:=intToStr(nc);  // label86   lifter cut-off (on pageControl2 i.e. certificate)
  End;{lifterCutOffChecker}

 procedure spcInputFileParameters(callChain:string);

  Begin          //called as radio:   10-filter   9-scaling const  11, 33 spectra and F0 windows shapes
   callChain:=callChain+'>spcInputFileParameters';
   with form1 do                                                                     //dataRecord
   begin
    RadioGroup11.ItemIndex:=paramRec.pWinShape;  //weighting windows shapes
    RadioGroup33.ItemIndex:=paramRec.pF0WinShape;
    lifterCutOffChecker(callChain);
   end;
  End; {spcInputFileParameters}

 procedure txtInputFileParameters({var RadioGroup11:TRadioGroup;var label1:Tlabel;}callChain:string);
  Begin
   with form1 do          //dataRecord do
   begin
    RadioGroup11.ItemIndex:=-1;  //weighting windows shape
    RadioGroup33.ItemIndex:=-1;  //F0 weighting windows shape
    label86.Caption:=intToStr(nc);//label1.Caption:=xxx;        //cepstrum filter cut-off     09082020 changed
    Label144.Caption:=intToStr(nc);
   end;
  End; {txtInputFileParameters}

 procedure spcDataParameters(var EventNbr:longWord;callChain:string);
  //reads  data parameters from a file

  Begin
   callChain:=callChain+'>spcDataParameters';
   form1.Edit15.Text:=intToStr(EventNbr);                       // "Whole Sample"                             //round(vect[0]);
   with form1.Edit1 do if not tryStrToInt(trim(Text),nc) then showMessage(Text+' is not an integer number!');//nc:=round(vect[1]);
   FFTwindowsWidth:=d_count;//signal[0];
   form2.edit8.Text:=intToStr(FFTwindowsWidth);                                                                     //vect[3]); //Orig:=round(signal[0]);
   cath1Nbr:=phonNbr;    //byte(cath1);
   cath2Nbr:=personNbr; //byte(cath2);
   cath3Nbr:=genderNbr;//byte(cath3);
   cath4Nbr:=ageNbr;  //byte(cath4);
   with form1 do spcInputFileParameters({RadioGroup11,RadioGroup33,label86,}callChain);
   frameStep:=Jump*1000/rate;
   write(reportFile,'Wave file: ');
   if fileExists(waveFileDir) then writeln(reportFile, '"',waveFileDir,'"')
   else writeln(reportFile,' has not been found');
   with form1 do
    begin
     if checkBox30.Checked then //"Remove Time Constant Contribution"
      begin
       edit20.Text:=floatToStr(averagingTime);
       edit21.Text:=intToStr(NbrOfFrames);
       Edit22.Text:=floatToStr(frameStep);
       Edit23.Text:=floatToStr(rate);
      end
     else
      begin
       Edit22.Text:=XXX;  Edit23.Text:=XXX;
      end;
     edit25.Text:=edit20.Text;
     edit24.Text:=edit21.Text;
     edit26.Text:=edit22.Text;
     edit27.Text:=edit23.Text;
    end;{with form1}
  End; {spcDataParameters}

 procedure txtDataParameters(var EventNbr:longWord;callChain:string);
 //reads the data parametersfrom of the *.txt file
  var s:shortString; c:integer;

  function name(var s:shortString;i:byte):shortString;
  //reads cath. variables names from header
   begin //-----------------name--------------
    result:='';
    while  (s[1] in [#0..#32]) and (length(s)>0) do delete(s,1,1);
    while  not (s[1] in [#0..#32]) and (length(s)>0) do
     begin
      result:=result+s[1];
      delete(s,1,1);
     end;
    if result='' then result:='Y'+intToStr(i);
   end;{name}

  Begin  //======================txtDataParameters==================
   callChain:=callChain+'>txtDataParameters';
   try
    repeat
     readln(txtEventFile,s);
     while  (s[1] in [#0..#47]) and (length(s)>0) do delete(s,1,1); //skip trailing nonvisual signs, spaces and other chars
     c:=pos(' ',s);
     val(copy(s,1,pos(' ',s)-1),eventNbr,c);
     if c<>0 then
      begin
       c:=pos(#9,s);
       val(copy(s,1,pos(#9,s)-1),eventNbr,c);
      end
    until c=0;                                                  //events data
    form1.Edit15.Text:=intToStr(EventNbr);                      //edit15 - whole sample
    readln(txtEventFile,vectorsSize,s);
    //dec(vectorsSize);                        //number of vectors components
    form1.Edit35.Text:=intToStr(vectorsSize+1);
    if nc>vectorsSize-1 then
     begin
     with form1 do
      showMessage('The "'+label1.Caption+'"='+edit1.text+', was bigger than vectors size, i.e. ='+
                   intToStr(vectorsSize-1)+'. It will be assigned the "'+intToStr(vectorsSize-1)+' value for now.'#13#10+
                   'Change it if necessary'#13#10'To check and correct to suitable value the "'+form1.Label1.Caption+
                   '" at the "'+form1.TabSheet1.Caption+ '(click the "'+form1.mainmenu1.Items[2].Caption+'" at the main menu).');
      Application.ProcessMessages;
      nc:=checkIncludeTreshold(nc);
     end;
    form1.Label144.Caption:=intToStr(vectorsSize); form1.Label86.Caption:=intToStr(vectorsSize);  //vector cut-off, lifter cut-off (the same)

    setLength(dataRecord.vect,vectorsSize+1);
    FFTwindowsWidth:=2*vectorsSize-1;
    readln(txtEventFile,txtStretch,s);                          //components values range
    readln(txtEventFile,s); //header
   except
    error100;
   end;

   y1Name:=name(s,1);  form1.edit30.Text:=y1Name;
   Y2Name:=name(s,2);  form1.edit31.Text:=y2Name;
   y3Name:=name(s,3);  form1.edit32.Text:=y3Name;
   y4Name:=name(s,4);  form1.edit37.Text:=y4Name;
   YnameActualize;

   with form1 do
    begin
     Edit1.text:=intToStr(nc); label86.Caption:=edit1.Text
    end;
   form1.edit8.Text:=xxx;                                      //FFT signal portions
   s:='';
   with form1 do txtInputFileParameters({RadioGroup11,label86,}callChain);    form1.Label144.Caption:=intToStr(vectorsSize);
   with form1 do
    begin
     if checkBox30.Checked then
     else
      begin
       edit20.Text:=xxx;
       edit21.Text:=XXX;
       edit22.Text:=XXX;
       edit23.Text:=XXX;
      end;
      edit25.Text:=edit20.Text;
      edit24.Text:=edit21.Text;
      edit26.Text:=edit22.Text;
      edit27.Text:=edit23.Text;
   end;{with}
   with form1.checkbox32 do begin Checked:=true; enabled:=false end;
   writeln(reportFile,'Wave file - does not apply here');
  End; {txtDataParameters}

 function standardise(var vect:TsingleArr):extended;
    var  sum,sumsq,mean,stDev:Extended;
     j,k:word;
    begin
     sum:=0;sumsq:=0; k:=0;
     if form1.CheckBox45.Checked then vect[0]:=0;
     for j:=0 to nc do  if inMegaSet(j,featureMegaSet) then
      begin
       inc(k);
       sum:=sum+vect[j];
       sumsq:=sumsq+vect[j]*vect[j];
      end;
      mean:=sum/k;
      stDev:=Sqrt(sumsq/k-mean*mean);
      if stDev>0 then
       for j:=0 to nc do   if inMegaSet(j,featureMegaSet) then  //standardise vector
        vect[j]:=(vect[j]-mean)/stDev
        else vect[j]:=0
      else
       for j:=0 to nc do    //standardise vector
        vect[j]:=0;
     result:=stDev;
    end;{standardise}

procedure txtPreprocessor(const n:longWord;var dataRecord:TdataRecord);
 var i:word;
 Begin
  with dataRecord do
   begin
      for i:=0 to nc do dataRecord.vect[i]:=vectList0[n,i];
      if form1.CheckBox13.Checked then  showTxtInputRecord(form1.panel2,dCath1,dCath2,dCath3,dCath4,txtStretch,xDescr_Glob);
      if form1.CheckBox39.Checked then vectStDev:=standardise(vect);
      if form1.CheckBox13.Checked then  //"Show input graphics", panel1
      if form1.CheckBox39.Checked then showTxtInputRecord(form1.panel3,dCath1,dCath2,dCath3,dCath4,2,xDescr_Glob)
     end;{with}
 End;{txtPreprocessor}

procedure txtInputer(const n:longWord;var dataRecord:TdataRecord);
 //czyta cały rekord z wejścia i odpowiednio do opcji podstawia pod wyjście jeden z wektorów parametrow


 procedure cath1SetAndListCreate(const sp:AnsiChar;var j:byte);
  Begin
   if not (sp in cath1Set) then
    begin
     inc(j);
     if j>=high(cath1CodeList) then with form1 do
      begin
       setLength(cath1CodeList,j+1+j div 5);
       if checkBox2.Checked then edit9.Text:=intToStr(j);

      end;
     cath1CodeList[j]:=sp;                 //dekoder znaków fonematycznych
     cath1Hash[sp]:=j;                 //koder znaków fonematycznych
     include(cath1Set,sp);
    end; {if}
  End;{cath1SetAndListCreate}

 procedure cath2SetAndListCreate(const sp:AnsiChar;var k:byte);

  Begin
   if not (sp in cath2Set) then
    begin
     inc(k);
     if k>=high(cath2CodeList) then with form1 do
      begin
       setLength(cath2CodeList,k+1+k div 5);
       if checkBox3.Checked then edit10.Text:=intToStr(k);
      end;
     cath2CodeList[k]:=sp;           //dekoder osobników
     cath2Hash[sp]:=k;               //koder osobników
     include(cath2Set,sp);
    end;
  End;{cath2SetAndListCreate}

 procedure cath3SetAndListCreate(const sp:AnsiChar;var l:byte);
  Begin
   if not (sp in cath3Set) then
    begin
     inc(l);
     if l>=high(cath3CodeList) then with form1 do
      begin
       setLength(cath3CodeList,l+1+l div 5);
       if checkBox4.Checked then edit11.Text:=intToStr(l);
      end;
     cath3CodeList[l]:=sp;           //dekoder kategorii gender
     cath3Hash[sp]:=l;               //koder kategorii gender
     include(cath3Set,sp);
    end;
   End;{cath3SetAndListCreate}

  procedure cath4SetAndListCreate(const sp:AnsiChar;var l:byte);
  Begin
   if not (sp in cath4Set) then
    begin
     inc(l);
     if l>=high(cath4CodeList) then with form1 do
      begin
       setLength(cath4CodeList,l+1+l div 5);
       if checkBox28.Checked then edit38.Text:=intToStr(l);
      end;
     cath4CodeList[l]:=sp;           //dekoder kategorii gender
     cath4Hash[sp]:=l;               //koder kategorii gender
     include(cath4Set,sp);
    end;
   End;{cath4SetAndListCreate}

  function skipper:AnsiChar;

  procedure skipIntroductoryInfo;      //used to skip introductory info, when new session begins.
   var k,c: longint; s:shortString;   //In the first session (i.e. when sessionCounter=0)
   Begin                             //this is done in the procedure with the procedure
    try                             //txtDataParameters
     repeat
      readln(txtEventFile,s);
      while  (s[1] in [#0..#47]) and (length(s)>0) do
       delete(s,1,1); //skip trailing nonvisual signs, spaces and other chars
      c:=pos(' ',s);
      val(copy(s,1,pos(' ',s)-1),k,c);
      if c<>0 then
      begin
       c:=pos(#9,s);
       val(copy(s,1,pos(#9,s)-1),k,c);
      end
     until c=0;                  //nbr of events
     readln(txtEventFile,k,s);  //number of vectors components
     readln(txtEventFile,k,s); //components values range
     readln(txtEventFile,s);  //header
    except
     error100;
    end;
   End;{skipIntroductoryInfo}

  Begin      //--------skipper---------------
   repeat
   if not eof(txtEventFile) then read(txtEventFile,result)
   else
    begin  //start reading from beginning
     reset(txtEventFile);
     skipIntroductoryInfo; result:=#0;
    end;
   until not (result in [#0..#32]); //(result<>' ') and  (result<>#9);
  End;{skipper}

  var i:word;
  Begin    //================== txtInputer =================
   with dataRecord do
    begin
     try
      dCath1:=skipper;
      dCath2:=skipper;
      dCath3:=skipper;
      dCath4:=skipper;
      with dataRecord do
       begin
        eventCath1[n]:=dCath1;   cath1SetAndListCreate(dCath1,cath1Count);  form1.Label31.Caption:=dCath1;
        eventCath2[n]:=dCath2;   cath2SetAndListCreate(dCath2,cath2Count);  form1.Label32.Caption:=dCath2;            //+#13#10'nbr='+intToStr(byte(cath2)-65);
        eventCath3[n]:=dCath3;   cath3SetAndListCreate(dCath3,cath3Count);  form1.Label33.Caption:=dCath3;
        eventCath4[n]:=dCath4;   cath4SetAndListCreate(dCath4,cath4Count);  form1.Label148.Caption:=dCath4;
       end;{with}
      control1:=high(dataRecord.vect);   //debug prp 210319
      for i:=0 to nc do
      read(txtEventFile,vect[i]);
      readln(txtEventFile);
     except
      error100;
     end;
     for i:=0 to nc do vectList0[n,i]:=dataRecord.vect[i];     //txtPreprocessor: for i:=0 to nc do dataRecord.vect[i]:=vectList0[n,i]; instead
     if form1.CheckBox13.Checked then  showTxtInputRecord(form1.panel2,dCath1,dCath2,dCath3,dCath4,txtStretch,xDescr_Glob);
     if form1.CheckBox39.Checked then vectStDev:=standardise(vect);
     if form1.CheckBox13.Checked then  //"Show input graphics", panel1
     if form1.CheckBox39.Checked then showTxtInputRecord(form1.panel3,dCath1,dCath2,dCath3,dCath4,2,xDescr_Glob)
    end;{with}
  End; {txtInputer}

 procedure setTXTclassifiersNumbers(i,j,k,l:byte);

  Begin  //------setTxtClassifiersNumbers-------
   if not spc_txt then
   with form1 do
    begin
     cath1Nbr:=card(Tset(cath1Set));
     if checkBox2.Checked then Edit9.Text:=intToStr(cath1Nbr);
     cath2Nbr:=card(Tset(cath2set));
     if checkBox3.Checked then Edit10.Text:=intToStr(cath2Nbr);
     cath3Nbr:=card(Tset(cath3Set));
     if checkBox4.Checked then Edit11.Text:=intToStr(cath3Nbr);
     cath4Nbr:=card(Tset(cath4Set));
     if checkBox28.Checked then Edit38.Text:=intToStr(cath4Nbr);
    end
   else error260('setTXTclassifiersNumbers');
  End; {setTXTclassifiersNumbers}

 procedure DataPrepare1(callChain:String);

  Begin    //----------------------------DataPrepare1;-------------------
    callChain:=callChain+'>DataPrepare1';
    form1.PageControl2.ActivePageIndex:=1;
     case form1.RadioGroup17.ItemIndex of   //txt|excel switch
     0 : begin
          RowsToReportTableCaption:=RowsToReportTableCaptionTXT;
          H0ToReport:=H0ToReportTXT
         end;
     1 : begin
          RowsToReportTableCaption:=RowsToReportTableCaptionEXCEL;
          H0ToReport:=H0ToReportExcel
         end;
    end;{case}
    with form1 do
    begin
     groupbox1.Visible:=true; button3.Visible:=not groupbox1.Visible; RadioGroup2.Enabled:=false; GroupBox6.Enabled:=false;
     CheckBox36.Enabled:=false; Edit29 .Enabled:=false;
    end;
    with form1 do
     if CheckBox36.Checked then
      label123.Caption :='Data reading will be broken at '+edit29.Text+#13#10'click the "'+button22.Caption+'" button to change it!'
     else label123.Caption :='';
    cath1Set:=[]; cath2Set:=[]; cath3Set:=[]; cath4Set:=[];
    form2.Visible := true;
   end;{dataPrepare1}

function radiogroupIdx(s:shortString):byte;
     var j:byte;
     begin
      s:=spacesRemove(copy(S,1,pos('.',S)-1));
      j:=strToInt(s);
      case j of
        0: result:=0;
        1: result:=1;
        2: result:=11;
        3: result:=2;
        4: result:=5;
        5: result:=4;
        6: result:=3;
        7: result:=7;
        8: result:=10;
        9: result:=9;
       10: result:=8;
       11: result:=6;
      end;{case}
    End;{radiogroupIdx}

   procedure streamRadioDescr;

    procedure radDescr(radioGroup:TradioGroup);
     var i:integer;
     Begin
      with radiogroup do
       begin
        for i:=0 to ComponentCount-1 do Items[i]:=XXX;
        if not spc_txt then
         begin
          radioGroup.ItemIndex:=-1;
          exit //120519
         end;
        for i:=0 to nbrOfStreams-1 do
         begin
         // k:=radiogroupIdx(StreamNamesArr[i]); //debug prp 100519
         // s:=StreamNamesArr[i];                //debug prp 100519
          Items[radiogroupIdx(StreamNamesArr[i])]:= StreamNamesArr[i];
         end;
        ItemIndex:=radiogroupIdx(StreamNamesArr[StreamIdx]);
       end;{with}
     End;{radDescr}

    Begin //==================streamRadioDescr===============
     with form1 do
      begin
       radioGroup2.Enabled:=false;
       radDescr(radioGroup2);
       radioGroup8.Columns:=2;
       radDescr(radioGroup8);
      end;{with}
    End;{streamRadioDescr}

 procedure minMaxReset;
  var i:word;
   begin
   for i:=0 to vectorsSize do
     with minMax[i] do
      begin
       min:=high(smallInt);
       max:=low(smallInt);
     end;{for with}
   end;{minMaxReset}

procedure constantContributionRemove(panel:Tpanel; var vect:Tvect; n:longword; const xDescr:shortString);  //TXT
  var i,j:word;
   Begin
    i:=n mod NbrOfFrames;                                                                             //running over buffer-ring (history) (bieg po pierścieniu buforująym)
    for j:=0 to vectorsSize do if inMegaSet(j,featureMegaSet) then meanVector[j]:=meanVector[j]-History[i][j];  //time constant contribution (odejmij od średniej jej pierwszy (najstarszy) składnik)
    for j:=0 to vectorsSize do if inMegaSet(j,featureMegaSet) then
     History[i][j]:=vect[j]/NbrOfFrames;                                                              //introduce features vector into the buffer ring (wprowadź wektor cechy do bufora (historii))
    for j:=0 to vectorsSize do if inMegaSet(j,featureMegaSet) then meanVector[j]:=meanVector[j]+History[i][j];  //add the latest component  to the mean (dodaj do średniej najnowszy składnik)
    for j:=0 to vectorsSize do if inMegaSet(j,featureMegaSet) then vect[j]:=(vect[j]-meanVector[j]);          //remove time constant contribution (usuń składową czasową stałą z aktualnego wektora cech)
    for j:=0 to vectorsSize do if inMegaSet(j,featureMegaSet) then vectList[n,j]:=vect[j];
    if form1.CheckBox13.Checked then showModifiedInput(panel,form1.CheckBox39.Checked,xDescr);                                               //show input graphics
   End;{constantContributionRemove}

 procedure stepWait;
  Begin
   if form1.CheckBox15.Checked then        //stepwise reading WAIT
     begin
      repeat
       application.ProcessMessages
      until showNextVect or not form1.CheckBox15.Checked;
      showNextVect:=false
     end;{if}
  End;

  procedure minMaxDetermination(var dataRecord:TdataRecord;const i:longWord);
   var  j:word;
   Begin
    control2:=high(vectList[0]); control3:=high(dataRecord.vect);  //debug prp
     with dataRecord do    //oznaczyć wartości skrajne  dla każdej składowej wektora cech niezależnie od tego, czy została użyta, bądź wogóle określona
      begin
       control1:=high(minMax); control2:=high(dataRecord.vect);   //debug prp
       for j:=0 to nc do with minMax[j] do
        begin
         if vect[j]<min then min:=vect[j];
         if vect[j]>max then max:=vect[j];
        end;{for}
      dCath1:=eventCath1[i]; dCath2:=eventCath2[i]; dCath3:=eventCath3[i];  dCath4:=eventCath4[i];
     end;{with dataRecord}
   End;{minMaxDetermination}

 procedure TXTvectorAndCathListRead(const eventNbr:longWord);  //;xDescr:shortString u. 11082020
 {
  Odczytuje z dysku listę wektorów cech (listę zdarzeń, czyli listę przekrojów spektralnych lub cepstralnych)
  oraz ich klasyfikatory cath1, cath2, cath3, cath4 (transkrypcję, osobę, plec, wiek)
 }
  var     i:longWord;

 procedure txtGraphCaptions;
  Begin
   with form1 do
   begin
    CheckBox36.Enabled:=false;                                       //check - "Break data reading at:"
    Edit29 .Enabled:=false;                                          //edit - "Break data reading at:"
    if form1.checkBox30.Checked then
     begin
      panel4.visible:=True;    // added 240311; check30 = Remove Time Constant Contribution
      label60.Caption:='Time mean';
      if CheckBox30.Checked then
       if CheckBox39.Checked then Label157.Caption:='Time constant removed && standardised'
       else Label157.Caption:='Time constant removed';
     end;
    label60.visible:=checkBox30.Checked;
    label157.visible:=checkBox30.Checked;
    label100.visible:=False;              //panel 7 caption='Cardinals (manyness...'
    application.ProcessMessages;          //+label101.top:=label100.top
    with Label56 do begin Visible:=true; caption:='Original data vector' end;
    with Label57 do                       //panel 3 caption=Standardised data vector
     begin
      Visible:=CheckBox39.Checked;
      if checkbox45.Checked then  caption:='Standardised data vector, zero component:=0'
      else caption:='Standardised data vector, orig. zero comp. included'
     end;
    application.ProcessMessages;  //+ label100.caption:='Mean'
   end;
  End; {txtGraphCaptions}

  var j:word;
  Begin  //-------------------------TXTvectorAndCathListRead--------------------------
   minMaxReset;
   control1:=high(vectList); control2:=high(eventCath4);                  //debug prp
   blindFrames(clBlack);
   txtGraphCaptions;
   cath1Count:=0; cath2Count:=0;cath3Count:=0; cath4Count:=0;             //set cath. values counters to 0
    i:=0;
   while (i<EventNbr) and not stopReading do                              //not (eof(eventFile)) do   ten strażnik nie sprawdza się!, czyta tylko do 941847 elementów z pliku....
    begin
     if  form1.checkBox36.Checked and (i>=(BreakReadingPoint-1)) then     //check36="break data reading at"
    begin stopReading:=true; form1.button22.Enabled:=true end;            //przerwać czytanie w pkcie BreakReadingPoint
     control3:=i;                                                         //debug prp
     inputer(i,dataRecord);                                               //read(eventFile,dataRecord);
     if form1.checkBox30.Checked then constantContributionRemove(form1.panel4,dataRecord.vect,i,xDescr_glob);
     for j:=0 to nc do vectList[i,j]:=dataRecord.vect[j];
     minMaxDetermination(dataRecord,i);
     inc(i);
     form1.label10.Caption:=intToStr(i);   Application.ProcessMessages;
     stepWait;
    end;{while}
   if not stopReading then
    begin
     writeln(reportFile,EventNbr,' vectors  was read.');
     if i<>EventNbr then error6(i,EventNbr)
     else
    end
   else                                 //przerwano czytanie, więc skrócić tablice
    begin
     writeln(reportFile,i,' vectors of ',EventNbr,' was read.');
     readEventNbr:=i;                       //Uwaga, próba obcięcia tablic przez setLength(*,i) nie powiodła się!, program daje złe wyniki po takiej akcji....
     try
     setLength(vectList,i+1,nc+1); //EventNbr+1
     setLength(eventcath1,i+1);
     setLength(eventcath2,i+1);
     setLength(eventcath3,i+1);
     setLength(eventcath4,i+1);
     setLength(wbl,i);
     setLength(sbl,i);
     except
     error48;
     end;
    end;{stopReading}
   form1.PageControl2.Visible:=false;
   form1.RadioGroup2.Enabled:=false;
   form1.WindowState:=wsMaximized; Application.ProcessMessages;
   form1.Edit12.Text:=intToStr(eventNbr);      //read eventNbr
   form1.label155.Caption:=form1.Edit12.Text;
   windows.beep(400,200);
   flush(reportFile);  //dataRead:=True; blok 22082022
  End;{TXTvectorAndCathListRead}

 procedure setSPCclassifiersNumbers(i,j,k,l:byte);
   {
   cath#Nbr are updated here to true values of sets elements counts
   }

  Begin  //------setSpcClassifiersNumbers-------
   if spc_txt then
   with form1 do   //update
    begin
     cath1Nbr:=card(Tset(cath1Set));
     if i<>cath1Nbr then error26(y1Name,i,cath1Nbr);
     if checkBox2.Checked then Edit9.Text:=intToStr(cath1Nbr);
     cath2Nbr:=card(Tset(cath2set));
     if j<>cath2Nbr then error26(y2Name,j,cath2Nbr);
     if checkBox3.Checked then Edit10.Text:=intToStr(cath2Nbr);
     cath3Nbr:=card(Tset(cath3Set));
     if k<>cath3Nbr then error26(y3Name,k,cath3Nbr);
     if checkBox4.Checked then Edit11.Text:=intToStr(cath3Nbr);
     cath4Nbr:=card(Tset(cath4Set));
     if l<>cath4Nbr then error26(y4Name,l,cath4Nbr);
     if checkBox28.Checked then Edit38.Text:=intToStr(cath4Nbr);
    end
    else error260('setSpcClassifiersNumbers');
  End; {setSpcClassifiersNumbers}

procedure spcPreprocessor(const k:longword; var dataRecord:TdataRecord);
 //kontrolnie wyswietla wektory cech zdarzen
 //shows events features vectors for control purposes
  var i:word;
  Begin
   with dataRecord do    //oznaczyć wartości skrajne  dla każdej składowej wektora cech niezależnie od tego, czy została użyta, bądź wogóle określona
    begin
     control2:=high(vectList[k]); control3:=high(dataRecord.vect);  //debug prp
     for i:=0 to nc do if inMegaSet(i,featureMegaSet) then
      begin
       control1:=i; control2:=high(vect); control3:=high(vectList0[0]);                    //debug prp 12072022
       vect[i]:=vectList0[k,i];
      end;{for}
     dCath1:=eventCath1[k]; dCath2:=eventCath2[k]; dCath3:=eventCath3[k];  dCath4:=eventCath4[k]; F0:=F0Arr[k];
    if form1.CheckBox13.Checked then showSpcInputRecord(form1.panel2,dCath1,dCath2,dCath3,dCath4,FFTwindowsWidth,drawingsArr[StreamIdx].yRange,false,xDescr_Glob);  //check13: "Show input graphics"
    //                               showSpcInputRecord(form1.panel3,dCath1,dCath2,dCath3,dCath4,FFTwindowsWidth,6,form1.CheckBox39.Checked,xDescr_Glob);
    if form1.CheckBox39.Checked then //"standardise events
      vectStDev:=standardise(vect);   //standardise vector, vectStDev - not used for now...
    if form1.CheckBox13.Checked and form1.CheckBox39.Checked then
    showSpcInputRecord(form1.panel3,dCath1,dCath2,dCath3,dCath4,FFTwindowsWidth,6,form1.CheckBox39.Checked,xDescr_Glob);
   end;{with dataRecord}
  End; {spcPreprocessor}

 procedure SPCvectorAndCathListRead(var eventNbr:longWord);  //;const xDescr:shortString u. 11082020
 {
  Odczytuje z dysku listę wektorów cech (listę zdarzeń, czyli listę przekrojów spektralnych lub cepstralnych)
  oraz ich klasyfikatory cath1, cath2, cath3, cath4 (transkrypcję, osobę, plec, wiek)
 }
  var i:longWord; j:word;

   procedure spcGraphCaptions;
   //captions for original data input control graphs
    Begin
     with form1 do
      begin
       label56.Visible:=true;  //Signal portions, panel2
       label56.Caption:=StreamNamesArr[StreamIdx];
       case StreamsNbrs[StreamIdx] of //in the case statement we call  streams ID, these are however specified in the StreamsNbrs array
         0: begin  //original signal
             checkbox32.Visible:=false;  //fullPlot
            end;
         1,3..6,11:  //Spectra, panel3
            begin
             checkbox32.Visible:=false;
             label56.Color:=drawingsArr[StreamIdx].chartColor;
             if StreamsNbrs[StreamIdx]=3 then label56.Font.Color:=clWhite
             else label56.Font.Color:=clBlack;
             label58.Visible:=false; label59.Visible:=false; label60.Visible:=false; label153.Visible:=false;
            end;//panel3.2           panel3.3                panel4.1                 panel3.4
         7..10:  //cepstra, panel4
            begin
             checkbox32.Visible:=true;
             label56.Color:=drawingsArr[StreamIdx].chartColor;
             label56.Font.Color:=clBlack; label57.font.Color:=clBlack;
             label57.Visible:=false;  label58.Visible:=false; label59.Visible:=false;  label153.Visible:=false;
            end;
        end;{case}
      CheckBox36.Enabled:=false;                                       //check - "Break data reading at:"
      Edit29 .Enabled:=false;                                          //edit - "Break data reading at:"
      if form1.checkBox30.Checked then    //remove time constant
       begin
        panel4.visible:=True;    // added 240311; check30 = Remove Time Constant Contribution
        label60.Caption:='Time mean';
        if CheckBox30.Checked then
         if CheckBox39.Checked then Label157.Caption:='Time constant removed && standardised'
         else Label157.Caption:='Time constant removed';
       end;
      label60.visible:=checkBox30.Checked;
      label157.visible:=checkBox30.Checked;
      with Label57 do
       begin
        color:=label56.Color;
        Visible:=CheckBox39.Checked;
        if checkbox45.Checked then  caption:='Standardised data vector, zero component:=0'
        else caption:='Standardised data vector, orig. zero comp. included'
       end;
     end;{with}
     Application.ProcessMessages
    End;{spcGraphCaptions;}

  var count:word;
  Begin  //-------------------------SPCvectorAndCathListRead--------------------------
   minMaxReset;
   blindFrames(clBlack);
   spcGraphCaptions;
   i:=0;
   form1.Panel9.Height:=form1.Panel7.Height-2;  form1.Panel9.top:=form1.Panel7.top+1; form1.panel9.visible:=true;
   form1.label100.Visible:=true; form1.label100.Caption:='T0 plot [ms]';
   frame(form1.Panel7,form1.canvas,round(form1.panel7.width/5), 1000*F0count/(2*rate), wspx7,wspy7, centr7,false,'Time points [events nbrs]');      //F0count=256|512|1024...; division by 2, because T0 is evaluated on the basis of a distribution of maximums in cepstrum, and a cepstrum encloses in a range of indexes [0 ... fft_windows_width/2]
   //VertTicker(panel:Tpanel;canvas:Tcanvas;const stretch:double;const wspy:double; const centr:word; const sgn:shortInt);
   vertTicker(form1.panel7,form1.canvas,1000*F0count/(2*rate),wspy7,0,-1,-1);
   while (i<EventNbr) and not stopReading do                               //not (eof(eventFile)) do   ten strażnik nie sprawdza się!, czyta tylko do 941847 elementów z pliku....
    begin
     if  form1.checkBox36.Checked and (i>=BreakReadingPoint-1) then
      begin stopReading:=true; form1.button22.Enabled:=true end;        //przerwać czytanie w pkcie BreakReadingPoint, ale gdy nie ma preprocessingu!
     inputer(i,dataRecord);                                            //read(eventFile,dataRecord);
     with dataRecord do
      begin
       if form1.checkBox30.Checked then constantContributionRemove(form1.Panel4,dataRecord.vect,i,xDescr_glob);
       for j:=0 to nc do
        begin
         control1:=i; control2:=j; //debug prp
         vectList[i,j]:=vect[j];
        end;
      end;
     minMaxDetermination(dataRecord,i);
     if form1.checkbox13.Checked then VQT0plot(i,F0Arr[i],eventCath1[i],T0plotStart);   //phon annotation
     inc(i);
     form1.label10.Caption:=intToStr(i);   Application.ProcessMessages;                 //debug prp
     stepWait;
    end;{while}
   form1.PageControl2.Visible:=false;;
   form1.RadioGroup2.Enabled:=false;
   form1.WindowState:=wsMaximized; Application.ProcessMessages;
   form1.label155.Caption:=form1.Edit12.Text;
   windows.beep(400,200);
   flush(reportFile);  //dataRead:=True;  blok 22082022
  End;{SPCvectorAndCathListRead}

 procedure dataReadingBox(callChain:shortString);
   Begin
    callChain:=callChain+'>dataReadingBox';
     with form1 do
       begin
        with Button21 do                          //"Break" on groupBox1 "Data reading"
         begin
          if not spc_txt then  Caption:='Break reading';
          label53.Caption:='';                      //number of event
          label53.width:=0;
          label53.height:=15;
          label53.Alignment:=taRightJustify;
          Label53.Top:=Label89.Top+label53.Height;
          label53.left:=label10.left+label10.width;//-6; 031019
          groupBox1.Height:=104;
          button22.Top:=groupBox1.Height-button22.height-2;      //"options"  on groupBox1 "Data reading"
          application.ProcessMessages;
         end;{with Button21}
       end;{with form1}
   End;{dataReadingBox}

   procedure dataPrepare2(callChain:shortString);
     {
      state proper procedures for:
      *.spc stream data controlling&preprocessing
      *.txt  data reading&controlling&preprocessing
     }
    Begin
    callChain:=callChain+'>dataPrepare2';  dataRead:=false;
    form1.Caption:='Vector Quantizier processes '+inpFileDir;
    extension:=extractFileExt(inpFileDir);
    form1.edit1.Enabled:=false;
    form1.Edit1.Color:=clRed;
    if TTextRec(reportFile).Mode=fmClosed then                 //21042022
     openReportFile(callChain);
    if extension='.spc' then
     begin
      dataReadingBox(callChain);
      inputer:=spcPreprocessor;
      DataParameters:=spcDataParameters;
      showModifiedInput:=showModifiedSPCinput;
      setClassifiersNumbers:=setSpcClassifiersNumbers;
      with form1 do
       begin
       checkBox36.enabled:=false; Edit29.enabled:=false;// panel3.Visible:=true; panel4.Visible:=true; 290419
       RadioGroup2.Enabled:=true; checkBox25.Visible:=false; checkBox27.Visible:=false;  // Averages, Nodes; 06052022
        Y1Name:=cathNamesArr[0];
        Y2Name:=cathNamesArr[1];
        Y3Name:=cathNamesArr[2];
        Y4Name:=cathNamesArr[3];
       end;{with}
      form1.edit20.Text:=floatToStr(averagingTime);  form1.edit25.Text:=form1.edit20.Text;
      spc_txt:=true;
      try
     // reset(eventFile);
      except
       showmessage('Have you received message "I/O error 32"? - if yes, check whether you have not opened the file '+inpFileDir+' with an another program.');
      end;
     end{if .spc}
    else   // input data is in text file
    if extension='.txt' then
     begin
       if not fileExists(inpFileDir) then
       begin
        showMessage('The events input file, i.e. the '#13#10'"'+inpFileDir+'"'#13#10'does not exists choose proper one!');
        openDialog(form1.OpenDialog1,inpFileDir,5,'Open event data file',form1.edit5,callChain);
       end;
      assignFile(txtEventFile,inpFileDir);
      try
       reset(txtEventFile);
      except
       showmessage('Have you received message "I/O error 32"? - if yes, check whether you have not opened the file '+inpFileDir+' with an another program, i.e. MS Word');
      end;
      inputer:=txtInputer;
      waveFileDir:='Does not refer to';
      DataParameters:=txtDataParameters;//(wholeEventNbr);
      showModifiedInput:=showModifiedTxtInput;
      setClassifiersNumbers:=setTXTclassifiersNumbers;
      with form1 do
       begin
        RadioGroup2.Enabled:=false;
        panel3.Visible:=false; panel4.Visible:=false;
        label56.Visible :=false;label57.Visible :=false;label58.Visible :=false;label59.Visible :=false;
        label153.Visible :=false;label64.Visible :=false;label100.Visible :=false; label60.Visible :=false;
        checkBox25.Visible:=false; checkBox27.Visible:=false;  // Averages, Nodes; 28042022
       end;{with}
      spc_txt:=false;
     end;{else extension='.txt'}
    DataParameters(wholeEventNbr,callChain);
    if not spc_txt then readEventNbr:=wholeEventNbr;
    with form1 do
     begin
      edit5.Text:=inpFileDir;
      edit5.Enabled:=false;
      Button2.Enabled:=false; //...  (show text of some procedure)
      Label53.Top:=Label22.Top; Label53.left:=Label22.left;
     end;{with}
    with form1.Button21 do   //OK|Break reading
     begin
      form1.label53.Alignment:=taLeftJustify;
      form1.label53.Color:=cllime;
      if spc_txt then Caption:='Check input'
      else Caption:='Read data';                    application.ProcessMessages;
      if spc_txt then form1.label53.Caption:='Click "'+form1.button22.Caption+'" to check and correct'#13#10'the analysis parameters or'#13#10'"'+caption+'" to inspect data'
      else form1.label53.Caption:='Click "'+form1.button22.Caption+'" to check and correct'#13#10'the analysis parameters or'#13#10'"'+form1.button21.caption+'" to continue data feature'#13#10'vectors reading...';;                                                    application.ProcessMessages;
     end;
   streamRadioDescr;
   form1.Button5.Enabled:=true;
   //form1.checkBox37.enabled:=true; blok 28022022
  End; {DataPrepare2}

 procedure saveTree(centroidsNb, nc:word; var treeFileDir:shortString;callChain:shortString);//; const ext:shortString);
  var
     decision : byte;
            i : longWord;
            j : longword;
            s : String;

  function openTreeFileToSave(callChain:shortString):boolean;

   function saving:byte;
    Begin
     repeat
      if not saveDialog(form1.SaveDialog1,treeFileDir,4,callChain+'>"Quantisation tree saving"') then //4=*.vqt*
       decision:=messageDlg('No result savings?',mtConfirmation,mbyesNo,0)
      else break;
      showMessage('Resulted quantisation tree was not saved!');
      writeln(reportFile,'Resulted quantisation tree (on user request) was not saved!');
      openTreeFileToSave:=false;
      exit;                                    //wyniki nie będą zapisane!!
     until decision=mrYes ;
     result:=decision
    End; {saving}

   var s1,s3,s4:shortString;
   Begin
    callChain:=callChain+'>openTreeFileToSave';
    openTreeFileToSave:=true;  s:=treeFileDir;
    if not form1.CheckBox18.Checked then   //nie wpisywać w pętli step RUN
    begin
     if not form1.CheckBox17.Checked then  //brak pozwolenia na nadpisywanie bez ostrzeżenia
     Begin
      if not oncePerformed then  //in order not to loose session number in treeFileDir 021220
       begin
        s1:=extractFileDir(treeFileDir);
        if s1[length(s1)]='\'  then delete(s1,length(s1),1);
        s3:=extractFileName(inpFileDir);
        s4:=extractFileExt(inpFileDir);
        treeFileDir:=s1+'\'+copy(s3,1, pos(s4,s3)-1)+'_Tree.vqt';
       end;
     if not DirectoryExists(extractFileDir(treeFileDir)) then
       if
        MessageDlg(callChain+#13#10'The "'+treeFileDir+'" directory'#13#10'(in the path "'+treeFileDir+'")'#13#10'does not exist, change it!',mtError,[mbYes, mbNo],0)=mrYes
       then  saving;
     if extractFileDir(treeFileDir)<>extractFileDir(reportFileDir) then
      begin
       showMessage(callChain+#13#10'Warning'#13#10'Path to report file and to tree file are different, i.e. "'+
        extractFileDir(treeFileDir)+'" <>"'+extractFileDir(reportFileDir)+'"'#13#10'Try to change it.');
       saving;
      end;
     if fileExists(treeFileDir) then saving
     else showMessage('Results quantisation tree was saved in "'+treeFileDir+'"');
    End;
    end{form1.CheckBox18.Checked}
    else form1.CheckBox17.Checked:=false;  //w pętli nadpisuj bez ostrzegania
    if s<>treeFileDir then
     begin initWrite(callChain); form1.Edit18.Text:=treeFileDir end;
    assignFile(treeFile,treeFileDir);
    rewrite(treeFile);
    //form1.edit18.Text:=treeFileDir;
   End;{openTreeFileToSave}

  Begin //---------------------saveTree--------------------
   callChain:=callChain+'>saveTree';
   form1.Label66.Caption:='Output tree saving';
   decision:=mrNo;    treeSaved:=false;
   if not openTreeFileToSave(callChain) then exit;
  {1} writeln(treeFile,form1.RadioGroup12.ItemIndex,' ', form1.radiogroup12.caption,': 0 - "',form1.radiogroup12.Items[0],'", 1 - "',form1.radiogroup12.items[1],'"');//CART|centroids dividing method, if =0 then CART, if =1 then centroids');
  {2} writeln(treeFile,waveFileDir);                                         //wave file dir
      writeln(treeFile,inpFileDir);                                         //Teaching events file dir
      writeln(treeFile,reportFileDir);                                      //Report file dir
      if spc_txt then
       with form1.RadioGroup2 do
        s:=Items[ItemIndex]
      else s:='One stream data from the text file';
      with form1.RadioGroup2 do
      s:=intToStr(ItemIndex)+' '+s;
  {3} writeln(treeFile,readEventNbr, ' of data vectors which were read from the teaching events file');
      writeln(treeFile,wholeEventNbr,' wholeEventNbr');
  {4} writeln(treeFile,s,' - analysed feature, radiogroup "',form1.RadioGroup2.Caption,'" item index and the item''s name');
  {5} writeln(treeFile,heapTop:5,' ',centroidsNb:5,' ',lifterTreshold:5, ' - heap size, centroids number, lifter treshold ');
  {6} writeln(treeFile,nc,' -  number of considered components (nc)');
      with paramRec do
  {7} writeln(treeFile,FFTwindowsWidth,' ',pWinShape,' ',F0Count,' ',pF0WinShape,
      ' wave FFT windows width, wave FFT windows shape ("',delAmpers(form2.radiogroup7.Items[pWinShape]),'"), F0 FFT windows width, F0 FFT windows shape ("',delAmpers(form2.radiogroup7.Items[pF0WinShape]),'")');    //windows width, windows shape
  {8}  writeln(treeFile,' coded cathegories sets values (in the MegaSet format):');            //TSAC=array[0..3] of int64;
      for i:=0 to 3 do write(treeFile,TSAC(cath1Set)[i],' '); writeln(treeFile,'cath1');      // decoder:
      for i:=0 to 3 do write(treeFile,TSAC(cath2Set)[i],' '); writeln(treeFile,'cath2');     // a) declare variables SAC# : TSAC, and set#:TcharSet
      for i:=0 to 3 do write(treeFile,TSAC(cath3Set)[i],' '); writeln(treeFile,'cath3');     // a) read a value of array SAC# : TSAC
      for i:=0 to 3 do write(treeFile,TSAC(cath4Set)[i],' '); writeln(treeFile,'cath4');     // b) convert the SAC with a TcharSet, i.e. cath#set:=TcharSet(SAC#)


   with form1 do
    Begin
       s:=MegaSetConstructorReconstruction(featureMegaSet);
  {9}  writeln(treeFile,s);//,' i.e."',Label111.caption,'"=',Label112.caption, ' (=should be true!)'); //featureMegaSet, "Resulting features set constructor" as label12.caption (should be equal ;
 {10}  writeln(treeFile,byte(CheckBox1.checked):6,' ',byte(CheckBox2.checked):6,' ',byte(CheckBox3.checked):6,
        ' ',byte(CheckBox4.checked):6,' ',byte(CheckBox28.checked):6,' ',byte(CheckBox19.checked):6,' ',label119.caption,CheckBox19.caption);//'Classificators for supervised training, degressive isolation',
 {11}  writeln(treeFile,byte(CheckBox30.checked):6,' ',byte(CheckBox39.checked):6,' ',' ',
       checkBox30.caption,'; ',checkBox39.caption,'; '); //averaging On, Off, stadarising on|off, scaling factor
 {12}      writeln(treeFile,ComboBox1.itemIndex:6,' ',label95.caption);                       //-averaging method'
 {13}            writeln(treeFile,AveragingTime:6,' ',label96.caption);                       //- averaging time'#13#10,
 {14}              writeln(treeFile,NbrOfFrames:6,' ',label97.caption);                       //- number of frames'#13#10,
 {15}                writeln(treeFile,FrameStep:6,' ',label99.caption);                       //- analysis step'#13#10,
 {16}                     writeln(treeFile,rate:6,' ',label98.caption);                       //- wave sampling frequency'#13#10,
 {17}            writeln(treeFile,rareEventNbr1,' ',rareEventNbr2,' rareEventNbr1, rareEventNbr2');
 {18}    writeln(treeFile,radiogroup4.ItemIndex:6,' ', radiogroup4.caption);   //'distortion=mean|sum of distances
 {19}   writeln(treeFile,radiogroup12.ItemIndex:6,' ', radiogroup12.caption);  //' Set dividing method (CART|Centroids)'#13#10,
 {20}   writeln(treeFile,radiogroup22.ItemIndex:6,' ', radiogroup22.caption);  //' kryteria wyboru zbioru do podziału'#13#10,
 {21}   writeln(treeFile,radiogroup23.ItemIndex:6,' ', radiogroup23.caption);  //' kryteria wyboru cechy w trybie CART wg wartości której był dzielony zbiór'#13#10,
 {22}   writeln(treeFile,radiogroup24.ItemIndex:6,' ', radiogroup24.caption);  //' kryteria wyboru zbioru do podziału, wrażenie , tryb supervised training'#13#10,
 {23}   writeln(treeFile,radiogroup25.ItemIndex:6,' ', radiogroup25.caption);  //' kryteria wyboru cechy w trybie CART, wrażenie , tryb supervised training'#13#10,
 {24}   writeln(treeFile,radiogroup26.ItemIndex:6,' ', radiogroup26.caption);  //' kryteria wyboru zbioru do podziału, unsupervise|supervised training (0 i 1 odpowiednio)'#13#10,
 {25}   writeln(treeFile,radiogroup27.ItemIndex:6,' ', radiogroup27.caption);  //' kryteria wyboru cechy w trybie CART, unsupervise|supervised training (0 i 1 odpowiednio)'#13#10,
 {26} writeln(treeFile,byte(checkBox42.checked):6,' ', checkBox42.caption);          //' CART-like
    End;{with}
 {27} writeln(treeFile,'Leaves nodes addresses:');                        //01.11.05
      for i:=0 to centroidsNb do write(treeFile,' ',leafNodes[i]);
      writeln(treeFile);
 {28} writeln(treeFile,'Exclude set:');
      writeln(treeFile,excludeSetCard,'  Exclude set card');                                   //01.11.05
      control1:=high(excludeEventsMegaSet); //debug prp
      control2:=cardMegaSet(excludeEventsMegaSet);
      if excludeSetCard>0 then
 {29} for i:=0 to (readEventNbr+1) div 8 do
        write(treeFile,' ',excludeEventsMegaSet[i]);//01.11.05, zbiór zdarzeń b. rzadkich
      writeln(treeFile);

 {30} writeln(treeFile,'Classification variable names (4 pieces):');
      writeln(treeFile,y1Name);
      writeln(treeFile,y2Name);
      writeln(treeFile,y3Name);
      writeln(treeFile,y4Name);                                                 //01.11.05
 {31} writeln(treeFile,cath1Nbr,' ',cath2Nbr,' ',cath3Nbr,' ',cath4Nbr,' ','numbers of cathegory values ');

 {32} writeln(treeFile,'Cathegory hash tables:');
      writeln(treeFile,y1Name,' codes list:');                                                        //21.02.06
      for i:=0 to cath1Nbr do write(treeFile,cath1CodeList[i],' '); writeln(treeFile);
      writeln(treeFile,y2Name,' codes list:');                                                        //21.02.06
      for i:=0 to cath2Nbr do write(treeFile,cath2CodeList[i],' '); writeln(treeFile);
      writeln(treeFile,y3Name,' codes list:');                                                        //21.02.06
      for i:=0 to cath3Nbr do write(treeFile,cath3CodeList[i],' '); writeln(treeFile);
      writeln(treeFile,y4Name,' codes list:');                                                        //21.02.06
      for i:=0 to cath4Nbr do write(treeFile,cath4CodeList[i],' '); writeln(treeFile);
 {33} //out and standardise checkbox states and rigid|weak identity analysis conditions lists
      writeln(treeFile,'Out and standardise check boxes states codes');
      writeln(treeFile, allNormChecksStatesCode,' ',allOutChecksStatesCode);
      writeln(treeFile,'Rigid and weak identity conditions lists for output streams in analysed teaching data sample');
      writeln(treeFile,'Rigid identity conditions list :');
      for i:=0 to nbrOfStreams-1 do   write(treeFile,c[i],' '); writeln(treeFile);
      writeln(treeFile,'Weak identity conditions list :');
      for i:=0 to nbrOfStreams-1 do   write(treeFile,d[i],' '); writeln(treeFile);
 {34} writeln(treeFile,'Quantization tree');                                                    //01.11.05
      for i:=0 to heapTop do
       with nodeHeap[i] do
       begin
 {35}   writeln(treeFile,i:5,' node nbr; next row: son, brother, leafIdx, ',y1Name,', ',y2Name,', ',y3Name,', ',y4Name,
        ' OptComponentNbr, fission distance');  //,cath1,cath2,cath3,cath4, OptComponentNbr
 {36}   writeln(treeFile,' ',son,' ',brother,' ',nodeProps[i].leafIdx,' ',nodeProps[i].maxCath1,' ',nodeProps[i].maxCath2,' ',
                nodeProps[i].maxCath3,' ',nodeProps[i].maxCath4,' ',nodeProps[i].OptComponentNbr,' ',nodeProps[i].fissionDistance);
 {37}   writeln(treeFile,'Centroid:');
 {38}   for j:=0 to nc do if inMegaSet(j,featureMegaSet) then writeln(treeFile,' ',nodeProps[i].centroid[j]);
       end;{for}
     if form1.CheckBox24.checked then    //"Save tree leaf sets to tree file"
      begin
       control1:=high(nodeProps);        //debug prp. 05022021
 {39}  writeln(treeFile,'Leaf Node Sets -----------------------------------------');
       for i:=0 to centroidsNb do        //saveLeafNodeSets
       begin
 {40}   writeln(treeFile,'node nbr=',i);
 {41}   for j:=nodeProps[i].lb to nodeProps[i].hb do writeln(treeFile,sbl[j]);
       end;
      end;{if}
   CloseFile(treeFile);
   treeSaved:=true;
   form1.Label66.Caption:='Output tree saving finished!';
  End;{saveTree}

procedure treeToreport;//(s:shortString);
{
Zapis drzewa wynikowego do reportu
}
 var i,j:longword; s,s1:shortString;

 procedure underline;
  var i:longWord;
  begin
   for i:=1 to 66 do  write(reportFile,'=');
   if form1.CheckBox8.checked then for i:=0 to nc do if inMegaSet(i,featureMegaSet) then write(reportFile,'|===========');
   writeln(reportFile,'|');
  end;

 Begin    //--------------------------------------------treeToreport------------------
  if not form1.CheckBox26.Checked then
   with form1 do
   begin
    checkBox7.Checked:=false;
    checkBox8.Checked:=false;
    exit;
   end;
  writeln(reportFile,#13#10'Table 4. Quantization tree.'#13#10,
                           '         Node parameter son<0 means, that the node is a leaf'#13#10,
                           '         and that the parameter''s value is its nbr multiplied by -1. '{,s});
  underline;
  write(reportFile,'node|------tree-------','|     mean  |','     fission    |','CART   | node ');
   s:='';
  if form1.CheckBox8.checked then s1:='|-centroids components' else s1:='';
  if form1.CheckBox8.checked then
   begin
    for i:=0 to nc-1 do if  inMegaSet(i,featureMegaSet) then s:=s+'------------';
    delete(s,1,length('components'));
   end;
  insert(s1,s,1);
  s:=s+'| ';
  writeln(reportFile,s);
  write(reportFile,' nbr|  son|broth| leaf|   distance|        distance|feature| count|');
  if form1.CheckBox8.checked then
   for j:=0 to nc do  if inMegaSet(j,featureMegaSet) then  write(reportFile,j:11,'|');
  writeln(reportFile);
  underline;
  for i:=0 to heapTop do
   with nodeHeap[i] do
    begin
     write(reportFile,i:4,'|',son:5,'|',brother:5,'|',nodeProps[i].leafIdx:5,'| ');
     write(reportFile,nodeProps[i].MeanDistance:10:3,'| ',nodeProps[i].fissionDistance:15:3,'| ',nodeProps[i].OptComponentNbr:6,'| ',nodeProps[i].cardinal:5,'| ');
     if form1.CheckBox8.checked then                                                     //drukuj centroidy
     for j:=0 to nc do  if  inMegaSet(j,featureMegaSet) then  write(reportFile,nodeProps[i].centroid[j]:10:3,'| ');
     if form1.CheckBox7.checked then                                                     //drukuj zbiory liści
     if son=0 then    //było if son<0, zmieniono w związku z blokadą InspectLeafPicker 31.03.09 (numeracji liści przez instrukcję nodeHeap[startNodeIndex].son:=-leafNodeNbr)
      begin
       writeln(reportFile);writeln(reportFile);
       writeln(reportFile,'Events addresses of set (',intToStr(nodeProps[i].hb-nodeProps[i].lb+1),' in total), of the final tree leaf (i.e. an end tree node adresse) nbr ',intToStr(i),':');
       for j:=nodeProps[i].lb to nodeProps[i].hb do
        begin
         if j mod 20=0 then  writeln(reportFile);
         write(reportFile,sbl[j]:8,'| ');      //wydruk zbioru zablokowany 09.11.05 aby obniżyc wymiar indexSet
        end;
       writeln(reportFile);
      end;
     writeln(reportFile);
    end;                                                                                                                           
  underline;
  flush(reportFile);
 End;{treeToreport}

 procedure excludeSetToreport;
  var i,j:longWord;
  Begin
   writeln(reportFile,#13#10'List of numbers of rare events which will not be taken into account at the second pass (contains ',excludeSetCard,' members)');
   j:=0;
   for i:=0 to readEventNbr-1 do
    Begin
     if inMegaSet(i,excludeEventsMegaSet) then
      begin
       if j mod 18=0 then writeln(reportFile);
       inc(j);
       write(reportFile,intToStr(i):6,#9);       //#9, aby liczby były rozróżnialne w excelu
      end;
    End;
   writeln(reportFile,#13#10);
   Flush(reportFile);
  End;{excludeSetToreport;}

  procedure featuresUsageHistToReport;
  var i,j,k:integer;  r:double; sum:longWord;
   Begin
    Writeln(reportFile);
    Writeln(reportFile,'----------------------CART mode -------------------------------------------------');
    Writeln(reportFile,'Table 5. Distribution of features usage in the CART mode');  Writeln(reportFile);
    k:=featureUseCounter[0];
    for i:=0 to nc do if k<featureUseCounter[i] then k:=featureUseCounter[i];   k:=k*5; if k<23 then k:=23;
    for i:=0 to k+27 do Write(reportFile,'=');Writeln(reportFile);
    Write(reportFile,'|feature|count|corr. coeff.| u s e d  i n  s t e p');
    for i:=22 to -2+k do Write(reportFile,'.');Writeln(reportFile,'|');
    for i:=0 to k+27 do Write(reportFile,'=');Writeln(reportFile);
    for i:=0 to nc do
     begin
      sum:=0;
      for j:=0 to featureUseCounter[i] do inc(sum,featureUseHist[i,j]);
      r:=(CentroidsNb_glob*featureUseCounter[i]-sum)/(CentroidsNb_glob*(CentroidsNb_glob-1));
      Write(reportFile,'|',i:7,'|',featureUseCounter[i]:5,'|',r:12:3,'|');
      for j:=1 to featureUseCounter[i] do  Write(reportFile,featureUseHist[i,j-1]:4,'|');Writeln(reportFile);   //-1, bo dla 0 0-1<0 wychodzi poza word
     end;
     for i:=0 to k+27 do Write(reportFile,'=');Writeln(reportFile);
   End;{featuresUsageHistToReport}

 procedure S0(callchain:string);
  var i,j,k,l:longWord; msd,idistance:extended; centroid0,centroid0double,vt:TmeanVector; m:word;
  Begin
   callChain:=callChain+'>S0';
   application.ProcessMessages;
   setLength(controlArr1, readEventNbr); setLength(controlArr2, readEventNbr); //debug prp
   setLength(centroid0,nc+1);
   setLength(centroid0double,nc+1);
   setLength(vt,nc+1);  //060819
   k:=0;  j:=high(longWord);  l:=0;                //zainicjować listy zakresów adresów zdarzeń z wyłączeniem zdarzeń rzadkich ("2" przebieg)
    control3:=high(sbl); control1:=high(wbl);     //debug prp
   for i:=0 to readEventNbr-1 do
    begin
     control2:=i;                              //debug prp
     wbl[i]:=j; sbl[i]:=j;                    //inicjowanie skorowidzow (indexes initiation)
     if not inMegaSet(i,excludeEventsMegaSet) then         //skorowidze nie uwzgledniaja wykluczonych zdarzen! (indexes does no take into account excluded events (derived from previous analyses))
      begin
       wbl[k]:=i; sbl[k]:=i;               //skorowidze zdarzen (events indexes)
       inc(k);
      end
     else
     begin
      controlArr1[l]:=i;
      inc(l);
     end;{else if}
    end;{for i}
   trueEventNbr:=k;                    //trueEvenNbr, to liczba zdarzen po wylaczeniu zdarzen ze zbioru excludeEventsMegaSet
   with form1 do begin Edit33.Text:=intToStr(trueEventNbr); Edit14.Text:=intToStr(readEventNbr-k); label155.Caption:=edit33.Text end;   //33- used nbr of data, 14 - excluded nbr of data (by excludeEventsMegaSet)
   for j:=0 to nc do if inMegaSet(j,featureMegaSet) then centroid0double[j]:=0;
   msd:=0; k:=0;
   control1:=trueEventNbr;          //debug prp
   control2:=high(vectList[0]);    //debug prp
   control3:=high(sbl);           //debug prp
   for i:=0 to trueEventNbr-1 do //zsumować wszystkie wektory zdarzeń
     begin                                                                   //nie należące do zbioru wykluczeń
      control3:=i;            //debug prp
      control2:=sbl[i];      //debug prp
      inc(k);
      for j:=0 to nc do
       begin
        control1:= j;    //debug prp
        if inMegaSet(j,featureMegaSet)    //sbl - sorted addresse list of events (sorted border list)
        then centroid0double[j]:=centroid0double[j]+vectList[sbl[i],j];
       end; {j}
     end; {i,if inMegaSet}
   if k<>trueEventNbr then error7(callChain);
    if k>0 then                          //------------obliczyć wektor średni (centroid), średnią odległość od centrum i wariancję
     begin
      for j:=0 to nc do if inMegaSet(j,featureMegaSet) then centroid0[j]:=centroid0double[j]/k;
      for i:=0 to readEventNbr-1 do   if not (inMegaSet(i,excludeEventsMegaSet)) then
       begin
        for m:=0 to nc do if inMegaSet(m,featureMegaSet) then vt[m]:=vectList[i,m];
        idistance:=dist(centroid0,vt);  //------------odległość od centr.
        msd:=msd+idistance;             //------------suma odległości wektorów od centrum
       end;{for}
      msd:=msd/k;                       //------------średnia odległość
     end{if k>0}
    else error5(callChain);                        //'Error 6'#13#10'The  event set is empty or all events belong to exclude set!, nothing to do, program will be halted.';

   with nodeHeap[0] do                  //------------określić parametry pierwszego węzła w drzewie
      begin
       son:=0;
       brother:=0;
       nodeProps[0].cardinal:=k;
       nodeProps[0].meanDistance:=msd;
       for m:=0 to nc do  if inMegaSet(m,featureMegaSet) then
        nodeProps[0].centroid[m]:=centroid0[m];
       nodeProps[0].lb:=0; nodeProps[0].hb:=trueEventNbr-1;
      end;
   setLength(centroid0,0); setLength(centroid0double,0); setLength(vt,0);
  End;{S0}

function checkDistortion(const startNode:longWord):double;
 { CARTlike:
 oblicza zniekształcenia po rozszczepieniu danego liścia,
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newDistortion,dist1,dist2:double; i:longint;
  Begin
   with form1.radiogroup4 do
    begin
     i:=-nodeHeap[startNode].son;
     if ItemIndex=1 then    //distortion=sum of distances
      begin
       dist1:=nodeProps[i].cardinal*nodeProps[i].meanDistance;
       dist2:=nodeProps[nodeHeap[i].brother].cardinal*nodeProps[nodeHeap[i].brother].meanDistance;
       newDistortion:=nodeprops[startNode].cardinal*nodeprops[startNode].meanDistance-dist1-dist2;
      end
     else
      begin            //distortion=mean distance
       dist1:=nodeProps[i].meanDistance;
       dist2:=nodeProps[nodeHeap[i].brother].meanDistance;
       newDistortion:=nodeprops[startNode].meanDistance-dist1-dist2;
      end;
    end;{with radiogroup4}
   result:=newDistortion;
  End;{checkDistortion}

function checkcath1Error(const startNode:longWord):double;
 { CARTlike:
 oblicza błąd rozpoznania (w trybie autotestu) po rozszczepieniu danego liścia,   (cath1RecErr,cath2RecErr,cath3RecErr,cath4RecErr)
 poszukuje się liścia o największym spadku błędu po jego podziale (metodą centroidów)
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newRecErr,recErr1,recErr2:double;
  Begin
   with nodeprops[startNode] do
    begin
     recErr1:=nodeProps[-nodeHeap[startNode].son].cath1RecErr;
     recErr2:=nodeProps[nodeHeap[-nodeHeap[startNode].son].brother].cath1RecErr;
     newRecErr:=(cath1RecErr-(recErr1+recErr2));
     result:=newRecErr;
    end;{with}
  End;{checkcath1Error}

function checkcath2Error(const startNode:longWord):double;
 { CARTlike:
 oblicza błąd rozpoznania (w trybie autotestu)  po rozszczepieniu danego liścia,   (cath1RecErr,cath2RecErr,cath3RecErr,cath4RecErr)
 poszukuje się liścia o największym spadku błędu po jego podziale (metodą centroidów)
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newRecErr,recErr1,recErr2:double;
  Begin
   with nodeprops[startNode] do
    begin
     recErr1:=nodeProps[-nodeHeap[startNode].son].cath2RecErr;
     recErr2:=nodeProps[nodeHeap[-nodeHeap[startNode].son].brother].cath2RecErr;
     newRecErr:=cath2RecErr-(recErr1+recErr2);
     result:=newRecErr;
    end;{with}
  End;{checkcath2Error}

function checkcath3Error(const startNode:longWord):double;
 { CARTlike:
 oblicza błąd rozpoznania (w trybie autotestu)  po rozszczepieniu danego liścia,   (cath1RecErr,cath2RecErr,cath3RecErr,cath4RecErr)
 poszukuje się liścia o największym spadku błędu po jego podziale (metodą centroidów)
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newRecErr,recErr1,recErr2:double;
  Begin
   with nodeprops[startNode] do
    begin
     recErr1:=nodeProps[-nodeHeap[startNode].son].cath3RecErr;
     recErr2:=nodeProps[nodeHeap[-nodeHeap[startNode].son].brother].cath3RecErr;
     newRecErr:=cath3RecErr-(recErr1+recErr2);
     result:=newRecErr;
    end;{with}
  End;{checkcath3Error}

function checkcath4Error(const startNode:longWord):double;
 { CARTlike:
 oblicza błąd rozpoznania (w trybie autotestu)  po rozszczepieniu danego liścia,   (cath1RecErr,cath2RecErr,cath3RecErr,cath4RecErr)
 poszukuje się liścia o największym spadku błędu po jego podziale (metodą centroidów)
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newRecErr,recErr1,recErr2:double;
  Begin
   with nodeprops[startNode] do
    begin
     recErr1:=nodeProps[-nodeHeap[startNode].son].cath4RecErr;
     recErr2:=nodeProps[nodeHeap[-nodeHeap[startNode].son].brother].cath4RecErr;
     newRecErr:=cath4RecErr-(recErr1+recErr2);
     result:=newRecErr;
    end;{with}
  End;{checkcath4Error}

function checkcath1IR(const startNode:longWord):double;
 { CARTlike:
 oblicza zniekształcenia  po rozszczepieniu danego liścia,
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newIR,IR1,IR2:double;
  Begin
   with nodeprops[startNode] do
    begin
     IR1:=nodeProps[-nodeHeap[startNode].son].cath1Ir;
     IR2:=nodeProps[nodeHeap[-nodeHeap[startNode].son].brother].cath1Ir;
     newIR:=-cath1Ir+IR1+IR2; //
     result:=newIR;
    end;{with}
  End;{checkcath1IR}

function checkcath2IR(const startNode:longWord):double;
 { CARTlike:
 oblicza zniekształcenia  po rozszczepieniu danego liścia,
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newIR,IR1,IR2:double;
  Begin
   with nodeprops[startNode] do
    begin
     IR1:=nodeProps[-nodeHeap[startNode].son].cath2Ir;
     IR2:=nodeProps[nodeHeap[-nodeHeap[startNode].son].brother].cath2Ir;
     newIR:=-cath2Ir+IR1+IR2;
     result:=newIR;
    end;{with}
  End;{checkcath2IR}

function checkcath3IR(const startNode:longWord):double;
 { CARTlike:
 oblicza zniekształcenia  po rozszczepieniu danego liścia,
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newIR,IR1,IR2:double;
  Begin
   with nodeprops[startNode] do
    begin
     IR1:=nodeProps[-nodeHeap[startNode].son].cath3Ir;
     IR2:=nodeProps[nodeHeap[-nodeHeap[startNode].son].brother].cath3Ir;
     newIR:=-cath3Ir+IR1+IR2;
     result:=newIR;
    end;{with}
  End;{checkcath3IR}

 function checkcath4IR(const startNode:longWord):double;
 { CARTlike:
 oblicza zniekształcenia  po rozszczepieniu danego liścia,
 zwraca różnicę
 startNode - adres próbnie rozbijanego liścia
 }
 var newIR,IR1,IR2:double;
  Begin
   with nodeprops[startNode] do
    begin
     IR1:=nodeProps[-nodeHeap[startNode].son].cath4Ir;
     IR2:=nodeProps[nodeHeap[-nodeHeap[startNode].son].brother].cath4Ir;
     newIR:=-cath4Ir+IR1+IR2;
     result:=newIR;
    end;{with}
  End;{checkcath4IR}

 procedure inspectTreeSettings(radio:TradioGroup);   //radio=radio24
  Begin
   case form1.radiogroup12.itemIndex of               // CART|centroids
    0: inspectTree:=FeaturesInspectTree;              // CART
    1: begin
        if form1.checkBox42.Checked then inspectTree:=CARTlike                     // CART-like
        else
        case  form1.radiogroup22.ItemIndex of          // Centroids
         0: inspectTree:=DistancesInspectTree;         // cohrence
         1: case  radio.ItemIndex of                   // error----------------------
             0: inspectTree:=cath1ErrorInspectTree;    // cath1
             1: inspectTree:=cath2ErrorInspectTree;    // cath2
             2: inspectTree:=cath3ErrorInspectTree;    // cath3
             3: inspectTree:=cath4ErrorInspectTree;    // cath4
            end;{case radiogroup24}
         2:  case  radio.ItemIndex of                  // IR-------------------------
              0: inspectTree:=cath1IRInspectTree;      // cath1
              1: inspectTree:=cath2IRInspectTree;      // cath2
              2: inspectTree:=cath3IRInspectTree;      // cath3
              3: inspectTree:=cath4IRInspectTree;      // cath4
             end;{case radiogroup24}
        end;{case radiogroup22}
       end;{case radio12=1}
     else error35(delAmpers('Program error, in the procedure RUN, "'+form1.radiogroup12.caption+'". No method identified as nr '+intToStr(form1.radiogroup12.itemIndex)+
                     ' exists!'#13#10'Check "'+ form1.mainMenu1.Items[2].Caption+'\'+form1.pagecontrol1.Pages[3].Caption+'".'#13#10'Turn to the author...'));
   end;{case radiogroup12}
  End;{inspectTreeSettings}


 {++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

 procedure RUN(const centroidsNb:word; const performance:string;callChain:string);//;ext:char); blok 12.03.09

 var
  s : shortString;


 procedure AnalysisSettingsToreport;
 //zapisuje opcje analizy do reportu
 var sp,sdot:shortString;
  Begin
   if spc_txt then with form1.RadioGroup2 do s:=Items[itemIndex]  //0: s:='power spectrum'; 1: s:='cepstrally smoothed spectrum'; 2: s:='mel cepstrally smoothed spectrum';  3: s:='power cepstrum';  4: s:='mel cepstrum (invers FFT of mel cepstrally smoothed spectrum)';
   else s:='One stream data from the text file';
   writeln(reportFile,#13#10,
   'Processed events features stream:               = ',s,#13#10,
   'Number of considered components (i.e. features) = ',nc+1,' (counting from 0-th component, including the ',nc,'-th)'#13#10,
   'Isolation treeshold                             < ',rareEventNbr1,#13#10,
   'Elimination treshold                            <=',rareEventNbr2);
   with form1 do s:='Features accordingly to the"'+label109.Caption+'" and "'+label110.Caption+'" edit windows contents:';
   with form1 do
   begin
   writeln(reportFile,s,' '#13#10,GroupBox9.Caption,', ',label111.Caption,': ',Label112.Caption);
   sp:=' - ';
   sdot:=' .....................................................................................................';
   writeln(reportFile,delAmpers(mainMenu1.Items[2].Caption+'\'+form1.PageControl1.Pages[3].Caption),':');
   s:=sdot; s:=radiogroup12.Caption; setLength(s,35);
   if RadioGroup12.itemIndex>=0 then s:=s+sp+RadioGroup12.Items[RadioGroup12.itemIndex]
   else s:=s+sp+'not determined';               //CART|centroid
   if (RadioGroup12.itemIndex=1) and checkBox42.Checked  then s:=s+', '+checkBox42.Caption;//CART-like
   writeln(reportFile,s);
   s:=sdot; s:=radiogroup22.Caption; setLength(s,35);
   if RadioGroup22.itemIndex>=0 then s:=s+sp+RadioGroup22.Items[RadioGroup22.itemIndex]
   else s:=s+sp+'not determined';               //CART|centroid
   writeln(reportFile,s);
   s:=sdot; s:=radiogroup24.Caption; setLength(s,35);
   if RadioGroup24.itemIndex>=0 then s:=s+sp+RadioGroup24.Items[RadioGroup24.itemIndex]
   else s:=s+sp+'not determined';               //CART|centroid
   writeln(reportFile,s);
   s:=sdot; s:=radiogroup26.Caption; setLength(s,35);
   if RadioGroup26.itemIndex>=0 then s:=s+sp+RadioGroup26.Items[RadioGroup26.itemIndex]
   else s:=s+sp+'not determined';               //CART|centroid
   writeln(reportFile,s);
   s:=sdot; s:=radiogroup23.Caption; setLength(s,35);
   if RadioGroup23.itemIndex>=0 then s:=s+sp+RadioGroup23.Items[RadioGroup23.itemIndex]
   else s:=s+sp+'not determined';               //CART|centroid
   writeln(reportFile,s);
   s:=sdot; s:=radiogroup25.Caption; setLength(s,35);
   if RadioGroup25.itemIndex>=0 then s:=s+sp+RadioGroup25.Items[RadioGroup25.itemIndex]
   else s:=s+sp+'not determined';               //CART|centroid
   writeln(reportFile,s);
   s:=sdot; s:=radiogroup27.Caption; setLength(s,35);
   if RadioGroup27.itemIndex>=0 then s:=s+sp+RadioGroup27.Items[RadioGroup27.itemIndex]
   else s:=s+sp+'not determined';               //CART|centroid
   writeln(reportFile,s);
   end;{with}
   if form1.CheckBox19.Checked then
     s:='- Degressive isolation treshold'+#13#10
   else s:='- Constant isolation treeshold='+intToStr(rareEventNbr1)+#13#10;
   writeln(reportFile,'Set counts constrain method........ ',s);
   if form1.RadioGroup12.ItemIndex=1 then
   writeln(reportFile,'Standard deviation multipier (for initial centroids computations) ...',multStdDev:5:2);
   if form1.CheckBox30.Checked then
   writeln(reportFile,'Input signal averaging parameters:'#13#10,
   byte(Form1.CheckBox30.checked):6,' - averaging: if=1, then was turned On, if = 0, then was turned  Off '#13#10,
   byte(Form1.CheckBox39.checked):6,' - standarise events:            1 - on, 0 - off',
   byte(Form1.CheckBox45.checked):6,' - set vector[0] component to 0: 1 - on, 0 - off',
                      NbrOfFrames:6,' - number of averaged frames'#13#10,
        form1.ComboBox1.itemIndex:6,' - averaging method:',form1.ComboBox1.items[form1.ComboBox1.itemIndex],#13#10,
                    AveragingTime:6,' - averaging time [ms]'#13#10,
                      FrameStep:6:0,' - frame analysis step [ms]'#13#10,
                             rate:6,' - wave sampling frequency'#13#10,
   'Note: last 3 items are not valid for the txt data input'#13#10)
   else writeln(reportFile,'No averaging of the input signal was applied.');
  End;{AnalysisSettingsToreport}

 procedure lookForBestSet(callChain:string);
 {
 wybiera kolejny zbiór do podziału
 }

  Begin  //---------------lookForBestSet
   callChain:=callChain+'>lookForBestSet';
   distMaxNodeAddr:=0;
   repeat                                                             //repeat jest potrzebny, bo tutaj następuje aktualizacja progu ograniczenia liczebności i ponowienie InspectTree
    bestFeature:=nc;
    application.ProcessMessages;
    InspectTree(0,callChain,0);                                                 //znajdź zbiór o największej średniej odległości jego elementów od jego centroidu
    if form1.CheckBox19.Checked then    //degres                      //RUN: if form1.radiogroup12.itemIndex=0 then inspectTree:=DistancesInspectTree else inspectTree:=CARTlike;
    if not nodeFound then  rareEventNbr1:=rareEventNbr1 div 2;        //degresja dolnego ograniczenia liczebności
    form1.label63.Caption:=intToStr(rareEventNbr1);
   until nodeFound or (rareEventNbr1=1) or not form1.CheckBox19.Checked         // ?? czy ...or not form1.CheckBox19.Checked nie powinno warunkować wywołanie repeat?
  End;{lookForBestSet}


  procedure leavesParametersSave(const EventNbr:longWord;callChain:string);
   Begin
    begin
     FinalIRToreport(performance,EventNbr,step,callChain);
    end;
   End;{leavesParametersSave}

   procedure initialSettings;

    Begin  //------------------initialSettings
     form1.GroupBox3.Enabled:=false;
     treeSaved:=false;
     fissionCounter:=0;
     with form1 do
     if checkBox19.Checked then                                      //obsługa trybu "deggressive isolation set count"
      begin
       rareEventNbr1:=trueEventNbr div 2;
       edit7.Text:=xxx; label160.Caption:=edit7.Text;
      end;
     case form1.RadioGroup17.ItemIndex of
      0 : begin
           RowsToReportTableCaption:=RowsToReportTableCaptionTXT;
           H0ToReport:=H0ToReportTXT
          end;
      1 : begin
           RowsToReportTableCaption:=RowsToReportTableCaptionEXCEL;
           H0ToReport:=H0ToReportExcel
          end;
     end;{case}
     TIC:=TakeInitialCentroidsSTD;
    End;{initialSettings}

  procedure nodeHistCreate;
  //alokuje pomocnicze zmienne NodeHist_glob,TempHist1, TempHist2 służące jako histogramy,
  //korzysta z odczytanej z pliku danych liczebności zbiorów kategorii, wybiera największą z nich
   var i:byte;
   Begin
    i:=cath1Nbr;
    if i<cath2Nbr then i:=cath2Nbr;
    if i<cath3Nbr then i:=cath3Nbr;
    if i<cath4Nbr then i:=cath4Nbr;
    inc(i);
    setLength(NodeHist_glob,i);
    try
     for i:=0 to high(NodeHist_glob) do  NodeHist_glob[i]:=high(NodeHist_glob[1]);
    except
     error35('Error in the procedure nodeHistCreate for some reason the "NodeHist_glob" variable could not be filled'+
       #13#10'probably because of its wrong size (empty). The size actually is='+intToStr(high(NodeHist_glob)));
    end;
    if form1.radiogroup12.ItemIndex=0 then
     begin
      setLength(TempHist1,high(NodeHist_glob)+1);
      setLength(TempHist2,high(NodeHist_glob)+1);
     end;
   End;

  var m : word;
      treeFileDirTemp:string;
  BEGIN  //--------------------RUN--------------------------
   callChain:=callChain+'>Run';
   form1.label26.Visible:=true; InitialSettings;  totalIterNbr:=0;
   with form1 do if edit19.Text <>'' then label133.Caption:=edit19.Text else label133.Caption:='No!';  //save leaves parameters after these steps
   writeln(reportFile,performance);
   AnalysisSettingsToreport;
   form1.Memo1.Lines.Add(performance); form1.Label52.caption:=intToStr(centroidsNb-1);
   NodeNbr:=0; HeapTop:=0; step:=0;
   with form1 do if checkBox9.checked then if nodeProps[0].cardinal=0 then begin error16(callChain); exit end;
   InspectTreeSettings(form1.RadioGroup24);
   nodeHistCreate;
   RowsToReportTableCaption;                                                                         //28.09.05
   with form1 do
    begin
     radiogroup17.Enabled:=false; radiogroup18.Enabled:=false;
     if checkBox2.Checked  then for m:=0 to cath1Nbr do cath1ClusterCount[m]:=0;
     if checkBox3.Checked  then for m:=0 to cath2Nbr do cath2ClusterCount[m]:=0;
     if checkBox4.Checked  then for m:=0 to cath3Nbr do cath3ClusterCount[m]:=0;
     if checkBox28.Checked then for m:=0 to cath4Nbr do cath4ClusterCount[m]:=0;
     prevX:=form1.panel3.left{+wspx3};   nodePrevX:=prevX;  step:=1;
     cath1IrGlob:=0; cath2IrGlob:=0; cath3IrGlob:=0; cath4IrGlob:=0;
     cath1RecErrSum:=0; cath2RecErrSum:=0; cath3RecErrSum:=0; cath4RecErrSum:=0;//sumy błędów rozpoznania
     if RadioGroup12.ItemIndex=0 then emptyMegaSet(leafNodeSet);
    end;{with}
   with nodeProps[0] do
    begin
     distortion:=cardinal*meanDistance;
     If form1.RadioGroup18.ItemIndex=1 then
      begin
       nodeProps[1].cardinal:=0;  nodeProps[2].cardinal:=0;
       ZeroDistrSum;
       MakeDistortionNodeDistributions(0,centroid,callChain+'0');
       leafNodeNbr:=0;  prevDist:=distortion; distortion:=0;
       leafSummer(0,0,callChain);
       saveStepDistributions(0);
      end;
    end;
   nodeHeap[0].son:=1;  nodeHeap[nodeHeap[0].son].brother:=2;
   RowsToReport(0,trueEventNbr,0);
   nodeHeap[0].son:=0;  nodeHeap[nodeHeap[0].son].brother:=0;  step:=0;  prevX:=form1.panel3.left{+wspx3};
   nodePrevX:=prevX;
   while not (step>=centroidsNb) do    //-------------MAIN LOOP------------------------
   Begin
    inc(step);
    cath1IrGlob:=0; cath2IrGlob:=0; cath3IrGlob:=0; cath4IrGlob:=0;
    cath1RecErrSum:=0; cath2RecErrSum:=0; cath3RecErrSum:=0; cath4RecErrSum:=0;//sumy błędów rozpoznania
    If form1.RadioGroup18.ItemIndex=1 then ZeroDistrSum;
    tryDelta:=-1.7e308;
    nodeFound:=false;             // centroids       Set choice=IR
    distMax:=-1e+324;  application.ProcessMessages;
{!} lookForBestSet(callChain);
     if not nodeFound then  with form1 do     //brak zbiorów o zróżnicowanych elementach
     begin
      error13(trueEventNbr,nodeNbr,centroidsNb,leafNodeNbr,callChain);  //error13(const eventNbr:longWord; const nodeNbr,centroidsNb,leafNodeNbr:word; callChain:string);
      Edit1.Color:=clLime;
      break
     end;
    form1.label135.caption:=intToStr(distMaxNodeAddr);                                         //divided set parameters: addresse
    form1.label47.Caption:=intToStr(nodeProps[distMaxNodeAddr].cardinal);                      //divided set parameters:card (pokaż liczebność dzielonego zbioru    (pod spodem))
    form1.label48.Caption:=floatToStrF(nodeProps[distMaxNodeAddr].meanDistance,ffFixed,13,1);  //pokaż odległości w dzielonym zbiorze (pod spodem)
    application.ProcessMessages;
    with form1 do if checkBox9.checked then if nodeProps[distMaxNodeAddr].cardinal<2 then begin error14(callChain);dec(step); break end;   //koniec możliwości podziałów
     //-------------------------------------------------------------------------------------------------first centroids (centroidy)
    with form1 do
     if (radiogroup12.itemIndex=0) then
     else if not checkBox42.Checked then LookForInitialCentroids(distMaxNodeAddr);             //check42 - CART-like; wyszukać prototypy centroidów (w trybie cohrence) warunek 24.04.10
    application.ProcessMessages;
{!!}if form1.radioGroup12.ItemIndex=0 then   //CART
     begin
      form1.Label128.Caption:=xxx;
      featureUseHist[globComponentNbr, featureUseCounter[globComponentNbr]]:=step;
      inc(featureUseCounter[globComponentNbr]);
     end
    else  if not form1.checkBox42.Checked then // 17.04.10
     FindBestDivision(distMaxNodeAddr,v1,v2,nodeProps[distMaxNodeAddr].lb,nodeProps[distMaxNodeAddr].hb,
      meanDistance1,meanDistance2,iterNbr,hb1glob,lb2glob,k1,k2,step,callChain);
    inc(nodeNbr,2);
    application.ProcessMessages;
    if (form1.checkBox42.Checked) or (form1.RadioGroup12.ItemIndex=0) then NodesFix(distMaxNodeAddr,callChain)//jeśli jest tryb CARTlike, to zafiksuj węzły nastepników
    else treeConstructor(distMaxNodeAddr,heapTop,hb1glob,lb2glob,v1,v2,meanDistance1,meanDistance2,iterNbr,k1,k2,false,0,callChain);
   If form1.RadioGroup18.ItemIndex=1 then
    begin
     MakeDistortionNodeDistributions(NodeHeap[distMaxNodeAddr].son,v1,callChain+'s');   //distMaxNodeAddr, to adres najodpowiedniejszego liścia do rozszczepienia, v1 - centroid of son
     MakeDistortionNodeDistributions(NodeHeap[NodeHeap[distMaxNodeAddr].son].brother,v2,callChain+'b');
   (*  if (form1.radiogroup12.ItemIndex=0) or Form1.CheckBox42.Checked then  //for CART or CART-like mode
      treeLeafSetProcess(NodeHeap[distMaxNodeAddr].son,nodeProps[NodeHeap[distMaxNodeAddr].son].leafIdx ,callChain);     *)//blocked 14062023
    end;
    leafNodeNbr:=0;  prevDist:=distortion; distortion:=0;                            //licznik liści, distortion                    28.09.05, 19.12.06
    leafSummer(0,0,callChain);
    if form1.CheckBox55.Checked then LastDistribControl(step,distortion,callChain);
    with nodeprops[distMaxNodeAddr] do RowsToReport(step,trueEventNbr,distMaxNodeAddr);//,nodeProps[heapTop-1].cath1,nodeProps[heapTop].cath1,nodeProps[heapTop-1].cath2,
    saveStepDistributions(step);
    form1.label91.Caption:=floatToStrF(distortion/trueEventNbr,ffFixed,10,3);
    form1.label92.Caption:=floatToStrF((distortion-prevDist)/trueEventNbr,ffFixed,10,3);
    application.ProcessMessages;
    if form1.CheckBox18.Checked then  //save tree after every step
     begin
      treeFileDirTemp:=treeFileDir;
      saveTree(step+1, nc,treeFileDir,callChain);//,ext);    blok 12.03.09
      treeFileDir:=treeFileDirTemp;
     end;
    if step<>leafNodeNbr-1 then error28(leafNodeNbr,callChain);
    if form1.checkBox29.Checked then       //zapisz parametry liści aktualnego drzewa
     if inMegaset(step,insertMegaSet) then
      begin
       writeln(reportFile,'--------------------------------------------------------------------------------------------------'#13#10,
        'Table 1 will be continued!!');
       writeln(reportFile,'--------------------------------------------------------------------------------------------------'#13#10);
       leavesParametersSave(trueEventNbr,callChain);
       writeln(reportFile,'--------------------------------------------------------------------------------------------------'#13#10,
        'Now table 1 is continued');
       writeln(reportFile,'--------------------------------------------------------------------------------------------------'#13#10);
      end;
    if interrupt then with form1 do
     begin
      interrupt:=false;
      writeln(reportFile, 'Interrupted at the current step='+intToStr(step-1)+' on user request'); flush(reportFile);
      label67.visible:=true; label67.Caption:='Analysis broken at '+intToStr(step-1)+'. step.';
       BREAK
     end;                                                       //poziom drzewa kwantującego
   End{while};                    //every entry to constructor results in adding one new leave more (każde wejście do konstruktora oznacza dodanie jednego liścia)
   if not form1.CheckBox1.Checked then  //DistributionsTablesToReport
    begin
  // procedure  DistributionsTableToReport(const checkBoxChecked:boolean; const tableId,stepSum, parameter,YName:shortString;const cathNbr:byte; groupNbr:word; const rowsArr:TresultsDistr; const cathCodeList: TcharList);
     DistributionsTableToReport(form1.checkBox2.Checked,'Table 1.1.1. ',' step sum ','distortion',Y1Name,cath1Nbr,step,cath1DistortDistrRes,cath1CodeList);
     DistributionsTableToReport(form1.checkBox3.Checked,'Table 1.1.2. ',' step sum ','distortion',Y2Name,cath2Nbr,step,cath2DistortDistrRes,cath2CodeList);
     DistributionsTableToReport(form1.checkBox4.Checked,'Table 1.1.3. ',' step sum ','distortion',Y3Name,cath3Nbr,step,cath3DistortDistrRes,cath3CodeList);
     DistributionsTableToReport(form1.checkBox28.Checked,'Table 1.1.4. ',' step sum ','distortion',Y4Name,cath4Nbr,step,cath4DistortDistrRes,cath4CodeList);

     DistributionsTableToReport(form1.checkBox2.Checked,'Table 1.2.1. ',' step sum ','IR',Y1Name,cath1Nbr,step,cath1IRDistrRes,cath1CodeList);
     DistributionsTableToReport(form1.checkBox3.Checked,'Table 1.2.2. ',' step sum ','IR',Y2Name,cath2Nbr,step,cath2IRDistrRes,cath2CodeList);
     DistributionsTableToReport(form1.checkBox4.Checked,'Table 1.2.3. ',' step sum ','IR',Y3Name,cath3Nbr,step,cath3IRDistrRes,cath3CodeList);
     DistributionsTableToReport(form1.checkBox28.Checked,'Table 1.2.4. ',' step sum ','IR',Y4Name,cath4Nbr,step,cath4IRDistrRes,cath4CodeList);

     DistributionsTableToReport(form1.checkBox2.Checked,'Table 1.3.1. ',' step sum ','recognition error',Y1Name,cath1Nbr,step,cath1RecErrDistrRes,cath1CodeList);
     DistributionsTableToReport(form1.checkBox3.Checked,'Table 1.3.2. ',' step sum ','recognition error',Y2Name,cath2Nbr,step,cath2RecErrDistrRes,cath2CodeList);
     DistributionsTableToReport(form1.checkBox4.Checked,'Table 1.3.3. ',' step sum ','recognition error',Y3Name,cath3Nbr,step,cath3RecErrDistrRes,cath3CodeList);
     DistributionsTableToReport(form1.checkBox28.Checked,'Table 1.3.4. ',' step sum ','recognition error',Y4Name,cath4Nbr,step,cath4RecErrDistrRes,cath4CodeList);
     writeln(reportFile,#13#10'"Distributions of class values  over leaves" = "How many leaves occupies a phonem, a person, an age or an gender class"');
     DistributionsTableToReport(form1.checkBox2.Checked,'Table 1.4.1. ',' leav sum ','leaves',Y1Name,cath1Nbr,step,cath1NodeDistrRes,cath1CodeList);
     DistributionsTableToReport(form1.checkBox3.Checked,'Table 1.4.2. ',' leav sum ','leaves',Y2Name,cath2Nbr,step,cath2NodeDistrRes,cath2CodeList);
     DistributionsTableToReport(form1.checkBox4.Checked,'Table 1.4.3. ',' leav sum ','leaves',Y3Name,cath3Nbr,step,cath3NodeDistrRes,cath3CodeList);
     DistributionsTableToReport(form1.checkBox28.Checked,'Table 1.4.4. ',' leav sum ','leaves',Y4Name,cath4Nbr,step,cath4NodeDistrRes,cath4CodeList);
    end;{if check1}

   writeln(reportFile,'--------------------------------------------------------------------------------------------------'#13#10,
    #13#10'NOTE, Centroids_number=step+1');//podkreślenie tabeli wyników z pętli
   leavesParametersSave(trueEventNbr,callChain);
   if leafNodeNbr-1<>step then if nodeFound then error15(leafNodeNbr,callChain);
   with form1 do begin radiogroup17.Enabled:=true; radiogroup18.Enabled:=true; GroupBox3.Enabled:=true end;
  END;{run}


procedure RAMresources(const centroidsNb:word; callChain:shortString);
 var i,j:longWord;
Begin
 callChain:=callChain+'>RAMresources';
   try
   setLength(leafNodes,CentroidsNb+2);
   except
   error47('IR leaves histograms, procedure "RAMresources"');
   end;
   //nodeHeapTop:=2*CentroidsNb+1;
 case  form1.radiogroup12.ItemIndex of         //17022021
  0:  nodeHeapTop:=4*CentroidsNb+1;
  1: if not form1.checkBox42.Checked then  nodeHeapTop:=2*CentroidsNb+1
     else  nodeHeapTop:=4*CentroidsNb+1;
 end;{case}
 form1.Edit16.Text:=intToStr(nodeHeapTop);
   try
   setLength(nodeHeap,nodeHeapTop);
   except
   error47('the output tree nodes, procedure "RAMresources"');
   end;
   try
    setLength(excludeEventsMegaSet,(readEventNbr+1) div 8+1);
   except
   error47('exclude set, procedure "RAMresources"');
   end;
   try
   setLength(nodeProps,nodeHeapTop);
   for i:=0 to nodeHeapTop-1 do
    with nodeProps[i] do
    begin
     setLength(centroid,vectorsSize+1);
     for j:=0 to vectorsSize do centroid[j]:=i;   //debug prp
     setLength(nodeStDev,vectorsSize+1);
     for j:=0 to vectorsSize do nodeStDev[j]:=i;  //debug prp
    end;
   setLength(v1,vectorsSize+1);
   for j:=0 to vectorsSize do v1[j]:=0;     //debug prp
   setLength(v2,vectorsSize+1);
   for j:=0 to vectorsSize do v2[j]:=0;     //debug prp
   setLength(vi,vectorsSize+1);             //z w. 904; 160919
   for j:=0 to vectorsSize do vi[j]:=0;
   setLength(centr1,vectorsSize+1); setLength(centr2,vectorsSize+1); //z w. 1291; 160919
   for j:=0 to vectorsSize do centr1[j]:=0; //debug prp
   for j:=0 to vectorsSize do centr2[j]:=0; //debug prp
   if form1.RadioGroup12.ItemIndex=0 then   //CART
    begin
     setLength(featureUseHist,nc+1, CentroidsNb_glob+1);
     setLength(featureUseCounter,nc+1);
     if not ((form1.radiogroup12.ItemIndex=0) or form1.CheckBox42.Checked) then setLength(leafNodeSet,(centroidsNb+1) div 4)
     else  setLength(leafNodeSet,(2*centroidsNb+1) div 4);  //05022021, było centroidsNb div 4
    end;
   setLength(sz,nc+1);
   setLength(sk,nc+1);
   setLength(stdev,nc+1);
   with form1 do
   if not CheckBox1.Checked then  //no classifications
    begin
     if CheckBox2.Checked then
      begin
       setLength(cath1ClusterCount,cath1Nbr+1);
       setLength(cath1H0,cath1Nbr+1);
       setLength(cath1Pb,cath1Nbr+1);
       setLength(cath1NodeHist,cath1Nbr+1);
      end
     else
      begin
       setLength(cath1ClusterCount,0);
       setLength(cath1H0,0);                  //dane Corpory są ustalane dopiero w cath1ListRead(cath1Nbr);
       setLength(cath1Pb,0);
       setLength(cath1NodeHist,0);
      end;

 if CheckBox3.Checked then
      begin
       setLength(cath2ClusterCount,cath2Nbr+1);
       setLength(cath2H0,cath2Nbr+1);
       setLength(cath2Pb,cath2Nbr+1);
       setLength(cath2NodeHist,cath2Nbr+1);

      end {check3}
     else
      begin
       setLength(cath2ClusterCount,0);
       setLength(cath2H0,0);
       setLength(cath2Pb,0);
       setLength(cath2NodeHist,0);              //centroidsNb+1,cath2Nbr+1);
      end;

 if CheckBox4.Checked then
       begin
        setLength(cath3ClusterCount,cath3Nbr+1);
        setLength(cath3H0,cath3Nbr+1);
        setLength(cath3Pb,cath3Nbr+1);
        setLength(cath3NodeHist,cath3Nbr+1);    //centroidsNb+1,cath3Nbr+1);
       end
     else
      begin
       setLength(cath3ClusterCount,0);
       setLength(cath3H0,0);
       setLength(cath3Pb,0);
       setLength(cath3NodeHist,0);             //centroidsNb+1,cath3Nbr+1);//centroidsNb+1,cath3Nbr+1);
      end;
 if CheckBox28.Checked then
       begin
        setLength(cath4ClusterCount,cath4Nbr+1);
        setLength(cath4H0,cath4Nbr+1);
        setLength(cath4Pb,cath4Nbr+1);
        setLength(cath4NodeHist,cath4Nbr+1);
       end
     else
      begin
       setLength(cath4ClusterCount,0);
       setLength(cath4H0,0);
       setLength(cath4Pb,0);
       setLength(cath4NodeHist,0);
      end;{check28}
    end {not check1}
   else //if not CheckBox1.Checked then  (no classifications)
    begin
     setLength(cath1ClusterCount,0);
     setLength(cath2ClusterCount,0);
     setLength(cath3ClusterCount,0);
     setLength(cath4ClusterCount,0);
    end;{not form1.CheckBox1.Checked}
    DistributionsRAMresources(nodeHeapTop,callChain);   // ++++++++++++new procedure++++++++++++ 13062021
   except
   error47('a lot of miscelaneous small arrays could not be created, procedure "RAMresources"');
   end;
   application.ProcessMessages;                                                           //parametry pierwszego węzła drzewa wynikowego
End;{RAMresources}

 procedure DataReading(const xDescr:shortString;callChain:shortString);

 var s:string;

  procedure Radio2(callChain:shortString);
  //make options interface accessible on data reading finish
   begin
    callChain:=callChain+'>Radio2';
    with form1 do
    if not radioGroup2.ItemIndex in [7,8,9,10] then //check30=RTCC
       ShowMessage(callChain+#13#10+delAmpers(('The checkBox "'+checkBox30.caption+'" has been set to false (if it wasn''t), because there'+
       ' is no point in averaging of the power spectrum, nevertheless you can try it.'#13#10#13#10'The parameter'#13#10#13#10+
       '"'+form1.Label1.Caption+'"'#13#10#13#10'has been set to a value '+intToStr(FFTwindowsWidth)+
       #13#10'Change it if necessary...')))
    else
       ShowMessage(callChain+#13#10+delAmpers(('The parameter'#13#10+'"'+Label1.Caption+'"'+
       #13#10'has been set to a value '+edit1.Text+' due to found settings, i.e. "'+RadioGroup12.Caption+
       '\'+RadioGroup12.Items[RadioGroup12.itemIndex]+'",'+#13#10'while vector size is='+intToStr(vectorsSize)+'.'+
       #13#10'This can not be changed because of RAM allocations which were already done.'+
       #13#10'Now set of taken into account vectors component (features) is ='+form1.label112.Caption +'.'+
       #13#10'Change it if necessary...')));
    button22ClickInside(0,form1.Button1);//make Option interface accessible
    optionsSelected:=false;
    repeat
     application.ProcessMessages; //wait for button "OK" click, do not remove it!!!
    until optionsSelected;
    with form1 do
     begin
      mainMenu1.Items[2].Enabled:=false;           //TCCR                standardise
      edit17.Enabled:=false; edit18.Enabled:=false; edit39.enabled:=false;                          //directories of: report, tree, collection
      form1.button17.enabled:=false; form1.button18.enabled:=false; form1.button10.enabled:=false;
     end;
   end;{Radio2}

  procedure finishDataStepIn(callChain:string);

   Begin
    callChain:=callChain+'>finishDataStepIn';
    if TTextRec(reportFile).Mode=fmClosed then                 //21042022
    openReportFile(callChain);
    with form1 do
     begin
      s:=edit5.Text;
      if length(s)>=44 then label141.Hint:=s;
      label141.Caption:=s;
      if spc_txt then label142.caption:=StreamNamesArr[StreamIdx] else label142.caption:='does not concern as it is only one in the text data version';
      label100.Visible:=false;label60.Visible:=false; label157.Visible:=false;
     end;
    dataReadingBox(callChain);
    with form1 do
    if checkBox30.Checked then                 //remove time constant contribution
     begin
      if extension='.spc' then
       begin
        Edit22.Text:=floatToStr(frameStep);  edit26.Text:=edit22.Text;
        Edit23.Text:=floatToStr(rate);       edit27.Text:=edit23.Text;
       end
     end
    else
     begin
      Edit22.Text:=XXX;  edit26.Text:=edit22.Text;
      Edit23.Text:=XXX;  edit27.Text:=edit23.Text;
     end; {if}
     if CentroidsNb_glob<=0 then error42(CentroidsNb_glob,form1.edit2,form1.label5,'procedure dataReading');
     with form1 do
      begin
       if checkBox19.Checked then edit7.Text:=xxx                                                           //check19 - Degresive isolation set power treshold
       else Edit7.Text:=intToStr(round(0.5+readEventNbr/(8*CentroidsNb_glob)));                            //edit7: rare events power treshold for isolation
       label160.Caption:=edit7.Text;
      end;
    radio2(callChain);
   End;{finishDataStepIn}

   procedure dataReadingControlSettings;
    Begin
     with form1 do
      begin
       button12.Visible:=false;
       button15.visible:=true;
       button15.enabled:=true;//12: "Start quantization, 15: "show next vector"
       Application.ProcessMessages;

       button24.Visible:=false;
       Application.ProcessMessages;
       GroupBox1.Left:=GroupBox2.Left;
       groupBox1.Visible:=true;    button3.Visible:=not groupbox1.Visible;

       checkBox10.Visible:=false;
       with form1.CheckBox13 do begin Checked:=true; Enabled:=true end;
       checkBox21.Visible:=false;
       checkBox25.Visible:=false;
       checkBox27.Visible:=false;
       checkBox38.Visible:=false;
       CheckBox46.Enabled:=true;

       Label60.Color:=form2.CheckBox13.Color;
       Label66.Caption:='';
       label64.Visible :=false;  //66='Program finished...'; 64='Average Information Radius...
       Label100.Color:=form2.CheckBox13.Color;
       Label157.Color:=form2.CheckBox12.Color;

       pageControl2.Visible:=false;
       panel1.Visible:=true;
       if button15.CanFocus then Button15.SetFocus;
       Application.ProcessMessages;
      end;{with}
    End;{dataReadingControlSettings;}

  Begin //----------------------------------DataReading--------------
   callChain:=callChain+'>DataReading';
   finishDataStepIn(callChain);
   dataReadingControlSettings;
   if spc_txt then
    begin
     s:='inspection';
     MemoryReservation(readEventNbr,callChain);
     form1.label53.caption:=intToStr(readEventNbr);
     SPCvectorAndCathListRead(readEventNbr)  //,xDescr u. 11082020
    end
   else
    begin
     s:='reading';
     MemoryReservation(wholeEventNbr,callChain);
     form1.label53.caption:=intToStr(readEventNbr);
     if (sessionCounter>0) or  PreprocessChange then
      begin
       inputer:=txtPreprocessor;
       TXTvectorAndCathListRead(readEventNbr);
      end
     else TXTvectorAndCathListRead(wholeEventNbr);   //,xDescr u.11082020//------------------------------------------------------------------
     trueEventNbr:=high(trueEventNbr);//wholeEventNbr;  debug prp, 241019
    end;
    with form1 do
     begin
      Edit12.Text:=intToStr(readEventNbr); // form1.GroupBox15.Visible:=false; 030320
      checkBox10.Enabled:=true;checkBox21.Enabled:=true;checkBox38.Enabled:=true;   //Overlay graphs, 100% reference for error, clipping
     end;
   with form1 do
    if FeatureSetCheck or
    (application.MessageBox(pchar('Data '+s+' finished. Click yes, if you want to check options (strongly recommended!)'#13#10+
    'After then click "'+button12.caption+'" to begin processing'),'Check options',4{mb_YesNo})=6)//idYes=6
    then
     begin
      checkbox36.Enabled:= false; edit29.Enabled:=false;
      controlPageShow(0,form1.Button1);
     end {if}
    else
     begin
      InitWrite(callChain);
      if checkBox9.Checked then with groupBox2 do begin top:=label56.Top; left:=panel2.Left+panel2.Width +80 end;
      groupBox2.Visible:=checkBox9.Checked  or checkBox23.checked;
      Button12.Visible:=true;  button3.Visible:=button12.Visible;
      if form1.button12.CanFocus then form1.button12.SetFocus;
      label66.Caption:='Event''s Space Quantization';
     end;{ else}
   form1.groupbox1.Visible:=false; form1.button3.Visible:=not form1.groupbox1.Visible; form1.MainMenu1.Items[2].Enabled:=true;
   application.ProcessMessages;
   setClassifiersNumbers(cath1Nbr,cath2Nbr,cath3Nbr,cath4Nbr);
   dataread:=true;  PreprocessChange:=false;
   stopReading:=false;//przeniesione z końca  vectorAndCathListRead; w. 2505, 05.11.08
    with form1 do    //25062022
     begin
      button15.enabled:=false;
      checkBox13.Enabled:=false;  checkBox13.Checked:=false;
      checkBox14.Enabled:=false; checkBox15.Enabled:=false;
      checkBox26.Enabled:=false;  checkBox46.Enabled:=false;
      checkBox10.Visible:=True; checkBox21.Visible:=True; checkBox38.Visible:=True; //  Overlay graphs; 100% reference reference for error; clipping
     end;
   form1.button21.Enabled:=true;
  End;{DataReading}

 procedure readExcludeSet(treeFileDir,callChain:String);
 //czyta zbiór zdarzeń wykluczanych znalezionych w poprzednim przebiegu
 //reads previous analysis settngs and found at that time set of excluded events
 type TSAC=array[0..3] of int64;
 var
  i, readExcludeEventsNbr : longword;
                     sTmp : String;
                j,k,l,m,n : integer;
              tempMegaSet : TarrSet;
                    logos : boolean;
                      SAC : TSAC;


 Begin     //---------------------------------readExcludeSet----------------------
  callChain:=callChain+'>readExcludeSet';
  showMessage('Attention!'#13#10'The program works in the "'+form1.RadioGroup3.Items[form1.RadioGroup3.itemIndex]+
   '" mode.'#13#10'All settings by which the exclude set was obtained will be automatically restoread.'#13#10+
   'The settings and the exclude set itself are read from the tree file.');
  form1.edit36.text:=TreeFileDir;
  assignFile(treeFile,treeFileDir);
  reset(treeFile);
  with form1 do
   begin
 {1} readln(treeFile,i,sTmp);                  //': 0 - "',form1.radiogroup12.Items[0],'", 1 - "',form1.radiogroup12.items[1],'"');//CART|centroids dividing method, if =0 then CART, if =1 then centroids');
     form1.RadioGroup12.ItemIndex:=i;         //CART/centroids
 {2} readln(treeFile,waveFileDir);
     readln(treeFile,sTmp);            //Teaching events file dir
     if sTmp<>inpFileDir then error67(sTmp,inpFileDir,callChain);
     readln(treeFile,reportFileDir);        //Report file dir
 {3} readln(treeFile,readExcludeEventsNbr,sTmp);   //data vectors which were read from the teaching events file');
     if readExcludeEventsNbr<readEventNbr then error68(readExcludeEventsNbr,readEventNbr,callChain);
     readln(treeFile,wholeEventNbr,sTmp); //containing "wholeEventNbr" events (i.e. vectors)
 {4} readln(treeFile,sTmp);              //,' - analysed feature, radiogroup "',form1.RadioGroup2.Caption,'" item index and the item''s name');
 {5} readln(treeFile,heapTop,CentroidsNb_glob,lifterTreshold,sTmp);// ' - heap size, centroids number, lifter treshold ');
     form1.Edit2.Text:=intToStr(CentroidsNb_glob);
 {6} readln(treeFile,nc,sTmp);
     with form1 do
      begin
      edit1.text:=intToStr(nc); Label144.Caption:=intToStr(nc); Label86.Caption:=intToStr(nc);  //metryczki
     end;
 {7} with paramRec do  // ' wave FFT windows width, wave FFT windows shape ("',delAmpers(form2.radiogroup7.Items[pWinShape]),'"), F0 FFT windows width, F0 FFT windows shape ("',delAmpers(form2.radiogroup7.Items[pF0WinShape]),'")');    //windows width, windows shape
      begin
       readln(treeFile,FFTwindowsWidth,pWinShape,F0Count,pF0WinShape,sTmp);
       form2.edit8.Text:=intToStr(FFTwindowsWidth);
       form2.RadioGroup7.ItemIndex:=pWinShape;
       form2.label24.Caption:=intToStr(F0count);
       form1.RadioGroup33.ItemIndex:=paramRec.pF0WinShape;
       form2.RadioGroup3.ItemIndex:=paramRec.pF0WinShape;
      end;
 {8} readln(treeFile,sTmp); //text info: ' coded cathegories sets values (in the MegaSet format)
     for i:=0 to 3 do read(treeFile,SAC[i]); read(treeFile); readln(treeFile,sTmp); cath1set:=TcharSet(SAC);
     for i:=0 to 3 do read(treeFile,SAC[i]); read(treeFile); readln(treeFile,sTmp); cath2set:=TcharSet(SAC);
     for i:=0 to 3 do read(treeFile,SAC[i]); read(treeFile); readln(treeFile,sTmp); cath3set:=TcharSet(SAC);
     for i:=0 to 3 do read(treeFile,SAC[i]); read(treeFile); readln(treeFile,sTmp); cath4set:=TcharSet(SAC);
 {9} readln(treeFile,sTmp);
     featureMegaSet:=MegaSetConstructor(sTmp);
     label112.caption:=sTmp;  label172.Caption:=label112.Caption;                                                //label112 - resulting features set;
     label117.Caption:=label112.caption;label165.Caption:=label112.caption; //The most important settings, groupBox10
{10} readln(treeFile,i,j,k,l,m,n,sTmp);                                    //Classificators for supervised training:, degressive isolation
     CheckBox1.checked:=boolean(i); CheckBox1.tag:=1;           CheckBox1Click(CheckBox1);
     CheckBox2.checked:=boolean(j);                             CheckBox2Click(CheckBox2);   //cath1
     CheckBox3.checked:=boolean(k);                             CheckBox3Click(CheckBox3);   //cath2
     CheckBox4.checked:=boolean(l);                             CheckBox4Click(CheckBox4);   //cath3
     CheckBox28.checked:=boolean(m);                            CheckBox28Click(CheckBox28); //cath4
     CheckBox19.checked:=boolean(n);                                                         //degressive isolation treshold
     checkBox48.Checked:=checkBox1.Checked;
     checkBox50.Checked:=checkBox2.Checked;
     checkBox51.Checked:=checkBox3.Checked;
     checkBox52.Checked:=checkBox4.Checked;
     checkBox53.Checked:=checkBox28.Checked;
{11} readln(treeFile,k,l,sTmp); CheckBox30.checked:=boolean(k);   CheckBox30Click(CheckBox30);//averaging On, Off '
                                CheckBox39.checked:=boolean(l);   CheckBox39Click(CheckBox39); //standardise events
{12} readln(treeFile,k,sTmp);        ComboBox1.itemIndex:=k;          //averaging method'
{13} readln(treeFile,AveragingTime,sTmp);                             // averaging time'
{14} readln(treeFile,NbrOfFrames,sTmp);                               //number of frames'
{15} readln(treeFile,FrameStep,sTmp);                                 //analysis step'#13#10,
{16} readln(treeFile,rate,sTmp);                                      //wave sampling frequency'#13#10,
{17} readln(treeFile,rareEventNbr1,rareEventNbr2,sTmp);               //rareEventNbr1, rareEventNbr2'#13#10,
{18} readln(treeFile,k,sTmp); radiogroup4.ItemIndex:= k;              //distortion =mean|sum of distances
                              radiogroup11.ItemIndex:=k;                            // weighting window shape (for WAW input signal)'#13#10,
{19} readln(treeFile,k,sTmp); radiogroup12.ItemIndex:=k;      RadioGroup12Click(RadioGroup12);                       // Set dividing method (CART|Centroids)
{20} readln(treeFile,k,sTmp); radiogroup22.ItemIndex:=k;      RadioGroup22Click(RadioGroup22);                       // kryteria wyboru zbioru do podziału'#13#10,
{21} readln(treeFile,k,sTmp); radiogroup23.ItemIndex:=k;      RadioGroup23Click(RadioGroup23);                       // kryteria wyboru cechy w trybie CART wg wartości której był dzielony zbiór'#13#10,
{22} readln(treeFile,k,sTmp); radiogroup24.ItemIndex:=k;      RadioGroup24Click(RadioGroup24);                       // kryteria wyboru zbioru do podziału, wrażenie , tryb supervised training'#13#10,
{23} readln(treeFile,k,sTmp); radiogroup25.ItemIndex:=k;      RadioGroup25Click(RadioGroup25);                       // kryteria wyboru cechy w trybie CART, wrażenie , tryb supervised training'#13#10,
{24} readln(treeFile,k,sTmp); radiogroup26.ItemIndex:=k;      radioGroup15.ItemIndex:=k;                      // kryteria wyboru zbioru do podziału, unsupervise|supervised training (0 i 1 odpowiednio)'#13#10,
{25} readln(treeFile,k,sTmp); radiogroup27.ItemIndex:=k;                            // kryteria wyboru cechy w trybie CART, unsupervise|supervised training (0 i 1 odpowiednio)'#13#10,
{26} readln(treeFile,k,sTmp); checkBox42.checked:=boolean(k); CheckBox42Click(CheckBox42);                      //CART-like
{27} repeat
      readln(treeFile,sTmp);   //Quantization tree
      logos:=(sTmp='Exclude set:') or seekEof(treeFile);
     until logos;
     if  seekEof(treeFile) then begin error2(treeFile);exit end;
     try
{28}  readln(treeFile,excludeSetCard,sTmp);  form1.label49.caption:=intTostr(excludeSetCard);           //'Exclude set'
      form1.label6.Caption:='Actual';
      form1.Label167.Caption:=intToStr(excludeSetCard);
      if excludeSetCard<=0 then
        begin
         error44;
         emptyMegaSet(excludeEventsMegaSet);
         closeFile(treeFile);
         form1.RadioGroup3.ItemIndex:=0;
         exit
        end;
      setLength(excludeEventsMegaSet,(readExcludeEventsNbr+1) div 8+1);
{29}  for i:=0 to (readExcludeEventsNbr+1) div 8 do
       begin
        control1:=i;
        read(treeFile,excludeEventsMegaSet[i]);       //03.11.05, zbiór zdarzeń b. rzadkich       i:=0 to (n+1) div 8 , bo zbiór jest zapisywany do struktury zdolnej pomieścić całośĆ  i całą tę strukturę należy wczytać!
       end;
       readln(treeFile);
     except
      error45(excludeSetCard,wholeEventNbr,wholeEventNbr);
     end;{try}
  end;{with}
  closeFile(treeFile);
  i:=cardMegaSet(excludeEventsMegaSet);
  if i<>excludesetCard then error53(i,excludesetCard);
 (* try
   setLength(excludeEventsMegaSet,(trueEventNbr+1) div 8+1);  //przywrócenie długości tablicy kodującej zbiór dostosowany do aktualnej ilości danych; jest też w RAMresources!
  except                                             //to chyba na wszelki wypadek, gdyby excludeEventsMegaSet zastosowano do innych danych?
   error47('exclude set, procedure "readExcludeSet" (2)');
  end; *)
  if i>0.05*readEventNbr then error66(i,readEventNbr,excludeEventsMegaSet,callChain);
  ResponseCheckerSettings;
  initWrite(callChain);
 End; {readExcludeSet}

 function IRmax(M:word;checkBox:TcheckBox):double;
//M - Number of cathegory values
 Begin
  if checkBox.checked then
  IRmax:= (1/(M*ln2))*ln(2/(M+1))+(1/ln2)*ln(2*M/(M+1))+(M-1)/M
  else IRmax:=0;
 End;

function stretch(const cath1IRmax,cath2IRmax,cath3IRmax,cath4IRmax:double):double;
//znaleźć największą wartość
 Begin
   result:=cath1IRmax;
   if result<cath2IRmax then result:=cath2IRmax;
   if result<cath3IRmax then result:=cath3IRmax;
   if result<cath4IRmax then result:=cath4IRmax;
 End;

procedure frameStretches(const eventNbr:longWord);
//określa wartości maksymalne funkcji i ramek wykresów
var wsp:double;
 Begin //cath1IRmax,cath2IRmax,cath3IRmax,cath4IRmax
   //IR
   with form1 do
   begin
   cath1IRmax:=IRmax(cath1Nbr,checkBox2);
   cath2IRmax:=IRmax(cath2Nbr,checkBox3);
   cath3IRmax:=IRmax(cath3Nbr,checkBox4);
   cath4IRmax:=IRmax(cath4Nbr,checkBox28);
   end;
   IRStretch:=Stretch(cath1IRmax,cath2IRmax,cath3IRmax,cath4IRmax);
    //error
   wsp:=100/eventNbr;
  if form1.CheckBox21.checked then  //100% reference for error graphs
   begin
    cath1ErrMax:=100;  cath2ErrMax:=100;  cath3ErrMax:=100;cath4ErrMax:=100;
   end
   else
   begin
    cath1ErrMax:=nodeprops[0].cath1RecErr*wsp;
    cath2ErrMax:=nodeprops[0].cath2RecErr*wsp;
    cath3ErrMax:=nodeprops[0].cath3RecErr*wsp;
    cath4ErrMax:=nodeprops[0].cath4RecErr*wsp;
   end;
   errStretch:=stretch(cath1ErrMax,cath2ErrMax,cath3ErrMax,cath4ErrMax);
 End;{frameStretches}

Procedure Frames(check10:boolean;callChain:string);
//procedure IRframe(Panel:TPanel;canvas:tcanvas;const classNbr:Word; const stretch:double; ceil1,ceil2,ceil3,ceil4:double; var wspx,wspy,topHeight:double);

Begin
 callChain:=callChain+'>Frames';
 with form1 do
 begin
  if check10 and oncePerformed and not errStretchChange then exit;   //nakładaj wykresy (overlay graphs)
  errStretchChange:=false;     //zmiana referencji wykresów błędu
  IRframe(Panel2,Canvas,CentroidsNb_glob,nodeProps[0].meanDistance,0,0,0,0,wspx2,wspy2,topHeight2,false,label5.caption{'Nbr of groups'},callChain);
  IRframe(Panel3,Canvas,CentroidsNb_glob,1.1*IRstretch,cath1IRmax,cath2IRmax,cath3IRmax,cath4IRmax,wspx3,wspy3,topHeight3,true,label5.caption{'Nbr of groups'},callChain);
  IRframe(Panel4,Canvas,CentroidsNb_glob,errStretch,0,0,0,0,wspx4,wspy4,topHeight4,false,label5.caption{'Nbr of groups'},callChain);//cath1ErrMax,cath2ErrMax,cath3ErrMax,cath4ErrMax
 end;
End;{Frames}

procedure outputGraphDataPrepare(const eventNbr:longWord;callChain:string);
 //prepares initial settings of parameters of grahs which illustrate results (przygotowuje początkowe parametry grafów obrazujących wyniki)
 var nodePercNorm : double;
  Begin
   callChain:=callChain+'>outputGraphDataPrepare';
   with form1 do
    begin
     panel3.Left:=panel2.Left;   panel4.Left:=panel2.Left;   panel7.Left:=panel2.Left;
     panel3.Width:=panel2.Width; panel4.Width:=panel2.Width; panel7.Width:=panel2.Width;
     NodeWspx:=panel2.width/(2*CentroidsNb_glob);  //(2*CentroidsNb_glob-1) = nbr_of_nodes_in_graph computed on the basis of a given number of groups
     NodeCounter:=0;
    end;{with}
   frameStretches(eventNbr);
   frames(form1.checkbox10.Checked,callChain);
   prevIRcath1:=0;
   prevIRCath2:=0;
   prevIRCath3:=0;
   prevIRCath4:=0;
   NodePrevIRcath1:=0;   //!!!  są powtórzone
   NodePrevIRcath2:=0;
   NodePrevIRcath3:=0;
   NodePrevIRcath4:=0;
   prevDistortion:=nodeprops[0].meandistance;
   NodePrevDistortion:=prevDistortion;       //!!!  są powtórzone
     prevErrcath1:=100*nodeProps[0].cath1RecErr/eventNbr;
     prevErrCath2:=100*nodeProps[0].cath2RecErr/eventNbr;
     prevErrCath3:=100*nodeProps[0].cath3RecErr/eventNbr;
     prevErrCath4:=100*nodeProps[0].cath4RecErr/eventNbr;
   percNorm_glob:=100/eventNbr;
    //if step=1 then     wklejone 290220
   with NodeProps[0] do  //startNodeIndex
    begin
     NodePrevX:=form1.panel2.Left +wspx2;// nodeCurrX;
     NodePrevDistortion:=meanDistance;//t9;
     NodePrevIRcath1:=cath1Ir;
     NodePrevIRcath2:=cath2Ir;
     NodePrevIRcath3:=cath3Ir;
     NodePrevIRcath4:=cath4Ir;
     nodePercNorm:=100/cardinal;
     NodePrevErrcath1:=NodePercNorm*cath1RecErr;
     NodePrevErrCath2:=NodePercNorm*cath2RecErr;
     NodePrevErrCath3:=NodePercNorm*cath3RecErr;
     NodePrevErrCath4:=NodePercNorm*cath4RecErr;
   end;{if}
  End;{outputGraphDataPrepare}

  Procedure ShowSpaceQuantization(const nc:word; const {nodeHeapTop1,}nodeHeapTop2:integer);
  {
  Shows features space quantization
  }

   procedure centroReset(const Top:word);
    var i,j:word;
    Begin
     for i:=0 to nc do if inMegaSet(i,featureMegaSet) then
      for j:=0 to Top+1 do //2*step+1-1
       begin
        centroArr[i,j]:=1.7e308;
       bordersArr[i,j]:=1.7e308;
      end;
    End; {centroReset}

    procedure takeCentroids(const Top:word);
    //run through the tree and pick up centroids
    var i,j:word;
     begin
      for i:=0 to Top do
       with nodeHeap[i] do
        begin
         for j:=0 to nc do if inMegaSet(j,featureMegaSet) then
          centroArr[j,i]:=nodeProps[i].centroid[j];
        end;{for i}
     end;

   procedure Borders(bordersArr : array of TdbArr;const Top:word);
    var i,j:word;
    begin
     for j:=0 to nc do  if inMegaSet(j,featureMegaSet) then
       begin
        bordersArr[j,0]:=minMax[j].min;
        for i:=1 to top do
          bordersArr[j,i-1]:=(centroArr[j,i-1]+centroArr[j,i])/2;
        bordersArr[j,top]:=minMax[j].max;
       end;{for j}
    end;{Borders}

    procedure sortCentroArr(const Top:word);
    //sorts increasingly columns of centroArr, which is an array of centroids
    //centroArr was created for space qantization showing; it gives possibility to sort coluns of centroids array
    //given in nodeProps to obtain in effect spaces quatization

     procedure QuickSort(var collumn:Tdbarr; l,r:longWord);
     var i,j:longint; x,y:double;
     begin
       i:=l; j:=r; x:=collumn[(l+r) DIV 2];
       repeat
        while collumn[i]<x do i:=i+1;
        while x<collumn[j] do j:=j-1;
        if i<=j then
        begin
         y:=collumn[i]; collumn[i]:=collumn[j]; collumn[j]:=y;
         i:=i+1; j:=j-1;
        end;
       until i>j;
       if l<j then QuickSort(collumn,l,j);
       if i<r then QuickSort(collumn,i,r);
     end;{QuickSort}

    var i:word;
     Begin
      for i:=0 to nc do if inMegaSet(i,featureMegaSet) then
       QuickSort(centroArr[i],0,Top+1); //2*step
     End;{sortCentroArr}

  procedure QuantizationToReport(centroArr : array of TdbArr;const Top:word; s:shortString);
   var i,l:integer; j,k:word;

   procedure underline(const k:byte;const s:shortString;const t:char;out l:integer);
   //t - tick
    var i,j:word;
   Begin
    l:=0;
    write(reportFile,'|',s);
    for j:=0 to nc do  if inMegaSet(j,featureMegaSet) then
     begin
      write(reportFile,t);
      for i:=1 to k*2 do write(reportFile,'=');
      inc(l,k*2+1);
     end;
     writeln(reportFile,'|');
   End; {underline}

   Begin   //-----------------------QuantizationToReport--------------------
    k:=6; //długość zapisu liczby w formacie "naukowym"      floatTostrF(rowsArr[i,j],ffExponent,6,0)
    writeln(reportFile,#13#10'Table 6.',s);
    underline(k,'========','-',l);
    s:='|Features numbers (choosen vectors components numbers)';
    l:=l-length(s);
    write(reportFile,'|        ',s); for i:=1 to l do write(reportFile,' ');
    if l>0 then writeln(reportFile,'|') else writeln(reportFile);
    underline(k,'Interval','-',l);
    write(reportFile,'|  number| ');
    for j:=0 to nc do if inMegaSet(j,featureMegaSet) then
     write(reportFile,j:2*(k-1),' | ');
    writeln(reportFile);
    underline(k,'========','|',l);
    write(reportFile,'|','minimum':8,'|');
    for j:=0 to nc do   if inMegaSet(j,featureMegaSet) then
       write(reportFile,floatTostrF(minMax[j].min,ffExponent,k,1):12,'|'); writeln(reportFile);
    for i:=0 to Top do
     begin
      write(reportFile,'|',i:8,'|');
      for j:=0 to nc do   if inMegaSet(j,featureMegaSet) then
       write(reportFile, floatTostrF(centroArr[j,i],ffExponent,k,1):12,'|'); writeln(reportFile);
     end;{for i}
    write(reportFile,'|','maximum':8,'|');
    for j:=0 to nc do   if inMegaSet(j,featureMegaSet) then
       write(reportFile,floatTostrF(minMax[j].max,ffExponent,k,1):12,'|'); writeln(reportFile);
    underline(k,'========','=',l);
    flush(reportFile);
   End;{QuantizationToReport}

   var n1:int64;
   Begin   //----------------------------------------------ShowSpaceQuantization-----------------------------------
    flush(reportFile);
    setLength(centroArr,nc+1,nodeHeapTop2+2);      //2*step+1
    setLength(bordersArr,nc+1,nodeHeapTop2+2);      //2*step+1
    n1:=sizeOf(centroArr);
    centroReset(nodeHeapTop2);
    takeCentroids(nodeHeapTop2);
    QuantizationToReport(centroArr,nodeHeapTop2,'A. Centroids vectors before sorting and min-max of all events features vectors components ranges');
    sortCentroArr(nodeHeapTop2);
    QuantizationToReport(centroArr,nodeHeapTop2,'B. Centroids vectors after sorting'+#13#10'Features Space Quantization - min-max range of all events features vectors and centers of intervals');
    Borders(bordersArr,nodeHeapTop2);
    QuantizationToReport(bordersArr,nodeHeapTop2-1,'C. Space quantization borders; b[j,i-1]:=(c[j,i-1]+c[j,i])/2;'#13#10+
                                                 'where b - border, c - centroid, j- vectors component index, i - node index');
    flush(reportFile);
   End;{ShowSpaceQuantization}

 procedure standardDeviationRatio;

  var
   leftRatioVector,rightRatioVector,ratioSumVector : TmeanVector;  //, leftRatioSumVector
                            stepMult, meanstepMult : TmeanVector;
                                            mult,r : extended;
                                 cardSum,iteratSum : longWord;
                                       counter,nof : word;

 procedure TreeExaminer(nodeAddr:word;c:char);
  {
  biegnie po drzewie i oblicza, o ile odchyleń standardowych odległe są wartości składowych wektorów opisujących
  zdarzenia w węźle przodka od tych składowych w węzłach następników
  abs(son) - ponieważ w trybie CART i CART-like pojawiają się rozbicia niewykorzystane połączone ujemnym parametrem son
  nof - number of features
  }
   var i:word;
   Begin
    with nodeHeap[nodeAddr],nodeProps[nodeAddr] do
     if son<>0 then
      Begin
       inc(counter);    r:=0;
        for i:=0 to nc do
         if inMegaSet(i,featureMegaSet) then
          begin
          // c1:=          nodeProps[nodeHeap[nodeAddr].son].centroid;
          // c2:=          nodeProps[nodeHeap[abs(nodeHeap[nodeAddr].son)].brother].centroid;
           stepMult[i]:=(nodeProps[nodeHeap[abs(nodeHeap[nodeAddr].son)].brother].centroid[i]-nodeProps[abs(nodeHeap[nodeAddr].son)].centroid[i]);//nodeProps[nodeHeap[abs(son)].brother].centroid[i]
           if nodeStDev[i]>abs(minExtended*stepMult[i]) then stepMult[i]:=stepMult[i]/(2*nodeStDev[i])
           else stepMult[i]:=minExtended*stepMult[i];
           meanStepMult[i]:=meanStepMult[i]+cardinal*stepMult[i];
           r:=r+stepMult[i];
          end;{for}
         mult:=mult+r*cardinal;;
       inc(cardSum,cardinal); inc(iteratSum,iterNbr);

     //To report
       with nodeProps[nodeAddr] do
        write(reportFile,'|',counter:5,'|',nodeStep:5,'|',nodeAddr:5,'|',c:2,' |',cardinal:6,'|',cardSum:6,'|',iterNbr:6,'|',mult/(cardSum*nof):6:3,'|');
       if form1.RadioGroup5.ItemIndex=2 then  //print means and vectors
        begin
         for i:=0 to nc do if inMegaSet(i,featureMegaSet) then write(reportFile,'|',stepMult[i]/nof:6:3);
         writeln(reportFile,'|');
        end
       else writeln(reportFile);{if}
       flush(reportFile);
       TreeExaminer(abs(nodeHeap[NodeAddr].son),'s')
      End;{son<>0}
    if nodeHeap[nodeAddr].brother>0 then TreeExaminer(nodeHeap[NodeAddr].brother,'b');
   End;{TreeExaminer}

 procedure underline;
  var i:word;
  Begin
    write(reportFile,'|=====|=====|=====|===|======|======|======|======|');
    if form1.RadioGroup5.ItemIndex=2 then   //print means and vectors
     begin
      for i:=0 to nc do if inMegaSet(i,featureMegaSet) then write(reportFile,'|======');
      writeln(reportFile,'|')
     end
    else writeln(reportFile);
  End;

 procedure TableCaption;
  var i:word;
  Begin
   write(reportFile,#13#10'Table 7. Standard deviation ratio estimates.');
   if form1.RadioGroup5.ItemIndex=2 then writeln(reportFile,'      ||Standard deviation multipiers for used vectors components')
   else writeln(reportFile);
   underline;
   write(reportFile,'|  No | Step| node|son|  car-|sum of|Nbr of| Step |');
   if form1.RadioGroup5.ItemIndex=2 then  writeln(reportFile,'|Used vectors components numbers')
   else writeln(reportFile);
   write(reportFile,'|     |     |addr |br.| dinal|cards |Iterat|multip|');
   if form1.RadioGroup5.ItemIndex=2 then   //print means and vectors
    begin
     for i:=0 to nc do if inMegaSet(i,featureMegaSet) then write(reportFile,'|',i:6);
     writeln(reportFile,'|');
    end
   else writeln(reportFile);
   underline;
  End;

 var i:word;
 Begin   //--------------------------------------------------- standardDeviationRatio --------------
  counter:=0;
  setLength(leftRatioVector,vectorsSize+1); setLength(rightRatioVector,vectorsSize+1); setLength(ratioSumVector,vectorsSize+1);
  setLength(stepMult,nc+1);setLength(meanStepMult,nc+1);
  mult:=0;  cardSum:=0; iteratSum:=0;  r:=0;  nof:=0;
  for i:=0 to vectorsSize do if inMegaSet(i,featureMegaSet) then  begin ratioSumVector[i]:=0; meanStepMult[i]:=0; inc(nof) end;
  TableCaption;
  TreeExaminer(0,'0');
  underline;
  //totals
  write(reportFile,'|Totals    -     -   -|',cardSum:6,'|','-':6,'|',iteratSum:6,'|',mult/(cardSum*nof):6:3,'|');
  if form1.RadioGroup5.ItemIndex=2 then for i:=0 to nc do if inMegaSet(i,featureMegaSet) then
   write(reportFile,'|',meanStepMult[i]/cardSum:6:3);
  writeln(reportFile,'|');
  underline;
 End;{standardDeviationRatio}

 procedure showNodeFission(nodeNbr:word);

  procedure printCentroid(const nodeAddr:word);
   var m:word;
   Begin
    write(reportFile,'|centroid:|',nodeAddr:9,'|');
    with nodeProps[nodeAddr] do
    for m:=0 to nc do
    if inMegaSet(m,featureMegaSet) then write(reportFile,'|',round(centroid[m]):10); writeln(reportFile,'|'#13#10)
   End;{printCentroid}

  procedure NodeSetToReport(const nodeAddr:word;s:string);
   var i:longWord;
       m:word;
   Begin
    writeln(reportFile,s);
    printCentroid(nodeAddr);
    with NodeProps[nodeAddr] do
     begin
      for i:=lb to hb do
       begin
        write(reportFile,'|',i:9,'|',sbl[i]:9,'|');
        for m:=0 to nc do
         if inMegaSet(m,featureMegaSet) then write(reportFile,'|',vectList[sbl[i],m]:6); writeln(reportFile,'|')
       end;{for i}
     end;{with}
   End;{NodeSetToReport}

  procedure underline;
   var k:word;
   Begin
    write(reportFile,'|=========|=========|');
    for k:=0 to nc do if inMegaSet(k,featureMegaSet) then write(reportFile,'|==========');writeln(reportFile,'|');
   End;

   procedure Caption;
    var k:byte;
    Begin
     writeln(reportFile,#13#10'Table 8. Fissios of chosen nodes, i.e. of: ', form1.label136.caption);
     underline;
     write(reportFile,'|'); write(reportFile,'  events |  events |'); write(reportFile,'|Features centroids   ');
     k:=cardMegaSet(featureMegaSet);
     for k:=2 to k do if inMegaSet(k,featureMegaSet) then write(reportFile,'          ');writeln(reportFile,'|');
     write(reportFile,'|'); write(reportFile,'   index |addresse |');
     for k:=0 to nc do if inMegaSet(k,featureMegaSet) then write(reportFile,'|',k:10);     writeln(reportFile,'|');
     underline;
    End;

  var k,l:word;  s:string;
 Begin//------------------- ShowNodeFission ---------------
  Caption;      l:=high(nodeHeap);
  for k:=0 to nodeNbr do
   if inMegaSet(k,FissionMegaSet) and (k<l) then
    with nodeHeap[k] do
     if son>0 then
      begin
       writeln(reportFile,#13#10'Fission of the node ',k,'; events count=',nodeProps[k].cardinal,', descendants: son=',
        son,'broth=',nodeHeap[(nodeHeap[k].son)].brother,
        '. Fission distance=',nodeProps[k].fissionDistance:12);
       printCentroid(k);
       s:='Node '+intToStr(son)+'; first descendant, events count='+intToStr(nodeProps[abs(son)].cardinal);
       NodeSetToReport(abs(son),s);
       s:='Node '+intToStr(nodeHeap[(nodeHeap[k].son)].brother)+'; second descendant, events count='+
                 intToStr(nodeProps[nodeHeap[(nodeHeap[k].son)].brother].cardinal);
       NodeSetToReport(nodeHeap[(nodeHeap[k].son)].brother,s);
      end {with}
     else writeln(reportFile,#13#10'The ',k,'-th node was not splitted') 
    else excludeFromMegaSet(k,fissionMegaSet);
  form1.edit34.Text:=MegaSetConstructorReconstruction(fissionMegaSet);
  underline;
 End;{ShowNodeFission}

 procedure perform(callChain:string);
 var
  performance:string;  k:word;

 procedure CartHistReset;  //zerowanie histogramu użycia cech w CART
  var i,j:word;
  Begin
   if form1.RadioGroup12.ItemIndex=0 then  //CART
    begin  //array[0..nc, 0..K] of Word i 1-wymiarową tablicę featureUseCounter:array[0..nc]
     for i:=0 to nc do
      begin
       featureUseCounter[i]:=0;
       for j:=0 to CentroidsNb_glob do featureUseHist[i,j]:=0
      end;
    end;
  End;{histReset}

 var i:word; s:String;
 BEGIN    //---------------------------------perform----------------------------------------------------
  callChain:=callChain+'>perform';
  with form1 do
  begin  //checks: 2, 3, 4, 10 = classifiers: cath 1, 2, 3, 4
   checkBox10.Enabled:=false;checkBox21.Enabled:=false;checkBox38.Enabled:=false;   //Overlay graphs, 100% reference for error, clipping
   if not checkBox2.Checked then  label138.Caption:=xxx else label138.Caption:='Not reached';
   if not checkBox3.Checked then  label139.Caption:=xxx else label139.Caption:='Not reached';
   if not checkBox4.Checked then  label140.Caption:=xxx else label140.Caption:='Not reached';
   if not checkBox28.Checked then label152.Caption:=xxx else label152.Caption:='Not reached';
   if not checkBox10.Checked then onceShowed:=false;
  end;
  dist:=EuclidDist; featureSetCard:=0;  alloc:='b';  step:=0;
  allcath1:=true; allcath2:=true; allcath3:=true; allcath4:=true;
  Checkcath1Set:=cath1Set; Checkcath2Set:=cath2Set; Checkcath3Set:=cath3Set; Checkcath4Set:=cath4Set;
  for i:=0 to nc do
   begin
   control1:=i;
   if  inMegaSet(i,featureMegaSet) then inc(featureSetCard);
   end;
  with form1 do
   if not checkBox10.Checked or not singleClass then  //preserve labels captions values in single class mode when overlay graphs
   begin
    Label75.Caption:=xxx; Label76.Caption:=xxx; Label77.Caption:=xxx; Label150.Caption:=xxx;
    Label45.Caption:=xxx;Label46.Caption:=xxx;Label108.Caption:=xxx;  Label151.Caption:=xxx;
   end; //label66.Caption:='Note! the "Fission distance" is not computed yet!'
  form1.checkBox11.Checked :=true;
  form1.checkBox11.Checked:=application.MessageBox('Turn off "Show history" to save memory!','Warning',mb_yesNo)=idno;
  if form1.RadioGroup3.ItemIndex=1 then   //"Empty"|"Exclude" pass
     begin
      showMessage(callChain+#13#10'Choose a tree file, from which an exclude set should be read');
      if OpenTreeFile(prevTreeFileDir,callChain) then
       if fileExists(prevTreeFileDir) then
         begin
          readExcludeSet(prevTreeFileDir,callChain);
          if excludeSetCard <readEventNbr then
           begin
            performance:='"third" performance. Elements from sets contained less then or aequal '+intToStr(rareEventNbr2)+' members will not be taken into account during centroids computations';
            writeln(reportFile,performance);
           end
          else
           begin
            error69(excludeSetCard,readEventNbr,rareEventNbr2,callChain);
            performance:='"third" performance, i.e. "'+ form1.RadioGroup3.Caption+'/'+ form1.RadioGroup3.Items[1]+ '" was rejected';
            writeln(reportFile,performance);
            flush(reportFile);
            closeFile(reportFile);
            exit
           end
         end
        else
         begin
          flush(reportFile);
          closeFile(reportFile);
          exit
         end {if fileExists}
      else
       begin
        flush(reportFile);
        closeFile(reportFile);
        exit
       end; {if OpenTreeFile}
     end {optionsSelected}
    else;
  RamResources(CentroidsNb_glob,callChain);
  // treeReset;  //blokada 101019; odblokowano 201019;  blok 201019
  CartHistReset; //201019
  if form1.RadioGroup3.ItemIndex=0 then emptyMegaSet(excludeEventsMegaSet);   //zeruj, gdy "first pass"
  S0(callChain);
  label66ColorCaption;
  form1.Button12.Visible:=false; // form1.button3.Visible:=form1.button12.Visible;    blocked 02082023
  application.ProcessMessages;
  //----------------------------perform--------------Zaczyna się!------------(It begins!)----------------------------------------
  OutNormCheckBoxesStates;               //show in report extended info on out and standardise checkboxes states
  currX:=Form1.panel3.left;
  if not form1.CheckBox1.Checked then MakeH0Hist(trueEventNbr,cath1H0,cath2H0,cath3H0,cath4H0,callChain);  //wykonać histogram całej próby
  OutputGraphDataPrepare(trueEventNbr,callChain);
  allcath1:=false; allcath2:=false; allcath3:=false; allcath4:=false;
  performance:=#13#10'First performance'#13#10+
   'Now are detected rare events, which you can exclude from the quantizing process'#13#10'at the next performance (if you judge it for necessary).'#13#10;
  if not form1.checkBox19.Checked then
  if tryStrToInt(trim(form1.Edit7.Text),rareEventNbr1) then
  else
   begin
    while not
     TryStrToInt(inputBox('Correct edit box text',form1.Edit7.Text+' is not correct integer number!',
     intToStr(round(0.5+trueEventNbr/(8*CentroidsNb_glob)))),rareEventNbr1) do;
     form1.Edit7.Text:=intToStr(rareEventNbr1);
     with form1 do label160.Caption:=edit7.Text;
   end;
  secondPass:=false;
  RUN(CentroidsNb_glob,performance,callChain);//,'1');  blok 12.03.09      //****************************************************************
  form1.Button3.Enabled:=true; form1.Button3.Visible:=not form1.GroupBox1.Visible;
  treeToReport;//(performance);
  ToRemoveSet(trueEventNbr,callChain);                                     //zbiór zdarzeń, które mają być pominięte przy obliczaniu centroidów
  if form1.RadioGroup12.ItemIndex=0 then featuresUsageHistToReport;
  if form1.CheckBox54.Checked then excludeSetToReport;                                                      //parametry pierwszego węzła
  saveTree(CentroidsNb_glob, nc,treeFileDir,callChain);                    //,'1'); blok 12.03.09

  ShowSpaceQuantization(nc,2*CentroidsNb_glob-2);

  with form1 do
  // if RadioGroup12.ItemIndex=1 then                                        //tylko dla metody centroidów!
   if RadioGroup5.ItemIndex>0 then standardDeviationRatio;
  if form1.checkBox5.Checked then  ShowNodeFission(nodeNbr);
  LeavesSetsCountsToReport(callChain);
  CloseFile(reportFile);
 if form1.checkBox33.Checked or form1.checkBox35.Checked then
   try
   SetSuspendState(true,false,false);//SuspendOrHibernate(true,false)  05052025
   except
   error80
   end;
  inc(sessionCounter);
   s:='Program finished.'#13#10'See results:'#13#10'report file at "'+reportFileDir+'",'#13#10+
   'tree file at "'+treeFileDir+#13#10'Table2 Collection file at "'+Table2CollectionfileDir+'".';
   if not oncePerformed then s:=s+#13#10#13#10+
   'In next sessions the report and tree directories will be supplied with a session counters, e.g.'#13#10'"'+
   AddSessionCounter(reportFileDir,'Report','txt',sessionCounter)+'"'#13#10' and '#13#10'"'+
   AddSessionCounter(treeFileDir,'Tree','vqt',sessionCounter)+'"'#13#10'adequately.';
  showMessage(s);
  reportFileDir:=AddSessionCounter(reportFileDir,'Report','txt',sessionCounter); form1.Edit17.Text:=reportFileDir;
  prevTreeFileDir:=treeFileDir;//24012021
  treeFileDir:=AddSessionCounter(treeFileDir,'Tree','vqt',sessionCounter);       form1.Edit18.Text:=treeFileDir;
  form1.Edit2.Enabled:=true; form1.checkBox37.Enabled:=true;
  form1.Edit17.Enabled:=true; form1.Edit18.Enabled:=true; form1.Edit39.Enabled:=FALSE;
  form1.button17.enabled:=true; form1.button18.enabled:=true; form1.button10.enabled:=FALSE;
  //form1.Edit1.Enabled:=true;  form1.checkBox37.Enabled:=form1.Edit1.Enabled; blok 28022022
  form1.Edit1.Color:=clYellow;
 END;{perform}

 Begin
 ln2:=ln(2);  newPreprocess:=false;  PreprocessChange:=false;
 prevTreeFileDir:='XXXXXXXX.XXX';
 prevIRcath1:=0;    prevIRcath2:=0;    prevIRcath3:=0;    prevIRcath4:=0;    FFTwindowsWidth:=0;
 prevErrcath1:=100; prevErrCath2:=100; prevErrCath3:=100; prevErrCath4:=100;
 wholeEventNbr:=high(wholeEventNbr);
 trueEventNbr:=high(trueEventNbr);
 AveragingTime:=100; NbrOfFrames:=10; frameStep:=1; rate:=16000; multStdDev:=1;//we take here default values
end.

