unit distributions;

interface
uses VQUnit,sysUtils;

type
       TSumCathRecErrDistr = array of longWord;
           TCathNodesDistr = array of longWord;
              TIRnodeDistr = array of TdbArr;//TdbArr = array of double;
TcathDistortLeafDistribArr = array of array of extended;
              TresultsDistr = array of array of single;
var
                            cath1DistortDistr,cath2DistortDistr,cath3DistortDistr,cath4DistortDistr : TmeanVector;
                                    sumCath1IRdistr,sumCath2IRdistr,sumCath3IRdistr,sumCath4IRdistr : TDbArr;
                sumCath1DistortDistr,sumCath2DistortDistr,sumCath3DistortDistr,sumCath4DistortDistr : TDbArr;
                    SumCath1RecErrDistr,SumCath2RecErrDistr,SumCath3RecErrDistr,SumCath4RecErrDistr : TSumCathRecErrDistr;
                                    Cath1NodesDistr,Cath2NodesDistr,Cath3NodesDistr,Cath4NodesDistr : TCathNodesDistr;
                   cath1DistortLeafDistribArr,cath2DistortLeafDistribArr,cath3DistortLeafDistribArr,
                                                                         cath4DistortLeafDistribArr : TcathDistortLeafDistribArr; //array of array of extended;
                    cath1IRnodeDistrArr,cath2IRnodeDistrArr,cath3IRnodeDistrArr,cath4IRnodeDistrArr : TIRnodeDistr;// = array of array of double;
controlCath1DistortDistr,controlCath2DistortDistr,controlCath3DistortDistr,controlCath4DistortDistr : extended;
                            cath1IRControlSum,cath2IRControlSum,cath3IRControlSum,cath4IRControlSum : double;
            cath1RecErrControlSum,cath2RecErrControlSum,cath3RecErrControlSum,cath4RecErrControlSum : double;
                                                                                            //----------------results arrays-----------------------
                cath1DistortDistrRes,cath2DistortDistrRes,cath3DistortDistrRes,cath4DistortDistrRes,
                                    cath1IRDistrRes,cath2IRDistrRes,cath3IRDistrRes,cath4IRDistrRes,
                    cath1RecErrDistrRes,cath2RecErrDistrRes,cath3RecErrDistrRes,cath4RecErrDistrRes : TresultsDistr;
                            cath1NodeDistrRes,cath2NodeDistrRes,cath3NodeDistrRes,cath4NodeDistrRes : TresultsDistr;

 procedure lastDistribControl(const step:word; const distortion:extended;callChain:shortString);
 procedure DistributionsRAMresources(const HeapTop:word;callChain:shortString);
 procedure ZeroDistrSum;
 procedure MakeDistortionNodeDistributions(const nodeAddr:Word;centroid:TmeanVector;callChain:string);  //MDND
 procedure distrIRscaler(const step:word;callChain:shortString);
 procedure DistribSums(const cathNbr,maxCath:byte; const cathRecErr:longWord; const cathIR:double;const nodeAddr:word;
                         var sumCathRecErrDistr:TSumCathRecErrDistr; var CathNodesDistr:TCathNodesDistr;
                         var sumCathIRdistr:TDbArr;var cathIRnodesDistrArr:TIRnodeDistr;
                         var sumCathDistortDistr:TDbArr;var cathDistortLeafDistribArr:TcathDistortLeafDistribArr;callChain:string);
procedure saveStepDistributions(const step:word);
procedure DistributionsTableToReport(const checkBoxChecked:boolean; const tableId,stepSum, parameter,YName:shortString;const cathNbr:byte; groupNbr:word; const rowsArr:TresultsDistr; const cathCodeList: TcharList);

implementation
 uses unit1,errorsUnit,megaSets;

 procedure lastDistribControl(const step:word; const distortion:extended;callChain:shortString);
  var m:byte;
  Begin
   callChain:=callChain+'>lastDistribControl';
  If form1.RadioGroup18.ItemIndex=1 then
   if not form1.CheckBox1.Checked then
   with form1 do
   begin
    distrIRscaler(step,callChain);
    if checkBox2.Checked then
     begin
      for m:=0 to cath1Nbr do
       begin
        controlCath1DistortDistr:=controlCath1DistortDistr+sumCath1DistortDistr[m];//leaves distortion over cath# values distribution sum
        cath1RecErrControlSum:=cath1RecErrControlSum+sumCath1RecErrDistr[m];
       end;
      error65('Distortion',Y1Name,controlCath1DistortDistr/trueEventNbr,distortion/trueEventNbr,1000,step,callChain);
      error65('Recognition Error',Y1Name,cath1RecErrControlSum,cath1RecErrSum,1000,step,callChain);
     end;
    if checkBox3.Checked then
      begin
       for m:=0 to cath2Nbr do
        begin
         controlCath2DistortDistr:=controlCath2DistortDistr+sumCath2DistortDistr[m];//leaves distortion over cath# values distribution sum
         cath2RecErrControlSum:=cath2RecErrControlSum+sumCath2RecErrDistr[m];
        end;
       error65('Distortion',Y2Name,controlCath2DistortDistr/trueEventNbr,distortion/trueEventNbr,1000,step,callChain);
       error65('Recognition Error',Y1Name,cath2RecErrControlSum,cath2RecErrSum,1000,step,callChain);
      end;
     if checkBox4.Checked then
      begin
       for m:=0 to cath3Nbr do
        begin
         controlCath3DistortDistr:=controlCath3DistortDistr+sumCath3DistortDistr[m];//leaves distortion over cath# values distribution sum
         cath3RecErrControlSum:=cath3RecErrControlSum+sumCath3RecErrDistr[m];
        end;
       error65('Distortion',Y3Name,controlCath3DistortDistr/trueEventNbr,distortion/trueEventNbr,1000,step,callChain);
       error65('Recognition Error',Y1Name,cath3RecErrControlSum,cath3RecErrSum,1000,step,callChain);
      end;
     if checkBox28.Checked then
      begin
       for m:=0 to cath4Nbr do
        begin
         controlCath4DistortDistr:=controlCath4DistortDistr+sumCath4DistortDistr[m];//leaves distortion over cath# values distribution sum
         cath4RecErrControlSum:=cath4RecErrControlSum+sumCath4RecErrDistr[m];
        end;
       error65('Distortion',Y4Name,controlCath4DistortDistr/trueEventNbr,distortion/trueEventNbr,1000,step,callChain);
       error65('Recognition Error',Y1Name,cath4RecErrControlSum,cath4RecErrSum,1000,step,callChain);
      end;
   end;
  End; {lastDistribControl}

 procedure DistributionsRAMresources(const HeapTop:word;callChain:shortString);
  BEGIN
   with form1 do
   Begin
    callChain:=callChain+'>DistributionsRAMresources';
    if not CheckBox1.Checked then  //no classifications
    If form1.RadioGroup18.ItemIndex=1 then
     Begin
        if CheckBox2.Checked then
         begin
      {1}    setLength(cath1DistortDistr,cath1Nbr+1);
      {4}    setLength(sumCath1IRdistr,cath1Nbr+1);
      {5}    setLength(sumCath1RecErrDistr,cath1Nbr+1);
      {6}    setLength(Cath1NodesDistr,cath1Nbr+1);
      {7}    setLength(sumCath1DistortDistr,cath1Nbr+1);

      {2}    setLength(cath1IRnodeDistrArr,HeapTop,cath1Nbr+1);         {nodeHeapTop}
      {3}    setLength(cath1DistortLeafDistribArr,HeapTop,cath1Nbr+1);
      {8}    setLength(cath1DistortDistrRes,HeapTop,cath1Nbr+1);
      {9}    setLength(cath1IRDistrRes,HeapTop,cath1Nbr+1);
     {10}    setLength(cath1RecErrDistrRes,HeapTop,cath1Nbr+1);
     {11}    setLength(cath1NodeDistrRes,HeapTop,cath1Nbr+1);
         end
        else
         begin
       {1}   setLength(cath1DistortDistr,0);
       {2}   setLength(cath1IRnodeDistrArr,0,0);
       {3}   setLength(cath1DistortLeafDistribArr,0,0);
       {4}   setLength(sumCath1IRdistr,0);
       {5}   setLength(sumCath1RecErrDistr,0);
       {6}   setLength(Cath1NodesDistr,0);
       {7}   setLength(sumCath1DistortDistr,0);
       {8}   setLength(cath1DistortDistrRes,0,0);
       {9}   setLength(cath1IRDistrRes,0,0);
      {10}   setLength(cath1RecErrDistrRes,0,0);
      {11}   setLength(cath1NodeDistrRes,0,0);
         end;{check2}

      if CheckBox3.Checked then
         begin
       {1}   setLength(cath2DistortDistr,cath2Nbr+1);
       {4}   setLength(sumCath2IRdistr,cath2Nbr+1);
       {5}   setLength(sumCath2RecErrDistr,cath2Nbr+1);
       {6}   setLength(Cath2NodesDistr,cath2Nbr+1);
       {7}   setLength(sumCath2DistortDistr,cath2Nbr+1);

       {2}   setLength(cath2IRnodeDistrArr,HeapTop,cath2Nbr+1);
       {3}   setLength(cath2DistortLeafDistribArr,HeapTop,cath2Nbr+1);
       {8}   setLength(cath2DistortDistrRes,HeapTop,cath2Nbr+1);
       {9}   setLength(cath2IRDistrRes,HeapTop,cath2Nbr+1);
      {10}   setLength(cath2RecErrDistrRes,HeapTop,cath2Nbr+1);
      {11}   setLength(cath2NodeDistrRes,HeapTop,cath2Nbr+1);

         end{check3}
      else
       begin
       {1} setLength(cath2DistortDistr,0);
       {2} setLength(cath2IRnodeDistrArr,0,0);
       {3} setLength(cath2DistortLeafDistribArr,0,0);
       {4} setLength(sumCath2IRdistr,0);
       {5} setLength(sumCath2RecErrDistr,0);
       {6} setLength(Cath2NodesDistr,0);
       {7} setLength(sumCath2DistortDistr,0);
       {8} setLength(cath2DistortDistrRes,0,0);
       {9} setLength(cath2IRDistrRes,0,0);
      {10} setLength(cath2RecErrDistrRes,0,0);
      {11} setLength(cath2NodeDistrRes,0,0);
       end; {check3}

      if CheckBox4.Checked then
        begin
       {1}  setLength(cath3DistortDistr,cath3Nbr+1);
       {4}  setLength(sumCath3IRdistr,cath3Nbr+1);
       {5}  setLength(sumCath3RecErrDistr,cath3Nbr+1);
       {6}  setLength(Cath3NodesDistr,cath3Nbr+1);
       {7}  setLength(sumCath3DistortDistr,cath3Nbr+1);

       {2}  setLength(cath3IRnodeDistrArr,HeapTop,cath3Nbr+1);
       {3}  setLength(cath3DistortLeafDistribArr,HeapTop,cath3Nbr+1);
       {8}  setLength(cath3DistortDistrRes,HeapTop,cath3Nbr+1);
       {9}  setLength(cath3IRDistrRes,HeapTop,cath3Nbr+1);
      {10}  setLength(cath3RecErrDistrRes,HeapTop,cath3Nbr+1);
      {11}  setLength(cath3NodeDistrRes,HeapTop,cath3Nbr+1);

        end
       else
        begin
       {1}  setLength(cath3DistortDistr,0);
       {2}  setLength(cath3IRnodeDistrArr,0,0);
       {3}  setLength(cath3DistortLeafDistribArr,0,0);
       {4}  setLength(sumCath3IRdistr,0);
       {5}  setLength(sumCath3RecErrDistr,0);
       {6}  setLength(Cath3NodesDistr,0);
       {7}  setLength(sumCath3DistortDistr,0);
       {8}  setLength(cath3DistortDistrRes,0,0);
       {9}  setLength(cath3IRDistrRes,0,0);
      {10}  setLength(cath3RecErrDistrRes,0,0);
      {11}  setLength(cath3NodeDistrRes,0,0);
        end;{check4}

        if form1.CheckBox28.Checked then
          begin
        {1}   setLength(cath4DistortDistr,cath4Nbr+1);
        {4}   setLength(sumCath4IRdistr,cath4Nbr+1);
        {5}   setLength(sumCath4RecErrDistr,cath4Nbr+1);
        {6}   setLength(Cath4NodesDistr,cath4Nbr+1);
        {7}   setLength(sumCath4DistortDistr,cath4Nbr+1);

        {2}   setLength(cath4IRnodeDistrArr,HeapTop,cath4Nbr+1);
        {3}   setLength(cath4DistortLeafDistribArr,HeapTop,cath4Nbr+1);
        {8}   setLength(cath4DistortDistrRes,HeapTop,cath4Nbr+1);
        {9}   setLength(cath4IRDistrRes,HeapTop,cath4Nbr+1);
       {10}   setLength(cath4RecErrDistrRes,HeapTop,cath4Nbr+1);
       {11}   setLength(cath4NodeDistrRes,HeapTop,cath4Nbr+1);
             end{if}
         else
          begin
        {1}   setLength(cath4DistortDistr,0);
        {2}   setLength(cath4IRnodeDistrArr,0,0);
        {3}   setLength(cath4DistortLeafDistribArr,0,0);
        {4}   setLength(sumCath4IRdistr,0);
        {5}   setLength(sumCath4RecErrDistr,0);
        {6}   setLength(Cath4NodesDistr,0);
        {7}   setLength(sumCath4DistortDistr,0);
        {8}   setLength(cath4DistortDistrRes,0,0);
        {9}   setLength(cath4IRDistrRes,0,0);
       {10}   setLength(cath4RecErrDistrRes,0,0);
       {11}   setLength(cath4NodeDistrRes,0,0);
          end;{check28}
     end
   End;{with form1}
  END;{DistributionsRAMresources}


  procedure ZeroDistrSum;
   var m:word;
   BEGIN
    with form1 do
     If form1.RadioGroup18.ItemIndex=1 then
      if not checkBox1.Checked then
       Begin
        if checkBox2.Checked then for m:=0 to cath1Nbr do
         begin
       {1}   cath1DistortDistr[m]:=0;
       {2}   sumCath1IRdistr[m]:=0;
       {3}   sumCath1RecErrDistr[m]:=0;
       {4}   Cath1NodesDistr[m]:=0;
       {5}   sumCath1DistortDistr[m]:=0;
       {6}   controlCath1DistortDistr:=0;
       {7}   cath1RecErrControlSum:=0;

         end;
        if checkBox3.Checked then for m:=0 to cath2Nbr do
         begin
        {1}  cath2DistortDistr[m]:=0;
        {2}  sumCath2IRdistr[m]:=0;
        {3}  sumCath2RecErrDistr[m]:=0;
        {4}  Cath2NodesDistr[m]:=0;
        {5}  sumCath2DistortDistr[m]:=0;
        {6}  controlCath2DistortDistr:=0;
        {7}  cath2RecErrControlSum:=0;
         end;
        if checkBox4.Checked then for m:=0 to cath3Nbr do
         begin
         {1} cath3DistortDistr[m]:=0;
         {2} sumCath3IRdistr[m]:=0;
         {3} sumCath3RecErrDistr[m]:=0;
         {4} Cath3NodesDistr[m]:=0;
         {5} sumCath3DistortDistr[m]:=0;
         {6} controlCath3DistortDistr:=0;
         {7} cath3RecErrControlSum:=0;
         end;
        if checkBox28.Checked then for m:=0 to cath4Nbr do
         begin
       {1}   cath4DistortDistr[m]:=0;
       {2}   sumCath4IRdistr[m]:=0;
       {3}   sumCath4RecErrDistr[m]:=0;
       {4}   Cath4NodesDistr[m]:=0;
       {5}   sumCath4DistortDistr[m]:=0;
       {6}   controlCath4DistortDistr:=0;
       {7}   cath4RecErrControlSum:=0;
         end
       End;{check1}
   END;{ZeroDistrSum}


   procedure DistribSums(const cathNbr,maxCath:byte; const cathRecErr:longWord; const cathIR:double;const nodeAddr:word;
                         var sumCathRecErrDistr:TSumCathRecErrDistr; var CathNodesDistr:TCathNodesDistr;
                         var sumCathIRdistr:TDbArr;var cathIRnodesDistrArr:TIRnodeDistr;
                         var sumCathDistortDistr:TDbArr;var cathDistortLeafDistribArr:TcathDistortLeafDistribArr;callChain:string);
(*
   calling for cath1: DistribSums(cath1Nbr,maxCath1,cath1RecErr,cath1IR,nodeAddr,sumCath1RecErrDistr,Cath1NodesDistr,sumCath1IRdistr,cath1IRnodeDistrArr,sumCath1DistortDistr,cath1DistortLeafDistribArr);

      procedure head: DistribSums(cathNbr; maxCath; cathRecErr; cathIR; nodeAddr;sumCathRecErrDistr; CathNodesDistr; sumCathIRdistr; cathIRnodesDistrArr;sumCathDistortDistr; cathDistortLeafDistribArr);

                                  byte     byte     longWord    double  word    TSumCathRecErrDistr TCathNodesDistr TDbArr          TIRnodeDistr        TDbArr               TcathDistortLeafDistribArr
*)
    var m:byte;
    Begin
     callChain:=callChain+'>DistribSums';
     If form1.RadioGroup18.ItemIndex=1 then
      begin
       inc(sumCathRecErrDistr[maxCath],cathRecErr); //contributions of recognition errors to overall recognition error (distribution of rec. err. over the cathegory 1 values)
       inc(CathNodesDistr[maxCath]);                  //histogram of nodes which recognizes the same cathegory over cathegory values
       for m:=0 to cathNbr do sumCathDistortDistr[m]:=sumCathDistortDistr[m]+cathDistortLeafDistribArr[nodeAddr,m];
       for m:=0 to cathNbr do sumCathIRdistr[m]:=sumCathIRdistr[m]+cathIRnodesDistrArr[nodeAddr,m];
      end;
    End; {DistribSums}

  procedure distrIRscaler(const step:word;callChain:shortString);
 {
 Averaging and scaling IR parameter distribution over cathegories values in actual tree leaves sets
 }
   function Scale(const sumCathIrDistr:TdbArr; const cathNbr:word; var cathIrControlSum:double;callChain:shortString):TdbArr;
   var m:word; cathIRcontrolSum0:double;
   begin
    callChain:=callChain+'>Scale';
    cathIRControlSum:=0;cathIRcontrolSum0:=0;
    for m:=1 to cathNbr do cathIRcontrolSum0:=cathIRcontrolSum+sumCathIrDistr[m];
    for m:=1 to cathNbr do
     begin
      sumCathIrDistr[m]:=sumCathIrDistr[m]/(ln2*(step+1));//cathH0[i]);
      cathIRcontrolSum:=cathIRcontrolSum+sumCathIrDistr[m];
     end;
    result:=sumCathIrDistr;
   end;{Scale}

    Begin
     callChain:=callChain+'>distrIRscaler';
     with form1 do
       If form1.RadioGroup18.ItemIndex=1 then
        if not checkBox1.Checked then      // t1:=cath1IRGlob/(step+1); this is IR value writen to report
        begin
        // cath1IRControlSum:=0; cath2IRControlSum:=0; cath3IRControlSum:=0; cath4IRControlSum:=0; procedure error65(s1, cathName:string; p1,p2:double;mult:integer);
         if checkBox2.Checked  then begin sumCath1IRdistr:=Scale(sumCath1IRdistr,cath1Nbr,cath1IRControlSum,callChain);
          error65('IR',Y1Name,cath1IRcontrolSum,cath1IRGlob/(step+1),32768,step,callChain) end;
         if checkBox3.Checked  then begin sumCath2IRdistr:=Scale(sumCath2IRdistr,cath2Nbr,cath2IRControlSum,callChain);
          error65('IR',Y2Name,cath2IRcontrolSum,cath2IRGlob/(step+1),32768,step,callChain) end;
         if checkBox4.Checked  then begin sumCath3IRdistr:=Scale(sumCath3IRdistr,cath3Nbr,cath3IRControlSum,callChain);
          error65('IR',Y3Name,cath3IRcontrolSum,cath3IRGlob/(step+1),32768,step,callChain) end;
         if checkBox28.Checked then begin sumCath4IRdistr:=Scale(sumCath4IRdistr,cath4Nbr,cath4IRControlSum,callChain);
          error65('IR',Y4Name,cath4IRcontrolSum,cath4IRGlob/(step+1),32768,step,callChain) end;
        end;{check1}
    End;{distrIRscaler}

  procedure MakeDistortionNodeDistributions(const nodeAddr:Word;centroid:TmeanVector;callChain:string);  //MDND
  //oblicz dystrybucje dystorsji nad wartociami kategorialnymi w wle
  //Make distributions of distortion over cahegories values in a node
   var i,m,n:longWord;   dist1:extended;

   procedure checkForError(callChain:shortString);
    var m:word;
    Begin
     callChain:=callChain+'>checkForError';
     with nodeProps[nodeAddr] do
      begin
       if n<> cardinal then  error50(n,cardinal,callChain);
       if form1.CheckBox2.Checked then
        begin
         dist1:=0;
         for m:=0 to cath1Nbr do dist1:=dist1+cath1DistortDistr[m];
         error65('Distortion',Y1Name,dist1/cardinal,meanDistance,10000,step,callChain);
        end;
       if form1.CheckBox3.Checked then
        begin
         dist1:=0;
         for m:=0 to cath2Nbr do dist1:=dist1+cath2DistortDistr[m];
         error65('Distortion',Y2Name,dist1/cardinal,meanDistance,10000,step,callChain);
        end;
       if form1.CheckBox4.Checked then
        begin
         dist1:=0;
         for m:=0 to cath3Nbr do dist1:=dist1+cath3DistortDistr[m];
         error65('Distortion',Y3Name,dist1/cardinal,meanDistance,10000,step,callChain);
        end;
       if form1.CheckBox28.Checked then
        begin
         dist1:=0;
         for m:=0 to cath4Nbr do dist1:=dist1+cath4DistortDistr[m];
         error65('Distortion',Y4Name,dist1/cardinal,meanDistance,10000,step,callChain)
       end;
      end
    End;{checkForError}
   var j : word;
  Begin  //---------------MakeDistortionNodeDistributions------------------
   callChain:=callChain+'>MakeDistortionNodeDistributions';
   if form1.CheckBox1.Checked then exit;  //no classification
   n:=0;
   for m:=0 to  cath1Nbr do if form1.CheckBox2.Checked  then cath1DistortDistr[m]:=0;
   for m:=0 to  cath2Nbr do if form1.CheckBox3.Checked  then cath2DistortDistr[m]:=0;
   for m:=0 to  cath3Nbr do if form1.CheckBox4.Checked  then cath3DistortDistr[m]:=0;
   for m:=0 to  cath4Nbr do if form1.CheckBox28.Checked then cath4DistortDistr[m]:=0;

   with nodeProps[nodeAddr] do  //a leaf set
   for i:=lb to hb do          //run over all events in a leaf set
      begin
       inc(n);
       for j:=0 to nc do if inMegaSet(j,featureMegaSet) then vi[j]:=vectList[sbl[i],j];  //choose an event
       dist1:=dist(centroid,vi);                                                         //compute its distance from a centroid
     //add the distance to the distances labeled by the  value of a cath#  which was ascribed to the choosen event during annotation
       if form1.CheckBox2.Checked then  cath1DistortDistr[cath1Hash[eventcath1[sbl[i]]]]:=cath1DistortDistr[cath1Hash[eventcath1[sbl[i]]]]+dist1;
       if form1.CheckBox3.Checked then  cath2DistortDistr[cath2Hash[eventcath2[sbl[i]]]]:=cath2DistortDistr[cath2Hash[eventcath2[sbl[i]]]]+dist1;
       if form1.CheckBox4.Checked then  cath3DistortDistr[cath3Hash[eventcath3[sbl[i]]]]:=cath3DistortDistr[cath3Hash[eventcath3[sbl[i]]]]+dist1;
       if form1.CheckBox28.Checked then cath4DistortDistr[cath4Hash[eventcath4[sbl[i]]]]:=cath4DistortDistr[cath4Hash[eventcath4[sbl[i]]]]+dist1;
      end;
     
    with nodeProps[nodeAddr] do
      begin
       if form1.CheckBox2.Checked  then for m:=0 to  cath1Nbr do cath1DistortLeafDistribArr[nodeAddr,m]:=cath1DistortDistr[m]; //save obtained distribution of a cathegory# values as a effect of overskimming the leaf node set
       if form1.CheckBox3.Checked  then for m:=0 to  cath2Nbr do cath2DistortLeafDistribArr[nodeAddr,m]:=cath2DistortDistr[m];
       if form1.CheckBox4.Checked  then for m:=0 to  cath3Nbr do cath3DistortLeafDistribArr[nodeAddr,m]:=cath3DistortDistr[m];
       if form1.CheckBox28.Checked then for m:=0 to  cath4Nbr do cath4DistortLeafDistribArr[nodeAddr,m]:=cath4DistortDistr[m];
      end;
   CheckForError(callChain);
  End;{MakeDistortionNodeDistributions}

 procedure saveStepDistributions(const step:word);
  var m:byte;
  Begin
   with form1 do       //save parameters distributions over trees leaves in arrays sumCath#(distortion|IR|recErrror)Distr     (zapisz krokowe dystrybucje dystrybucji dystorsji,IR, bdu rozpoznania w tablicach sumCath#(distortion|IR|recErrror)Distr )
     if RadioGroup18.ItemIndex=1 then
      begin
       if checkBox2.Checked  then
        begin
   {1}   cath1DistortDistrRes[step,0]:=distortion/TrueEventNbr;
   {2}   cath1IRDistrRes[step,0]:=cath1IrGlob/(step+1);
   {3}   cath1RecErrDistrRes[step,0]:=0;
   {4}   cath1NodeDistrRes[step,0]:=0;

         for m:=1 to cath1Nbr do
          BEGIN
    {1}    cath1DistortDistrRes[step,m]:=sumCath1DistortDistr[m]/TrueEventNbr;
    {2}    cath1IRDistrRes[step,m]:=sumCath1IRdistr[m];
    {3}    cath1RecErrDistrRes[step,m]:=sumCath1RecErrDistr[m]*percNorm_glob;
           cath1RecErrDistrRes[step,0]:=cath1RecErrDistrRes[step,0]+cath1RecErrDistrRes[step,m];
    {4}    cath1NodeDistrRes[step,m]:=Cath1NodesDistr[m];   //
           cath1NodeDistrRes[step,0]:=cath1NodeDistrRes[step,0]+Cath1NodesDistr[m];
          END;{for m}
        end;{if checkBox2}

       if checkBox3.Checked  then
        begin
         cath2DistortDistrRes[step,0]:=distortion/TrueEventNbr;
         cath2IRDistrRes[step,0]:=cath2IrGlob/(step+1);
         cath2RecErrDistrRes[step,0]:=0;
         cath2NodeDistrRes[step,0]:=0;

         for m:=1 to cath2Nbr do
          BEGIN
           cath2DistortDistrRes[step,m]:=sumCath2DistortDistr[m]/TrueEventNbr;
           cath2IRDistrRes[step,m]:=sumCath2IRdistr[m];
           cath2RecErrDistrRes[step,m]:=sumCath2RecErrDistr[m]*percNorm_glob;
           cath2RecErrDistrRes[step,0]:=cath2RecErrDistrRes[step,0]+cath2RecErrDistrRes[step,m];
           cath2NodeDistrRes[step,m]:=Cath2NodesDistr[m];
           cath2NodeDistrRes[step,0]:=cath2NodeDistrRes[step,0]+Cath2NodesDistr[m];
          END;{for m}
        end;{if checkBox3}

       if checkBox4.Checked  then
        begin
         cath3DistortDistrRes[step,0]:=distortion/TrueEventNbr;
         cath3IRDistrRes[step,0]:=cath3IrGlob/(step+1);
         cath3RecErrDistrRes[step,0]:=0;
         cath3NodeDistrRes[step,0]:=0;

         for m:=1 to cath3Nbr do
          BEGIN
           cath3DistortDistrRes[step,m]:=sumCath3DistortDistr[m]/TrueEventNbr;
           cath3IRDistrRes[step,m]:=sumCath3IRdistr[m];
           cath3RecErrDistrRes[step,m]:=sumCath3RecErrDistr[m]*percNorm_glob;
           cath3RecErrDistrRes[step,0]:=cath3RecErrDistrRes[step,0]+cath3RecErrDistrRes[step,m];
           cath3NodeDistrRes[step,m]:=Cath3NodesDistr[m];
           cath3NodeDistrRes[step,0]:=cath3NodeDistrRes[step,0]+Cath3NodesDistr[m];
          END;{for m}
        end;{if checkBox4}

       if checkBox28.Checked then
        begin
         cath4DistortDistrRes[step,0]:=distortion/TrueEventNbr;
         cath4IRDistrRes[step,0]:=cath4IrGlob/(step+1);
         cath4RecErrDistrRes[step,0]:=0;
         cath4NodeDistrRes[step,0]:=0;

         for m:=1 to cath4Nbr do
          BEGIN
           cath4DistortDistrRes[step,m]:=sumCath4DistortDistr[m]/TrueEventNbr;
           cath4IRDistrRes[step,m]:=sumCath4IRdistr[m];
           cath4RecErrDistrRes[step,m]:=sumCath4RecErrDistr[m]*percNorm_glob;
           cath4RecErrDistrRes[step,0]:=cath4RecErrDistrRes[step,0]+cath4RecErrDistrRes[step,m];
           cath4NodeDistrRes[step,m]:=Cath4NodesDistr[m];
           cath4NodeDistrRes[step,0]:=cath4NodeDistrRes[step,0]+Cath4NodesDistr[m];
          END;{for m}
        end;{if checkBox28}
      end;
  End;{saveStepDistributions}

 procedure  DistributionsTableToReport(const checkBoxChecked:boolean; const tableId,stepSum, parameter,YName:shortString;
                  const cathNbr:byte; groupNbr:word; const rowsArr:TresultsDistr; const cathCodeList: TcharList);
  procedure underline;
   var m:word;
   begin
    write(reportFile,'|====|');
    for m:=0 to cathNbr do write(reportFile,'==========|');  writeln(reportFile,'|');
   end;
  var i,m:word;
  BEGIN
  //Header-----------------------------
    with form1 do        //Top table 1. outline
    If RadioGroup18.ItemIndex=1 then    //totals and cathegories
     Begin
      if checkBoxChecked then
       begin
        writeln(reportFile,#13#10,tableId,'Distribution of the '+parameter+' over the "'+Yname+'" cathegory values as a function of centroids number (=step+1)');   //table title
        underline;                                                                                                     //table head, caption overline
        write(reportFile,'|Step|',stepSum:10,'|');                                                                    //cathegory values list
        for i:=1 to cathNbr do write(reportFile,'     ',cathCodeList[i],'    |');                                    //cathegory values list
        writeln(reportFile,'|');
        underline;                                                                                                  //table head, caption underline
        for i:=0 to groupNbr do   //----------------------------table inside ---------------------------------
         begin
          write(reportFile,'|',i:4,'|');
          for m:=0 to cathNbr do
           begin
            if round(rowsArr[i,m]*10e9) <> 0 then
             if round(rowsArr[i,m])<>rowsArr[i,m] then
              write(reportFile,floatTostrF(rowsArr[i,m],ffExponent,6,0),'|')
             else write(reportFile,round(rowsArr[i,m]):10,'|')
            else write(reportFile,0:10,'|');
           end;
          writeln(reportFile,'|');
          flush(reportFile);
         end;{i}
       underline;
      end;{checkBox}                                                                                                    //table underline
     End;{radio18}
  END;{ DistributionsTableToReport}

 end.





  (*
 procedure DistributionsRAMresources(const centroidsNb:word;callChain:shortString);
  BEGIN
   with form1 do
   Begin
    callChain:=callChain+'>DistributionsRAMresources';
    if not CheckBox1.Checked then  //no classifications
    If form1.RadioGroup18.ItemIndex=1 then
     Begin
        if CheckBox2.Checked then
         begin
      {1}    setLength(cath1DistortDistr,cath1Nbr+1);
      {4}    setLength(sumCath1IRdistr,cath1Nbr+1);
      {5}    setLength(sumCath1RecErrDistr,cath1Nbr+1);
      {6}    setLength(Cath1NodesDistr,cath1Nbr+1);
      {7}    setLength(sumCath1DistortDistr,cath1Nbr+1);
          if not((form1.RadioGroup12.ItemIndex=0) or form1.CheckBox42.Checked) then
            begin
      {2}    setLength(cath1IRnodeDistrArr,CentroidsNb_glob+1,cath1Nbr+1);         {nodeHeapTop}
      {3}    setLength(cath1DistortLeafDistribArr,CentroidsNb_glob+1,cath1Nbr+1);
      {8}    setLength(cath1DistortDistrRes,CentroidsNb_glob+1,cath1Nbr+1);
      {9}    setLength(cath1IRDistrRes,CentroidsNb_glob+1,cath1Nbr+1);
     {10}    setLength(cath1RecErrDistrRes,CentroidsNb_glob+1,cath1Nbr+1);
     {11}    setLength(cath1NodeDistrRes,CentroidsNb_glob+1,cath1Nbr+1);
            end{if}
          else
            begin
      {2}    setLength(cath1IRnodeDistrArr,2*CentroidsNb_glob+1,cath1Nbr+1);         {nodeHeapTop}
      {3}    setLength(cath1DistortLeafDistribArr,2*CentroidsNb_glob+1,cath1Nbr+1);
      {8}    setLength(cath1DistortDistrRes,2*CentroidsNb_glob+1,cath1Nbr+1);
      {9}    setLength(cath1IRDistrRes,2*CentroidsNb_glob+1,cath1Nbr+1);
     {10}    setLength(cath1RecErrDistrRes,2*CentroidsNb_glob+1,cath1Nbr+1);
     {11}    setLength(cath1NodeDistrRes,2*CentroidsNb_glob+1,cath1Nbr+1);
            end;{else if}
         end
        else
         begin
       {1}   setLength(cath1DistortDistr,0);
       {2}   setLength(cath1IRnodeDistrArr,0,0);
       {3}   setLength(cath1DistortLeafDistribArr,0,0);
       {4}   setLength(sumCath1IRdistr,0);
       {5}   setLength(sumCath1RecErrDistr,0);
       {6}   setLength(Cath1NodesDistr,0);
       {7}   setLength(sumCath1DistortDistr,0);
       {8}   setLength(cath1DistortDistrRes,0,0);
       {9}   setLength(cath1IRDistrRes,0,0);
      {10}   setLength(cath1RecErrDistrRes,0,0);
      {11}   setLength(cath1NodeDistrRes,0,0);
         end;{check2}

      if CheckBox3.Checked then
         begin
       {1}   setLength(cath2DistortDistr,cath2Nbr+1);
       {4}   setLength(sumCath2IRdistr,cath2Nbr+1);
       {5}   setLength(sumCath2RecErrDistr,cath2Nbr+1);
       {6}   setLength(Cath2NodesDistr,cath2Nbr+1);
       {7}   setLength(sumCath2DistortDistr,cath2Nbr+1);
           if not((form1.RadioGroup12.ItemIndex=0) or form1.CheckBox42.Checked) then
            begin
       {2}   setLength(cath2IRnodeDistrArr,CentroidsNb_glob+1,cath2Nbr+1);
       {3}   setLength(cath2DistortLeafDistribArr,CentroidsNb_glob+1,cath2Nbr+1);
       {8}   setLength(cath2DistortDistrRes,CentroidsNb_glob+1,cath2Nbr+1);
       {9}   setLength(cath2IRDistrRes,CentroidsNb_glob+1,cath2Nbr+1);
      {10}   setLength(cath2RecErrDistrRes,CentroidsNb_glob+1,cath2Nbr+1);
      {11}   setLength(cath2NodeDistrRes,CentroidsNb_glob+1,cath2Nbr+1);
            end{if}
           else
            begin
       {2}   setLength(cath2IRnodeDistrArr,2*CentroidsNb_glob+1,cath2Nbr+1);
       {3}   setLength(cath2DistortLeafDistribArr,2*CentroidsNb_glob+1,cath2Nbr+1);
       {8}   setLength(cath2DistortDistrRes,2*CentroidsNb_glob+1,cath2Nbr+1);
       {9}   setLength(cath2IRDistrRes,2*CentroidsNb_glob+1,cath2Nbr+1);
      {10}   setLength(cath2RecErrDistrRes,2*CentroidsNb_glob+1,cath2Nbr+1);
      {11}   setLength(cath2NodeDistrRes,2*CentroidsNb_glob+1,cath2Nbr+1);
            end;
         end{check3}
      else
       begin
       {1} setLength(cath2DistortDistr,0);
       {2} setLength(cath2IRnodeDistrArr,0,0);
       {3} setLength(cath2DistortLeafDistribArr,0,0);
       {4} setLength(sumCath2IRdistr,0);
       {5} setLength(sumCath2RecErrDistr,0);
       {6} setLength(Cath2NodesDistr,0);
       {7} setLength(sumCath2DistortDistr,0);
       {8} setLength(cath2DistortDistrRes,0,0);
       {9} setLength(cath2IRDistrRes,0,0);
      {10} setLength(cath2RecErrDistrRes,0,0);
      {11} setLength(cath2NodeDistrRes,0,0);
       end; {check3}

      if CheckBox4.Checked then
        begin
       {1}  setLength(cath3DistortDistr,cath3Nbr+1);
       {4}  setLength(sumCath3IRdistr,cath3Nbr+1);
       {5}  setLength(sumCath3RecErrDistr,cath3Nbr+1);
       {6}  setLength(Cath3NodesDistr,cath3Nbr+1);
       {7}  setLength(sumCath3DistortDistr,cath3Nbr+1);
          if not((form1.RadioGroup12.ItemIndex=0) or form1.CheckBox42.Checked) then
           begin
       {2}  setLength(cath3IRnodeDistrArr,CentroidsNb_glob+1,cath3Nbr+1);
       {3}  setLength(cath3DistortLeafDistribArr,CentroidsNb_glob+1,cath3Nbr+1);
       {8}  setLength(cath3DistortDistrRes,CentroidsNb_glob+1,cath3Nbr+1);
       {9}  setLength(cath3IRDistrRes,CentroidsNb_glob+1,cath3Nbr+1);
      {10}  setLength(cath3RecErrDistrRes,CentroidsNb_glob+1,cath3Nbr+1);
      {11}  setLength(cath3NodeDistrRes,CentroidsNb_glob+1,cath3Nbr+1);
           end {if}
          else
           begin
       {2}  setLength(cath3IRnodeDistrArr,2*CentroidsNb_glob+1,cath3Nbr+1);
       {3}  setLength(cath3DistortLeafDistribArr,2*CentroidsNb_glob+1,cath3Nbr+1);
       {8}  setLength(cath3DistortDistrRes,2*CentroidsNb_glob+1,cath3Nbr+1);
       {9}  setLength(cath3IRDistrRes,2*CentroidsNb_glob+1,cath3Nbr+1);
      {10}  setLength(cath3RecErrDistrRes,2*CentroidsNb_glob+1,cath3Nbr+1);
      {11}  setLength(cath3NodeDistrRes,2*CentroidsNb_glob+1,cath3Nbr+1);
           end;{else if}
        end
       else
        begin
       {1}  setLength(cath3DistortDistr,0);
       {2}  setLength(cath3IRnodeDistrArr,0,0);
       {3}  setLength(cath3DistortLeafDistribArr,0,0);
       {4}  setLength(sumCath3IRdistr,0);
       {5}  setLength(sumCath3RecErrDistr,0);
       {6}  setLength(Cath3NodesDistr,0);
       {7}  setLength(sumCath3DistortDistr,0);
       {8}  setLength(cath3DistortDistrRes,0,0);
       {9}  setLength(cath3IRDistrRes,0,0);
      {10}  setLength(cath3RecErrDistrRes,0,0);
      {11}  setLength(cath3NodeDistrRes,0,0);
        end;{check4}

        if CheckBox28.Checked then
          begin
        {1}   setLength(cath4DistortDistr,cath4Nbr+1);
        {4}   setLength(sumCath4IRdistr,cath4Nbr+1);
        {5}   setLength(sumCath4RecErrDistr,cath4Nbr+1);
        {6}   setLength(Cath4NodesDistr,cath4Nbr+1);
        {7}   setLength(sumCath4DistortDistr,cath4Nbr+1);
            if not((form1.RadioGroup12.ItemIndex=0) or form1.CheckBox42.Checked) then
             begin
        {2}   setLength(cath4IRnodeDistrArr,CentroidsNb_glob+1,cath4Nbr+1);
        {3}   setLength(cath4DistortLeafDistribArr,CentroidsNb_glob+1,cath4Nbr+1);
        {8}   setLength(cath4DistortDistrRes,CentroidsNb_glob+1,cath4Nbr+1);
        {9}   setLength(cath4IRDistrRes,CentroidsNb_glob+1,cath4Nbr+1);
       {10}   setLength(cath4RecErrDistrRes,CentroidsNb_glob+1,cath4Nbr+1);
       {11}   setLength(cath4NodeDistrRes,CentroidsNb_glob+1,cath4Nbr+1);
             end{if}
            else
             begin
        {2}   setLength(cath4IRnodeDistrArr,2*CentroidsNb_glob+1,cath4Nbr+1);
        {3}   setLength(cath4DistortLeafDistribArr,2*CentroidsNb_glob+1,cath4Nbr+1);
        {8}   setLength(cath4DistortDistrRes,2*CentroidsNb_glob+1,cath4Nbr+1);
        {9}   setLength(cath4IRDistrRes,2*CentroidsNb_glob+1,cath4Nbr+1);
       {10}   setLength(cath4RecErrDistrRes,2*CentroidsNb_glob+1,cath4Nbr+1);
       {11}   setLength(cath4NodeDistrRes,2*CentroidsNb_glob+1,cath4Nbr+1);
             end;{else if}
          end
         else
          begin
        {1}   setLength(cath4DistortDistr,0);
        {2}   setLength(cath4IRnodeDistrArr,0,0);
        {3}   setLength(cath4DistortLeafDistribArr,0,0);
        {4}   setLength(sumCath4IRdistr,0);
        {5}   setLength(sumCath4RecErrDistr,0);
        {6}   setLength(Cath4NodesDistr,0);
        {7}   setLength(sumCath4DistortDistr,0);
        {8}   setLength(cath4DistortDistrRes,0,0);
        {9}   setLength(cath4IRDistrRes,0,0);
       {10}   setLength(cath4RecErrDistrRes,0,0);
       {11}   setLength(cath4NodeDistrRes,0,0);
          end;{check28}
     End;{not CheckBox1 and form1.RadioGroup18.ItemIndex=1}
   End;{with form1}
  END;{DistributionsRAMresources}    *)

