unit Graffiti;


interface
uses unit1,types,ExtCtrls, Graphics, forms,coder;
 const
  psColor:longWord=clblue;
 psSmColor:longWord=clBlack;
 psMelColor:longWord=clRed;
 pcColor:longWord=clBlue;
 pcMelColor:longWord=clRed;
 var
  wspx1,wspy1, wspx2,wspy2, wspx3,wspy3, wspx4,wspy4,wspx5,wspy5,wspx6,wspy6 : double;   //wspczynniki proporcjonalnoci dla poszczeglnych paneli
  dataBlockLength : word;
procedure showDataRecords(const i:int64;const color1,color2:longint; const Range2,Range3,Range4:double; const s:shortString);
procedure showModifiedInput(meanVector:TmeanVector; const Range5:double);
implementation

 var
     centr2,centr3,centr4,centr5: integer;                                     //centra pionowe dla poszczeglnych paneli

  procedure frame(Pane:TPanel;canvas:tcanvas;const dataBlockLength:longWord; const Range:double;  out wspx,wspy:double; out centr:integer);
  //Wykrela ramki pokazujce pole wykresu
  //wspx,wspy - wspczynniki proporcjonalnoci dla okna
  //centr - rodek w pionie pola rysunku
  begin
   with Pane,canvas do
    begin
     centr:=round(top+height/2);
     wspy:=(height)/Range;
     wspx:=width/(dataBlockLength-1);
     Pen.Color:=clblack;                                           //------------------------------------a ten jest!
     Rectangle(left-2,top-2,left+Width+2, top+Height+2);
     Pen.Color:=clwhite;
     Rectangle(left-1,top-1,left+Width+2, top+Height+2);
     Pen.Color:=clgray;
     Rectangle(left,top,left+Width, top+Height);
     Pen.Color:=clwhite;
     Rectangle(left,top,left+Width, top+Height);
     Pen.Color:=clwhite;
     moveTo(left,centr);                                           //--------------------ten kolor nie jest aktywowany!
     lineTo(left+width,centr);
     moveTo(left,centr);
    end;
   application.processmessages;
  end;{frame}

  procedure OscDraw(panel:tpanel;canvas:tcanvas; const y:T255SmallIntArr; wspx,wspy : double; centr:integer;
  const count:longWord; const clear:boolean;const chartColor:longInt;const cepstr:boolean);
//---------------------oscylogram danych wave    var Yzero,wagi,xr,yi : rAryType;
var
      i : longWord;
      j : integer;
    label e1;
  begin if not form1.CheckBox1.Checked then exit;//poka grafik
   panel.Visible:=clear;
   panel.Visible:=false;
   with panel do
    begin
     j:=centr;
     if j<top then goto e1;
     if j>top+Height then goto e1;
     if cepstr then   //draw vertical line showing lifter treshold
      begin
       form1.Canvas.Pen.Color:=clwhite;
       form1.Canvas.moveTo(round(nc*wspx+left),top);
       form1.canvas.LineTo(round(nc*wspx+left),top+height);
      end;
     form1.Canvas.moveTo(left,centr);                                           //--------------------ten kolor nie jest aktywowany!
     form1.Canvas.lineTo(left+width,centr);
e1:  form1.Canvas.moveTo(left,centr);
     form1.Canvas.Pen.Color:=chartColor;
    end;
   application.processMessages;
   for i:=0 to count-1 do with Panel do
    begin
     j:=round(-y[i]*wspy+centr);
     if j<top then j:=top;
     if j>top+Height then j:=top+Height;
     canvas.LineTo(round(i*wspx+left),j);
     application.processMessages;                  //Uwaga! skasuje narysowany oscylogram, jeli wczeniej nie wywoano jeszcze processmessages
    end;{for}
  end;{OscDraw}

 procedure SpkDraw(panel:tpanel;canvas:tcanvas; const y:T128SmallIntArr; wspx,wspy:double; centr:integer;
  const count:longWord; const clear:boolean;const chartColor:longInt;const cpstr:boolean);
//---------------------wave data oscillogram (oscylogram danych wave    var Yzero,wagi,xr,yi : rAryType;)
var
    i : integer;
label e1;

 function jot(const i:longWord):integer;
  Begin
   with panel do
    begin
     result:=round(-y[i]*wspy+centr);
     if result<top then result:=top;
     if result>top+Height then result:=top+Height;
    end{with}
  End;

 procedure drawLine(const i:longWord);
   Begin
    with panel do canvas.LineTo(round(i*wspx+left),jot(i));          //Attention! clears drawed oscillogram if earlie was not called yet the processMessages
    application.processMessages;                  //Uwaga! skasuje narysowany oscylogram, jeli wczeniej nie wywoano jeszcze processmessages
   End;

  Begin
   if not form1.CheckBox1.Checked then exit;//show graphics
   panel.Visible:=clear;
   panel.Visible:=false;
   with panel do
    begin
     if centr<top then goto e1;
     if centr>top+Height then goto e1;
     if cpstr then
      begin
       form1.Canvas.Pen.Color:=clwhite;
       form1.Canvas.moveTo(round((nc-1)*wspx+left),top);
       form1.canvas.LineTo(round((nc-1)*wspx+left),top+height);
      end;
     form1.Canvas.moveTo(left,centr);                                           //--------------------this color is not activated! (ten kolor nie jest aktywowany!)
     form1.Canvas.lineTo(left+width,centr);
e1:  form1.Canvas.moveTo(left,jot(0));
     form1.Canvas.Pen.Color:=chartColor;
    end; {with}
   application.processMessages;   i:=count; i:=i-1;
   for i:=1 to i do
    with Panel do drawLine(i);
  End;{SpkDraw}



 procedure showInputRecord(const count:word; const Range2,Range3,Range4:double;const s:shortString); //high(word), 13, 64
  var count_cp:word;
  Begin
    with form1,inputRecord do
    begin
     count_cp:=count div 2;
     Frame(Panel2,canvas,count,Range2,wspx2,wspy2,centr2);
     Frame(Panel3,canvas,count_cp,Range3,wspx3,wspy3,centr3);
     Frame(Panel4,canvas,dataBlockLength,Range4,wspx4,wspy4,centr4);
     OscDraw(panel2,canvas,signal,wspx2,wspy2*1.5,centr2,count,false,clblue,false);                                     //waony oscylogram okienka
     SpkDraw(panel3,canvas,powerSpectr,wspx3,wspy3/950,centr3+round(panel3.Height/4.4),count_cp,true,psColor,false);      //wykres spektrum; centr+round(panel3.Height/1.75) - eksperymentalne obnienie wykresu dla neperw
     SpkDraw(panel3,canvas,smoothedSpectr,wspx3,wspy3/1600,centr3+round(panel3.Height/4.5),count_cp,false,psSmColor,false);//- odwrcone cepstrum - spektrum wygadzone
     SpkDraw(panel3,canvas,melSmoothSpectr,wspx3,wspy3/1000,centr3+round(panel3.Height/5.5),count_cp,false,psMelColor,false); //spektrum wygadzone po transformacji do meli
     SpkDraw(panel4,canvas,powerCepstr,wspx4,wspy4/512,centr4+round(panel4.Height/5.5),dataBlockLength,true,pcColor,true);                               //cepstrum mocy
     SpkDraw(panel4,canvas,melCepstr,wspx4,wspy4/512,centr4+round(panel4.Height/5.5),dataBlockLength,false,pcMelColor,true);                                //cepstrum mocy na melach
     if checkBox5.Checked then  with panel3,canvas do TextOut(Left,Top,s);
    end;
  End;{showInputRecord}

  procedure showDataRecords(const i:int64;const color1,color2:longint; const Range2,Range3,Range4:double; const s:shortString); //high(word), 13, 64
   var j:word;
   Begin
    if form1.CheckBox1.Checked then      //Show Input Records
     begin
      with form1 do
       begin
        if (i mod pctNb =0) and (pctNb>1) then  //pctNb - number of pictures in series on the screen (liczba obrazkw wywietlanych jeden po drugim)
         if form1.Canvas.Brush.Color=clwhite then form1.Canvas.Brush.Color:=color1 else  form1.Canvas.Brush.Color:=color2;  // 12639424   16777215
        j:=(i mod pctNb)*(panel2.width+8)+panelStep;
        panel2.left:=j;          //panels shift
        panel3.left:=j;
        panel4.left:=j;
      end;
      showInputRecord(count,Range2,Range3,Range4,s);
     end;
   End; {showDataRecords}

 var intVect : T128SmallIntArr;
 procedure showModifiedInput(meanVector:TmeanVector; const Range5:double);
 //wywietla dane po ojciu redniej czasowej i redni czasow
  var i:integer;
  Begin
   with form1 do
    begin
     panel1.Left:=panel4.Left;//przesuwaj si razem z panelem4; patrz Inputer, przesuw paneli (panels shift synchronized with the panel 4)
     for i:=0 to nc-1 do intVect[i]:=round(meanVector[i]);
     Frame(Panel1,canvas,dataBlockLength,Range5,wspx5,wspy5,centr5);  //krel poszerzone cepstrum
     SpkDraw(panel1,canvas,intVect,wspx5,wspy5/512,centr5+round(panel1.Height/5.5),nc,true,clblack,true);             //rednia czasowa
     for i:=0 to nc-1 do intVect[i]:=round(dataRecord.IntVect[i]);
     SpkDraw(panel1,canvas,intVect,wspx5,wspy5/512,centr5+round(panel1.Height/5.5),nc,false,clLime,true);   //po odjciu redniej czasowej
    end;
  End;{showModifiedInput}

Initialization
 psColor:=clblue;
 psSmColor:=clBlack;
 psMelColor:=clRed;
 pcColor:=clBlue;
 pcMelColor:=clRed;
 dataBlockLength:=count div 2;

end.
 procedure SpkDraw(panel:tpanel;canvas:tcanvas; const y:T128SmallIntArr; wspx,wspy:double; centr:integer;
  const count:longWord; const clear:boolean;const chartColor:longInt);

    procedure frame(Pane:TPanel;canvas:tcanvas;const dataBlockLength:longWord; const Range:double;  out wspx,wspy:double; out centr:integer);
