unit InputControl;

interface
uses extCtrls,stdCtrls,dialogs,coder,sysUtils,unit1;

 Type
 TcharArray = packed array[0..2*(parametersSize+1)-1] of char;
 var charArray : TcharArray;
implementation

 procedure error100;
 var s:string;
 begin
  s:='Error 100.'#13#10 +'Error probably caused by erronous data format.'#13#10+
  'Check whether following conditions for the file'#13#10+eventFileDir+#13#10'were fullfilled:'#13#10+
  'All introductory comments appearing at the beginning  will be skipped until the first integer value.'#13#10+
  'Each row contains description of one event: features vector and its classification according to values of three cathegorical variables.'#13#10+
  'Values of the cathegorical variables can be proceeded by any number of spaces and tabs; they will be skipped.'#13#10+
  'Remember! All cathegorical variable values can be encoded with ONLY ONE character!!'#13#10+
  'First integer number greater than 0 will be interpreted as number of events (eventNbr). Every trailing nonvisual'#13#10+
  'signs, spaces and other chars proceeding 0 (#48) will be skipped here.'#13#10+
  'Second one, in the next row, will be interpreted as number of vectors components  (nc).'#13#10+
  'Third one, in the next row, will be interpreted as  components values range.'#13#10+
  'Next row is the table header; cathegorical variable names are read from here.'#13#10+
  'First three column will be interpreted as cathegory, classyfing values (values of three dependent variables)'#13#10+
  'Next nc columns will be read as vectors components'#13#10+
  'Prepare data file with MS Excel and export it as a txt file to avoid unnecessary characters.'#13#10+
  'End of the error 100 description';
   ShowMessage(s);
   if fileExists(reportFileDir) then
    with TTextRec(reportFile) do if mode=fmOutput then
    begin writeln(reportFile,s); flush(reportFile) end;
 end;{error100}
     procedure spkInputFileParameters(var RadioGroup1,RadioGroup2,RadioGroup3:TRadioGroup;var label1,label2:Tlabel;checkBox1:TcheckBox);
  Begin                           //            10          9           11
   with inputRecord do                                                                     //dataRecord do
   begin
    if (signal[2]>=0) and (signal[2]<=4) then RadioGroup1.ItemIndex:=signal[2] else RadioGroup1.ItemIndex:=-1;  //filter
    if (signal[3]>=0) and (signal[3]<=1) then RadioGroup2.ItemIndex:=signal[3] else RadioGroup2.ItemIndex:=-1;  //filter-scaling const
    if (signal[7]>=0) and (signal[7]<=4) then RadioGroup3.ItemIndex:=signal[7] else RadioGroup3.ItemIndex:=-1;  //weighting windows shape
    if signal[11]<>1 then checkBox1.Checked:=false else checkBox1.Checked:=true;                                //preemphase
    label1.Caption:=intToStr(powerSpectr[1]);                                                                   //cepstrum filter cut-off
    label2.Caption:=intToStr(powerSpectr[0]);                                                                   //weighting window nbr
   end;//-----------------------------abs'y, aby czyta starsze wersje spektrw, gdzie to nie byo odnotowywane
  End; {spkInputFileParameters}

 procedure txtInputFileParameters(var RadioGroup1,RadioGroup2,RadioGroup3:TRadioGroup;var label1,label2:Tlabel;checkBox1:TcheckBox);
  Begin
   with inputRecord do          //dataRecord do
   begin
    RadioGroup1.ItemIndex:=-1;  //filter
    RadioGroup2.ItemIndex:=-1;  //filter-scaling const
    RadioGroup3.ItemIndex:=-1;  //weighting windows shape
    checkBox1.Checked:=false;   //preemphase
    checkBox1.State:=cbGrayed;  //preemphase
    label1.Caption:=xxx;        //cepstrum filter cut-off
    label2.Caption:=xxx;        //weighting window nbr
   end;
  End; {txtInputFileParameters}

 function realTypeRead(var vector:T128SmallIntArr; startRecording,realTypeSize:word;param:string):double;
  {
  for reading real values  rate and step from input file with integer components
  }
  var
  IntRealArr:array[0..3] of smallInt;
  k,l:byte;
  Begin
   k:=sizeOf(double) div 2;
   if k<>realTypeSize then
    begin
    ShowMessage('The realType size declaread in the Spectrum analyzer (='+intToStr(realTypeSize)+
     '), differs from the realType declaread here (='+intTostr(k)+
     ').'#13#10'The parameter'#13#10#13#10+param+#13#10#13#10'will be incorrectly read out.'+
     #13#10'This influences averaging parameters in the spectra or cepstra preprocessing consisted in time-constant'+
     ' contribution removal.'#13#10'You should set this parameter manually'+
     #13#10'The discrepancy can appear if you use analysis results from before march 2007,'+
     #13#10'which were recorded without sending this parameter...');
     result:=0;
     exit
    end;
   if startRecording>3+k+1 then
    begin
     ShowMessage('There is something wrong with reading of the start point of the '+param+
     '. You should set this parameter manually..(as well as the second)'); result:=0; exit
    end;
   for l:=0 to k-1 do IntRealArr[l]:=vector[l+startRecording];
   result:=double(IntRealArr);
  End;{realTypeRead}

 procedure spkDataParameters(var EventNbr:longWord; var eventFile:TeventFile; var cath1Nbr,cath2Nbr,cath3Nbr:byte;
  const RadioGroup10,RadioGroup9,RadioGroup11:Tradiogroup; var label86,label87:Tlabel; const checkBox28,checkBox30:TcheckBox; var frameStep, rate:realType);
  //              10           9            8                       37      38                        7          9 in VQCoder
  //reads the data parameters from the 0-th record of the data file
  var  i:byte;
  Begin
   read(eventFile,inputRecord);                                                                                    //dataRecord);
     with inputRecord do                                                                                           //dataRecord do
     begin
      EventNbr:=sliceNbr;   //form1.Edit15.Text:=intToStr(EventNbr);                                                //round(vect[0]);
      with form1.Edit1 do if not tryStrToInt(trim(Text),nc) then showMessage(Text+' is not an integer number!');   //nc:=round(vect[1]);
      //form1.edit8.Text:=intToStr(signal[0]);                                                                    //vect[3]); //Orig:=round(signal[0]);
      cath2Nbr:=byte(cath2);
      cath1Nbr:=byte(cath1);
      cath3Nbr:=byte(cath3);
      with form1 do spkInputFileParameters(RadioGroup10,RadioGroup9,RadioGroup11,label86,label87,checkBox28);
      frameStep:=realTypeRead(powerSpectr,3,powerSpectr[2],'STEP');
      rate:=realTypeRead(powerSpectr,3+powerSpectr[2]+1,powerSpectr[2],'RATE');
      charArray:=TcharArray(smoothedSpectr);
      if (charArray[0]=#0) or (charArray[0]>#255) then  waveFileDir:='Unknown'
      else for i:=1 to byte(chararray[0]) do waveFileDir:=chararray[i];
     (* writeln(reportFile,'Wave file "',waveFileDir,'"');
      with form1 do
      if checkBox30.Checked then                                             //check9
       begin
        Edit22.Text:=floatToStr(frameStep);  Edit23.Text:=floatToStr(rate);  //label 43,45
       end
      else
      begin
       Edit22.Text:=XXX;  Edit23.Text:=XXX;
      end; *)
     end;{with}
  End; {spkDataParameters}

 procedure txtDataParameters(var EventNbr:longWord; var txtEventFile : textFile);
 //reads the data parametersfrom of the *.txt file
  var s:shortString; c:integer;

  function name(var s:shortString;i:byte):shortString;
  //reads cath. variable names from header
   begin
    result:='';
    while  (s[1] in [#0..#32]) and (length(s)>0) do delete(s,1,1);
    while  not (s[1] in [#0..#32]) and (length(s)>0) do
     begin
      result:=result+s[1];
      delete(s,1,1);
     end;
    if result='' then result:='Y'+intToStr(i);
   end;

  Begin
   try
   repeat
   readln(txtEventFile,s);
   while  (s[1] in [#0..#47]) and (length(s)>0) do delete(s,1,1); //skip trailing nonvisual signs, spaces and other chars
   c:=pos(' ',s);
   val(copy(s,1,pos(' ',s)-1),eventNbr,c);
   if c<>0 then
    begin
    c:=pos(#9,s);
    val(copy(s,1,pos(#9,s)-1),eventNbr,c);
   end
   until c=0;                                                  //events data
   form1.Edit15.Text:=intToStr(EventNbr);
   readln(txtEventFile,nc,s);                                                //number of vectors components
   readln(txtEventFile,txtStretch,s);                                       //components values range
   readln(txtEventFile,s); //header
   except
    error100;
   end;

   y1Name:=name(s,1);  form1.edit30.Text:=y1Name;
   Y2Name:=name(s,2);  form1.edit31.Text:=y2Name;
   y3Name:=name(s,3);  form1.edit32.Text:=y3Name;
   YnameActualize;

   form1.Edit15.Text:=intToStr(EventNbr);
   with form1.Edit1 do text:=intToStr(nc);
   form1.edit8.Text:=xxx;                                               //FFT signal portions
   with form1 do txtInputFileParameters(RadioGroup10,RadioGroup9,RadioGroup11,label86,label87,checkBox28);
   AveragingTime:=100; frameNbr:=10; frameStep:=1; rate:=10000; multStdDev:=1; s:='';//we take here default values
   with form1.checkbox32 do begin Checked:=true; enabled:=false end;
   with form1 do
   if checkBox30.Checked then                 //remove time constant contribution
    begin
     Edit22.Text:=floatToStr(frameStep);      //floatToStr(frameStep);
     Edit23.Text:=floatToStr(rate);           //floatToStr(rate);
    end
   else
   begin
    Edit22.Text:=XXX;  Edit23.Text:=XXX;
   end;
   writeln(reportFile,'Wave file "',waveFileDir,'"');
  End; {txtDataParameters}


procedure spkInputer(out dataRecord:TdataRecord);
 //czyta cay rekord z wejcia i odpowiednio do opcji podstawia pod wyjcie jeden z wektorw parametrow
  var i:byte;
  Begin
   read(eventFile,InputRecord);
   with inputRecord,dataRecord do
    case form1.RadioGroup2.ItemIndex of   //events feature
     0: vect:=inputRecord.powerSpectr;
     1: vect:=inputRecord.smoothedSpectr;
     2: vect:=inputRecord.melSmoothSpectr;
     3: vect:=inputRecord.powerCepstr;
     4: vect:=inputRecord.melCepstr;
    end;{case}
   with inputRecord do
    begin
     dataRecord.cath1:=cath1;
     dataRecord.cath2:=cath2;
     dataRecord.cath3:=cath3;
     if form1.CheckBox13.Checked then showSpkInputRecord(cath2,cath1,cath3,256);
    end;{with}
    with dataRecord do    //oznaczy wartoci skrajne  dla kadej skadowej wektora cech niezalenie od tego, czy zostaa uyta, bd wogle okrelona
     for i:=0 to parametersSize do with minMax[i] do
      begin
       if vect[i]<min then min:=vect[i];
       if vect[i]>max then max:=vect[i];
      end;{for}
    if form1.CheckBox15.Checked then
     if
      application.MessageBox('Ok, to show next record, No to turn off stepwise reading','Stepwise reading',4)=idNo
     then
      begin
       form1.checkbox13.SetFocus;
       form1.CheckBox15.Checked:=false;
      end;
  End; {spkInputer}

procedure txtInputer(out dataRecord:TdataRecord);
 //czyta cay rekord z wejcia i odpowiednio do opcji podstawia pod wyjcie jeden z wektorw parametrow

 function skipper:char;
  begin
   repeat read(txtEventFile,result) until not (result in [#32,#9]); //(result<>' ') and  (result<>#9);
  end;

  var i:byte;
  Begin
   with dataRecord do
    begin
     try
      cath1:=skipper;
      cath2:=skipper;
      cath3:=skipper;
      for i:=0 to nc-1 do read(txtEventFile,vect[i]); readln(txtEventFile);
     except
      error100;
     end;
     if form1.CheckBox13.Checked then  showTxtInputRecord(cath2,cath1,cath3,txtStretch);
    end;{with}
   with dataRecord do   //oznaczy wartoci skrajne  dla kadej skadowej wektora cech niezalenie od tego, o ile jest okrelona
    for i:=0 to nc-1 do with minMax[i] do
     begin
      if vect[i]<min then min:=vect[i];
      if vect[i]>max then max:=vect[i];
     end;{for}
   if form1.CheckBox15.Checked then
    if
     application.MessageBox('Ok, to show next record, No to turn off stepwise reading','Stepwise reading',4)=idNo
    then
     begin
      form1.checkbox13.SetFocus;
      form1.CheckBox15.Checked:=false;
     end;
  End; {txtInputer}


    procedure OscDraw(panel:tpanel;canvas:tcanvas; const y:array of smallInt; wspx,wspy : double; centr:integer;
  const count:longWord; const clear:boolean;const chartColor:longInt; const cath2,cath1,cath3:char);
//---------------------oscylogram danych wave    var Yzero,wagi,xr,yi : rAryType;
var
      i : longWord;
      j : integer;
    label e1;
  begin if not form1.CheckBox13.Checked then exit;//poka grafik
   panel.Visible:=clear;
   panel.Visible:=false;
   with panel do
    begin
     j:=centr;
     if j<top then goto e1;
     if j>top+Height then goto e1;
     form1.Canvas.Pen.Color:=clwhite;
     form1.Canvas.moveTo(round(nc*wspx+left),top);
     form1.canvas.LineTo(round(nc*wspx+left),top+height);
     form1.Canvas.TextOut(left+width-35,top-25,'           ');
     form1.Canvas.TextOut(left+width-35,top-25,cath1+', '+cath2+', '+cath3);
     form1.Canvas.moveTo(left,centr);                                           //--------------------ten kolor nie jest aktywowany!
     form1.Canvas.lineTo(left+width,centr);
e1:  form1.Canvas.moveTo(left,centr);
     form1.Canvas.Pen.Color:=chartColor;
    end;
   application.processMessages;
   for i:=0 to count-1 do with Panel do
    begin
     j:=round(-y[i]*wspy+centr);
     if j<top then j:=top;
     if j>top+Height then j:=top+Height;
     canvas.LineTo(round(i*wspx+left),j);
     application.processMessages;                  //Uwaga! skasuje narysowany oscylogram, jeli wczeniej nie wywoano jeszcze processmessages
    end;{for}
  end;{OscDraw}

   frame(Pane:TPanel;canvas:tcanvas;const dataBlockLength:longWord; const stretch:double;  out wspx,wspy:double; out centr:integer);
  //Wykrela ramki pokazujce pole wykresu
  //wspx,wspy - wspczynniki proporcjonalnoci dla okna
  //centr - rodek w pionie pola rysunku
  var leftWidth,topHeight:integer;
  begin
   with Pane,canvas do
    begin
     leftWidth:=left+Width;   topHeight:=top+Height;
     centr:=round(top+height/2);
     wspy:=(height)/stretch;
     wspx:=width/dataBlockLength;
     Pen.Color:=clblack;                                           //------------------------------------a ten jest!
     Rectangle(left-10,top-10,leftWidth+10, topHeight+10); Application.ProcessMessages;
     Pen.Color:=clwhite;
     Rectangle(left-8,top-8,leftWidth+9, topHeight+9);     Application.ProcessMessages;
     Pen.Color:=clgray;
     Rectangle(left-2,top-2,leftWidth+2, topHeight+2);     Application.ProcessMessages;
     Pen.Color:=clwhite;
     Rectangle(left,top,leftWidth, topHeight);             Application.ProcessMessages;
     Pen.Color:=clwhite;
     moveTo(left,centr);                                           //--------------------ten kolor nie jest aktywowany!
     lineTo(left+width,centr);                             Application.ProcessMessages;
     moveTo(left,centr);                                   Application.ProcessMessages;
    end;
   application.processMessages;
  end;{frame}

   procedure showTxtInputRecord(const cath2,cath1,cath3:char;const txtStretch:smallInt);
  var  i:byte;
  Begin
    with form1,dataRecord do
   begin
    Frame(Panel2,canvas,nc-1,2*txtStretch,wspx2,wspy2,centr2);
    OscDraw(panel2,canvas,vect,wspx2,wspy2,centr2,nc,false,clblue,cath2,cath1,cath3);                                     //waony oscylogram okienka
   end;
  End;{showTxtInputRecord}

end.
